/*
*********************************************************************
**
** Copyright (C) jjsa 1999-2000  All Rights Reserved  Confidential
**
*********************************************************************
*/

static char xwChoice_Vxc[] = "@(#)xwChoice.c V1.03 2000-MAI-27/jjsa";
/*
 *********************************************************************
 *
 *  MODULE:      xwChoice
 *
 *  CONTENTS:
 *
 *  FUNCTION:   A simple choice box for installing of the
 *              xw_tools
 *
 *  CREATION:   jjsa 08.AUG.1999
 *
 *  CHANGES:    jjsa 04.JAN.2000 deleted <Return> and <Tab> from text 
 *                               widget input. <Space> conditional
 *                               opt -input no Space allowed,
 *                                   -Input Space allowed
 *                               opt -deny for text input added
 *              jjsa 20.FEB.2000 opt -defChoice added
 *              jjsa 29.APR-2000 added handling from keyboard
 *              jjsa 07.MAI-2000 focus change on mouse event better handled
 *              jjsa 19-MAI-2000 Added file viewer (-log ok file)
 *              jjsa 27-MAI-2000 Added file viewer (-tail ok file)
 *                               review of handling of scrolled list
 *
 *********************************************************************
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <errno.h>
#include <sys/stat.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <X11/keysym.h>

#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Text.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/Porthole.h>
#include <X11/Xaw/Viewport.h>

typedef struct choice_s
{
   char **text;
   char **ret;
   int    count;
} choice_t;

choice_t  choice    = { NULL, NULL, 0 };
char     *title     = NULL;
char     *help      = NULL;
char     *helpFile  = NULL;
char     *cancel    = NULL;  
char     *cancelRet = NULL;
char     *ok        = "OK";
char     *helpOK    = "OK";
char     *log       = NULL;
char     *tail      = NULL;
char     *question  = NULL;
char     *error     = NULL;
char     *errFile   = NULL;
char     *message   = NULL;
char     *Wait      = NULL;
char     *columnsT  = NULL;
char     *linesT    = "10";
int       lines;

int       input     = 0;
int       Input     = 0;
int       both      = 0;
int       noReturn  = 0;
char     *defChoice = NULL;

Widget    mf;
Widget    tlb;
Widget    list;
Widget    quest;
Widget    cancelB;
Widget    helpB;
Widget    okB;
Widget    helpW;
Widget    helpM;
Widget    inText;
Widget    vp;

Widget    selectedWidget;

char      geoBuf[100];
Pixel     white, darkblue, grey, red, dgrey;
Dimension viewPortHeight = 0xffff;
XtAppContext appContext;

Widget   toplevel;
Widget   hlplevel;

char    *display  = ":0.0";
char    *geometry =  NULL;

String textTranslation = {
   "<Key>Return: \n<Key>Tab: \n<Key>\\ : "
};
String textTranslationSpc = {
   "<Key>Return: \n<Key>Tab: "
};
char *denyChars = NULL;

String buttonTranslation = {
   "<Key>Return:  set() notify() unset()\n"
   "<KeyUp>Tab: highlight()\n<KeyDown>Tab: unhighlight() "
};

String buttonTranslationLog = {
   "<Key>Return:  set() notify() unset()\n"
};


Widget widgetTab[20];
int    tabCount;
                     
void setFocus_CB(Widget w, XtPointer closure, XEvent *event, Boolean *contDisp);
void ListSel_CB(Widget w, XtPointer closure, XEvent *event, Boolean *contDisp);

#define IF_OPT(a,b)  if (  strcmp(*argv, a) ==  0 )\
                      {\
                         argc--;\
                         argv++;\
                         if ( argc )\
                         {\
                            b = *argv;\
                            argc--;\
                            argv++;\
                         }\
                         else\
                         {\
                            exit(1);\
                         }\
                      }

#define IF_OPTC(a,b)  if (  strcmp(*argv, a) ==  0 ) \
                       {\
                         argc--;\
                         argv++;\
                         if ( argc > 1 )\
                         {\
                            addChoice(argv);\
                            argc -= 2;\
                            argv += 2;\
                         }\
                         else\
                         {\
                            exit(1);\
                         }\
                       }

#define IF_OPTB(a,b,c)  if (  strcmp(*argv, a) ==  0 ) \
                        {\
                         argc--;\
                         argv++;\
                         if ( argc > 1 )\
                         {\
                            b = *argv; \
                            argv++; \
                            c = *argv; \
                            argv++;\
                            argc -= 2;\
                         }\
                         else\
                         {\
                            exit(1);\
                         }\
                       }

                       
#define IF_OPTH(a,b,c,d)  if (  strcmp(*argv, a) ==  0 ) \
                        {\
                         argc--;\
                         argv++;\
                         if ( argc > 2 )\
                         {\
                            b = *argv; \
                            argv++; \
                            c = *argv; \
                            argv++;\
                            d = *argv; \
                            argv++;\
                           argc -= 3;\
                         }\
                         else\
                         {\
                            exit(1);\
                         }\
                       }

#define IF_OPT1(a,b)  if (  strcmp(*argv, a) ==  0 ) \
                        {\
                         argc--;\
                         argv++;\
                         b = 1; \
                       }

/*  
 ********************************************************************* 
 *  +++fhb  
 *  
 *  NAME:       void prtText
 *  
 *  FUNCTION:   append text into log widget if there is an input
 *  
 *  INPUT:      Widegt w 
 *  
 *  REMARKS:    
 *  
 *  +++fhe  
 *********************************************************************  
*/

void prtText(XtPointer closure, int *source, XtInputId *id)
{
   char           buffer[1024];
   XawTextBlock   tB;
   static char   *text = NULL;
   static int     got  = 0;
   static int     size = 0;
   if ( text == NULL )
   {
      text = (char *)calloc(1,1);
   }
   if ( (got = read(*source, buffer, sizeof(buffer)-1)) > 0)
   {
      buffer[got] = 0;
      //text = realloc(text, size+got+1);
      //text[size+got] = 0;
      //strcpy(text+size,buffer);
      XtVaSetValues(inText,
        	    XtNresizable, False,
        	    XtNeditType, XawtextAppend,
                    NULL);
      tB.firstPos = 0;
      tB.length   = got;
      tB.ptr	  = buffer;
      tB.format   = 0;
      size += got;
      XawTextSetInsertionPoint(inText,size);
      XawTextReplace(inText, size+1, size+got+1,&tB);
      XawTextSetInsertionPoint(inText,size);
      XtVaSetValues(inText,
        	    XtNresizable, False,
        	    XtNeditType, XawtextRead,
                    NULL);
   }
}

/*  
 ********************************************************************* 
 *  +++fhb  
 *  
 *  NAME:       void setFocusToButton
 *  
 *  FUNCTION:   set the focus to the passed button
 *  
 *  INPUT:      Widegt w 
 *  
 *  REMARKS:    
 *  
 *  +++fhe  
 *********************************************************************  
*/

void setFocusToButton(Widget w)
{
   XEvent ev;
   
   XtVaSetValues(w, XtNhighlightThickness, 2, NULL);

   memset(&ev, 0,sizeof(ev));
   ev.xcrossing.type = EnterNotify;
   ev.xcrossing.display = XtDisplay(w);
   ev.xcrossing.window  = XtWindow(w);
   ev.xcrossing.subwindow  = 0;
   ev.xcrossing.send_event = True;
   ev.xcrossing.x = 1;
   ev.xcrossing.y = 1;
   ev.xcrossing.x_root = 0;
   ev.xcrossing.y_root = 0;
   ev.xcrossing.mode = NotifyNormal;
   XSendEvent(XtDisplay(w), XtWindow(w), True, EnterWindowMask, &ev);
}

/*  
 ********************************************************************* 
 *  +++fhb  
 *  
 *  NAME:       void addChoice
 *  
 *  FUNCTION:   fill the struct for the presented choices
 *  
 *  INPUT:      char *argv[] 
 *  
 *  REMARKS:    *argv[] must contain 2 values
 *  
 *  +++fhe  
 *********************************************************************  
*/

void addChoice(char *argv[])
{

   if ( choice.count == 0 )
   {
      choice.text = (char**)malloc(sizeof(char**)*2);
      choice.ret  = (char**)malloc(sizeof(char**)*2);
   }
   else
   {
      choice.text = (char**)realloc(choice.text,
                                    sizeof(char**) * (choice.count+2));
      choice.ret  = (char**)realloc(choice.ret ,
                                    sizeof(char**) * (choice.count+2));
     
   }
   if ( choice.text == NULL || choice.ret == NULL )
   {
      fprintf(stderr,"can't alloc memory\n");
      exit(1);
   }
   choice.text[choice.count] = argv[0];
   if ( argv[1][0] == '\0' )
   {
      choice.ret[choice.count] = argv[0];
   }
   else
   {
      choice.ret[choice.count] = argv[1];
   }
   choice.count++;
   choice.text[choice.count] = NULL;
   choice.ret[choice.count]  = NULL;
}

/*  
 ********************************************************************* 
 *  +++fhb  
 *  
 *  NAME:       void cancelCB
 *  
 *  FUNCTION:   print cancel string and return
 *  
 *  INPUT:      
 *  
 *  REMARKS:    
 *  
 *  +++fhe  
 *********************************************************************  
*/

void cancelCB(Widget widget, XtPointer clientData, XtPointer callData)
{
   if ( cancelRet && *cancelRet )
      printf("%s\n",cancelRet);
   exit(3);
}

/*  
 ********************************************************************* 
 *  +++fhb  
 *  
 *  NAME:       void endHelpCB
 *  
 *  FUNCTION:   unmap help window
 *  
 *  INPUT:      
 *  
 *  REMARKS:    
 *  
 *  +++fhe  
 *********************************************************************  
*/

void endHelpCB(Widget widget, XtPointer clientData, XtPointer callData)
{
   XtUnmapWidget(hlplevel);
}

/*  
 ********************************************************************* 
 *  +++fhb  
 *  
 *  NAME:       void HelpCB
 *  
 *  FUNCTION:   build help window or map it if allready created
 *  
 *  INPUT:      
 *  
 *  REMARKS:    
 *  
 *  +++fhe  
 *********************************************************************  
*/

void helpCB(Widget widget, XtPointer clientData, XtPointer callData)
{
   FILE *fp;
   char *buf;
   struct stat stat;
   Arg    args[100];
   int    n;
   Dimension w = 0, h1=0,h2=0;
   char  *geo = NULL;
   Widget wid;

   if ( hlplevel )
   {
      XtMapWidget(hlplevel);
      return;
   }
   if ( helpFile && (fp = fopen(helpFile,"r")) )
   {
      /* create a new window an print the message */
      /* we use a dialog window                   */
      fstat(fileno(fp),&stat);
      buf = (char*)malloc(stat.st_size);
      if ( buf )
      {
         fread(buf, stat.st_size, 1,fp);
      }
      fclose(fp);
   }
   else
   {
      char *s, *t;
      buf = helpFile;
      t = s = buf;
      while(*s)
      {
         if ( *s == '\\' && s[1] == 'n' )
         {
            *t++ = '\n';
            s += 2;
         }
         else
            *t++ = *s++;
      }
      *t = '\0';     
   }
   {
      n = 0;
      if ( geometry )
      {
         XtSetArg(args[n],XtNgeometry, geometry);n++;
      }
      if ( title )
      {
          XtSetArg(args[n],XtNtitle, title);n++;
      }
      hlplevel = XtAppCreateShell("help", "Help",
                                  transientShellWidgetClass,
                                  XtDisplay(toplevel),
                                  args,
                                  n);           
      n = 0;
      XtSetArg(args[n], XtNbackground, grey); n++;
      helpW = XtCreateManagedWidget("Help",
                                   formWidgetClass,
                                   hlplevel,args,n);
      
      n = 0;
      XtSetArg(args[n], XtNbackground, grey); n++;
      XtSetArg(args[n],XtNlabel, buf);n++;
      helpM = XtCreateManagedWidget("Help",
                                   labelWidgetClass,
                                   helpW,args,n);

      n = 0;
      XtSetArg(args[n], XtNfromVert, helpM); n++;
      wid = XtCreateManagedWidget("end",commandWidgetClass,helpW, args,n);
/*
      XtSetKeyboardFocus( hlplevel, wid);
      XtCallAcceptFocus(wid,CurrentTime);
*/
      XtRealizeWidget(hlplevel);

      /* the window is realized now but we need info's */
      /* so we sync and flush the X server             */
      XFlush(XtDisplay(hlplevel));
      XSync(XtDisplay(hlplevel), False);
      XFlush(XtDisplay(hlplevel));
      XtVaGetValues(helpW,
                    XtNwidth, &w,
                    XtNheight, &h1,
                    NULL);

      /* in order to create the widget properly we must */
      /* unrealize the shell                            */
      
      XtUnrealizeWidget(hlplevel);
      XtDestroyWidget(wid);

#ifdef XAW3D
      w -= 7;
#else      
      w -= 10;
#endif
      n = 0;
      XtSetArg(args[n],XtNwidth, w);n++;
      XtSetArg(args[n],XtNlabel, helpOK);n++;
      XtSetArg(args[n], XtNbackground, grey); n++;
      XtSetArg(args[n], XtNfromVert, helpM); n++;
      wid = XtCreateManagedWidget("end",commandWidgetClass,helpW, args,n);
      XtAddCallback( wid, XtNcallback, endHelpCB, NULL);

      XtOverrideTranslations(wid,
                             XtParseTranslationTable(buttonTranslation));
      XtSetKeyboardFocus(helpW,wid);
      XtRealizeWidget(hlplevel);

      /* we have to resize the shell so we set the min and max */
      /* width and height                                      */
#ifdef XAW3D
      w = w + 7;
#else
      w = w + 10;
#endif
      n = 0;
      XtSetArg(args[n],XtNminHeight, h1);n++;
      XtSetArg(args[n],XtNmaxHeight, h1);n++;
      XtSetArg(args[n],XtNminWidth, w);n++;
      XtSetArg(args[n],XtNmaxWidth, w);n++;
      XtSetValues(hlplevel, args,n);

   }
}

/*  
 ********************************************************************* 
 *  +++fhb  
 *  
 *  NAME:       void endErrorCB
 *  
 *  FUNCTION:   exit
 *  
 *  INPUT:      
 *  
 *  REMARKS:    
 *  
 *  +++fhe  
 *********************************************************************  
*/

void endErrorCB(Widget widget, XtPointer clientData, XtPointer callData)
{
   exit(0);
}

/*  
 ********************************************************************* 
 *  +++fhb  
 *  
 *  NAME:       void showError
 *  
 *  FUNCTION:   exit
 *  
 *  INPUT:      
 *  
 *  REMARKS:    
 *  
 *  +++fhe  
 *********************************************************************  
*/

void showError()
{
   FILE *fp;
   char *buf;
   struct stat stat;
   Arg    args[100];
   int    n;
   Dimension w1 = 0, w2 = 0, h1 = 0, h2 = 0;
   char  *geo = NULL;
   int    len;
   int    totalLen;
   int    bufSize;
   Widget wid;

   if ( errFile )
   {
      if ( (fp = fopen(errFile,"r")) )
      {
         fstat(fileno(fp),&stat);
         buf = (char*)malloc(stat.st_size+1);
         if ( buf )
         {
            fread(buf, stat.st_size, 1,fp);
            buf[stat.st_size] = '\0';
         }
         fclose(fp);
      }
      else
      {
         char *s, *t;
         buf = errFile;
         t = s = buf;
         while(*s)
         {
            if ( *s == '\\' && s[1] == 'n' )
            {
               *t++ = '\n';
               s += 2;
            }
            else
               *t++ = *s++;
         }
         *t = '\0';
      }

      n = 0;
      XtSetArg(args[n],XtNbackground, grey);n++;
      helpW = XtCreateManagedWidget("Help",
                                   formWidgetClass,
                                   toplevel,args,n);
      n = 0;
      XtSetArg(args[n],XtNbackground, grey);n++;
      XtSetArg(args[n],XtNborderColor, grey);n++;
      if ( error )
      {
         XtSetArg(args[n],XtNforeground, red);n++;
      }
      XtSetArg(args[n],XtNlabel, buf);n++;
      helpM = XtCreateManagedWidget("HelpM",
                                   labelWidgetClass,
                                   helpW,args,n);

      n = 0;
      XtSetArg(args[n],XtNfromVert,helpM);n++;
      wid = XtCreateManagedWidget("tmp",commandWidgetClass,helpW,args,n);

      XtRealizeWidget(toplevel);
      XtUnrealizeWidget(toplevel);

      XtDestroyWidget(wid);

      XFlush(XtDisplay(toplevel));
      XSync(XtDisplay(toplevel), False);
      XFlush(XtDisplay(toplevel));

      XtVaGetValues(helpW,
                    XtNwidth,  &w1,
                    XtNheight, &h1,
                    NULL);

#ifdef XAW3D
      w1 -= 7;
#else      
      w1 -= 10;
#endif
      n = 0;
      XtSetArg(args[n],XtNwidth, w1);n++;
      if ( error )
      {
         XtSetArg(args[n],XtNlabel, error);n++;
      }
      else
      {
         if ( message == NULL )
            message = Wait;
         XtSetArg(args[n],XtNlabel, message);n++;
      }
      XtSetArg(args[n],XtNbackground, grey);n++;
      XtSetArg(args[n],XtNfromVert, helpM);n++;
      wid = XtCreateManagedWidget("end",commandWidgetClass,helpW, args,n);
      XtAddCallback( wid, XtNcallback, endErrorCB, NULL);
      XtOverrideTranslations(wid,
                             XtParseTranslationTable(buttonTranslation));

      /* we have to resize the shell so we set the min and max */
      /* width and height                                      */
      XtRealizeWidget(toplevel);
      XtUnrealizeWidget(toplevel);

      XFlush(XtDisplay(toplevel));
      XSync(XtDisplay(toplevel), False);
      XFlush(XtDisplay(toplevel));

#ifdef XAW3D
      w1 = w1 + 7;
#else
      w1 = w1 + 10;
#endif
      n = 0;
      XtSetArg(args[n],XtNminHeight, h1);n++;
      XtSetArg(args[n],XtNmaxHeight, h1);n++;
      XtSetArg(args[n],XtNminWidth,  w1);n++;
      XtSetArg(args[n],XtNmaxWidth,  w1);n++;
      XtSetArg(args[n],XtNtitle,     title);n++;
      /* get witdh and height from display, calculate position */
      if ( geometry == NULL )
      {
         h2 = DisplayHeight(XtDisplay(toplevel),0);
         w2 = DisplayWidth(XtDisplay(toplevel),0);
         sprintf(geoBuf,"+%d+%d", (w2-w1)/2,(h2-h1)/2);
         XtSetArg(args[n], XtNgeometry,  geoBuf); n++;
         geometry = geoBuf;
      }
      else
      {
         XtSetArg(args[n],XtNgeometry, geometry);n++;
      }
      XtSetValues(toplevel, args,n);

   }
   XtRealizeWidget(toplevel);
   XtSetKeyboardFocus( toplevel, wid);
   XtCallAcceptFocus(wid,CurrentTime);
   setFocusToButton(wid);
}

/*  
 ********************************************************************* 
 *  +++fhb  
 *  
 *  NAME:       void setFocus_CB
 *  
 *  FUNCTION:   select widget with Focus onm TAB SHIFT+TAB
 *  
 *  INPUT:      
 *  
 *  REMARKS:    
 *  
 *  +++fhe  
 *********************************************************************  
*/

void setFocus_CB(Widget w, XtPointer closure, XEvent *event, Boolean *contDisp)
{
   KeySym     key;
   Modifiers *modifiers=NULL;
   Widget     netxWidget;
   int        i;
   Boolean    res;
   XawListReturnStruct *selection;

   *contDisp = True;
   if ( event->xany.type == KeyPress || event->xany.type == KeyRelease )
   {
      key = XtGetActionKeysym(event, modifiers);

      /* check wich widget will be the next*/
      if ( (key == XK_Tab || key == XK_ISO_Left_Tab ) &&
           event->xkey.type == KeyPress )
      {
         for ( i = 0; i < tabCount; i++ )
         {
            if ( widgetTab[i] == w )
            {
               if ( key == XK_Tab )
               {
                  if ( i == (tabCount - 1) )
                    i = 0;
                  else
                    i++;
               }
               else
               {
                  if ( i > 0 )
                  {
                     i--;
                  }
                  else
                  {
                     i = tabCount - 1;
                  }
               }
               break;
            }
         }
      }
      else
      {
         return;
      }
   }
   else if ( event->xany.type == ButtonRelease ||
            (event->xany.type == ButtonPress && w == inText )
           )
   {
      for ( i = 0; i < tabCount; i++ )
      {
         if ( widgetTab[i] == w )
         {
            XtSetKeyboardFocus( toplevel, widgetTab[i]);
            res = XtCallAcceptFocus(widgetTab[i],CurrentTime);
            break;
         }
      }
      if ( i == tabCount )
         return;
   }
   else if ( event->xany.type == ConfigureNotify )
   {
      for ( i = 0; i < tabCount; i++ )
      {
         if ( widgetTab[i] == list )
         {
            Position y;
            if ( vp )
               XtVaSetValues(vp, XtNborderColor, darkblue, NULL);
            else
               XtVaSetValues(list, XtNborderColor, darkblue, NULL);
            selectedWidget =  list;
            XtSetKeyboardFocus( toplevel, list);
            res = XtCallAcceptFocus(list,CurrentTime);
            XtVaGetValues(list,XtNy,&y,NULL);
            return;
         }
      }
   }
   else
   {
      return;
   }

   if (widgetTab[i])
   {
      XtSetKeyboardFocus( toplevel, widgetTab[i]);
      res = XtCallAcceptFocus(widgetTab[i],CurrentTime);

      if ( widgetTab[i] == list)
      {
         if ( vp )
            XtVaSetValues(vp, XtNborderColor, darkblue, NULL);
         else
            XtVaSetValues(list, XtNborderColor, darkblue, NULL);
      }
      else if ( list != NULL  )
      {
         if ( vp )
            XtVaSetValues(vp, XtNborderColor, dgrey, NULL);
         else
            XtVaSetValues(list, XtNborderColor, dgrey, NULL);
      }
 
      if ( widgetTab[i] == inText )
      {
         XtVaSetValues(inText, XtNborderColor, darkblue, NULL);
      }
      else if ( inText != NULL )
      {
         XtVaSetValues(inText, XtNborderColor, dgrey, NULL);
      }

      if ( widgetTab[i] == cancelB )
      {
         XtVaSetValues(cancelB, XtNhighlightThickness, 2, NULL);
      }
      else if ( cancelB != NULL )
      {
         XtVaSetValues(cancelB, XtNhighlightThickness, 0, NULL);
      }
      
      if ( widgetTab[i] == helpB )
      {
         XtVaSetValues(helpB, XtNhighlightThickness, 2, NULL);
      }
      else if ( helpB != NULL )
      {
         XtVaSetValues(helpB, XtNhighlightThickness, 0, NULL);
      }
      
      if ( widgetTab[i] == okB )
      {
         XtVaSetValues(okB, XtNhighlightThickness, 2, NULL);
      }
      else if ( okB != NULL )
      {
         XtVaSetValues(okB, XtNhighlightThickness, 0, NULL);
      }
      selectedWidget =  widgetTab[i];    

   }
}

/*  
 ********************************************************************* 
 *  +++fhb  
 *  
 *  NAME:       void leave_CB
 *  
 *  FUNCTION:   handle enter leave of pushbutton
 *  
 *  INPUT:      
 *  
 *  REMARKS:    
 *  
 *  +++fhe  
 *********************************************************************  
*/
void leave_CB(Widget w, XtPointer closure, XEvent *event, Boolean *contDisp)
{
   int isButton = selectedWidget &&
                  (selectedWidget == okB ||
                   selectedWidget == cancelB ||
                   selectedWidget == helpB);

   if ( event->xcrossing.type == EnterNotify )
   {
      *contDisp = True;
       XtVaSetValues(w, XtNhighlightThickness, 2, NULL);
       if ( w != selectedWidget && selectedWidget &&
           (selectedWidget == okB || selectedWidget == cancelB ||
            selectedWidget == helpB )
          )
       {
          XtVaSetValues(selectedWidget, XtNhighlightThickness, 0, NULL);
       }
   }
   else
   {
       *contDisp = False;
       if ( w == selectedWidget )
       {
          XtVaSetValues(w, XtNhighlightThickness, 2, NULL);
       }
       else
       {
          XtVaSetValues(w, XtNhighlightThickness, 0, NULL);
       }
 
       /* selected is a button set Highlight */
       if ( isButton )
       {
          XtVaSetValues(selectedWidget, XtNhighlightThickness, 2, NULL);
       }
   }
}

/*  
 ********************************************************************* 
 *  +++fhb  
 *  
 *  NAME:       void setListPosition
 *  
 *  FUNCTION:   select list item from keyboard cursor down and up keys
 *  
 *  INPUT:      
 *  
 *  REMARKS:    
 *  
 *  +++fhe  
 *********************************************************************  
*/
void setListPosition(Widget w, int item)
{
   Position  y;
   Dimension h;
   int       li, liTotal;
   int       cols = 1;
   
   if ( columnsT )
    cols = atoi(columnsT);

   XtVaGetValues(w,XtNheight,&h, NULL);
   
   if ( h > viewPortHeight )
   {
      liTotal = (choice.count+(cols-1))/cols;
      li = item % liTotal;
      if ( li + 1 > lines )
      {
         y = ((float)(li) / (float)lines)*(viewPortHeight-4)-4;

      }
      else
      {
         y = 0;
      }
      XawViewportSetCoordinates(XtParent(w),0,y);
   }
 }

/*  
 ********************************************************************* 
 *  +++fhb  
 *  
 *  NAME:       void ListSel_CB
 *  
 *  FUNCTION:   select list item from keyboard cursor down and up keys
 *  
 *  INPUT:      
 *  
 *  REMARKS:    
 *  
 *  +++fhe  
 *********************************************************************  
*/

void ListSel_CB(Widget w, XtPointer closure, XEvent *event, Boolean *contDisp)
{
   KeySym                key;
   Modifiers             modifiers;
   XawListReturnStruct *selection;
   int                   newSelected;
   int                   cols = 1;
   if ( columnsT )
    cols = atoi(columnsT);

   *contDisp = True;
   cols = cols ? cols : 1;
   
   selection = XawListShowCurrent(list);

   if ( event->xkey.type == KeyRelease )
   {
      return;
   }
   if ( selection == NULL )
   {
      setFocus_CB(w,closure,event,contDisp);
      return;
   }
   
   newSelected = selection->list_index;

   key = XtGetActionKeysym(event, &modifiers);

   switch(key)
   {
      case XK_Up:
         if ( selection->list_index > 0 )
         {
            newSelected = selection->list_index - 1;
            XawListHighlight(list, newSelected );
         }
      break;
      case XK_Down:
         if ( selection->list_index < choice.count -1 )
         {
            newSelected = selection->list_index + 1;
            XawListHighlight(list, newSelected );
         }
      break;
      case XK_Right:
      {
         int  cols = atoi(columnsT);
         if ( cols > 1 )
         {
            int next, act = selection->list_index;
            int delta = ((choice.count+cols-1)/cols);
          
            next = selection->list_index + delta ;
            if ( next > choice.count - 1 )
               next -= delta * cols;
            if ( next < 0 )
               next += delta;
            newSelected = next;
            XawListHighlight(list, next );
         }
      }
      break;
      case XK_Left:
      {
         int  cols = atoi(columnsT);
         if ( cols > 1 )
         {
            int next, act = selection->list_index;
            int delta = ((choice.count+cols-1)/cols);
          
            next = selection->list_index - delta ;
            if ( next < 0 )
               next += delta * cols;
            if ( next > choice.count - 1 )
               next -= delta;
            XawListHighlight(list, next ); 
            newSelected = next;
         }
      }
      break;
      case XK_Tab: case XK_ISO_Left_Tab:
         setFocus_CB(w,closure,event,contDisp);
      break;
   }
   setListPosition(w,newSelected); 
   setFocus_CB(w,closure,event,contDisp);
}

/*  
 ********************************************************************* 
 *  +++fhb  
 *  
 *  NAME:       void okCB
 *  
 *  FUNCTION:   return selection or beep in no selction
 *  
 *  INPUT:      
 *  
 *  REMARKS:    
 *  
 *  +++fhe  
 *********************************************************************  
*/

void okCB(Widget widget, XtPointer clientData, XtPointer callData)
{
   XawListReturnStruct *selection;
   Arg                  args[1];
   int                  n;
   String               str = NULL;
   char                 *s;

   if ( noReturn )
   {
      /* return without printing any thinks */
      exit(0);
   }

   /***********************************************************/
   /* if we have a list and an input field the User data will */
   /* take precedence                                         */
   /***********************************************************/
   if ( input )
   {
      XtVaGetValues(inText,XtNstring, &str,NULL);

      if ( str )
      {
         s = str;
         while ( *s && isspace(*s)) s++;
         if (denyChars)
         {
            /* if any of the mentionned chars are in the inpt: deny */
            char *d = denyChars;
            while ( *d )
            {
               if ( strchr(s,*d) != NULL )
               {
                  XBell(XtDisplay(widget),100);
                  return;
               }
               d++;
            }
         }
      }
      if ( str == NULL || *s == '\0' && (list == NULL || both))
      {
         XBell(XtDisplay(widget),100);
         return;
      }
      else if ( str && *s )
      {
         if ( !both )
         {
            printf("%s\n",s);
            exit(0);
         }
      }
   }   
   /* look for list selection */
   if ( list )
   {
      selection = XawListShowCurrent(list);
      if (selection == NULL || selection->list_index< 0 )
      {
         XBell(XtDisplay(widget),100);
         return;
      }
      if ( !both )
      {
         printf("%s\n",choice.ret[selection->list_index]);
      }
      else
      {
         printf("%s %s\n",choice.ret[selection->list_index], s);
      }
   }
   exit(0);
}

/*  
 ********************************************************************* 
 *  +++fhb  
 *  
 *  NAME:       void getColors
 *  
 *  FUNCTION:   get a fews colors
 *              (if we have a display with 256 colors and
 *               can't get the wanted color we will default to
 *               black or white)
 *  
 *  INPUT:      
 *  
 *  REMARKS:    
 *  
 *  +++fhe  
 *********************************************************************  
*/

void getColors()
{
   Colormap     cmap;
   XrmValue     fromVal, toVal;

   fromVal.addr = "#0000cf";
   toVal.addr = NULL;
   fromVal.size = sizeof(String);
   XtConvert(toplevel, XtRString, &fromVal, XtRPixel, &toVal);
   if ( toVal.addr != NULL )
      darkblue = *(Pixel*)toVal.addr;
   else
   {
      fromVal.addr = "blue";
      toVal.addr = NULL;
      fromVal.size = sizeof(String);
      XtConvert(toplevel, XtRString, &fromVal, XtRPixel, &toVal);
      if ( toVal.addr != NULL )
      {
         darkblue = *(Pixel*)toVal.addr;
      }
      else
      {
         darkblue = BlackPixel(XtDisplay(toplevel),0);
      }
   }
      
   fromVal.addr = "#cfcfcf";
   toVal.addr = NULL;
   fromVal.size = sizeof(String);
   XtConvert(toplevel, XtRString, &fromVal, XtRPixel, &toVal);
   if ( toVal.addr != NULL )
      grey = *(Pixel*)toVal.addr;
   else
   {
      fromVal.addr = "#cccccc";
      toVal.addr = NULL;
      fromVal.size = sizeof(String);
      XtConvert(toplevel, XtRString, &fromVal, XtRPixel, &toVal);
      if ( toVal.addr != NULL )
         grey = *(Pixel*)toVal.addr;
      else
         grey = WhitePixel(XtDisplay(toplevel),0);
   }

   fromVal.addr = "#ff0000";
   toVal.addr = NULL;
   fromVal.size = sizeof(String);
   XtConvert(toplevel, XtRString, &fromVal, XtRPixel, &toVal);
   if ( toVal.addr != NULL )
      red = *(Pixel*)toVal.addr;
   else
   {
      red = BlackPixel(XtDisplay(toplevel),0);    
   }

   fromVal.addr = "white";
   fromVal.size = sizeof(String);
   toVal.addr = NULL;
   XtConvert(toplevel, XtRString, &fromVal,   XtRPixel, &toVal);
   if ( toVal.addr != NULL )
      white = *(Pixel*)toVal.addr;
   else
   {
      white = WhitePixel(XtDisplay(toplevel),0);
   }
}

/*  
 ********************************************************************* 
 *  +++fhb  
 *  
 *  NAME:       void buildLog
 *  
 *  FUNCTION:   build the log window
 *  
 *  INPUT:      
 *  
 *  REMARKS:    
 *  
 *  +++fhe  
 *********************************************************************  
*/

void buildLog()
{
   Widget       wid;
   Arg          args[20];
   XrmValue     fromVal, toVal;
   Dimension    wMax,w, hMax,h, bwMax;
   Position     x,y;
   XFontStruct *fontb=NULL, *fontn=NULL;
   int          tw, tb, th;
   int          cols = 1;
   int          defaultChoice = 0;
   Widget       topWid = NULL;
   char        *tmpChar = NULL;
   char        *s;
   int          i, n;
   int          dirR, faR, fdR;
   XCharStruct  oR;
   XawTextBlock tB;
   FILE *fp;
   int len;
   if ( linesT )
       lines = atoi(linesT);
   if ( lines <=10  )
      lines = 25;
  
    if( columnsT )
    {
       cols = atoi(columnsT);
    }
    cols = cols <= 40 ? 80 : cols;
   
   /******************************************************/
   /* get fonts                                          */
   /******************************************************/

   /* standard font for list and buttons */
   wid = XtCreateManagedWidget("tmp",labelWidgetClass,toplevel,NULL,0);
   XtVaGetValues(wid, XtNfont, &fontn, NULL);

   tmpChar = calloc(cols+1,1);
   memset(tmpChar, 'W',cols);
   tw = XTextWidth(fontn,tmpChar, cols);
   wMax = tw;

   XTextExtents(fontn, tmpChar, lines,&dirR,&faR,&fdR,&oR);
   th = (faR+fdR) * lines;
   free(tmpChar);
   
   XtDestroyWidget(wid);

   /* bold bigger font for titel an question */
   fromVal.addr = "*lucida*-bold-*-14-*";
   toVal.addr = NULL;
   fromVal.size = sizeof(String);
   XtConvert(toplevel, XtRString, (XrmValuePtr) &fromVal, XtRFontStruct, 
                (XrmValuePtr) &toVal);
   if ( toVal.addr != NULL )
   {
      fontb = (XFontStruct*) *((XFontStruct **)toVal.addr);
   }

   /******************************************************/
   /* calculate text length in pixel                     */
   /******************************************************/
   tw = XTextWidth(fontb,title, strlen(title));
   wMax = tw > wMax ? tw : wMax;


   n=0;
   if ( ok ) 
   {
      tb = XTextWidth(fontn,ok, strlen(ok));
      bwMax = tb > bwMax ? tb : bwMax;
      i++;
   }


   /***** main form ******/

   n = 0;
   XtSetArg(args[n], XtNbackground, grey); n++;
   mf = XtCreateManagedWidget("mainForm",
                              formWidgetClass,
                              toplevel,
                              args,
                              n);

   /******** title label *******/

   n=0;
   XtSetArg(args[n], XtNwidth, wMax); n++;
   XtSetArg(args[n], XtNborderWidth,  0); n++;
   XtSetArg(args[n], XtNbackground, white); n++;
   XtSetArg(args[n], XtNforeground, darkblue); n++;
   XtSetArg(args[n], XtNresizable, True); n++;
   XtSetArg(args[n], XtNresize, False); n++;
   XtSetArg(args[n], XtNfont, (XFontStruct*)fontb);n++;
   XtSetArg(args[n], XtNlabel, title); n++;
   tlb = XtCreateManagedWidget("Label",labelWidgetClass, mf, args,n);
   topWid = tlb;
   
   
   /********* text widget *******/
   n = 0;
   XtSetArg(args[n], XtNfromVert, topWid); n++;
   XtSetArg(args[n], XtNwidth, (wMax-2)); n++;
   XtSetArg(args[n], XtNheight,th); n++;
   XtSetArg(args[n], XtNbackground, white); n++;
   XtSetArg(args[n], XtNresize, False); n++;
   XtSetArg(args[n], XtNfont, fontn);n++;
   XtSetArg(args[n], XtNresizable, True); n++;
   XtSetArg(args[n], XtNeditType, XawtextAppend); n++;
   XtSetArg(args[n], XtNscrollVertical, XawtextScrollWhenNeeded); n++;
   XtSetArg(args[n], XtNscrollHorizontal, XawtextScrollWhenNeeded); n++;
   
   inText = XtCreateManagedWidget("text",asciiTextWidgetClass, mf,args,n);

   topWid = inText;

   /************* ok Button ************/

   n=0;
   XtSetArg(args[n], XtNlabel, ok); n++;
   XtSetArg(args[n], XtNfromVert, topWid); n++;
   XtSetArg(args[n], XtNresizable, True); n++;
   XtSetArg(args[n], XtNresize, False); n++;
   XtSetArg(args[n], XtNwidth, wMax); n++;
   XtSetArg(args[n], XtNbackground, grey); n++;
   if ( help )
   {
      XtSetArg(args[n], XtNfromHoriz, helpB); n++;
   }
   else if ( cancel )
   {
      XtSetArg(args[n], XtNfromHoriz, cancelB); n++;
   }

   okB = XtCreateManagedWidget("ok",commandWidgetClass, mf,args,n); 
   XtAddCallback( okB, XtNcallback, okCB, NULL);
   XtOverrideTranslations(okB,
                           XtParseTranslationTable(buttonTranslationLog));
   XtAddEventHandler(okB,
                     LeaveWindowMask|EnterWindowMask,
                     True,
                     (XtEventHandler) leave_CB, NULL);
   selectedWidget = okB;
  
   /* fill first all widget data's */
   XtRealizeWidget(toplevel);
   XtUnrealizeWidget(toplevel);
   XFlush(XtDisplay(toplevel));
   XSync(XtDisplay(toplevel), False);
   XFlush(XtDisplay(toplevel));
 
   /* get height */
   XtVaGetValues(mf, XtNheight, &h, NULL);

   /* set all values */
   n=0;
   XtSetArg(args[n], XtNtitle,     title); n++;
   XtSetArg(args[n], XtNminHeight, h);n++;
   XtSetArg(args[n], XtNmaxHeight, h);n++;
   XtSetArg(args[n], XtNminWidth,  wMax);n++;
   XtSetArg(args[n], XtNmaxWidth,  wMax);n++;

   /* get witdh and height from display, calculate position */
   if ( geometry == NULL )
   {
      tb = DisplayHeight(XtDisplay(toplevel),0);
      tw = DisplayWidth(XtDisplay(toplevel),0);
      sprintf(geoBuf,"+%d+%d", (tw-wMax)/2,(tb-h)/2);
      XtSetArg(args[n], XtNgeometry,  geoBuf); n++;
      geometry = geoBuf;
   }

   XtSetValues(toplevel,args,n);
   XtRealizeWidget(toplevel);
   
   XtSetKeyboardFocus( toplevel, okB);
   XtCallAcceptFocus(okB,CurrentTime);

   if ( errFile )
   {
      if ( strcmp(errFile, "-") )
         fp = fopen(errFile,"r");
      else
         fp = stdin;
      if ( fp && ! tail )
      {
         fseek(fp,0,SEEK_END);
         len = ftell(fp);
         fseek(fp,0,0);
         tmpChar = calloc(len+1,1);
         fread(tmpChar,len,1, fp);
         fclose(fp);
         tB.firstPos = 0;
         tB.length   = len;
         tB.ptr      = tmpChar;
         tB.format   = 0;

         XawTextReplace(inText, 1, 1,&tB);
         XtVaSetValues(inText,
                       XtNresizable, False,
                       XtNeditType, XawtextRead,
                       NULL);
         free(tmpChar);
      }
      else if ( fp && tail )
      {
         n = fileno(fp);
         XtAppAddInput(appContext,
                       n, (XtPointer) XtInputReadMask,
                       prtText, NULL );
      }
      else
      {
         fprintf(stderr,"cant open file %s, error %d\n",errFile,errno);
         exit(2);
      }
   }
   else
   {
      fprintf(stderr,"no file given\n");
      exit(2);
   }
   setFocusToButton(okB);
}

/*  
 ********************************************************************* 
 *  +++fhb  
 *  
 *  NAME:       void buildWindow
 *  
 *  FUNCTION:   build the main window
 *  
 *  INPUT:      
 *  
 *  REMARKS:    
 *  
 *  +++fhe  
 *********************************************************************  
*/

void buildWindow()
{
   Widget       wid;
   Arg          args[20];
   XrmValue     fromVal, toVal;
   int          n = 0;
   int          i;
   char        *s, *t;
   Dimension    wMax,w, hMax,h, bwMax;
   Position     x,y;
   XFontStruct *fontb=NULL, *fontn=NULL;
   int          tw, tb, th;
   int          cols = 1;
   int          defaultChoice = 0;
   Widget       topWid = NULL;
   int          doVp = 0;
 
  if ( linesT )
     lines = atoi(linesT);
  if ( lines == 0 )
     lines = 15;
  
   if( columnsT )
   {
      cols = atoi(columnsT);
   }
   cols = cols == 0 ? 1 : cols;
   
   /******************************************************/
   /* get fonts                                          */
   /******************************************************/

   /* standard font for list and buttons */
   wid = XtCreateManagedWidget("tmp",labelWidgetClass,toplevel,NULL,0);
   XtVaGetValues(wid, XtNfont, &fontn, NULL);

   XtDestroyWidget(wid);

   /* bold bigger font for titel an question */
   fromVal.addr = "*lucida*-bold-*-14-*";
   toVal.addr = NULL;
   fromVal.size = sizeof(String);
   XtConvert(toplevel, XtRString, (XrmValuePtr) &fromVal, XtRFontStruct, 
                (XrmValuePtr) &toVal);
   if ( toVal.addr != NULL )
   {
      fontb = (XFontStruct*) *((XFontStruct **)toVal.addr);
   }

   /******************************************************/
   /* calculate text length in pixel                     */
   /******************************************************/
   tw = XTextWidth(fontb,title, strlen(title));
   wMax = tw;

   /* this may be a multi line string ! */
   s = t = question;
   do
   {
      t = strchr(s,'\n');
      if ( t )
      {
         tw = XTextWidth(fontb,s, t-s);
         s = t+1;
      }
      else
      {
         tw = XTextWidth(fontb,s, strlen(s));
      }
      wMax = tw > wMax ? tw : wMax;
   } while ( t );

   for ( i = 0; i < choice.count; i++)
   {
      tw = XTextWidth(fontn,choice.text[i], strlen(choice.text[i]));
      if ( cols == 1 )
         wMax = (tw+2) > wMax ? (tw+2)  : wMax;
      else
         wMax = (tw+8)*cols > wMax ? (tw+6)*cols  : wMax;
      if(defChoice && strcmp(defChoice,choice.text[i]) == 0 )
      {
         /* default choice */
         if ( defChoice && strcmp(choice.text[i],defChoice) == 0)
         {
            defaultChoice = i;
         }
      }
   }
   if ( defaultChoice == choice.count )
   {
      defaultChoice = 0;
   }
   
   if ( ((choice.count+1)/cols) >= lines )
   {
      wMax += 14; /* for the scrollbar */
   }
      
   wMax += 10; /* border width of labels */

   bwMax=0;
   tb=0;
   i=0;
   if ( cancel ) 
   {
      tb = XTextWidth(fontn,cancel, strlen(cancel));
      bwMax = tb;
      i++;
   }
   n=0;
   if ( ok ) 
   {
      tb = XTextWidth(fontn,ok, strlen(ok));
      bwMax = tb > bwMax ? tb : bwMax;
      i++;
   }
   if ( help ) 
   {
      tb = XTextWidth(fontn,help, strlen(help));
      bwMax = tb > bwMax ? tb : bwMax;
      i++;
   }
   
#ifdef XAW3D
   bwMax += 12;
#endif
   
   /* take care of borders for button */
   
   /* set width of window, space between button is 4 pixel */
   tb = (4+bwMax)* i;
   wMax = tb > wMax ? tb : wMax;
   /* width fot button -10 for border and -4 for space */
   tb = (wMax-14) / i;
#ifdef XAW3D
   wMax += 2;
#endif

   /***** main form ******/

   n = 0;
   XtSetArg(args[n], XtNbackground, grey); n++;
   mf = XtCreateManagedWidget("mainForm",
                              formWidgetClass,
                              toplevel,
                              args,
                              n);

   /******** title label *******/

   n=0;
   XtSetArg(args[n], XtNwidth, wMax); n++;
   XtSetArg(args[n], XtNborderWidth,  0); n++;
   XtSetArg(args[n], XtNbackground, white); n++;
   XtSetArg(args[n], XtNforeground, darkblue); n++;
   XtSetArg(args[n], XtNresizable, True); n++;
   XtSetArg(args[n], XtNresize, False); n++;
   XtSetArg(args[n], XtNfont, (XFontStruct*)fontb);n++;
   XtSetArg(args[n], XtNlabel, title); n++;
   tlb = XtCreateManagedWidget(s,labelWidgetClass, mf, args,n);
   topWid = tlb;
    
   /**** Create question *****/
   n = 0;
   XtSetArg(args[n], XtNfont, fontb);n++;
   XtSetArg(args[n], XtNwidth, wMax); n++;
   XtSetArg(args[n], XtNborderWidth,  0); n++;
   XtSetArg(args[n], XtNfromVert, tlb); n++;
   XtSetArg(args[n], XtNjustify, XtJustifyLeft); n++;   
   XtSetArg(args[n], XtNlabel, question); n++;
   XtSetArg(args[n], XtNresizable, True); n++;
   XtSetArg(args[n], XtNresize, False); n++;
   XtSetArg(args[n], XtNbackground, grey); n++;

   quest = XtCreateManagedWidget("question",labelWidgetClass, mf, args,n);
   topWid = quest;

   /**** Create List *****/
   if ( choice.count )
   {
      if ( (choice.count / cols ) > lines )
      {
         doVp = 1;
      }

      if ( doVp )
      {
          int di,as,de;
          XCharStruct ov;
          XTextExtents(fontn, "pMq",4, &di, &as,&de,&ov);
          th = as+de+3;
          n = 0;
          XtSetArg(args[n], XtNwidth, (wMax-2)); n++;
          XtSetArg(args[n], XtNheight, th * lines); n++;
          XtSetArg(args[n], XtNallowVert, True); n++;
          XtSetArg(args[n], XtNuseRight, True);  n++;
          XtSetArg(args[n], XtNfromVert, quest); n++;
          vp = XtCreateManagedWidget("vp",viewportWidgetClass,mf,args,n);
          viewPortHeight = th * lines;
      }
      
      n = 0;
      
      XtSetArg(args[n], XtNwidth, (wMax-2)); n++;
      if ( !doVp )
      {
         XtSetArg(args[n], XtNfromVert, quest); n++;
      }
      XtSetArg(args[n], XtNdefaultColumns, cols); n++;
      XtSetArg(args[n], XtNforceColumns, cols); n++;
      XtSetArg(args[n], XtNverticalList, True); n++;
 
      XtSetArg(args[n], XtNbackground, white); n++;
      XtSetArg(args[n], XtNresize, False); n++;
      XtSetArg(args[n], XtNresizable, True); n++;
      XtSetArg(args[n], XtNfont, fontn);n++;

      /* set the choices */
      if ( choice.count )
      {
         XtSetArg(args[n], XtNlist, choice.text); n++;
      }
      /* create button as given choice in a list */
      list = XtCreateManagedWidget("list",listWidgetClass,
                                   doVp? vp : mf ,args,n);
      topWid = doVp ? vp : list;
      XtAddEventHandler(list,
                        KeyPressMask|KeyReleaseMask|ButtonReleaseMask,
                        True,
                        (XtEventHandler) ListSel_CB, NULL);
      XtAddEventHandler(list, StructureNotifyMask,
                        True,
                       (XtEventHandler) setFocus_CB, NULL);
      widgetTab[tabCount++] = list;
   }

   if ( input )
   {
      n = 0;
      XtSetArg(args[n], XtNfromVert, topWid); n++;
      XtSetArg(args[n], XtNwidth, (wMax-2)); n++;
      XtSetArg(args[n], XtNbackground, white); n++;
      XtSetArg(args[n], XtNresize, False); n++;
      XtSetArg(args[n], XtNfont, fontn);n++;
      XtSetArg(args[n], XtNresizable, True); n++;
      XtSetArg(args[n], XtNeditType, XawtextEdit); n++;

      inText = XtCreateManagedWidget("text",asciiTextWidgetClass, mf,args,n);
      widgetTab[tabCount++] = inText;

      XtAddEventHandler(inText, KeyPressMask|KeyReleaseMask|ButtonPressMask,
                        True,
                        (XtEventHandler) setFocus_CB, NULL);

      XtOverrideTranslations(inText,
                             Input == 0
                                ?
                                  XtParseTranslationTable(textTranslation)
                                :
                                  XtParseTranslationTable(textTranslationSpc));
      
      topWid = inText;
   }
   
   /******* install the help, cancel and ok buttons */
   i= 0;
   if ( cancel) i++;
   if ( help) i++;
   if ( ok) i++;
   w = tb;

#ifdef XAW3D
   w += 3;
#endif
   switch ( i )
   {
      case 1: w += 12;break;
      case 2: w += 3;break;
   }
   if ( cancel )
   {
      n=0;
      XtSetArg(args[n], XtNlabel, cancel); n++;
      XtSetArg(args[n], XtNfromVert, topWid); n++;      
      XtSetArg(args[n], XtNresizable, True); n++;
      XtSetArg(args[n], XtNresize, False); n++;
      XtSetArg(args[n], XtNwidth, w); n++;
      XtSetArg(args[n], XtNbackground, grey); n++;
      cancelB = XtCreateManagedWidget("cancel",commandWidgetClass, mf,args,n);
      XtAddCallback( cancelB, XtNcallback, cancelCB, NULL);
      widgetTab[tabCount++] = cancelB;
      XtAddEventHandler(cancelB, KeyPressMask|KeyReleaseMask, True,
                        (XtEventHandler) setFocus_CB, NULL);
      XtOverrideTranslations(cancelB,
                             XtParseTranslationTable(buttonTranslation));
      XtAddEventHandler(cancelB, LeaveWindowMask|EnterWindowMask,  True,
                        (XtEventHandler) leave_CB, NULL);
   }

   if ( help )
   {
      n=0;
      XtSetArg(args[n], XtNlabel, help); n++;
      XtSetArg(args[n], XtNfromVert, topWid); n++;
      XtSetArg(args[n], XtNresizable, True); n++;
      XtSetArg(args[n], XtNresize, False); n++;
      XtSetArg(args[n], XtNwidth, w); n++;
      XtSetArg(args[n], XtNbackground, grey); n++;
      if ( cancel )
      {
         XtSetArg(args[n], XtNfromHoriz, cancelB); n++;
      }
      helpB = XtCreateManagedWidget("help",commandWidgetClass, mf,args,n); 
      XtAddCallback( helpB, XtNcallback, helpCB, NULL);
      widgetTab[tabCount++] = helpB;
      XtAddEventHandler(helpB, KeyPressMask|KeyReleaseMask, True,
                        (XtEventHandler) setFocus_CB, NULL);
      XtOverrideTranslations(helpB,
                             XtParseTranslationTable(buttonTranslation));
      XtAddEventHandler(helpB, LeaveWindowMask|EnterWindowMask,  True,
                        (XtEventHandler) leave_CB, NULL);
   }
   if ( ok )
   {
      n=0;
      XtSetArg(args[n], XtNlabel, ok); n++;
      XtSetArg(args[n], XtNfromVert, topWid); n++;
      XtSetArg(args[n], XtNresizable, True); n++;
      XtSetArg(args[n], XtNresize, False); n++;
      XtSetArg(args[n], XtNwidth, w); n++;
      XtSetArg(args[n], XtNbackground, grey); n++;
      if ( help )
      {
         XtSetArg(args[n], XtNfromHoriz, helpB); n++;
      }
      else if ( cancel )
      {
         XtSetArg(args[n], XtNfromHoriz, cancelB); n++;
      }

      okB = XtCreateManagedWidget("ok",commandWidgetClass, mf,args,n); 
      XtAddCallback( okB, XtNcallback, okCB, NULL);
      widgetTab[tabCount++] = okB;
      XtAddEventHandler(okB, KeyPressMask|KeyReleaseMask, True,
                        (XtEventHandler) setFocus_CB, NULL);
      XtOverrideTranslations(okB,
                             XtParseTranslationTable(buttonTranslation));
      XtAddEventHandler(okB, LeaveWindowMask|EnterWindowMask,  True,
                        (XtEventHandler) leave_CB, NULL);
   }

   /* set max and min width / height for the toplevel shell */
   
   /* fill first all widget data's */
   XtRealizeWidget(toplevel);
   XtUnrealizeWidget(toplevel);
   XFlush(XtDisplay(toplevel));
   XSync(XtDisplay(toplevel), False);
   XFlush(XtDisplay(toplevel));
 
   /* get height */
   XtVaGetValues(mf, XtNheight, &h, NULL);

   /* set all values */
   n=0;
   XtSetArg(args[n], XtNtitle,     title); n++;
   XtSetArg(args[n], XtNminHeight, h);n++;
   XtSetArg(args[n], XtNmaxHeight, h);n++;
   XtSetArg(args[n], XtNminWidth,  wMax);n++;
   XtSetArg(args[n], XtNmaxWidth,  wMax);n++;

   /* get witdh and height from display, calculate position */
   if ( geometry == NULL )
   {
      tb = DisplayHeight(XtDisplay(toplevel),0);
      tw = DisplayWidth(XtDisplay(toplevel),0);
      sprintf(geoBuf,"+%d+%d", (tw-wMax)/2,(tb-h)/2);
      XtSetArg(args[n], XtNgeometry,  geoBuf); n++;
      geometry = geoBuf;
   }
   XtSetValues(toplevel,args,n);
   XtRealizeWidget(toplevel);

   
   /* select first list item or default choice */
   if ( list && !noReturn )
   {
      XawListHighlight(list, defaultChoice);
      setListPosition(list, defaultChoice);
   }
   if ( list )
   {
      XtSetKeyboardFocus( toplevel, list);
      XtCallAcceptFocus(list,CurrentTime);
      if ( doVp )
      {
         XtVaSetValues(XtParent(list), XtNborderColor, darkblue, NULL);
      }
      else
      {
         XtVaSetValues(list, XtNborderColor, darkblue, NULL);
      }
   }
   else if ( inText )
   {
      XtSetKeyboardFocus( toplevel, inText);
      XtCallAcceptFocus(inText,CurrentTime);
      XtVaSetValues(inText, XtNborderColor, darkblue, NULL);
   }
}

/*  
 ********************************************************************* 
 *  +++fhb  
 *  
 *  NAME:       void main
 *  
 *  FUNCTION:   start here
 *  
 *  INPUT:      
 *  
 *  REMARKS:    
 *  
 *  +++fhe  
 *********************************************************************  
*/

int main(int argc, char *argv[])
{
   char    *args[5];
   int      count;
   char     *s, *t;
    
   args[0] = *argv;
   args[1] = "-display";
   args[2] = display;
   args[3] = NULL;
   args[4] = NULL;
   count   = 3;

   /* preset title to prg name */
   s = strrchr(*argv,'/');
   title = (s!=NULL) ? s+1 : *argv;
 
   s = getenv("DISPLAY");
   if ( s != NULL )
      display = s;

   argc--;
   argv++;
   while ( argc > 0 )
   {
      IF_OPT("-display",        display)
      else IF_OPT("-columns",   columnsT)
      else IF_OPT("-lines",     linesT)
      else IF_OPT("-geometry",  geometry)
      else IF_OPT("-title",     title)
      else IF_OPTH("-help",     help, helpOK, helpFile)
      else IF_OPTB("-cancel",   cancel, cancelRet)
      else IF_OPT("-ok",        ok)
      else IF_OPT("-question",  question)
      else IF_OPTC("-choice",   choice)
      else IF_OPT("-defChoice", defChoice)
      else IF_OPTB("-error",    error, errFile)
      else IF_OPTB("-message",  message, errFile)
      else IF_OPTB("-wait",     Wait, errFile)
      else IF_OPT1("-input",    input)
      else IF_OPT1("-Input",    Input)
      else IF_OPT("-deny",      denyChars)
      else IF_OPT1("-both",     both)
      else IF_OPT1("-noReturn", noReturn)
      else IF_OPTB("-log",      log, errFile )
      else IF_OPTB("-tail",     tail,errFile )
      else exit(2);
   }

   if ( Input == 1 )
      input = 1;

   if ( tail != NULL )
   {
      log = tail;
   }
 
   if ( question == NULL && (message == NULL && error == NULL &&
        Wait == NULL && log == NULL))
   {
      exit(2);
   }

   if ( (choice.text != NULL && input == 0 ) ||
        (input != 0 && choice.text == NULL && Wait == NULL && log == NULL ) )
   {
      both = 0;
   }

   /***************************************************/
   /* substitute \n with <NL> (question string)       */
   /***************************************************/
   if ( question )
   {
      t = s = question;
      while(*s)
      {
         if ( *s == '\\' && s[1] == 'n' )
         {
            *t++ = '\n';
            s += 2;
         }
         else
            *t++ = *s++;
      }
      *t = '\0';
   }
   else
   {
      question = "choose:";
   }

   args[2] = display;
   if ( geometry )
   {
      args[count++] = "-geometry";
      args[count++] = geometry;
   }
   
   toplevel = XtAppInitialize(&appContext,  /* XtAppContext */
                              title,        /* String       */
                              NULL,         /* XrmOptionDescRec* */
                              0,            /* Cardinal num_options */
                              &count,       /* int* argc_in_out; */
                              args,         /* String* argv_in_out */
                              NULL,         /* String* fallback_resources */
                              NULL, 
                              0
                            );
   
   if ( toplevel )
   {
      Window win;
      Atom XwAtom = None;
      Bool oie;

      getColors();
      if ( ( error == NULL && message == NULL && Wait == NULL && log == NULL) )
      {
        buildWindow();
      }
      else
      {
         if ( log )
         {
            buildLog();
         }
         else
         {
            showError();
         }
      }

      oie = Wait != NULL ? False : True;
      XwAtom = XInternAtom(XtDisplay(toplevel),
                           "xwChoice",
                           oie);

      if ( XwAtom != None )
      {
         if ( (win = XGetSelectionOwner(XtDisplay(toplevel), XwAtom)) == None )
         {
            if ( Wait )
            {
               XSetSelectionOwner(XtDisplay(toplevel),XwAtom,
                                  XtWindow(toplevel), CurrentTime);
            }
         }

         if ( win != None && Wait == NULL )
         {
            /* send a client message to the Wait window */
            XEvent event;

            memset(&event,0,sizeof(XEvent));
            event.xclient.type = ClientMessage;
            event.xclient.window = win;
            event.xclient.display = XtDisplay(toplevel);
            event.xclient.message_type = None;
            event.xclient.format = 8;
            XSendEvent(XtDisplay(toplevel), win, True,NoEventMask,&event);
         }
         else if ( Wait != NULL && win != None && win != XtWindow(toplevel))
         {
            exit(0);
         }
      }
      
      for (;;)
      {
         XEvent  event;
         XtAppNextEvent(appContext,&event);
         if ( event.xclient.type == ClientMessage )
            break;
         XtDispatchEvent(&event);
      } 
   }
   else
   {
      exit(1);
   }
   exit(0);
}
