#!/bin/sh
##########################################################################
#
# Function: Configure the Makefile and provide a menu for
#           calling of make
#
# Remark:  This is not very usefull here but I need an example
#
# Author:  Jean-Jacques Sarton jj.sarton@t-online.de
#
# Date:    JUN-04-2000
#
##########################################################################

### compile xwChoice

if [ "`uname -s`" = Linux ]
then
   if [ -f /usr/X11R6/lib/libXaw3d.so ]       
   then
      sed -e 's/#ddd/ddd/' \
          -e 's/#XAWDEF.*/XAWDEF=-DXAW3D=1/' \
			 -e 's/@//' \
          Makefile.org > Makefile
	else
	   cp Makefile.org Makefile
	fi
fi

### set environment
PATH=`pwd`:$PATH

### prepare for logging of make output
echo xwChoice Log > make.log
exec 2>&1 1>> make.log
make xwChoice

### I use a few functions so the main code look better and

# xwChoice must be started as background process and calling via
# a function is necessary

doWait()
{
   # start xwChoice as wait box in the background
	./xwChoice -title 'Make xwChoice'                         \
	           -wait  OK '\n\n\n   Wait a little bit ...\n\n\n' &
}

# Popup the log window if not allready running
showLog()
{
   if [ "$ProcessId" = "" -o ! -d /proc/$ProcessId ]
	then
      ./xwChoice -title 'Make xwChoice'     \
	              -tail 'Log viewed' make.log &
	   ProcessId=$!
	fi
}

# only in order to have a message file which can be outputed
bldHlp()
{
   if [ -f helpFile ]
   then
      return
   fi
   echo 'This is an example for an help text
This is the second line
and the third.

Enjoy with xwChoice

' > helpFile
}

# a simple file selection box
fsb()
{
   wd=`pwd`
   title='File Selection Box'
	question="actual dir: `pwd`"
	back='Done'
	ok='Select'

   # build list of directories and files
	dirs="../ `ls -F1 | grep / | sort`"
	files="`ls -F1 | grep -v / | tr -d '*=|@' | sort`"
	# make a script with all items
	{
	   echo "xwChoice -title '$title'       \\"
		echo "         -question '$question' \\"
		echo "         -cancel   '$back' ''  \\"
		echo "         -columns 3 -lines 24  \\"

	  for d in $dirs
	  do
	     echo " 		-choice '$d' $d \\"
	  done
	  for f in $files
	  do
	     echo " 	   -choice '$f' $f \\"
	  done
	  echo "          -ok '$ok'"
	} > /tmp/fsb.$$

	# make the script executable	
	chmod +x /tmp/fsb.$$

	answer=`/tmp/fsb.$$`
	choice=$wd/$answer

   # Cancel choosen -> we have our choice now
	if [ $? -eq 3 ]
	then
	   rm /tmp/fsb.$$
		xwChoice -error ok "You choosed\n$choice\n"
	   return;
	fi

   # special case for links
	if [ -h $wd/$answer -a -d $wd/$answer ]
	then
	   answer=$answer/
	fi

   # perform acrion according to entry type
	case $answer in
	   '../') cd $wd/..; wd=`pwd`;fsb;;
	   */)    cd $wd/$answer; fsb;;
		*)     xwChoice -message OK "`file $wd/$answer`";; 
	esac
}

# Demonstation for an input field
input()
{
   answer=`xwChoice -question 'Enter a little text' -Input -ok Done`
	xwChoice -message OK "You have entered:\n\n$answer\n\n"
}

# our main menu
menu()
{
   ./xwChoice -title     'Make xwChoice'                                   \
              -question  'Choose the action you want:'                     \
              -choice    'show me the documentation'             doc       \
	   		  -choice    'Remove all temporary files'            clean     \
              -choice    'Build xwChoice'                        xwChoice  \
		   	  -choice    'Install xwChoice to /usr/local/bin'    install   \
		   	  -choice    'show error message'                    errMsg    \
		   	  -choice    'File Selection'                        fsb       \
		   	  -choice    'Input Box'                             input     \
		   	  -defChoice 'Build xwChoice'                                  \
		   	  -cancel    'Quit'                                  quit      \
		   	  -help      'Help me' 'I have read the Help textes' helpFile  \
			     -ok        'Do the hard job'
}

### begin with the job
ProcessId=

while :
do
   bldHlp  # build help file needed by menu
   answer=`menu`
   case $answer in
	   doc)      xwChoice -title 'Make xwChoice' -log OK xwChoice.txt;;
      clean)    doWait; sleep 1; rm *.o;;
		xwChoice) showLog; make ./xwChoice ;;
		install)  cp ./xwChoice /usr/local/bin;;
		errMsg)   xwChoice -error OK '  An error\noccured here';;
		fsb)      curDir=`pwd`
		          cd /
					 fsb
					 cd $curDir;;
		input)    input;;
		quit)     rm helpFile make.log; exit;;
	esac
done
