/* xvtxlib.c library routines for xvtx.c */

#include "sys_head.h"
#include "xvtx.h"
#include "keys.h"
#include "s14font.h"
#include "txtfont.h"
#include "xglgraphi.h"
#include "display.h"

#define SEQUENCE_DELAY	3000000
#define MAX_SEQUENCE	100

#define PAGE_START	12

#define GET_PAGE		0
#define GET_SUBPAGE		1
#define SELECTED		3

/* for macros */
#define MACRO_OFF	0
#define MACRO_READ	1
#define MACRO_WRITE	2

/*commands */
/* 0 through 9 for digits */
#define CLEAR_ENTRY				10
#define ERASE_PAGE				11
#define SAVE_PAGE				12
#define LOAD_PAGE				13
#define AUTO_SEQUENCE_TOGGLE	14
#define TRY_PREVIOUS_SUBPAGE	15
#define RESTORE_PREVIOUS_PAGE 	16
#define DISPLAY_GROUP_TOGGLE	17
#define TRY_NEXT_SUBPAGE		18
#define REVEAL_CONCEAL_TOGGLE	19
#define MACRO_A					20
#define MACRO_B					21
#define MACRO_C					22		   	
#define MACRO_D					23
#define MACRO_E					24
#define MACRO_F					25
#define MACRO_G					26
#define MACRO_H					27
#define MACRO_I					28
#define CHANNEL_1				29
#define CHANNEL_2				30
#define CHANNEL_3				31
#define CHANNEL_4				32
#define CHANNEL_5				33
#define CHANNEL_6				34
#define CHANNEL_7				35
#define CHANNEL_8				36
		
/* definition of teletext screen format */
#define ROWS		24
#define COLUMNS		40

/*
the arrays are needed because we need to know all parameters of a
displayed page all the time
*/
static char data_buffer[DISPLAYS * CHANNELS * PAGE_SPACE];
static int _main_page[DISPLAYS * CHANNELS];
static int _sub_page[DISPLAYS * CHANNELS];
static int _hold_page_flag[DISPLAYS * CHANNELS];
static int _reveal_flag[DISPLAYS * CHANNELS];
static int _man_sequence_flag[DISPLAYS * CHANNELS];
static int mouse_page[DISPLAYS];
static int macro_flag;
static char present_macro_name[COLUMNS];
static int x_initiated_flag;
static int oldpixels[10][10];
static int oldx, oldy;
static int mouse_click;
int display_group;
static int mouse_flag;

FILE *macrofile;

/* defined in xvtx.c */
extern char *home_dir;
extern int debug_flag;
extern struct timeval *start_timeval[];
extern struct timeval *current_timeval[];


int print_cursor_status(int x, int y, int dspmem_offset)
/*
print mouse position in txt page as column and row in display page 3 top
right corner
*/
{
int x_position, y_position;
int data_at_cursor;
int txt_vpos, txt_hpos;
int vert_page_position, hor_page_position;
int saa_mem;
int display;
char iic_data[3];
char temp[40];
#define UPPER 1
#define LOWER 2
#define LEFT 3
#define RIGHT 4
/*
characterset s14font is 8 width and 9 hight
pages are 40 characters * 8 dots = 320 widht
the left oriented pages start at x = 0,
the right oriented pages start at x = 320.
the top oriented pages start at y = 0,
the bottom oriented pages start at y = 240.
*/
/*first calculate the row into a teletext page on screen*/
if(y > 239)/*lower 2 pages*/
	{
	y -= 240;
	vert_page_position = LOWER;
	}
else vert_page_position = UPPER;
/*calculate column into teletext page*/
if(x > 319)/*right 2 pages*/
	{
	x -= 320;
	hor_page_position = RIGHT;
	}
else hor_page_position = LEFT;
if(hor_page_position == LEFT && vert_page_position == UPPER)
	{
	display = 0;
	}
if(hor_page_position == RIGHT && vert_page_position == UPPER)
	{
	display = 1;
	}
if(hor_page_position == LEFT && vert_page_position == LOWER)
	{
	display = 2;
	}
if(hor_page_position == RIGHT && vert_page_position == LOWER)
	{
	display = 3;
	}
txt_vpos = y / charheight;/*first line is 0*/
txt_hpos = x / charwidth;/*first column is 0*/
/*we have screen (0 to 3) and x and y position in that screen*/
saa_mem = display + dspmem_offset;
if(! pgetstr(txt_hpos, txt_vpos, saa_mem, 1, iic_data) )return 0;
data_at_cursor = iic_data[0];
sprintf(temp, "%02d %02d %03d", txt_hpos, txt_vpos, data_at_cursor);

x_position = 639 - 19 * charwidth + 1; /* for 9 characters plus spaces */
y_position = 0;
s3putmsg(x_position, y_position, WHITE, BLUE, temp, 1);
return 1;
}


int print_channel_clickbar_status(int selected_channel)
{
/*
print the channel clickbar in top right display, wit hteh selected
channel number in a different color.
*/
int i;
int channel_char;
int referenced_channel_char;
int channel_char_color;
int x_position;
int y_position;
char temp[80];
int fgcolor;
int bgcolor;
referenced_channel_char = selected_channel + '1' - 1;
//macro_id - MACRO_A + 'A';
/* print the channel click bar 12345678 */
/*only the character referenced by channel_id changes background color*/
fgcolor = WHITE;
/* the color of the selected channel */
channel_char_color = YELLOW;
/* position of click bar */
y_position = 0;
x_position = 639 - ( (9 + 8 + 1) * charwidth);
temp[1] = 0;/* string termination */
i = 0;
while(1)
	{ 
	/* calculate the channel character to be printed */
	channel_char = i + '1';
	/* calculate the back ground color */
	if(channel_char == referenced_channel_char)	bgcolor = channel_char_color;
	else bgcolor = BLUE;
	/* print channel character */
	temp[0] = channel_char;
	s3putmsg(x_position, y_position, fgcolor, bgcolor, temp, 1);
	/* calculate new x_position */
	x_position += charwidth;/* one space */
	if(x_position > 639 - 11 * charwidth) break;/* no more space */
	i++;
	}
return 1;
}


int print_macro_status(int macro_id, int macro_mode)
{
/*
print the macro clickbar and the selected macro in a different color,
depending on wether it is open for read or write
*/
int i;
int macro_char;
int referenced_macro_char;
int macro_char_color;
int x_position;
int y_position;
char temp[80];
int fgcolor;
int bgcolor;
referenced_macro_char = macro_id - MACRO_A + 'A';
if(macro_mode == MACRO_OFF)macro_char_color = BLUE;
if(macro_mode == MACRO_WRITE)macro_char_color = RED;
if(macro_mode == MACRO_READ)macro_char_color = GREEN;
/* print the macro click bar ABCDEFGHI */
/*only the character referenced by macro_id changes background color*/
fgcolor = WHITE;
/* position of click bar */
y_position = 0;
x_position = 639 - 9 * charwidth; /* for 9 characters plus spaces */
temp[1] = 0;/* string termination */
i = 0;
while(1)
	{ 
	/* calculate the macro character to be printed */
	macro_char = i + 'A';
	/* calculate the back ground color */
	if(macro_char == referenced_macro_char)	bgcolor = macro_char_color;
	else bgcolor = BLUE;
	/* print macro character */
	temp[0] = macro_char;
	s3putmsg(x_position, y_position, fgcolor, bgcolor, temp, 1);
	/* calculate new x_position */
	x_position += charwidth;/* one space */
	if(x_position > 639)break;/* no more space */
	i++;
	}
return 1;
}


int print_status()
/* print the status of the acquisition circuits in each display */
{
int i;
char temp[80];

for(i = 0; i < DISPLAYS; i++)
	{
	if(_hold_page_flag[i + (display_group * DISPLAYS) ])
		{
		sprintf(temp, "%03d/%03d HOLD",\
		_main_page[i + (display_group * DISPLAYS) ],\
		_sub_page[i + (display_group * DISPLAYS) ]);
		}
	else
		{
		sprintf(temp, "%03d/%03d ACQUIRE",\
		_main_page[i + (display_group * DISPLAYS) ],\
		_sub_page[i + (display_group * DISPLAYS) ]);
		}
	print_in_display(i, temp);
	}
return 1;
}


int calculate_teletext_page_and_position(int x, int y,\
	int *selected_item, int *selected_item_tail,\
	int *selected_display_page, int dspmem_offset)
/*
calculates value of page (*selected_item) and page (*selected_display_page)
in display (of 4 pages) mouse is pointing at,
dspmem_offset is  0 to MX_CHANNLES 8 4
checks for mouse click in special field bar and returns special field
commands in *selected_item.
returns -1 for *selected_item and *selected_display_page if invalid data.
*/
{
int txt_vpos, txt_hpos;
int vert_page_position, hor_page_position;
int saa_dsp_mem;
#define UPPER 1
#define LOWER 2
#define LEFT 3
#define RIGHT 4
/*
characterset s14font is 8 width and 9 hight
pages are 40 characters * 8 dots = 320 widht
the left oriented pages start at x = 0,
the right oriented pages start at x = 320.
the top oriented pages start at y = 0,
the bottom oriented pages start at y = 240.
*/
/*first calculate the row into a teletext page on screen*/
if(y > 239)/*lower 2 pages*/
	{
	y -= 240;
	vert_page_position = LOWER;
	}
else vert_page_position = UPPER;
/*calculate column into teletext page*/
if(x > 319)/*right 2 pages*/
	{
	x -= 320;
	hor_page_position = RIGHT;
	}
else hor_page_position = LEFT;
if(hor_page_position == LEFT && vert_page_position == UPPER)
	{
	*selected_display_page = 0;
	}
if(hor_page_position == RIGHT && vert_page_position == UPPER)
	{
	*selected_display_page = 1;
	}
if(hor_page_position == LEFT && vert_page_position == LOWER)
	{
	*selected_display_page = 2;
	}
if(hor_page_position == RIGHT && vert_page_position == LOWER)
	{
	*selected_display_page = 3;
	}
txt_vpos = y / charheight;/*first line is 0*/
txt_hpos = x / charwidth;/*first column is 0*/
/*check for valid x range*/
if( (txt_hpos < 0) || (txt_hpos > 39) )
	{
	*selected_item = -1;
	return 1;
	}
/*check for valid y range*/
if( (txt_vpos < 0) || (txt_vpos > 25) )
	{
	*selected_item = -1;
	return 1;
	}
/*we have screen (0 to 3) and x and y position in that screen*/
/*check for mouse click in special field bar*/
if(txt_vpos == 25)/*on special field bar*/
	{
	if( (txt_hpos >= 20) && (txt_hpos < 20 + 10) )/*digits 0 trough 9*/
		{
		*selected_item = txt_hpos - 20;/* 0 to 9 is digits */
		return 1;
		}
	if(txt_hpos == 30)/*'C' clear entry*/
		{
		*selected_item = CLEAR_ENTRY;
		return 1;
		}
	if(txt_hpos == 31)/* '?' reveal / conceal toggle, default conceal */
		{
		*selected_item = REVEAL_CONCEAL_TOGGLE;
		return 1;
		}
	if(txt_hpos == 32)/*'R' restore previous page (from RAM)*/
		{
		*selected_item = RESTORE_PREVIOUS_PAGE;
		return 1;
		}
	if(txt_hpos == 33)/*save page*/
		{
		*selected_item = SAVE_PAGE;
		return 1;
		}
	if(txt_hpos == 34)/*'L' load page*/
		{
		*selected_item = LOAD_PAGE;
		return 1;
		}
	if(txt_hpos == 35)/* 'E' erase page */
		{
		*selected_item = ERASE_PAGE;
		return 1;
		}
	if(txt_hpos == 36) /*'A' auto sequence off for this page */
		{
		*selected_item = AUTO_SEQUENCE_TOGGLE;
		return 1;
		}
	if(txt_hpos == 37)/*'P' try previous subpage */
		{
		*selected_item = TRY_PREVIOUS_SUBPAGE;
		return 1;
		}
	if(txt_hpos == 38)/* 'N' try next subpage */
		{
		*selected_item = TRY_NEXT_SUBPAGE;
		return 1;
		}
	if(txt_hpos == 39)/* 'G' group 1 / 2 toggle */
		{
		*selected_item = DISPLAY_GROUP_TOGGLE;
		set_all_mouse_pages();
		return 1;
		}
	}/*end special field processing*/
if( (*selected_display_page == 1) && (txt_vpos == 0) )
	{
	/* on channel clickbar */
	if(txt_hpos == 22) /* channel '1' */
		{
		*selected_item = CHANNEL_1;
		set_all_mouse_pages();
		return 1;
		}
	if(txt_hpos == 23) /* channel '2' */
		{
		*selected_item = CHANNEL_2;
		set_all_mouse_pages();
		return 1;
		}
	if(txt_hpos == 24) /* channel '3' */
		{
		*selected_item = CHANNEL_3;
		set_all_mouse_pages();
		return 1;
		}
	if(txt_hpos == 25) /* channel '4' */
		{
		*selected_item = CHANNEL_4;
		set_all_mouse_pages();
		return 1;
		}
	if(txt_hpos == 26) /* channel '5' */
		{
		*selected_item = CHANNEL_5;
		set_all_mouse_pages();
		return 1;
		}
	if(txt_hpos == 27) /* channel '6' */
		{
		*selected_item = CHANNEL_6;
		set_all_mouse_pages();
		return 1;
		}
	if(txt_hpos == 28) /* channel '7' */
		{
		*selected_item = CHANNEL_7;
		set_all_mouse_pages();
		return 1;
		}
	if(txt_hpos == 29) /* channel '8' */
		{
		*selected_item = CHANNEL_8;
		set_all_mouse_pages();
		return 1;
		}

	/*on macro clickbar */
	if(txt_hpos == 31) /* macro 'A' */
		{
		*selected_item = MACRO_A;
		return 1;
		}
	if(txt_hpos == 32) /* macro 'B'*/
		{
		*selected_item = MACRO_B;
		return 1;
		}
	if(txt_hpos == 33) /* macro 'C' */
		{
		*selected_item = MACRO_C;
		return 1;
		}
	if(txt_hpos == 34) /* macro 'D' */
		{
		*selected_item = MACRO_D;
		return 1;
		}	
	if(txt_hpos == 35) /* macro 'E' */
		{
		*selected_item = MACRO_E;
		return 1;
		}
	if(txt_hpos == 36) /* macro 'F'*/
		{
		*selected_item = MACRO_F;
		return 1;
		}
	if(txt_hpos == 37) /* macro 'G' */
		{
		*selected_item = MACRO_G;
		return 1;
		}
	if(txt_hpos == 38) /* macro 'H' */
		{
		*selected_item = MACRO_H;
		return 1;
		}	
	if(txt_hpos == 39) /* macro 'I' */
		{
		*selected_item = MACRO_I;
		return 1;
		}
	}/* end macro click bar */
/*get the page*/
saa_dsp_mem = *selected_display_page + dspmem_offset;
if(!get_integer_value_pointed_at(saa_dsp_mem, txt_hpos,txt_vpos,
										selected_item, selected_item_tail))
	{
	return 0; /* hardware error, selected_item is -1 for invalid data */
	}
/*check for valid result*/
if(*selected_item == REVEAL_CONCEAL_TOGGLE)/* on '?' */
	{
	return 1;
	}
if( (*selected_item < 100) || ( *selected_item > 899) )
										/*not a txt page value pointed at*/
	{
	*selected_item = -1;
	return 1;
	}
/*
*selected_item and selected_display_page now -1 for error
sprintf(temp, "hpos = %d  vpos = %d  display = %d, selected_item = %d",\
txt_hpos, txt_vpos, *selected_display_page, *selected_item);
s3putmsg(0, 400, 14, 12, temp, 1);
*/
return 1;
}


int print_in_display(int selected_display_page, char *text)
{
/*
print the red status / click bar with text in the selected display.
*/
int fg, bg;
int x, y;

if(debug_flag)
	{
	fprintf(stdout,\
	"print_in_display(): selected_display_page=%d text=%s\n",\
	selected_display_page, text);
	}

fg = YELLOW;
bg = RED;
if(selected_display_page == 0)
	{
	x = 0;
	y = 225;/*25 * 9*/
	}
if(selected_display_page == 1)
	{
	x = 320;
	y = 225;
	}
if(selected_display_page == 2)
	{
	x = 0;
	y = 465;/*25 * 9 + (480 / 2)*/
	}
if(selected_display_page == 3)
	{
	x = 320;
	y = 465;
	}
/* draw the bar to click on*/
/*
0 trough 9 stand for digits making up page,
0 at position 20 stands for digit 0 for entering pages and subpages,
1 at position 21 stands for digit 1 for entering pages and subpages,
etc., through 9 at position 29.
C at position 30 stands for clear (page and subpage entry),
? at position 31 stands for reveal / conceal toggle
R at position 32 stands for restore (get previous page in this display),
S at position 33 stands for save page (filename asked for),
L at position 34 stands for load page (filename asked for),
E at position 35 stands for clear screen,
M at position 36 stands for man sequence sub pages.
P at position 37 stands for previous subpage if manual mode selected.
N at position 38 stands for next subpage if manual mode selected.
G at position 39 stands for display group increment.
*/
/* prevent text getting mixed up */
if(strlen(text) < 20)/* print click points in second part of line */
	{
	s3putmsg(x, y, fg, bg, "                    0123456789C?RSLEMPNG", 1);
	}
else /* clear whole line */
	{
	s3putmsg(x, y, fg, bg, "                                        ", 1);
	}
s3putmsg(x, y, fg, bg, text, 1);/* print message */
return 1;
}	


int get_requested_pages()
{
/*
read the 4 pages from disk for the channel shown, take into
account any timers for sequenced pages.
If a page was requested by a mouse click, get immediate by bypassing the
sequence timer for that page.
*/
int display_page;
unsigned long lstart_usecs, lcurrent_usecs, ldiff_usecs;
int fast_mode;
static int x_text_pos;

if(debug_flag)
	{
	fprintf(stdout, "get_selected_pages(): arg none\n");
	}

/* only for selected display group */
for(display_page = 0; display_page < DISPLAYS; display_page++)
	{
	/* get elapsed time */
	gettimeofday(current_timeval[display_page], NULL);

	/* calculate time from moment display was last updated */
	lcurrent_usecs =\
		current_timeval[display_page] -> tv_usec +\
		(1000000 * current_timeval[display_page] -> tv_sec);

	lstart_usecs =\
		start_timeval[display_page] -> tv_usec +\
		(1000000 * start_timeval[display_page] -> tv_sec);

	ldiff_usecs = lcurrent_usecs - lstart_usecs;

	if( (ldiff_usecs > SEQUENCE_DELAY) || mouse_page[display_page] )
		{
		fast_mode = 0;
		xacq_page(display_page, &fast_mode);

		/* set new start time */
		gettimeofday(start_timeval[display_page], NULL);

		if(! fast_mode) mouse_page[display_page] = 0;
		else mouse_page[display_page] |= 1;
		}
	}

return 1;
} /* end function get_requested_pages */


int xacq_page(int selected_display_page, int *fast_mode)
/* acquire the corresponding page */
{
int display_mem;
int retry_flag;
int missing_sequential_subpages;

/*
get one page from disk, into the selected display (0-3).
The philosophy is, that if subpage zero is requested, the user
clicked for example 400  (without specifying a subpage).
In this case first 400/0 is tried.
If this file is not present, 400/1 is tried (it could be a sequenced
page and the user did not know).
Sequenced pages start with xxx/1
If this also fails, the page is not present.
If xxx/1 is read, the subpage is incremented to xxx/2 and a timer is
set (in get_requested_pages() ).
When this timer expires the next subpage will be read and the subpage
incremented again.
If the xxx/n fails for n > 1, then n is set to 1 again, and the sequence
repeats.
It must be kept in mind that this is because all pages ARE already on disk.
So we are merely performing operations on a database.
*/
 
if(debug_flag)
	{
	fprintf(stdout,\
	"xacq_page(): arg selected_display_page=%d\n", selected_display_page);
	}

display_mem = selected_display_page + (display_group * DISPLAYS);

if(debug_flag)
	{
	printf(\
	"xacq_page():  display_mem=%d\n\
	_main_page[display_mem]=%d\n\
	_sub_page[display_mem]=%d\n\
	_man_sequence_flag[display_mem]=%d\n\
	_hold_page_flag[display_mem]=%d\n\
	",\
	display_mem,\
	_main_page[display_mem],\
	_sub_page[display_mem],\
	_man_sequence_flag[display_mem],\
	_hold_page_flag[display_mem]);
	}

/* do nothing if hold */
if (_hold_page_flag[ display_mem ] ) return 1;

retry_flag = 0;
while(1)
	{
	/* get the page */
	if( acqpag(display_mem,\
	_main_page[ display_mem ],\
	_sub_page[display_mem],\
	_man_sequence_flag[ display_mem ]) )
		{
		/* if manual ready */
		if( _man_sequence_flag[display_mem] ) return 1;

		if(_sub_page[display_mem] != 0) _sub_page[display_mem]++;
		return 1;
		}

	if(retry_flag)
		{
		return 1;
		}

	/* if manual ready */
	if( _man_sequence_flag[display_mem] )
		{
		if(_sub_page[display_mem] > 1) _sub_page[display_mem]--;

		*fast_mode = 1;
		return 1;
		}

	/* if not found and subpage zero, try auto increment */
	if(_sub_page[display_mem] == 0)
		{
		_sub_page[display_mem] = 1;

		retry_flag = 1;
		continue;
		}
	else if(_sub_page[display_mem] == 1)
		{
		_sub_page[display_mem] = 2;

		retry_flag = 1;
		continue;
		}

	/* if subpage is not zero, and not manual mode, subpage is one  */
  	_sub_page[display_mem] = 1;

	*fast_mode = 1;

	return 1;
	} /* end while acquire page */

return 1;
}/*end function xacq_page*/


int mouse_handling(int *dspmem_offset, int *selected_display_page)
{
/*following saved in between calls to this function*/
static int mode;
static int selected_page;/*the mouse was pressed on this 3 digit page nmbr*/
static int selected_subpage;
static int selected_item;
static int selected_item_tail;
static int accumulator;
static int accumulation_cnt;
static char usertext[80];
char temp[80];
int dummy;
int y;
int a, b, c, d, e;
extern int audio_volume;
FILE *exec_filefd;
static int curmode;
int x, len;

while(1)/* events queued or macro read */
	{
	if(macro_flag == MACRO_READ)	/* reading from macro file */
		{
		if( fscanf(macrofile, "%d %d %d %d %d", &a, &b, &c, &d, &e) == EOF)
			{
			fclose(macrofile);
			print_macro_status(MACRO_A, MACRO_OFF);/* macro a used as dummy */
			macro_flag = MACRO_OFF;
			return 1;
			}
		else	/*reading from macro file */
			{
			myevent.type = a;
			myevent.xbutton.button = b;
			myevent.xbutton.x = c;
			myevent.xbutton.y = d;
			text[0]= e;
			}
		/* else continue with these values */
		}/* end if macro flag == MACRO_READ */
	else /* read from user */
		{
		a = XEventsQueued(mydisplay, QueuedAfterReading);
		if(!a)break;	
		XNextEvent(mydisplay, &myevent);
		}	
	switch (myevent.type)
		{
		case MappingNotify:
			XRefreshKeyboardMapping((XMappingEvent *) &myevent);
			break;
		case ConfigureNotify:
			recalculate(myevent.xconfigure.width,\
				myevent.xconfigure.height);
			XMapSubwindows(mydisplay, topwindow);
			break;
		case ButtonPress:
			if(macro_flag == MACRO_WRITE)
				{
				if(macrofile)/* writing to macro file */
					{
 					/*
					only store left button,
					else error messages for click on macro bar in
					macro read*/
					if(myevent.xbutton.button == M_LEFT_DOWN)
						{
						mouse_flag = 1;

						fprintf(macrofile, "%d %d %d %d %d ",\
							myevent.type,\
							myevent.xbutton.button,\
							myevent.xbutton.x,\
							myevent.xbutton.y,\
							text[0]);
						}	
	 				}
 				}/* end macro write */
			mouse_click = 1;
/*
			print_cursor_status(\
			myevent.xbutton.x, myevent.xbutton.y, *dspmem_offset);
*/
			if(myevent.xbutton.button == M_LEFT_DOWN)
			/*calculate txt page from value pointing at*/
				{
				mouse_flag = 1;

				if( (mode == GET_PAGE) || (mode == GET_SUBPAGE) )
					{
					/*get what the mouse is pointing at*/
					calculate_teletext_page_and_position(\
						myevent.xbutton.x, myevent.xbutton.y,\
						&selected_item, &selected_item_tail,\
						selected_display_page, *dspmem_offset);
					/* clear any previous messages */
					print_status();

					/*range check*/
					if( (selected_item >= MACRO_A) && (selected_item <= MACRO_I) )
					/*macro read*/
					/* a click in macro bar */
						{
						if(macro_flag == MACRO_OFF)/* valid */
						    {
							temp[0] = selected_item - MACRO_A + 'A';
							temp[1] = 0;/* string termination */
							sprintf(present_macro_name,\
								 "%s/.xvtx-s/%s.mac", home_dir, temp);
							macrofile = fopen(present_macro_name, "r");
														/* a.mac, b.mac etc. */
							if(macrofile)
								{
								sprintf(temp, "READING FROM MACROFILE %s",\
								present_macro_name);
								print_in_display(*selected_display_page, temp);
								print_macro_status(selected_item, MACRO_READ);
								macro_flag = MACRO_READ;
								return 1;
								}
							print_in_display(*selected_display_page, "NO MACRO DEFINED");
							return 1;
							}/* end if valid */
						}/* end left click user on macro (macro read command) */

					/* test if click in channel bar */
//					if( (selected_item >= CHANNEL_1) && (selected_item <= CHANNEL_8) )
//						{
//						display_group = selected_item - CHANNEL_1;
//						*dspmem_offset = DISPLAYS * display_group;
//						print_channel_clickbar_status(display_group + 1);
//
//						return 1;
//						} /* end left click user on channel bar */
					if( (selected_item > 99) && (selected_item < 900) )/*valid*/
						{
						if(mode == GET_PAGE)
							{
							selected_page = selected_item;
							if(selected_item_tail != -1)/*130/1 or like that*/
								{
								selected_subpage = selected_item_tail;
								}
							else selected_subpage = 0;
							}
						}/*end valid page or page with subpage extention*/
					if(selected_item == SAVE_PAGE)
						{
						print_in_display(*selected_display_page, "SAVE name?");
						return 1;/* key event handles rest */
 						}	
					if(selected_item == LOAD_PAGE)
						{
						print_in_display(*selected_display_page, "LOAD name?");
						/* save this display page in RAM for restore function*/
						if(!put_display_page_in_ram(*selected_display_page,\
						*dspmem_offset))
							{
							return 0;/*hardware error*/
							}
						/*set hold*/
						_hold_page_flag[\
							*selected_display_page + *dspmem_offset] = 1;
						return 1;/* keyevent handles rest */
						}
					if(selected_item == ERASE_PAGE)
						{
						if(! tcls(*selected_display_page + *dspmem_offset) )
							return 0;

						print_in_display(*selected_display_page, "page erased");

						mouse_flag = 0;
						return 1;
						}

					if(selected_item == DISPLAY_GROUP_TOGGLE)
							 					/* default = 0 */
						{ 
						display_group++;
						if(display_group >= CHANNELS)
							{
							display_group = 0;
							}

						*dspmem_offset =\
						*selected_display_page + (display_group * DISPLAYS);

						sprintf(temp, "group %d", display_group);
						print_in_display(*selected_display_page, temp);

						return 1;
						}
					if(selected_item == AUTO_SEQUENCE_TOGGLE)
						{
						/* toggle flag */
						_man_sequence_flag[\
							*selected_display_page + *dspmem_offset] =\
						1 - _man_sequence_flag[\
							*selected_display_page + *dspmem_offset];

						/*
						to prevent the already incremented subpage
						displayed, decrement it if not zero, if man set 
						*/
						if(_man_sequence_flag[\
							*selected_display_page + *dspmem_offset])
							{
							print_in_display(\
							*selected_display_page, "MANUAL SEQUENCE");

							if(_sub_page[\
							*selected_display_page + *dspmem_offset] > 0)
								{
								_sub_page[\
								*selected_display_page + *dspmem_offset]--;
								return 1;
								}
							}
						else
							{
							print_in_display(\
							*selected_display_page, "AUTO SEQUENCE");
							}
						return 1;	
						}
					if(selected_item == TRY_PREVIOUS_SUBPAGE)
						{
						if(! _man_sequence_flag[\
							*selected_display_page + *dspmem_offset])
							{
							/* prevent early update */
							mouse_flag = 0;
							return 1;
							}	

						if(_sub_page[\
							*selected_display_page + *dspmem_offset] >  1)
						_sub_page[*selected_display_page + *dspmem_offset]--;

						return 1;
						}
					if(selected_item == TRY_NEXT_SUBPAGE)
						{
						if(! _man_sequence_flag[\
							*selected_display_page + *dspmem_offset])
							{
							/* prevent early update */
							mouse_flag = 0;
							return 1;
							}
						_sub_page[\
							*selected_display_page + *dspmem_offset]++;

						return 1;
						}
					if(selected_item == RESTORE_PREVIOUS_PAGE)
						{
						if(! get_display_page_from_ram(*selected_display_page,\
						*dspmem_offset, _hold_page_flag) )
							{
							return 0;/*hardware error*/
							}	
						print_in_display(\
						*selected_display_page, "PREVIOUS PAGE");

						return 1;
						}
					if(selected_item == CLEAR_ENTRY)/*clear entry*/
						{
						mode = GET_PAGE;
						selected_page = 0;
						selected_subpage = 0;
						accumulator = 0;
						accumulation_cnt = 0;
						print_in_display(\
						*selected_display_page, "Entry cleared");
						mouse_flag = 0;
//						print_status();
						return 1;
						}
					if(selected_item == REVEAL_CONCEAL_TOGGLE)
										/* default conceal*/
						{
						/* toggle */
						_reveal_flag[*selected_display_page + *dspmem_offset] =\
						1 - _reveal_flag[*selected_display_page + *dspmem_offset];
						if(_reveal_flag[*selected_display_page + *dspmem_offset] == 1)
							{
							print_in_display(*selected_display_page, "REVEAL");
							}
						if(_reveal_flag[*selected_display_page + *dspmem_offset] == 0)
							{
							print_in_display(*selected_display_page, "CONCEAL");
							}
						mouse_flag = 0;
						return 1;
						}
					if( (selected_item >= 0) && (selected_item <= 9) )/*single digit*/
						{
						accumulator = accumulator * 10 + selected_item;
						/*feedback to user*/
						if(mode == GET_PAGE)
							{
							sprintf(temp, "%03d/%03d PAGE?",\
							accumulator, selected_subpage);
							}
					
						if(mode == GET_SUBPAGE)
							{
							selected_subpage = accumulator;
							sprintf(temp, "%03d/%03d SUBPAGE?",
							selected_page, selected_subpage);
							}
						print_in_display(*selected_display_page, temp);
						accumulation_cnt++;
						if(accumulation_cnt == 3)/*3 digits could be a page*/
							{	
							/*overrule previous*/
							if(mode == GET_PAGE)
								{
								selected_page = accumulator;
								selected_subpage = 0;
								}
							accumulator = 0;
							accumulation_cnt = 0;	
							}/*end full field*/
						else /*proces next digit*/
							{
							if(accumulator > 899)/*not valid txt page or subpage*/
								{
								print_in_display(*selected_display_page, "NOT VALID");
								accumulator = 0;
								accumulation_cnt = 0;
								return 1; /* end digits, invalid selection */
								}/*end overflow*/
							continue; /* get next digit or command */
							}/*end proces next digit*/
						}/*end single digit*/
					else/*not a single digit*/
						{
						/*test if early end of subpage*/
						if(mode == GET_SUBPAGE)
							{
							accumulator = 0;
							accumulation_cnt = 0;
							}
						}/*end not a single digit*/
		
					if(selected_item == -1)/*invalid selection*/
						{
						/*
						if click not on status bar in get subpage mode,
						the subpage digit field is considered complete,
						and an acquisition is performed
						*/
						if(mode == GET_SUBPAGE)
							{
							/* clear info bar in this page */
							print_in_display(*selected_display_page, " ");
							goto acquire;
							}
						print_in_display(*selected_display_page, "NOT A PAGE");
						mouse_flag = 0;
						continue;/*do nothing*/
						}
					sprintf(temp, "%03d/%03d SUB/DEST?",\
					selected_page, selected_subpage);
					print_in_display(*selected_display_page, temp);
					mode = GET_SUBPAGE;
					continue;/*go for next mouse click*/
					}/*end mode is GET_PAGE or GET_SUBPAGE*/
				if(mode == SELECTED)	/*can get it now*/
					{
					/*calculate the new *selected_display_page from the mouse position*/
					calculate_teletext_page_and_position(\
						myevent.xbutton.x, myevent.xbutton.y,\
						&selected_item, &dummy,\
						selected_display_page, *dspmem_offset);
					/*arguments are x, y, &page, &page display, offset*/
acquire:
					/* first save this display page in RAM for restore function */
					/* save this display in ram for memory functions (F7 to F10) */
					if(! save_page_in_ram_file(*selected_display_page,\
					selected_page, selected_subpage) )

//_main_page[*selected_display_page],\
//					_sub_page[*selected_display_page]) )
						{
						return 0;/* hardware error */
						}
					/* save page in ram file for 'r' function (recall) */
					if(!put_display_page_in_ram(*selected_display_page, *dspmem_offset))
						{
						return 0;/*hardware error*/
						}
					/*
					get page in acqcir display_page
					acquire a txt page, use selected_page from first mouse click,
					and *selected_display_page from second mouse click
					*/
					_main_page[ *selected_display_page + (display_group * DISPLAYS) ] =\
					selected_page;
					_sub_page[ *selected_display_page + (display_group * DISPLAYS) ] =\
					selected_subpage;

					if(_sub_page[ *selected_display_page + (display_group * DISPLAYS) ] == 0)
						{
						/*select all subpages*/
						_man_sequence_flag[\
						*selected_display_page + (display_group * DISPLAYS)] = 0;
						}
					else
						{
						_man_sequence_flag[\
						*selected_display_page + (display_group * DISPLAYS)] = 1;
						}
					_hold_page_flag[\
					*selected_display_page + (display_group * DISPLAYS) ] = 0;
																/*no hold*/
					selected_subpage = 0;/*reset*/
					/* print status bars in all display pages */
					print_status();
					mode = GET_PAGE;
					return 1;
					}
				}/*end if left mouse button pressed*/
			if(myevent.xbutton.button == M_MIDDLE_DOWN)/*hold toggle page in selected page*/
				{
				mouse_flag = 1;

				/*find out where we are*/
				calculate_teletext_page_and_position(\
					myevent.xbutton.x, myevent.xbutton.y,\
					&dummy, &dummy,\
					selected_display_page, *dspmem_offset);

				/*togle hold for the corresponding acquisition circuit*/
				_hold_page_flag[ *selected_display_page + *dspmem_offset] =\
				1 - _hold_page_flag[ *selected_display_page + *dspmem_offset];

				/*report in destination screen*/
				print_status();

				return 1;
				}/* end if middle mouse button pressed */
			if(myevent.xbutton.button == M_RIGHT_DOWN)
				/* program vcr with times found at cursor, create macro, 
								or end 'X' mode */
				{								
				/* clear any previous messages */
				print_status();
				/* find out where we are */
				calculate_teletext_page_and_position(\
					myevent.xbutton.x, myevent.xbutton.y,\
					&selected_item, &dummy,\
					selected_display_page, *dspmem_offset);
				if( (selected_item >= MACRO_A) && (selected_item <= MACRO_I) )
				/* a click in macro bar */
					{
					if(macro_flag == MACRO_WRITE)/* close macro file */
						{
						if(macrofile)fclose(macrofile);
						sprintf(temp, "MACRO FILE %s CLOSED", present_macro_name);
						print_in_display(*selected_display_page, temp);
						print_macro_status(selected_item, MACRO_OFF);
						macro_flag = MACRO_OFF;
						return 1;
						}
					if(macro_flag == MACRO_OFF)/* open macro file for write */
					    {
						temp[0] = selected_item - MACRO_A + 'A';
						temp[1] = 0;/* string termination */
						sprintf(present_macro_name,\
							 "%s/.xvtx-s/%s.mac", home_dir, temp);
						macrofile = fopen(present_macro_name, "w");
												/* a.mac, b.mac etc. */
						if(macrofile)
							{
							sprintf(temp, "MACRO FILE %s OPEN FOR WRITE",\
							present_macro_name);
							print_in_display(*selected_display_page, temp);
							print_macro_status(selected_item, MACRO_WRITE);
							macro_flag = MACRO_WRITE;
							return 1;
							}
						sprintf(temp, "CANNOT OPEN MACRO FILE %s FOR WRITE",\
						present_macro_name);
						print_in_display(*selected_display_page, temp);
						return 1;
						}
					}/* end click in macro bar */
				if(selected_item == ERASE_PAGE)
					{
					return 0;
					}
				if(myevent.xbutton.y < 240)y = myevent.xbutton.y / charheight;
				else y = (myevent.xbutton.y - 240) / charheight;
/*
				sprintf(temp,\
				"WAS HERE myevent.xbutton.y=%d y=%d sel dsp=%d off=%d",\
				myevent.xbutton.y, y, *selected_display_page, *dspmem_offset);
				s3putmsg(0, 10, WHITE, BLUE, temp, 1);
*/
/*
				xfndtime(*selected_display_page + *dspmem_offset,\
				y, ".", *selected_display_page);
*/
				}/* end if right mouse button pressed */
			break;

		case KeyPress:
			if(macro_flag == MACRO_READ)
				{
				;/* do nothing, everything in already */
				}
			else
				{
				if (XLookupString((XKeyEvent *) &myevent,\
					text, 10, &mykey, 0) != 1)break;
				}
			if(macro_flag == MACRO_WRITE)
				{
				if(macrofile)/* writing to macro file */
					{
 					fprintf(macrofile, "%d %d %d %d %d ",\
						myevent.type,\
						myevent.xbutton.button,\
						myevent.xbutton.x,\
						myevent.xbutton.y,\
						text[0]);
	 				}
 				}/* end macro write */
			if(selected_item == SAVE_PAGE)
				{
				/*x, y, max length, selected display, string*/
				/*25 for on info bar*/
				if(curmode == 0)
					{
					x = 11;
					len = 8;
					}
				else
					{
					x = 24;
					len = 1;
					}
				if(xget_input_string_with_echo(x, 25, len,\
					*selected_display_page, usertext, text[0]) == EOF)
					/* enter was pressed */
					{
					if(! save_page(usertext, *selected_display_page,\
						 *dspmem_offset, &selected_item, &curmode) )
						{
						return 0; /* hardware error */
						}/* end user pressed enter */
					}/* end enter was pressed */
				}/* end selected_item == SAVE_PAGE */
			else if(selected_item == LOAD_PAGE)
				{
				/*x, y, max length, selected display, string*/
				/*25 for on info bar*/
				if(xget_input_string_with_echo(11, 25, 8,\
				*selected_display_page, usertext, text[0]) == EOF)
					/* enter was pressed */
					{
					/*set hold*/
			_hold_page_flag[*selected_display_page + *dspmem_offset] = 1;

					/*now load the page from disk*/
					if(! load_page(usertext, *selected_display_page,\
						 *dspmem_offset) )
						{
						}
					selected_item = 0;
					}/* end user pressed enter */

				return 1;
				}/*end selected_item == LOAD_PAGE */
			else switch(toupper(text[0]))
				{
				case ESC:/* exit xvtx disabled, dangerous if in tv mode,
							no way to switch back */
				/* exit(0);*/
					break;
				}/* end switch toupper text[0] */
			default:
				break;
			}/* end switch myevent type */
		/* handle special keys here (using key code) */	
		switch(myevent.xbutton.button)
				{		
//				case GREY_PAGE_UP:	/* saa dspmem and display_group change*/
//				case GREY_PAGE_DOWN:
				case F5:/* volume down */
					if(audio_volume > 0) audio_volume--;
					sprintf(temp, "cmix vol %d", audio_volume);
					exec_filefd = popen(temp, "r");
					pclose(exec_filefd);
					if(! exec_filefd) break;
					break;
				case F6:/* volume up */
					if(audio_volume < 100) audio_volume++;
					sprintf(temp, "cmix vol %d", audio_volume);
					exec_filefd = popen(temp, "r");
					if(! exec_filefd) break;
					pclose(exec_filefd);
					break;					
				case F7:/* display pages in ramfile home (first entry) */
					_hold_page_flag[0 + *dspmem_offset] = 1;/* set hold flag */
					load_page_from_ram_file(FIRST, 0, *dspmem_offset);
					break;
				case F8:/* display pages in ramfile up */
					_hold_page_flag[0 + *dspmem_offset] = 1;/* set hold flag */
					load_page_from_ram_file(PREVIOUS, 0, *dspmem_offset);
					break;
				case F9:/* display pages in ramfile down */
					_hold_page_flag[0 + *dspmem_offset] = 1;/* set hold flag */
					load_page_from_ram_file(NEXT, 0, *dspmem_offset);
					break;
				case F10:/* display pages in ramfile end (last entry) */
					_hold_page_flag[0 + *dspmem_offset] = 1;/* set hold flag */
					load_page_from_ram_file(LAST, 0, *dspmem_offset);
					break;
				
				}/* end switch myevent.xbuttton.button */

/*
	sprintf(temp, "x=%d y=%d b=%d k=%d",
	myevent.xbutton.x, myevent.xbutton.y, myevent.xbutton.button,\
	text[0]);
	print_in_display(0, temp);
	printf("\n%s\n", temp);
*/
	}/* end while events queued */
return 1;
}/* end function mouse handling */


int displaytxtpage()
/* 
display teletext pages in display  0 trough 3 in selected display_group.
display_group starts at zero, channels start at 1, refer to same thing.
*/
{
static int dspmem_offset;
static int flash;/* 0 if character on, 1 if off,
					toggles on call to this function */

int a, e;
int x, y, p;
int i;
int ptr, ptrb;
char cctram_data[PAGE_SPACE + 8];
char temp[2];

int fgcolor;
int bgcolor;
int graphicsflag;
int gholdflag;		/*hold graphics*/
int gsepaflag;		/*separated graphics*/
int concealflag;
int boxflag;
int soflag;			/*SO SI unknown command*/
int escapeflag;
int flashflag;
int dheightflag;	/*double height*/
int dheightline;
int posx[DISPLAYS];
int posy[DISPLAYS];
/*
remember where in this line was double height,
need to clear the x positions that were not double height in this line,
one line lower, else old data will remain visible there.
*/
char dheight_xpositions_background[COLUMNS];
int last_graphic_character;
int last_background;
int last_foreground;
int foreground;
int background;

/* select character set, global statics, used by many functions */
charheight = S14_CHAR_HEIGHT;
charwidth = S14_CHAR_WIDTH;

posx[0]=0;			  		/*top left*/
posy[0]=0;

posx[1]=(HSIZE / 2) + 1;	/*top middle, avoid overwriting window line*/
posy[1]=0;

posx[2]=0;					/*middle left, avoid overwriting window line*/
posy[2]=(VSIZE / 2) + 1;

posx[3]=(HSIZE / 2) + 1;	/*middle middle, avoid overwriting window line*/
posy[3]=(VSIZE / 2) + 1;

if(! x_initiated_flag)/* cold start */
	{
	/* print the click bar, in each display page */
	print_status();
	macro_flag = MACRO_OFF;
	print_macro_status(MACRO_A, MACRO_OFF);/* macro a used as dummy */
//	print_channel_clickbar_status(display_group + 1);

	x_initiated_flag = 3;/* prevent doing previous every time */
	}

/*
draw 4 windows
vertical in middle top to bottom*/
/*
s3unpaint_mouse must know about pixels,
only s3plot stores them in array (see xglgraphi.c)
*/
for(y = 0; y < VSIZE; y++)
	{
	s3plot(HSIZE / 2, y, WHITE);
	}
/*horizontal in middle left to right*/
for(x = 0; x < HSIZE; x++)
	{
	s3plot(x, VSIZE / 2, WHITE);
	}

//display_group = 0;

flash = 1 - flash; /* toggle */
for(p = 0; p < DISPLAYS; p++)/*display 4 dspmems*/
	{
	get_requested_pages();

	if(! pgetstr(0, 0, p + dspmem_offset, PAGLEN, cctram_data) ) return 0;
								/*error reading teletext data*/
	/* the following flags and colors are reset at the start of every page */
	/* none */
	for(y = 0; y < ROWS; y++)/*every line in txt page*/
		{
		if(! mouse_handling(&dspmem_offset, &e) )
			{
			return 0;
			}	
		if(mouse_flag) mouse_page[e] |= 1;
		mouse_flag = 0;
//		mouse_page[e] = mouse_flag;

		/* 
		mouse, x or y mode in mouse routine changes dspmem_offset from 0
		for x mode to 4 for y mode,
		dspmem_offset is initialized to 0 on first call to mouse_handling
		*/
		
		/*the following flags are reset at the start of each line*/
		graphicsflag = 0; /* not if graphics hold */
		gsepaflag = 0;
		bgcolor = BLACK;
		fgcolor = WHITE;
		escapeflag = 0;
		flashflag = 0;
		dheightflag = 0;
		concealflag = 0;
		dheightflag = 0;
		gholdflag = 0;
		boxflag = 0;
		soflag = 0;
		dheightline = 0;
		ptr = y * COLUMNS;
		for(x = 0; x < COLUMNS; x++)/*every column in txt page*/
			{
			ptrb = ptr + x;
			if(ptrb > PAGLEN)break;
			a = cctram_data[ptrb];			/*get data*/
			if(a > 31)		/*not a control character*/
				{
				/*
				0x20 trouhg 0x3f first 32 graphics characters teletext
				0x60 trough 0x7f second 32
				s14font graphics 0xa0 through 0xff (is 160 trough 255)
				first half s14font graphics at 0xa0,
				second half s14font graphics at 0xe0.
				*/
				if(graphicsflag)	/*display as graphics if valid, else text */
					{
					if( (a >= 0x20) && (a <= 0x3f) )	/* upper group */
						{
						a += (0xa0 - 0x20);/* upper half of graphics set s14font*/
						}
					if( (a >= 0x60) && (a <= 0x7f) ) /* lower group */
						{
						a += (0xe0 - 0x60);/* lower half of graphics set s14font */
						}
					} /* end graphics flag */
				/* print code here */
				temp[0] = a;
				temp[1] = 0;/* string termination */
				/*
				only print clock in display 0 display_offset 0
				date and time only correct in selected display memory,
				date starts here, followed by time,
				*/
				/*print spaces to end of line*/
//				get_saa_dspmem(&a);
//				if( ((p + dspmem_offset) != a) && (y == 0) && (x >= 21) )
//					{
//					temp[0] = ' ';/* print space */
//					}

				/* reveal handling */
				if( (! _reveal_flag[p + dspmem_offset])  &&	concealflag )
				/* not reveal request by user, and conceal by transmittor */
						{
						temp[0] = ' ';/* print space */
						}
				/* flash handling */
				/* print char if flash on, else overwrite with space */
				if( flashflag && (!flash) )/* flash was off */
					{
					temp[0] = ' ';/* print space */
					}
				/*
				do not overwrite mouse position display and macro clickbar
				in display 1 (top right)
				*/
				if( (p == 1) && ( y == 0) && (x >= 21) ){}/* do nothing */
				else
					{
					if(dheightflag)
						{
						/* remember where and what bgcolor */
						dheight_xpositions_background[x] = -1;
						s3txtdoubleputmsg(\
						posx[p] + (x * charwidth),\
						posy[p] + (y * charheight),\
						fgcolor, bgcolor, temp, gsepaflag);
						}
					else
						{
						dheight_xpositions_background[x] = bgcolor;
						s3txtputmsg(\
						posx[p] + (x * charwidth),\
						posy[p] + (y * charheight),\
						fgcolor, bgcolor, temp, gsepaflag);
						}
					}
				last_graphic_character = temp[0];/* save for graphics hold */
				last_background = bgcolor;
				last_foreground = fgcolor;
				}/* end not a control character */
			else		/* < 32 is control characters*/
				{
				concealflag = 0;/* reset conceal flag*/
				switch(a)				/*control character sort*/
					{
					case 0:
						fgcolor = BLACK;
						graphicsflag = 0;
						break;
					case 1:
						fgcolor = RED;	/* using intensified, 
										luminance of red to low to read*/
						graphicsflag = 0;
						break;
					case 2:
						fgcolor = GREEN;
						graphicsflag = 0;
						break;
					case 3:
						fgcolor = YELLOW;
						graphicsflag = 0;
						break;
					case 4:
						fgcolor = BLUE;
						graphicsflag = 0;
						break;
					case 5:
						fgcolor = MAGENTA;
						graphicsflag = 0;
						break;
					case 6:
						fgcolor = CYAN;
						graphicsflag = 0;
						break;
					case 7:
						fgcolor = WHITE;
						graphicsflag = 0;
						break;
					case 8:				/*flash*/
						flashflag = 1;
						break;
					case 9:				/*steady*/
						flashflag = 0;
						break;
					case 10:			/*end box*/
						boxflag = 0;
						break;
					case 11:			/*start box*/
						boxflag = 1;
						break;
					case 12:			/*normal height*/
						dheightflag = 0;
						break;
					case 13:			/*double height*/
						dheightflag = 1;
						dheightline = 1;/* flag if set causes next line to be 
										erased at x pos. where no dheight in
										this line */
						break;
					case 14:			/*SO unknown command*/
						soflag = 1;
						break;
					case 15:			/*SI unknown command*/
						soflag = 0;
						break;
					case 16:
						fgcolor = BLACK;
						break;
					case 17:
						fgcolor = RED;	/* using intensified,
										luminance od red to low to read */
						graphicsflag = 1;
						break;
					case 18:
						fgcolor = GREEN;
						graphicsflag = 1;
						break;
					case 19:
						fgcolor = YELLOW;
						graphicsflag = 1;
						break;
					case 20:
						fgcolor = BLUE;
						graphicsflag = 1;
						break;
					case 21:
						fgcolor = MAGENTA;
						graphicsflag = 1;
						break;
					case 22:
						fgcolor = CYAN;
						graphicsflag = 1;
						break;
					case 23:
						fgcolor = WHITE;
						graphicsflag = 1;
						break;
					case 24:
					 	concealflag = 1;
						break;
					case 25:			/*continuous graphics*/
						gsepaflag = 0;
						break;
					case 26:			/*separated graphics*/
						gsepaflag = 1;
						graphicsflag = 1;
						break;
					case 27:			/*escape*/
						escapeflag = 1;
						break;
					case 28:			/*black background*/
						bgcolor = BLACK;
						break;
					case 29:			/*new background*/
						gholdflag = 0;
						bgcolor = fgcolor;
						break;
					case 30:			/*hold graphics*/
						gholdflag = 1;
/*						graphicsflag = 1;*/
						break;
					case 31:			/*release graphics*/
						gholdflag = 0;
						break;
						}
				/*control characters appear as spaces*/
				if(gholdflag && graphicsflag)/* repeat last graphics char */
					{
					foreground = last_foreground;
					background = last_background;
					temp[0] = last_graphic_character;
					}
				else
					{
					foreground = fgcolor;
					background = bgcolor;
					temp[0] = ' ';/* space */
					}
				temp[1] = 0;/* string termination */
				/* leave channel and macro clickbar in display 1 (top right) */
//				if( (p == 1) && (y == 0) && (x >= 30) ){}/* do nothing */
				if( (p == 1) && (y == 0) && (x >= 21) ) {}
				else
					{
					if(dheightflag)
						{
						dheight_xpositions_background[x] = -1;/* remember where */
						s3txtdoubleputmsg(\
						posx[p] + (x * charwidth),\
						posy[p] + (y * charheight),\
						foreground, background, temp, gsepaflag);
						}
					else
						{
						dheight_xpositions_background[x] = background;
						s3txtputmsg(\
						posx[p] + (x * charwidth),\
						posy[p] + (y * charheight),\
						foreground, background, temp, gsepaflag);
						}
					}
				}/*end control characters*/
			}/*end for each column*/
		/* dheightline should remain to end of line */
		/* only prevents line being overwritten */
		/* dheightflag may be reset within line */
		if(dheightline)
			{
			/*
			Has now printed double height, this uses two lines,
			must clear NEXT line in x positions that where not used by
			double height, something might be there.
			*/
			y++;/* scip next line,
				it would overwrite the lower half of double height */
			for(i = 0; i < COLUMNS; i++)
				{
				if(dheight_xpositions_background[i] != -1)
									/* was not double height here */
					{
 					/* erase position */
 					s3txtputmsg(\
					posx[p] + (i * charwidth),\
					posy[p] + (y * charheight),\
					BLACK, dheight_xpositions_background[i], " ", 0);
					/* print space in correct background color */
					}
				}
			}/* end double hight erase */
		}/*end for each line*/
	}/*end for each page*/
/* print the macro clickbar in case it was not there :) */
if(macro_flag == MACRO_OFF)
	{
	print_macro_status(MACRO_A, MACRO_OFF);/* macro a used as dummy */
	}
//print_channel_clickbar_status(display_group + 1);
return 1;
}


int tcls(int m)/*clear display memory m*/
{
int i;
int base;

if(debug_flag)
	{
	fprintf(stdout, "tcls(): arg m=%d\n", m);
	}

base = PAGE_SPACE * m;
for(i = 0; i < PAGE_SPACE; i++)
	{
	data_buffer[base + i] = ' ';
	}

return 1;
}


int get_integer_value_pointed_at(int dspmem, int x, int y,\
int *selected_item, int *selected_item_tail)
/*
get value of selected_item at his position,
move back to first space to find start of field,
if non digits in field return with value set to -1
*/
{
int ptr;
char c;
char temp[COLUMNS + 2];
char iic_data[COLUMNS  + 2];
int i;
int tail_flag;/*set if '/' detected in like 130/1*/

tail_flag = 0;/*field has no tail*/

/*read in the whole line*/
if(! pgetstr(0, y, dspmem, COLUMNS, iic_data) )return 0; /* error */

/*find starting point of digits in iic_data*/
/*return these values if error or not found*/
*selected_item = -1;
*selected_item_tail = -1;
/*check if on digit, if not return ok with value -1*/
if(! isdigit(iic_data[x]) )
	{
	/*not a valid field*/
	if(iic_data[x] == '?')/* on '?' */
		{
		*selected_item = REVEAL_CONCEAL_TOGGLE;
		}
	return 1; /* ok */
	}
ptr = x;/*start from here towards zero*/
while(1)/*scan iic_data*/
	{
	c = iic_data[ptr];
	if( isdigit(c) )
		{
		if(ptr == 0)break;/*start of line, valid, pointing at first digit*/
		ptr--;
		continue;
		}
	else
		{
		ptr++;
		break;/*space found, valid, pointing at first digit*/
		}
	}/*end while scan iic_data*/
/*
sprintf(temp,"starting point found in iic_data is %d", ptr);
s3putmsg(0, 100, YELLOW, RED, temp, 1);
*/
/*
left search for digits was ok, ptr points to first digit of field
copy from start of digits in iic_data to temp until space or end of line,
found, nondigit is error
*/
while(1)
	{
	i = 0;/*ptr in temp*/
	while(1)/*copy digits to temp*/
		{
		c = iic_data[ptr];
		if( isdigit(c) )/*only copy digits*/
			{
			temp[i] = c;/*copy*/
			i++;
			if(ptr == 39)/*end of line, valid*/
				{
				temp[i] = 0;/*terminating zero*/
				break;
				}
			ptr++;
			continue;
			}
		else /*termination of digits field*/
			{
			temp[i] = 0;/*terminating zero*/
			break;
			}
		} /*end while copy digits to temp*/
	/*ptr points to last valid digit*/
	if(! tail_flag)
		{
		sscanf(temp, "%d", selected_item);/*read in value*/
		}
	else/*subpage*/
		{
		sscanf(temp, "%d", selected_item_tail);/* already a pointer! */
												/*read in value*/
		tail_flag = 0;
		return 1;
		}
	if( c == '/')
		{
		ptr++;
		tail_flag = 1;
		continue;/*get subpage*/
		}
	else return 1; /* no subpage, value set */
	} /* end while page and subpage fields */
return 1; /* ok */
}/*end function get_integer_value_pointed_at*/


int getclk(int x, int y, int *ph, int *pm, int me)
	/*get the clock into hour and minute me=cctmem*/
{
char iic_data[COLUMNS];
int h, m;
if(! pgetstr(x, y, me, 8, iic_data) )return 0;
if(! isdigit(iic_data[0]) )return 0;
h = iic_data[0] - 48;
if(! isdigit(iic_data[1]) )return 0;
h = h * 10 + (iic_data[1] - 48);
if(iic_data[2] != '.')return 0;
if(! isdigit(iic_data[3]) )return 0;
m = iic_data[3] - 48;
if(! isdigit(iic_data[4]) )return 0;
m = m * 10 + (iic_data[4] - 48);
*ph = h;
*pm = m;
return 1;
}


int pgetstr(int x, int y, int saamem, int length, char str[])
/* read cctram m row y column x length l in string str*/
{
int i;
int base;
if(debug_flag)
	{
	printf("pgetstr(): x=%d y=%d saamem=%d length=%d str=%lu\n",\
	x, y, saamem, length, str);
	}

base = (PAGE_SPACE * saamem) + (y * COLUMNS) + x;
for(i = 0; i < length; i++)
	{
	str[i] = data_buffer[base + i];
	}

return 1;
}


int tputpage(int m, char s[])
/* puts string s into cctram m */
{
int i;
int base;

if(debug_flag)
	{
	fprintf(stdout,\
	"tputpage(): arg m=%d s=%lu\n",\
	m, s);
	}

base = m * PAGE_SPACE;
for(i = 0; i < PAGE_SPACE; i++)
	{
	data_buffer[base + i] = s[i];
	}

return 1;
}


int tputstr(int x, int y, int m, char s[])
/*puts string s into column x,line y,cctram m*/
{
int i;
int base;

if(debug_flag)
	{
	fprintf(stdout,\
	"tputstr(): arg x=%d y=%d m=%d s=%s\n",\
	x, y, m, s);
	}

base = (m * PAGE_SPACE) + (y * COLUMNS) + x; 
for(i = 0; i < PAGLEN + 1; i++)
	{
	if(s[i] == 0)break;
	data_buffer[base + i] = s[i];
	}

return 1;
}


int acqpag(int dspmem, int p, int t, int mo)
/*
(display_memory, page, time, smode)
reads requested page into data_buffer
*/
{
int c, i, j;
char temp[PAGE_SPACE];
FILE *fptr;
int offset;

if(debug_flag)
	{
	fprintf(stdout,\
	"acqpag(): arg dspmem=%d p=%d t=%d mo=%d using display_group=%d\n",\
	dspmem, p, t, mo, display_group);
	}

/*clear the field*/
tputstr(0, 0, dspmem, "       ");/*the acq/display_group screen, 7 spaces, */

if(mo == 1)/*time*/
	{
	sprintf(temp, "%d", t);
	tputstr(4, 0, dspmem, temp);
	}
else
	{
	sprintf(temp,"%d", p);
	tputstr(0, 0, dspmem, temp);
	}

offset = dspmem * PAGE_SPACE;

sprintf(temp, "%s/.xcha/vtx/%3d_%02d.vtx", home_dir, p, t);
fptr = fopen(temp, "r");
if(! fptr)
	{
	if(_man_sequence_flag[ dspmem ] )
		{
		sprintf(temp, "%d/%dM nf", p, t);
		}
	else
		{
		sprintf(temp, "%d/%d nf", p, t);
		}
	for(i = 0 ; i < strlen(temp); i++)
		{
		data_buffer[offset + i] = temp[i];
		}

	return 0;
	}

j = 0;
for(i = 0; i < PAGLEN; i++)
	{
	c = getc(fptr);
	if(c == EOF) break;

	if(i < PAGE_START) continue;

	c &= 127;

	data_buffer[offset + j] = c;		
	j++;
	}
fclose(fptr);

for(i = 0; i < 11; i++)
	{
	data_buffer[offset + i] = ' ';
	} 

if(_man_sequence_flag[ dspmem ] )
	{
	sprintf(temp, "%d/%dM", p, t);
	}
else
	{
	sprintf(temp, "%d/%d", p, t);
	}
for(i = 0 ; i < strlen(temp); i++)
	{
	data_buffer[offset + i] = temp[i];
	}

return 1;
}


int user_echo(int x, int y, int fg, int bg, char buffer[], int max_length)
{
char temp[2];
int ptr;

ptr = 0;
/* print characters from buffer until 0 found */
temp[1] = 0;/*string termination*/
while(1)
   	{
   	if(ptr >= max_length)break;
 	temp[0] = buffer[ptr];
   	if(temp[0] == 0)break;/*end of buffer*/
   	s3putmsg(x + ptr * charwidth, y, fg, bg, temp, 1);
   	ptr++;
   	}
/* 
print spaces until max_length, this overwrites previous characters
after backspace
*/
while(1)
   	{
   	if(ptr >= max_length)break;
   	temp[0] = ' ';/*overwrite with space*/
   	s3putmsg(x + ptr * charwidth, y, fg, bg, temp, 1);
	ptr++;
	}
return 1;
}/*end function user_echo*/


int copy_down(char string[], int start, int space, int maxlen)
/*copy up string str from start space characters*/
{
int ptr;
char c;
/* first start + space to start, then start + space + 1 to start + 1, etc.*/
if(start < 0)return 0;/*boundary*/
ptr = start;
while(1)
	{
	if( (ptr + space) > maxlen)return 0;/*boundary*/
	c = string[ptr + space];
	string[ptr] = c;/*copy down*/
	if(c == 0)return 1;/*array termination also copied, ready*/
	ptr++;
	}
}/*end function copy_down*/


int copy_up(char string[], int start, int space, int maxlen)
/*copy up string str from start space characters*/
{
int ptr;
char c;
int top;
/*find end of string*/
top = 0;
while(1)
	{
	c = string[top];
	if(c == 0)break;/*found end*/
	top++;
	if(top > maxlen)return 0;/*error, top not found*/
	}
ptr = top;
/* first top to top + space, then top - 1 to top + space - 1, etc. */
while(1)
	{
	/*test for array boundary*/
	if( (ptr < 0) || (ptr > (maxlen - space) ) )return 0;/*error*/
	c = string[ptr];
	string[ptr + space] = c;/* copy up starting at top*/
	if(ptr == start)return 1;/*ready*/
	ptr--;
	}
return 1;/*ok*/
}/*end function copy_up*/


int move_softcursor(int x, int y)
{
unpaint_softcursor();
paint_softcursor(x, y);
return 1;
}


int unpaint_softcursor()
{
int pixel;
int dx, dy;

for(dx = 0; dx < charwidth; dx++)
	{
	for(dy = 0; dy < charheight; dy++)
		{
		if(dy == charheight - 1)
			{
			pixel = oldpixels[dx][dy];
			s3plot(oldx + dx, oldy + dy, pixel);
			}
		}
	}
return 1;
}


int paint_softcursor(int x, int y)
{
int pixel;
int dx, dy;

for(dx = 0; dx < charwidth; dx++)
	{
	for(dy = 0; dy < charheight; dy++)
		{
		pixel = s3getpixel(x + dx, y + dy);
		oldpixels[dx][dy] = pixel;
		if(dy == charheight - 1)
			{
			pixel = WHITE;
//			if(dy == charheight - 2)pixel = WHITE;/* underline */
			s3plot(x + dx, y + dy, pixel);
			}
		oldx = x;	
		oldy = y;
		}
	}
return 1;
}


int xget_input_string_with_echo(int x, int y, int max_length,\
		int selected_display_page, char buffer[], int key)
{
static int cursor_position;
int fg,bg;
static int first_time_flag;

fg = WHITE;
bg = RED;
x *= charwidth;
y *= charheight;
if(selected_display_page == 1)
	{
	x += 320;	/* 640 / 2 */
	}
if(selected_display_page == 2)
	{
	y += 240;	/* 480 / 2 */
	}
if(selected_display_page == 3)
	{
	x += 320;
	y += 240;
	}
/* the editor, mode is always insert */
if(first_time_flag || mouse_click)
	{
	buffer[0] = 0;/* mark empty */
	cursor_position = 0;
	}
if( (key == 13) || (key == 10) )/*ENTER pressed*/
	{
	/*
	set these for next time, set to zero on first start of program, 
    statics!
	*/
	first_time_flag = 1;/* reset */
	return EOF;
	}
first_time_flag = 0;
if(key == BACKSPACE)
	{
	if(cursor_position > 0)/* erase character left of cursor in buffer */
		{
		cursor_position--;
		/*copy down the buffer*/
		copy_down(buffer, cursor_position, 1, max_length);
		}
	}
if(key == DELETE)
	{
	/* erase character at cursor position */
	copy_down(buffer, cursor_position, 1, max_length);
	}
if(key ==  CU_LEFT)
	{
	if(cursor_position > 0) cursor_position--;
	}
if(key == CU_RIGHT)
	{
	if(cursor_position < strlen(buffer) )cursor_position++;
	}
if( (key > ' ') && (key < 127) )/*valid character*/
	{
	/* a valid character, insert it at cursor position */
	/* test for space */
	if( (cursor_position < max_length) && (strlen(buffer) < max_length) )
		{
		/* make space, copy up the buffer 1 */
		copy_up(buffer, cursor_position, 1, 79);
		/* insert character at cursor position */
		buffer[cursor_position] = key;
		cursor_position++;
		/*
		the buffer is now longer, if it extends beyond max_length,
		then that part must be truncated
		*/
		}	
	else  /* no space */
		{
		/* signal user */
		fprintf(stdout, "\a");
//		sbeep(22, 2000);/* 22 milliseconds at 2000 Hz */
		/* do nothing if no space */
		}
	}/* end valid character */
/* ignore other keys */
/*echo to user the buffer*/
user_echo(x, y, fg, bg, buffer, max_length);
move_softcursor(x + cursor_position * charwidth, y);
mouse_click = 0;
return 1;
}/* end function xget_input_string_with_echo */


int load_page(char name[], int selected_display_page, int dspmem_offset)
/*
reads page 'name' from disk into saamem corresponding to
selected_display_page and dspmem_offset
hold must have been set prior to this, else page will be overwritten
*/
{
FILE *infile;
int a, i;
char filename[COLUMNS];
char temp[80];
int base;

if(debug_flag)
	{
	fprintf(stdout,\
	"load_page(): arg name=%s selected_display_page=%d dspmem_offset=%d\n",\
	name, selected_display_page, dspmem_offset);
	}

strcpy(temp, name);
if(! strchr(temp, '.') ) strcat(temp,".txt");
sprintf(filename, "%s/.xvtx-s/teletext/%s", home_dir, temp);

base = PAGE_SPACE * (selected_display_page + dspmem_offset);

infile = fopen(filename, "rb");
if(! infile)
	{
	print_in_display(selected_display_page, "NOT FOUND");
	return 0;
	}

for(i = 0; i < PAGLEN; i++)
	{
	a = getc(infile);

	data_buffer[base + i] = a;

	}
fclose(infile);

sprintf(temp, "%s loaded", name);
print_in_display(selected_display_page, temp);
return 1;
}/*end function load_page*/


int save_page(char name[], int selected_display_page, int dspmem_offset,\
	int *selected_item, int *curmode)
/* 
writes  saamem corresponding to selected_display_page and dspmem_offset
to disk.
*/
{
FILE *outfile;
char temp[80];
int i;
char c;
static char filename[COLUMNS];
char iic_data[PAGE_SPACE];
int saamem;
int base;
static int mode;

#define SAVE_MODE_CLEAR			0
#define SAVE_MODE_FILE_EXISTS	1

if(debug_flag)
	{
	fprintf(stdout,\
	"save_page(): arg\n\
	 name=%s selected_display_page=%d\n\
	dspmem_offset=%d\n\
	*selected_item=%d",\
	name, selected_display_page, dspmem_offset, *selected_item);
	}

*curmode = 0;
/* test if exists */
if(mode == SAVE_MODE_CLEAR)
	{
	strcpy(temp, name);
	if(! strchr(temp, '.') ) strcat(temp,".txt");
	sprintf(filename, "%s/.xvtx-s/teletext/%s", home_dir, temp);

	outfile = fopen(filename, "rb");
	if(outfile)/*exists*/
		{
		fclose(outfile);
		print_in_display(selected_display_page,\
		"EXISTS, overwrite (y/n)?                 ");
		*curmode = 1;
		
		/* save filename in static, later 'name' will be 'y' or 'n' */

		/* back to mouse / key event loop, get response in name */ 
		mode = SAVE_MODE_FILE_EXISTS;
		return 1;
		}
	} /* end if mode SAVE_MODE_CLEAR */
else if(mode == SAVE_MODE_FILE_EXISTS)
	{
	mode = SAVE_MODE_CLEAR;
	c = toupper(name[0]);
	if(c != 'Y')
		{
		print_in_display(selected_display_page, "Cancelled");
		*selected_item = 0;
		return 1;
		}
	} /* end if mode SAVE_MODE_FILE_EXISTS */
else
	{
	*selected_item = 0;
	return 1;
	}	

*selected_item = 0;

/* create (new) */
outfile = fopen(filename, "wb");
if(! outfile)
	{
	print_in_display(selected_display_page, "CANNOT SAVE");
	return 1;
	}

saamem = selected_display_page + dspmem_offset;
/* get data from saamem */
if(!pgetstr(0, 0, saamem, PAGLEN, iic_data) )return 0;/*hardware error*/

base = PAGE_SPACE * saamem;

/* write iic_data to disk */
for(i = 0; i < PAGLEN; i++)
	{
	putc(data_buffer[base + i], outfile);
	}
fclose(outfile);

/* report to user */
sprintf(temp, "%s saved", filename);
print_in_display(selected_display_page, temp);

/* prevent retry if enter is pressed again */
return 1;
}/* end function save_page */


int put_display_page_in_ram(int selected_display_page, int dspmem_offset)
/*saves selected display page in RAM*/
{
char temp[20];
char iic_data[PAGE_SPACE];
/*x, y, dspmem(saa), lenght, char array*/
if(! pgetstr(0, 0, selected_display_page + dspmem_offset, PAGLEN, iic_data) )
	{
	return 0;
	}
sprintf(temp, "SDP%3d", selected_display_page);
/*if(! install(temp, iic_data, PAGLEN) )*/
if(! data_to_ram(temp, iic_data) )
	{
	print_in_display(selected_display_page, "NO SPACE TO STORE PAGE");
	return 0;
	}
return 1;
}


int get_display_page_from_ram(int selected_display_page, int dspmem_offset,\
int _hold_page_flag[])
{
char temp[20];
char iic_data[PAGE_SPACE];

if(debug_flag)
	{
	fprintf(stdout,\
	"get_display_page_from_ram(): arg\n\
	selected_display_page=%d dspmem_offset=%d hold_page_flag=%lu\n",\
	selected_display_page, dspmem_offset, _hold_page_flag);
	}

/*set hold for the corresponding acquisition circuit*/
_hold_page_flag[selected_display_page + dspmem_offset] = 1;

sprintf(temp,  "SDP%3d", selected_display_page);
if(! data_from_ram(temp, iic_data) )
	{
	print_in_display(selected_display_page, "NO PREVIOUS PAGE");

	return 1;
	}
/*x, y, dspmem(saa), data*/
/* the difference between tputpage and tputstr is that tputpage may contain 0 */
if(! tputpage(selected_display_page + dspmem_offset, iic_data) )
	{
	return 0;	/*hardware error*/
	}
print_in_display(selected_display_page, "PREVIOUS PAGE");
return 1;
}


int load_startup_pages()
{
int i;

for(i = 0; i < CHANNELS; i++)
	{
	_main_page[i * DISPLAYS] = 100;
	_sub_page[i * DISPLAYS] = 0;
	}

return 1;
}


int set_all_mouse_pages()
{
/* set the mouse flag in each display for the selected display group */
int i;


for(i = 0; i < DISPLAYS; i++)
	{	
	mouse_page[i] = 1;	
	}

return 1;
}

