/*xwindos version teletext and stock value aquisition program*/

#define XKRS_VERSION "Panteltje xvtx-s Version 0.2"

#define HIGHEST_CHANNEL	3
#define LOWEST_CHANNEL	1

#include "sys_head.h"

#include "xvtx.h"
#include "display.h"
#include "keys.h"
#include <getopt.h>
#include <pwd.h>

struct timeval *start_timeval[4];
struct timeval *current_timeval[4];
static int rdptr;
static int store_pages[STOREMAX];
static int store_subpages[STOREMAX];
static int store_channels[STOREMAX];
static int store_ptr;/*points in these arrays*/
FILE *fy;
int audio_volume;
int debug_flag;
char *malloc();
char *displayname = NULL;
int level = 0;
int rows = 6, columns = 7;
char *user_name;
char *home_dir;

#define TOPBORDERWIDTH 5

#define DEFAULTWIDTH	640
#define DEFAULTHEIGHT	480
#define MINWIDTH	640
#define MINHEIGHT	480

#define MINASPECTWIDTH	DEFAULTWIDTH
#define MINASPECTHEIGHT	(2 * DEFAULTHEIGHT)
#define MAXASPECTWIDTH	(2 * DEFAULTWIDTH)
#define MAXASPECTHEIGHT	DEFAULTHEIGHT

XSizeHints myhint;
XClassHint myclass;
XWMHints *mywmhints;


Colormap cmap;
int private_cmap = 0;
Cursor cursor_normal, cursor_q[4];

Pixmap qup, qupmask, qright, qrightmask, qdown, qdownmask, qleft, qleftmask;
XColor cursorforeground, cursorbackground;
int cursor_num;

#ifndef NO_SELECT
struct timeval selectval;
#endif

unsigned long valuemask;
XSetWindowAttributes attributes;


Pixmap iconpixmap;

char Title[] = XKRS_VERSION;
int c_index = 1, message_index = 0;

#define DEFAULTFONTPATTERN "*-Helvetica-Medium-R-Normal-*"
#define MAXFONTS 100
XFontStruct *fontstructarray[MAXFONTS];
int fontnum,  newposx, newposy,
    undoposx, undoposy, startposx, startposy, changeposx, changeposy;
int text1x, text2x, levely, humany, compy, movey;
int topwidth = 0, topheight = 0, boardwidth,
    buttonwidth, buttonheight, buttonspace,
    piece_dx, piece_dy, piece_width, piece_height;
int processing;

int *columnfill;

struct _rgb_vals
{
unsigned short red;
unsigned short green;
unsigned short blue;
}

color_values[8] = 
	{
		{     0,     0,     0 },	/* black*/	
		{ 65535,     0,     0 },	/* red */
		{     0, 65535,      0},	/* green */
		{     0,     0, 65535 },	/* blue */
		{     0, 65535, 65535 },	/* cyan (green + blue)*/
		{ 65535,     0, 65535 },	/* magenta (red + blue) */
		{ 65535, 65535,     0 },	/* yellow (red + green) */
		{ 65535, 65535, 65535 },	/* white (red + green + blue) */

	},
/* red = .3  green = .6  blue = .1 */
gray_values[8] = 
	{
		{     0,     0,     0 },	/* black 0 x 65535 */
		{ 19660, 19660, 19660 },	/* red .3 x 65535 */
		{ 39321, 39321, 39321 },	/* green .6 x 65535 */
		{  6553,  6553,  6553 },	/* blue .1 x 65535 */
		{ 45874, 45874, 45874 },	/* cyan (.6 + .1) x 65535 */
		{ 26214, 26214, 26214 },	/* magenta (.3 + .1) x 65535 */ 
		{ 58981, 58981, 58981 },	/* yellow (.3 +.6) x 65535 */
		{ 65535, 65535, 65535 },	/* white (.3 + .6 + .1) x 65535 */
	},
*rgb_values;

int font_cmp(p1, p2)
XFontStruct **p1, **p2;
{
  int ret = ((*p1)->max_bounds.rbearing + (*p1)->max_bounds.lbearing) -
	    ((*p2)->max_bounds.rbearing + (*p2)->max_bounds.lbearing);

  if (ret == 0)
    ret = ((*p1)->max_bounds.ascent + (*p1)->max_bounds.descent) -
	  ((*p2)->max_bounds.ascent + (*p2)->max_bounds.descent);
  return ret;
}


int save_page_in_ram_file(int cctmem, int d_page, int d_subpage)
/*
store page in ramfile, format as for function 93,
and update directory arrays.
*/
{
char iic_data[PAGE_SPACE];
char temp[50];
extern int display_group;
int display;

if(debug_flag)
	{
	fprintf(stdout,\
	"save_page_in_ram_file(): arg cctmem=%d d_page=%d d_subpage=%d\n",\
	cctmem, d_page, d_subpage);
	}

/* range check */
if(store_ptr >= STOREMAX)
	{
	sprintf(temp, "Cannot store page, store directory full");
	print_in_display(cctmem, temp);
	return 1;
	}

display = cctmem + (display_group * 4);

/* get data */
if(! pgetstr(0, 0, display, PAGLEN, iic_data) )return 0; /* hardware error */

/* make id */
sprintf(temp, "%1d%03d%03d", display_group + 1, d_page, d_subpage);

/* save in ram */
if(! data_to_ram(temp, iic_data) )
	{
	print_in_display(cctmem, "No more space in ram to store page");
	return 1;
	}
/* update pages directory */
store_pages[store_ptr] = d_page;
store_subpages[store_ptr] = d_subpage;
store_channels[store_ptr] = display_group + 1;/* global static */
store_ptr++;/*point to next position in directory*/
return 1;
}/* end function save_page_in_ramfile */


int load_page_from_ram_file(int action, int entry, int dspmem_offset)
/* reads a page from ram file into saa cctmem, action sets command */
{
char temp[80];
char pageid[20];
char iic_data[PAGE_SPACE];

/* range check */
if(store_ptr == 0)
	{
	print_in_display(0, "No pages stored in ramfile");
	return 1;
	}

/* decide what to do */
if(action == FIRST)		rdptr = 0;
if(action == PREVIOUS)	if(rdptr > 0)rdptr--;
if(action == NEXT)		if(rdptr < (store_ptr - 1) )rdptr++;
if(action == LAST)		rdptr = store_ptr - 1;
if(action == THIS)		if( (entry >= 0) && (entry <= rdptr - 1) )rdptr = entry;

/* make id */
sprintf(pageid,  "%1d%03d%03d",\
store_channels[rdptr], store_pages[rdptr], store_subpages[rdptr]);

/* get the page */
if(! data_from_ram(pageid, iic_data) )
	{
	sprintf(temp,"\nCannot find page %s in ram file", pageid);
	print_in_display(0, temp);
	return 1;
	}

/* page to cct ram display 0 (top left) */
if(! tputpage(dspmem_offset, iic_data) )return 0; /* hardware error */

/* print the info line */
sprintf(temp, "Item %d  ch %d  pg %d  subp %d  MEMORY",\
rdptr + 1,\
store_channels[rdptr], store_pages[rdptr], store_subpages[rdptr]);
print_in_display(0, temp);
return 1;
}


void change_cursor()
{
if (cursor_num == 3) cursor_num = 0;
else cursor_num++;
XDefineCursor(mydisplay, topwindow, cursor_q[cursor_num]);
}


void write_prog(ch)
char ch;
{
if (processing) XBell(mydisplay, 0);
else
	{
	processing = 1;
	cursor_num = 0;
	XDefineCursor(mydisplay, topwindow, cursor_q[0]);
	}
}


void message(newindex)
int newindex;
{
message_index = newindex;
}


void recalculate(int width, int height)
{
//int i, j, fontid, d1, d2, d3, maxtextwidth, maxtextheight;
//XCharStruct tmpsize;

if (width == topwidth && height == topheight) return;
topwidth = width;
topheight = height;
}


int main(int argc, char **argv)
{
int a, i, j;
struct passwd *userinfo;

/*defaults set here*/

/* get user info */
userinfo = getpwuid(getuid() );

/* get home directory */ 
home_dir = strsave(userinfo -> pw_dir);
user_name = strsave(userinfo -> pw_name);

/* allocate timer structures */
for(i = 0; i < 4; i++)
	{
	start_timeval[i] = malloc(sizeof(struct timeval) );
	current_timeval[i] = malloc(sizeof(struct timeval) );
	}

debug_flag = 0;

/*end defaults setting*/

while(1)
	{
	a = getopt(argc, argv, "d:h");
	if(a == -1) break;
	switch(a)
		{
		case 'd':
			displayname = malloc(strlen(optarg) + 1);
			if(! displayname)
				{
				fprintf(stdout, "Could not set displayname\n");
				exit(1);
				}
			strcpy(displayname, optarg);
			break;
		case 'h':
			fprintf(stdout,\
"Usage:\n\
krs [-h].\n\
\t-d  displayname (for example 0:0).\n\
\t-h  help (this help).\n\
");
			exit(0);	
			break;
		case '?':
			fprintf(stdout, "Unknown option `-");
			if( (optopt >= 32) && (optopt <= 127) )
				{
				fprintf(stdout, "%c\n", optopt);
				}
			else
				{
				fprintf(stdout, "Unknown option character `\\x%x'.\n",\
				optopt);
				}
			exit(1);
			break;			
		default:
			break;
		}/* end switch a */
	}/* end while getopt() */

mydisplay = XOpenDisplay(displayname);
if(! mydisplay)
	{
	fprintf(stderr, "%s: Couldn't open display.\n", displayname);
	exit(1);
	}

myscreen = DefaultScreen(mydisplay);

valuemask = 0;

a = DefaultDepth(mydisplay, myscreen);
if(a == 1)	
	{
	WHITE = YELLOW = RED = GREEN = BLUE = MAGENTA = CYAN =\
		 WhitePixel(mydisplay, myscreen);
	BLACK = BlackPixel(mydisplay, myscreen);
	}
else
	{
	Visual *vis = DefaultVisual(mydisplay, myscreen);
	if (vis->class == GrayScale || vis->class == StaticGray ||
														vis->map_entries < 5)
		{
		rgb_values = gray_values;
		}
    else
		{
		rgb_values = color_values;
		}
	cmap = DefaultColormap(mydisplay, myscreen);
	for (i = 0; i < 8; i++)
		{
		XColor color;
		color.red   = rgb_values[i].red;
		color.green = rgb_values[i].green;
		color.blue  = rgb_values[i].blue;
		color.flags = DoRed | DoGreen | DoBlue;
		retry:
		if (XAllocColor(mydisplay, cmap, &color) == 0)
			{
			if (!private_cmap)
				{
				private_cmap = 1;
				cmap = XCopyColormapAndFree(mydisplay, cmap);
				goto retry;
				}
			else
				{
				fprintf(stderr, "%s: Couldn't allocate color %d\n", *argv, i);
				exit(2);
				}
			}
		PixelArray[i] = color.pixel;
		}/* end for */
    if (private_cmap)
		{
		attributes.colormap = cmap;
		valuemask |= CWColormap;
		}
	}/*end else default depth display */


attributes.background_pixel = BLACK;
valuemask |= CWBackPixel;
attributes.border_pixel = BLACK;
valuemask |= CWBorderPixel;
attributes.cursor = cursor_normal = XCreateFontCursor(mydisplay, XC_hand2);
valuemask |= CWCursor;
attributes.event_mask = ButtonPressMask | KeyPressMask | ExposureMask | StructureNotifyMask;
valuemask |= CWEventMask;
attributes.do_not_propagate_mask = ButtonPressMask;
valuemask |= CWDontPropagate;
  
myhint.width = DEFAULTWIDTH;
myhint.height = DEFAULTHEIGHT;
myhint.flags = PSize;

myhint.x = (DisplayWidth(mydisplay, myscreen) - myhint.width) / 2;
myhint.y = (DisplayHeight(mydisplay, myscreen) - myhint.height) / 2;
myhint.flags |= PPosition;

topwindow = XCreateWindow(mydisplay, DefaultRootWindow(mydisplay),
			    myhint.x, myhint.y, myhint.width, myhint.height,
			    TOPBORDERWIDTH, CopyFromParent, InputOutput,
			    CopyFromParent, valuemask, &attributes);

xptestgc = XCreateGC(mydisplay, topwindow, 0, 0);
XSetBackground(mydisplay, xptestgc, BLACK);

myhint.min_width = MINWIDTH;
myhint.min_height = MINHEIGHT;
myhint.flags |= PMinSize;
myhint.min_aspect.x = MINASPECTWIDTH;
myhint.min_aspect.y = MINASPECTHEIGHT;
myhint.max_aspect.x = MAXASPECTWIDTH;
myhint.max_aspect.y = MAXASPECTHEIGHT;
myhint.flags |= PAspect;

XSetStandardProperties(mydisplay, topwindow, Title, Title, iconpixmap,
			 argv, argc, &myhint);

myclass.res_name = "xvtx";
myclass.res_class = "Xvtx";
XSetClassHint(mydisplay, topwindow, &myclass);

valuemask = 0;
if (DefaultDepth(mydisplay, myscreen) == 1)
	{
	unsigned int w, h, w_8;
	char *data;

	XQueryBestStipple(mydisplay, topwindow, 8, 8, &w, &h);
	if (w & 1) w *= 2;
	if (h & 1) h *= 2;
	w_8 = (w + 7) / 8;
	data = malloc(w_8 * h);
	for (j = 0; j < h; j++)
      for (i = 0; i < w_8; i++) data[j * w_8 + i] = ((j & 1) ? 0xaa : 0x55);
/*
	bgpixmap = XCreateBitmapFromData(mydisplay, topwindow, data, w, h);
	attributes.background_pixmap = bgpixmap;
*/
	valuemask |= CWBackPixmap;
	free(data);
	}
 else
	{
	attributes.background_pixel = BLACK;
	valuemask |= CWBackPixel;
	}

valuemask = 0;
attributes.background_pixel = WHITE;
valuemask |= CWBackPixel;
attributes.border_pixel = BLACK;
valuemask |= CWBorderPixel;
attributes.event_mask = ButtonPressMask | ExposureMask;
valuemask |= CWEventMask;
attributes.override_redirect = True;
valuemask |= CWOverrideRedirect;
attributes.win_gravity = UnmapGravity;
valuemask |= CWWinGravity;

recalculate(myhint.width, myhint.height);

XMapSubwindows(mydisplay, topwindow);
XMapRaised(mydisplay, topwindow);

/*
XFlush(mydisplay);
*/

/*
XDefineCursor(mydisplay, topwindow, cursor_normal);
*/

/* load page 100 for each display group (channel) */
load_startup_pages();
	
while (1)/* main loop */
	{
	if(! displaytxtpage() ) break;
	}/* end main while */

XCloseDisplay(mydisplay);

fprintf(stdout, "\n");
exit(0);
}/* end main */


