/*File panteltje graphics */

#include "xvtx.h"
#include "sys_head.h"
#include "s14font.h"
#include "txtfont.h"
#include "xglgraphi.h"
#include "display.h"
									 
#define HSIZE	640
#define VSIZE	480


char vga_memory[640 * 480];/* pixels are also stored here, s3_getpixel uses this
						for erasure of mouse cursor */
static unsigned char *font;

static int lastx, lasty;


void s3txtdoubleputmsg(int x, int y, int fg, int bg, char *text,\
	int separated_graphics)
{
unsigned char *fp;
register bits, row, column, yp, xp;
font = txtfont;
charheight = TXT_CHAR_HEIGHT;
charwidth = TXT_CHAR_WIDTH;
while (*text)
	{
	fp = font + charheight * *(unsigned char *)text;
	yp = 0;
	for (row = 0; row < charheight; row++)
		{
		bits = *fp++;
		if(separated_graphics)/* separated graphics */
			{
			if(*text < 0)/* bit 8 set, graphics */
				{
				switch(row)
					{
					case 0:
					case 3:
					case 6:
						bits &= 0;/* zero all bits */
						break;
					default:
						bits &= 119;/* zero bit 7 and bit 3 */
						break;
					}/* end switch */
				}/* end bit 8 character set */
			}/* end if separated graphics */
		yp = y + row * 2;
		/* write first row of pixels */
		for (column = 0; column < charwidth; column++)
			{
			xp = x + column;
			if(bits & (0x80 >> column))
				{
				s3plot(xp, yp, fg);
				}
			else		
				{
				s3plot(xp, yp, bg);
				}
			}/* end first row */
		/* write same row of pixels again, one position lower */
		yp++;
		for (column = 0; column < charwidth; column++)
			{
			xp = x + column;
			if(bits & (0x80 >> column))
				{
				s3plot(xp, yp, fg);
				}
			else		
				{
				s3plot(xp, yp, bg);
				}
			}
		}/* end second row */
	text++;
	x += charwidth;
	}
}


void s3txtputmsg(int x, int y, int fg, int bg, char *text,\
	int separated_graphics)
{
unsigned char *fp;
register bits, row, column, yp, xp;
font = txtfont;
charheight = TXT_CHAR_HEIGHT;
charwidth = TXT_CHAR_WIDTH;
while (*text)
	{
	fp = font + charheight * *(unsigned char *)text;
	for (row = 0; row < charheight; row++)
		{
		yp = y + row;
		bits = *fp++;
		if(separated_graphics)/* separated graphics */
			{
			if(*text < 0)/* bit 8 set, graphics */
				{
				switch(row)
					{
					case 0:
					case 3:
					case 6:
						bits &= 0;/* zero all bits */
						break;
					default:
						bits &= 119;/* zero bit 7 and bit 3 */
						break;
					}/* end switch */
				}/* end bit 8 character set */
			}/* end if separated graphics */
		for (column = 0; column < charwidth; column++)
			{
			xp = x + column;
			if(bits & (0x80 >> column))
				{
				s3plot(xp, yp, fg);
				}
			else		
				{
				s3plot(xp, yp, bg);
				}
			}
		}
	text++;
	x += charwidth;
	}
}


void s3putmsg(int x, int y, int fg, int bg, char *text, int fnt)
{
unsigned char *fp;
int fheight,fwidth;
register bits, row, column, yp, xp;

/*
if( (fnt) == 0)
	{
	font = stdchrst;
	fwidth= 8;
	fheight= 8;
	}
*/

if(( fnt) == 1)
	{
	font= s14font;
	fwidth = S14_CHAR_WIDTH;
	fheight = S14_CHAR_HEIGHT;
	}
while (*text)
	{
	fp = font + fheight * *(unsigned char *)text;
	for (row = 0; row < fheight; row++)
		{
		yp = y + row;
		bits = *fp++;
		for (column = 0; column < fwidth; column++)
			{
			xp = x + column;
			if(bits & (0x80 >> column))
				{
				s3plot(xp, yp, fg);
				}
			else		
				{
				s3plot(xp, yp, bg);
				}
			}
		}
	text++;
	x += fwidth;
	}
}


int s3getpixel(int x, int y)
{
int color;
color = vga_memory[x + y * HSIZE];
return color;
}


void s3plot(int x, int y, int color)/*plot 1 dot*/
{
static int previouscolor;
/* avoid 're appearing' at left and top */
if(x >= HSIZE)return;
if(y >= VSIZE)return;
if(color != previouscolor)
	{
	XSetForeground(mydisplay, xptestgc, color);
	previouscolor = color;
	}
/* XSetBackground(mydisplay, xptestgc, WHITE);*/
XDrawPoint(mydisplay, topwindow, xptestgc, x, y);
vga_memory[x + y * HSIZE] = color;
}
