#include "sys_head.h"
#include "xvtx.h"

struct equtab
	{
	char *text;
	char *replac;
	struct equtab *nxtentr;/*next entry to table*/
	};
static struct equtab *pnttab[EQUTABLENGTH];/*pointer table*/


struct equtab *lookup(char *s)  /*look for s in pnttab */
{
struct equtab *pa;
/*pa points to next entry*/
for(pa = pnttab[hash(s)]; pa != 0; pa = pa -> nxtentr)
	{
	if(strcmp(s, pa -> text) == 0)return pa ; /* found it */
	}
return 0 ; /*not found*/
}


struct equtab *install(char *text, char *replac, int length)
/* put (text.replac) in pnttab */
{
struct equtab *pa, *lookup();
char *charsave();
char *strsave();
int hashval;
pa = lookup(text);
if(!pa)	/* not found */
	{
	pa = (struct equtab *)malloc(sizeof(*pa));
	if(!pa)return 0;
	pa -> text = strsave(text);
	if(! pa -> text)return 0;
	hashval = hash(pa -> text);
	pa -> nxtentr = pnttab[hashval];
	pnttab[hashval] = pa;
	}
else	/*already there*/
	{
	free (pa -> replac); /*free previous defenition*/
	}
/* test for space */
pa -> replac = charsave(replac, length);
if(!pa -> replac)return 0;
return pa;
}


char *charsave(char *s, int length) /*save char array s somewhere*/
{
char *p;
int i;
p = malloc(length + 1);
if(!p)return 0;
for(i = 0; i < length; i++)
	{
	p[i] = s[i];
	}
return p;
}


char *strsave(char *s) /*save string s somewhere*/
{
char *p;
p = malloc(strlen(s) + 1);
if(!p)return 0;
strcpy(p, s);
return p;
}


int hash(s)/*form hash value for string s */
char *s;
{
int hashval;
for(hashval=0;*s != '\0';)hashval += *s++;
/* sum of ascii value of characters divived by tablesize */
return hashval % EQUTABLENGTH;
}


int data_to_ram(char id[], char iic_data[])
{
if(! install(id, iic_data, PAGLEN) )return 0;
return 1;
}


int data_from_ram(char id[], char iic_data[])
{
struct equtab *pa;
int i;
pa = lookup(id);
if(!pa) return 0;
for(i = 0; i < PAGLEN; i++)
	{
	iic_data[i] = pa -> replac[i];
	}
return 1;
}

