/*
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _XSTE_PROTO_H_
#define _XSTE_PROTO_H_


extern void get_pids(int fd, int program_number);
extern int set_main_form_file_menu_decoder();
extern int add_showview_timer(unsigned long showview);
extern char *showview_channel_id_to_channel_description(int channel_id);
extern int decode_showview_number(\
	unsigned long showview, int *channel_id, int *start_year,\
	int *start_month, int *start_day, int *start_hour, int *start_minute,\
	int *length);
extern int set_timer_length_input(int length);
extern int set_weekday_output(struct timer *pa);
extern int showview_to_inputs(unsigned long showview);
extern int update_time_and_filename(struct timer *pa);
extern int save_record_dir();
extern int save_play_dir();
extern int load_record_dir();
extern int load_play_dir();
extern int save_dirs();
extern int load_dirs();
extern int load_dirs();
extern int save_dirs();
extern int create_filename(char *program, struct timer *pa);
extern int clear_timer_form();
extern int test_timer_overlap();
extern int filename_to_timer(struct timer *pa);
extern int timer_start_recording(struct timer *pa);
extern int timer_stop_recording();
extern int delete_timer_pa(struct timer *pa);
extern int process_timers();
extern struct timer *timer_line_to_pa(int line);
extern int pa_to_timer_line(struct timer *pt, int *timer_line);
extern int month_to_digit(char *month_str);
extern int weekday_to_digit(char *weekday_str);
extern int inputs_to_timer(struct timer *pa, int update_length_field_flag);
extern int timer_to_inputs(struct timer *pa);
extern int line_to_day_and_weekly_button(int line);
extern void timer_form_directory_input_field_cb(FL_OBJECT *ob, long data);
extern void timer_form_daily_button_cb(FL_OBJECT *ob, long data);
extern void timer_form_weekly_button_cb(FL_OBJECT *ob, long data);
extern void timer_form_work_days_button_cb(FL_OBJECT *ob, long data);
extern void timer_form_start_year_input_field_cb(FL_OBJECT *ob, long data);
extern void timer_form_start_month_input_field_cb(FL_OBJECT *ob, long data);
extern void timer_form_start_day_input_field_cb(FL_OBJECT *ob, long data);
extern void timer_form_start_hour_input_field_cb(FL_OBJECT *ob, long data);
extern void timer_form_start_minute_input_field_cb(FL_OBJECT *ob, long data);
extern void timer_form_length_input_field_cb(FL_OBJECT *ob, long data);
extern void timer_form_stop_year_input_field_cb(FL_OBJECT *ob, long data);
extern void timer_form_stop_month_input_field_cb(FL_OBJECT *ob, long data);
extern void timer_form_stop_day_input_field_cb(FL_OBJECT *ob, long data);
extern void timer_form_stop_hour_input_field_cb(FL_OBJECT *ob, long data);
extern void timer_form_stop_minute_input_field_cb(FL_OBJECT *ob, long data);
extern int add_timer_to_list(int selected_line);
extern struct timer *lookup_timer(char *name);
extern struct timer *install_timer_at_end_of_list(char *name);
extern int delete_timer(char *name);
extern int delete_all_timers();
extern int sort_timers();
extern int load_timers();
extern int save_timers();
extern int show_timer_form();
extern int show_timers(int position);
extern char *line_to_timer(int line);
extern int timer_to_line(char *name, int *line);
extern int swap_timer_position(struct timer *ptop, struct timer *pbottom);
extern void timer_form_browser_cb(FL_OBJECT *ob, long data);
extern void timer_form_browser_double_cb(FL_OBJECT *ob, long data);
extern void timer_form_delete_button_cb(FL_OBJECT *ob, long data);
extern void timer_form_fontsize_up_button_cb(FL_OBJECT *ob, long data);
extern void timer_form_fontsize_down_button_cb(FL_OBJECT *ob, long data);
extern void timer_form_cancel_button_cb(FL_OBJECT *ob, long data);
extern void timer_form_accept_button_cb(FL_OBJECT *ob, long data);
extern int enable_receiver_controls(int mode);
extern int get_free_disk_space(\
	char *filename, int *megabytes, int *percentage);
extern void main_form_seek_slider_cb(FL_OBJECT *ob, long data);
extern int stop_receiver();
extern int stop_button_routine();
extern int close_all_devices();
extern void main_form_play_button_cb(FL_OBJECT *ob, long data);
extern void main_form_record_button_cb(FL_OBJECT *ob, long data);
extern void main_form_pause_button_cb(FL_OBJECT *ob, long data);
extern void main_form_stop_button_cb(FL_OBJECT *ob, long data);
extern void *recorder_routine();
extern int recorder_init();
extern int start_recorder();
extern int stop_recorder();
extern void main_form_recorder_menu_cb(FL_OBJECT *ob, long data);
extern int process_preset(int preset);
extern int set_mute();
extern int load_presets();
extern int save_presets();
extern int str_to_program(char *string, int *programnr);
extern char *get_selected_program_definition(int line);
extern int set_preset_button_label_color(int preset_nr);
extern int set_preset_button_labels();
extern void main_form_audio_mute_button_cb(FL_OBJECT *ob, long data);
extern void main_form_preset0_button_cb(FL_OBJECT *ob, long data);
extern void main_form_preset1_button_cb(FL_OBJECT *ob, long data);
extern void main_form_preset2_button_cb(FL_OBJECT *ob, long data);
extern void main_form_preset3_button_cb(FL_OBJECT *ob, long data);
extern void main_form_preset4_button_cb(FL_OBJECT *ob, long data);
extern void main_form_preset5_button_cb(FL_OBJECT *ob, long data);
extern void main_form_preset6_button_cb(FL_OBJECT *ob, long data);
extern void main_form_preset7_button_cb(FL_OBJECT *ob, long data);
extern void main_form_preset8_button_cb(FL_OBJECT *ob, long data);
extern void main_form_preset9_button_cb(FL_OBJECT *ob, long data);
extern void main_form_preset10_button_cb(FL_OBJECT *ob, long data);
extern void main_form_preset11_button_cb(FL_OBJECT *ob, long data);
extern void main_form_preset12_button_cb(FL_OBJECT *ob, long data);
extern void main_form_preset13_button_cb(FL_OBJECT *ob, long data);
extern void main_form_preset14_button_cb(FL_OBJECT *ob, long data);
extern int get_first_program_number(char *channel_name, int *prog_number);
extern int set_main_form_file_menu_adjacent();
extern int set_main_form_file_menu_decoder();
extern int set_main_form_file_menu_card_share(int mode);
extern void main_form_driver_select_button_cb(FL_OBJECT *ob, long data);
extern int set_driver_select_button(int driver);
extern void main_form_description_input_cb(FL_OBJECT *ob, long data);
extern void main_form_disecq_input_cb(FL_OBJECT *ob, long data);
extern void main_form_frequency_input_cb(FL_OBJECT *ob, long data);
extern void main_form_polarization_input_cb(FL_OBJECT *ob, long data);
extern void main_form_symbolrate_input_cb(FL_OBJECT *ob, long data);
extern void main_form_program_number_input_cb(FL_OBJECT *ob, long data);
extern void main_form_vpid_input_cb(FL_OBJECT *ob, long data);
extern void main_form_apid_input_cb(FL_OBJECT *ob, long data);
extern void main_form_tpid_input_cb(FL_OBJECT *ob, long data);
extern void main_form_signal_strength_indicator_cb(\
	FL_OBJECT *ob, long data);
extern int set_service_button(int service_type_filter);
extern void main_form_service_button_cb(FL_OBJECT *ob, long data);
extern int add_to_program_list(\
	int service_id, char *service_name, char *service_provider_name,\
	int free_ca_mode, int transport_stream_id, int frequency,\
	int service_type);
extern int scan_satellite(\
	int fd, unsigned int start_frequency, unsigned int end_frequency,\
	unsigned int start_symbolrate, unsigned int end_symbolrate,\
	unsigned int frequency_increment);
extern void main_form_scan_button_cb(FL_OBJECT *ob, long data);
extern int clear_status_line();
extern int getpids_init();
extern void getpids_start();
extern void getpids_stop();
extern void to_log(char *message);
extern int beep(int duration, int freq);
extern int sbeep(int milliseconds, int freq);
extern int beep_freq(int freq);
extern int beep_on();
extern beep_off();
extern int idle_cb(XEvent *ev, void *data);
extern int print_status();
extern int line_to_input(int line);
extern void main_form_teletext_button_cb(FL_OBJECT *ob, long data);
extern void main_form_log_messages_button_cb(FL_OBJECT *ob, long data);
extern void SetFilt(int fd, int pid);
extern int read_t(int fd, byte *buffer, int length);
extern int ParsePAT(int fd,int program_number,int *pid);
extern int ParsePMT(int fd, int pmt_pid);
extern int show_date(int date[]);
extern void *main_loop_routine();
extern set_front(void); 
extern set_diseqc_nb(int nr); 
extern set_ttpid(ushort ttpid); 
extern set_vpid(ushort vpid); 
extern set_apid(ushort apid); 
//extern tune_it(struct qpskParameters qpsk);
extern tune_it();
extern set_tp(uint *freq, int ttk, int pol, uint srate, int dis); 
extern get_front(void); 
extern int init_tuning();
extern set_ost_power_off();
extern set_pol(int polarity);
extern void set_filt(int fd, unsigned short tt_pid, dmxPesType_t t);
extern int set_channel(\
	int freqMHz, char pol, int diseqc, uint srate,\
	int vpid, int apid, int tpid, int ca, int power);
extern struct program *lookup_program(char *name);
extern struct program *install_program_at_end_of_list(char *name);
extern int delete_program(char *name);
extern int delete_all_programs();
extern int save_programs();
extern int load_programs();
extern int swap_program_position(\
	struct program *ptop, struct program *pbottom);
extern int sort_program_list(int mode);
extern int save_programs_gvideo_format();
extern int make_vdr_list();
extern int search_and_select_next_program();
extern int show_programs(int position);
extern int search_in_for(char *database, char *data, int case_sensitive);
extern char *strstr_case_insensitive(char *s, char *t);
extern int program_to_line(int programnr, int *line);
extern int add_program_in_position();
extern int save_setting(char *type, char *string);
extern char *load_setting(char *type);
extern int save_fontsizes();
extern int load_fontsizes();
extern int save_general_settings();
extern load_general_settings();
extern int set_sort_button();
extern int send_text_to_on_screen_display(char *text);
extern char *strsave(char *s);
extern int readline(FILE *file, char *contents);
extern int integer_to_fontsize(int fontsize);
extern int get_this_time(time_t this_time,
	char *weekday, char *month, int *monthday,
	int *hour, int *minute, int *second, int *year);
extern struct vdr_entry *lookup_vdr_entry(char *name);
extern struct vdr_entry *install_vdr_entry_at_end_of_list(char *name);
extern int delete_vdr_entry(char *name);
extern int delete_all_vdr_entrys();
extern int save_vdr_entries();
extern int load_vdr_entries(char *pathfilename);
extern int add_vdr_entry(
	char *name,\
	char *service_name,\
	int symbolrate,\
	int frequency,\
	char polarization,\
	int disecq,\
	int vpid,\
	int apid,\
	int tpid,\
	int ca,\
	int pnr);
extern int swap_vdr_entry_position(\
	struct vdr_entry *ptop, struct vdr_entry *pbottom);
extern int sort_vdr_entry_list(int mode);
extern unsigned long F(unsigned long R, unsigned char *K);
extern FD_xcha *create_form_main_form(void);
extern int main(int argc, char *argv[]);
extern void main_form_search_input_field_cb(FL_OBJECT *ob, long data);
extern int main_form_reset_last_found_line();
extern void main_form_beep_button_cb(FL_OBJECT *ob, long data);
extern void main_form_sort_button_cb(FL_OBJECT *ob, long data);
extern void main_form_channel_up_button_cb(FL_OBJECT *ob, long data);
extern void main_form_channel_down_button_cb(FL_OBJECT *ob, long data);
extern void main_form_apid_up_button_cb(FL_OBJECT *ob, long data);
extern void main_form_apid_down_button_cb(FL_OBJECT *ob, long data);
extern void main_form_vpid_up_button_cb(FL_OBJECT *ob, long data);
extern void main_form_vpid_down_button_cb(FL_OBJECT *ob, long data);
extern void main_form_program_number_up_button_cb(\
	FL_OBJECT *ob, long data);
extern void main_form_program_number_down_button_cb(\
	FL_OBJECT *ob, long data);
extern void main_form_tv_button_cb(FL_OBJECT *ob, long data);
extern void main_form_sort_frequency_button_cb(FL_OBJECT *ob, long data);
extern int test_for_open_forms(int *some_form_open_flag);
extern void main_form_browser_cb(FL_OBJECT *ob, long data);
extern void main_form_browser_double_cb(FL_OBJECT *ob, long data);
extern void main_form_search_button_cb(FL_OBJECT *ob, long data);
extern void main_form_search_case_button_cb(FL_OBJECT *ob, long data);
extern void main_form_volume_slider_cb(FL_OBJECT *ob, long data);
extern void main_form_delete_button_cb(FL_OBJECT *ob, long data);
extern void main_form_clear_button_cb(FL_OBJECT *ob, long data);
extern void main_form_add_button_cb(FL_OBJECT *ob, long data);
extern void main_form_file_menu_cb(FL_OBJECT *ob, long data);
extern void main_form_fontsize_up_button_cb(FL_OBJECT *ob, long data);
extern void main_form_fontsize_down_button_cb(FL_OBJECT *ob, long data);
extern void main_form_exit_switch_cb(FL_OBJECT *ob, long data);
extern int set_title();
extern int select_program(int browser_line);
extern int set_wait_indicator(int state);
extern int set_inputs(int browser_line);
extern int delete_program_line(int selected_program);

#endif /* _XSTE_PROTO_H_ */
