
/*
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "xcha.h"

extern FD_xcha *fdui;
extern FD_xcha *fd_main_form;

FL_APPEVENT_CB optimize_idle_cb;

struct timeval timeout;
time_t idletimer; /* idle time for user */
char *present_time();
int have_start_difference_flag;


void main_form_seek_slider_cb(FL_OBJECT *ob, long data)
{
seek_position = (uint64_t)play_length * fl_get_slider_value(ob);

seek_flag = 1;
}/* end function main_form_seek_slider_cb */


void main_form_description_input_cb(FL_OBJECT *ob, long data)
{
} /* end function main_form_description_input_cb */


void main_form_disecq_input_cb(FL_OBJECT *ob, long data)
{
} /* end function main_form_disecq_input_cb */


void main_form_frequency_input_cb(FL_OBJECT *ob, long data)
{
} /* end function main_form_frequency_input_cb */


void main_form_polarization_input_cb(FL_OBJECT *ob, long data)
{
} /* end function main_form_polarization_input_cb */


void main_form_symbolrate_input_cb(FL_OBJECT *ob, long data)
{
} /* end function main_form_symbolrate_input_cb */


void main_form_program_number_input_cb(FL_OBJECT *ob, long data)
{
} /* end function main_form_program_number_input_cb */


void main_form_vpid_input_cb(FL_OBJECT *ob, long data)
{
} /* end function main_form_vpid_input_cb */


void main_form_apid_input_cb(FL_OBJECT *ob, long data)
{
} /* end function main_form_apid_input_cb */


void main_form_tpid_input_cb(FL_OBJECT *ob, long data)
{
} /* end function main_form_tpid_input_cb */


void main_form_play_button_cb(FL_OBJECT *ob, long data)
{
int a;
FILE *fptr;
char temp[TEMP_SIZE];
char temp2[80];
char *ptr;

error_message_flag = 0;

/* start file browser */

/* set directory */
sprintf(temp, "%s/", play_dir);

/* set pattern */
sprintf(temp2, "*.pes");

ptr = (char *)fl_show_fselector(\
"SELECT A FILENAME", temp, "*.pes", temp2);
if(! ptr) return;

/* ptr will NOT stay allocated in xforms */
play_filename = strsave(ptr);
if(! play_filename) return;

/* get directory part of filename */
strcpy(temp, play_filename);
ptr = strrchr(temp, '/');

/* terminate string at last '/' */
if(ptr) *ptr = 0;
else
	{
	/* use home dir */
	sprintf(temp, "%s", home_dir);
	}

if(play_dir) free(play_dir);
play_dir = strsave(temp);
if(! play_dir) return;

save_dirs();

stop_button_routine();

if(! stop_receiver() ) return;

fl_set_object_color(fdui -> main_form_seek_slider, FL_COL1, FL_YELLOW);

enable_receiver_controls(0);
recorder_mode = PLAYBACK_MODE;
start_recorder();
} /* end function main_form_play_button_cb */


void main_form_record_button_cb(FL_OBJECT *ob, long data)
{
int a;
FILE *fptr;
char temp[TEMP_SIZE];
char temp2[80];
char *ptr;

error_message_flag = 0;

/* start file browser */

/* set directory */
sprintf(temp, "%s/", record_dir);

/* set pattern */
sprintf(temp2, "*.pes");

ptr = (char *)fl_show_fselector(\
"SELECT A FILENAME", temp, "*.pes", temp2);
if(! ptr) return;

/* ptr will NOT stay allocated in xforms */
record_filename = strsave(ptr);
if(! record_filename) return;

/* get directory part of filename */
strcpy(temp, record_filename);
ptr = strrchr(temp, '/');

/* terminate string at last '/' */
if(ptr) *ptr = 0;
else
	{
	/* use home dir */
	sprintf(temp, "%s", home_dir);
	}

if(record_dir) free(record_dir);
record_dir = strsave(temp);
if(! record_dir) return;

save_dirs();

/* test if file exists */
fptr = fopen(record_filename, "r");
if(fptr)
	{
	fclose(fptr);

	sprintf(temp, "%s\nexists, overwrite?", record_filename);

	/* mouse on no */
	if(! fl_show_question(temp, 0) ) return;
	} /* end if file exists */

/* stop the teletext decoder, so the dvr device is free */
stop_teletext_viewer();
stop_teletext_decoder();                 
fl_set_button(fdui -> main_form_teletext_button, 0);
save_general_settings();

stop_button_routine();

fl_set_object_color(fdui -> main_form_seek_slider, FL_WHITE, FL_RED);

enable_receiver_controls(0);
recorder_mode = RECORD_MODE;
start_recorder();
} /* end function main_form_record_button_cb */


void main_form_stop_button_cb(FL_OBJECT *ob, long data)
{
error_message_flag = 0;

if(recorder_mode == RECORD_MODE)
	{
	if(running_timer)
	 	{
		if(running_timer -> status & TIMER_RUNNING)
			{
			sprintf(error_message, "USER ABORT TIMER RECORDING");
			error_message_flag = 1;

			/* prevent restart in process_timers() */
			running_timer -> status |= TIMER_RUNNING_CANCELLED;
			} /* end if recording timer was actually running */

		return;
		} /* end if recording via timer */
	else
		{
		sprintf(error_message, "USER ABORT MANUAL RECORDING");
		error_message_flag = 1;
		}
	} /* end if record mode */

stop_button_routine();
} /* end function main_form_stop_button_cb */


void main_form_pause_button_cb(FL_OBJECT *ob, long data)
{
recorder_pause_flag = fl_get_button(ob);
} /* end function main_form_pause_button_cb */


void main_form_service_button_cb(FL_OBJECT *ob, long data)
{
service_type_filter++;
if(service_type_filter > DATA_SERVICE) service_type_filter = ANY_SERVICE;

set_service_button(service_type_filter);
 
sort_program_list(sort_mode);

show_programs(SHOW_SELECTED_IN_MIDDLE);

save_general_settings();
} /* end function main_form_service_button_cb */


void main_form_driver_select_button_cb(FL_OBJECT *ob, long data)
{
selected_driver++;
if(selected_driver > DRIVER_0_9_4) selected_driver = DRIVER_0_9_3;

set_driver_select_button(selected_driver);

save_general_settings();
} /* end function main_form_driver_select_button_cb */


void main_form_preset0_button_cb(FL_OBJECT *ob, long data)
{
process_preset(0);
} /* end function main_form_preset0_button_cb */


void main_form_preset1_button_cb(FL_OBJECT *ob, long data)
{
process_preset(1);
} /* end function main_form_preset1_button_cb */


void main_form_preset2_button_cb(FL_OBJECT *ob, long data)
{
process_preset(2);
} /* end function main_form_preset2_button_cb */


void main_form_preset3_button_cb(FL_OBJECT *ob, long data)
{
process_preset(3);
} /* end function main_form_preset3_button_cb */


void main_form_preset4_button_cb(FL_OBJECT *ob, long data)
{
process_preset(4);
} /* end function main_form_preset4_button_cb */


void main_form_preset5_button_cb(FL_OBJECT *ob, long data)
{
process_preset(5);
} /* end function main_form_preset5_button_cb */


void main_form_preset6_button_cb(FL_OBJECT *ob, long data)
{
process_preset(6);
} /* end function main_form_preset6_button_cb */


void main_form_preset7_button_cb(FL_OBJECT *ob, long data)
{
process_preset(7);
} /* end function main_form_preset7_button_cb */


void main_form_preset8_button_cb(FL_OBJECT *ob, long data)
{
process_preset(8);
} /* end function main_form_preset8_button_cb */


void main_form_preset9_button_cb(FL_OBJECT *ob, long data)
{
process_preset(9);
} /* end function main_form_preset9_button_cb */


void main_form_preset10_button_cb(FL_OBJECT *ob, long data)
{
process_preset(10);
} /* end function main_form_preset10_button_cb */


void main_form_preset11_button_cb(FL_OBJECT *ob, long data)
{
process_preset(11);
} /* end function main_form_preset11_button_cb */


void main_form_preset12_button_cb(FL_OBJECT *ob, long data)
{
process_preset(12);
} /* end function main_form_preset12_button_cb */


void main_form_preset13_button_cb(FL_OBJECT *ob, long data)
{
process_preset(13);
} /* end function main_form_preset13_button_cb */


void main_form_preset14_button_cb(FL_OBJECT *ob, long data)
{
process_preset(14);
} /* end function main_form_preset14_button_cb */


void main_form_signal_strength_indicator_cb(FL_OBJECT *ob, long data)
{
} /* end function main_form_signal_strength_indicator_cb */


extern void main_form_scan_button_cb(FL_OBJECT *ob, long data)
{
unsigned int start_frequency, end_frequency;
unsigned int start_symbolrate, end_symbolrate;
unsigned int frequency_increment;

/* mouse on no */
if(! fl_show_question(\
"This will delete your current channel list, OK?", 0) )
	{
	fl_set_button(ob, 0);
	return;
	}

switch(selected_satellite)
	{
	case SATELLITE_ASTRA:
		start_frequency = ASTRA_START_FREQUENCY;
		end_frequency = ASTRA_END_FREQUENCY;
		start_symbolrate = ASTRA_START_SYMBOLRATE;
		end_symbolrate = ASTRA_END_SYMBOLRATE;
		frequency_increment = ASTRA_SCAN_FREQUENCY_INCREMENT;
		break;
	case SATELLITE_HOTBIRD:
		start_frequency = HOTBIRD_START_FREQUENCY;
		end_frequency = HOTBIRD_END_FREQUENCY;
		start_symbolrate = HOTBIRD_START_SYMBOLRATE;
		end_symbolrate = HOTBIRD_END_SYMBOLRATE;
		frequency_increment = HOTBIRD_SCAN_FREQUENCY_INCREMENT;
		break;
	case SATELLITE_MANUAL:
		return;
		break;
	default:
		return;
		break;
	}

scan_satellite(\
	fd_frontend, start_frequency, end_frequency,\
	start_symbolrate, end_symbolrate, frequency_increment);

fl_set_button(ob, 0);

} /* end function main_form_scan_button_cb */


extern void main_form_teletext_button_cb(FL_OBJECT *ob, long data)
{
teletext_flag = fl_get_button(ob);

if(teletext_flag)
	{
//	start_telext_decoder();
	start_teletext_viewer();
	}
else
	{
	stop_teletext_viewer();
//	stop_teletext_decoder();
	}

save_general_settings();
} /* end function main_form_teletext_button_cb */


int main_form_reset_last_found_line()
{
last_found_line = 0;

return 1;
}/* end function main_form_reset_last_found_line */


void main_form_beep_button_cb(FL_OBJECT *ob, long data)
{
beep_mode = fl_get_button(ob);

if(beep_mode) beep_on();
else beep_off();

} /* end function main_form_beep_button_cb */


void main_form_sort_button_cb(FL_OBJECT *ob, long data)
{
sort_mode++;
if(sort_mode > SORT_PROVIDER) sort_mode = 0;

/* set the sort button */
set_sort_button();

sort_program_list(sort_mode);

show_programs(SHOW_SELECTED_IN_MIDDLE);

save_programs();

save_general_settings();
} /* end function main_form_sort_alpha_button_cb */


void main_form_channel_up_button_cb(FL_OBJECT *ob, long data)
{

selected_program++;

/* select program */
if(! select_program(selected_program) ) return;

/* keep entry visible */
fl_set_browser_topline(fdui -> main_form_browser, selected_program - 10);

/* save o.a. selected_program */
save_general_settings();
} /* end function main_form_channel_up_button_cb */


void main_form_channel_down_button_cb(FL_OBJECT *ob, long data)
{

if(selected_program > 0) selected_program--;

/* select program */
if(! select_program(selected_program) ) return;

/* keep entry visible */
fl_set_browser_topline(fdui -> main_form_browser, selected_program - 10);

/* save o.a. selected_program */
save_general_settings();
} /* end function main_form_channel_down_button_cb */


void main_form_audio_mute_button_cb(FL_OBJECT *ob, long data)
{
mute_flag = fl_get_button(ob);

set_mute();

} /* end function main_form_audio_mute_button_cb */


void main_form_apid_up_button_cb(FL_OBJECT *ob, long data)
{
int apid;

apid = used_apid;
apid++;
set_apid(apid);

} /* end function main_form_apid_up_button_cb */


void main_form_apid_down_button_cb(FL_OBJECT *ob, long data)
{
int apid;

apid = used_apid;
if(apid > 0) apid--;
set_apid(apid);

} /* end function main_form_apid_down_button_cb */


void main_form_vpid_up_button_cb(FL_OBJECT *ob, long data)
{
int vpid;

vpid = used_vpid;
vpid++;
set_vpid(vpid);

} /* end function main_form_vpid_up_button_cb */


void main_form_vpid_down_button_cb(FL_OBJECT *ob, long data)
{
int vpid;

vpid = used_vpid;
if(vpid > 0) vpid--;
set_vpid(vpid);

} /* end function main_form_vpid_down_button_cb */


void main_form_program_number_up_button_cb(FL_OBJECT *ob, long data)
{
set_wait_indicator(1);

clear_status_line();

stop_teletext_decoder();

clear_teletext_dir();

/* stop the getpids routine (in a thread) */
getpids_stop();

/* no more language */
language[0] = 0;
	
used_vpid = used_apid = used_tpid = 0;

program_number++;

have_pmt = 0;

/*
always read PAT then PMT to get video, audio and telext pid for
this program number
*/
if(program_number != 0)
	{
	pids_program_number = program_number;
	strcpy(report_string, "");
			
	/*
	ca routine will, if program number specified, read PAT,\
	then get PMT, and set vpid, apid, tpid
	*/
	getpids_start();
	}
else
	{
	strcpy(report_string, "");
	pids_program_number = -1;
	}

/* uses used_tpid */
if(teletext_flag) start_teletext_decoder();

set_wait_indicator(0);
} /* end function main_form_program_number_up_button_cb */


void main_form_program_number_down_button_cb(FL_OBJECT *ob, long data)
{
set_wait_indicator(1);

clear_status_line();

stop_teletext_decoder();

clear_teletext_dir();

/* stop the getpids routine (in a thread) */
getpids_stop();

/* no more language */
language[0] = 0;
	
used_vpid = used_apid = used_tpid = 0;

if(program_number > 0) program_number--;

have_pmt = 0;

/*
always read PAT then PMT to get video, audio and telext pid for
this program number
*/
if(program_number != 0)
	{
	pids_program_number = program_number;
	strcpy(report_string, "");
			
	/*
	ca routine will, if program number specified, read PAT,\
	then get PMT, and set vpid, apid, tpid
	*/
	getpids_start();
	}
else
	{
	strcpy(report_string, "");
	pids_program_number = -1;
	}

/* uses used_tpid */
if(teletext_flag) start_teletext_decoder();

set_wait_indicator(0);
} /* end function main_form_program_number_down_button_cb */
 


void main_form_tv_button_cb(FL_OBJECT *ob, long data)
{
int a;
FILE *pptr;
char temp[80];

a = fl_get_button(ob);

/* 
select computer output or PCTV1000 card output with aux as input to monitor.
*/
sprintf(temp, "tv1000 -c 0 -o %d -e", a);
pptr = popen(temp, "w");
pclose(pptr);
} /* end function main_form_tv_button_cb */


int test_for_open_forms(int *some_form_open_flag)
{
*some_form_open_flag = 0;

if(timer_form_shown_flag) 
	{
	fl_show_alert("Close timer form first (use ACCEPT)", "", "", 1);
	*some_form_open_flag = 1;
	}

return 1;
}/* end function test_for_open_forms */


void main_form_browser_cb(FL_OBJECT *ob, long data)
{
int selected_line;
char *ptr;
int status;
int depth;
int mouse_button;
int seconds;

if(debug_flag)
	{
	fprintf(stdout, "main_form_browser_cb():\n");
	}

mouse_button = fl_mouse_button();

selected_line = fl_get_browser(ob);
if(! selected_line) return;

if(mouse_button == FL_LEFT_MOUSE)
	{
	selected_program = abs(selected_line);

	/* select program */
	if(! select_program(selected_program) ) return;
	}
else if(mouse_button == FL_RIGHT_MOUSE)
	{
	add_timer_to_list(selected_line);

	return;
	}

else if(mouse_button == FL_MIDDLE_MOUSE)
	{
	return ;
	}

/* save o.a. selected_program */
save_general_settings();

}/* end function main_form_browser_cb */


void main_form_browser_double_cb(FL_OBJECT *ob, long data)
{
return;
}/* end function main_form_browser_double_cb */


void main_form_search_input_field_cb(FL_OBJECT *ob, long data)
{
main_form_reset_last_found_line();
}/* end function main_form_search_input_field_cb */


void main_form_search_button_cb(FL_OBJECT *ob, long data)
{
search_and_select_next_program();
}/* end function main_form_search_button_cb */


void main_form_search_case_button_cb(FL_OBJECT *ob, long data)
{
main_form_reset_last_found_line();
}/* end function main_form_search_case_button_cb */


void main_form_volume_slider_cb(FL_OBJECT *ob, long data)
{
FILE *pptr;
char temp[1024];

selected_volume = 100 * fl_get_slider_value(ob);

sprintf(temp, "cmix %s %d\n", MIXER_VOLUME, selected_volume);
pptr = popen(temp, "r");
pclose(pptr);

save_general_settings();
}/* end function main_form_volume_slider_cb */


void main_form_delete_button_cb(FL_OBJECT *ob, long data)
{
int total_lines;
int s_line;
int start_program;
int end_program;

if(! fl_show_question("DELETE this entry?", 0) ) return; /* mouse on NO */

total_lines = fl_get_browser_maxline(fdui -> main_form_browser);
for(s_line = 1; s_line <= total_lines; s_line++)
	{
	if(fl_isselected_browser_line(fdui -> main_form_browser, s_line) )
		{
		main_form_modified_flag = 1;

		/* finally delete structure entry */
		delete_program_line(s_line);

		/* write modified structure list to disk */
		save_programs();

		/* only one at the time */
		break;		
		}/* end selected line */
	}/* end for all lines */

show_programs(SHOW_SAME_POSITION);

/* keep entry visible */
fl_set_browser_topline(fdui -> main_form_browser, selected_program - 10);

}/* end function main_form_delete_button_cb */


void main_form_clear_button_cb(FL_OBJECT *ob, long data)
{
if(debug_flag)
	{
	fprintf(stdout, "main_form_clear_button_cb(): arg none\n");
	}

fl_set_input(fdui -> main_form_description_input, "");
fl_set_input(fdui -> main_form_disecq_input, "");
fl_set_input(fdui -> main_form_frequency_input, "");
fl_set_input(fdui -> main_form_polarization_input, "");
fl_set_input(fdui -> main_form_symbolrate_input, "");
fl_set_input(fdui -> main_form_program_number_input, "");
fl_set_input(fdui -> main_form_vpid_input, "");
fl_set_input(fdui -> main_form_apid_input, "");
fl_set_input(fdui -> main_form_tpid_input, "");

XSync(fl_get_display(), 0);

/*main_form_modified_flag = 1;*/
}/* end function main_form_clear_button_cb */


void main_form_add_button_cb(FL_OBJECT *ob, long data)
{
int s_line;

/* add the entry to the browser */
if(! add_program_in_position() ) return;

show_programs(SHOW_SAME_POSITION);

/* mark new entry in browser */
program_to_line(selected_program, &s_line);

fl_select_browser_line(fdui -> main_form_browser, s_line);

save_programs();

main_form_modified_flag = 1;
}/* end function main_form_add_button_cb */


void main_form_file_menu_cb(FL_OBJECT *ob, long data)
{
int some_form_open_flag;
int s_line;
char *ptr;
char temp[4096];
char temp2[4096];
FILE *pptr;

main_form_file_menu_selection = fl_get_menu(ob);

/* if nothing selected, but mouse in menu, no action */
if(main_form_file_menu_selection <= 0) return;

if(main_form_file_menu_selection == FILE_MENU_IMPORT_DVB2000_CHANNEL_LIST)
	{
	import_dvb2000_channel_list();

	return;
	}
else if(main_form_file_menu_selection ==\
							FILE_MENU_SEARCH_ADJACENT_FREQUENCIES)
	{
	adjacent_flag = 1 - adjacent_flag;

	set_main_form_file_menu_adjacent();		

	save_general_settings();
	}
else if(main_form_file_menu_selection == FILE_MENU_EXIT) 
	{
	/* test if any forms are open */
	if(! test_for_open_forms(&some_form_open_flag) ) return;
	if(some_form_open_flag) return;

	stop_teletext_decoder();

	exit(0);
	}

} /* end function main_form_file_menu_cb */


void main_form_recorder_menu_cb(FL_OBJECT *ob, long data)
{
int some_form_open_flag;
int s_line;
char *ptr;
char temp[4096];
char temp2[4096];
FILE *ftr;
unsigned long showview;

main_form_recorder_menu_selection = fl_get_menu(ob);

/* if nothing selected, but mouse in menu, no action */
if(main_form_recorder_menu_selection <= 0) return;

if(main_form_recorder_menu_selection == RECORDER_MENU_SET_RECORD_DIRECTORY)
	{
	ptr = (char *) fl_show_input("Record directory?", record_dir);
	if(!ptr) return;/* cancel pressed */

	/* ptr will NOT stay allocated in xforms */
	if(record_dir) free(record_dir);
	record_dir = strsave(ptr);
	if(! record_dir) return;

	save_dirs();

	return;
	}
else if(main_form_recorder_menu_selection ==\
RECORDER_MENU_PLAYBACK_DIRECTORY)
	{
	ptr = (char *) fl_show_input("Playback directory?", play_dir);
	if(!ptr) return;/* cancel pressed */

	/* ptr will NOT stay allocated in xforms */
	if(play_dir) free(play_dir);
	play_dir = strsave(ptr);
	if(! play_dir) return;

	save_dirs();
	return;
	}
else if(main_form_recorder_menu_selection == RECORDER_MENU_TIMERS)
	{
	clear_timer_form();

	show_timer_form();

	return;
	}
else if(main_form_recorder_menu_selection ==\
RECORDER_MENU_ADD_SHOWVIEW_TIMER)
	{
	ptr = (char *) fl_show_input("ShowView code?", "");
	if(!ptr) return; /* cancel pressed */

	showview = atol(ptr);
	if(showview <= 0) return;

	if(! add_showview_timer(showview) ) return;

	clear_timer_form();

	show_timer_form();

	return;
	}
else if(main_form_recorder_menu_selection ==\
RECORDER_MENU_LOG_SIGNAL_QUALITY)
	{
	log_signal_quality_flag = 1 - log_signal_quality_flag;	

	save_general_settings();
	
	return;
	}
} /* end function main_form_recorder_menu_cb */


void main_form_fontsize_up_button_cb(FL_OBJECT *ob, long data)
{
int size;

fontsizes_modified_flag = 1;
if(main_form_fontsize < 5) main_form_fontsize++;
size = integer_to_fontsize(main_form_fontsize);

fl_set_browser_fontsize(fdui -> main_form_browser, size);
//fl_set_object_lsize(fdui -> main_form_text_input_field, size);
save_fontsizes();
}/* end function main_form_fontsize_up_button_cb */


void main_form_fontsize_down_button_cb(FL_OBJECT *ob, long data)
{
int size;

fontsizes_modified_flag = 1;
if(main_form_fontsize > 0) main_form_fontsize--;
size = integer_to_fontsize(main_form_fontsize);

fl_set_browser_fontsize(fdui -> main_form_browser, size);
//fl_set_object_lsize(fdui -> main_form_text_input_field, size);

save_fontsizes();
}/* end function main_form_fontsize_down_button_cb */


void main_form_exit_switch_cb(FL_OBJECT *ob, long data)
{
int some_form_open_flag;
FILE *pptr;

/* test if any forms are open */
if(! test_for_open_forms(&some_form_open_flag) ) return;
if(some_form_open_flag) return;

stop_teletext_decoder();

exit(1);
} /* end function main_form_exit_switch_cb */


int set_title()
{
char temp[TEMP_SIZE];

sprintf(temp, "%s",\
VERSION);

fl_set_form_title(fdui -> main_form, temp);

return 1;
}/* end function set_title */


int select_program(int browser_line)
{
char temp[1024];
FILE *pptr;
struct program *pa;
int power;

if(debug_flag)
	{
	fprintf(stdout, "select_program(): arg browser_line=%d\n",\
	browser_line);
	}

/* argument check */
if(browser_line < 0) return 0;

/* find the entry in the linked list */
for(pa = programtab[0]; pa != 0; pa = pa -> nxtentr)	
	{
	if(pa -> browser_line == browser_line)
		{
		clear_status_line();

		set_wait_indicator(1);

		stop_teletext_decoder();

		clear_teletext_dir();

		/* stop the getpids routine (in a thread) */
		getpids_stop();

		/* no more language */
		language[0] = 0;
	
		used_vpid = used_apid = used_tpid = 0;

		power = 1;
		program_number = pa -> pnr;

		have_pmt = 0;

		error_message_flag = 0;
		/* tune to this channel */
		set_channel(\
			pa -> frequency,\
			pa -> polarization,\
			pa -> disecq,\
			pa -> symbolrate,\
			pa -> vpid,\
			pa -> apid,\
			pa -> tpid,\
			pa -> ca,\
			power
			);

		/*
		always read PAT then PMT to get video, audio and telext pid for
		this program number
		*/
		if( pa -> pnr != 0)
//		if(pa -> ca == 1)
			{
			pids_program_number = pa -> pnr;
			strcpy(report_string, "");
			
			/*
			ca routine will, if program number specified, read PAT,\
			then get PMT, and set vpid, apid, tpid
			*/
			getpids_start();
			}
		else
			{
			strcpy(report_string, "");
			pids_program_number = -1;
			}

//		if(pa -> tpid != 0)
		/* uses used_tpid */
		if(teletext_flag) start_teletext_decoder();

		set_wait_indicator(0);

		/* maintain visible indication that line is selected with single click */
		fl_select_browser_line(fdui -> main_form_browser, selected_program);

//		/* keep entry visible */
//		fl_set_browser_topline(fdui -> main_form_browser, selected_program - 10);

		/* set input fields */
		set_inputs(selected_program);

		return 1;
		} /* end if entry found */
	} /* end for all entries in list */

/* not found */
return 0;
}/* end function select_program */


int set_wait_indicator(int state)
{
if(debug_flag)
	{
	printf("set_wait_indicator(): arg state=%d\n", state);
	}

if(state)
	{
	fl_set_object_label(fdui -> main_form_wait_light, "WAIT");
	fl_set_object_color(fdui -> main_form_wait_light, FL_RED, FL_RED);
	}
else
	{
	fl_set_object_label(fdui -> main_form_wait_light, "");
	fl_set_object_color(fdui -> main_form_wait_light, FL_COL1, FL_COL1);
	}

XSync(fl_get_display(), 0);

return 1;
} /* end function set_wait_indicator */


int set_inputs(int browser_line)
{
struct program *pa;
char temp[80];

if(debug_flag)
	{
	printf("set_inputs(): arg browser_line=%d\n", browser_line);
	}

if(browser_line < 0) return 0;

/* find the entry in the linked list */
for(pa = programtab[0]; pa != 0; pa = pa -> nxtentr)	
	{
	if(pa -> browser_line == browser_line)
		{
		fl_set_input(fdui -> main_form_description_input,\
		pa -> service_name);

		sprintf(temp, "%d",  pa -> disecq);
		fl_set_input(fdui -> main_form_disecq_input, temp);

		sprintf(temp, "%d", pa -> frequency);
		fl_set_input(fdui -> main_form_frequency_input, temp);

		sprintf(temp, "%c", pa -> polarization);
		fl_set_input(fdui -> main_form_polarization_input, temp);

		sprintf(temp, "%d", pa -> symbolrate);
		fl_set_input(fdui -> main_form_symbolrate_input, temp);

		sprintf(temp, "%d", pa -> pnr);
		fl_set_input(fdui -> main_form_program_number_input, temp);

		sprintf(temp, "%d", pa -> vpid);
		fl_set_input(fdui -> main_form_vpid_input, temp);

		sprintf(temp, "%d", pa -> apid);
		fl_set_input(fdui -> main_form_apid_input, temp);

		sprintf(temp, "%d", pa -> tpid);
		fl_set_input(fdui -> main_form_tpid_input, temp);

		return 1;
		}
	} /* end for all entries in list */

/* not found */
return 0;
}/* end function set_inputs */


int delete_program_line(int selected_program)
{
struct program *pa;

if(debug_flag)
	{
	printf("delete_program(): arg selected_program=%d\n",\
	selected_program);
	}

if(selected_program < 0) return 0;

/* find the entry in the linked list */
for(pa = programtab[0]; pa != 0; pa = pa -> nxtentr)	
	{
	if(pa -> browser_line == selected_program)
		{
		delete_program(pa -> name);

		return 1;
		}
	} /* end for all entries in list */

/* not found */
return 0;
} /* end function delete_program_line */


int set_mute()
{
FILE *pptr;
char temp[80];

if(debug_flag)
	{
	printf("set_mute(): arg none, using mute_flag=%d\n", mute_flag);
	}

if(mute_flag)
	{
	sprintf(temp, "cmix %s 0", MIXER_VOLUME);
	}
else
	{
	sprintf(temp, "cmix %s %d", MIXER_VOLUME, selected_volume);
	}

pptr = popen(temp, "w");
pclose(pptr);

return 1;
} /* end function set_mute */


int process_preset(int preset)
{
int mouse_button;

if(debug_flag)
	{
	printf("process_preset(): arg preset=%d\n", preset);
	}

mouse_button = fl_mouse_button();

set_preset_button_label_color(preset);

if(mouse_button == FL_RIGHT_MOUSE)
	{
	selected_preset_str[preset] = \
	get_selected_program_definition(selected_program);
	set_preset_button_labels();
	}
else
	{
	str_to_program(selected_preset_str[preset], &selected_program);
	select_program(selected_program);

    if(! show_programs(SHOW_SELECTED_IN_MIDDLE) )
        {
        return;
        }
	}

save_presets();

return 1;
} /* end function process preset */


int stop_button_routine()
{
if(debug_flag)
	{
	printf("stop_button_routine(): arg none\n");
	}

if(recorder_mode == STOP_MODE) return 1;

stop_recorder();

if(recorder_mode == RECORD_MODE)
	{
	/* if we were recording, channel is still tuned */
	recorder_mode = STOP_MODE;

	/* prevent overwrite next time recording button is pressed */
	free(record_filename);
	record_filename = 0;

	/* reset the timer status */
	if(running_timer)
		{
		running_timer -> status &= ~TIMER_RUNNING;
		running_timer = 0;
		}

	return 1;	
	}
else if(recorder_mode == PLAYBACK_MODE)
	{
	/*
	if we were playing, re-start receiver and
	tune to selected channel again
	*/

	/* free the tuning devices */
	close_all_devices();

	/* try starting the receiver again */
	if(! init_tuning() )
		{
		fl_show_alert("Could not init tuning", "aborting", "", 1);

		return 0;
		}

	/* tune to the selected program */
	if(! select_program(selected_program) ) return 0;

	recorder_mode = STOP_MODE;

	return 1;
	} /* end if was playing */

} /* end function stop_button_routine */


int stop_receiver()
{
if(debug_flag)
	{
	printf("stop_receiver(): arg none\n");
	}

/* stop the teletext decoder, so the dvr device is free */
stop_teletext_viewer();
stop_teletext_decoder();             
fl_set_button(fdui -> main_form_teletext_button, 0);
save_general_settings();

/* free the ca device */
getpids_stop();
	
/* free the tuning devices */
close_all_devices();

return 1;
} /* end function stop_receiver */


extern void main_form_log_messages_button_cb(FL_OBJECT *ob, long data)
{
log_messages_flag = fl_get_button(ob);

save_general_settings();
} /* end function main_form_log_messages_button_cb */


