/*
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "xcha.h"

FD_xcha *fdui;

int main(int argc, char *argv[])
{
int a, i;
int n;
char temp[1024];
struct passwd *userinfo;
FILE *pptr;
Pixmap p, mask;
int h, w;
char channel_name[1024];
int exit_flag;

/* select con io 1 byte at the time */
setbuf(stdout, NULL);
setbuf(stdin, NULL);

//FL_IOPT fl_iopt;
    
/* some defaults */
debug_flag = 0;
tab_size = 8;
selected_satellite = SATELLITE_HOTBIRD;

/* end defaults */

/* against flashing */
/* set double buffering */
//fl_iopt.doubleBuffer = 1;
//fl_set_defaults(FL_PDDouble, &fl_iopt);
                   
start_timeval = malloc(sizeof(struct timeval) );
if(! start_timeval)
	{
	fprintf(stdout, "could not allocate space for start_timeval\n");

	exit(1);
	}

current_timeval = malloc(sizeof(struct timeval) );
if(! current_timeval)
	{
	fprintf(stdout, "could not allocate space for current_timeval\n");

	exit(1);
	}

/* get user info */
userinfo = getpwuid(getuid() );

/* get home directory */ 
home_dir = strsave(userinfo -> pw_dir);
if(! home_dir)
	{
	fprintf(stdout,\
	"main(): could allocte space for home_dir\n");
	exit(1);
	}

user_name = strsave(userinfo -> pw_name);
if(! user_name)
	{
	fprintf(stdout,\
	"main(): could allocate space for user_name\n");
	exit(1);
	}

sprintf(temp, "%s", home_dir);
record_dir = strsave(temp);
if(! record_dir)
	{
	printf("could not allocate space for record_dir\n");
	exit(1);
	}

sprintf(temp, "%s", home_dir);
play_dir = strsave(temp);
if(! play_dir)
	{
	printf("could not allocate space for play_dir\n");
	exit(1);
	}

/* for beep.c */
iopl(3);

if(! init_tuning() )
	{
	fl_show_alert("Could not init tuning", "aborting", "", 1);

	exit(1);
	}

exit_flag = 0;
channel_name[0] = 0;
while(1)
	{
	/* allow for '-shared' */
	a = getopt(argc, argv, "c:dehs:v");
	if(a == -1) break;
	switch(a)
		{
		case 'c':
			strcpy(channel_name, optarg);	
			break;
        case 'd': /* debug */
			debug_flag = 1;
			break;
		case 'e':
			exit_flag = 1;
			break;
		case 'h':
			printf(\
"Usage: xcha [-c channel name] [-d] [-h] [-shared]\n\
\t-c  channel name.\n\
\t-d  send debug output to console.\n\
\t-e  exit after tuning to channel name (first match in channels.dat).\n\
\t-h  help (this help).\n\
\t-s  shared (for < 24 bit color map sharing).\n\
\t-v  tune to Visions Europe and exit, 12092, pol H, symbolr 27500,\n\
\t    vpid 4416, apid 4417 and up, prognr 8791.\n\
");
			exit(0);	
			break;
		case 's':
			break;
		case 'v':
        /* tune to this channel */
        set_channel(\
            12092,	// freq
			'h',	// pol	
            0,		// disecq,
            27500,	// symbolrate
            4416,	// vpid
            4417,	// apid,
            0,		// tpid
            0,		// ca
			1		// power     
            );
			exit(1);
			break;
		case '?':
			if (isprint(optopt) )
 				{
 				fprintf(stdout, "Unknown option `-%c'.\n", optopt);
 				}
			else
				{
				fprintf(stdout, "Unknown option character `\\x%x'.\n",\
				optopt);
				}
			exit(1);
			break;			
		default:
			break;
		}/* end switch a */
	}/* end while getopt() */

/* set default volume for sound playback */
selected_volume = 50;

fl_initialize(&argc, argv, 0, 0, 0);
fdui = create_form_main_form();

sprintf(temp, "%s/.xcha/xcha.xpm", home_dir);
p = fl_read_pixmapfile(fl_root, temp, &w, &h, &mask, 0, 0, 0);
fl_set_form_icon(fdui -> main_form, p, mask);

/* set default fontsizes for forms */
main_form_fontsize = 3;
load_fontsizes();

/* set default settings (sets sort mode) */
load_general_settings();

load_dirs();

load_presets();

load_timers();

if(channel_name[0])
	{
	if(! get_first_program_number(channel_name, &a) )
		{
		printf("program %s not found in channels.dat\n", channel_name);

		exit(1);
		}

    if(! select_program(a) )
		{
		exit(1);
		}
	} /* end if channel name specified in command line */

/* show the main form */
fl_show_form(\
fdui -> main_form, FL_PLACE_FREE, FL_FULLBORDER, VERSION);

/* set the title of the main form to the version and the selected project */
set_title();

if(! show_programs(SHOW_SELECTED_IN_MIDDLE) ) exit(1);

/* set the sort mode button */
set_sort_button();

getpids_init();

if(exit_flag) exit(0);

teletext_decoder_init();

recorder_init();

set_preset_button_labels();

/* set mute */
mute_flag = 1;
fl_set_button(fdui -> main_form_audio_mute_button, mute_flag);
set_mute();

fl_set_slider_value(fdui -> main_form_seek_slider, 0.0);

//fl_set_object_dblbuffer(fdui -> main_form_seek_slider, 1);

fl_do_forms();

return 0;
} /* end function main */

