/*
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef FD_xcha_h_
#define FD_xcha_h_

#define _FILE_OFFSET_BITS   64

#define STRANGE_LNB
#define PCTV1000

#include <forms.h>
#include <unistd.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <time.h>
#include <sys/time.h>
#include <signal.h>
#include <setjmp.h>
#include <pwd.h>
#include <math.h>
#include <time.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <errno.h>
#include <fcntl.h>
#include <linux/soundcard.h>
#include <pthread.h>
#include <sys/poll.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <linux/types.h>
#include <setjmp.h>
#include <sys/poll.h>

#include <ost/dmx.h>
#include <ost/frontend.h>
#include <ost/sec.h>
#include <ost/video.h>
#include <ost/audio.h>

#include "program_list.h"
#include "import_dvb2000.h"
#include "dvb_formats.h"
#include "timers.h"

typedef unsigned char byte;

typedef struct {
	FL_FORM *main_form;
	FL_FORM *timer_form;

	FL_OBJECT *main_form_window_menu;
	FL_OBJECT *main_form_file_menu;
	FL_OBJECT *main_form_seek_slider;
	FL_OBJECT *main_form_recorder_menu;
	FL_OBJECT *main_form_outfield;
	FL_OBJECT *main_form_title;
	FL_OBJECT *main_form_wait_light;
	FL_OBJECT *main_form_browser;
	FL_OBJECT *main_form_search_input_field;
	FL_OBJECT *main_form_search_case_button;
	FL_OBJECT *main_form_search_button;
	FL_OBJECT *main_form_scan_button;
	FL_OBJECT *main_form_driver_select_button;
	FL_OBJECT *main_form_preset_button_group;
	FL_OBJECT *main_form_preset0_button;
	FL_OBJECT *main_form_preset1_button;
	FL_OBJECT *main_form_preset2_button;
	FL_OBJECT *main_form_preset3_button;
	FL_OBJECT *main_form_preset4_button;
	FL_OBJECT *main_form_preset5_button;
	FL_OBJECT *main_form_preset6_button;
	FL_OBJECT *main_form_preset7_button;
	FL_OBJECT *main_form_preset8_button;
	FL_OBJECT *main_form_preset9_button;
	FL_OBJECT *main_form_preset10_button;
	FL_OBJECT *main_form_preset11_button;
	FL_OBJECT *main_form_preset12_button;
	FL_OBJECT *main_form_preset13_button;
	FL_OBJECT *main_form_preset14_button;
	FL_OBJECT *main_form_signal_strength_indicator;
	FL_OBJECT *main_form_bit_error_rate_text_text_field;
	FL_OBJECT *main_form_bit_error_rate_text_field;
	FL_OBJECT *main_form_signal_strength_text_field;
	FL_OBJECT *main_form_signal_strength_text_text_field;
	FL_OBJECT *main_form_beep_button;
	FL_OBJECT *main_form_volume_slider;
	FL_OBJECT *main_form_teletext_button;
	FL_OBJECT *main_form_delete_button;
	FL_OBJECT *main_form_clear_button;
	FL_OBJECT *main_form_add_button;
	FL_OBJECT *main_form_description_input;
	FL_OBJECT *main_form_disecq_input;
	FL_OBJECT *main_form_frequency_input;
	FL_OBJECT *main_form_polarization_input;
	FL_OBJECT *main_form_symbolrate_input;
	FL_OBJECT *main_form_program_number_input;
	FL_OBJECT *main_form_vpid_input;
	FL_OBJECT *main_form_apid_input;
	FL_OBJECT *main_form_tpid_input;
	FL_OBJECT *main_form_snap_button;
	FL_OBJECT *main_form_recorder_button_group;
	FL_OBJECT *main_form_play_button;
	FL_OBJECT *main_form_record_button;
	FL_OBJECT *main_form_pause_button;
	FL_OBJECT *main_form_stop_button;
	FL_OBJECT *main_form_service_button;
	FL_OBJECT *main_form_sort_button;
	FL_OBJECT *main_form_channel_up_button;
	FL_OBJECT *main_form_channel_down_button;
	FL_OBJECT *main_form_program_number_up_button;
	FL_OBJECT *main_form_program_number_down_button;
	FL_OBJECT *main_form_log_messages_button;
	FL_OBJECT *main_form_apid_up_button;
	FL_OBJECT *main_form_apid_down_button;
	FL_OBJECT *main_form_audio_mute_button;
	FL_OBJECT *main_form_vpid_up_button;
	FL_OBJECT *main_form_vpid_down_button;
	FL_OBJECT *main_form_tv_button;
	FL_OBJECT *main_form_fontsize_up_button;
	FL_OBJECT *main_form_fontsize_down_button;
	FL_OBJECT *main_form_local_clock;
	FL_OBJECT *main_form_local_clock2;
	FL_OBJECT *main_form_exit_switch;
	
	FL_OBJECT *timer_form_title;
	FL_OBJECT *timer_form_browser;
	FL_OBJECT *timer_form_directory_input_field;
	FL_OBJECT *timer_form_filename_output_field;
	FL_OBJECT *timer_form_filename_output_field_text;  
	FL_OBJECT *timer_form_start_text_field;
	FL_OBJECT *timer_form_stop_text_field;
	FL_OBJECT *timer_form_start_year_input_field;
	FL_OBJECT *timer_form_start_month_input_field;
	FL_OBJECT *timer_form_start_day_input_field;
	FL_OBJECT *timer_form_start_hour_input_field;
	FL_OBJECT *timer_form_start_minute_input_field;
	FL_OBJECT *timer_form_start_weekday_output_field_text;
	FL_OBJECT *timer_form_start_weekday_output_field_text_text;
	FL_OBJECT *timer_form_length_input_field;
	FL_OBJECT *timer_form_showview_output_field;
	FL_OBJECT *timer_form_showview_output_field_text;
	FL_OBJECT *timer_form_stop_year_input_field;
	FL_OBJECT *timer_form_stop_month_input_field;
	FL_OBJECT *timer_form_stop_day_input_field;
	FL_OBJECT *timer_form_stop_hour_input_field;
	FL_OBJECT *timer_form_stop_minute_input_field;
	FL_OBJECT *timer_form_stop_weekday_output_field_text;
	FL_OBJECT *timer_form_daily_button;
	FL_OBJECT *timer_form_work_days_button;
	FL_OBJECT *timer_form_weekly_button;
	FL_OBJECT *timer_form_delete_button;
	FL_OBJECT *timer_form_cancel_button;
	FL_OBJECT *timer_form_accept_button;
	FL_OBJECT *timer_form_fontsize_up_button;
	FL_OBJECT *timer_form_fontsize_down_button;

} FD_xcha;

extern FD_xcha *create_form_main_form(void);
extern FD_xcha *create_form_timer_form(void);

#define READSIZE	65535
#define TEMP_SIZE	65535

/* for scanning */
#define ASTRA_START_FREQUENCY				11798
#define ASTRA_END_FREQUENCY					12730
#define ASTRA_START_SYMBOLRATE				22000
#define ASTRA_END_SYMBOLRATE				22000
#define ASTRA_SCAN_FREQUENCY_INCREMENT		10

#define HOTBIRD_START_FREQUENCY				10700
#define HOTBIRD_END_FREQUENCY				12570
#define HOTBIRD_START_SYMBOLRATE			27500
#define HOTBIRD_END_SYMBOLRATE				27500
#define HOTBIRD_SCAN_FREQUENCY_INCREMENT	10

/* for position browser display */
#define SHOW_TOP				0
#define SHOW_SAME_POSITION		1
#define SHOW_UNREAD_AT_TOP		2
#define SHOW_BOTTOM				3
#define SHOW_SELECTED_IN_MIDDLE	4

/* for status in frame browser USE 1 2 4 8 */
#define NEW_ENTRY		0
#define NO_SPACE		1
#define TOO_LONG		2
#define TXT_HOLD		4
	
/* for sorting program list */
#define SORT_ALPHA				0
#define SORT_FREQUENCY			1
#define SORT_PROGRAM_NUMBER		2
#define SORT_PROVIDER			3

/* for main form file menu */
#define FILE_MENU_IMPORT_DVB2000_CHANNEL_LIST	1
#define FILE_MENU_SEARCH_ADJACENT_FREQUENCIES	2
#define FILE_MENU_EXIT							3

/* for main form recorder menu */
#define RECORDER_MENU_SET_RECORD_DIRECTORY		1
#define RECORDER_MENU_PLAYBACK_DIRECTORY		2
#define RECORDER_MENU_TIMERS					3
#define RECORDER_MENU_ADD_SHOWVIEW_TIMER		4
#define RECORDER_MENU_LOG_SIGNAL_QUALITY		5


/* satellites, used for scan */
#define SATELLITE_MANUAL	0
#define SATELLITE_ASTRA		1
#define SATELLITE_HOTBIRD	2

/* display filters for service_type_filter */
#define ANY_SERVICE				0
#define DIGITAL_TV_SERVICE		1
#define DIGITAL_RADIO_SERVICE	2
#define TELETEXT_SERVICE		3
#define MOSAIC_SERVICE			4
#define PAL_SERVICE				5
#define SECAM_SERVICE			6
#define D_D2_MAC_SERVICE		7
#define FM_RADIO				8
#define NTSC_SERVICE			9
#define DATA_SERVICE			10

/* for signal to noise display */
#define MAX_SNR_SCALE  		20.0

/* maximum and minimum frequency beep */
#define BEEP_MINIMUM_FREQ  	200
#define BEEP_MAXIMUM_FREQ  	2000

/* for recorder */
#define STOP_MODE			0
#define RECORD_MODE			1
#define PLAYBACK_MODE		2

/* for timers (use 1, 2 ,4 ,8 etc.. ) */
#define TIMER_REPEAT_DAILY			1
#define TIMER_REPEAT_WEEKLY			2
#define TIMER_RUNNING				4
#define TIMER_EXPIRED				8
#define TIMER_OVERLAP				16
#define TIMER_ERROR					32
#define TIMER_REPEAT_WORK_DAYS		64
#define TIMER_RUNNING_CANCELLED		128
#define TIMER_REPEAT_NO				256

int debug_flag;
char *home_dir;
char *user_name;
int new_york_offset;
int fontsizes_modified_flag;
int main_form_modified_flag;
int main_form_fontsize;
int timer_form_fontsize;
int main_form_file_menu_selection;
int main_form_recorder_menu_selection;
int selected_volume;
struct timeval *start_timeval;
struct timeval *current_timeval;
int selected_program;
int current_program;
char *selected_text;
int last_found_line;
int sort_mode;
int tv_state;
int pids_program_number;
int new_program_flag;
int teletext_flag;

int used_vpid, used_apid, used_tpid;
int pmt_vpid, pmt_apid, pmt_tpid;

int fd_frontend;
int beep_mode;
int timer_form_shown_flag;
int program_number;
char language[1024];

char date_string[80];
char log_message[1024];
int tab_size;
char report_string[80];
int have_pmt;
int scan_flag;
int selected_satellite;
int adjacent_flag;

int scan_polarization;
unsigned int scan_frequency;
unsigned int scan_symbolrate;
int scan_disecq;
int nit_frequency;
int nit_transport_stream_id;
int service_type_filter;
int have_signal_flag;
int selected_driver;
int conditional_access_stop;
int conditional_access_running;
int error_message_flag;
char error_message[128];
int selected_decoder;
char *selected_preset_str[15];
int mute_flag;
char *record_filename;
char *play_filename;
char *record_dir;
char *play_dir;
int receiver_active_flag;
int recorder_mode;
int recorder_pause_flag;
int stop_button_flag;
uint64_t play_length;
uint64_t play_position;
uint64_t seek_position;
int seek_flag;
struct timer *selected_timer_pa;
int timer_overlap_flag;
char *timer_form_record_filename;
struct timer *running_timer;
double deebee;
int bit_error_rate;
int log_signal_quality_flag;
time_t recording_start_time;
int log_messages_flag;

/* for convergence driver versions */
#define DRIVER_0_9_3	0
#define DRIVER_0_9_4	1

/* for cmix the input channel the TV sound is on */
#define MIXER_VOLUME	"line1"

#define VERSION "xcha-0.6"

/* this must be last to include all definitions */
#include "xcha_proto.h"

#endif /* FD_xcha_h_ */

