/*
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "xcha.h"

FD_xcha *fdui;


FD_xcha *create_form_main_form(void)
{
FL_OBJECT *obj;

extern int idle_cb();

fdui = (FD_xcha *) fl_calloc(1, sizeof(*fdui));

fl_set_idle_callback(idle_cb, 0);

fdui -> timer_form =\
fl_bgn_form(FL_UP_BOX, 700, 500);

fdui -> timer_form_title = obj =\
	fl_add_text(FL_NORMAL_TEXT, 175, 4, 350, 25,\
	"R E C O R D I N G  T I M E R S");
	fl_set_object_lalign(obj, FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
	fl_set_object_lstyle(obj, FL_BOLD_STYLE);

fdui -> timer_form_browser = obj =\
	fl_add_browser(FL_HOLD_BROWSER, 20, 28, 558, 200, "");
	fl_set_object_color(obj, FL_WHITE, 15);
	fl_set_object_callback(obj, timer_form_browser_cb, 0);
	fl_set_browser_dblclick_callback(obj, timer_form_browser_double_cb, 0);
	fl_set_object_dblbuffer(obj, 1);

fdui -> timer_form_length_input_field = obj =\
	fl_add_input(FL_NORMAL_INPUT, 345, 390, 80, 25, "length");
	fl_set_input_return(obj, FL_RETURN_ALWAYS);
	fl_set_object_callback(obj, timer_form_length_input_field_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_WHITE);
	fl_set_object_lstyle(obj, FL_BOLD_STYLE);
	fl_set_object_lsize(obj, FL_MEDIUM_SIZE);
	fl_set_object_lalign(obj, FL_ALIGN_CENTER|FL_ALIGN_BOTTOM);
	
fdui -> timer_form_directory_input_field = obj =\
	fl_add_input(FL_NORMAL_INPUT, 20, 240, 558, 25, "directory");
	fl_set_input_return(obj, FL_RETURN_ALWAYS);
	fl_set_object_callback(obj, timer_form_directory_input_field_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_WHITE);
	fl_set_object_lstyle(obj, FL_BOLD_STYLE);
	fl_set_object_lsize(obj, FL_MEDIUM_SIZE);
	fl_set_object_lalign(obj, FL_ALIGN_CENTER|FL_ALIGN_BOTTOM);
	
fdui -> timer_form_filename_output_field = obj =\
	fl_add_text(FL_NORMAL_TEXT, 20, 290, 558, 25, "");
    fl_set_object_boxtype(obj,FL_DOWN_BOX);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
	fl_set_object_lsize(obj, FL_MEDIUM_SIZE);
    fl_set_object_lcol(obj, FL_BLACK);
    fl_set_object_color(obj, FL_SPRINGGREEN, FL_COL1);

fdui -> timer_form_filename_output_field_text = obj =\
	fl_add_box(FL_NO_BOX, 20, 315, 558, 25, "filename");
	fl_set_object_lstyle(obj,FL_BOLD_STYLE);
	fl_set_object_lsize(obj, FL_MEDIUM_SIZE);

fdui -> timer_form_start_text_field = obj =\
	fl_add_box(FL_NO_BOX, 20, 340, 40, 25, "START");
	fl_set_object_lstyle(obj, FL_BOLD_STYLE);

fdui -> timer_form_start_year_input_field = obj =\
	fl_add_input(FL_NORMAL_INPUT, 65, 340, 50, 25, "year");
	fl_set_input_return(obj, FL_RETURN_ALWAYS);
	fl_set_object_callback(obj, timer_form_start_year_input_field_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_WHITE);
	fl_set_object_lstyle(obj, FL_BOLD_STYLE);
	fl_set_object_lsize(obj, FL_MEDIUM_SIZE);
	fl_set_object_lalign(obj, FL_ALIGN_CENTER|FL_ALIGN_BOTTOM);
	
fdui -> timer_form_start_month_input_field = obj =\
	fl_add_input(FL_NORMAL_INPUT, 125, 340, 40, 25, "month");
	fl_set_input_return(obj, FL_RETURN_ALWAYS);
	fl_set_object_callback(obj, timer_form_start_month_input_field_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_WHITE);
	fl_set_object_lstyle(obj, FL_BOLD_STYLE);
	fl_set_object_lsize(obj, FL_MEDIUM_SIZE);
	fl_set_object_lalign(obj, FL_ALIGN_CENTER|FL_ALIGN_BOTTOM);	

fdui -> timer_form_start_day_input_field = obj =\
	fl_add_input(FL_NORMAL_INPUT, 175, 340, 40, 25, "day");
	fl_set_input_return(obj, FL_RETURN_ALWAYS);
	fl_set_object_callback(obj, timer_form_start_day_input_field_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_WHITE);
	fl_set_object_lstyle(obj, FL_BOLD_STYLE);
	fl_set_object_lsize(obj, FL_MEDIUM_SIZE);
	fl_set_object_lalign(obj, FL_ALIGN_CENTER|FL_ALIGN_BOTTOM);

fdui -> timer_form_start_hour_input_field = obj =\
	fl_add_input(FL_NORMAL_INPUT, 225, 340, 40, 25, "hour");
	fl_set_input_return(obj, FL_RETURN_ALWAYS);
	fl_set_object_callback(obj, timer_form_start_hour_input_field_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_WHITE);
	fl_set_object_lstyle(obj, FL_BOLD_STYLE);
	fl_set_object_lsize(obj, FL_MEDIUM_SIZE);
	fl_set_object_lalign(obj, FL_ALIGN_CENTER|FL_ALIGN_BOTTOM);
	
fdui -> timer_form_start_minute_input_field = obj =\
	fl_add_input(FL_NORMAL_INPUT, 275, 340, 40, 25, "minute");
	fl_set_input_return(obj, FL_RETURN_ALWAYS);
	fl_set_object_callback(obj, timer_form_start_minute_input_field_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_WHITE);
	fl_set_object_lstyle(obj, FL_BOLD_STYLE);
	fl_set_object_lsize(obj, FL_MEDIUM_SIZE);
	fl_set_object_lalign(obj, FL_ALIGN_CENTER|FL_ALIGN_BOTTOM);
	
fdui -> timer_form_start_weekday_output_field_text = obj =\
	fl_add_box(FL_DOWN_BOX, 335, 340, 100, 25, "");
	fl_set_object_lstyle(obj,FL_BOLD_STYLE);
	fl_set_object_lsize(obj, FL_MEDIUM_SIZE);
	fl_set_object_lcol(obj, FL_BLACK);
	fl_set_object_color(obj, FL_SPRINGGREEN, FL_COL1);

fdui -> timer_form_start_weekday_output_field_text_text = obj =\
	fl_add_box(FL_NO_BOX, 340, 362, 90, 25, "when");
	fl_set_object_lstyle(obj,FL_BOLD_STYLE);
	fl_set_object_lsize(obj, FL_MEDIUM_SIZE);

fdui -> timer_form_stop_text_field = obj =\
	fl_add_box(FL_NO_BOX, 20, 390, 40, 25, "STOP");
	fl_set_object_lstyle(obj, FL_BOLD_STYLE);

fdui -> timer_form_stop_year_input_field = obj =\
	fl_add_input(FL_NORMAL_INPUT, 65, 390, 50, 25, "year");
	fl_set_input_return(obj, FL_RETURN_ALWAYS);
	fl_set_object_callback(obj, timer_form_stop_year_input_field_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_WHITE);
	fl_set_object_lstyle(obj, FL_BOLD_STYLE);
	fl_set_object_lsize(obj, FL_MEDIUM_SIZE);
	fl_set_object_lalign(obj, FL_ALIGN_CENTER|FL_ALIGN_BOTTOM);
	
fdui -> timer_form_stop_month_input_field = obj =\
	fl_add_input(FL_NORMAL_INPUT, 125, 390, 40, 25, "month");
	fl_set_input_return(obj, FL_RETURN_ALWAYS);
	fl_set_object_callback(obj, timer_form_stop_month_input_field_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_WHITE);
	fl_set_object_lstyle(obj, FL_BOLD_STYLE);
	fl_set_object_lsize(obj, FL_MEDIUM_SIZE);
	fl_set_object_lalign(obj, FL_ALIGN_CENTER|FL_ALIGN_BOTTOM);
	
fdui -> timer_form_stop_day_input_field = obj =\
	fl_add_input(FL_NORMAL_INPUT, 175, 390, 40, 25, "day");
	fl_set_input_return(obj, FL_RETURN_ALWAYS);
	fl_set_object_callback(obj, timer_form_stop_day_input_field_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_WHITE);
	fl_set_object_lstyle(obj, FL_BOLD_STYLE);
	fl_set_object_lsize(obj, FL_MEDIUM_SIZE);
	fl_set_object_lalign(obj, FL_ALIGN_CENTER|FL_ALIGN_BOTTOM);
	
fdui -> timer_form_stop_hour_input_field = obj =\
	fl_add_input(FL_NORMAL_INPUT, 225, 390, 40, 25, "hour");
	fl_set_input_return(obj, FL_RETURN_ALWAYS);
	fl_set_object_callback(obj, timer_form_stop_hour_input_field_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_WHITE);
	fl_set_object_lstyle(obj, FL_BOLD_STYLE);
	fl_set_object_lsize(obj, FL_MEDIUM_SIZE);
	fl_set_object_lalign(obj, FL_ALIGN_CENTER|FL_ALIGN_BOTTOM);
	
fdui -> timer_form_stop_minute_input_field = obj =\
	fl_add_input(FL_NORMAL_INPUT, 275, 390, 40, 25, "minute");
	fl_set_input_return(obj, FL_RETURN_ALWAYS);
	fl_set_object_callback(obj, timer_form_stop_minute_input_field_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_WHITE);
	fl_set_object_lstyle(obj, FL_BOLD_STYLE);
	fl_set_object_lsize(obj, FL_MEDIUM_SIZE);
	fl_set_object_lalign(obj, FL_ALIGN_CENTER|FL_ALIGN_BOTTOM);
	
fdui -> timer_form_showview_output_field = obj =\
	fl_add_text(FL_NORMAL_TEXT, 485, 340, 90, 25, "");
    fl_set_object_boxtype(obj,FL_DOWN_BOX);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
	fl_set_object_lsize(obj, FL_MEDIUM_SIZE);
    fl_set_object_lcol(obj, FL_BLACK);
    fl_set_object_color(obj, FL_SPRINGGREEN, FL_COL1);

fdui -> timer_form_showview_output_field_text = obj =\
	fl_add_box(FL_NO_BOX, 485, 362, 90, 25, "showview");
	fl_set_object_lstyle(obj,FL_BOLD_STYLE);
	fl_set_object_lsize(obj, FL_MEDIUM_SIZE);

fdui -> timer_form_daily_button = obj =\
	fl_add_button(FL_PUSH_BUTTON, 590, 50, 90, 30, "DAILY");
	fl_set_object_callback(obj, timer_form_daily_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_DARKORANGE);

fdui -> timer_form_work_days_button = obj =\
	fl_add_button(FL_PUSH_BUTTON, 590, 100, 90, 30, "WORK DAYS");
	fl_set_object_callback(obj, timer_form_work_days_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, 10); // mat blue

fdui -> timer_form_weekly_button = obj =\
	fl_add_button(FL_PUSH_BUTTON, 590, 150, 90, 30, "WEEKLY");
	fl_set_object_callback(obj, timer_form_weekly_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_CYAN);

fdui -> timer_form_delete_button = obj =\
	fl_add_button(FL_NORMAL_BUTTON, 590, 290, 90, 30, "DELETE");
	fl_set_object_callback(obj, timer_form_delete_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_RED);

fdui -> timer_form_cancel_button = obj =\
	fl_add_button(FL_NORMAL_BUTTON, 20, 460, 90, 30, "CANCEL");
	fl_set_object_callback(obj, timer_form_cancel_button_cb, 0);

fdui -> timer_form_accept_button = obj =\
	fl_add_button(FL_NORMAL_BUTTON, 590, 460, 90, 30, "ACCEPT");
	fl_set_object_callback(obj, timer_form_accept_button_cb, 0);
	
fdui -> timer_form_fontsize_up_button = obj =\
	fl_add_button(FL_NORMAL_BUTTON, 500, 460, 20, 20, "-");
	fl_set_object_callback(obj, timer_form_fontsize_down_button_cb, 0);

fdui -> timer_form_fontsize_down_button = obj =\
	fl_add_button(FL_NORMAL_BUTTON, 530, 460, 20, 20, "+");
	fl_set_object_callback(obj, timer_form_fontsize_up_button_cb, 0);

fl_end_form(); /* timer_form */


fdui -> main_form =\
	fl_bgn_form(FL_NO_BOX, 790, 570);
	obj = fl_add_box(FL_UP_BOX, 0, 0, 790, 570,"");
	fl_set_object_lsize(obj,FL_HUGE_SIZE);
	fl_set_object_lstyle(obj,FL_FIXEDBOLDITALIC_STYLE + FL_EMBOSSED_STYLE);

fdui -> main_form_title = obj =\
	fl_add_text(FL_NORMAL_TEXT, 145, 4, 500, 30,\
	"Panteltje (c)\nxcha-no-crypt");
	fl_set_object_lalign(obj, FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
	fl_set_object_lstyle(obj, FL_BOLD_STYLE);
	fl_set_object_lsize(obj, FL_NORMAL_SIZE);

fdui -> main_form_browser = obj =\
	fl_add_browser(FL_HOLD_BROWSER, 20, 120, 650, 270, "");
	fl_set_object_color(obj, FL_WHITE, 15);
	fl_set_object_callback(obj, main_form_browser_cb, 0);
	fl_set_browser_dblclick_callback(obj, main_form_browser_double_cb, 0);
	fl_set_object_dblbuffer(obj, 1);
	fl_set_browser_fontsize(obj, FL_MEDIUM_SIZE); 

fdui -> main_form_search_input_field = obj =\
	fl_add_input(FL_NORMAL_INPUT, 300, 80, 160, 30, "Search\nkeywords");
	fl_set_input_return(obj, FL_RETURN_CHANGED);
	fl_set_object_callback(obj, main_form_search_input_field_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_WHITE);
	fl_set_object_lstyle(obj, FL_BOLD_STYLE);
	fl_set_object_lsize(obj, FL_MEDIUM_SIZE);
	
fdui -> main_form_search_case_button = obj =\
	fl_add_button(FL_PUSH_BUTTON, 480, 80, 90, 30, "CASE SENS");
	fl_set_object_callback(obj, main_form_search_case_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_DARKORANGE);

fdui -> main_form_driver_select_button = obj =\
	fl_add_button(FL_NORMAL_BUTTON, 120, 30, 90, 30, "");
	fl_set_object_callback(obj, main_form_driver_select_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_DARKORANGE);
	fl_hide_object(obj);

fdui -> main_form_preset_button_group =\
fl_bgn_group();

fdui -> main_form_preset0_button = obj =\
	fl_add_button(FL_RADIO_BUTTON, 80, 40, 30, 30, "PRG\n0");
	fl_set_object_callback(obj, main_form_preset0_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_BLUE);

fdui -> main_form_preset1_button = obj =\
	fl_add_button(FL_RADIO_BUTTON, 120, 40, 30, 30, "PRG\n1");
	fl_set_object_callback(obj, main_form_preset1_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_BLUE);

fdui -> main_form_preset2_button = obj =\
	fl_add_button(FL_RADIO_BUTTON, 160, 40, 30, 30, "PRG\n2");
	fl_set_object_callback(obj, main_form_preset2_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_BLUE);

fdui -> main_form_preset3_button = obj =\
	fl_add_button(FL_RADIO_BUTTON, 200, 40, 30, 30, "PRG\n3");
	fl_set_object_callback(obj, main_form_preset3_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_BLUE);

fdui -> main_form_preset4_button = obj =\
	fl_add_button(FL_RADIO_BUTTON, 240, 40, 30, 30, "PRG\n4");
	fl_set_object_callback(obj, main_form_preset4_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_BLUE);

fdui -> main_form_preset5_button = obj =\
	fl_add_button(FL_RADIO_BUTTON, 280, 40, 30, 30, "PRG\n5");
	fl_set_object_callback(obj, main_form_preset5_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_BLUE);

fdui -> main_form_preset6_button = obj =\
	fl_add_button(FL_RADIO_BUTTON, 320, 40, 30, 30, "PRG\n6");
	fl_set_object_callback(obj, main_form_preset6_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_BLUE);

fdui -> main_form_preset7_button = obj =\
	fl_add_button(FL_RADIO_BUTTON, 360, 40, 30, 30, "PRG\n7");
	fl_set_object_callback(obj, main_form_preset7_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_BLUE);

fdui -> main_form_preset8_button = obj =\
	fl_add_button(FL_RADIO_BUTTON, 400, 40, 30, 30, "PRG\n8");
	fl_set_object_callback(obj, main_form_preset8_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_BLUE);

fdui -> main_form_preset9_button = obj =\
	fl_add_button(FL_RADIO_BUTTON, 440, 40, 30, 30, "PRG\n9");
	fl_set_object_callback(obj, main_form_preset9_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_BLUE);

fdui -> main_form_preset10_button = obj =\
	fl_add_button(FL_RADIO_BUTTON, 480, 40, 30, 30, "PRG\n10");
	fl_set_object_callback(obj, main_form_preset10_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_BLUE);

fdui -> main_form_preset11_button = obj =\
	fl_add_button(FL_RADIO_BUTTON, 520, 40, 30, 30, "PRG\n11");
	fl_set_object_callback(obj, main_form_preset11_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_BLUE);

fdui -> main_form_preset12_button = obj =\
	fl_add_button(FL_RADIO_BUTTON, 560, 40, 30, 30, "PRG\n12");
	fl_set_object_callback(obj, main_form_preset12_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_BLUE);

fdui -> main_form_preset13_button = obj =\
	fl_add_button(FL_RADIO_BUTTON, 600, 40, 30, 30, "PRG\n13");
	fl_set_object_callback(obj, main_form_preset13_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_BLUE);

fdui -> main_form_preset14_button = obj =\
	fl_add_button(FL_RADIO_BUTTON, 640, 40, 30, 30, "PRG\n14");
	fl_set_object_callback(obj, main_form_preset14_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_BLUE);

fl_end_group();

fdui -> main_form_scan_button = obj =\
	fl_add_button(FL_PUSH_BUTTON, 580, 30, 90, 30, "SCAN");
	fl_set_object_callback(obj, main_form_scan_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_RED);
	fl_hide_object(obj);

fdui -> main_form_search_button = obj =\
	fl_add_button(FL_NORMAL_BUTTON, 580, 80, 90, 30, "SEARCH");
	fl_set_object_callback(obj, main_form_search_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_GREEN);

fdui -> main_form_volume_slider = obj =\
	fl_add_slider(FL_HOR_FILL_SLIDER, 680, 120, 90, 30, "VOLUME");
//	fl_set_object_lalign(obj, FL_ALIGN_INSIDE);
	fl_set_slider_return(obj, FL_RETURN_ALWAYS);
	fl_set_object_color(obj, FL_COL1, FL_GREEN);
	fl_set_object_callback(obj, main_form_volume_slider_cb, 0);

fdui -> main_form_audio_mute_button = obj =\
	fl_add_button(FL_PUSH_BUTTON, 680, 164, 90, 30, "MUTE");
	fl_set_object_callback(obj, main_form_audio_mute_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_YELLOW);
	fl_set_object_shortcut(obj, "-", 1);

fdui -> main_form_signal_strength_indicator = obj =\
	fl_add_dial(FL_FILL_DIAL, 680, 30, 60, 60, "S/N ratio");
	fl_set_object_callback(obj, main_form_signal_strength_indicator_cb, 0);
    fl_set_dial_bounds(obj, 0.0, MAX_SNR_SCALE);
    fl_set_dial_value(obj, 0.0);
    fl_set_object_color(obj, FL_DIAL_COL1, FL_GREEN);

fdui -> main_form_signal_strength_text_field = obj =\
	fl_add_box(FL_DOWN_BOX, 745, 50, 25, 25, "");

fdui -> main_form_signal_strength_text_text_field = obj =\
	fl_add_box(FL_NO_BOX, 775, 50, 10, 25, "dB");

fdui -> main_form_bit_error_rate_text_text_field = obj =\
	fl_add_box(FL_NO_BOX, 678, 8, 45, 20, "bit errors");

fdui -> main_form_bit_error_rate_text_field = obj =\
	fl_add_box(FL_DOWN_BOX, 725, 10, 45, 20, "");

fdui -> main_form_beep_button = obj =\
	fl_add_button(FL_PUSH_BUTTON, 735, 90, 35, 20, "BEEP");
	fl_set_object_callback(obj, main_form_beep_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_YELLOW);

fdui -> main_form_recorder_button_group =\

fdui -> main_form_play_button = obj =\
	fl_add_button(FL_NORMAL_BUTTON, 440, 5, 30, 30, "PLA");
	fl_set_object_callback(obj, main_form_play_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_YELLOW);

fdui -> main_form_record_button = obj =\
	fl_add_button(FL_NORMAL_BUTTON, 480, 5, 30, 30, "REC");
	fl_set_object_callback(obj, main_form_record_button_cb, 0);
	fl_set_object_color(obj, FL_DARKORANGE, FL_RED);
//	fl_set_object_color(obj, 24, FL_RED);

fdui -> main_form_stop_button = obj =\
	fl_add_button(FL_NORMAL_BUTTON, 520, 5, 30, 30, "STO");
	fl_set_object_callback(obj, main_form_stop_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_GREEN);

fdui -> main_form_pause_button = obj =\
	fl_add_button(FL_PUSH_BUTTON, 560, 5, 30, 30, "PAU");
	fl_set_object_callback(obj, main_form_pause_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_BLUE);

fdui -> main_form_service_button = obj =\
	fl_add_button(FL_NORMAL_BUTTON, 640, 170, 90, 30, "");
	fl_set_object_callback(obj, main_form_service_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_COL1);
	fl_hide_object(obj);

fdui -> main_form_sort_button = obj =\
	fl_add_button(FL_NORMAL_BUTTON, 680, 210, 90, 30, "");
	fl_set_object_callback(obj, main_form_sort_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_YELLOW);

fdui -> main_form_teletext_button = obj =\
	fl_add_button(FL_PUSH_BUTTON, 680, 250, 90, 30, "VIDEOTEXT");
	fl_set_object_callback(obj, main_form_teletext_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_GREEN);

fdui -> main_form_delete_button = obj =\
	fl_add_button(FL_NORMAL_BUTTON, 680, 300, 90, 30, "DELETE");
	fl_set_object_callback(obj, main_form_delete_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_RED);

fdui -> main_form_clear_button = obj =\
	fl_add_button(FL_NORMAL_BUTTON, 680, 360, 90, 30, "CLEAR");
	fl_set_object_callback(obj, main_form_clear_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_YELLOW);

fdui -> main_form_add_button = obj =\
	fl_add_button(FL_NORMAL_BUTTON, 680, 400, 90, 30, "ADD");
	fl_set_object_callback(obj, main_form_add_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_GREEN);

fdui -> main_form_log_messages_button = obj =\
	fl_add_button(FL_PUSH_BUTTON, 20, 450, 90, 30, "Log\nmessages");
	fl_set_object_callback(obj, main_form_log_messages_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_DARKORANGE);
//	fl_set_object_shortcut(obj, "", 1);

fdui -> main_form_channel_up_button = obj =\
	fl_add_button(FL_NORMAL_BUTTON, 540, 450, 90, 30, "CHANNEL+");
	fl_set_object_callback(obj, main_form_channel_up_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_GREEN);
	fl_set_object_shortcut(obj, "]", 1);

fdui -> main_form_channel_down_button = obj =\
	fl_add_button(FL_NORMAL_BUTTON, 440, 450, 90, 30, "CHANNEL-");
	fl_set_object_callback(obj, main_form_channel_down_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_YELLOW);
	fl_set_object_shortcut(obj, "[", 1);

fdui -> main_form_apid_up_button = obj =\
	fl_add_button(FL_NORMAL_BUTTON, 540, 500, 90, 30, "APID+");
	fl_set_object_callback(obj, main_form_apid_up_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_GREEN);
	fl_set_object_shortcut(obj, ",", 1);

fdui -> main_form_apid_down_button = obj =\
	fl_add_button(FL_NORMAL_BUTTON, 440, 500, 90, 30, "APID-");
	fl_set_object_callback(obj, main_form_apid_down_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_YELLOW);
	fl_set_object_shortcut(obj, ".", 1);

fdui -> main_form_vpid_up_button = obj =\
	fl_add_button(FL_NORMAL_BUTTON, 330, 500, 90, 30, "VPID+");
	fl_set_object_callback(obj, main_form_vpid_up_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_GREEN);
	fl_set_object_shortcut(obj, ">", 1);

fdui -> main_form_vpid_down_button = obj =\
	fl_add_button(FL_NORMAL_BUTTON, 230, 500, 90, 30, "VPID-");
	fl_set_object_callback(obj, main_form_vpid_down_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_YELLOW);
	fl_set_object_shortcut(obj, "<", 1);

fdui -> main_form_program_number_up_button = obj =\
	fl_add_button(FL_NORMAL_BUTTON, 330, 450, 90, 30, "PR NR+");
	fl_set_object_callback(obj, main_form_program_number_up_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_GREEN);
	fl_set_object_shortcut(obj, ",", 1);

fdui -> main_form_program_number_down_button = obj =\
	fl_add_button(FL_NORMAL_BUTTON, 230, 450, 90, 30, "PR NR-");
	fl_set_object_callback(obj, main_form_program_number_down_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_YELLOW);
	fl_set_object_shortcut(obj, ".", 1);

fdui -> main_form_description_input = obj =\
	fl_add_input(FL_NORMAL_INPUT, 20, 400, 160, 30, "Description");
	fl_set_input_return(obj, FL_RETURN_CHANGED);
	fl_set_object_callback(obj, main_form_description_input_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_WHITE);
	fl_set_object_lalign(obj, FL_ALIGN_CENTER|FL_ALIGN_BOTTOM);
	fl_set_object_lstyle(obj, FL_BOLD_STYLE);
	fl_set_object_lsize(obj, FL_MEDIUM_SIZE);
//	fl_set_button_shortcut(obj, "^N", 0);	

fdui -> main_form_disecq_input = obj =\
	fl_add_input(FL_NORMAL_INPUT, 190, 400, 30, 30, "Dis");
	fl_set_input_return(obj, FL_RETURN_CHANGED);
	fl_set_object_callback(obj, main_form_disecq_input_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_WHITE);
	fl_set_object_lalign(obj, FL_ALIGN_CENTER|FL_ALIGN_BOTTOM);
	fl_set_object_lstyle(obj, FL_BOLD_STYLE);
	fl_set_object_lsize(obj, FL_MEDIUM_SIZE);
//	fl_set_button_shortcut(obj, "^N", 0);	

fdui -> main_form_frequency_input = obj =\
	fl_add_input(FL_NORMAL_INPUT, 230, 400, 70, 30, "Freq");
	fl_set_input_return(obj, FL_RETURN_CHANGED);
	fl_set_object_callback(obj, main_form_frequency_input_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_WHITE);
	fl_set_object_lalign(obj, FL_ALIGN_CENTER|FL_ALIGN_BOTTOM);
	fl_set_object_lstyle(obj, FL_BOLD_STYLE);
	fl_set_object_lsize(obj, FL_MEDIUM_SIZE);
//	fl_set_button_shortcut(obj, "^N", 0);	

fdui -> main_form_polarization_input = obj =\
	fl_add_input(FL_NORMAL_INPUT, 310, 400, 20, 30, "Pol");
	fl_set_input_return(obj, FL_RETURN_CHANGED);
	fl_set_object_callback(obj, main_form_polarization_input_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_WHITE);
	fl_set_object_lalign(obj, FL_ALIGN_CENTER|FL_ALIGN_BOTTOM);
	fl_set_object_lstyle(obj, FL_BOLD_STYLE);
	fl_set_object_lsize(obj, FL_MEDIUM_SIZE);
//	fl_set_button_shortcut(obj, "^N", 0);	

fdui -> main_form_symbolrate_input = obj =\
	fl_add_input(FL_NORMAL_INPUT, 340, 400, 70, 30, "Symbolr");
	fl_set_input_return(obj, FL_RETURN_CHANGED);
	fl_set_object_callback(obj, main_form_symbolrate_input_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_WHITE);
	fl_set_object_lalign(obj, FL_ALIGN_CENTER|FL_ALIGN_BOTTOM);
	fl_set_object_lstyle(obj, FL_BOLD_STYLE);
	fl_set_object_lsize(obj, FL_MEDIUM_SIZE);
//	fl_set_button_shortcut(obj, "^N", 0);	

fdui -> main_form_program_number_input = obj =\
	fl_add_input(FL_NORMAL_INPUT, 420, 400, 70, 30, "Progr nr");
	fl_set_input_return(obj, FL_RETURN_CHANGED);
	fl_set_object_callback(obj, main_form_program_number_input_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_WHITE);
	fl_set_object_lalign(obj, FL_ALIGN_CENTER|FL_ALIGN_BOTTOM);
	fl_set_object_lstyle(obj, FL_BOLD_STYLE);
	fl_set_object_lsize(obj, FL_MEDIUM_SIZE);
//	fl_set_button_shortcut(obj, "^N", 0);	

fdui -> main_form_vpid_input = obj =\
	fl_add_input(FL_NORMAL_INPUT, 500, 400, 50, 30, "vpid");
	fl_set_input_return(obj, FL_RETURN_CHANGED);
	fl_set_object_callback(obj, main_form_vpid_input_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_WHITE);
	fl_set_object_lalign(obj, FL_ALIGN_CENTER|FL_ALIGN_BOTTOM);
	fl_set_object_lstyle(obj, FL_BOLD_STYLE);
	fl_set_object_lsize(obj, FL_MEDIUM_SIZE);
//	fl_set_button_shortcut(obj, "^N", 0);	

fdui -> main_form_apid_input = obj =\
	fl_add_input(FL_NORMAL_INPUT, 560, 400, 50, 30, "apid");
	fl_set_input_return(obj, FL_RETURN_CHANGED);
	fl_set_object_callback(obj, main_form_apid_input_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_WHITE);
	fl_set_object_lalign(obj, FL_ALIGN_CENTER|FL_ALIGN_BOTTOM);
	fl_set_object_lstyle(obj, FL_BOLD_STYLE);
	fl_set_object_lsize(obj, FL_MEDIUM_SIZE);
//	fl_set_button_shortcut(obj, "^N", 0);	

fdui -> main_form_tpid_input = obj =\
	fl_add_input(FL_NORMAL_INPUT, 620, 400, 50, 30, "tpid");
	fl_set_input_return(obj, FL_RETURN_CHANGED);
	fl_set_object_callback(obj, main_form_tpid_input_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_WHITE);
	fl_set_object_lalign(obj, FL_ALIGN_CENTER|FL_ALIGN_BOTTOM);
	fl_set_object_lstyle(obj, FL_BOLD_STYLE);
	fl_set_object_lsize(obj, FL_MEDIUM_SIZE);
//	fl_set_button_shortcut(obj, "^N", 0);	

#ifdef PCTV1000
fdui -> main_form_tv_button = obj =\
	fl_add_button(FL_PUSH_BUTTON, 640, 450, 130, 110, "TV");
	fl_set_object_callback(obj, main_form_tv_button_cb, 0);
	fl_set_object_color(obj, FL_COL1, FL_GREEN);
	fl_set_object_shortcut(obj, "=", 1);
#endif /* PCTV1000 */

fdui -> main_form_fontsize_up_button = obj =\
	fl_add_button(FL_NORMAL_BUTTON, 580, 540, 20, 20, "-");
	fl_set_object_callback(obj, main_form_fontsize_down_button_cb, 0);

fdui -> main_form_fontsize_down_button = obj =\
	fl_add_button(FL_NORMAL_BUTTON, 610, 540, 20, 20, "+");
	fl_set_object_callback(obj, main_form_fontsize_up_button_cb, 0);

fdui -> main_form_wait_light =\
	obj = fl_add_text(FL_NORMAL_TEXT, 20, 80, 90, 30, "");
	fl_set_object_boxtype(obj, FL_DOWN_BOX);
	fl_set_object_lstyle(obj, FL_BOLD_STYLE);
	fl_set_object_lcol(obj, FL_WHITE);
	fl_set_object_color(obj, FL_COL1, FL_COL1);
	
fdui -> main_form_outfield =\
	obj = fl_add_text(FL_NORMAL_TEXT, 20, 540, 540, 20, "");
	fl_set_object_boxtype(obj,FL_DOWN_BOX);
	fl_set_object_lstyle(obj,FL_BOLD_STYLE);
	fl_set_object_lcol(obj, FL_BLUE);
	fl_set_object_color(obj, FL_YELLOW, FL_COL1);

fdui -> main_form_local_clock  =\
	obj = fl_add_clock(FL_DIGITAL_CLOCK, 120, 500, 90, 30, "");
    fl_set_object_boxtype(obj, FL_DOWN_BOX);
	fl_set_object_color(obj, FL_BLACK, FL_GREEN);
	fl_set_object_lstyle(obj, FL_BOLD_STYLE);
	fl_set_object_lsize(obj, FL_LARGE_SIZE);

fdui -> main_form_exit_switch =\
	obj = fl_add_button(FL_NORMAL_BUTTON, 20, 500, 90, 30, "EXIT");
	fl_set_object_color(obj, FL_COL1, FL_WHITE);
	fl_set_object_callback(obj, main_form_exit_switch_cb, 0);


fdui -> main_form_file_menu = obj =\
	fl_add_menu(FL_PULLDOWN_MENU, 20, 10, 90, 20, "FILE");
	fl_set_object_boxtype(obj, FL_FRAME_BOX);
	fl_set_object_callback(obj, main_form_file_menu_cb, 0);
	fl_set_menu(obj,\
"IMPORT DVB2000 CHANNEL LIST|\
SEARCH ADJACENT FREQUENCIES|\
EXIT\
");

fdui -> main_form_local_clock2  =\
	obj = fl_add_clock(FL_DIGITAL_CLOCK, 20, 45, 47, 20, "");
    fl_set_object_boxtype(obj, FL_DOWN_BOX);
	fl_set_object_color(obj, FL_BLACK, FL_GREEN);

fdui -> main_form_recorder_menu = obj =\
	fl_add_menu(FL_PULLDOWN_MENU, 120, 10, 90, 20, "RECORDER");
	fl_set_object_boxtype(obj, FL_FRAME_BOX);
	fl_set_object_callback(obj, main_form_recorder_menu_cb, 0);
	fl_set_menu(obj,\
"SET RECORD DIRECTORY|\
SET PLAY DIRECTORY|\
SHOW RECORD TIMERS|\
ADD SHOWVIEW TIMER -> NOT IMPLEMENTED YET <-|\
LOG SIGNAL QUALITY\
");

fdui -> main_form_seek_slider = obj =\
	fl_add_slider(FL_HOR_FILL_SLIDER, 260, 10, 90, 15, "player status");
	fl_set_slider_return(obj, FL_RETURN_ALWAYS);
	fl_set_object_color(obj, FL_COL1, FL_COL1);
	fl_set_object_callback(obj, main_form_seek_slider_cb, 0);

fl_end_form(); /* main form */

return fdui;
}/* end function FD_xcha *create_form_main_form */

