/*
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "xcha.h"

/*
VDR format:
sprintf(temp, "%s:%d:%c:%d:%d:%d:%d:%d:%d\n",\
service_name, *transponder_frequency, polarization,\
disecq, symbolrate, vpid, apid,\
ca, pnr);
*/
struct vdr_entry
	{
	char *name;/* combine service name and video audio pid to get unique */
	char *service_name;
	int symbolrate;
	int frequency;
	char polarization;
	int disecq;
	int vpid;
	int apid;
	int tpid;
	int ca;
	int pnr;	
	struct vdr_entry *nxtentr;
	struct vdr_entry *prventr;
	};
struct vdr_entry *vdr_entrytab[2]; /* first element points to first entry,
			second element to last entry */


struct vdr_entry *lookup_vdr_entry(char *name)
{
struct vdr_entry *pa;

/*pa points to next entry*/
for(pa = vdr_entrytab[0]; pa != 0; pa = pa -> nxtentr)
	{
	if(strcmp(pa -> name, name) == 0) return pa;
	}
return 0 ; /*not found*/
}/* end function lookup_vdr_entry */


struct vdr_entry *install_vdr_entry_at_end_of_list(char *name)
{
struct vdr_entry *plast, *pnew;

if(debug_flag)
	{
	fprintf(stdout,\
	"install_vdr_entry_at_end_off_list(): arg name=%s\n", name);
	}

pnew = lookup_vdr_entry(name);
if(pnew)
	{
	/* free previous definition */
/*	free(pnew -> subject);*/
	return pnew; /* already there */
	}

/* create new structure */
pnew = (struct vdr_entry *) calloc(1, sizeof(*pnew) );
if(! pnew)
	{
	fprintf(stdout,\
	"install_vdr_entry_at_end_of_list(): coul not allocate space struct\n");

	return 0;
	}

pnew -> name = strsave(name);
if(! pnew -> name) return 0;

/* get previous structure */
plast = vdr_entrytab[1]; /* end list */

/* set new structure pointers */
pnew -> nxtentr = 0; /* new points top zero (is end) */
pnew -> prventr = plast; /* point to previous entry, or 0 if first entry */

/* set previuos structure pointers */
if( !vdr_entrytab[0] ) vdr_entrytab[0] = pnew; /* first element in list */
else plast -> nxtentr = pnew;

/* set array end pointer */
vdr_entrytab[1] = pnew;

return pnew; /* pointer to new structure */
}/* end function install_vdr_entry */


int delete_vdr_entry(char *name)/* delete entry from double linked list */
{
struct vdr_entry *pa, *pprev, *pdel, *pnext;

if(debug_flag)
	{
	fprintf(stdout, "delete_vdr_entry(): arg name=%s\n", name);
	}

/* argument check */
if(! name) return 0;

pa = vdr_entrytab[0];
while(1)
	{
	/* if end list, return not found */
	if(! pa) return 0;

	/* test for match in name */
	if(strcmp(name, pa -> name) != 0) /* no match */
		{
		/* point to next element in list */
		pa = pa -> nxtentr;

		/* loop for next element in list */
		continue;
		}

	/* we now know which struture to delete */
	pdel = pa;

	/* get previous and next structure */
	pnext = pa -> nxtentr;
	pprev = pa -> prventr;

	/* set pointers for previous structure */
	/* if first one, modify vdr_entrytab[0] */
	if(pprev == 0) vdr_entrytab[0] = pnext;
	else pprev -> nxtentr = pnext;

	/* set pointers for next structure */
	/* if last one, modify vdr_entrytab[1] */
	if(pnext == 0) vdr_entrytab[1] = pprev;
	else pnext -> prventr = pprev;
	
	/* delete structure */	
	free(pdel -> name);
	free(pdel -> service_name);
	free(pdel); /* free structure */

	/* return OK deleted */
	return 1;
	}/* end for all structures */
}/* end function delete_vdr_entry */


int delete_all_vdr_entrys()/* delete all entries from table */
{
struct vdr_entry *pa;

if(debug_flag)
	{
	fprintf(stdout, "delete_all_vdr_entrys() arg none\n");
	}

while(1)
	{	
	pa = vdr_entrytab[0];
	if(! pa) break;
	vdr_entrytab[0] = pa -> nxtentr;
	free(pa -> name);
	free(pa -> service_name);
	free(pa);/* free structure */
	}/* end while all structures */

vdr_entrytab[1] = 0;
return 1;
}/* end function delete_all_vdr_entrys */


int save_vdr_entries()
{
char temp[TEMP_SIZE];
struct vdr_entry *pa;
int a;
FILE *fptr;
FILE *pptr;

if(debug_flag)
	{
	fprintf(stdout, "save_vdr_entries(): arg none\n");
	}

/* save the new file as a tmp */
sprintf(temp, "%s/channels.conf.tmp", home_dir);
fptr = fopen(temp, "w");
if(! fptr)
	{
	fprintf(stdout,\
	"save_vdr_entries(): could not open file %s for write\n",\
	temp);
	return 0;
	}

/*
The vdr-0.62 format
const char *cChannel::ToText(cChannel *Channel)
{
asprintf(&buffer,\
"%s:%d:%c:%d:%d:%d:%d:%d:%d\n",\
Channel->name, Channel->frequency, Channel->polarization, Channel->diseqc,\
Channel->srate, Channel->vpid, Channel->apid, Channel->ca, Channel->pnr);
return buffer;
}
*/
for(pa = vdr_entrytab[0]; pa != 0; pa = pa -> nxtentr)	
	{
	/* VDR format */
	fprintf(fptr, "%s:%d:%c:%d:%d:%d:%d:%d:%d\n",\
	pa -> service_name, pa -> frequency, pa -> polarization,\
	pa -> disecq, pa -> symbolrate, pa -> vpid, pa -> apid,\
	pa -> ca, pa -> pnr);
	}	

/* remove any old .bak file */
sprintf(temp, "%s/channels.conf.bak", home_dir);
if(unlink(temp) != 0)
	{
//	fprintf(stdout, "scan_channels(): could not unlink %s\n",\
//	temp);

//	return 0;
	}

/* rename the old file to .bak */
sprintf(temp, "mv %s/channels.conf %s/channels.conf.bak",\
home_dir, home_dir);
pptr = popen(temp, "r");
pclose(pptr);

/* rename the temp file to the corrrect name */
sprintf(temp, "mv %s/channels.conf.tmp %s/channels.conf",\
home_dir, home_dir);
pptr = popen(temp, "r");
pclose(pptr);

return 1;
}/* end function save_vdr_entries */


int load_vdr_entries(char *pathfilename)
{
int a;
FILE *fptr;
char temp[READSIZE];
struct vdr_entry *pa;
extern char *strsave();
char name[4096];
int frequency;
char polarization;
int disecq;
int symbolrate;
int vpid;
int apid;
int tpid;
int ca;
int pnr;
char *station_name;
struct stat *statptr;
int file_size;

if(debug_flag)
	{
	fprintf(stdout,\
	"load_vdr_entries() arg pathfilename=%s\n",\
	pathfilename);
	}
	
if(! pathfilename) return 0;

delete_all_vdr_entrys();

errno = 0;
fptr = fopen("/root/channels.conf", "r");
//perror("");
if(! fptr)
	{
	if(debug_flag)
		{
		fprintf(stdout,\
		"load_vdr_entries(): could not open file %s for read\n",\
		pathfilename);
		}
	return 0;
	} 

/*
need the length of this file, to prevent generating zero output length
files from defective (zero length) channels.conf
*/
/* allocate space for structure stat */
statptr = (struct stat*) malloc(sizeof(struct stat) );
if(! statptr)
	{
	fprintf(stdout,\
	"load_vdr_entries(): could not alllocate space for stat\n");

	return 0;
	}

/* fill the structure with data for this file */
fstat(fileno(fptr), statptr);

/* get filesize */
file_size = statptr -> st_size;

/* free the structure */
free(statptr);

/* test the filesize */
if(file_size == 0)
	{
	fprintf(stdout,\
	"load_vdr_entries(): %s has zero length aborting\n",\
	pathfilename);

	return 0;
	}
/*
The vdr-0.62 format
const char *cChannel::ToText(cChannel *Channel)
{
asprintf(&buffer,\
"%s:%d:%c:%d:%d:%d:%d:%d:%d\n",\
Channel->name, Channel->frequency, Channel->polarization, Channel->diseqc,\
Channel->srate, Channel->vpid, Channel->apid, Channel->ca, Channel->pnr);
return buffer;
}
*/

/* read the file */
while(1)
	{
	a = readline(fptr, temp);/* closes file on EOF */
	if(a == EOF) return 1;/* empty file or last line */

	a = sscanf(temp,\
	"%a[^:]:%d:%c:%d:%d:%d:%d:%d:%d",\
	&station_name, &frequency, &polarization, &disecq,\
	&symbolrate, &vpid, &apid, &ca, &pnr);

//	if(a == 10)
		{
		/* create a structure entry */
		pa = install_vdr_entry_at_end_of_list(temp);
		if(! pa)
			{
			if(debug_flag)
				{
				fprintf(stdout,\
				"load_vdr_entries(): cannot install url %s\n", temp);
				}
			return 0;
			}
		pa -> frequency = frequency;

		pa -> service_name = strsave(station_name);
		if(! pa -> service_name) return 0;

		pa -> polarization = polarization;
		pa -> disecq = disecq;
		pa -> symbolrate = symbolrate;
		pa -> vpid = vpid;
		pa -> apid = apid;
		pa -> ca = ca;
		pa -> pnr = pnr;

		}/* end if a == 10 */
	}/* end while all lines in urls.dat */

return 1;
}/* end function load_vdr_entries */


int add_vdr_entry(
char *name,\
char *service_name,\
int symbolrate,\
int frequency,\
char polarization,\
int disecq,\
int vpid,\
int apid,\
int tpid,\
int ca,\
int pnr)
{
struct vdr_entry *pa;

if(debug_flag)
	{
	fprintf(stdout, "add_vdr_entry(): arg\n\
	name=%s\n\
	service_name=%s\n\
	symbolrate=%d\n\
	frequency=%d\n\
	polarization=%c\n\
	disecq=%d\n\
	vpid=%d\n\
	apid=%d\n\
	tpid=%d\n\
	ca=%d\n\
	pnr=%d\n",\
	name,\
	service_name, symbolrate, frequency, polarization, disecq,\
	vpid, apid, tpid, ca, pnr);
	}

pa = install_vdr_entry_at_end_of_list(name);
	if(! pa) return 0;
pa -> service_name = strsave(service_name);
	if(! pa -> service_name) return 0;
pa -> frequency = frequency;
pa -> polarization = polarization;
pa -> disecq = disecq;
pa -> symbolrate = symbolrate;
pa -> vpid = vpid;
pa -> apid = apid;
pa -> tpid = tpid;
pa -> ca = ca;
pa -> pnr = pnr;

return 1;
}/* end function add_vdr_entry */


int swap_vdr_entry_position(\
struct vdr_entry *ptop, struct vdr_entry *pbottom)
{
struct vdr_entry *punder;
struct vdr_entry *pabove;

if(debug_flag)
	{
	fprintf(stdout,\
	"swap_position(): swapping top=%lu bottom=%lu\n", ptop, pbottom);
	}

/* get one below the bottom */
punder = pbottom -> prventr;/* could be zero if first entry */
if(debug_flag)
	{
	fprintf(stdout,\
	"swap_position(): punder=%lu\n", punder);
	}

/* get the one above the top */
pabove = ptop -> nxtentr;/* could be zero if last entry */
if(debug_flag)
	{
	fprintf(stdout,\
	"swap_position(): pabove=%lu\n", pabove);
	}

/* the next pointer in punder (or vdr_entrytab[0]) must now point to ptop */
if(! punder)
	{
	vdr_entrytab[0] = ptop; 
	}
else
	{
	punder -> nxtentr = ptop;
	}

/* the prev pointer in in ptop must now point to punder */
ptop -> prventr = punder;/* could be zero if first entry */

/* the next pointer in ptop must now point to pbottom */
ptop -> nxtentr = pbottom;

/* the next pointer in pbottom must now point to pabove */
pbottom -> nxtentr = pabove;

/* mark last one in vdr_entrytabtab */
if(! pabove)
	{
	vdr_entrytab[1] = pbottom;
	}
else
	{
	/* the prev pointer in pabove must now point to pbottom */
	pabove -> prventr = pbottom;
	}

/* the prev pointer in pbottom must now point to ptop */
pbottom -> prventr = ptop;

/* return swapped */
return 1;
}/* end function swap_vdr_entry_position */


int sort_vdr_entry_list(int mode)
/*
sorts the double linked vdr_entry with criterium set by mode.
doing some sort of bubble sort.
*/
{
struct vdr_entry *pa;
struct vdr_entry *pb;
int swap_flag;
char temp[4096];
FILE *pptr;
FILE *fptr;

if(debug_flag)
	{
	fprintf(stdout, "sort_vdr_entry_list(): arg mode=%d\n", mode);
	}

if(mode == SORT_ALPHA)
	{
//	fprintf(stdout,\
//	"Sorting database alphanumeric, this may take a while...\n");
	}
else if(mode == SORT_FREQUENCY)
	{
//	fprintf(stdout,\
//	"Sorting database by frequency, this may take a wile\n");
	}

/* sort the double linked list */
while(1)/* go through vdr_entry again and again */
	{
	swap_flag = 0;
	for(pa = vdr_entrytab[0]; pa != 0; pa = pa -> nxtentr)
		{
		pb = pa -> prventr;
		if(pb)
			{
			if(mode == SORT_ALPHA)
				{
				if(debug_flag)
					{
					fprintf(stdout, "pa->name=%s pb->name=%s\n",\
					pa -> name, pb -> name);
					}

				if(strcasecmp(pa -> name, pb -> name) < 0)
					{
					swap_flag = swap_vdr_entry_position(pa, pb);
					/* indicate position was swapped */
					}/* end if condition */
				}
			else if(mode == SORT_FREQUENCY)
				{
				if(pa -> frequency < pb -> frequency)
					{
					swap_flag = swap_vdr_entry_position(pa, pb);
					}		
				}			
			}/* end if pb */
		}/* end for all entries */

	/* if no more swapping took place, ready, vdr_entry is sorted */
	if(! swap_flag) break;
	}/* end while go through vdr_entry again and again */

return 1;
}/* end function sort_vdr_entry_list */

