/*
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "xcha.h"

FD_xcha *fdui;

FILE *filefd;


char *strsave(char *s) /*save char array s somewhere*/
{
char *p, *malloc();
if(p = malloc( strlen(s) +  1) )strcpy(p, s);
return p;
}


int readline(FILE *file, char *contents)
{
int a, c, i;

if(debug_flag)
	{
	fprintf (stdout, "readline(): arg file=%lu\n", (long)file);
	}

for(i = 0; i < READSIZE - 1; i++)
	{
	while(1)
		{
		c = getc(file);
		a = ferror(file);
		if(a)
			{
			perror("readline():");
			continue;
			}
		break;
		}
	if(feof(file) )
		{
		fclose(file);
		contents[i] = 0;/* EOF marker */
		return EOF;
		}
	if(c == '\n')
		{
		contents[i] = 0;/* string termination */
		return 1;/* end of line */
		} 
	contents[i] = c;
	}
/*
mmm since we are here, the line must be quite long, possibly something
is wrong.
Since I do not always check for a return 0 in the use uf this function,
just to be safe, gona force a string termination.
This prevents stack overflow, and variables getting overwritten.
*/
contents[i] = 0;/* force string termination */
/*fclose(file);*/
if(debug_flag)
	{
	fprintf(stdout,\
	"readline(): line to long, returning 0 contents=%s\n", contents);
	}
return 0;
}/* end function readline */


int integer_to_fontsize(int fontsize)
{
int size;

size = 0;/* only for clean compilation with -Wall */

/* tiny snall normal medium large huge */
if(fontsize == 0) size = FL_TINY_SIZE;
if(fontsize == 1) size = FL_SMALL_SIZE;
if(fontsize == 2) size = FL_NORMAL_SIZE;
if(fontsize == 3) size = FL_MEDIUM_SIZE;
if(fontsize == 4) size = FL_LARGE_SIZE;
if(fontsize == 5) size = FL_HUGE_SIZE;

return size;
}/* end function integer to fontsize */


int get_this_time(\
time_t this_time,
char *weekday,
char *month,
int *monthday,
int *hour,
int *minute,
int *second,
int *year
)
{
char *datestring;

/* char *, converts time_t I to character string date and time */
datestring = ctime(&this_time);

sscanf(datestring, "%s %s %d %d:%d:%d %d",\
weekday, month, monthday, hour, minute, second,year);/*no &, already pointers*/

return 1;
}/* end function get_this_time */


int weekday_to_digit(char *weekday_str)
{
int day;

/*
The abbreviations for the days of week in ctime() are:
`Sun', `Mon', `Tue', `Wed', `Thu', `Fri', `Sat'.
*/
if(strcmp(weekday_str, "Sun") == 0) day = 0;
if(strcmp(weekday_str, "Mon") == 0) day = 1;
if(strcmp(weekday_str, "Tue") == 0) day = 2;
if(strcmp(weekday_str, "Wed") == 0) day = 3;
if(strcmp(weekday_str, "Thu") == 0) day = 4;
if(strcmp(weekday_str, "Fri") == 0) day = 5;
if(strcmp(weekday_str, "Sat") == 0) day = 6;

return day;
} /* end function weekday_to_digit */


int month_to_digit(char *month_str)
{
int month;

/*
The abbreviations for the months in ctime() are:
`Jan', `Feb', `Mar', `Apr', `May', `Jun',
`Jul', `Aug', `Sep', `Oct', `Nov', `Dec'.
*/

if(strcmp(month_str,"Jan") == 0) month = 1; 
if(strcmp(month_str,"Feb") == 0) month = 2;
if(strcmp(month_str,"Mar") == 0) month = 3; 
if(strcmp(month_str,"Apr") == 0) month = 4; 
if(strcmp(month_str,"May") == 0) month = 5; 
if(strcmp(month_str,"Jun") == 0) month = 6; 
if(strcmp(month_str,"Jul") == 0) month = 7; 
if(strcmp(month_str,"Aug") == 0) month = 8; 
if(strcmp(month_str,"Sep") == 0) month = 9; 
if(strcmp(month_str,"Oct") == 0) month = 10;
if(strcmp(month_str,"Nov") == 0) month = 11;
if(strcmp(month_str,"Dec") == 0) month = 12;

return month;
} /* end function month_to_digit */


int get_free_disk_space(char *filename, int *megabytes, int *percentage)
{
int a, c, i;
FILE *fptr;
FILE *pptr;
char temp[TEMP_SIZE];
char dummy[TEMP_SIZE];
char filename_copy[TEMP_SIZE];
int usage;
int available;

if(debug_flag)
	{
	printf("get_free_disk_space(): arg filename=%s\n", filename);
	}

/* parameter check */
if(! filename) return 0;

/* extract the mount pointof the firs tpart of the filename to 


/* execute df */
sprintf(temp, "df > %s/.xcha/disk_space", home_dir);
pptr = popen(temp, "w");
pclose(pptr);

/* format of the file */
/*
Filesystem           1k-blocks      Used Available Use% Mounted on
/dev/hda7              9076364   7125700   1489604  83% /
/dev/hda5                23302      3681     18418  17% /boot
shmfs                   495768         0    495768   0% /dev/shm
/dev/hdb5              6135204   4768980   1054568  82% /redhat
/dev/hdd1             28842748  22280728   5096896  82% /video
/dev/hda1             29288192  25004352   4283840  86% /big
/dev/hdd2              9775248   7474388   2300860  77% /reiser
*/

/* read and parse the disk_space_file */
sprintf(temp, "%s/.xcha/disk_space", home_dir);
fptr = fopen(temp, "r");
if(! fptr)
	{
	printf("get_free_disk_space(): could not open %s for read\n", temp);
	}

while(1)
	{
	/* read a line */
	a = fscanf(fptr, "%s %s %s %ld %ld%% %s",\
	dummy, dummy, dummy, &available, &usage, temp);	

	if(debug_flag)
		{
		printf("a = %d dummy=%s available=%d usage=%d temp=%s\n",\
		a, dummy, available, usage, temp);
		}

	if(a == EOF) break;

	if(a != 6) continue;

	/* check if this is where we are mounted */
	i = 0;
	while(1)
		{
		c = temp[i];

		/* test for end of temp, if reached we have a match */
		if(c == 0)
			{
			*megabytes = available / 1024;

			*percentage = usage; 

			fclose(fptr);
			return 1;
			} /* end while all characters in mounted */

		if(c != filename[i]) break;
		i++;
		} /* end while all lines in file */
	
	} /* end while all lines in file */
fclose(fptr);

/* return not found */
return 0;
} /* end fubnction get_free_disk_space */


int enable_receiver_controls(int mode)
{
if(debug_flag)
	{
	printf("enable_receiver_controls(): mode=%d\n", mode);
	}

if(mode == 0)
	{
//	fl_deactivate_object(fdui -> main_form_window_menu);
	fl_deactivate_object(fdui -> main_form_file_menu);
	fl_deactivate_object(fdui -> main_form_recorder_menu);

	fl_deactivate_object(fdui -> main_form_browser);
	fl_deactivate_object(fdui -> main_form_search_input_field);
	fl_deactivate_object(fdui -> main_form_search_case_button);
	fl_deactivate_object(fdui -> main_form_search_button);
	fl_deactivate_object(fdui -> main_form_scan_button);
	fl_deactivate_object(fdui -> main_form_driver_select_button);

//	fl_deactivate_object(fdui -> main_form_preset_button_group);

	fl_deactivate_object(fdui -> main_form_preset0_button);
	fl_deactivate_object(fdui -> main_form_preset1_button);
	fl_deactivate_object(fdui -> main_form_preset2_button);
	fl_deactivate_object(fdui -> main_form_preset3_button);
	fl_deactivate_object(fdui -> main_form_preset4_button);
	fl_deactivate_object(fdui -> main_form_preset5_button);
	fl_deactivate_object(fdui -> main_form_preset6_button);
	fl_deactivate_object(fdui -> main_form_preset7_button);
	fl_deactivate_object(fdui -> main_form_preset8_button);
	fl_deactivate_object(fdui -> main_form_preset9_button);
	fl_deactivate_object(fdui -> main_form_preset10_button);
	fl_deactivate_object(fdui -> main_form_preset11_button);
	fl_deactivate_object(fdui -> main_form_preset12_button);
	fl_deactivate_object(fdui -> main_form_preset13_button);
	fl_deactivate_object(fdui -> main_form_preset14_button);

	fl_deactivate_object(fdui -> main_form_beep_button);

	fl_deactivate_object(fdui -> main_form_teletext_button);
	fl_deactivate_object(fdui -> main_form_delete_button);
	fl_deactivate_object(fdui -> main_form_clear_button);
	fl_deactivate_object(fdui -> main_form_add_button);
	fl_deactivate_object(fdui -> main_form_description_input);
	fl_deactivate_object(fdui -> main_form_disecq_input);
	fl_deactivate_object(fdui -> main_form_frequency_input);
	fl_deactivate_object(fdui -> main_form_polarization_input);
	fl_deactivate_object(fdui -> main_form_symbolrate_input);
	fl_deactivate_object(fdui -> main_form_program_number_input);
	fl_deactivate_object(fdui -> main_form_vpid_input);
	fl_deactivate_object(fdui -> main_form_apid_input);
	fl_deactivate_object(fdui -> main_form_tpid_input);

	fl_deactivate_object(fdui -> main_form_service_button);
	fl_deactivate_object(fdui -> main_form_sort_button);
	fl_deactivate_object(fdui -> main_form_channel_up_button);
	fl_deactivate_object(fdui -> main_form_channel_down_button);
	fl_deactivate_object(fdui -> main_form_program_number_up_button);
	fl_deactivate_object(fdui -> main_form_program_number_down_button);
	fl_deactivate_object(fdui -> main_form_apid_up_button);
	fl_deactivate_object(fdui -> main_form_apid_down_button);
	fl_deactivate_object(fdui -> main_form_vpid_up_button);
	fl_deactivate_object(fdui -> main_form_vpid_down_button);

	fl_deactivate_object(fdui -> main_form_exit_switch);
	} /* end if mode is 0 */
else if(mode == 1)
	{
//	fl_activate_object(fdui -> main_form_window_menu);
	fl_activate_object(fdui -> main_form_file_menu);
	fl_activate_object(fdui -> main_form_recorder_menu);

	fl_activate_object(fdui -> main_form_browser);
	fl_activate_object(fdui -> main_form_search_input_field);
	fl_activate_object(fdui -> main_form_search_case_button);
	fl_activate_object(fdui -> main_form_search_button);
	fl_activate_object(fdui -> main_form_scan_button);
	fl_activate_object(fdui -> main_form_driver_select_button);

//	fl_activate_object(fdui -> main_form_preset_button_group);

	fl_activate_object(fdui -> main_form_preset0_button);
	fl_activate_object(fdui -> main_form_preset1_button);
	fl_activate_object(fdui -> main_form_preset2_button);
	fl_activate_object(fdui -> main_form_preset3_button);
	fl_activate_object(fdui -> main_form_preset4_button);
	fl_activate_object(fdui -> main_form_preset5_button);
	fl_activate_object(fdui -> main_form_preset6_button);
	fl_activate_object(fdui -> main_form_preset7_button);
	fl_activate_object(fdui -> main_form_preset8_button);
	fl_activate_object(fdui -> main_form_preset9_button);
	fl_activate_object(fdui -> main_form_preset10_button);
	fl_activate_object(fdui -> main_form_preset11_button);
	fl_activate_object(fdui -> main_form_preset12_button);
	fl_activate_object(fdui -> main_form_preset13_button);
	fl_activate_object(fdui -> main_form_preset14_button);

	fl_activate_object(fdui -> main_form_beep_button);

	fl_activate_object(fdui -> main_form_teletext_button);
	fl_activate_object(fdui -> main_form_delete_button);
	fl_activate_object(fdui -> main_form_clear_button);
	fl_activate_object(fdui -> main_form_add_button);
	fl_activate_object(fdui -> main_form_description_input);
	fl_activate_object(fdui -> main_form_disecq_input);
	fl_activate_object(fdui -> main_form_frequency_input);
	fl_activate_object(fdui -> main_form_polarization_input);
	fl_activate_object(fdui -> main_form_symbolrate_input);
	fl_activate_object(fdui -> main_form_program_number_input);
	fl_activate_object(fdui -> main_form_vpid_input);
	fl_activate_object(fdui -> main_form_apid_input);
	fl_activate_object(fdui -> main_form_tpid_input);

	fl_activate_object(fdui -> main_form_service_button);
	fl_activate_object(fdui -> main_form_sort_button);
	fl_activate_object(fdui -> main_form_channel_up_button);
	fl_activate_object(fdui -> main_form_channel_down_button);
	fl_activate_object(fdui -> main_form_program_number_up_button);
	fl_activate_object(fdui -> main_form_program_number_down_button);
	fl_activate_object(fdui -> main_form_apid_up_button);
	fl_activate_object(fdui -> main_form_apid_down_button);
	fl_activate_object(fdui -> main_form_vpid_up_button);
	fl_activate_object(fdui -> main_form_vpid_down_button);

	fl_activate_object(fdui -> main_form_exit_switch);
	
	} /* end if mode is 1 */

return 1;
} /* end function enable_receiver_controls */



