/*
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "xcha.h"

FD_xcha *fdui;

int fontsizes_modified_flag;
int new_timer_flag;

int timer_form_modified_flag;


void timer_form_directory_input_field_cb(FL_OBJECT *ob, long data)
{
inputs_to_timer(selected_timer_pa, 1);

show_timers(SHOW_SAME_POSITION);

timer_form_modified_flag = 1;
}/* end function timer_form_directory_input_field_cb */


void timer_form_start_year_input_field_cb(FL_OBJECT *ob, long data)
{
inputs_to_timer(selected_timer_pa, 1);

show_timers(SHOW_SAME_POSITION);

timer_form_modified_flag = 1;
}/* end function timer_form_start_year_input_field_cb */


void timer_form_start_month_input_field_cb(FL_OBJECT *ob, long data)
{
inputs_to_timer(selected_timer_pa, 1);

show_timers(SHOW_SAME_POSITION);

timer_form_modified_flag = 1;
}/* end function timer_form_start_month_input_field_cb */


void timer_form_start_day_input_field_cb(FL_OBJECT *ob, long data)
{
inputs_to_timer(selected_timer_pa, 1);

show_timers(SHOW_SAME_POSITION);

timer_form_modified_flag = 1;
}/* end function timer_form_start_day_input_field_cb */


void timer_form_start_hour_input_field_cb(FL_OBJECT *ob, long data)
{
inputs_to_timer(selected_timer_pa, 1);

show_timers(SHOW_SAME_POSITION);

timer_form_modified_flag = 1;
}/* end function timer_form_start_hour_input_field_cb */


void timer_form_start_minute_input_field_cb(FL_OBJECT *ob, long data)
{
inputs_to_timer(selected_timer_pa, 1);

show_timers(SHOW_SAME_POSITION);

timer_form_modified_flag = 1;
}/* end function timer_form_start_minute_input_field_cb */


void timer_form_length_input_field_cb(FL_OBJECT *ob, long data)
{
int a;
char *ptr;
long length;
int seconds, minutes, hours;
char temp[80];
char weekday_str[80];
char month_str[80];
int monthday, hour, minute, second, year;
struct timer *pa;

ptr = (char *)fl_get_input(ob);
if(! ptr) return;

a = sscanf(ptr, "%d:%d:%d", &hours, &minutes, &seconds);
if(a != 3) return;

length = seconds + (minutes * 60) + (hours * 3600);

if(length <= 0)
	{
	fl_set_object_color(fdui -> timer_form_length_input_field,\
	FL_RED,FL_RED);
	}
else
	{
	fl_set_object_color(fdui -> timer_form_length_input_field,\
//	FL_COL1, FL_COL1);
	FL_WHITE, FL_WHITE);
	}	

if(! selected_timer_pa) return;
pa = selected_timer_pa;

pa -> stop_time = pa -> start_time + length;

get_this_time(pa -> stop_time,\
	weekday_str, month_str, &monthday, &hour, &minute, &second, &year);
pa -> stop_year = year;
pa -> stop_month = month_to_digit(month_str);
pa -> stop_day = monthday;
pa -> stop_hour = hour;
pa -> stop_minute = minute;

sprintf(temp, "%d", pa -> stop_year);
fl_set_input(fdui -> timer_form_stop_year_input_field, temp);

sprintf(temp, "%d", pa -> stop_month);
fl_set_input(fdui -> timer_form_stop_month_input_field, temp);

sprintf(temp, "%d", pa -> stop_day);
fl_set_input(fdui -> timer_form_stop_day_input_field, temp);

sprintf(temp, "%d", pa -> stop_hour);
fl_set_input(fdui -> timer_form_stop_hour_input_field, temp);

sprintf(temp, "%d", pa -> stop_minute);
fl_set_input(fdui -> timer_form_stop_minute_input_field, temp);

inputs_to_timer(selected_timer_pa, 0);

show_timers(SHOW_SAME_POSITION);

timer_form_modified_flag = 1;
}/* end function timer_form_length_input_field_cb */


void timer_form_stop_year_input_field_cb(FL_OBJECT *ob, long data)
{
inputs_to_timer(selected_timer_pa, 1);

show_timers(SHOW_SAME_POSITION);

timer_form_modified_flag = 1;
}/* end function timer_form_stop_year_input_field_cb */


void timer_form_stop_month_input_field_cb(FL_OBJECT *ob, long data)
{
inputs_to_timer(selected_timer_pa, 1);

show_timers(SHOW_SAME_POSITION);

timer_form_modified_flag = 1;
}/* end function timer_form_stop_month_input_field_cb */


void timer_form_stop_day_input_field_cb(FL_OBJECT *ob, long data)
{
inputs_to_timer(selected_timer_pa, 1);

show_timers(SHOW_SAME_POSITION);

timer_form_modified_flag = 1;
}/* end function timer_form_stop_day_input_field_cb */


void timer_form_stop_hour_input_field_cb(FL_OBJECT *ob, long data)
{
inputs_to_timer(selected_timer_pa, 1);

show_timers(SHOW_SAME_POSITION);

timer_form_modified_flag = 1;
}/* end function timer_form_stop_hour_input_field_cb */


void timer_form_stop_minute_input_field_cb(FL_OBJECT *ob, long data)
{
inputs_to_timer(selected_timer_pa, 1);

show_timers(SHOW_SAME_POSITION);

timer_form_modified_flag = 1;
}/* end function timer_form_stop_minute_input_field_cb */


void timer_form_browser_cb(FL_OBJECT *ob, long data)
{
int selected_line;
char *ptr;
struct timer *pa;
char temp[TEMP_SIZE];

if(debug_flag)
	{
	fprintf(stdout, "timer_form_browser_cb():\n");
	}

selected_line = fl_get_browser(ob);
if(! selected_line) return;

pa = timer_line_to_pa(selected_line);
selected_timer_pa = pa;
timer_to_inputs(pa);

/* maintain visible indication that line is selected with single click  */
fl_select_browser_line(fdui -> timer_form_browser, abs(selected_line) );

} /* end function timer_form_browser_cb */


void timer_form_browser_double_cb(FL_OBJECT *ob, long data)
{
if(debug_flag)
	{
	fprintf(stdout, "timer_form_browser_double_cb():\n");
	}

return;
}/* end function  timer_form_browser_double_cb */


void timer_form_delete_button_cb(FL_OBJECT *ob, long data)
{
delete_timer_pa(selected_timer_pa);

show_timers(SHOW_SAME_POSITION);

clear_timer_form();

timer_form_modified_flag = 1;
}/* end function timer_form_delete_button_cb */


void timer_form_daily_button_cb(FL_OBJECT *ob, long data)
{
fl_set_button(fdui -> timer_form_weekly_button, 0);
fl_set_button(fdui -> timer_form_work_days_button, 0);

inputs_to_timer(selected_timer_pa, 1);

show_timers(SHOW_SAME_POSITION);

timer_form_modified_flag = 1;
}/* end function timer_form_daily_button_cb */


void timer_form_work_days_button_cb(FL_OBJECT *ob, long data)
{
fl_set_button(fdui -> timer_form_weekly_button, 0);
fl_set_button(fdui -> timer_form_daily_button, 0);

inputs_to_timer(selected_timer_pa, 1);

show_timers(SHOW_SAME_POSITION);

timer_form_modified_flag = 1;
}/* end function timer_form_work_days_button_cb */


void timer_form_weekly_button_cb(FL_OBJECT *ob, long data)
{
fl_set_button(fdui -> timer_form_daily_button, 0);
fl_set_button(fdui -> timer_form_work_days_button, 0);

inputs_to_timer(selected_timer_pa, 1);

show_timers(SHOW_SAME_POSITION);

timer_form_modified_flag = 1;
}/* end function timer_form_weekly_button_cb */


void timer_form_fontsize_up_button_cb(FL_OBJECT *ob, long data)
{
int size;

if(timer_form_fontsize < 5) timer_form_fontsize++;
size = integer_to_fontsize(timer_form_fontsize);

fl_set_browser_fontsize(fdui -> timer_form_browser, size);

fontsizes_modified_flag = 1;
}/* end function timer_form_fontsize_up_button_cb */


void timer_form_fontsize_down_button_cb(FL_OBJECT *ob, long data)
{
int size;

if(timer_form_fontsize > 0) timer_form_fontsize--;
size = integer_to_fontsize(timer_form_fontsize);

fl_set_browser_fontsize(fdui -> timer_form_browser, size);

fontsizes_modified_flag = 1;
}/* end function timer_form_fontsize_down_button_cb */


void timer_form_cancel_button_cb(FL_OBJECT *ob, long data)
{
/* prevent callbacks from accessing non existent structure */
selected_timer_pa = 0;

if(timer_form_modified_flag)
	{
	/* restore from disc */
	load_timers();

	timer_form_modified_flag = 0;
 	}

fl_hide_form(fdui -> timer_form);

/* restore from disc */
if(fontsizes_modified_flag)
	{
	load_fontsizes();
	fontsizes_modified_flag = 0;
	}

timer_form_shown_flag = 0;
}/* end function timer_form_cancel_button_cb */


void timer_form_accept_button_cb(FL_OBJECT *ob, long data)
{
char temp[TEMP_SIZE];
char *ptr;

if(timer_overlap_flag)
	{
	fl_show_alert("WARNING", "TIMER OVERLAP", "FIX IT FIRST", 1);
	return;
	}

if(timer_form_modified_flag)
	{
	save_timers();

	timer_form_modified_flag = 0;
	}

fl_hide_form(fdui -> timer_form);

if(fontsizes_modified_flag)
	{
	save_fontsizes();
	fontsizes_modified_flag = 0;
	}

timer_form_shown_flag = 0;
}/* end function timer_form_accept_button_cb */


