/* 
dvbtext - a teletext decoder for DVB cards. 
(C) Dave Chapman <dave@dchapman.com> 2001.
adapted for xcha by JP.

The latest version can be found at http://www.linuxstb.org/dvbtext

Thanks to:  

Ralph Metzler for his work on both the DVB driver and his old
vbidecode package (some code and ideas in dvbtext are borrowed
from vbidecode).

Copyright notice:

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "xcha.h"
#include "teletext_decoder.h"

pthread_t *teletext_decoder_thread;
static int stop_teletext_decoder_flag = 0;
static int start_teletext_decoder_flag = 0;
static int teletext_running = 0;

typedef struct mag_struct_
{
int valid;
int mag;
unsigned char flags;
unsigned char lang;
int pnum;
int sub;
unsigned char pagebuf[25 * 40];
} mag_struct;


// FROM vbidecode
// unham 2 bytes into 1, report 2 bit errors but ignore them
unsigned char unham(unsigned char a, unsigned char b)
{
unsigned char c1, c2;
  
c1 = unhamtab[a];
c2 = unhamtab[b];

//  if ((c1 | c2) & 0x40) 
//      fprintf(stderr, "bad ham!");

return (c2 << 4) | (0x0f & c1);
} /* end function unham */


void set_line(mag_struct *mag, int line, unsigned char* data)
{
int i;
unsigned char c;
FILE * fd;
char fname[80];
unsigned char buf;

if(line == 0)
	{
	mag->valid = 1;
	memset(mag->pagebuf, ' ', 25 * 40);

	/* The lower two (hex) numbers of page */
	mag->pnum = unham(data[0], data[1]);

	/* These are filler lines. Can use to update clock */
	if(mag->pnum == 0xff) return;

//	fprintf(stderr, "pagenum: %03x\n", c + mag->mag * 0x100);
	mag->flags = unham(data[2], data[3]) & 0x80;
	mag->flags |= (c&0x40) | ((c >> 2) & 0x20);
	c = unham(data[6], data[7]);

	mag->flags |=\
	( (c << 4) &0x10) | ( (c << 2) & 0x08) |\
	(c & 0x04) | ( (c >> 1) & 0x02) | ( (c >> 4) & 0x01);

	mag->lang = ((c >> 5) & 0x07);

	mag->sub = (\
	unham(data[4], data[5]) << 8) | (unham(data[2], data[3]) & 0x3f7f);

//	mag->pnum = (mag->mag<<8)|((mag->sub&0x3f7f)<<16)|page;
//	fprintf(stderr,"page: %x, pnum: %x, sub: %x\n",page,mag->pnum,mag->sub);
	}

if(mag->valid)
	{
	if (line <= 23)
		{
		for(i = 0; i < 40; i++)
			{		
			/* make readable Pj 2002 */
			data[i] &= 0x7f;
			}

		memcpy(mag->pagebuf + 40 * line, data, 40);
		}

	if(line == 23)
		{
		sprintf(fname,\
		"%s/.xcha/vtx/%03x_%02x.vtx",\
		home_dir, mag->pnum + (mag->mag * 0x100), mag->sub & 0xff);

//		fprintf(stderr,"Writing to file %s\n", fname);
		if( (fd = fopen(fname, "w") ) )
			{
			fwrite("VTXV4", 1, 5, fd);

			buf = 0x01; fwrite(&buf, 1, 1, fd);
			buf = mag->mag;  fwrite(&buf, 1, 1, fd);
			buf = mag->pnum; fwrite(&buf, 1, 1, fd);
			buf = 0x00; fwrite(&buf, 1, 1, fd);    /* subpage?? */
			buf = 0x00; fwrite(&buf, 1, 1, fd);  
			buf = 0x00; fwrite(&buf, 1, 1, fd);  
			buf = 0x00; fwrite(&buf, 1, 1, fd);  

			fwrite(mag->pagebuf, 1, 24 * 40, fd);
			fclose(fd);
			}

		mag->valid=0;
		}
	}
} /* end function set_line */


void set_tt_filt(int fd, uint16_t tt_pid)
{
struct dmxPesFilterParams pesFilterParams;

pesFilterParams.pid     = tt_pid;
pesFilterParams.input   = DMX_IN_FRONTEND;
pesFilterParams.output  = DMX_OUT_TS_TAP;
pesFilterParams.pesType = DMX_PES_TELETEXT;
pesFilterParams.flags   = DMX_IMMEDIATE_START | DMX_ONESHOT;
//pesFilterParams.flags   = DMX_IMMEDIATE_START;
//pesFilterParams.output  = DMX_OUT_DECODER;

if (ioctl(fd, DMX_SET_PES_FILTER, &pesFilterParams) < 0)
	{
	if(debug_flag)
		{
		fprintf(stderr,"FILTER %i: ", tt_pid);
		}
	perror("DMX SET PES FILTER");
	}
} /* end function set_tt_filt */


void *teletext_decoder_routine()
{
char temp[1024];
int pid;
int pids; /* the requested */
int i, j, n;
unsigned char buf[188]; /* data buffer */
unsigned char mpag, mag, pack;
int fd_dvr;
int pnr = 1;
mag_struct mags[8];
int txt_fd;
int count;

if(debug_flag)
	{
	fprintf(stdout, "teletext_decoder_routine(): arg none\n");
	}

while(1)
	{
	/* wait for the ca routine to set the tpid */
	while(! have_pmt)
		{
		usleep(100000);
		}

	if(start_teletext_decoder_flag)
		{
		start_teletext_decoder_flag = 0;
		sprintf(temp, "start teletext_decoder_routine\n");
		to_log(temp);

		mags[0].mag = 8;
		for(i = 1; i < 8; i++)
			{ 
			mags[i].mag = i; 
			mags[i].valid = 0;
			}

		if((txt_fd = open("/dev/ost/demux", O_RDWR | O_NONBLOCK)) < 0)
			{
			if(debug_flag)
				{
				fprintf(stderr, "FD %i: ", i);
				}
			perror("DEMUX DEVICE: ");
			
			continue;
			}

		if((fd_dvr = open("/dev/ost/dvr", O_RDONLY | O_NONBLOCK)) < 0)
			{
			perror("DVR DEVICE: ");

			close(txt_fd);
			continue;			
			return;
			}

		/* Now we set the filters */
		set_tt_filt(txt_fd, (uint16_t)used_tpid);

		teletext_running = 1;
		while(! stop_teletext_decoder_flag)
			{
			n = read(fd_dvr, buf, 188);
			if(n < 2)
				{
				usleep(10000);
				continue;
				}

			pid = ( (buf[1] & 0x1f) << 8) | buf[2];
			if(pid == used_tpid)
				{
//				fprintf(stderr, "pid: %i\n", pid);
//				fprintf(stderr, "ts_id %i\n", buf[3]);
//				fprintf(stderr, "data_identifier = 0x%02x\n", buf[0x31]);
				for(i = 0; i < 4; i++)
					{
					if(buf[4 + i * 46] == 2)
						{
						for(j = (8 + i * 46); j < (50 + i * 46); j++)
							{
							buf[j] = invtab[ buf[j] ];
							}
						mpag = unham(buf[0x8 + i * 46], buf[0x9 + i * 46]);
						mag = mpag & 7;
						pack = (mpag >> 3) &0x1f;

						set_line(\
						&mags[mag], pack, &buf[10 + i * 46]);
//						fprintf(stderr, "i: %d mag=%d,pack=%d\n",i,mag,pack);
						} 
					} /* end for i */
				} /* end if pid matches */
			} /* end while ! stop_teletext_decoder_flag */

		close(txt_fd);
		close(fd_dvr);

		sprintf(temp, "exit teletext_decoder_routine\n");
		to_log(temp);
		if(debug_flag)
			{
			printf("%s", temp);
			}

		} /* end if program has changed */
	teletext_running = 0;

	/* take it easy on processor cycles */
	usleep(10000);
	} /* end while teletext_decoder */

return;
} /* end function teletext_decoder_routine */


int teletext_decoder_init()
{
if(debug_flag)
	{
	printf("teletext_decoder_init(): arg none\n");
	}

clear_teletext_dir();

pthread_create(\
(pthread_t *)&teletext_decoder_thread, NULL ,\
&teletext_decoder_routine, NULL);

return 1;
} /* end function teletext_decoder_init */


int start_teletext_decoder()
{
stop_teletext_decoder_flag = 0;
start_teletext_decoder_flag = 1;
} /* end function start_teletext_decoder */


int stop_teletext_decoder()
{
stop_teletext_decoder_flag = 1;

if(teletext_running)
	{
	stop_teletext_decoder_flag = 1;
	while (teletext_running)
		{
		usleep(100000);
		}
	}
stop_teletext_decoder_flag = 0;
} /* end function stop_teletext_decoder */


int clear_teletext_dir()
{
char temp[4096];
FILE *pptr;

sprintf(temp, "rm %s/.xcha/vtx/*.vtx 1> /dev/null 2> /dev/null", home_dir);
pptr = popen(temp, "w");
pclose(pptr);

} /* end function clear_teletext_dir */


int start_teletext_viewer()
{
FILE *pptr;
char temp[1024];

sprintf(temp, "nice -n 19 xvtx-s &");
pptr = popen(temp, "w");
pclose(pptr);

} /* end function start_teletext_viewer */


int stop_teletext_viewer()
{
FILE *pptr;
char temp[1024];

sprintf(temp, "killall xvtx-s &");
pptr = popen(temp, "w");
pclose(pptr);

} /* end function stop_teletext_viewer */


