/*
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "xcha.h"

FD_xcha *fdui;

extern int timer_form_modified_flag;


int add_showview_timer(unsigned long showview)
{
char temp[80];
int start_year, start_month, start_day, start_hour, start_minute;
int stop_year, stop_month, stop_day, stop_hour, stop_minute;
int start_weekday;
struct tm *ptime;
time_t start_time;
time_t stop_time;
int length;
char weekday_str[80];
char month_str[80];
int monthday, hour, minute, second, year;
int channel_id;
char *ptr;
struct timer *pa;
int timer_line;

if(debug_flag)
	{
	printf("add_showview_timer(): arg showview=%lu\n", showview);
	}

if(! decode_showview_number(showview,\
&channel_id,\
&start_year, &start_month, &start_day, &start_hour, &start_minute,\
&length) ) return 0;

ptime = (struct tm *)malloc( sizeof(struct tm) );
if(! ptime)
	{
	printf("inputs_to_timer(): malloc struct ptime failed\n");
	return 0;
	}

ptime -> tm_sec = 0;
ptime -> tm_min = start_minute;
ptime -> tm_hour = start_hour;
ptime -> tm_mday = start_day;
ptime -> tm_mon = (start_month) - 1;
ptime -> tm_year = (start_year) - 1900;
ptime -> tm_isdst = -1; /* daylight savings time info n.a. */

start_time = mktime( (struct tm *)ptime);
if(debug_flag)
	{
	printf("showview_to_inputs(): ptime -> tm_isdst=%d\n",\
	ptime -> tm_isdst);
	}

/* calculated by mktime() */
start_weekday = ptime -> tm_wday;

/* free structure */
free(ptime);

stop_time = start_time + length;

get_this_time(stop_time,\
	weekday_str, month_str, &monthday, &hour, &minute, &second, &year);

stop_year = year;
stop_month = month_to_digit(month_str);
stop_day = monthday;
stop_hour = hour;
stop_minute = minute;

ptr = showview_channel_id_to_channel_description(channel_id);
if(! ptr)
	{
	sprintf(temp, "for showview channel_id %d", channel_id);

	fl_show_alert("Cannot find channel descrition", temp, "", 0);
	
	return 0;
	}

if(timer_form_record_filename) free(timer_form_record_filename);
timer_form_record_filename = strsave(ptr);
if(! timer_form_record_filename)
	{
	printf(\
	"add_timer_to_list(): strsave timer_form_record_filename failed\n");

	return 0;
	}

pa = install_timer_at_end_of_list(ptr);
if(! pa)
	{
	fl_show_alert(\
	"add_timer():",\
	"cannot install timer", \
	"command cancelled", 0);
	return 0;
	}

selected_timer_pa = pa;

pa -> start_time = start_time;
pa -> stop_time = stop_time;

pa -> showview = showview;

pa -> status = 0;
pa -> status |= TIMER_REPEAT_NO;

pa -> browser_line = 0;

pa -> start_year = start_year;
pa -> start_month = start_month;
pa -> start_day = start_day;
pa -> start_hour = start_hour;
pa -> start_minute = start_minute;

pa -> start_weekday = start_weekday;

pa -> stop_year = stop_year;
pa -> stop_month = stop_month;
pa -> stop_day = stop_day;
pa -> stop_hour = stop_hour;
pa -> stop_minute = stop_minute;

pa -> directory = strsave(record_dir);
if(! pa -> directory)
	{
	printf("add_timer_to_list(): strsave pa->record_dir failed\n");
	}

if(! create_filename(timer_form_record_filename, pa) ) return 0;

/* set the input fields */
timer_to_inputs(pa);

timer_form_modified_flag = 1;

show_timer_form();

if(! pa_to_timer_line(pa, &timer_line) ) return 0;

/* mark new entry in browser */
fl_select_browser_line(fdui -> timer_form_browser, timer_line);

/* make visible */
fl_set_browser_topline(fdui -> timer_form_browser, timer_line - 10);

return 1;
} /* end function add_showview_timer */


char *showview_channel_id_to_channel_description(int channel_id)
{
char *ptr;

if(debug_flag)
	{
	printf(\
	"showview_channel_id_to_channel_description(): arg channel_id=%d\n",\
	channel_id);
	}

/* this will have to be a lookup, for a file specified by iser perhaps */
ptr = strsave(\
"ShowView NOT IMPLEMENTED YET!:12092:h:1:27500:4416:4417:0:0:8719");

return ptr;
} /* end function showview_channel_id_to_channel_description */


/*
This may help if you want to implement showview:

                       Dekodierung von ShowView-Codes
                                      
                              Herbert Fichtner
                          [1]fichtner@mail.isis.de
                                9. Juli 2000
                                      
   Dieser Text wurde in LATEX geschrieben und von TeX4ht nach HTML4 mit
   Cascading Style Sheets bersetzt. Dabei wurden nicht darstellbare
   Zeichen durch Bilder ersetzt. Um diese Seite lesen zu knnen, darf
   also die Anzeige von Bildern in Ihrem Browser nicht deaktiviert sein.
   
   Was ist ShowView?
   ShowView ist ein System, das die "Progammierung" von Videorekordern
   erleichtern soll. Zu jeder Sendung existiert eine 1- bis 9-stellige
   Codezahl. Dieser Code enthlt in verschlsselter Form den Tag, den
   Sender, die Anfangszeit und die Dauer der Sendung. Wird dieser Code in
   einen ShowView-tauglichen Videorekorder eingegeben, so wird er dort
   dekodiert und die entsprechende Sendung aufgenommen.
   
   Dieses Dokument beschreibt die Dekodierung von ShowView-Codes der Form
   y00x5x4x3x2x1x0 mit y (- {0, ..., 4} und xi (- {0, ..., 9}. An
   entscheidenden Stellen wird auf die Injektivitt der verwendeten
   Funktionen hingewiesen und die Umkehrung skizziert, so dass auch die
   Kodierung von "Sendungen" mglich ist.
   
   Die Dekodierung
   
   Vereinbarungen
   
   n-stellige Zahlen: Eine n-stelligen Zahl sei eine natrliche Zahl,
   deren Darstellung im Dezimalsystem ohne fhrende Nullen n Ziffern hat.
   Es ist sinnvoll, die Null als 0-stellige Zahl zu definieren. Dann gibt
   es fr n > 1 genau 10n-10n-1 n-stellige Zahlen. Nn bezeichne die Menge
   der n-stelligen Zahlen:
   
                      Nn := {x (- N |x ist n- stellig}
                                      
   Die Menge der hchstens n-stelligen Zahlen sei dann:
   
                            (n) U n i N := N i=0
                                      
   Sind ai (- {0, ..., 9} fr 0 < i < n- 1 die Ziffern einer n-stelligen
   Zahl a, so sei an-1an-2 ...a0 nicht das Produkt der Ziffern, sondern
   eine abgekrzte Schreibweise fr:
   
                            n sum - 1 i ai10 i=0
                                      
   x mod n: Es sei n (- N mit n > 1. Fr x (- Z bezeichne
   
                                  x mod n
                                      
   die eindeutig bestimmte Zahl m (- {0, ..., n - 1} mit
   
                                m =_ x mod n
                                      
   Vorbemerkung
   
   ShowView-Codes sind 1- bis 9-stellige Zahlen, die nicht durch 1000
   teilbar sind. Ein Code wird im Videorekorder abhngig vom aktuellen
   Monat und Jahr zu einem Tag, einem Kanal, einer Startzeit und einer
   Dauer dekodiert. Derselbe Code fhrt also in verschiedenen Monaten
   oder Jahren zu verschiedenen "Sendungen". Damit der Videorekorder die
   richtige Sendung aufnehmen kann, muss die Kodierung (Sendung '-->
   Code) injektiv sein. Zustzlich ist auch die Dekodierung injektiv,
   d.h. verschiedene ShowView-Codes kodieren verschiedene "Sendungen".
   Dazu mssen die in den einzelnen Schritten verwendeten Funktionen
   injektiv sein. In der folgenden Beschreibung werden mehrmals
   lngenerhaltende Funktionen aus injektiven Funktionen konstruiert.
   Dass dies mglich ist und dass die so entstehenden Funktionen injektiv
   sind, ist Inhalt des folgenden Satzes.
   
   Satz 1: Gegeben sei eine injektive Abbildung (n) (n) f : N ---> N .
   Dann sei eine Abbildung n n y : N ---> N wie folgt definiert: Fr n x
   (- N sei
   
         (r) (i) n y(x) := f (x) mit r := min{1 < i (- N |f (- N }
                                      
   wobei f(i) die i-fach iterierte von f ist. Man wendet also f so lange
   an, bis dass das Ergebnis wieder n-stellig ist. Die lngenerhaltende
   Abbildung y ist wohldefiniert und injektiv.
   
   Beweis: Es sei x (- Nn beliebig. Da N(n) nur endlich viele Elemente
   hat, knnen in der Folge f(1)(x),f(2)(x),... nicht alle Elemente
   verschieden sein. Es gibt also i > j > 0 mit f(i)(x) = f(j)(x) . Da f
   injektiv ist, folgt: f(i-j)(x) = x (- Nn mit i - j > 0. y kann also
   wie angegeben definiert werden.
   
   Seien nun x,y (- Nn beliebig mit y (x) = y (y). Nach Definition von y
   ist y(x) = f(i)(x) und y(y) = f(j)(x) mit i, j (- N  \{0}
   kleinstmglich. Sei o.B.d.A. i > j. Dann folgt, da f injektiv ist:
   f(i- j)(x) = y (- Nn mit i - j > 0. Da i nach Definition die kleinste
   positive Zahl mit f(i)(x) (- Nn ist, muss i - j = 0 sein, d.h. es ist
   x = y. Also ist y injektiv.
   []
   
   Der Algorithmus
   
   Eine grafische Gesamtbersicht der aus acht Schritten bestehenden
   Dekodierung finden Sie [2]hier. Durch "klicken" auf einen Rahmen in
   der Grafik gelangen Sie zur Beschreibung des entsprechenden Schrittes.
   
   Schritt 1: Ist der Code eine 9-stellige Zahl a8a7a6a5a4a3a2a1a0, so
   wird er in die hchstens 8-stellige Zahl a := a7a6a5a4a3a2a1a0 und die
   Zahl a8 getrennt. Bisher gilt fr a8 die Einschrnkung 0 < a8 < 4. In
   [3]Schritt 8 wird a8 zur Berechnung der Startzeit und der Dauer
   bentigt.
   
   Schritt 2: In diesem Schritt wird aus der in [4]Schritt 1 abgetrennten
   Zahl a ein Zwischencode b berechnet. Dazu werden zuerst Abbildungen gn
   : N(n)---> N(n) wie folgt definiert: Es sei x = xn-1...x0 (- N(n) .
   Man schreibe x mit eventuell fhrenden Nullen n mal untereinander,
   wobei jede folgende Zeile um eine Stelle weiter nach links verschoben
   wird:
   
   xn-1 xn-2 ... x1 x0 xn-1 xn-2 ... x1 x0 .. . xn-1 xn-2 ... x1 x0 xn-1
          xn-2 ... x1 --x0-------------------- yn-1 yn-2 ... y1 y0
                                      
   Nun addiert man spaltenweise ohne bertrag modulo 10, also ist fr i
   (- {0, 1, ..., n - 1}:
   
                       ( ) sum i yi := xr mod 10 r=0
                                      
   Dann sei
   
                          gn(x) := y = yn-1 ...y0
                                      
   Da man die Ziffern von x sukzessive aus denen von y = gn(x) berechnen
   kann,
   
       x0 = y0 ( i sum -1 ) xi = yi- xr mod 10 fur 1 < i < n- 1 r=0
                                      
   ist gn injektiv. Nun sei fn := g(n3) die 3-fach iterierte von gn. Mit
   gn ist auch fn injektiv. Schlielich sei Fn : Nn- --> Nn die injektive
   lngenerhaltende Abbildung, die man nach [5]Satz 1 aus fn erhlt. Ist
   nun die in [6]Schritt 1 abgetrennte Zahl a n-stellig, so sei der
   Zwischencode:
   
                                 b := Fn(a)
                                      
   Bemerkung: Ist a nicht durch 1000 teilbar, so ist auch b nicht durch
   1000 teilbar. Denn es ist:
   
                    b = Fn(a) = f (i)(a) = g(3i)(a) n n
                                      
   und gn(x) ist nicht durch 1000 teilbar, wenn x es nicht ist. Denn ist
   x0 /= 0 , so auch y0 = x0. Ist x0 = 0 und x1 /= 0 , so auch y1 = x1.
   Ist x0 = x1 = 0 und x2 /= 0 , so auch y2 = x2.
   
   Schritt 3: Nun wird der hchstens 8-stellige Zwischencode b = b7...b0
   in die Zahl r := b2b1b0 - 1 und die hchstens 5-stellige Zahl c :=
   b7b6b5b4b3 zerteilt. Da ShowView-Codes nicht durch 1000 teilbar sind,
   gilt nach der [7]Bemerkung in Schritt 2: 0 < r < 998
   
   Schritt 4: Aus der in [8]Schritt 3 berechneten Zahl r erhlt man den
   Tag t durch:
   
                            |_ -r _| t = 32 + 1
                                      
   Dabei bezeichne |_ ... _| den ganzzahligen Teil einer Zahl.
   
   Schritt 5: In diesem Schritt werden aus der in [9]Schritt
   3 abgeteilten Zahl c zwei neue Zahlen, die "oberen Bits" o und ein
   "Offset" d , berechnet. Bisher ist dieser Schritt nur fr hchstens
   3-stellige Zahlen c mglich. Dazu werden zuerst Abbildungen gn : N(n)
   ---> N(n) wie folgt definiert: Es sei x = xn-1...x0 (- N(n) . Man
   schreibe den in [10]Schritt 4 berechneten Tag t gefolgt von den n
   Ziffern (evt. mit fhrenden Nullen) von x n+1 mal untereinander, wobei
   jede folgende Zeile um eine Stelle weiter nach rechts verschoben wird:
   
    t xn- 1 xn-2 ... x1 x0 t xn-1 xn-2 ... x1 x0 ... t x x ... x x n-t 1
   xn- 2 x ..1. x0 x -y-----y------...--y----y---- n- 1 n- 2 1 0 n-1 n-2
                                    1 0
                                      
   Nun addiert man spaltenweise ohne bertrag modulo 10, also ist fr i
   (- {0, 1, ..., n - 1}:
   
                    ( ) n sum -1 yi := t+ xr mod 10 r=i
                                      
   Dann sei
   
                          gn(x) := y = yn-1 ...y0
                                      
   Da man die Ziffern von x sukzessive aus denen von y = gn(x) berechnen
   kann,
   
   xn-1 = (yn-1- t) mod 10 ( n-1 ) xi = yi- t- sum xr mod 10 fur 0 < i <
                                 n-2 r=i+1
                                      
   ist gn injektiv. Mit diesen gn werden nun zwei neue Familien von
   Abbildungen fn und hn definiert. Dazu sei j := (J mod 100) mod 16
   wobei J das aktuelle Jahr ist. Ist nun x (- N(n) , so seien:
   
       fn(x) := g(jn+1)(x) j+ sum 1 ( ) hn(x) := g(in)(x) mod 10 i=1
                                      
   Da gn injektiv ist, ist auch fn injektiv.
   
   Sei nun c die in [11]Schritt 3 abgeteilte Zahl. Ist c = 0, so ist o =
   d = 0. Ist n c (- N mit n > 1, so ist
   
                                 o := Fn(c)
                                      
   wobei Fn : Nn ---> Nn die injektive lngenerhaltende Abbildung ist,
   die man nach [12]Satz 1 aus fn erhlt. Ist 1 < r (- N die kleinste
   Zahl mit o = fn(r)(c) , so ist:
   
             n sum -1 r- sum 1 (i) d := ci + hn(fn (c)) i=0 i=0
                                      
   wobei f(n0) die Identitt ist, d.h. f(n0)(x) = x A x (- N(n)
   
   Schritt 6: Nun wird aus der in [13]Schritt 3 abgeteilten Zahl r , dem
   in [14]Schritt 4 berechneten Tag t, dem in [15]Schritt 5 berechneten
   "Offset" d und dem aktuellen Monat m (Januar=1, ..., Dezember=12) eine
   Zahl "unteren Bits" u berechnet:
   
                        u := (r+ t(m + 1)+ d) mod 32
                                      
   Schritt 7: Aus den "Bits" der in den Schritten [16]5 und
   [17]6 berechneten Zahlen o und u werden nun zwei neue Zahlen z und k
   gebildet. Da o hchstens 3-stellig und u < 32 ist, haben die
   Binrdarstellungen dieser Zahlen maximal 10 bzw. 5 Stellen. Die
   Binrdarstellungen von o und u seien:
   
                  o = z9k4k3z8z7z6z5z4z3k2 u = z2k1z1k0z0
                                      
   Die Binrdarstellungen der neuen Zahlen z und k sind dann:
   
                 z := z9z8z7z6z5z4z3z2z1z0 k := k4k3k2k1k0
                                      
   Aus dem "Zeitindex" z wird in [18]Schritt 8 die Startzeit und die
   Dauer ermittelt.
   Der Kanal oder genauer die ShowView-Leitzahl L ergibt sich aus k wie
   folgt:
   
            { L = k + 1 fur 0 < k < 18 k + 81 fur 19 < k < 31
                                      
   Schritt 8: In diesem letzten Schritt werden die Startzeit S und die
   Dauer D aus einer Tabelle ermittelt. Die Tabelle enthlt 1024
   Eintrge, wobei jeder Eintrag aus einer Startzeit und einer Dauer
   besteht. Hier ein Ausschnitt der Tabelle:
   
   | | -Index---Startzeit---Dauer-in-Minuten-- 0 | 19:00 | 30 1 | 19:30 |
         30 .. | .. | .. . | . | . 1022 | 14:55 | 35 1023 14:05 35
                                      
   Alle Startzeiten und Dauern liegen in einem Fnfminutenraster, d.h.
   die Minuten der Startzeit und die Dauern sind modulo 5 gleich Null.
   Ist nun z der in [19]Schritt 7 berechnete "Zeitindex", sz die
   dazugehrige aus der Tabelle gelesene Startzeit, dz die entsprechende
   Dauer und a8 die in [20]Schritt 1 abgetrennte 9. Ziffer des
   ShowView-Codes, so ergeben sich die endgltige Startzeit und Dauer wie
   folgt:
   
                           S = sz + a8 D = dz- a8

References

   1. mailto:fichtner@mail.isis.de
   2. file://localhost/root/compile/showview/Uebersicht.html
   3. file://localhost/root/compile/showview/showview.html#schritt8
   4. file://localhost/root/compile/showview/showview.html#schritt1
   5. file://localhost/root/compile/showview/showview.html#satz
   6. file://localhost/root/compile/showview/showview.html#schritt1
   7. file://localhost/root/compile/showview/showview.html#bemerkung
   8. file://localhost/root/compile/showview/showview.html#schritt3
   9. file://localhost/root/compile/showview/showview.html#schritt3
  10. file://localhost/root/compile/showview/showview.html#schritt4
  11. file://localhost/root/compile/showview/showview.html#schritt3
  12. file://localhost/root/compile/showview/showview.html#satz
  13. file://localhost/root/compile/showview/showview.html#schritt3
  14. file://localhost/root/compile/showview/showview.html#schritt4
  15. file://localhost/root/compile/showview/showview.html#schritt5
  16. file://localhost/root/compile/showview/showview.html#schritt5
  17. file://localhost/root/compile/showview/showview.html#schritt6
  18. file://localhost/root/compile/showview/showview.html#schritt8
  19. file://localhost/root/compile/showview/showview.html#schritt7
  20. file://localhost/root/compile/showview/showview.html#schritt1
*/


int decode_showview_number(\
unsigned long showview,\
int *channel_id,\
int *start_year, int *start_month, int *start_day,\
int *start_hour, int *start_minute,\
int *length)
{
/* __________________TEST DATA_____________________ */

*channel_id = 0;
*start_year = 2000; 
*start_month = 11;
*start_day = 30;
*start_hour = 23;
*start_minute = 25;
*length = 90;


return 1;
} /* end function decode_showview_number */

