/* 
xcha
I read alt.tv.crypt

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "xcha.h"

FD_xcha *fdui;

FILE *filefd;


int save_setting(char *type, char *string)
{
char pathfilename[TEMP_SIZE];
FILE *setting_file;

/* combine with home directory */
sprintf(pathfilename, "%s/.xcha/setup/%s", home_dir, type);
setting_file = fopen(pathfilename, "w");
if(! setting_file)
	{
	fl_show_alert("Cannot open file for write:", pathfilename, "", 0);
	if(debug_flag)
		{
		fprintf(stdout, "\nCannot open setting file %s for write\n",\
		pathfilename);
		}
	return 0;
	}

fprintf(setting_file, "%s", string);
fclose(setting_file);
return 1;	
}/* end function save_setting */


char *load_setting(char *type)
{
int a;
char temp[1024];
char pathfilename[TEMP_SIZE];
FILE *setting_file;

/* combine with home directory */
sprintf(pathfilename, "%s/.xcha/setup/%s", home_dir, type);
setting_file = fopen(pathfilename, "r");
if(! setting_file)
	{
	fl_show_alert("Cannot open file for read:", pathfilename, "", 0);
	if(debug_flag)
		{
		fprintf(stdout, "\nCannot open setting file %s for read\n",\
		pathfilename);
		}
	return 0;
	}

a = readline(setting_file, temp);/* closes file if EOF */	
if(a != EOF) fclose(setting_file);
return strsave(temp);
}/* end function load_setting */


int save_fontsizes()
{
char temp[TEMP_SIZE];
sprintf(temp,\
"%d %d %d %d",\
main_form_fontsize,\
0,\
0,\
timer_form_fontsize\
);

if(! save_setting("fontsizes", temp) ) return 0;

return 1;
}/* end function save_fontsizes */


int load_fontsizes()
{
char *data_read;
int dummy;
 
data_read = (char *) load_setting("fontsizes");
if(! data_read) return 0;
sscanf(data_read,\
"%d %d %d %d",\
&main_form_fontsize,\
&dummy,\
&dummy,\
&timer_form_fontsize\
);

free(data_read);

/* for main form */
fl_set_browser_fontsize(fdui -> main_form_browser,\
integer_to_fontsize(main_form_fontsize) );

/* for timer form */
fl_set_browser_fontsize(fdui -> timer_form_browser,\
integer_to_fontsize(timer_form_fontsize) );

return 1;
}/* end function load_fontsizes */


int save_general_settings()
{
char *ptr;
char temp[TEMP_SIZE];

sprintf(temp,\
"%d %d %d %d %d %d %d %d %d %d %d %d",\
selected_program,\
sort_mode,\
selected_volume,\
log_messages_flag,\
0,\
teletext_flag,\
adjacent_flag,\
service_type_filter,\
selected_driver,\
0,\
0,\
log_signal_quality_flag\
);

save_setting("global_flags", temp);

return 1;
}/* end function save_general_settings */


load_general_settings()
{
char temp[512];
double da;
int error;
char *ptr;
FILE *pptr;
int dummy;

if(debug_flag)
	{
	fprintf(stdout, "load_general_settings(): arg none\n");
	}

error = 0;
ptr = load_setting("global_flags");
if(ptr)
	{
	sscanf(ptr,\
	"%d %d %d %d %d %d %d %d %d %d %d %d",\
	&selected_program,\
	&sort_mode,\
	&selected_volume,\
	&log_messages_flag,\
	&dummy,\
	&teletext_flag,\
	&adjacent_flag,\
	&service_type_filter,\
	&selected_driver,\
	&dummy,\
	&dummy,\
	&log_signal_quality_flag\
	);

	free(ptr);

	load_programs();

	/* build the list so we have a valid browser_line, not stored */
	/* note thus will be done again in main */
	if(! show_programs(SHOW_SELECTED_IN_MIDDLE) )
		{
		return;
		}

	/* select program */
	if(! select_program(selected_program) )
		{
//		return;
		}

	/* do the volume thing */
	da = selected_volume / 100.0;
	fl_set_slider_value(fdui -> main_form_volume_slider, da);

	sprintf(temp, "cmix %s %d\n", MIXER_VOLUME, selected_volume);
	pptr = popen(temp, "r");
	pclose(pptr);

	/* set the sort button */
	set_sort_button();

    /* set the log ca button */
    fl_set_button(fdui -> main_form_log_messages_button, log_messages_flag);

	/* set the teletext button */
	fl_set_button(fdui -> main_form_teletext_button, teletext_flag);

	/* set the service_type filter button */
	set_service_button(service_type_filter);

	/* set file mnu tick boxes */
	set_main_form_file_menu_adjacent();
	set_driver_select_button(selected_driver);
	set_main_form_recorder_menu_logging();

	/* start the teletext decoder if needed */
	if(teletext_flag)
		{
//		start_teletext_decoder();
		start_teletext_viewer();
		}
	}
else
	{
	error = 1;
	}
/* 
create setup files from defaults if some not found,
else use values just read.
*/
if(error) save_general_settings();

return 1;
}/* end function load_general_settings */


int set_sort_button()
{
int color;
char text[80];

if(debug_flag)
	{
	printf("set_sort_button(): arg none, using sort_mode=%d\n", sort_mode);
	}

switch(sort_mode)
	{
	case SORT_ALPHA:
		strcpy(text, "ALPHA SORT");
		color = FL_GREEN;
		break;
	case SORT_FREQUENCY:
		strcpy(text, "FREQ SORT");
		color = FL_YELLOW;
		break;
	case SORT_PROGRAM_NUMBER:
		strcpy(text, "PROG SORT");
		color = FL_MAGENTA;
		break;
	case SORT_PROVIDER:
		strcpy(text, "PROV SORT");
		color = FL_CYAN;
		break;
	} /* end switch sort_mode */

fl_set_object_label(fdui -> main_form_sort_button, text);
fl_set_object_color(\
	fdui -> main_form_sort_button, color, color);

return 1;
} /* end function set_sort_button */


char *expand_tabs(char *text, int tabsize)
{
int c, i, j, k;
int tabs;
char *space;

if(debug_flag)
	{
	fprintf(stdout, "expand_tabs(): arg text=%s tabsize=%d\n",\
	text, tabsize);
	}

/* argument check */
if(! text) return 0;
if(tabsize < 0) return 0;

/* determine hom many tabs, so we can calculate the required space */
i = 0;
tabs = 0;
while(1)
	{
	c = text[i];
	if(c == 0) break;
	if(c == 9) tabs++;
	i++;
	}/* end while all characters in text */

space = malloc(strlen(text) + (tabs * tabsize) - tabs + 1 + 1);
if(! space) return 0;

/* copy and expand */
i = 0;
j = 0;
while(1)
	{
	c = text[i];
	if(c == 9)
		{
		for(k = 0; k < tabsize; k++)
			{
			space[j] = ' ';
			j++;
			}
		i++;
		continue;
		}
	else
		{
		space[j] = c;
		}
	if(c == 0) break;
	i++;
	j++;
	}
return space;
}/* end function expand_tabs */


int set_service_button(int service_type)
{
int color;
char text[80];

if(debug_flag)
	{
	printf("set_service_button(): arg service_type=%d\n", service_type);
	}

switch(service_type)
	{
	case ANY_SERVICE:
		strcpy(text, "ANY SERVICE");
		color = FL_COL1;
		break;
	case DIGITAL_TV_SERVICE:
		strcpy(text, "D TV");
		color = FL_GREEN;
		break;
	case DIGITAL_RADIO_SERVICE:
		strcpy(text, "D RADIO");
		color = FL_BLUE;
		break;
	case TELETEXT_SERVICE:
		strcpy(text, "TELETEXT");
		color = FL_RED;
		break;
	case MOSAIC_SERVICE:
		strcpy(text, "MOSAIC");
		color = FL_MAGENTA;
		break;
	case PAL_SERVICE:
		strcpy(text, "PAL TV");
		color = FL_CYAN;
		break;
	case SECAM_SERVICE:
		strcpy(text, "SECAM TV");
		color = FL_YELLOW;
		break;
	case D_D2_MAC_SERVICE:
		strcpy(text, "D/D2MAC TV");
		color = FL_DARKORANGE;
		break;
	case FM_RADIO:
		strcpy(text, "FM RADIO");
		color = FL_DARKGOLD;
		break;
	case NTSC_SERVICE:
		strcpy(text, "NTSC TV");
		color = FL_INDIANRED;
		break;
	case DATA_SERVICE:
		strcpy(text, "DATA");
		color = FL_DEEPPINK;
		break;
	default:
		sprintf(text, "%d", service_type);
		color = FL_ORCHID;
		break; 
	} /* end switch service_type */

fl_set_object_label(fdui -> main_form_service_button, text);
fl_set_object_color(fdui -> main_form_service_button, color, color);

return 1;
} /* end function set_service_button */


set_driver_select_button(int driver)
{
int color;
char text[80];

if(debug_flag)
	{
	printf("set_driver_select_button(): arg driver=%d\n", driver);
	}

switch(selected_driver)
	{
	case DRIVER_0_9_3:
		strcpy(text, "DRIVER 0.9.3");
		color = FL_COL1;
		break;
	case DRIVER_0_9_4:
		strcpy(text, "DRIVER 0.9.4");
		color = FL_YELLOW;
		break;
	default:
		break;
	} /* end switch selected_driver */

fl_set_object_label(fdui -> main_form_driver_select_button, text);
fl_set_object_color(fdui -> main_form_driver_select_button, color, color);

return 1;
} /* end function set_driver_select_button */


int set_main_form_file_menu_adjacent()
{
if(debug_flag)
	{
	printf(\
	"set_main_form_file_menu_adjacent(): arg none using adjacent_flag=%d\n",\
	adjacent_flag);
	}

switch(adjacent_flag)
    {
    case 0:
      fl_set_menu_item_mode(fdui -> main_form_file_menu,\
		FILE_MENU_SEARCH_ADJACENT_FREQUENCIES, FL_PUP_BOX);
        break;
    case 1:   
      fl_set_menu_item_mode(fdui -> main_form_file_menu,\
        FILE_MENU_SEARCH_ADJACENT_FREQUENCIES, FL_PUP_CHECK);
        break;
    } /* end switch selected_decoder */

return 1;
} /* end function set_main_form_file_menu_adjacent */


int save_presets()
{
char pathfilename[TEMP_SIZE];
FILE *setting_file;
int i;

/* combine with home directory */
sprintf(pathfilename, "%s/.xcha/setup/presets", home_dir);
setting_file = fopen(pathfilename, "w");
if(! setting_file)
	{
	fl_show_alert("Cannot open file for write:", pathfilename, "", 0);
	if(debug_flag)
		{
		fprintf(stdout, "\nCannot open setting file %s for write\n",\
		pathfilename);
		}
	return 0;
	}

for(i = 0; i < 15; i++)
	{
	fprintf(setting_file, "%s\n", selected_preset_str[i]);
	}

fclose(setting_file);
return 1;	
}/* end function save_presets */


int load_presets()
{
int a, i;
char pathfilename[TEMP_SIZE];
FILE *setting_file;
char temp[TEMP_SIZE];

for(i = 0; i < 15; i ++)
	{
	selected_preset_str[i] = strsave("");
	if(! selected_preset_str[i]) return 0;
	}

/* combine with home directory */
sprintf(pathfilename, "%s/.xcha/setup/presets", home_dir);
setting_file = fopen(pathfilename, "r");
if(! setting_file)
	{
	fl_show_alert("Cannot open file for read:", pathfilename, "", 0);
	if(debug_flag)
		{
		fprintf(stdout, "\nCannot open setting file %s for read\n",\
		pathfilename);
		}
	return 0;
	}

for(i = 0; i < 15; i++)
	{
	a = readline(setting_file, temp); /* closes file if EOF */

	free(selected_preset_str[i] );
	selected_preset_str[i] = strsave(temp);
	if(! selected_preset_str[i]) return 0;
//	if(a == EOF) break;
	}

set_preset_button_labels();

return 1;
} /* end function load_presets */


int load_dirs()
{
int error;
char *data_read;

if(debug_flag)
	{
	printf("load_dirs(): arg none\n");
	}

error = 0;
data_read = (char *) load_setting("record_dir");
if(data_read)
	{
	if(record_dir) free(record_dir);
	record_dir = data_read;
	}
else
	{
	error = 1;
	}

data_read = (char *) load_setting("play_dir");
if(data_read)
	{
	if(play_dir) free(play_dir);
	play_dir = data_read;
	}
else
	{
	error = 1;
	}

if(error) return 0;
return 1;
} /* end function load_dirs */


int save_dirs()
{
int error;

if(debug_flag)
	{
	printf("save_dirs(): arg none using record_dir=%s play_dir=%s\n",\
	record_dir, play_dir);
	}

error  = 0;
if(! save_setting("record_dir", record_dir) ) error = 1;
if(! save_setting("play_dir", play_dir) ) error = 1;

if(error) return 0;
return 1;
} /* end function load_dirs */


int set_main_form_recorder_menu_logging()
{
if(debug_flag)
	{
	printf(\
	"set_main_form_recorder_menu_logging(): using selected_decoder=%d\n",\
	selected_decoder);
	}

switch(log_signal_quality_flag)
	{
	case 0:
      fl_set_menu_item_mode(fdui -> main_form_recorder_menu,\
        RECORDER_MENU_LOG_SIGNAL_QUALITY, FL_PUP_BOX);
 		break;
	case 1:
      fl_set_menu_item_mode(fdui -> main_form_recorder_menu,\
       	RECORDER_MENU_LOG_SIGNAL_QUALITY, FL_PUP_CHECK);
 		break;
	} /* end switch selected_decoder */

return 1;
} /* end function set_main_form_recorder_menu_logging */


