
/*
 * SERVICE DESCRIPTION TABLE
 *
 * Copyright (C) 1998  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as dent@cosy.sbg.ac.at, or
 * Thomas Mirlacher, Jakob-Haringerstr. 2, A-5020 Salzburg,
 * Austria
 *
 *------------------------------------------------------------
 *
 */

#ifndef __SDT_H__
#define __SDT_H__

#include <sys/types.h>

typedef unsigned short _u16;

#define MAXSECSIZE 32768
#define PID_SDT 0x11      /* Service Description Table */
#define HILO(x) (x##_hi << 8 | x##_lo)


typedef struct
{
char service_type;
char *provider_name;
char *service_name;
} dvb_descr_service_t;
struct dvb_sdt_descr_struct;


typedef struct dvb_sdt_descr_struct
{
dvb_descr_service_t *service;
char *country_avail;
struct dvb_sdt_descr_struct *next;
} dvb_sdt_descr_t;
struct dvb_sdt_service_struct;


typedef struct dvb_sdt_service_struct
{
u_int service_id;		// Service ID
u_char free_ca_mode;
dvb_sdt_descr_t *descr;
struct dvb_sdt_service_struct *next;
} dvb_sdt_service_t;


typedef struct
{
u_int version;
u_int ts_id;			// Transport Stream ID
u_int orig_nw_id;		// Original Network ID
dvb_sdt_service_t *service;
} dvb_sdt_t;

#define SDT_LEN 11

typedef struct
{
u_char	table_id						: 8;	//	0
u_char	section_length_hi				: 4;	//	1
u_char									: 3;
u_char	section_syntax_indicator		: 1;
u_char	section_length_lo				: 8;	//	2
u_char	transport_stream_id_hi			: 8;	//	3
u_char	transport_stream_id_lo			: 8;	//	4
u_char	current_next_indicator			: 1;	//	5
u_char	version_number					: 5;
u_char									: 2;
u_char	section_number					: 8;	//	6
u_char	last_section_number				: 8;	//	7
u_char	original_network_id_hi			: 8;	//	8
u_char	original_network_id_lo			: 8;	//	9
u_char									: 8;	//	10
} sdt_t;


#define SDT_DESCR_LEN 5

struct sdt_descr_struct
{
u_char	service_id_hi					: 8;	//	0
u_char	service_id_lo					: 8;	//	1
u_char	eit_present_following_flag		: 1;	//	2
u_char	eit_schedule_flag				: 1;
u_char									: 6;
u_char	descriptors_loop_length_hi		: 4;	//	3
u_char	free_ca_mode					: 1;
u_char	running_status					: 3;
u_char	descriptors_loop_length_lo		: 8;	//	4
};
typedef struct sdt_descr_struct sdt_descr_t;


#define SDT_SERVICE_DESCRIPTOR 0x48

struct sdt_generic_descriptor
{
u_char	descriptor_tag					: 8;	//	0
u_char	descriptor_length				: 8;	//	1
};
	

struct sdt_service_descriptor_1
{
u_char	service_type					: 8;	//	0
u_char	service_provider_name_length	: 8;	//	1
};


struct sdt_service_descriptor_2
{
u_char	service_name_length				: 8;	//	0
};



struct sdt_service_desc
{
u_char	description_tag					: 8;	//	0
u_char	description_length				: 8;	//	1
u_char	service_type					: 8;	//	2
u_char	service_provider_name_length	: 8;	//	3
};


#endif	
