#include "xcha.h"
#include "sdt.h"
#include "indentifier.h"
#include "descr.h"
#include <linux/types.h>

dvb_descr_service_t *descr_service (char *buf, int len);
char *descr_country_availability (char *buf, int len);


int ParseSDT(int fd)
{
/* specified in ETSI 486 */
#define MAX_SDT_SECTION_LENGTH 1024

int a, c, i, j, n;
int length;
byte buffer[MAX_SDT_SECTION_LENGTH + 12];
byte *ptr;
char temp[1024];
int transport_stream_id;
int service_type;
int free_ca_mode;
int service_id;
int frequency;
char service_name[1024];
char service_provider_name[1024];
int table_id;
int section_syntax_indicator;
int reserved1, reserved2;
int section_length;
int section_number;
int last_section_number;
int original_network_id;
int offset;
int header_size;
int sections[1024];
int have_all;
int eit_schedule_flag;
int eit_present_following_flag;
int running_status;
int descriptors_loop_length;
int index;
int description_tag;
int description_length;
int service_provider_name_length;
int service_type_length;
int bytes_read, to_be_read;
int loop_count;
int count;

if(debug_flag)
	{
	printf("ParseSDT(): arg fd=%d\n", fd);
	}

/* these flags indicate if the section is read */
for(i = 0; i < 1024; i++)
	{
	sections[i] = 0;
	}

loop_count = 0;
while(1)
	{
	if(debug_flag)
		{
		printf("ParseSDT() starting read\n");
		}

	do
		{
		if(loop_count > 1000)
			{
			printf("ParseSDT(): timeout id in length loop\n");

			return 1;
			}
		loop_count++;

		to_be_read = 4;
		ptr = buffer;		
		bytes_read = 0;
		while(1)
			{
			n = read_t(fd, ptr, to_be_read);
			if(n < 0)
				{
				if(n == -1)
					{
					/* timeout */
					printf("ParseSDT(): timeout read_t in length loop\n");

					return 1;
					}

				perror("ParseSDT(): read ");
				continue;
				}
			if(n == 0) break;

			to_be_read -= n;
			ptr += n;
			bytes_read += n;
			} /* end while try read */
		usleep(10000);
		} /* end do buffer length */
	while(bytes_read >= 4 && (buffer[0] != 0 || buffer[1] != 0x42) );

	length = ( (buffer[2] & 0x0f) << 8) | buffer[3];
	if(debug_flag)
		{
		printf("ParseSDT(): length=%d\n", length);
		}

	/* prevent out of range */
	if(length > MAX_SDT_SECTION_LENGTH)
		{
		if(debug_flag)
			{
			printf("ParseSDT(): length=%d incorrect aborting\n", length);
			}

		return 0;
		}

	/* read data */
	to_be_read = length;
	ptr = buffer;		
	bytes_read = 0;
	while(1)
		{
		n = read_t(fd, ptr, to_be_read);
		if(n < 0)
			{
			if(n == -1)
				{
				printf("ParseSDT(): timeout in data loop\n");

				return 1;
				}

			perror("ParseSDT(): read ");
			continue;
			}

		if(n == 0) break;

		to_be_read -= n;
		ptr += n;
		bytes_read += n;
		} /* end while buffer length */

	index = 0;

	transport_stream_id =	(buffer[0] << 8) | buffer[1];
	section_number =		buffer[3];
	last_section_number =	buffer[4];
	original_network_id =	(buffer[5] << 8) | buffer[6]; 
	reserved1 = buffer[7];
	index += 8;

	if(debug_flag)
		{
		printf("transport_stream_id=%d\n", transport_stream_id);
		printf("section_number=%d\n", section_number);
		printf("section_number=%d\n", section_number);
		printf("last_section_number=%d\n", last_section_number);
		printf("original_network_id=%d\n", original_network_id);
		printf("reserved1=%d\n", reserved1);

		for(i = 0; i < length; i++)
			{
			c = buffer[i];
 
			if(c >= ' ') printf("%c ", buffer[i]);
			else printf(" ");
			}
		printf("\n");

		for(i = 0; i < length; i++)
			{
			printf("buffer[%d]=0x%02x (dec %d) (%c)\n",\
			i, buffer[i], buffer[i], buffer[i]);
			}
		} /* end if debug_flag */

	/* test if we already processed this section */
	if(sections[section_number])
		{
		return 1;
		}

	/* set flag */
	sections[section_number] = 1;

	/* parse section */
	while(index < length)
		{
		if(index >= length) break;

		service_id = (buffer[index + 0] << 8) | buffer[index + 1];		
		descriptors_loop_length =\
					( (buffer[index + 3] & 0x0f) << 8) | buffer[index + 4];
		running_status =  (buffer[index + 3] & 0xe0) >> 5;
		free_ca_mode = 	(buffer[index + 3] & 0x10) >> 4;
		index += 5;
		count = 1;

		if(debug_flag)
			{
			printf("service_id=%d\n", service_id);
			printf("descriptors_loop_length=%d\n", descriptors_loop_length);
			printf("running_status=%d ", running_status);
			if(running_status == 0) printf("undefined\n");
			if(running_status == 1) printf("not running\n");
			if(running_status == 2) printf("starts in a few seconds\n");
			if(running_status == 3) printf("pausing\n");
			if(running_status == 4) printf("running\n");
			printf("free_ca_mode=%d ", free_ca_mode);
			if(free_ca_mode == 0) printf("not scrambled\n");
			if(free_ca_mode == 1) printf("scrambled\n");
			}

		description_tag = buffer[index];
		description_length = buffer[index + 1];
		service_type = buffer[index + 2]; 
		service_provider_name_length = buffer[index + 3];
		index += 4;
		count += 4;
		if(count > descriptors_loop_length) break;

		if(debug_flag)
			{
			printf("tag=%d\n", description_tag);
			printf("description_length=%d\n", description_length);
			printf("service_type=%d\n", service_type);
			printf("service_provider_name_length=%d\n",\
			service_provider_name_length);
			}

		for(j = 0; j < service_provider_name_length; j++)
			{
			c = buffer[index + j];
			
			if(c < ' ') continue;
			if(c > 126) continue;
			if(c == ':') c = 'x'; /* this would give problems parsing */

			service_provider_name[j] = c;
			count++;
			if(count > descriptors_loop_length) break;
			}
		service_provider_name[j] = 0;
		index += service_provider_name_length;

		service_type_length = buffer[index];
		index += 1;
		count += 1;
		if(count > descriptors_loop_length) break;

		if(debug_flag)
			{
			printf("service_type_length=%d\n", service_type_length);		
			}

		for(j = 0; j < service_type_length; j++)
			{
			c = buffer[index + service_provider_name_length + j];
			
			if(c < ' ') continue;
			if(c > 126) continue;
			if(c == ':') c = 'x'; /* this would give problems parsing */

			service_name[j] = c;

			count++;
			if(count > descriptors_loop_length) break;
			}
		service_name[j] = 0;
		index += service_type_length;

		if(debug_flag)
			{
			if(service_provider_name_length)
				{
				printf("%s (%s) ", service_name, service_provider_name);
				}
			else
				{
				printf("%s ", service_name);
				}

			printf("service_id=%d ", service_id);

			if(running_status == 0) printf("undefined ");
			if(running_status == 1) printf("not running ");
			if(running_status == 2) printf("starts in a few seconds ");
			if(running_status == 3) printf("pausing ");
			if(running_status == 4) printf("running ");

			if(free_ca_mode == 0) printf("not scrambled ");
			if(free_ca_mode == 1) printf("scrambled ");

			printf("\n");
			}

		/*
		add to structure:
		service_id
		service_name
		service_provider_name
		free_ca_mode
		*/
		if(transport_stream_id == nit_transport_stream_id)
			{
			frequency = nit_frequency;
			}
		else
			{
			frequency = scan_frequency;
			}

		switch(service_type)
			{
			case 0x01:
			case 0x02:
			case 0x03:
			case 0x06:
			case 0x07:
			case 0x08:
			case 0x09:
			case 0x0a:
			case 0x0b:
			case 0x0c:
				if(! add_to_program_list(\
				service_id,\
				service_name, service_provider_name,
				free_ca_mode, transport_stream_id,\
				frequency, service_type) )
					{
					fl_show_alert(\
					"ParseSDT():",\
					"could not add to program list",\
					"aborting",\
					0);

					return 0;
					}
				break;
			default:
				printf("ParseSDT(): unknown service type 0x%x\n",\
				service_type);
				break;
			} /* end switch service_type */

		save_programs();
		} /* end while index < length */

	/* test if we have read all sections */
//	if(section_number == last_section_number) break;
	have_all = 1;
	for(i = 0; i <last_section_number + 1; i++)
		{
		if(sections[i] == 0) have_all = 0;
		}
	if(have_all)
		{
		printf(\
		"SDT**********transport_stream_id=%d**************HAVE ALL\n",\
		transport_stream_id);

		return 1;
		}
	} /* end while all sections */

return 1;
} /* end function ParseSDT */


