#include "xcha.h"

int scan_satellite(\
int fd, unsigned int start_frequency, unsigned int end_frequency,\
unsigned int start_symbolrate, unsigned int end_symbolrate,\
unsigned int frequency_increment)
{
int a, c;
int scan_vpid, scan_apid, scan_tpid, scan_ca, scan_power;
int demux_fd;
char temp[1024];
int old_transport_stream_id;
int ans;
struct qpskFrontendInfo *info;
int start_symbol_rate;

if(debug_flag)
	{
	printf(\
	"scan_satellite(): arg fd=%d\n\
	start_frequency=%lu end_frequency=%lu\n\
	start_symbolrate=%lu end_symbolrate=%lu\n",\
	fd, start_frequency, end_frequency, start_symbolrate, end_symbolrate);
	}

/* get scan limits */
if( (ans = ioctl(fd_frontend, QPSK_FE_INFO, info) < 0) )
	{
	perror("QPSK FE INFO: ");

	return 0;
	}

printf("min Frequency   : %d\n", info -> minFrequency);
printf("max Frequency   : %d\n", info -> maxFrequency);
printf("min Symbol Rate : %d\n", info -> minSymbolRate);
printf("max Symbol Rate : %d\n", info -> maxSymbolRate);
printf("Hardware Type   : %d\n", info -> hwType);
printf("Hardware Version: %d\n", info -> hwVersion);

start_symbol_rate = info -> minSymbolRate;

//start_frequency = 11820;

stop_teletext_decoder();
clear_teletext_dir();

getpids_stop();

clear_status_line();

delete_all_programs();

scan_flag = 1;

				demux_fd = open("/dev/ost/demux", O_RDWR);
				if(demux_fd < 0)
					{
					perror("DEMUX DEVICE");
					fl_show_alert(\
					"scanning()", "could not open /dev/ost/demux", "", 0);
					return 0;
					}

scan_vpid = scan_apid = scan_tpid = 0;
scan_ca = 1;
scan_power = 1;
scan_disecq = 0;
scan_frequency = start_frequency;
while(1)
	{
	scan_symbolrate = start_symbolrate;
	while(1)
		{
		scan_polarization = 'v';
		while(1)
			{
			/* no more language */
			language[0] = 0;
		
			used_vpid = used_apid = used_tpid = 0;

			scan_power = 1;

			/* PMT not yet read in */
			have_pmt = 0;

//			if(debug_flag)
				{
				printf("scan_satellite():\n\
				scan_frequency=%lu\n\
				scan_symbolrate=%lu\n\
				scan_polarization=%c\n",\
				scan_frequency, scan_symbolrate, scan_polarization);
				}
			have_signal_flag = 0;
		
			/* tune to this channel */
			set_channel(\
				scan_frequency,\
				scan_polarization,\
				scan_disecq,\
				scan_symbolrate,\
				scan_vpid,\
				scan_apid,\
				scan_tpid,\
				scan_ca,\
				scan_power
				);

			if(have_signal_flag)
				{
				sleep(1);

				/* will be set if NIT could be read */
				nit_frequency = 0;
				nit_transport_stream_id = 0;

				/* get NIT */
				SetFilt(demux_fd, 0x10);
				if(! ParseNIT(demux_fd) )
					{
//					fl_show_alert(\
//					"scanning():", "could not parse NIT", "aborting", 0);
				
//					close(demux_fd);
//					return 0;	
					}

				StopFilt(demux_fd);
				} /* end if have_signal_flag */

printf("WAS nit_frequency=%d\n", nit_frequency);

			/* jump upwards to transponder frequency if known */
			if(nit_frequency)
				{
				if(scan_frequency < nit_frequency)
					{
					scan_frequency = nit_frequency;

printf("WAS re-tuning scan_frequency=%d\n", scan_frequency);

					have_signal_flag = 0;
		
					/* tune to this channel */
					set_channel(\
						scan_frequency,\
						scan_polarization,\
						scan_disecq,\
						scan_symbolrate,\
						scan_vpid,\
						scan_apid,\
						scan_tpid,\
						scan_ca,\
						scan_power
						);

					if(have_signal_flag)
						{
printf("WAS retuning success\n");
						}
					else
						{
printf("WAS retuning error\n");
						}

					} /* end if jumped to nit frequency */

				if(have_signal_flag)
					{
					/* get SDT */
					SetFilt(demux_fd, 0x11);
					if(! ParseSDT(demux_fd) )
						{
//						fl_show_alert(\
//						"scanning():", "could not parse SDT", "aborting", 0);
				
//						close(demux_fd);
//						return 0;	
						}

					StopFilt(demux_fd);
					} /* end if nit frequency */
				} /* end if have_signal_flag */


			if(scan_polarization == 'h') break;

			/* try the other polarity */
			if(scan_polarization == 'v') scan_polarization = 'h';
			} /* end for all polarizations */

		/* get next	 symbolrate */
		a = ioctl(fd, FE_GET_NEXT_SYMBOL_RATE, &scan_symbolrate);

		/* stop if maximum symbolrate reached */
		if(a == EINVAL) break;

		/* try next symbolrate */
		if(a == EBADF)
			{
			fl_show_alert(\
			"Could not set symbolrate", "bad file descriptor", "", 0);
			scan_flag = 0;
			return 0;
			}
		if(a == EFAULT)
			{
			fl_show_alert(\
			"Could not set symbolrate", "bad address", "", 0);
			scan_flag = 0;
			return 0;
			}
		if(a == ENOSYS)
			{
			fl_show_alert(\
			"Could not set symbolrate", "hardware error", "", 0);
			scan_flag = 0;
			return 0;
			}

		/* test for max symbolrate */
		if(scan_symbolrate >= end_symbolrate) break;

		} /* end while all symbolrates */

	/* jump upwards to transponder frequency if known */

//#define USE_IOCTL_NEXT_FREQ
#ifdef USE_IOCTL_NEXT_FREQ
	/* get next frequency steps 11700 to 12700, unusable */
	a = ioctl(fd, FE_GET_NEXT_FREQUENCY, &scan_frequency);
	
	/* stop if maximum frequency reached */
	if(a == EINVAL) break;

	/* try next frequency */
	if(a == EBADF)
		{
		fl_show_alert(\
		"Could not set frequency", "bad file descriptor", "", 0);
		scan_flag = 0;
		return 0;
		}
	if(a == EFAULT)
		{
		fl_show_alert(\
		"Could not set frequency", "bad address", "", 0);
		scan_flag = 0;
		return 0;
		}
	if(a == ENOSYS)
		{
		fl_show_alert(\
		"Could not set frequency", "hardware error", "", 0);
		scan_flag = 0;
		return 0;
		}
#else
	/* add 20 MHz */
	scan_frequency += frequency_increment;
#endif

	/* test for max frequency */
	if(scan_frequency >= end_frequency) break;

	} /* end while all frequencies */

close(demux_fd);

scan_flag = 0;

save_programs();

show_programs(SHOW_TOP);

if(debug_flag)
	{
	printf("end function scan_satellite()\n");
	}

return 1;
} /* end function scan_satellite */

