/*
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "xcha.h"

FD_xcha *fdui;

pthread_t *recorder_thread;
static int stop_recorder_flag = 0;
static int start_recorder_flag = 0;
static int recorder_running = 0;
static int record_fd;
static int play_fd;
static int fdv = -1;
static int fda = -1;

static int yskip;
static int volume;
static int pause_mode;

void pes_write (uint8_t *buf, int count, void *data)
{
write(record_fd, buf, count);
} /* end function pes_write */


void *recorder_routine()
{
int a, c;
char temp[1024];
int dvr_fd;
int demux_fd;
dvb_pid_t pids[5];
dvb_pid_t pida, pidv;
dvb_pid_t pid;
ipack pa;
ipack pv;
int i;
uint8_t buf[IN_SIZE];
char play_buffer[BUFFY];
int count;
int device;
struct pollfd pfd[1];
char *audiot = "MP2";
double da;

if(debug_flag)
	{
	printf("recorder_routine(): arg none\n");
	}

while(1)
	{
	if(start_recorder_flag)
		{
		sprintf(temp, "start recorder_routine\n");
		to_log(temp);
		if(debug_flag)
			{
			printf("%s", temp);
			}

		start_recorder_flag = 0;

		if(recorder_mode == RECORD_MODE)
			{
			record_fd = open(record_filename,\
			O_CREAT | O_RDWR | O_TRUNC,\
			S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH|S_IWOTH);
			if(record_fd < 0)
				{
				perror("record_filename");
				continue;
				}

			dvr_fd = open("/dev/ost/dvr", O_RDONLY | O_NONBLOCK);
			if(dvr_fd < 0)
				{
				perror("open /dev/ost/dvr for read failed ");

				close(record_fd);
				continue;
				}

			demux_fd = open("/dev/ost/demux", O_RDWR | O_NONBLOCK);
			if(demux_fd < 0)
				{
				perror("open /dev/ost/demux for read failed ");
	
				close(record_fd);
				close(dvr_fd);
				continue;
				}

			a = ioctl(demux_fd, DMX_GET_PES_PIDS, pids);
			if(a < 0)
				{
				perror("ioctl DMX_GET_PES_PIDS failed ");

				close(record_fd);
				close(dvr_fd);
				close(demux_fd);
				continue;
				}

			if(pids[0] != 65535 && pids[1] != 65535)
				{
				pida = pids[0];
				pidv = pids[1];

				setup_ts2pes(&pa, &pv, pids[0], pids[1],\
				pes_write, (void *)record_fd);
				}
			else
				{
				printf("recorder record no valid pids\n");
				close(record_fd);
				close(dvr_fd);
				close(demux_fd);
				continue;
				}

			if(debug_flag)
				{
				printf("recorder_routine(): vpid=%d apid=%d\n",\
				pidv, pida);
				}

			recorder_running = 1;
			recording_start_time = time(NULL);
			while(! stop_recorder_flag)
				{
				if(recorder_pause_flag)
					{
					usleep(10000);
					continue;
					}

				count = read(dvr_fd, buf, IN_SIZE);
				if(count < 0)
					{
					usleep(10000);					
					continue;
					}

				for(i = 0; i < count; i+= TS_SIZE)
					{
					int len = TS_SIZE;

					if( (count - i) < TS_SIZE)
						{
						printf("recorder_routine(): count < i\n");
						}

					pid = get_pid(buf + i + 1);
	
					if( !(buf[3 + i] & 0x10) ) continue; // no payload?

					if(pid == pidv) ts_to_pes(&pv, buf + i);
					else if(pid == pida) ts_to_pes(&pa, buf + i);
					}

				} /* end while ! stop_recorder_flag */

			close(demux_fd);
			close(dvr_fd);
			close(record_fd);
			} /* end if recorder_mode is RECORD_MODE */
		else if(recorder_mode == PLAYBACK_MODE)
			{
			play_fd = open(play_filename, O_RDONLY);
			if(play_fd < 0)
				{
				perror("play_filename");
				continue;
				}

			play_length = lseek(play_fd, 0, SEEK_END);
			lseek(play_fd, 0, SEEK_SET);

			device = 0;
			a = open_av(&fdv, &fda, device);
			if(a < 0)
				{
				printf("recorder_routine(): play: open_av() failed\n");

				close(play_fd);
				continue;
				}

			if(audioSetStreamtype(fda, audiot) < 0)
				{
				printf("audioSetStreamtype(0) failed\n");
				}

			/*
			this code is not implemented (empty space) in
			convergence driver 0.9.2, 0.9.3 and 0.9.4!
			*/
//			if(videoSetStreamtype(fdv, "PROG") < 0)
//			if(videoSetStreamtype(fdv, "MPEG2") < 0)
//				{
//				printf("videoSetStreamtype(): failed\n");
//				} 

			if(debug_flag)
				{
				printf("recording_routine(): playback_mode\n\
				play_fd=%d play_filename=%s fdv=%d fda=%d\n",\
				play_fd, play_filename, fdv, fda);
				}

			videoSelectSource(fdv, VIDEO_SOURCE_MEMORY);

			audioSetAVSync(fda, true);
//			audioSetAVSync(fda, false);

			videoPlay(fdv);

			pfd[0].fd = fdv;
			pfd[0].events = POLLOUT;

			recorder_running = 1;
			while(1)
				{
				if(stop_recorder_flag) break;

				if(recorder_pause_flag)
					{
					if(pause_mode == 0)
						{
						audioPause(fda);
						videoFreeze(fdv);
						pause_mode = 1;
						}
					usleep(10000);

					continue;
					} /* end if recorder_pause_flag */
				else
					{
					if(pause_mode == 1)
						{
						audioContinue(fda);
						videoContinue(fdv);
						audioSetAVSync(fda, true);
						pause_mode = 0;
						} /* end if pause_mode is 1 */
					} /* end if ! recorder_pause_flag */

				if(seek_flag)
					{
                    audioPause(fda);
                    videoFreeze(fdv);

  					lseek(play_fd, seek_position, SEEK_SET);

					audioContinue(fda);
					videoContinue(fdv);
					audioSetAVSync(fda, true);

					play_position = seek_position;
					seek_flag = 0;
					} /* end if seek_flag */
				count = read(play_fd, play_buffer, BUFFY);
				if(count > 0)
					{
					int written = 0;

					play_position += count;
					while(written < count)
						{
						if(stop_recorder_flag) break;

						c = 0;
						if( poll(pfd, 1, 100) )
							{
							if(pfd[0].revents & POLLOUT)
								{
								c = write(fdv, play_buffer + written,\
								count - written);
								} /* end if POLLOUT */
							} /* end if poll */

						if(c > 0) written += c;
						if(c < 0)
							{
							usleep(10000);
							}

						} /* end while written < count */

					} /* end if count > 0 */
				else
					{
					break;
					}
				} /* end while read */

			videoStop(fdv);
			audioStop(fda);

			close(fdv);
			close(fda);
			close(play_fd);
			} /* end if recorder_mode is PLAYBACK_MODE */
	
		/* push the recorder stop button */ 
		stop_button_flag = 1;

		sprintf(temp, "exit recorder_routine\n");
		to_log(temp);
		if(debug_flag)
			{
			printf("%s", temp);
			}

		} /* end if start_recorder_flag */

	recorder_running = 0;

	/* take it easy on processor cycles */
	usleep(10000);
	} /* end while recorder_decoder */

return;
} /* end function recorder_routine */


int recorder_init()
{
if(debug_flag)
	{
	printf("recorder_init(): arg none\n");
	}

pthread_create(\
(pthread_t *)&recorder_thread, NULL ,\
&recorder_routine, NULL);

return 1;
} /* end function recorder_init */


int start_recorder()
{
if(debug_flag)
	{
	printf("start_recorder(): arg none\n");
	}

play_position = 0;
seek_flag = 0;
pause_mode = 0;
stop_recorder_flag = 0;
start_recorder_flag = 1;
} /* end function start_recorder_decoder */


int stop_recorder()
{
if(debug_flag)
	{
	printf("stop_recorder(): arg none\n");
	}

stop_recorder_flag = 1;

if(recorder_running)
	{
	stop_recorder_flag = 1;
	while(recorder_running)
		{
		usleep(100000);
		}
	}

stop_recorder_flag = 0;
} /* end function stop_recorder_decoder */



/*
void play_file_video(int filefd, int fd, int fda, int next)
{
	char buf[BUFFY];
	int count,c;
	int written;
	struct pollfd pfd[NFD];
	int stopped = 0;
	uint64_t length = 0;
	uint64_t l = 0;

	pfd[0].fd = STDIN_FILENO;
	pfd[0].events = POLLIN;
	
	pfd[1].fd = fd;
	pfd[1].events = POLLOUT;

	if (fda) audioSetAVSync(fda, true);
	if (!next){
		videoSelectSource(fd,VIDEO_SOURCE_MEMORY);
		videoPlay(fd);
	}		
	
	length = lseek(filefd, 0, SEEK_END);
	lseek(filefd,0,SEEK_SET);
	printf("File length: %2.2f MB\r\n",(double)length/1024/1024);
	yskip++;
	count = read(filefd,buf,BUFFY);
	write(fd,buf,count);
	if (count > 0)  l+= count;
	
//	set_volume(fda, volume);
//	mvprintw(yskip+1,30,
//		 "Volume: %d",volume);
//	mvprintw(yskip,30, "playback started  ");
//	refresh();

	while ( l < length ){
		if ( (count = read(filefd,buf,BUFFY)) < 0){
			perror("AUDIO DEVICE: ");
			exit(1);
		}		
		
		if (count > 0) l+= count;
//		mvprintw(yskip,0,"read %02.2f%%",100.0*l/length);
//		refresh();

		written = 0;
		while(count >0 && written < count){
			if (poll(pfd,NFD,1000)){
				if (pfd[1].revents & POLLOUT){
					c = write(fd,buf+written,
							count-written);
					if (c > 0) written += c;
				}

continue;

				if (pfd[0].revents & POLLIN){
//					int cc = getch();
					int cc = getc(stdin);
					switch(cc){
					case 'z':
//						mvprintw(yskip,30,
//							 "playback frozen   ");
						audioPause(fda);
						videoFreeze(fd);
						stopped = 1;
						break;
					case 's':
//						mvprintw(yskip,30,
//							 "playback stopped  ");
						videoStop(fd);
						audioStop(fda);
						stopped = 1;
						break;
			
					case 'c':
//						mvprintw(yskip,30,
//							"playback continued ");
						audioContinue(fda);
						videoContinue(fd);
						audioSetAVSync(fda, true);
						stopped = 0;
						break;

					case 'p':
//						mvprintw(yskip,30,
//							 "playback started  ");
						audioSetAVSync(fda, true);
						audioPlay(fda);
						videoPlay(fd);
						stopped = 0;
						break;

					case 'f':
//						mvprintw(yskip,30,
//							 "fast forward      ");
						audioSetAVSync(fda, false);
						audioPause(fda);
						videoFastForward(fd,0);
						stopped = 0;
						break;

					case 'm':
//						mvprintw(yskip,30,
//							 "slow motion       ");
						audioSetAVSync(fda, false);
						audioPause(fda);
						videoSlowMotion(fd,2);
						stopped = 0;
						break;
						
					case '+':
//						set_volume(fda, volume+1);
//						mvprintw(yskip+1,30,
//							 "Volume: %d",volume);
						break;

					case '-':
//						set_volume(fda, volume-1);
//						mvprintw(yskip+1,30,
//							 "Volume: %d",volume);
						break;


					case 'q':
						videoContinue(fd);
						exit(0);
						break;
					}
				}
				
			}
		}
	}
	if (fda) audioSetAVSync(fda, false);
}
*/
