/*
xcha

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "xcha.h"

FD_xcha *fdui;

struct program *lookup_program(char *name)
{
struct program *pa;

for(pa = programtab[0]; pa != 0; pa = pa -> nxtentr)
	{
	if(strcmp(pa -> name, name) == 0) return pa;
	}

return 0; /* not found */
} /* end function lookup_program */


struct program *install_program_at_end_of_list(char *name)
{
struct program *plast, *pnew;

if(debug_flag)
	{
	fprintf(stdout,\
	"install_program_at_end_off_list(): arg name=%s\n", name);
	}

pnew = lookup_program(name);
if(pnew)
	{
	/* free previous definition */
	free(pnew -> service_name);
	return pnew; /* already there */
	}

/* create new structure */
pnew = (struct program *) calloc(1, sizeof(*pnew) );
if(! pnew)
	{
	fprintf(stdout,\
	"install_program_at_end_of_list(): coul not allocate space struct\n");

	return 0;
	}

pnew -> name = strsave(name);
if(! pnew -> name) return 0;

/* get previous structure */
plast = programtab[1]; /* end list */

/* set new structure pointers */
pnew -> nxtentr = 0; /* new points top zero (is end) */
pnew -> prventr = plast; /* point to previous entry, or 0 if first entry */

/* set previous structure pointers */
if( !programtab[0] ) programtab[0] = pnew; /* first element in list */
else plast -> nxtentr = pnew;

/* set array end pointer */
programtab[1] = pnew;

return pnew; /* pointer to new structure */
}/* end function install_program */


int delete_program(char *name)/* delete entry from double linked list */
{
struct program *pa, *pprev, *pdel, *pnext;

if(debug_flag)
	{
	fprintf(stdout, "delete_program(): arg name=%s\n", name);
	}

/* argument check */
if(! name) return 0;

pa = programtab[0];
while(1)
	{
	/* if end list, return not found */
	if(! pa) return 0;

	/* test for match in name */
	if(strcmp(name, pa -> name) != 0) /* no match */
		{
		/* point to next element in list */
		pa = pa -> nxtentr;

		/* loop for next element in list */
		continue;
		}

	/* we now know which struture to delete */
	pdel = pa;

	/* get previous and next structure */
	pnext = pa -> nxtentr;
	pprev = pa -> prventr;

	/* set pointers for previous structure */
	/* if first one, modify programtab[0] */
	if(pprev == 0) programtab[0] = pnext;
	else pprev -> nxtentr = pnext;

	/* set pointers for next structure */
	/* if last one, modify programtab[1] */
	if(pnext == 0) programtab[1] = pprev;
	else pnext -> prventr = pprev;
	
	/* delete structure */	
	free(pdel -> name);
	free(pdel -> service_name);
	free(pdel); /* free structure */

	/* return OK deleted */
	return 1;
	}/* end for all structures */
}/* end function delete_program */


int delete_all_programs()/* delete all entries from table */
{
struct program *pa;

if(debug_flag)
	{
	fprintf(stdout, "delete_all_programs() arg none\n");
	}

while(1)
	{	
	pa = programtab[0];
	if(! pa) break;
	programtab[0] = pa -> nxtentr;
	free(pa -> name);
	free(pa -> service_name);
	free(pa);/* free structure */
	}/* end while all structures */

programtab[1] = 0;
return 1;
}/* end function delete_all_programs */


int save_programs()
{
char temp[TEMP_SIZE];
struct program *pa;
int a;
FILE *fptr;
FILE *pptr;

if(debug_flag)
	{
	fprintf(stdout, "save_programs (): arg none\n");
	}

/* save the new file as a tmp */
sprintf(temp, "%s/.xcha/programs.dat.tmp", home_dir);
fptr = fopen(temp, "w");
if(! fptr)
	{
	fprintf(stdout,\
	"save_programs (): could not open file %s for write\n",\
	temp);
	return 0;
	}

for(pa = programtab[0]; pa != 0; pa = pa -> nxtentr)	
	{
	fprintf(fptr,\
	"%s:%d:%c:%d:%d:%d:%d:%d:%d:%d:%d:%d\n",\
	pa -> service_name, pa -> frequency, pa -> polarization,\
	pa -> disecq, pa -> symbolrate, pa -> vpid, pa -> apid, pa -> tpid,\
	pa -> ca, pa -> pnr, pa -> transport_stream_id,\
	pa -> service_type);
	}	

fclose(fptr);

/* remove any old .bak file */
sprintf(temp, "%s/.xcha/programs.dat.bak", home_dir);
if(unlink(temp) != 0)
	{
//	fprintf(stdout, "scan_programs(): could not unlink %s\n",\
//	temp);

//	return 0;
	}

/* rename the old file to .bak */
sprintf(temp, "mv %s/.xcha/programs.dat %s/.xcha/programs.dat.bak",\
home_dir, home_dir);
pptr = popen(temp, "r");
pclose(pptr);

/* rename the temp file to the corrrect name */
sprintf(temp, "mv %s/.xcha/programs.dat.tmp %s/.xcha/programs.dat",\
home_dir, home_dir);
pptr = popen(temp, "r");
pclose(pptr);

return 1;
}/* end function save_programs */


int load_programs()
{
int a;
FILE *fptr;
char temp[READSIZE];
char temp2[READSIZE];
struct program *pa;
extern char *strsave();
char name[4096];
int frequency;
char polarization;
int disecq;
int symbolrate;
int vpid;
int apid;
int tpid;
int ca;
int pnr;
char *service_name;
struct stat *statptr;
int file_size;
int line;
int transport_stream_id;
int service_type;

if(debug_flag)
	{
	fprintf(stdout, "load_programs() arg none\n");
	}
	
delete_all_programs();

sprintf(temp, "%s/.xcha/programs.dat", home_dir); 
fptr = fopen(temp, "r");
if(! fptr)
	{
	fl_show_alert("Could not open file", temp, "for read", 0);

	if(debug_flag)
		{
		fprintf(stdout,\
		"load_programs(): could not open file %s for read\n",\
		temp);
		}

	return 0;
	} 

/*
need the length of this file, to prevent generating zero output length
files from defective )zero length) programs.dat
*/
/* allocate space for structure stat */
statptr = (struct stat*) malloc(sizeof(struct stat) );
if(! statptr)
	{
	fprintf(stdout,\
	"load_programs(): could not alllocate space for stat\n");

	return 0;
	}

/* fill the structure with data for this file */
fstat(fileno(fptr), statptr);

/* get filesize */
file_size = statptr -> st_size;

/* free the structure */
free(statptr);

/* test the filesize */
if(file_size == 0)
	{
	fprintf(stdout,\
	"load_programs(): %s has zero length aborting\n", temp);

	return 0;
	}

/* read the file */
line = 0;
while(1)
	{
	a = readline(fptr, temp);/* closes file on EOF */
	if(a == EOF) return 1;/* empty file or last line */

	line++;

	/* for compatibility with older versions */

	transport_stream_id = 0;
	service_type = 0;

	a = sscanf(temp,\
	"%a[^:]:%d:%c:%d:%d:%d:%d:%d:%d:%i:%d:%d",\
	&service_name, &frequency, &polarization, &disecq,\
	&symbolrate, &vpid, &apid, &tpid, &ca, &pnr, &transport_stream_id,\
	&service_type);

	sprintf(temp2,\
	"%s:%d:%c:%d:%d:%d:%d:%d:%d:%d",\
	service_name, frequency, polarization,\
	disecq, symbolrate, vpid, apid, tpid,\
	ca, pnr, transport_stream_id);

	if(a >= 10)
		{
		pa = install_program_at_end_of_list(temp2);
		if(! pa)
			{
			if(debug_flag)
				{
				fprintf(stdout,\
				"load_programs(): cannot install entry %s\n", temp);

				return 0;
				}
			} /* end if install failed */

		pa -> frequency = frequency;

		pa -> service_name = strsave(service_name);
		if(! pa -> service_name) return 0;

		pa -> polarization = polarization;
		pa -> disecq = disecq;
		pa -> symbolrate = symbolrate;
		pa -> vpid = vpid;
		pa -> apid = apid;
		pa -> tpid = tpid;
		pa -> ca = ca;
		pa -> pnr = pnr;
		pa -> service_type = service_type;

		if(a == 10) pa -> transport_stream_id = 0;
		else pa -> transport_stream_id = transport_stream_id;
		}/* end if a >= 10 */
	else
		{
		sprintf(temp, "line %d", line);
		fl_show_alert(\
		"File format error programs.dat", temp, "aborting", 0); 

		exit(1);
		}
	}/* end while all lines in programs.dat */

return 1;
}/* end function load_programs */


int swap_program_position(struct program *ptop, struct program *pbottom)
{
struct program *punder;
struct program *pabove;

if(debug_flag)
	{
	fprintf(stdout,\
	"swap_position(): swapping top=%lu bottom=%lu\n", ptop, pbottom);
	}

/* get one below the bottom */
punder = pbottom -> prventr;/* could be zero if first entry */
if(debug_flag)
	{
	fprintf(stdout,\
	"swap_position(): punder=%lu\n", punder);
	}

/* get the one above the top */
pabove = ptop -> nxtentr;/* could be zero if last entry */
if(debug_flag)
	{
	fprintf(stdout,\
	"swap_position(): pabove=%lu\n", pabove);
	}

/* the next pointer in punder (or programtab[0]) must now point to ptop */
if(! punder)
	{
	programtab[0] = ptop; 
	}
else
	{
	punder -> nxtentr = ptop;
	}

/* the prev pointer in ptop must now point to punder */
ptop -> prventr = punder;/* could be zero if first entry */

/* the next pointer in ptop must now point to pbottom */
ptop -> nxtentr = pbottom;

/* the next pointer in pbottom must now point to pabove */
pbottom -> nxtentr = pabove;

/* mark last one in programtab */
if(! pabove)
	{
	programtab[1] = pbottom;
	}
else
	{
	/* the prev pointer in pabove must now point to pbottom */
	pabove -> prventr = pbottom;
	}

/* the prev pointer in pbottom must now point to ptop */
pbottom -> prventr = ptop;

/* return swapped */
return 1;
}/* end function swap_program_position */


int sort_program_list(int mode)
/*
sorts the double linked program with criterium set by  mode.
doing some sort of bubble sort.
*/
{
int a, b;
int ca, cb;
struct program *pa;
struct program *pb;
int swap_flag;
char temp[4096];
FILE *pptr;
FILE *fptr;
char tempa[1024], tempb[1024];
char *ptr, *ptra, *ptrb;

if(debug_flag)
	{
	fprintf(stdout, "sort_program_list(): arg mode=%d\n", mode);
	}

/* sort the double linked list */
while(1)/* go through program again and again */
	{
	swap_flag = 0;
	for(pa = programtab[0]; pa != 0; pa = pa -> nxtentr)
		{
		pb = pa -> prventr;
		if(pb)
			{
			if(debug_flag)
				{
				fprintf(stdout, "pa->name=%s pb->name=%s\n",\
				pa -> name, pb -> name);
				}

			switch(mode)
				{
				case SORT_ALPHA:
					if(strcasecmp(pa -> service_name, pb -> service_name) < 0)
						{
						swap_flag = swap_program_position(pa, pb);
						/* indicate position was swapped */
						}/* end if condition */
					break;
				case SORT_FREQUENCY:
					if(pa -> frequency < pb -> frequency)
						{
						swap_flag = swap_program_position(pa, pb);
						}		
					break;
				case SORT_PROVIDER:
					tempa[0] = 0;
					tempa[0] = 0;

					ptra = strchr(pa -> service_name, '(');
					if(ptra)
						{
						strcpy(temp, ptra + 1);
						ptr = strchr(temp, ')');
						if(ptr) *ptr = 0;
						strcpy(tempa, temp);
						}

					ptrb = strchr(pb -> service_name, '(');
					if(ptrb)
						{
						strcpy(temp, ptrb + 1);
						ptr = strchr(temp, ')');
						if(ptr) *ptr = 0;
						strcpy(tempb, temp);
						}

					if(ptra && ptrb)
						{
						if( strcmp(tempa, tempb) < 0 )
							{
							swap_flag = swap_program_position(pa, pb);
							}
						}
					break;
				case SORT_PROGRAM_NUMBER:
					if(pa -> pnr < pb -> pnr)
						{
						swap_flag = swap_program_position(pa, pb);
						}
					break;
				} /* end switch mode */
			}/* end if pb */
		}/* end for all entries */

	/* if no more swapping took place, ready, program is sorted */
	if(! swap_flag) break;
	}/* end while go through program again and again */

return 1;
}/* end function sort_program_list */


int make_vdr_list()
{
struct program *pa;
char temp[4096];

for(pa = programtab[0]; pa != 0; pa = pa -> nxtentr)
    {
	/* make a unique entry */

	/* VDR format */
	sprintf(temp, "%s:%d:%c:%d:%d:%d:%d:%d:%d\n",\
	pa -> service_name, pa -> frequency, pa -> polarization,\
	pa -> disecq, pa -> symbolrate, pa -> vpid, pa -> apid,\
    pa -> ca, pa -> pnr);

	add_vdr_entry(\
		temp,\
		pa -> service_name,\
		pa -> symbolrate, pa -> frequency, pa -> polarization,\
		pa -> disecq, pa -> vpid, pa -> apid, pa -> tpid,
		pa -> ca, pa -> pnr);

	}/* end for all structure entries */

return 1;
}/* end function make_vdr_list */


int search_and_select_next_program()
{
int a;
struct program *pa;
char *keyword;
int case_sensitive_flag;
int found;

if(debug_flag)
	{
	fprintf(stdout, "search_and_select_next_program(): arg none\n");
	}

keyword = (char *)fl_get_input(fdui -> main_form_search_input_field);
if(! keyword) return 0;

case_sensitive_flag =\
fl_get_button(fdui -> main_form_search_case_button);

found = 0;
/* pa points to next entry */
for(pa = programtab[0]; pa != 0; pa = pa -> nxtentr)
	{
	/* search from last position (set to zero if keyword changes */
	if(pa -> browser_line <= last_found_line) continue;
	
	if(search_in_for(pa -> name, keyword, case_sensitive_flag) )
		{
		found = 1;
		}

	if(search_in_for(pa -> name, keyword, case_sensitive_flag) )
		{
		found = 1;
		}

	if(found)
		{
		free(selected_text);
		selected_text = strsave(pa -> name);

		/*
		maintain visible indication that line is selected with single
		click
		*/
		fl_select_browser_line(fdui -> main_form_browser, pa -> browser_line);

		/* show the entry */
		fl_set_browser_topline(fdui -> main_form_browser, pa -> browser_line);

//		/* select the entry */
//		fl_set_input(fdui -> main_form_text_input_field, pa -> name);

		/* remember where we are */
		last_found_line = pa -> browser_line;
		
		selected_program = atoi(pa -> name);

//		set_program_input(selected_start_program);

		/* return found */
		return 1;
		}/* end if found */
	}/* end for all program's */

if(last_found_line) fl_show_alert(keyword, "end of list", "", 0);
else fl_show_alert(keyword, "not found", "", 0);

last_found_line = 0;

/* return not found */
return 0;
}/* end function search_and_select_next_program */


int show_programs(int position)
{
int a, c, i;
char temp[TEMP_SIZE];
char temp2[TEMP_SIZE];
struct program *pa;
char formatstr[20];
int browser_line;
int browser_topline;
int first_new_program_line;
int find_first_new_program_flag;

int maxline;

if(debug_flag)
	{
	printf("show_programs(): arg position=%d using selected_program=%d\n",\
	position, selected_program);
	}

/* remember vertical slider position */
browser_topline = fl_get_browser_topline(fdui -> main_form_browser);

fl_freeze_form(fdui -> main_form);

fl_clear_browser(fdui -> main_form_browser);

first_new_program_line = -1;/* keep gcc -Wall from complaining */
find_first_new_program_flag = 1;
browser_line = 1;
for(pa = programtab[0]; pa != 0; pa = pa -> nxtentr)	
	{
	if(position == SHOW_UNREAD_AT_TOP)
		{
		/* want to show the first unaccessed at top of display */
		if(find_first_new_program_flag)
			{
			if(pa -> status == 1)
				{
				first_new_program_line = browser_line;
				find_first_new_program_flag = 0;
				}
			}
		}
	
	if(service_type_filter)
		{
		if(pa -> service_type != service_type_filter) continue;
		}

	strcpy(formatstr, "@b@i@f");

	if(pa -> status == 0) strcat(formatstr, "@C0");/* black */
	
	a = 1;
	for(i = 0; i < 20; i++)
		{
		temp2[i] = ' ';
		if(pa -> service_name[i] == 0) a = 0;

		if(a) temp2[i] = pa -> service_name[i];
		}
	temp2[i] = 0;	

	sprintf(temp,\
	"%s %sfreq=%5d %c dis=%1d sym=%5d VPID=%4d APID=%4d TPID=%4d CA=%1d pnr=%d tr=%d",\
	formatstr, temp2, pa -> frequency, pa -> polarization,\
	pa -> disecq, pa -> symbolrate, pa -> vpid, pa -> apid, pa -> tpid,\
	pa -> ca, pa -> pnr, pa -> transport_stream_id);


	fl_add_browser_line(fdui -> main_form_browser, temp);
	pa -> browser_line = browser_line;/* first one is 1 */
	browser_line++;
	}/* end for all elements in list */
	
/* re adjust browser for same position of top line (vertical slider) */	
if(position == SHOW_UNREAD_AT_TOP)
	{
	fl_set_browser_topline(fdui -> main_form_browser, first_new_program_line);
	}
if(position == SHOW_BOTTOM)
	{
	/* make the status of the last program visible */
	maxline = fl_get_browser_maxline(fdui -> main_form_browser);
	fl_set_browser_topline(fdui -> main_form_browser, maxline);
	}
/*
if(position == SHOW_TOP)
	{
	fl_set_browser_topline(fdui -> main_form_browser, 1);
	}
*/
if(position == SHOW_SAME_POSITION)
	{
	fl_set_browser_topline(fdui -> main_form_browser, browser_topline);
	}	

fl_unfreeze_form(fdui -> main_form);

/*
maintain visible indication that line is selected with single click
*/
fl_select_browser_line(fdui -> main_form_browser, selected_program );

if(position == SHOW_SELECTED_IN_MIDDLE)
	{
	fl_set_browser_topline(fdui -> main_form_browser, selected_program - 10);
	}	
else
	{
	/* show the entry */
	fl_set_browser_topline(fdui -> main_form_browser, selected_program);
	}

return 1;
}/* end function show_programs */


int search_in_for(char *database, char *data, int case_sensitive)
{
/* This function returns 1 if all words in data are present in database */
char *ptra, *ptrb, *ptrc;
int match_failed_flag;
int last_string_flag;
char *strsave();
char *strstr_case_insensitve();

if(debug_flag)
	{
	fprintf(stdout,\
	"search_in_for(): arg database=%s data=%s case_sensitive=%d\n",\
	database, data, case_sensitive);
	}

/* argument check */
if(! database) return 0;
if(! data) return 0;
if( (case_sensitive != 0) && (case_sensitive != 1) ) return 0;

/*
Test if some data,
data may consist of one or more words separated by spaces
*/
if(! data[0]) return 0;/* no data */

/* test if data present in database */
/* for all entries in data */
ptra = data;
ptrb = strsave(data);/* create space */
match_failed_flag = 0;
last_string_flag = 0;
while(1)
	{
	ptrc = ptrb;/* point to start availeble space */
	while(1)/* string in data to ptrb */
		{
		*ptrc = *ptra;
		if(! *ptra) break;/* end data */
		if(*ptra == ' ')/* end of string in data */
			{
			*ptrc = 0;
			ptra++;/* scip the space */
			break;
			}
		ptra++;
		ptrc++;
		}/* end while all characters in string */
	/* test if string present in database */
	if(case_sensitive)
		{
		if(! strstr(database, ptrb) )
			{
			match_failed_flag = 1;
			break;
			}
		}
	else
		{
		if(! strstr_case_insensitive(database, ptrb) )
			{
			match_failed_flag = 1;
			break;
			}
		}/* end if not case sensitive */
	if(! *ptra) break;/* end filter */
	}/* end while all strings in filter */	
free(ptrb);/* release space */

if(match_failed_flag) return 0;
return 1;
} /* end function search_in_for */


char *strstr_case_insensitive(char *s, char *t)
{
int i, j, k;
for(i = 0; s[i] != '\0'; i++)
	{
	for(j = i, k = 0; t[k] != '\0' &&  toupper(s[j]) == toupper(t[k]);\
	j++, k++)
	;
	if(t[k] == '\0') return s + i;
	}
return 0;
}/* end function strstr_case_insensitive */


int program_to_line(int programnr, int *line)
{
struct program *pa;
char name[50];

if(debug_flag)
	{
	fprintf(stdout, "program_to_line(): arg program=%d\n", programnr);
	}

sprintf(name, "%d", programnr);
pa = lookup_program(name);
if(! pa) return 0;

*line = pa -> browser_line;
return 1;
}/* end function program_to_line */


int add_program_in_position()
{
int a;
struct program *pa;
char temp[READSIZE];
char name[4096];
int frequency;
char polarization;
int disecq;
int symbolrate;
int vpid;
int apid;
int tpid;
int ca;
int pnr;
char station_name[1024];
int transport_stream_id;
char *ptr;

if(debug_flag)
	{
	fprintf(stdout,\
	"add_program_in_position(): arg none\n");
	}

ptr = (char *)fl_get_input(fdui -> main_form_description_input);
if(! ptr) return 0;
sprintf(station_name, "%s", ptr);

ptr = (char *)fl_get_input(fdui -> main_form_disecq_input);
if(! ptr) return 0;
disecq = atoi(ptr);

ptr = (char *)fl_get_input(fdui -> main_form_frequency_input);
if(! ptr) return 0;
frequency = atoi(ptr);

ptr = (char *)fl_get_input(fdui -> main_form_polarization_input);
if(! ptr) return 0;
polarization = tolower(ptr[0]);

ptr = (char *)fl_get_input(fdui -> main_form_symbolrate_input);
if(! ptr) return 0;
symbolrate = atoi(ptr);

ptr = (char *)fl_get_input(fdui -> main_form_program_number_input);
if(! ptr) return 0;
pnr = atoi(ptr);

ptr = (char *)fl_get_input(fdui -> main_form_vpid_input);
if(! ptr) return 0;
vpid = atoi(ptr);

ptr = (char *)fl_get_input(fdui -> main_form_apid_input);
if(! ptr) return 0;
apid = atoi(ptr);

ptr = (char *)fl_get_input(fdui -> main_form_tpid_input);
if(! ptr) return 0;
tpid = atoi(ptr);

ca = 0;

transport_stream_id = 0;

sprintf(temp,\
"%s:%d:%c:%d:%d:%d:%d:%d:%d:%d:%d",\
station_name, frequency, polarization,\
disecq, symbolrate, vpid, apid, tpid,\
ca, pnr, transport_stream_id);

/* sets status to new entry if found not to exist */
pa = install_program_at_end_of_list(temp);
if(! pa)
	{
	if(debug_flag)
		{
		fprintf(stdout,\
		"add_program_in_position(): cannot install entry %s\n", temp);

		return 0;
		}
	} /* end if install failed */

pa -> frequency = frequency;

pa -> service_name = strsave(station_name);
if(! pa -> service_name) return 0;

pa -> polarization = polarization;
pa -> disecq = disecq;
pa -> symbolrate = symbolrate;
pa -> vpid = vpid;
pa -> apid = apid;
pa -> tpid = tpid;
pa -> ca = ca;
pa -> pnr = pnr;
pa -> transport_stream_id = transport_stream_id;
pa -> service_type = 0;

/* 
sort the list, cause if item < first entry was entered it
would be at the end
*/
sort_program_list(sort_mode);

return 1;
}/* end function add_program_in_position */


add_to_program_list(\
int	service_id,\
char *service_name, char *service_provider_name,\
int free_ca_mode, int transport_stream_id, int frequency, int service_type)
{
char temp[4096];
int vpid, apid, tpid;
struct program *pa;
char service_descr[4096];
int service;

if(debug_flag)
	{	
	printf("add_to_program_list(): arg service_id=%d\n\
	service_name=%s service_provider_name=%s\n\
	free_ca_mode=%d transport_stream_id=%d frequency=%d\n\
	service_type=%d\n",\
	service_id, service_name, service_provider_name, free_ca_mode,\
	transport_stream_id, frequency,\
	service_type);
	}

vpid = apid = tpid = 0;

if(strlen(service_provider_name) )
	{
	sprintf(service_descr, "%s (%s)", service_name, service_provider_name);
	}
else
	{
	sprintf(service_descr, "%s", service_name);
	}

/* !!!!!!!!!!!!!!!!!!!!!! */
scan_disecq = 0;

/*
force a name, so even if empty name we have a valid entry.
*/
if(strlen(service_descr) == 0) strcpy(service_descr, "NO DATA");

/* make unique entry */
sprintf(temp, "%d:%d:%d", scan_disecq, transport_stream_id, service_id);

/* sets status to new entry if found not to exist */
pa = install_program_at_end_of_list(temp);
if(! pa)
	{
	if(debug_flag)
		{
		fprintf(stdout,\
		"add_program_in_position(): cannot install entry %s\n", temp);

		return 0;
		}
	} /* end if install failed */

switch(service_type)
	{
	case 0x01:
		service = DIGITAL_TV_SERVICE;
		break;
	case 0x02:
		service = DIGITAL_RADIO_SERVICE;
		break;
	case 0x03:
		service = TELETEXT_SERVICE;
		break;
	case 0x06:
		service = MOSAIC_SERVICE;
        break;
	case 0x07:
		service = PAL_SERVICE;
        break;
	case 0x08:
		service = SECAM_SERVICE;
        break;
	case 0x09:
		service = D_D2_MAC_SERVICE;
        break;
	case 0x0a:
		service = FM_RADIO;
        break;
	case 0x0b:
		service = NTSC_SERVICE;
        break;
	case 0x0c:
		service = DATA_SERVICE;
		break;
	default:
		service = ANY_SERVICE;
		break;
	} /* end switch service_type */

pa -> frequency = frequency;

pa -> service_name = strsave(service_descr);
if(! pa -> service_name) return 0;

pa -> polarization = scan_polarization;
pa -> disecq = scan_disecq;
pa -> symbolrate = scan_symbolrate;
pa -> vpid = vpid;
pa -> apid = apid;
pa -> tpid = tpid;
pa -> ca = free_ca_mode;
pa -> pnr = service_id;
pa -> transport_stream_id = transport_stream_id;
pa -> service_type = service;

/* 
sort the list, cause if item < first entry was entered it
would be at the end
*/
sort_program_list(sort_mode);

return 1;
} /* end function add_to_program_list */


int get_first_program_number(char *channel_name, int *prog_number)
{
struct program *pa;
int length;

if(debug_flag)
	{
	printf(\
	"get_first_program_number() arg channel_name=%s\n",\
	channel_name);
	}

length = strlen(channel_name);
if(! length) return 0;

for(pa = programtab[0]; pa != 0; pa = pa -> nxtentr)
	{
	if(strncmp(pa -> name, channel_name, length) == 0)
		{
		*prog_number = pa -> browser_line;

		return 1;
		}
	} /* end for all elements in list */

return 0;
} /* end function get_first_program_number */


int set_preset_button_labels()
{
char temp[80];
char temp1[80];
struct program *pa;
int i;
char *ptr;

if(debug_flag)
	{
	printf("set_preset_button_labels(): arg none\n");
	}

/* get first 3 characters of description */
for(pa = programtab[0]; pa != 0; pa = pa -> nxtentr)
	{
	for(i = 0; i < 3; i++)
		{
		temp[i] = pa -> name[i];
		}
	temp[i] = 0;

	/* find first space in description */
	ptr = strchr(pa -> name, ' ');
	if(ptr)
		{
		/* copy first 3 chars of second part descripton */
		ptr++;
		temp1[0] = *ptr;
		ptr++;
		temp1[1] = *ptr;
		ptr++;
		temp1[2] = *ptr;
		temp1[3] = 0;

		/* print second part on next line */
		strcat(temp, "\n");

		/* add second part description */
		strcat(temp, temp1);
		} /* end if second part description found */

	if(strcmp(pa -> name, selected_preset_str[0]) == 0)
		{
		fl_set_object_label(fdui -> main_form_preset0_button, temp);
		}
	else if(strcmp(pa -> name, selected_preset_str[1]) == 0)
		{
		fl_set_object_label(fdui -> main_form_preset1_button, temp);
		}
	else if(strcmp(pa -> name, selected_preset_str[2]) == 0)
		{
		fl_set_object_label(fdui -> main_form_preset2_button, temp);
		}
	else if(strcmp(pa -> name, selected_preset_str[3]) == 0)
		{
		fl_set_object_label(fdui -> main_form_preset3_button, temp);
		}
	else if(strcmp(pa -> name, selected_preset_str[4]) == 0)
		{
		fl_set_object_label(fdui -> main_form_preset4_button, temp);
		}
	else if(strcmp(pa -> name, selected_preset_str[5]) == 0)
		{
		fl_set_object_label(fdui -> main_form_preset5_button, temp);
		}
	else if(strcmp(pa -> name, selected_preset_str[6]) == 0)
		{
		fl_set_object_label(fdui -> main_form_preset6_button, temp);
		}
	else if(strcmp(pa -> name, selected_preset_str[7]) == 0)
		{
		fl_set_object_label(fdui -> main_form_preset7_button, temp);
		}
	else if(strcmp(pa -> name, selected_preset_str[8]) == 0)
		{
		fl_set_object_label(fdui -> main_form_preset8_button, temp);
		}
	else if(strcmp(pa -> name, selected_preset_str[9]) == 0)
		{
		fl_set_object_label(fdui -> main_form_preset9_button, temp);
		}
	else if(strcmp(pa -> name, selected_preset_str[10]) == 0)
		{
		fl_set_object_label(fdui -> main_form_preset10_button, temp);
		}
	else if(strcmp(pa -> name, selected_preset_str[11]) == 0)
		{
		fl_set_object_label(fdui -> main_form_preset11_button, temp);
		}
	else if(strcmp(pa -> name, selected_preset_str[12]) == 0)
		{
		fl_set_object_label(fdui -> main_form_preset12_button, temp);
		}
	else if(strcmp(pa -> name, selected_preset_str[13]) == 0)
		{
		fl_set_object_label(fdui -> main_form_preset13_button, temp);
		}
	else if(strcmp(pa -> name, selected_preset_str[14]) == 0)
		{
		fl_set_object_label(fdui -> main_form_preset14_button, temp);
		}
	} /* end for all elements in list */

return 1;
} /* end function set_preset_button_labels */


int set_preset_button_label_color(int preset_nr)
{
int color;

if(debug_flag)
	{
	printf(\
	"set_preset_button_label_color(): arg preset_nr=%d\n",\
	preset_nr);
	}

switch(preset_nr)
	{
	case 0:
		fl_set_object_lcol(fdui -> main_form_preset1_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset2_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset3_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset4_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset5_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset6_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset7_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset8_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset9_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset10_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset11_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset12_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset13_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset14_button, FL_BLACK);

		fl_set_object_lcol(fdui -> main_form_preset0_button, FL_WHITE);
		break;
	case 1:
		fl_set_object_lcol(fdui -> main_form_preset0_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset2_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset3_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset4_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset5_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset6_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset7_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset8_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset9_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset10_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset11_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset12_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset13_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset14_button, FL_BLACK);

		fl_set_object_lcol(fdui -> main_form_preset1_button, FL_WHITE);
		break;
	case 2:
		fl_set_object_lcol(fdui -> main_form_preset0_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset1_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset3_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset4_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset5_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset6_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset7_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset8_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset9_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset10_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset11_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset12_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset13_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset14_button, FL_BLACK);

		fl_set_object_lcol(fdui -> main_form_preset2_button, FL_WHITE);
		break;
	case 3:
		fl_set_object_lcol(fdui -> main_form_preset0_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset1_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset2_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset4_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset5_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset6_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset7_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset8_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset9_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset10_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset11_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset12_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset13_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset14_button, FL_BLACK);

		fl_set_object_lcol(fdui -> main_form_preset3_button, FL_WHITE);
		break;
	case 4:
		fl_set_object_lcol(fdui -> main_form_preset0_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset1_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset2_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset3_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset5_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset6_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset7_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset8_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset9_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset10_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset11_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset12_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset13_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset14_button, FL_BLACK);

		fl_set_object_lcol(fdui -> main_form_preset4_button, FL_WHITE);
		break;
	case 5:
		fl_set_object_lcol(fdui -> main_form_preset0_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset1_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset2_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset3_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset4_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset6_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset7_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset8_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset9_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset10_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset11_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset12_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset13_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset14_button, FL_BLACK);

		fl_set_object_lcol(fdui -> main_form_preset5_button, FL_WHITE);
		break;
	case 6:
		fl_set_object_lcol(fdui -> main_form_preset0_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset1_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset2_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset3_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset4_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset5_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset7_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset8_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset9_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset10_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset11_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset12_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset13_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset14_button, FL_BLACK);

		fl_set_object_lcol(fdui -> main_form_preset6_button, FL_WHITE);
		break;
	case 7:
		fl_set_object_lcol(fdui -> main_form_preset0_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset1_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset2_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset3_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset4_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset5_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset6_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset8_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset9_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset10_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset11_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset12_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset13_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset14_button, FL_BLACK);

		fl_set_object_lcol(fdui -> main_form_preset7_button, FL_WHITE);
		break;
	case 8:
		fl_set_object_lcol(fdui -> main_form_preset0_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset1_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset2_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset3_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset4_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset5_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset6_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset7_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset9_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset10_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset11_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset12_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset13_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset14_button, FL_BLACK);

		fl_set_object_lcol(fdui -> main_form_preset8_button, FL_WHITE);
		break;
	case 9:
		fl_set_object_lcol(fdui -> main_form_preset0_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset1_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset2_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset3_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset4_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset5_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset6_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset7_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset8_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset10_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset11_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset12_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset13_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset14_button, FL_BLACK);

		fl_set_object_lcol(fdui -> main_form_preset9_button, FL_WHITE);
		break;
	case 10:
		fl_set_object_lcol(fdui -> main_form_preset0_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset1_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset2_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset3_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset4_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset5_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset6_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset7_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset8_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset9_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset11_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset12_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset13_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset14_button, FL_BLACK);

		fl_set_object_lcol(fdui -> main_form_preset10_button, FL_WHITE);
		break;
	case 11:
		fl_set_object_lcol(fdui -> main_form_preset0_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset1_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset2_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset3_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset4_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset5_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset6_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset7_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset8_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset9_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset10_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset12_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset13_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset14_button, FL_BLACK);

		fl_set_object_lcol(fdui -> main_form_preset11_button, FL_WHITE);
		break;
	case 12:
		fl_set_object_lcol(fdui -> main_form_preset0_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset1_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset2_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset3_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset4_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset5_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset6_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset7_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset8_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset9_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset10_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset11_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset13_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset14_button, FL_BLACK);

		fl_set_object_lcol(fdui -> main_form_preset12_button, FL_WHITE);
		break;
	case 13:
		fl_set_object_lcol(fdui -> main_form_preset0_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset1_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset2_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset3_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset4_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset5_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset6_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset7_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset8_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset9_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset10_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset11_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset12_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset14_button, FL_BLACK);

		fl_set_object_lcol(fdui -> main_form_preset13_button, FL_WHITE);
		break;
	case 14:
		fl_set_object_lcol(fdui -> main_form_preset0_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset1_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset2_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset3_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset4_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset5_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset6_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset7_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset8_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset9_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset10_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset11_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset12_button, FL_BLACK);
		fl_set_object_lcol(fdui -> main_form_preset13_button, FL_BLACK);

		fl_set_object_lcol(fdui -> main_form_preset14_button, FL_WHITE);
		break;
	} /* end switch preset_nr */

return 1;
} /* end function set_preset_button_label_color */


char *get_selected_program_definition(int line)
{
struct program *pa;

if(debug_flag)
	{
	printf(\
	"get_selected_program_definition(): arg line=%d\n",\
	line);
	}

for(pa = programtab[0]; pa != 0; pa = pa -> nxtentr)
	{
	if(pa -> browser_line == line) return pa -> name;
	}

return 0; /* not found */
} /* end function get_selected_program_definition */


int str_to_program(char *string, int *programnr)
{
struct program *pa;

if(debug_flag)
	{
	printf("str_to_program(): arg string=%s\n", string);
	}

if(! string) return 0;

for(pa = programtab[0]; pa != 0; pa = pa -> nxtentr)
    {
    if(strcmp(pa -> name, string) == 0)
		{
		*programnr = pa -> browser_line;

		return 1;
		}
    }
 
return 0;
} /* end function str_to_program */

