#include "xcha.h"
#include "nit.h"
#include "indentifier.h"
#include "descr.h"
#include <linux/types.h>


int ParseNIT(int fd)
{
/* specified in ETSI 486 */
#define MAX_NIT_SECTION_LENGTH 1024

int a, c, i, j, n;
int length;
byte buffer[MAX_NIT_SECTION_LENGTH + 12];
byte *ptr;
char temp[1024];

int table_id;
int section_syntax_indicator;
int reserved1, reserved2;
int section_length;
int network_id;
int section_number;
int last_section_number;
int network_descriptors_length;
int offset;
int header_size;
int sections[1024];
int have_all;
int service_id;
int eit_schedule_flag;
int eit_present_following_flag;
int running_status;
int free_ca_mode;
int descriptors_loop_length;
int index;
int description_tag;
int description_length;
int service_type;
int service_provider_name_length;
int service_type_length;
char service_name[1024];
char service_provider_name[1024];
int bytes_read, to_be_read;
int loop_count;
dvb_nit_t *dvb_nit;
int transport_stream_id;

if(debug_flag)
	{
	printf("ParseNIT(): arg fd=%d\n", fd);
	}

/* these flags indicate if the section is read */
for(i = 0; i < 1024; i++)
	{
	sections[i] = 0;
	}

loop_count = 0;
while(1)
	{
	if(debug_flag)
		{
		printf("ParseNIT() starting read\n");
		}

	do
		{
		if(loop_count > 1000)
			{
			printf("ParseNIT(): timeout id in length loop\n");

			return 1;
			}
		loop_count++;

		to_be_read = 4;
		ptr = buffer;		
		bytes_read = 0;
		while(1)
			{
			n = read_t(fd, ptr, to_be_read);
			if(n < 0)
				{
				if(n == -1)
					{
					/* timeout */

					printf("ParseNIT(): timeout read_t in length loop\n");
					return 1;
					}

				perror("ParseNIT(): read ");
				continue;
				}
			if(n == 0) break;

			to_be_read -= n;
			ptr += n;
			bytes_read += n;
			} /* end while try read */
		usleep(10000);
		} /* end do buffer length */
	while(bytes_read >= 4 && (buffer[0] != 0 || buffer[1] != 0x40) );

	length = ( (buffer[2] & 0x0f) << 8) | buffer[3];
	if(debug_flag)
		{
		printf("ParseNIT(): length=%d\n", length);
		}

	/* prevent out of range */
	if(length > MAX_NIT_SECTION_LENGTH)
		{
		if(debug_flag)
			{
			printf("ParseNIT(): length=%d incorrect aborting\n", length);
			}

		return 0;
		}

	/* read data */
	to_be_read = length;
	ptr = buffer;		
	bytes_read = 0;
	while(1)
		{
		n = read_t(fd, ptr, to_be_read);
		if(n < 0)
			{
			if(n == -1)
				{
				printf("ParseNIT(): timeout in data loop\n");

				return 1;
				}

			perror("ParseNIT(): read ");
			continue;
			}

		if(n == 0) break;

		to_be_read -= n;
		ptr += n;
		bytes_read += n;
		} /* end while buffer length */

	network_id =			(buffer[4 - 4] << 8) | buffer[5 - 4];
	section_number =		buffer[7 - 4];
	last_section_number =	buffer[8 - 4];
	network_descriptors_length =\
							((buffer[9 - 4] & 0x0f) << 8) | buffer[10 - 4]; 

//	if(debug_flag)
		{
		printf("ParseNIT():\n");
		printf("network_id=%d\n", network_id);
		printf("section_number=%d\n", section_number);
		printf("last_section_number=%d\n", last_section_number);
		printf("network_descriptors_length=%d\n",\
		network_descriptors_length);
		} /* end if debug_flag */

	/* test if we already processed this section */
	if(sections[section_number])
		{
		return 1;
		}
	/* set flag */
	sections[section_number] = 1;

	/* the data starts at buffer + 11 */

	/* parse section */
	ptr = buffer + 7;

	dvb_nit = calloc(1, sizeof(dvb_nit_t) );
	if(! dvb_nit)
		{
		printf("could not allocate space for dvb_nit\n");

		return 0;
		}
	parse_nit(ptr, dvb_nit, network_descriptors_length);

	transport_stream_id = dvb_nit -> ts_id;

//	if(debug_flag)
		{
		printf("ParseNIT():\n");
		printf("transport_stream_id=%u\n", transport_stream_id);
		printf("original_network_id=%u\n", dvb_nit -> orig_nw_id);
		printf("name=%s\n", dvb_nit -> name);
		printf("frequency=%f\n", dvb_nit -> freq);
		}

	/* this causes big problems, 65535 seen! */
	if(dvb_nit -> orig_nw_id != network_id)
//	if(dvb_nit -> orig_nw_id == 65535)
		{
		printf(\
		"WAS org network id error! setting nit_frequency to zero!\n");

		nit_frequency = 0;
		return 0;		
		}
	else	
		{
		/* to be used by parse SDT to add to program list */
		nit_frequency = dvb_nit -> freq * 1000;
		}

	if(debug_flag)
		{
		printf("nit_frequency=%d\n", nit_frequency);
		printf("orbit=%.2f\n", dvb_nit -> orbit);

		if(dvb_nit -> west_east == 1) printf("west_east=east\n");
		else printf("west_east=west\n");

		switch(dvb_nit -> polar[0])
			{
			case 0:
				printf("polarization=linear horizontal\n");
				break;
			case 1:
				printf("polarization=linear vertical\n");
				break;
			case 2:
				printf("polarization=circular left\n");
				break;
			case 3:
				printf("polarization=circular right\n");
				break;
			} /* end switch polarization */
		printf("symbolrate=%.2f\n", dvb_nit -> rate * 1000.0);
		switch(dvb_nit -> qam)
			{
			case 0:
				printf("modulation=not defined\n");
				break;
			case 1:
				printf("modulation=16 QAM\n");
				break;
			case 2:
				printf("modulation=32 QAM\n");
				break;
			case 3:
				printf("modulation=64 QAM\n");
				break;
			case 4:
				printf("modulation=128 QAM\n");
				break;
			case 5:
				printf("modulation=256 QAM\n");
				break;
			} /* end switch modulation */

		switch(dvb_nit -> fec)
			{
			case 0:
				printf("FEC=not defined\n");
				break;
			case 1:
				printf("FEC=1/2\n");
				break;
			case 2:
				printf("FEC=2/3\n");
				break;
			case 3:
				printf("FEC=3/4\n");
				break;
			case 4:
				printf("FEC=5/6\n");
				break;
			case 5:
				printf("FEC=7/8\n");
				break;
			case 15:
				printf("no conv. coding\n");
				break;
			} /* end switch FEC */
		} /* end if debug_flag */

	free(dvb_nit);

	/* test if we have read all sections */
//	if(section_number == last_section_number) break;
	have_all = 1;
	for(i = 0; i <last_section_number + 1; i++)
		{
		if(sections[i] == 0) have_all = 0;
		}
	if(have_all)
		{
		printf(\
		"NIT**********transport_stream_id=%d**************HAVE ALL\n",\
		transport_stream_id);

		nit_transport_stream_id = transport_stream_id;

		return 1;
		}

	} /* end while all sections */

return 1;
} /* end function ParseNIT */


int parse_nit(u_char *buf, dvb_nit_t *dvb_nit, int descr_length) 
{
nit_t *nit = (nit_t *) buf;
nit_mid_t *nit_mid;
u_char *ptr = buf;
u_int sec_len;
int ts_loop_len;

if(debug_flag)
	{
	printf("parse_nit(): arg buf=%;u dvb_nit=%lu descr_length=%d\n",\
	buf, dvb_nit, descr_length);
	}

_parse_nit_descr(ptr, dvb_nit);

ptr += descr_length;

nit_mid = (nit_mid_t *) ptr;
ts_loop_len = HILO(nit_mid -> transport_stream_loop_length);
	
ptr += 2;

while(ts_loop_len > 0)
	{
	nit_ts_t *nit_ts = (nit_ts_t *) ptr;
	int ts_descr_len;

	dvb_nit->ts_id = HILO(nit_ts -> transport_stream_id);
	dvb_nit->orig_nw_id = HILO(nit_ts -> original_network_id);

	ts_descr_len = HILO(nit_ts -> transport_descriptors_length);

	ptr += 6; 
	ts_loop_len -= 6 + ts_descr_len;

	while(ts_descr_len > 0)
		{
		_parse_nit_descr(ptr, dvb_nit);

		ts_descr_len -= get_descr_len(ptr) + DESCR_GEN_LEN;
		ptr += get_descr_len(ptr) + DESCR_GEN_LEN;
		}
	} /* end while */

return 0;
} /* end function parse_nit */ 


int _parse_nit_descr(u_char *ptr, dvb_nit_t *dvb_nit)
{
int a;

if(debug_flag)
	{
	printf("_parse_nit_descr(): ptr=%lu dvb_nit=%lu\n",\
	ptr, dvb_nit);
	}

a = get_descr(ptr);
if(debug_flag)
	{
	printf("_parse_nit_descr(): switch: a=%d (0x%x)\n", a, a);
	}

switch(a)
	{
	case DESCR_NW_NAME:
		if(dvb_nit -> name) free (dvb_nit -> name);
		dvb_nit->name = calloc(1, get_descr_len(ptr) + 1);
		memcpy(dvb_nit -> name, ptr + DESCR_GEN_LEN, get_descr_len(ptr) );
		break;
	case DESCR_STUFFING:
		break;
	case DESCR_SAT_DEL_SYS:
		{
		struct descr_satellite_delivery_system_struct *descr =\
		(struct descr_satellite_delivery_system_struct *)\
		(ptr + DESCR_GEN_LEN);

		dvb_nit -> freq  = 1E2 * ((descr -> frequency1 & 0xF0) >> 4);
		dvb_nit -> freq += 1E1 * (descr -> frequency1 & 0x0F);
		dvb_nit -> freq += 1E0 * ((descr -> frequency2 & 0xF0) >> 4);
		dvb_nit -> freq += 1E-1 * (descr -> frequency2 & 0x0F);
		dvb_nit -> freq += 1E-2 * ((descr -> frequency3 & 0xF0) >> 4);
		dvb_nit -> freq += 1E-3 * (descr -> frequency3 & 0x0F);
		dvb_nit -> freq += 1E-4 * ((descr -> frequency4 & 0xF0) >> 4);
		dvb_nit -> freq += 1E-5 * (descr -> frequency4 & 0x0F);

		dvb_nit -> orbit = 1E2 * ((descr -> orbital_position1 & 0xF0) >> 4);
		dvb_nit -> orbit += 1E1 * (descr -> orbital_position1 & 0x0F);
		dvb_nit -> orbit += 1E0 * ((descr -> orbital_position2 & 0xF0) >> 4);
		dvb_nit -> orbit += 1E-1 * (descr -> orbital_position2 & 0x0F);

		dvb_nit -> west_east = descr -> west_east_flag;

		dvb_nit -> rate = 1E2 * (int) ((descr -> symbol_rate1 & 0xF0) >> 4);
		dvb_nit -> rate += 1E1 * (int) (descr -> symbol_rate1 & 0x0F);
		dvb_nit -> rate += 1E0 * (int) ((descr -> symbol_rate2 & 0xF0) >> 4);
		dvb_nit -> rate += 1E-1 * (int) (descr -> symbol_rate2 & 0x0F);
		dvb_nit -> rate += 1E-2 * (int) ((descr -> symbol_rate3 & 0xF0) >> 4);
		dvb_nit -> rate += 1E-3 * (int) (descr -> symbol_rate3 & 0x0F);
		dvb_nit -> rate += 1E-4 * (int) (descr -> symbol_rate4 & 0x0F);

		dvb_nit -> fec = descr -> fec_inner;
	
		dvb_nit -> polar[0] = descr -> polarization & 3;	
		}
		break;
	case DESCR_SERVICE_LIST:
        break;
   	case DESCR_CABLE_DEL_SYS:
		{
		struct descr_cable_delivery_system_struct *descr =\
		(struct descr_cable_delivery_system_struct *)\
		(ptr + DESCR_GEN_LEN);

		dvb_nit -> freq  = 1E3 * ((descr -> frequency1 & 0xF0) >> 4);
		dvb_nit -> freq += 1E2 * (descr -> frequency1 & 0x0F);
		dvb_nit -> freq += 1E1 * ((descr -> frequency2 & 0xF0) >> 4);
		dvb_nit -> freq += 1E0 * (descr -> frequency2 & 0x0F);
		dvb_nit -> freq += 1E-1 * ((descr -> frequency3 & 0xF0) >> 4);
		dvb_nit -> freq += 1E-2 * (descr -> frequency3 & 0x0F);
		dvb_nit -> freq += 1E-3 * ((descr -> frequency4 & 0xF0) >> 4);
		dvb_nit -> freq += 1E-4 * (descr -> frequency4 & 0x0F);

		dvb_nit->qam = descr->modulation;

		dvb_nit -> rate = 1E2 * (int) ((descr -> symbol_rate1 & 0xF0) >> 4);
		dvb_nit -> rate += 1E1 * (int) (descr -> symbol_rate1 & 0x0F);
		dvb_nit -> rate += 1E0 * (int) ((descr -> symbol_rate2 & 0xF0) >> 4);
		dvb_nit -> rate += 1E-1 * (int) (descr -> symbol_rate2 & 0x0F);
		dvb_nit -> rate += 1E-2 * (int) ((descr -> symbol_rate3 & 0xF0) >> 4);
		dvb_nit -> rate += 1E-3 * (int) (descr -> symbol_rate3 & 0x0F);
		dvb_nit -> rate += 1E-4 * (int) (descr -> symbol_rate4 & 0x0F);

		dvb_nit -> fec = descr -> fec_inner;
		dvb_nit -> qam = descr -> modulation;
		}
		break;
	case DESCR_LINKAGE:
	case DESCR_TERR_DEL_SYS:
	case DESCR_ML_NW_NAME:
	case DESCR_PRIV_DATA_SPEC:
//		printf(\
//		"NIT: UNCRITICAL unhandled descr (0x%x) %s\n,\
//		*ptr, decode_descr (*ptr));

		printf(\
		"NIT: UNCRITICAL unhandled descr 0x%x", *ptr);
		break;
	default:
//		printf(\
//		"NIT: CRITICAL unallowed descr (0x%x) %s\n,\
//		*ptr, decode_descr (*ptr));

		printf(\
		"NIT: CRITICAL unhandled descr 0x%x", *ptr);
		break;
	} /* end switch */

return 0;
} /* end function _parse_nit_descr */

