/*
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "xcha.h"

FD_xcha *fdui;


int log_signal_quality()
{
/* this is only called in recording mode */
FILE *fptr;
int hours, minutes, seconds;
long length;
char temp[TEMP_SIZE];

if(debug_flag)
	{
	printf("log_signal_quality(): arg none,\n\
	using recording_start_time=%ld deebee=%.2f bit_error_rate=%d n",\
	recording_start_time, deebee, bit_error_rate);
	}

/* only log if bit errors */
if(bit_error_rate == 0) return 1;

sprintf(temp, "%s.log", record_filename);
fptr = fopen(temp, "a");
if(! fptr)
	{
	printf("log_signal_quality(): could not open file %s for append\n",\
	temp);

	return 0;
	}

length = time(NULL) - recording_start_time;
hours = length / 3600;
minutes = (length - (hours * 3600) ) / 60;
seconds = length - (hours * 3600) - (minutes * 60);

fprintf(fptr, "%02d:%02d:%02d  S/N=%.2f dB  bit error rate=%d \n",\
hours, minutes, seconds, deebee, bit_error_rate);

fclose(fptr);

return 1;
} /* end function log_signal_quality */

