#ifndef _DVB2000_H_
#define _DVB2000_H_

struct dvb2000
{
char szFlag[4];                 // always DVSO              0-3
unsigned char ucChannelIDh;     // channel ID               4
unsigned char ucChannelIDl;     // channel ID               5
unsigned char ucPMTPIDh;        // PMT PID                  6
unsigned char ucPMTPIDl;        // PMT PID                  6
unsigned char ucFreqh;          // frequency                8
unsigned char ucFreql;          // frequency                8
unsigned char ucSRh;            // symbol rate              a
unsigned char ucSRl;            // symbol rate              b
unsigned char ucFEC;            // FEC flag                 c
unsigned char ucAcqBW;          // Aquisition bandwidth     d
unsigned char ucPolarity;       // polarity                 e
unsigned char ucDiseqc;         // diseqc mode              f
unsigned char ucVPIDh;          // video PID                10
unsigned char ucVPIDl;          // video PID                11
unsigned char ucAPIDh;          // audio PID                12
unsigned char ucAPIDl;          // audio PID                13
unsigned char ucPCRPIDh;        // PCR PID                  14
unsigned char ucPCRPIDl;        // PCR PID                  15
unsigned char ucFlagsh;         // scrambling flags         16
unsigned char ucFlagsl;         // scrambling flags         17
unsigned char ucPMCh;           // PMC for CA               18
unsigned char ucPMCl;           // PMC for CA               19
unsigned char ucVideo;          // video/audio mode         1a
unsigned char ucServiceType;    // service type             1b
unsigned char ucTPIDh;          // teletext PID             1c
unsigned char ucTPIDl;          // teletext PID             1d
unsigned char ucTSIDh;          // Transport stream ID      1e
unsigned char ucTSIDl;          // Transport stream ID      1f
unsigned char szName[20];       // channel name             20-33
unsigned char szReserved3a[4];  // reserved                 34-37
unsigned char autoPIDPMT;       // auto PID(0), auto PMT(1) 38
unsigned char szReserved3b[3];  // reserved                 39-3b
unsigned char link;             // channel link ?           3c
unsigned char unknown;          // unknown                  3d
unsigned char ucNetworkIDh;     // Network ID               3e
unsigned char ucNetworkIDl;     // Network ID               3e
};
struct dvb2000 *dvb2000tab[2];

#endif _DVB2000_H_

