/*
DVB2000 readin by Pj, experimental code, just a hack from mmtools.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "xcha.h"


int import_dvb2000_channel_list()
{
int a, b, c, i;
FILE *fptr;
char temp[4096];
char temp2[READSIZE];
int idummy;
byte buffer[1024];
char *ptr;
struct dvb2000 *pi;
struct program *pa;
char name[4096];
int frequency;
char polarization;
int disecq;
int symbolrate;
int vpid;
int apid;
int tpid;
int ca;
int pnr;
char station_name[80];

if(debug_flag)
	{	
	fprintf(stdout, "import_dvb2000(): arg none\n");
	}

/* allocate space for a dvb2000 data record */
pi = malloc(sizeof(struct dvb2000) );
if(! pa)
	{
	if(debug_flag)
		{
		printf(\
		"import_dvb2000_channel_list(): malloc struct dvb2000 failed\n");
		}

	return 0;
	}

/* start file browser */
sprintf(temp, "%s/.xcha/", home_dir);
sprintf(temp2, "*.dvb");
ptr = \
	(char *)fl_show_fselector("SELECT A FILE", temp, "*.dvb", temp2);
if(! ptr) return;

/* ptr will NOT stay allocated in xforms */
strcpy(temp, ptr);
fptr = fopen(temp, "r");
if(! fptr)
	{
	fl_show_alert("Could not open file", temp, "for read", 0);

	return 0;
	}

/* read the dvb2000 .dvb file binary format into the structure */
while(1)
	{
	a = fread(pi, 1, 0x40, fptr);
	if(a == 0) break;
	if(a != 0x40)
		{
		/* file format error or retry */
		fl_show_alert("File format error in", temp, "aborting", 0);
		if(debug_flag)
			{
			printf("import_dvb2000_channel_list(): file fomat error\n");
			}

		break;
		}

	/* read the info we need */
	frequency = pi -> ucFreql + 256 * pi -> ucFreqh;
	polarization = pi -> ucPolarity;
	disecq = pi -> ucDiseqc;
	symbolrate = pi -> ucSRl + 256 * pi -> ucSRh;
	vpid = pi -> ucVPIDl + 256 * pi -> ucVPIDh;
	apid = pi -> ucAPIDl + 256 * pi -> ucAPIDh;
	tpid = pi -> ucTPIDl + 256 * pi -> ucTPIDh;
	ca = pi -> ucFlagsl + 256 * pi -> ucFlagsh;
	pnr = pi -> ucChannelIDl + 256 * pi -> ucChannelIDh;

	/* convert to normal values */
	if(frequency == 0) continue;
//	if(disecq > 1) disecq = 1; /* ? */
	if(ca == 62466) ca = 0; /* ? */

	/* it looks like dvb2000 uses '-1' in 8191 = 8192 - 1 as error flag */
	if(vpid == 8191) vpid = 0;
	if(apid == 8191) apid = 0;
	if(tpid == 8191) tpid = 0;

	if(polarization == 0) polarization = 'h';
	else if(polarization == 1) polarization = 'v';
	else polarization = 'v';

	/* clear the program name of funny characters */
	a = 0;
	for(i = 0; i < 20; i++)
		{
		/* control characters to spaces */
		if(pi -> szName[i] == 0) break;
		if(pi -> szName[i] < 32) continue;
		if(pi -> szName[i] > 125) continue;

		station_name[a] = pi -> szName[i];

		/*
		we do not want ':', that casues a format error in
		programs.dat, so we change ':' to 'x'( it is used
		in for example 16:9, now 16x9)
		*/
		if(station_name[a] == ':') station_name[a] = 'x';

		a++;
		}
	station_name[a] = 0;

	/* add to our channel list */
	sprintf(temp,\
	"%s:%d:%c:%d:%d:%d:%d:%d:%d:%d\n",\
	station_name, frequency, polarization,\
	disecq, symbolrate, vpid, apid, tpid,\
	ca, pnr);

	/* sets status to new entry if found not to exist */
	pa = install_program_at_end_of_list(temp);
	if(! pa)
		{
		if(debug_flag)
			{
			fprintf(stdout,\
			"add_program_in_position(): cannot install entry %s\n", temp);

			return 0;
			}
		} /* end if install failed */

	pa -> frequency = frequency;

	pa -> service_name = strsave(station_name);
	if(! pa -> service_name) return 0;

	pa -> polarization = polarization;
	pa -> disecq = disecq;
	pa -> symbolrate = symbolrate;
	pa -> vpid = vpid;
	pa -> apid = apid;
	pa -> tpid = tpid;
	pa -> ca = ca;
	pa -> pnr = pnr;
	} /* end while all lines in input .dvb file */

fclose(fptr);


show_programs(SHOW_TOP);

/* 
sort the list, cause if item < first entry was entered it
would be at the end
*/

save_programs();

return 1;
} /* end function import_dvb2000_channel_list */

