/*
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
~*/


#include "xcha.h"

extern FD_xcha *fdui;
extern FD_xcha *fd_main_form;

FL_APPEVENT_CB optimize_idle_cb;


int idle_cb(XEvent *ev, void *data)
{
//waitpid (WAIT_ANY, &status, WNOHANG);
double da;
char temp[256];
int megabytes;
int percentage;
char weekday[20];
char month[20];
int monthday, hour, minute, second, year;
time_t now;
int colorfg, colorbg;
process_timers();

if(stop_button_flag)
	{
	fl_set_object_color(fdui -> main_form_seek_slider, FL_COL1, FL_COL1);

	fl_set_slider_value(fdui -> main_form_seek_slider, 0.0);

	enable_receiver_controls(1);
	stop_button_flag = 0;
	}

/* speed up things if beep_mode */
if(! beep_mode)
	{
	if(recorder_mode == PLAYBACK_MODE)
		{
		/* calculate position */
		da = (double) play_position / play_length;

		if(!seek_flag)
			{
			/* set slider indicating position in file */
			fl_set_slider_value(fdui -> main_form_seek_slider, da);
			}

		/* calculate play position in percent */
		da *= 100.0;

		sprintf(temp, "PLAY POSITION %.2f%%", da);
		fl_set_object_label(fdui -> main_form_seek_slider, temp);

		sprintf(temp, "Playing file %s %.2f%%", play_filename, da);
	
		colorbg = FL_GREEN;
		colorfg = FL_BLACK;		
		fl_set_object_label(fdui -> main_form_outfield, temp);
		fl_set_object_color(fdui -> main_form_outfield, colorbg, FL_COL1);
		fl_set_object_lcol(fdui -> main_form_outfield, colorfg);
		} /* end if playback mode */
	else if(recorder_mode == RECORD_MODE)
		{
		if( get_free_disk_space(record_filename, &megabytes, &percentage) )
			{
			/* set slider indicating position in file */
			da = percentage / 100.0;
			fl_set_slider_value(fdui -> main_form_seek_slider, da);

			if(running_timer)
				{
				now = time(NULL);

				sprintf(temp,\
				"%d of %d minutes  disk usage %d%%  %dMB free",\
				(now - running_timer -> start_time) / 60,\
				(running_timer -> stop_time - running_timer -> start_time) / 60,\
				percentage, megabytes);
				}
			else
				{
				sprintf(temp, "disk usage %d%%  %dMB free",\
				percentage, megabytes);
				}

			fl_set_object_label(fdui -> main_form_seek_slider, temp);
			} /* end if recording mode */
		else
			{
//			printf("get_free_disk_space(): failed\n");
			}
		}
	else /* not in record or play */
		{			
		fl_set_object_label(fdui -> main_form_seek_slider, "player status");
		}

	} /* end if not beep mode */

if(! receiver_active_flag) return;

print_status();

return 1;
}/* end function idle_cb */


int print_status()
{
int a, c, i;
double da, db;
char temp[TEMP_SIZE];
double dpart;
int signal_strength;
int top;
int beep_range;
int beep_frequency;
struct qpskFrontendInfo *info;
FILE *fptr;
off_t position;
static int count;
double fbe;
double bit_errors;
int colorbg, colorfg;

/* save processor cycles, ioctl is expensive */
if(! beep_mode)
	{ 	
	count++;
	if(count % 10) return 1;
	}

/* get front end info */
/*
bit error rate, multiple of 10-9,
2500 = 2.5 10-6 is 1 error in 400000
*/
a = ioctl(fd_frontend, FE_READ_BER, &bit_error_rate);
if(a < 0)
	{
	printf("Error=%d reading fd_frontend\n", a);
	}
fbe = (double) bit_error_rate * 10e-9;
bit_errors = 1.0 / fbe;

//printf("BIT ERRORS=1 in %.0f bit_error_rate=%d fbe=%.3f\n",\
//bit_errors, bit_error_rate, fbe);

sprintf(temp, "%d", bit_error_rate);
fl_set_object_label(fdui -> main_form_bit_error_rate_text_field, temp);

if(bit_error_rate > 20000)
	{
	fl_set_object_color(fdui -> main_form_bit_error_rate_text_field,\
	FL_RED, FL_RED);
	}
else if(bit_error_rate > 5000)
	{
	fl_set_object_color(fdui -> main_form_bit_error_rate_text_field,\
	FL_DARKORANGE, FL_DARKORANGE);
	}
else if(bit_error_rate != 0)
	{
	fl_set_object_color(fdui -> main_form_bit_error_rate_text_field,\
	FL_YELLOW, FL_YELLOW);
	}
else
	{
	fl_set_object_color(fdui -> main_form_bit_error_rate_text_field,\
	FL_GREEN, FL_GREEN);
	}

/* signal to noise */
a = ioctl(fd_frontend, FE_READ_SNR, &signal_strength);
if(a < 0)
	{
	printf("Error=%d reading fd_frontend\n", a);
	}

deebee = (double)signal_strength / 1000000.0;

sprintf(temp, "%.0f", deebee);
fl_set_object_label(fdui -> main_form_signal_strength_text_field, temp);

if(log_signal_quality_flag)
	{
	if(recorder_mode == RECORD_MODE) log_signal_quality();
	}

/* limit range of indicator and beep */
if(deebee < 0.0) deebee = 0.0;
if(deebee > MAX_SNR_SCALE) deebee = MAX_SNR_SCALE;

beep_range = BEEP_MAXIMUM_FREQ - BEEP_MINIMUM_FREQ;

/* create a beep sound, higher frequecy is more signal */
if(beep_mode)
	{
	da = deebee / MAX_SNR_SCALE;
	db = da * beep_range;
	beep_frequency = BEEP_MINIMUM_FREQ + db;

	if(debug_flag)
		{
		fprintf(stdout, "BEEP FREQ=%d\n", beep_frequency);
		}

	beep_freq(beep_frequency);
	}

fl_set_dial_value(fdui -> main_form_signal_strength_indicator, deebee);

if(error_message_flag)
	{
	sprintf(temp, "%s", error_message);

	colorbg = FL_WHITE;
	colorfg = FL_RED;
	} /* end if error message flag */
else
	{
	if(recorder_mode == RECORD_MODE)
		{
		if(running_timer)
			{
			sprintf(temp,\
			"Recording to %s/%s until %02d:%02d",\
			running_timer -> directory, running_timer -> filename,\
			running_timer -> stop_hour, running_timer -> stop_minute);
			} /* end if record using timer */
		else
			{
			sprintf(temp, "Recording to %s", record_filename);
			} /* end if manual recording */

		colorbg = FL_RED;
		colorfg = FL_WHITE;
		} /* end if record */
	else if(recorder_mode == PLAYBACK_MODE)
		{
		/* never here (receiver_active_flag) */
		} /* end if playback */
	else /* no recorder active */
		{
		sprintf(temp,\
"prog=%d vpid=%d apid=%d tpid=%d %s %s",\
		program_number, used_vpid, used_apid, used_tpid,\
		report_string, date_string);

		colorbg = FL_YELLOW;
		colorfg = FL_BLUE;
		}	
	} /* end if not error message flag */

fl_set_object_label(fdui -> main_form_outfield, temp);
fl_set_object_color(fdui -> main_form_outfield, colorbg, FL_COL1);
fl_set_object_lcol(fdui -> main_form_outfield, colorfg);

fl_set_object_label(fdui -> main_form_wait_light, language);

/* see above */
if(beep_mode)
	{
	count++;
	if(count % 10) return 1;
	}

return 1;
} /* end function print_status */


int clear_status_line()
{
if(debug_flag)
	{
	printf("clear_status_line(): arg none\n");
	}

//used_apid = 0;
//used_vpid = 0;
//used_tpid = 0;
strcpy(date_string, "");

return 1;
} /* end function clear_status_line */

