#include "xcha.h"
#include "sdt.h"

pthread_t *getpids_thread;

static int demux_fd;


/* 
  THIS NO LONGER HAS ANYTHING TO DO WITH CRYPT,
  THIS IS JUST TO GET THE AUDIO VIDEO AND TELETEXT PIDSs
  FROM THE PROGRAM NUMBER.
*/


/**
* Set a filter for a DVB stream
**/
void SetFilt(int fd, int pid)
{
struct dmxPesFilterParams pesFilterParams;

if(debug_flag)
	{
	printf("SetFilt(): arg fd=%d pid=%d\n", fd, pid);
	}

pesFilterParams.pid = pid;
pesFilterParams.input = DMX_IN_FRONTEND;
pesFilterParams.output = DMX_OUT_TAP;
pesFilterParams.pesType = DMX_PES_OTHER;
pesFilterParams.flags = DMX_IMMEDIATE_START;

if(ioctl(fd, DMX_SET_PES_FILTER, &pesFilterParams) < 0)
	perror("DMX SET PES FILTER");
} /* end function SetFilt */


/**
* Stop a PID filter.
**/
void StopFilt(int fd)
{
if(debug_flag)
	{
	printf("stopfilt(): arg fd=%d\n", fd);
	}

ioctl(fd, DMX_STOP);
} /* end function StopFilt */ 


/**
* Read with timeout.
**/
int read_t(int fd, byte *buffer, int length)
{
struct pollfd u[1];
char temp[1024];
int a;

if(debug_flag)
	{
	printf("read_t(): arg fd=%d buffer=%lu length=%d\n",\
	fd, buffer, length);
	}

u[0].fd = fd;
u[0].events = POLLIN;

a = poll(u, 1, 20000);

/* test for timeout */
if(a == 0)
	{
	sprintf(temp, "Timeout\n");
	to_log(temp);

	if(debug_flag)
    	printf("%s", temp);

	return -1;
	}

if(a < 0)
	{
	perror("read_t(): ");
	return 0;
	}

while(1)
	{
	a = read(fd, buffer, length);
	if(a < 0)
		{
		perror("read(): in read_t(): ");
		continue;
		}
	else break;
	}

return a;
} /* end function read_t */


/**
 * Parse the PAT to get the PMT.
**/
int ParsePAT(int fd, int program_number, int *pid)
{
byte buffer[184];
int length, index;
int n;
char temp[1024];

if(debug_flag)
	{
	printf("ParsePAT(): arg fd=%d program_number=%d, *pid=%d\n",\
	fd, program_number, *pid);
	}

*pid = 0;

/* The PAT is supposed to fit in a 184 bytes packet */
sprintf(temp, "Reading PAT ...\n");
to_log(temp);
if(debug_flag)
    printf("%s", temp);

SetFilt(fd, 0);
do
	{
    n = read_t(fd, buffer, 184);
	}
while( n >= 2 && (buffer[0] != 0 || buffer[1] != 0) );
StopFilt(fd);

if(n < 2)
	return -1;

sprintf(temp, "Analyzing PAT ...\n");
to_log(temp);
if(debug_flag)
    printf("%s", temp);

length = ((buffer[2] & 0x0F) << 8) | buffer[3];
for (index = 9; index < length - 4 && index < 184; index += 4)
	{
    int p = (buffer[index] << 8) | buffer[index + 1];

	sprintf(temp, "Found program number %d\n", p);
	to_log(temp);
	if(debug_flag)
    	printf("%s", temp);

	if(scan_flag)
		printf("%s", temp);

	if(! scan_flag)
		{
		if(program_number == p)
			{
			/* get PMT pid */
			*pid = ( (buffer[index + 2] << 8) | buffer[index + 3]) & 0x1FFF;
			break;
			}
		} /* end if ! scan_flag */
	} /* end for */

if(*pid == 0)
	{
	sprintf(temp, "Program number %d not in PAT\n", program_number);
	to_log(temp);
	if(debug_flag)
    	printf("%s", temp);

	return -1;
	}

sprintf(temp, "Program number: %d PMT pid: %x\n", program_number, *pid);
to_log(temp);
if(debug_flag)
    printf("%s", temp);

return 0;
} /* end function ParsePAT */


/**
 * Parse PMT to get audio video and telext PIDs.
**/
int ParsePMT(int fd, int pmt_pid)
{
byte buffer[4096];
int length, info_len, data_len, index;
int n, i;
char temp[1024];

if(debug_flag)
	{
	printf("ParsePMT(): arg fd=%d pmt_pid=%d\n", fd, pmt_pid);
	}

sprintf(temp, "Analyzing PMT (PID = %x)...\n", pmt_pid);
to_log(temp);
if(debug_flag)
    printf("%s", temp);

SetFilt(fd, pmt_pid);
do
	{
	n = read_t(fd, buffer, 184);
	}
while(n >= 2 && (buffer[0] != 0 || buffer[1] != 0x02) );

length = ( (buffer[2] & 0x0F) << 8) | buffer[3];
if(length + 4 > sizeof(buffer) )
	n = -1;

if(n >= 2 && length > (n - 4) )
	n = read_t(fd, &buffer[n], length - (n - 4));

StopFilt(fd);

if(debug_flag)
	{
	printf("ParsePMT(): read returned n=%d\n", n);
	}

if(n < 2)
	{
	have_pmt = 1;
	return -1;
	}

index = 11;
info_len = ((buffer[index] & 0x0F) << 8) + buffer[index + 1];
index += 2;

while(info_len > 0)
	{
	switch(buffer[index])
		{
		case 0x1: /* mpeg1 video */
		case 0x2: /* mpeg2 video */
			/* 13 bits, high byte first */
			pmt_vpid =\
			buffer[index + 2] + (256 * (buffer[index + 1] & 0x1f) );

			set_vpid(pmt_vpid);
			break;
		case 0x3: /* mpeg1 audio */
		case 0x4: /* mpeg2 audio */
			/* 13 bits, high byte first */
			pmt_apid =\
			buffer[index + 2] + (256 * (buffer[index + 1] & 0x1f) );

			set_apid(pmt_apid);
			break;
		case 0x6: /* teletext */
			/* 13 bits, high byte first */
			pmt_tpid =\
			buffer[index + 2] + (256 * (buffer[index + 1] & 0x1f) );
			used_tpid = pmt_tpid;
			break;
		default:
			printf("ParsePMT(): info buffer[index]=%d unknown\n",\
			buffer[index]);
			break;
		} /* end switch */

	info_len -= 2 + buffer[index + 1];
	index += 2 + buffer[index + 1];
	} /* end while info_len */

while(index < length - 4)
	{
	data_len = ((buffer[index + 3] & 0x0F) << 8) + buffer[index + 4];

	/* check streamtype for PIDS video, audio, teletext */
	switch(buffer[index])
		{
		case 0x1: /* mpeg1 video */
		case 0x2: /* mpeg2 video */
			/* 13 bits, high byte first */
			pmt_vpid =\
			buffer[index + 2] + (256 * (buffer[index + 1] & 0x1f) );

			set_vpid(pmt_vpid);
			break;
		case 0x3: /* mpeg1 audio */
		case 0x4: /* mpeg2 audio */
			/* 13 bits, high byte first */
			pmt_apid =\
			buffer[index + 2] + (256 * (buffer[index + 1] & 0x1f) );

			set_apid(pmt_apid);
			break;
		case 0x6: /* teletext */
			/* 13 bits, high byte first */
			pmt_tpid =\
			buffer[index + 2] + (256 * (buffer[index + 1] & 0x1f) );
			used_tpid = pmt_tpid;
			break;
		} /* end switch streamtype */

	/* mpeg2 video or mpeg2 audio */
	if(buffer[index] == 0x02 || buffer[index] == 0x04)
		{
		i = index + 5;
		while (i < index + 5 + data_len)
			{
			switch(buffer[i])
				{
				case 0x0a:

					sprintf(language, "%.3s\n", &buffer[i + 2]);

					sprintf(temp, "Language = %.3s\n", &buffer[i + 2]);
					to_log(temp);

					if(debug_flag)
					    printf("%s", temp);
						
					break;
				default:
					if(debug_flag)
						{
						printf(\
						"ParsePMT(): switch(buffer[i] no match for %x\n",\
						buffer[i]);
						}
					break;
				}
			i += 2 + buffer[i+1];
			}
		}
	index += 5 + data_len;
	} /* end while index */

have_pmt = 1;
return 0;
} /* end function ParsePMT */


void get_pids(int fd, int program_number)
{
byte buffer[184];
int pmt_pid;
int parity;
int n, i;
char temp[1024];
char tmp[8];
dvb_sdt_t *sdt;

/* DECRYPTION CODE HAS BEEN REMOVED */

if(debug_flag)
	{
	printf("get_pids(): arg fd=%d program_number=%d\n",\
	fd, program_number);
	}


conditional_access_running = 1;

/* timeout PAT if this delay is not there ! (why?) */ 
sleep(1);

if( ParsePAT(fd, program_number, &pmt_pid) )
	{
	StopFilt(fd);

	conditional_access_running = 0;
	return;
	}

if( ParsePMT(fd, pmt_pid) )
	{
	StopFilt(fd);

	conditional_access_running = 0;
	return;
	}

sprintf(temp, "No supported encryption system found\n");
to_log(temp);
if(debug_flag)
	printf("%s", temp);

sprintf(report_string, "");

StopFilt(fd);

conditional_access_running = 0;

return;
} /* end function get_pids */


int show_date(int date[])
{
int year, month, day;

if(debug_flag)
	{
	fprintf(stdout, "show_date(): arg date=%02x %02x\n",\
	date[0], date[1]); 
	}

/* report date */

/*
report date
Bytes 0 and 1 represent a date with the first 7 bits being the year from
1980, the next 4 bits the month and the last 5 the day of the month.
So the date shown (20 21) is year 0010000 or decimal 16, month 0001 or 1,
and day 00001 or 1 ie January 1 1996.
yyyyyyym mmmddddd
*/

/* first seven bits byte 0 is year since 1980 */
year = 1980 + ( (date[0] & 0xfe) >> 1);

/* next 4 bits is month */
month = ( (date[0] & 1) << 3) | ( (date[1] & 0xe0) >> 5);

/* last 5 bits is day */
day = date[1] & 0x1f;

if(debug_flag)
	{
	fprintf(stdout, "date: %d-%d-%d\n", day, month, year);
	}

sprintf(date_string, "%d-%d-%d", day, month, year);

return 1;
} /* end function show_date */


void *main_loop_routine()
{
char temp[1024];
byte buffer[16];
FILE *pptr;

if(debug_flag)
	{
	fprintf(stdout, "main_loop_routine(): arg none\n");
	}

/*
DECRYPTION HAS BEEN REMOVED FROM THIS ROUTINE,
/dev/ost/ca is not even opened!
*/

while(1)
	{
	if(new_program_flag)
		{
		new_program_flag = 0;

		sprintf(temp, "start get_pids\n");
		to_log(temp);

		demux_fd = open("/dev/ost/demux", O_RDWR | O_NONBLOCK);
		if(demux_fd < 0)
			{
			perror("DEMUX DEVICE");

			sprintf(error_message,\
			"mail_loop_routine(): could not open /dev/ost/demux");

			error_message_flag = 1;
	
			to_log(error_message);
			if(debug_flag)
				{
				printf("%s", error_message);
				}	

			return 0;
			}

		get_pids(demux_fd, program_number);
		close(demux_fd);
			
		sprintf(temp, "exit get_pids()\n");
		to_log(temp);
		if(debug_flag)
			{
			printf("%s", temp);
			}	

		} /* end if program has changed (new_program_flag) */

	/* take it easy on processor cycles */
	usleep(10000);
	} /* end while */

return;
} /* end function main_loop_routine */


int getpids_init()
{
if(debug_flag)
	{
	printf("getpids_init(): arg none\n");
	}

pthread_create(\
(pthread_t *)&getpids_thread, NULL , &main_loop_routine, NULL);

return 1;
} /* end function getpids_init */


void to_log(char *message)
{
int c, i;
char temp[1024];
static FILE *fptr;

if(debug_flag)
	{
	printf("to_log(): message=%s\n", message);
	}

if(! log_messages_flag) return;

sprintf(temp, "%s/.xcha/message_log.txt", home_dir);
fptr = fopen(temp, "a");
if(! fptr)
	{
	if(debug_flag)
		{
		printf("to_log(): could not open file %s for append\n", temp);
		}

	return;
	}
else
	{
	fprintf(fptr, "%s", message);
	fclose(fptr);
	}

return;
} /* end function log */


void getpids_start()
{
char temp[1024];

if(debug_flag)
	{
	printf("getpids_start() arg none\n");
	}

sprintf(temp, "getpids_start\n");
to_log(temp);
if(debug_flag)
    printf("%s", temp);

new_program_flag = 1;

} /* end function getpids_start */


void getpids_stop()
{
struct ECMINFO *e, *n;
char temp[1024];
FILE *pptr;

if(debug_flag)
	{
	printf("getpids_stop(): arg none\n");
	}

sprintf(temp, "getpids_stop\n");
to_log(temp);
if(debug_flag)
    printf("%s", temp);

if(conditional_access_running)
	{
	conditional_access_stop = 1;

	while (conditional_access_running)
		{
		sleep(1);
		}
	}

conditional_access_stop = 0;
} /* end function getpids_stop */

