#include "xcha.h"

pthread_t *eit_thread;
static volatile int running = 0; 
static volatile int stop = 0;    
static int eit_demux_fd;


/**
 * Parse the EIT to get the PMT.
**/
int ParseEIT(int fd, int program_number, int *pid)
{
byte buffer[184];
int length, index;
int n;
char temp[1024];

if(debug_flag)
	{
	printf("ParseEIT(): arg fd=%d program_number=%d, *pid=%d\n",\
	fd, program_number, *pid);
	}

*pid = 0;

/* The EIT is supposed to fit in a 184 bytes packet */
sprintf(temp, "Reading EIT ...\n");
to_log(temp);
if(debug_flag)
    printf("%s", temp);

SetFilt(fd, 0);
do
	{
    n = read_t(fd, buffer, 184);
	}
while( n >= 2 && (buffer[0] != 0 || buffer[1] != 0) );
StopFilt(fd);

if(n < 2)
	return -1;

sprintf(temp, "Analyzing EIT ...\n");
to_log(temp);
if(debug_flag)
    printf("%s", temp);

length = ((buffer[2] & 0x0F) << 8) | buffer[3];
for (index = 9; index < length - 4 && index < 184; index += 4)
	{
    int p = (buffer[index] << 8) | buffer[index + 1];

	sprintf(temp, "Found program number %d\n", p);
	to_log(temp);
	if(debug_flag)
    	printf("%s", temp);

	if(program_number == p)
		{
		/* get PMT pid */
		*pid = ( (buffer[index + 2] << 8) | buffer[index + 3]) & 0x1FFF;
		break;
		}
	} /* end for */

if(*pid == 0)
	{
	sprintf(temp, "Program number %d not in EIT\n", program_number);
	to_log(temp);
	if(debug_flag)
    	printf("%s", temp);

	return -1;
	}

sprintf(temp, "Program number: %d PMT pid: %x\n", program_number, *pid);
to_log(temp);
if(debug_flag)
    printf("%s", temp);

return 0;
} /* end function ParseEIT */


void *eit_routine()
{
char temp[1024];

if(debug_flag)
	{
	fprintf(stdout, "eit_routine(): arg none\n");
	}

while(1)
	{
	if(new_program_flag)
		{
		new_program_flag = 0;

		sprintf(temp, "start eit_process\n");
		to_log(temp);

		eit_demux_fd = open("/dev/ost/demux", O_RDWR | O_NONBLOCK);
		if(eit_demux_fd < 0)
			{
			perror("DEMUX DEVICE");
			fl_show_alert(\
			"eit_program_init()", "could not open /dev/ost/demux",\
			"", 0);
			return 0;
			}

//		eit_eit_fd = open("/dev/ost/ca", O_RDWR | O_NONBLOCK);
//		if(eit_eit_fd < 0)
//			{
//			perror("CA DEVICE");
//			fl_show_alert(\
//			"eit_program_init()", "could not open /dev/ost/ca", "", 0);
//			return 0;
//			}

//		eit_process(eit_eit_fd, eit_demux_fd, eit_program_number);

		close(eit_demux_fd);
//		close(eit_eit_fd);

		sprintf(temp, "exit eit_process()\n");
		to_log(temp);
		if(debug_flag)
			{
			printf("%s", temp);
			}

		} /* end if program has changed */

	/* take it easy on processor cycles */
	usleep(10000);
	} /* end while eit */

return;
} /* end function eit_routine */


int eit_init()
{
if(debug_flag)
	{
	printf("eit_init(): arg none\n");
	}

pthread_create(\
(pthread_t *)&eit_thread, NULL , &eit_routine, NULL);

return 1;
} /* end function eit_init */


void eit_start()
{
char temp[1024];

if(debug_flag)
	{
	printf("eit_start() arg none\n");
	}

sprintf(temp, "eit_start\n");
to_log(temp);
if(debug_flag)
    printf("%s", temp);

new_program_flag = 1;

} /* end function eit_start */


void eit_stop()
{
//struct ECMINFO *e, *n;
char temp[1024];

if(debug_flag)
	{
	printf("eit_stop(): arg none\n");
	}

sprintf(temp, "eit_stop\n");
to_log(temp);
if(debug_flag)
    printf("%s", temp);

if(running)
	{
	stop = 1;
	while(running)
		{
		sleep(1);
		}
	}

stop = 0;
} /* end function eit_stop */

