/*
Copyright (C) 2000, 2001 Marcus Metzler 
            for convergence integrated media GmbH
 
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.


This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
Or, point your browser to http://www.gnu.org/copyleft/gpl.html
 
The author can be reached at marcus@convergence.de, 

the project's page is at http://linuxtv.org/dvb/
*/

#ifndef _DVB_FORMATS_H_
#define _DVB_FORMATS_H_

#include "xcha.h"

#define BUFFY 32768
#define NFD  2
#define PID_MASK_HI    0x1F
#define MAX_SECTION_SIZE 4096
#define NFD2   1
#define BUFFY2 1024*1024
#define IN_SIZE TS_SIZE*10



#define PROG_STREAM_MAP  0xBC
#ifndef PRIVATE_STREAM1
#define PRIVATE_STREAM1  0xBD
#endif
#define PADDING_STREAM   0xBE
#ifndef PRIVATE_STREAM2
#define PRIVATE_STREAM2  0xBF
#endif
#define AUDIO_STREAM_S   0xC0
#define AUDIO_STREAM_E   0xDF
#define VIDEO_STREAM_S   0xE0
#define VIDEO_STREAM_E   0xEF
#define ECM_STREAM       0xF0
#define EMM_STREAM       0xF1
#define DSM_CC_STREAM    0xF2
#define ISO13522_STREAM  0xF3
#define PROG_STREAM_DIR  0xFF

#define BUFFYSIZE    10*MAX_PLENGTH
//#define MAX_PTS      8192
#define MAX_FRAME    8192
#define MAX_PACK_L   4096
#define PS_HEADER_L1    14
#define PS_HEADER_L2    (PS_HEADER_L1+18)
#define MAX_H_SIZE   (PES_H_MIN + PS_HEADER_L1 + 5)
#define PES_MIN         7
#define PES_H_MIN       9

//flags2
#define PTS_DTS_FLAGS    0xC0
#define ESCR_FLAG        0x20
#define ES_RATE_FLAG     0x10
#define DSM_TRICK_FLAG   0x08
#define ADD_CPY_FLAG     0x04
#define PES_CRC_FLAG     0x02
#define PES_EXT_FLAG     0x01

//pts_dts flags 
#define PTS_ONLY         0x80
#define PTS_DTS          0xC0

#define TS_SIZE        188
#define TRANS_ERROR    0x80
#define PAY_START      0x40
#define TRANS_PRIO     0x20
#define PID_MASK_HI    0x1F
//flags
#define TRANS_SCRMBL1  0x80
#define TRANS_SCRMBL2  0x40
#define ADAPT_FIELD    0x20
#define PAYLOAD        0x10
#define COUNT_MASK     0x0F

// adaptation flags
#define DISCON_IND     0x80
#define RAND_ACC_IND   0x40
#define ES_PRI_IND     0x20
#define PCR_FLAG       0x10
#define OPCR_FLAG      0x08
#define SPLICE_FLAG    0x04
#define TRANS_PRIV     0x02
#define ADAP_EXT_FLAG  0x01

// adaptation extension flags
#define LTW_FLAG       0x80
#define PIECE_RATE     0x40
#define SEAM_SPLICE    0x20


#define MAX_PLENGTH 0xFFFF
#define MMAX_PLENGTH (4*MAX_PLENGTH)

#ifdef __cplusplus
extern "C" {
#endif                          /* __cplusplus */
        

	typedef struct p2pstruct {
		int found;
		uint8_t *buf;
		uint8_t *buf2;
		uint8_t cid;
		uint32_t plength;
		uint8_t plen[2];
		uint8_t flag1;
		uint8_t flag2;
		uint8_t hlength;
		uint8_t pts[5];
		int mpeg;
		uint8_t check;
		int which;
		int done;
		int repack;
		uint16_t bigend_repack;
		void (*func)(uint8_t *buf, int count, void *data);
		uint16_t pid;
		uint16_t pida;
		uint16_t pidv;
		uint8_t acounter;
		uint8_t vcounter;
		uint8_t count0;
		uint8_t count1;
		void * data;
		int fd;
		int fd1;
	} p2p;
	
	typedef struct ipack_s {
		int size;
		int found;
		uint8_t *buf;
		uint8_t cid;
		uint32_t plength;
		uint8_t plen[2];
		uint8_t flag1;
		uint8_t flag2;
		uint8_t hlength;
		uint8_t pts[5];
		uint16_t pid;
		int fd;
		int fd1;
		int fd2;
		int mpeg;
		uint8_t check;
		int which;
		int done;
		void *data;
		void (*func)(uint8_t *buf,  int size, void *priv);
		int count;
		int playing;
	} ipack;


	void init_p2p(p2p *p, void (*func)(uint8_t *buf, int count, 
					   void *data),int repack);
	void get_pes (uint8_t *buf, int count, p2p *p, void (*func)(p2p *p));
	void pes_repack(p2p *p);
	void setup_pes2ts( p2p *p, uint16_t pida, uint16_t pidv, 
			   void (*ts_write)(uint8_t *buf, int count, 
					    void *data),void *data);
	void pes_to_ts( p2p *p,uint8_t *buf ,int count );
	void setup_ts2pes( ipack *pa, ipack *pv, uint16_t pida, uint16_t pidv, 
			   void (*pes_write)(uint8_t *buf, int count, 
					     void *data), void *data);

	void ts_to_pes( ipack *p, uint8_t *buf);
	uint16_t get_pid(uint8_t *pid);
	void free_p2p(p2p *p);
	uint16_t get_pid(uint8_t *pid);	


	int videoStop(int fd);
	int videoPlay(int fd);
	int videoFreeze(int fd);
	int videoContinue(int fd);
	int videoSelectSource(int fd, videoStreamSource_t source);
	int videoSetBlank(int fd, boolean state);
	int videoFastForward(int fd,int nframes);
	int videoSlowMotion(int fd,int nframes);
	int videoGetStatus(int fd);
	int videoStillPicture(int fd, struct videoDisplayStillPicture *sp);
	int videoSetStreamtype(int fd, char *format);
	unsigned int videoCapabilities(int fd);
	int audioSetStreamtype(int fd, char *format);
	unsigned int audioCapabilities(int fd);
	int audioStop(int fd);
	int audioPlay(int fd);
	int audioPause(int fd);
	int audioContinue(int fd);
	int audioSelectSource(int fd, audioStreamSource_t source);
	int audioSetMute(int fd, boolean state);
	int audioSetAVSync(int fd,boolean state);
	int audioSetBypassMode(int fd,boolean mode);
	int audioChannelSelect(int fd, audioChannelSelect_t select);
	int audioGetStatus(int fd);
	void play_file_audio(int filefd, int fd);
	void play_file_video(int filefd, int fd, int fda, int next);
	void load_iframe(int filefd, int fd);
	int open_av(int *fdv,int *fda, int dev);
	void set_pat_filt(int fd);
	void set_pmt_filt(int fd,uint16_t ppid);
	void set_av_filts(int vfd,int afd,uint16_t vpid,uint16_t apid);
	uint16_t get_pmt_pid(int fd);
	void get_av_pids(int fd, uint16_t *vpid, uint16_t *apid);
	void play_file_video_stdin(int fd, int fda);
	void init_ipack(ipack *p, int size,
			void (*func)(uint8_t *buf,  int size, void *priv));
	void send_ipack(ipack *p);
	void instant_repack (uint8_t *buf, int count, ipack *p);
	void reset_ipack(ipack *p);

#ifdef __cplusplus
}
#endif                          /* __cplusplus */


#endif /* _DVB_FORMATS_H_*/
