/* 
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "xcha.h"

extern FD_xcha *fdui;

int erase_ca_log_flag;
int fontsizes_modified_flag;


void ca_log_form_input_cb(FL_OBJECT *ob, long data)
{
}/* end function ca_log_form_field_cb */


void ca_log_form_fontsize_up_button_cb(FL_OBJECT *ob, long data)
{
int size;

fontsizes_modified_flag = 1;

if(ca_log_form_fontsize < 5) ca_log_form_fontsize++;
size = integer_to_fontsize(ca_log_form_fontsize);

fl_set_object_lsize(fdui -> ca_log_form_input, size);

update_ca_log();
}/* end function ca_log_form_fontsize_up_button_cb */


void ca_log_form_fontsize_down_button_cb(FL_OBJECT *ob, long data)
{
int size;

fontsizes_modified_flag = 1;

if(ca_log_form_fontsize > 0) ca_log_form_fontsize--;
size = integer_to_fontsize(ca_log_form_fontsize);

fl_set_object_lsize(fdui -> ca_log_form_input, size);

update_ca_log();
}/* end function ca_log_form_fontsize_down_button_cb */


void ca_log_form_update_button_cb(FL_OBJECT *ob, long data)
{
update_ca_log();

}/* end function ca_log_form_update_button_cb */


void ca_log_form_clear_button_cb(FL_OBJECT *ob, long data)
{
fl_show_alert(\
"pressing ACCEPT will now delete the logfile",\
"CANCEL will leave it", "" , 0);

erase_ca_log_flag = 1;
fl_set_input(fdui -> ca_log_form_input, "");

}/* end function ca_log_form_clear_button_cb */


void ca_log_form_accept_button_cb(FL_OBJECT *ob, long data)
{
if(erase_ca_log_flag) erase_ca_log();
erase_ca_log_flag = 0;

fl_hide_form(fdui -> ca_log_form);

if(fontsizes_modified_flag)
	{
	save_fontsizes();
	fontsizes_modified_flag = 0;
	}

}/* end function ca_log_form_accept_button_cb */


void ca_log_form_cancel_button_cb(FL_OBJECT *ob, long data)
{
fl_hide_form(fdui -> ca_log_form);

/* restore from disc */
if(fontsizes_modified_flag)
	{
	load_fontsizes();
	fontsizes_modified_flag = 0;
	}

}/* end function ca_log_form_cancel_button_cb */


