/* BEEP.C */

#include "xcha.h"
#include <asm/io.h>


int beep(int duration, int freq)
{
long i;
long lt;
int scale;
if(freq == 0)return 1;
if(duration == 0)return 1;
scale = 1193046 / freq;
outb(0xb6, 0x43);
outb(scale & 0xff, 0x42);
outb(scale >> 8, 0x42);
outb(inb(0x61) | 3, 0x61);/*set bit 0 and 1,
									/*timer 2 gate and lsp gate*/
	lt = duration * 6666666;/*depends on system speed*/
	for(i = 0; i < lt; i++)/*delay*/
		{
		;
		}
outb(inb(0x61) & ~3, 0x61);/*reset bit 0 and 1,
									/*timer 2 gate and lsp gate*/
return 1;
}


int sbeep(int milliseconds, int freq)/*short beep*/
{
long i;
long lt;
int scale;
if(freq == 0)return 1;
if(milliseconds == 0) return 1;
scale = 1193046 / freq;
outb(0xb6, 0x43);
outb(scale & 0xff, 0x42);
outb(scale >> 8, 0x42);
outb(inb(0x61) | 3, 0x61);/*set bit 0 and 1,
									/*timer 2 gate and lsp gate*/
	lt = milliseconds * 6666;/*depends on system speed*/
	for(i = 0; i < lt; i++)/*delay*/
		{
		;
		}
outb(inb(0x61) & ~3, 0x61);/*reset bit 0 and 1,
									/*timer 2 gate and lsp gate*/
return 1;
} /* end function sbeep */


int beep_freq(int freq)/* set frequency of beep */
{
int scale;
if(freq == 0) return 1;

scale = 1193046 / freq;

outb(0xb6, 0x43);
outb(scale & 0xff, 0x42);
outb(scale >> 8, 0x42);

return 1;
}


int beep_on()
{
outb(inb(0x61) | 3, 0x61);/*set bit 0 and 1, timer 2 gate and lsp gate */

return 1;
}


beep_off()
{
outb(inb(0x61) & ~3, 0x61);/*reset bit 0 and 1, timer 2 gate and lsp gate */

return 1;
}

