#ifndef lint
static char RCSid[] = 
"$Id: aux.c,v 6.4 1993/07/12 20:15:23 mcooper Exp mcooper $";

static char copyright[] =
"@(#) Copyright (c) 1990-1993 Michael A. Cooper.\n\
 All rights reserved.\n";
#endif

/*
 * Copyright (c) 1990-1993 Michael A. Cooper.
 * This software may be freely distributed provided it is not sold for 
 * profit and the author is credited appropriately.
 */

#include "config.h"
#include "qterm.h"
#include <stdio.h>
#include <errno.h>

/*
 * Get system error string
 */
char *SysErr()
{
    extern int			errno;
    extern int			sys_nerr;
    extern char		       *sys_errlist[];
    static char			buff[BUFSIZ];

    if (errno > 0 && errno < sys_nerr)
	return(sys_errlist[errno]);
    else {
	(void) sprintf(buff, "Unknown error %d", errno);
	return(buff);
    }
}

#if 	ARG_TYPE == ARG_VARARGS
/*
 * Varargs Error()
 */
void Error(va_alist)
    va_dcl
{
    va_list 			args;
    char		       *fmt;

    (void) fprintf(stderr, "%s: ", ProgName);

    va_start(args);
    fmt = va_arg(args, char *);
    (void) vfprintf(stderr, fmt, args);
    va_end(args);

    (void) fprintf(stderr, "\r\n");
}
#endif	/* ARG_VARARGS */

#if 	ARG_TYPE == ARG_STDARGS
/*
 * Stdargs Error()
 */
void Error(char *fmt, ...)
{
    va_list 			args;

    (void) fprintf(stderr, "%s: ", ProgName);

    va_start(args, fmt);
    if (fmt)
	(void) vfprintf(stderr, fmt, args);
    va_end(args);

    (void) fprintf(stderr, "\r\n");
}
#endif	/* ARG_VARARGS */

#if 	!defined(ARG_TYPE)
/*
 * Simple Error()
 */
void Error(fmt, a1, a2, a3, a4, a5, a6)
    char *fmt;
{
    (void) fprintf(stderr, "%s: ", ProgName);

    if (fmt)
	(void) fprintf(stderr, fmt, a1, a2, a3, a4, a5, a6);

    (void) fprintf(stderr, "\r\n");
}
#endif	/* ARG_VARARGS */


#if 	ARG_TYPE == ARG_VARARGS
/*
 * Varargs dprintf()
 */
void dprintf(va_alist)
    va_dcl
{
    va_list 			args;
    char		       *fmt;

    if (!Debug)
	return;

    va_start(args);
    fmt = va_arg(args, char *);
    (void) vfprintf(stderr, fmt, args);
    va_end(args);
}
#endif	/* ARG_VARARGS */

#if 	ARG_TYPE == ARG_STDARGS
/*
 * Stdargs dprintf()
 */
void dprintf(char *fmt, ...)
{
    va_list 			args;

    if (!Debug)
	return;

    va_start(args, fmt);
    if (fmt)
	(void) vfprintf(stderr, fmt, args);
    va_end(args);
}
#endif	/* ARG_VARARGS */

#if 	!defined(ARG_TYPE)
/*
 * Simple dprintf()
 */
void dprintf(fmt, a1, a2, a3, a4, a5, a6)
    char *fmt;
{
    if (!Debug)
	return;

    if (fmt)
	(void) fprintf(stderr, fmt, a1, a2, a3, a4, a5, a6);
}
#endif	/* ARG_VARARGS */


/*
 * xmalloc - Do a malloc with error checking.
 */
char *xmalloc(size)
    int 			size;
{
    char 		       *p;
    char		       *malloc();
    
    if ((p = malloc((unsigned) size)) == NULL) {
	Error("malloc %d bytes failed: %s.", size, SYSERR);
	Done(1);
	/*NOTREACHED*/
    }
    
    return(p);
}

#if	RE_TYPE == RE_BSD
/*
 * BSD style regular expression matching
 */
int RegExMatch(re, string)
    char		       *re;
    char		       *string;
{
    char		       *errmsg;
    char		       *re_comp();

    if (errmsg = re_comp(re)) {
	Error("Bad regular expression: \"%s\": %s.", re, errmsg);
	return(-1);
    }

    if (re_exec(string) == 1)
	return(TRUE);	/* Matched */

    return(0);
}
#endif	/* RE_BSD */

#if	RE_TYPE == RE_SYSV
/*
 * SYSV style regular expression matching
 */
int RegExMatch(re, string)
    char		       *re;
    char		       *string;
{
    char		       *reptr;
    char		       *regcmp();
    int				status = 0;

    if ((reptr = regcmp(re, (char *)NULL)) == (char *)NULL) {
	Error("Bad regular expression: \"%s\".", re);
	return(-1);
    }

    if (regex(reptr, string))
	status = 1;	/* Matched */

    (void) free(reptr);
    return(status);
}
#endif	/* RE_SYSV */

#if	RE_TYPE == RE_REGCOMP
/*
 * HP/UX style regular expression matching
 */
#include <regex.h>

int RegExMatch(pattern, string)
    char		       *pattern;
    char		       *string;
{
    int				status = 0;
    regex_t			re;

    if (regcomp(&re, pattern, REG_NOSUB|REG_NEWLINE)) {
	Error("Bad regular expression: \"%s\".", pattern);
	return(-1);
    }

    if (regex(&re, string, (size_t) 0, NULL, 0) == 0)
	status = 1;	/* Matched */

    regfree(&re);
    return(status);
}
#endif	/* RE_REGCOMP */

/*
 * Copy a string
 */
char *StrCopy(ptr)
    char		       *ptr;
{
    char		       *newptr;

    if (!ptr)
	return((char *)NULL);

    newptr = xmalloc(strlen(ptr)+1);
    (void) strcpy(newptr, ptr);

    return(newptr);
}
