#include <stdio.h> 
#include "Match.h"

unsigned Match::add_globbed(const glob_t &glob_struct)
{
    register char
	*cp;
    struct stat
	buf;
    register unsigned
	count;

#ifdef DEBUG
	fprintf(stderr, "Match::add_globbed() called\n");
#endif

    if (!(count = glob_struct.gl_pathc))	// any elements globbed ?
    {
#ifdef DEBUG
	fprintf(stderr, "Match::add_globbed(): no joy\n");
#endif
	return (0);			// no, inform the caller
    }

    for (register int index = 0; cp =  glob_struct.gl_pathv[index]; index++)
    {
	if
	(
	    !stat(cp, &buf)		// stat succeeds
	    &&
	    S_ISDIR(buf.st_mode)	// and it's a dir
	)
	{
#ifdef DEBUG
	    fprintf(stderr, "Match::add_globbed():\t added: ");
#endif
	    add(cp);			// then add the name
#ifdef DEBUG
	    fprintf(stderr, "Match::add_globbed():\t %s\n", cp);
#endif
	}
    }

    return (count);			// return # paths found
}	
	
