#!/bin/sh

#
# where is our wastebasket?
#
WB="@WASTEBASKET@"
WBROOT="@WBROOT@"
wastebasket=$HOME/${WB:-".wastebasket"}/${WBROOT:-"waste"}

purge()
{
   if [ -n "$1" ]; then
	purgefile=${1:${#wastebasket}:${#1}-11-${#wastebasket}}
#
#	shall we really purge the file?
#
	if [ "$ask" ]; then
		del=0
		echo -n "$0: purge \`$purgefile'? "
		read input 
		if [ "$input" = "y" ]; then
			del=1
		fi
	else
		del=1
	fi
#
#	No!
#
	if [ "$del" = "0" ]; then
		return -1
	fi
#
#	print out what we're doing
#
	if [ "$verbose" ]; then
		echo "$0: purging file $purgefile"
	fi
#
#	we do not have to use realrm here since libwastebasket checks whether
#	it is inside the wastebasket or not
#
	rm -f "$1"
	return 0
   fi
   return -1
}

while getopts "vqid:" OPT; do
	case $OPT in
		v)	verbose=1;;
		i)	ask=1;;
		d)	diff=$OPTARG;;
		*)	echo "Usage: $0 [-v] [-i] [-d days]" >& 2
			exit 1;;
	esac
done

if [ ! "$diff" ]; then
	diff=7
fi

#
# calculate the time stamp up to which we are going to purge
#
now=`date +%s`
stamp=`expr $now - $diff \* 24 \* 60 \* 60`

#
# print all files that were deleted before the time stamp
#
IFS=' '

wb_files=`find $wastebasket \( -type f -o -type l \)\
	-regex ".*_[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]"`

typeset -i count sum size

sum=0
count=0

for file in $wb_files
do
 	if [ ${file:${#file}-10} -lt $stamp ]; then
		stat=`ls -ds "$file"`
		size=${stat%%/*}
		purge "$file"
		if [ $? -eq 0 ]; then
			count=`expr $count + 1`
			sum=`expr $sum + $size`
		fi

	fi
done

if [ "$verbose" ]; then
	echo "$0: totally purged "$count" files with "$sum"KB."
fi

exit 0

