/* sdquery.c
   This program just regurgitates information about the safedelete
   configuration along with parsed items from the .safedelete.log file.
*/

#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <stdio.h>
#include <pwd.h>
#include <grp.h>
#include <string.h>
#include <ctype.h>
#include <getopt.h>
#include <errno.h>
#include <time.h>
#include <utime.h>
#include "safedelete.h"

#define NUM_CMD_FLAGS 18

/* main routine

   Parses the command line parameters and returns the requested info

   Usage: sdquery [flags]

	flags: original filename (ala "undelete -l") is almost always displayed 
		-v = version of safedelete used to process file
		-f = file flags for file
		-n = grunged filename for file (ala "undelete -lf")
		-p = file permissions
		-u = uid or user name of file owner
		-g = gid or group name of file owner
		-s = size of file
		-a = access time
		-m = modified time
		-l = symlink target, if file is a symlink
		-c = uncompress command, if grunged file was compressed
		-d = date file was deleted
		-t = time file was deleted
		-x = file suffix, if grunged file was compressed

		-e = environment variables ONLY (filename NOT displayed)
*/

int main(argc, argv)
  int argc;
  char **argv;
{
int i, j, ccode;
int SafeDays;

int Vflag, Fflag, Nflag, Pflag, Uflag, Gflag;
int Sflag, Aflag, Mflag, Lflag, Cflag, Xflag;
int Dflag, Tflag;

mode_t  Mode;
uid_t   Uid;
gid_t   Gid;
off_t   Size;
time_t  Atime, Mtime;

FILE *gfp;

char *wrkptr, *wrkptr2, *palloc, *HomeDir, *LogEnt;

char CmdFlags[NUM_CMD_FLAGS];
char CmdName[16];
char SafeDelLog[DEL_LOG_LEN];
char SafeDir[SAFE_DIR_LEN];

char WorkBuf[WORK_BUF_LEN];
char FileName[FILE_NAME_LEN];
char LinkName[FILE_NAME_LEN];
char GrungedFileName[GRUNGED_FILE_LEN];
char CompressCmd[41];
char FileSuff[9];

char Permissions[8][4];

struct stat FileInfo;
struct passwd *UserInfo, *UidInfo;
struct group  *GidInfo;
struct tm *tm;
fileflag_struct *FileFlags;

/* Initialize a bunch of stuff */

  strcpy(CmdName, "sdquery");
  HomeDir=NULL;
  for(i=0; i<NUM_CMD_FLAGS; i++)
    CmdFlags[i]='\0';
  j=0;
  Vflag=0;
  Fflag=0;
  Nflag=0;
  Pflag=0;
  Uflag=0;
  Gflag=0;
  Sflag=0;
  Aflag=0;
  Mflag=0;
  Lflag=0;
  Cflag=0;
  Xflag=0;
  Dflag=0;
  Tflag=0;

  strcpy(Permissions[0], "---");
  strcpy(Permissions[1], "--x");
  strcpy(Permissions[2], "-w-");
  strcpy(Permissions[3], "-w-");
  strcpy(Permissions[4], "r--");
  strcpy(Permissions[5], "r-x");
  strcpy(Permissions[6], "rw-");
  strcpy(Permissions[7], "rwx");

  HomeDir=getenv("HOME");
  if(! HomeDir) 
  {
    wrkptr2=getlogin();
    UserInfo=getpwnam(wrkptr2);
    HomeDir=UserInfo->pw_dir;
  }
  strcpy(SafeDelLog, HomeDir);
  strcat(SafeDelLog, LOG_NAME);
 
  strcpy(SafeDir, HomeDir);
  strcat(SafeDir, SAFE_DIR_NAME);

  while((i=getopt(argc, argv, "evfnpugsamlcxdt?")) != -1)
  { 
    switch(i)
    {
      case 'e' : wrkptr=getenv("SAFEDAYS");
		 if(! wrkptr) 
		   SafeDays=MAX_SAFE_DAYS;
		 else
		   SafeDays=atoi(wrkptr);

		 printf("SAFEDAYS is %d\n", SafeDays);
		 printf("LOG_NAME is %s\n", SafeDelLog);
		 printf("SAFE_DIR_NAME is %s\n", SafeDir);
		 printf("MAX_FILES is %d\n", MAX_FILES);
		 
		 return 0;

      case 'v' : if(! Vflag) { 
		   Vflag=1;
		   CmdFlags[j]=(char)i;
		   j++;
		 }
		 break;


      case 'f' : if(! Fflag) { 
		   Fflag=1;
		   CmdFlags[j]=(char)i;
		   j++;
		 }
		 break;

      case 'n' : if(! Nflag) { 
		   Nflag=1;
		   CmdFlags[j]=(char)i;
		   j++;
		 }
		 break;

      case 'p' : if(! Pflag) { 
		   Pflag=1;
		   CmdFlags[j]=(char)i;
		   j++;
		 }
		 break;

      case 'u' : if(! Uflag) { 
		   Uflag=1;
		   CmdFlags[j]=(char)i;
		   j++;
		 }
		 break;

      case 'g' : if(! Gflag) { 
		   Gflag=1;
		   CmdFlags[j]=(char)i;
		   j++;
		 }
		 break;

      case 's' : if(! Sflag) { 
		   Sflag=1;
		   CmdFlags[j]=(char)i;
		   j++;
		 }
		 break;

      case 'a' : if(! Aflag) { 
		   Aflag=1;
		   CmdFlags[j]=(char)i;
		   j++;
		 }
		 break;

      case 'm' : if(! Mflag) { 
		   Mflag=1;
		   CmdFlags[j]=(char)i;
		   j++;
		 }
		 break;

      case 'l' : if(! Lflag) { 
		   Lflag=1;
		   CmdFlags[j]=(char)i;
		   j++;
		 }
		 break;

      case 'c' : if(! Cflag) { 
		   Cflag=1;
		   CmdFlags[j]=(char)i;
		   j++;
		 }
		 break;

      case 'x' : if(! Xflag) { 
		   Xflag=1;
		   CmdFlags[j]=(char)i;
		   j++;
		 }
		 break;

      case 'd' : if(! Dflag) { 
		   Dflag=1;
		   CmdFlags[j]=(char)i;
		   j++;
		 }
		 break;

      case 't' : if(! Tflag) { 
		   Tflag=1;
		   CmdFlags[j]=(char)i;
		   j++;
		 }
		 break;

      case '?' : printf("Usage: sdquery [flags]\n\n");
	         printf("flags: (original filename is usually displayed)\n");
	         printf("-e = environment variables ONLY (filename NOT displayed)\n");
	         printf("-v = version of safedelete used to process file\n");
	         printf("-f = file flags for file\n");
	         printf("-n = grunged filename for file (ala \"undelete -lf\")\n");
	         printf("-p = file permissions\n");
	         printf("-u = uid or user name of file owner\n");
	         printf("-g = gid or group name of file owner\n");
                 printf("-s = size of file\n");
	         printf("-a = access time\n");
	         printf("-m = modified time\n");
	         printf("-l = symlink target, if file is a symlink\n");
	         printf("-c = uncompress command, if grunged file was compressed\n");
	         printf("-x = file suffix, if grunged file was compressed\n");
	         printf("-d = date file was safedeleted\n");
	         printf("-t = time file was safedeleted\n");
		 return 0;

      default : return 1;
    }
  }
/*
  printf("Flag order: ");
  for(j=0; j<15; j++)
    printf("%c ", CmdFlags[j]);
  printf("\n");
*/
/* Get stuff from the .safedelete.log file and parse it */

  if((ccode=stat(SafeDelLog, &FileInfo))) 
  {
    printf("SafeDelete log file %s not found\n", SafeDelLog);
    return 1;
  }

  if(FileInfo.st_size == 0) 
  {
    printf("SafeDelete log file %s is empty\n", SafeDelLog);
    return 1;
  }

  i=FileInfo.st_size;
  wrkptr2=palloc=malloc(i);
  gfp=fopen(SafeDelLog, "r");
  fread(wrkptr2, i, 1, gfp);
  fclose(gfp);

  LogEnt=palloc;

  while((int)(LogEnt-palloc) < FileInfo.st_size)
  {
    wrkptr=LogEnt;
    FileFlags=(fileflag_struct*)wrkptr;

    wrkptr+=sizeof(fileflag_struct);
    strcpy(FileName, wrkptr);

    wrkptr+=strlen(FileName)+1;
    strcpy(GrungedFileName, wrkptr);

    wrkptr+=strlen(GrungedFileName)+1;

    Mode=atoi(wrkptr);
    wrkptr+=strlen(wrkptr)+1;
    Uid=atoi(wrkptr);
    wrkptr+=strlen(wrkptr)+1;
    Gid=atoi(wrkptr);
    wrkptr+=strlen(wrkptr)+1;
    Size=atol(wrkptr);
    wrkptr+=strlen(wrkptr)+1;
    Atime=atol(wrkptr);
    wrkptr+=strlen(wrkptr)+1;
    Mtime=atol(wrkptr);
    wrkptr+=strlen(wrkptr)+1;

    if(FileFlags->LinkFlag == FLAGON)
    {
      strcpy(LinkName, wrkptr);
      wrkptr+=strlen(LinkName)+1;
    }

    if(FileFlags->NoCompressFlag == FLAGOFF)
    {
      strcpy(CompressCmd, wrkptr); 
      wrkptr+=strlen(CompressCmd)+1;
      strcpy(FileSuff, wrkptr);
      wrkptr+=strlen(FileSuff)+1;
    }

    printf("%s ", FileName);

    for(j=0; j<NUM_CMD_FLAGS; j++)
    {
      if(! CmdFlags[j]) break;
      switch (CmdFlags[j])
      {
        case 'v' : printf("%c ", FileFlags->Version);
		   break;

        case 'f' : printf("Link=%c NoCompress=%c ", FileFlags->LinkFlag, 
				   FileFlags->NoCompressFlag);
		   break;

        case 'n' : printf("%s ", GrungedFileName);
		   break;

        case 'p' : for(i=0; i<12; i++)
		     WorkBuf[i]='\0';
		   if(S_ISREG(Mode))
		     WorkBuf[0]='-';
		   if(S_ISDIR(Mode))
		     WorkBuf[0]='d';
		   if(S_ISLNK(Mode))
		     WorkBuf[0]='l';
		   if(S_ISBLK(Mode))
		     WorkBuf[0]='c';
		   if(S_ISFIFO(Mode))
		     WorkBuf[0]='b';
		   if(S_ISSOCK(Mode))
		     WorkBuf[0]='s';
		   i=(Mode>>6)&0x0007;
		   strcat(WorkBuf, Permissions[i]);
		   i=(Mode>>3)&0x0007;
		   strcat(WorkBuf, Permissions[i]);
		   i=Mode&0x0007;
		   strcat(WorkBuf, Permissions[i]);
		   printf("%s ", WorkBuf);
		   break;

        case 'u' : if(! (UidInfo=getpwuid(Uid)))
		     printf("%d ", Uid);
		   else
		     printf("%s ", UidInfo->pw_name);
		   break;

        case 'g' : if(! (GidInfo=getgrgid(Gid)))
		     printf("%d ", Gid);
		   else
		     printf("%s ", GidInfo->gr_name);
		   break;

        case 's' : printf("%d ", (int)Size);
		   break;

        case 'a' : tm=localtime(&Atime);
		   strftime(WorkBuf, 9, "%m/%d/%Y", tm);
		   printf("%s ", WorkBuf);
		   break;

        case 'm' : tm=localtime(&Mtime);
		   strftime(WorkBuf, 9, "%m/%d/%Y", tm);
		   printf("%s ", WorkBuf);
		   break;

        case 'l' : printf("%s ", LinkName);
		   break;

        case 'c' : printf("%s ", CompressCmd);
		   break;

        case 'x' : printf("%s ", FileSuff);
		   break;

	case 'd' : if(GrungedFileName[5] == '9')
		     sprintf(WorkBuf, "%c%c/%c%c/19%c%c ", GrungedFileName[1],
		           GrungedFileName[2], GrungedFileName[3],
		           GrungedFileName[4], GrungedFileName[5],
			   GrungedFileName[6]);
		   else
		     sprintf(WorkBuf, "%c%c/%c%c/20%c%c ", GrungedFileName[1],
		           GrungedFileName[2], GrungedFileName[3],
		           GrungedFileName[4], GrungedFileName[5],
			   GrungedFileName[6]);
		   printf("%s ", WorkBuf);
		   break;

	case 't' : sprintf(WorkBuf, "%c%c:%c%c:%c%c ", GrungedFileName[9],
		           GrungedFileName[10], GrungedFileName[11],
		           GrungedFileName[12], GrungedFileName[13],
			   GrungedFileName[14]);
		   printf("%s ", WorkBuf);
		   break;
      }
    }

    printf("\n");
    LogEnt+=RecLen(LogEnt);

  }
  free(palloc);
  return 0;
}
