#ifndef _SAFEDEL_H
#define _SAFEDEL_H

#include <sys/types.h>
#include <dirent.h>

#define HOME_DIR_LEN     45
#define GRUNGED_FILE_LEN 31
#define DEL_LOG_LEN      49
#define FILE_NAME_LEN    256
#define WORK_BUF_LEN     512
#define SAFE_DIR_LEN     256
#define SAFE_RC_LEN      256
#define BIG_NUM         9999

#define PREFIX   1
#define SUFFIX   2
#define INFIX    3
#define FULLNAME 4
#define ALLFILES 5

#define VERSION '3'

#define YES_MSG 1
#define NO_MSG  0

#ifndef TRUE
#define TRUE  1
#define FALSE 0
#endif

#define FLAGOFF '0'
#define FLAGON  '1'

#define CP_OK          0
#define CP_DIR_NF      1
#define CP_NOT_DIR     2
#define CP_DIR_NOWRITE 3
#define CP_FILE_NF     4
#define CP_NOT_FILE    5
#define CP_BAD_LOG     6
#define CP_FILE_NOREAD 7

#define LCKBSY_WAIT    1
#define LCKBSY_PROMPT  2
#define LCKBSY_QUIT    3

#define SORTBY_NAME    0
#define SORTBY_DATE    1

#define DATEFMT_MDY    0
#define DATEFMT_DMY    1

/* Various filenames */

#define LOG_NAME "/.safedelete.log"
#define RC_NAME  "/.Safedelrc"
#define LOCK_NAME "/.safedelete.lock"

/* File Flags structure */

typedef struct
{
char Version;
char LinkFlag;
char NoCompressFlag;
char MoreFlags[14];   
} fileflag_struct;

/* .Safedelrc structures */

typedef struct
{
int  LockBusyFlag;
int  SortByFlag;
int  DateFmtFlag;
} opts_struct;

typedef struct
{
char *FileName;
int  Type;
int  PreLen;
int  SufLen;
int  Days;
} safedays_struct;

typedef struct
{
char *FileName;
int  Type;
int  PreLen;
int  SufLen;
char *CompCmd;
char *UncompCmd;
} compression_struct;

typedef struct
{
char *CmdName;
char *Suffix;
} suffix_struct;

typedef struct
{
int  NumDaysEnts;
safedays_struct *DaysStruct;
int  NumCompressEnts;
compression_struct *CompStruct;
int  NumSuffixes;
suffix_struct *SuffStruct;
opts_struct *OptionsStruct;
} rcstruct;

/* Directory structure used for recursive deletes */

struct dir_struct
{
int  BaseDir;
int  FilesLeft;
DIR  *dirptr;
struct dirent *dirent;
struct dir_struct *PrevDir;
char DirName[256];
};

#ifndef HPUX
#ifndef SUNOS

/* Global external subroutine prototypes */

extern int ParseFileName(char *FileName);
extern int CheckPerms(char *DirName, char *FileName, char *Cmd, int MsgInd);
extern rcstruct *ReadRC(char *RCFileName, char *SectName);
extern int CheckFilePattern(char *FileName, compression_struct *cs);
extern int CheckFileDays(char *FileName, safedays_struct *ss);
extern int RecLen(char *Rec);
extern int AcquireLock(char *LockFileName, char *CmdName, char *SafeDelRC, int Mode);
extern void ReleaseLock(void);

#endif /* SUNOS */
#endif /* HPUX */

#endif
