#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <pwd.h>
#include <ctype.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "safedelete.h"

int  main(argc, argv)
  int argc;
  char **argv;
{
char InLog[WORK_BUF_LEN];
char InLogOld[WORK_BUF_LEN];
char OutLog[WORK_BUF_LEN];
char SafeDelLockFile[DEL_LOG_LEN];
char SafeDelRC[SAFE_RC_LEN];
char NewDir[256], OldDir[256];
char WorkBuf[WORK_BUF_LEN];
FILE *in, *out;
char *inbuf, *outbuf, *CurrIn;
char *wrkptr, *wrkptr2, *LoginName, *HomeDir;
char CmdName[16];
int  j, k;
struct stat FileInfo, DirInfo;
fileflag_struct FileFlags;
struct passwd *UserInfo;

typedef struct  {
int Version;
int Flag;
mode_t Mode;
uid_t  Uid;
gid_t  Gid;
off_t  Size;
time_t Atime;
time_t Mtime;
} fileinfo_struct;
  
#define NOCOMPRESS 1
  
fileinfo_struct *OrigInfo;

  strcpy(CmdName, "safecnvt");
  HomeDir=getenv("HOME");
  if(HomeDir == NULL)
  {
    LoginName=getlogin();
    UserInfo=getpwnam(LoginName);
    HomeDir=UserInfo->pw_dir;
  }

  strcpy(NewDir, HomeDir);
  strcat(NewDir, SAFE_DIR_NAME);
  strcpy(InLog, HomeDir);
  strcat(InLog, LOG_NAME);
  strcpy(SafeDelLockFile, HomeDir);
  strcat(SafeDelLockFile, LOCK_NAME);
  strcpy(InLogOld, InLog);
  strcat(InLogOld, ".old");
  strcpy(OutLog, InLog);
  strcat(OutLog, ".new");

  if((wrkptr=getenv("SAFEDELRC")) != NULL)
    strcpy(SafeDelRC, wrkptr);
  else
  {
    strcpy(SafeDelRC, HomeDir);
    strcat(SafeDelRC, RC_NAME);
  }
     
  if(stat(InLog, &FileInfo) != 0)
  {
    printf("%s: %s not found\n", CmdName, InLog);
    return 1;
  }
  
  if(FileInfo.st_size == 0)
  {
    printf("%s: your .safedelete.log is empty, conversion not needed\n", CmdName);
    return 0;
  }

/* Convert the old .safedelete.log to the new format */

  printf("%s: converting your .safedelete.log\n", CmdName);

/* Get log file lock */
  
  if(AcquireLock(SafeDelLockFile, CmdName, SafeDelRC, 0))
  {
    printf("%s: file %s is busy, try again later\n", CmdName, InLog);
    return 1;
  }
  
  CurrIn=inbuf=malloc(2*FileInfo.st_size);
  outbuf=inbuf+FileInfo.st_size;
  in=fopen(InLog, "r");
  fread(inbuf, FileInfo.st_size, 1, in);
  fclose(in);

/* See if the .safedelete.log was previously converted */

  if(isdigit(*inbuf))
  {
    printf("%s: your .safedelete.log was previously converted\n", CmdName);
    ReleaseLock();
    free(inbuf);
    return 0;
  }
  
  for(j=0, wrkptr=(char *)&FileFlags; j < sizeof(fileflag_struct); j++, wrkptr++)
    *wrkptr=FLAGOFF;
  
/* Convert a release 0 log */
  
  if(*inbuf == '/')
  {

/* Move the files from the old SafeDelete 
   directory to the new one.
*/

    printf("%s: enter the complete path where your safedeleted files are\n", CmdName);
    printf("%s: currently kept ==> ", CmdName);
    fgets(OldDir, 256, stdin);
    wrkptr=strchr(OldDir, '\n');
    *wrkptr='\0';

/* Make target directory if it doesn't exist */

    if(stat(NewDir, &DirInfo) != 0)
    {
      printf("%s: creating %s\n", CmdName, NewDir);
      mkdir(NewDir, S_IRWXU);
    }
  
    printf("%s: moving your safedeleted files from %s\nsafecnvt: to %s\n", 
	   CmdName, OldDir, NewDir);
    sprintf(WorkBuf, "mv %s/* '%s'", OldDir, NewDir);
    system(WorkBuf);
    FileFlags.Version='0';

    out=fopen(OutLog, "w");

    while((long)(CurrIn-inbuf) < FileInfo.st_size)
    {
      wrkptr=strchr(CurrIn, '\n')+1;   /* Look for start of next record */
      j=(int)(wrkptr-CurrIn);
      memcpy(outbuf, &FileFlags, sizeof(fileflag_struct));
      memcpy(outbuf+sizeof(fileflag_struct), CurrIn, j);     /* Copy record to area */
      CurrIn+=j;                       /* Point to next input record */
      wrkptr=strchr(outbuf+sizeof(fileflag_struct), '\t');   /* End filename with null */
      *wrkptr='\0';
      wrkptr=strchr(wrkptr+1, '\n');   /* End grunged name with null */
      *wrkptr='\0';
      wrkptr++;                        /* Point past grunged name */
      strcpy(wrkptr, "0");             /* Set mode to 0 */
      wrkptr+=strlen(wrkptr)+1;
      strcpy(wrkptr, "0");             /* Set uid to 0 */
      wrkptr+=strlen(wrkptr)+1;
      strcpy(wrkptr, "0");             /* Set gid to 0 */
      wrkptr+=strlen(wrkptr)+1;
      strcpy(wrkptr, "0");             /* Set size to 0 */
      wrkptr+=strlen(wrkptr)+1;
      strcpy(wrkptr, "0");             /* Set atime to 0 */
      wrkptr+=strlen(wrkptr)+1;
      strcpy(wrkptr, "0");             /* Set mtime to 0 */
      wrkptr+=strlen(wrkptr)+1;
      *wrkptr='\n';                    /* Add end-of-record indicator */
      fwrite(outbuf, RecLen(outbuf), 1, out);
    }
    fclose(out);
    rename(InLog, InLogOld);
    rename(OutLog, InLog);
  }

/* Convert a release 1 or 2 log */

  else
  {
    j=k=0;
    FileFlags.Version=VERSION;

    out=fopen(OutLog, "w");

    while(j < FileInfo.st_size)
    {
      memcpy(&k, CurrIn, 2);
      wrkptr=outbuf+sizeof(fileflag_struct);
      wrkptr2=CurrIn+2;
      strcpy(wrkptr, wrkptr2);  /* Move original filename */
      wrkptr+=strlen(wrkptr)+1;
      wrkptr2+=strlen(wrkptr2)+1;
      strcpy(wrkptr, wrkptr2);  /* Move grunged filename */
      wrkptr+=strlen(wrkptr)+1;
      wrkptr2+=strlen(wrkptr2)+1;
      if(*wrkptr2 == 127)
        wrkptr2++;
      OrigInfo=(fileinfo_struct *)wrkptr2;
      wrkptr2+=sizeof(fileinfo_struct);
      if(S_ISLNK(OrigInfo->Mode))
        FileFlags.LinkFlag=FLAGON;
      if(OrigInfo->Flag && NOCOMPRESS)
        FileFlags.NoCompressFlag=FLAGON;
      sprintf(wrkptr, "%d", OrigInfo->Mode);
      wrkptr+=strlen(wrkptr)+1;
      sprintf(wrkptr, "%d", OrigInfo->Uid);
      wrkptr+=strlen(wrkptr)+1;
      sprintf(wrkptr, "%d", OrigInfo->Gid);
      wrkptr+=strlen(wrkptr)+1;
      sprintf(wrkptr, "%li", OrigInfo->Size);
      wrkptr+=strlen(wrkptr)+1;
      sprintf(wrkptr, "%li", OrigInfo->Atime);
      wrkptr+=strlen(wrkptr)+1;
      sprintf(wrkptr, "%li", OrigInfo->Mtime);
      wrkptr+=strlen(wrkptr)+1;
      if(FileFlags.LinkFlag == FLAGON)
      {
	strcpy(wrkptr, wrkptr2);  /* move in symlink name */
	wrkptr+=strlen(wrkptr)+1;
      }
      if(FileFlags.NoCompressFlag == FLAGOFF)
      {
	strcpy(wrkptr, wrkptr2);  /* move in uncompress command */
	wrkptr+=strlen(wrkptr)+1;
	wrkptr2+=strlen(wrkptr2)+1;
	strcpy(wrkptr, wrkptr2);  /* move in filename suffix */
	wrkptr+=strlen(wrkptr)+1;
      }
      *wrkptr='\n';
      memcpy(outbuf, &FileFlags, sizeof(fileflag_struct));
      fwrite(outbuf, RecLen(outbuf), 1, out);
      j+=k;
      CurrIn+=k;
    }
    fclose(out);
    rename(InLog, InLogOld);
    rename(OutLog, InLog);
  }

/* Release lock */
  
  ReleaseLock();
  
  free(inbuf);

  printf("%s: conversion successful!\n", CmdName);
  return 0;
}
