/* 

The SunOS code provided by Alexandar Howard at the University of Washington 

*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>
#include <sys/file.h>
#include <sys/types.h>
#include <fcntl.h>
#include "safedelete.h"

/* Global variables */

static int lock;

/* AcquireLock
  
   This routine checks on the existence of the lock file 
   and creates one if it doesn't exist.

   Passed: pointer to lock file name
           pointer to command name
           pointer to user's .Safedelrc filename
           flag indicating mode (0=user  1=administrator)
             (this flag used only for safedelchk!)

   Returns: 0 - lock acquired
            1 - another process holds the lock
 
*/
 
int AcquireLock(LockFileName, CmdName, SafeDelRC, Mode)
  char *LockFileName, *CmdName, *SafeDelRC;
  int  Mode;
{
struct stat FileInfo;
int  i, j, c;
static int BeenHere = 0;
static opts_struct options;
opts_struct *opts;
rcstruct *RCstruct;
char WorkBuf[WORK_BUF_LEN];

  if(! BeenHere)
  {
    
/* If this is safedelchk running in admin mode, ignore the
   user's .Safedelrc file
*/
    
    if(Mode)
      options.LockBusyFlag=LCKBSY_QUIT;
    else
    {
      options.LockBusyFlag=LCKBSY_PROMPT;   /* Set default action */
    
/* See if user has an 'options' section is their .Safedelrc */
    
      if((RCstruct=(rcstruct*)ReadRC(SafeDelRC, "options")))
      {
        if((opts=RCstruct->OptionsStruct))
        {
          options.LockBusyFlag=opts->LockBusyFlag;
          free(opts);
        }
      }
    }
    BeenHere=1;
  }

/* See if the lock file exists, if so, open it
   and slap an exclusive lock on it so noone
   else can get it.  If someone else already
   has it locked, we just close the file and
   try again after waiting a 10th of a second.
   We'll wait 5 seconds before checking on what
   the user wants us to do.
*/

  if((stat(LockFileName, &FileInfo)))
  {
    if((lock=creat(LockFileName, S_IRUSR | S_IWUSR)) == -1)
    {
      sprintf(WorkBuf, "%s: error creating lock file", CmdName);
      perror(WorkBuf);
      return 1;
    }
    close(lock);
  }
  
  lock=open(LockFileName, O_WRONLY);

  if(lockf(lock, F_TLOCK, 1) == 0)
    return 0;

  close(lock);  

  switch(options.LockBusyFlag)
  {
    case LCKBSY_WAIT : j=1;
                      while(j)
                      {
                        for(i=0; i < 250; i++)
                        {
                          usleep(100);
 	                  lock=open(LockFileName, O_WRONLY);
	                  if((j=lockf(lock, F_TLOCK, 1)) == 0)
			     break;
			  close(lock);
		        }
			if(j && getppid() != 1)
           		  printf("%s: waiting for lock file\n", CmdName);
		      }
		      break;
    
    case LCKBSY_PROMPT : j=1;
                      while(j)
                      {
                        for(i=0; i < 250; i++)
                        {
                          usleep(100);      
		          lock=open(LockFileName, O_WRONLY);
			  if((j=lockf(lock, F_TLOCK, 1)) == 0)
			    break;
			  close(lock);
		        }
		        if(j && getppid() != 1)
			{
                 printf("%s: unable to obtain lock, continue waiting? (y|n) ", CmdName);
 			  while((c=getchar()) != 'n' && c != 'N' && 
			     c != 'y' && c != 'Y');
			  if(c == 'n' || c == 'N') 
			    return 1;
			}
		      }
                      break;

    case LCKBSY_QUIT : return 1;
      
   default : return 1;
  }
  return 0;
}

/* ================================================================ */

/* ReleaseLock
 
   Releases the lock by deleting the lock file.
 
   Passed: nothing, uses global pointer to lock filename

   Returns: nothing
*/

void ReleaseLock()
{
  lockf(lock, F_ULOCK, 1);
  close(lock);
}
 
