/* chkperm.c 
   Check permissions on the safedelete directory
   and the user's .safedelete.log.

   Passed: pointer to directory name or NULL
           pointer to file name or NULL
           pointer to command calling us
           indicator telling us to issue messages or not

   Returns: 0 permission granted
            1 directory not found
            2 name provided is not a directory
            3 don't have write permission to directory
            4 file not found
            5 name provided is not a file
            6 user needs update access to .safedelete.log
            7 don't have read permission to file
*/

#include <unistd.h>
#include <sys/stat.h>
#include <stdio.h>
#include "safedelete.h"

int  CheckPerms(DirName, FileName, Cmd, MsgInd)
  char *DirName, *FileName, *Cmd;
  int  MsgInd;
{
int LinkFlag, RetCode;
int  i, j;
struct stat DirInfo, FileInfo;
char Message[256];

  LinkFlag=0;
  RetCode=CP_OK;
  j=0;
  *Message='\0';

  if(DirName)
  {
    if(stat(DirName, &DirInfo))
    {
      RetCode=CP_DIR_NF;
      goto BldMsg;
    }

    if(! S_ISDIR(DirInfo.st_mode))
    {
      RetCode=CP_NOT_DIR;
      goto BldMsg;
    }

    if(access(DirName, W_OK))
    {
      RetCode=CP_DIR_NOWRITE;
      goto BldMsg;
    }
  }

  if(FileName)
  {
    if(lstat(FileName, &FileInfo) || ! S_ISLNK(FileInfo.st_mode))
    {
      if(stat(FileName, &FileInfo))
      {
	RetCode=CP_FILE_NF;
	goto BldMsg;
      }
    }
    else
      LinkFlag=1;

    if(! LinkFlag && ! S_ISREG(FileInfo.st_mode))
    {
      RetCode=CP_NOT_FILE;
      goto BldMsg;
    }

    if(strcmp(FileName+strlen(FileName)-15, ".safedelete.log") == 0)
    {
      if(access(FileName, R_OK | W_OK) != 0)
        RetCode=CP_BAD_LOG;
      goto BldMsg;
    }
    else
    {
      if(! LinkFlag && access(FileName, R_OK))
        RetCode=CP_FILE_NOREAD;
      goto BldMsg;
    }
  }

BldMsg:
  switch(RetCode)
  {
    case CP_OK : break;

    case CP_DIR_NF : if(strcmp(Cmd, "undelete"))
                       break;
                     strcpy(Message, "\0");
                     RetCode=0;
                     j=1;
                     for(i=0; j > 0; i++)
                     {
                       j=ParseFileName(DirName);
                       *(DirName+j)='\0';
                     }

                     for( ; i > 0; i--)
                     {
                       j=strlen(DirName);
                       *(DirName+j)='/';
                       if(stat(DirName, &DirInfo))
                       {
                         if(mkdir(DirName, S_IRWXU | S_IRWXG | S_IRWXO) != 0)
                         {
                           RetCode=CP_DIR_NF;
                           sprintf(Message, "%s: %s: unable to create directory\n",
                                   Cmd, DirName);
                            break;
                         }
                       }
                     }
                     break;

    case CP_NOT_DIR : sprintf(Message, "%s: %s is not a directory\n",
                              Cmd, DirName);
                      break;

    case CP_DIR_NOWRITE : sprintf(Message, "%s: %s: write access denied\n",
                                  Cmd, DirName);
                          break;

    case CP_FILE_NF : sprintf(Message, "%s: %s: file not found\n",
                              Cmd, FileName);
                      break;

    case CP_NOT_FILE : sprintf(Message, "%s: %s is not a file\n",
                               Cmd, FileName);
                       break;

    case CP_BAD_LOG : sprintf(Message, "%s: %s: update access to log needed\n",
                              Cmd, FileName); 
                      break;

    case CP_FILE_NOREAD : sprintf(Message, "%s: %s: read access denied, unable to save file\n",
                                  Cmd, FileName);
                          break;

    default : break;
  }

  if(MsgInd && strlen(Message) > 0)
    fprintf(stderr, Message);

  return RetCode;
}
