#include <string.h>
#include "safedelete.h"

/* CheckFileDays

   Scans filename looking for a match with a pattern
   specified in the users .Safedelrc file.

   Passed: pointer to filename
           pointer to safedays_struct structure

   Returns: n - number of days file is to be saved
           -1 - filename does not match pattern
*/

int  CheckFileDays(FileName, ss)
  char *FileName;
  safedays_struct *ss;
{
int i;

  switch(ss->Type)
  {
    case PREFIX   : i=(*(ss->FileName) == '/' ? 0 : ParseFileName(FileName)+1);
                    if(strncmp(FileName+i, ss->FileName, ss->PreLen) == 0)
                      return ss->Days;
                    else
                      return -1;

    case SUFFIX   : if(strncmp(FileName+strlen(FileName)-ss->SufLen,
                              ss->FileName+1, ss->SufLen) == 0)
                      return ss->Days;
                    else
                      return -1;

    case INFIX    : i=(*(ss->FileName) == '/' ? 0 : ParseFileName(FileName)+1);
                    if(strncmp(FileName+i, ss->FileName, ss->PreLen) == 0)
                    {
                      if(strncmp(FileName+strlen(FileName)-ss->SufLen,
                                ss->FileName+strlen(ss->FileName)-ss->SufLen,
                                ss->SufLen) == 0)
                        return ss->Days;
                      else
                        return -1;
                    }
                    else
                      return -1;

    case FULLNAME : i=(*(ss->FileName) == '/' ? 0 : ParseFileName(FileName)+1);
                    if(strcmp(FileName+i, ss->FileName) == 0)
                      return ss->Days;
                    else
                      return -1;

    case ALLFILES : return ss->Days;
  }
  return -1; 
}
