#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include "ncd.h"

/*************************************************************************/
/* adds the final slash to {dirName} if necessary.   {returns} the same
   {dirName} */

char *addSlash(char *dirName)
{
	size_t len;

	len = strlen(dirName);
	if ((!len) || (dirName[len - 1] != '/')) {
		dirName[len + 1] = 0;
		dirName[len] = '/';
	}
	return dirName;
}

/*************************************************************************/
/* strips the final slash from {dirName} if necessary.  {returns} the same
   {dirName} */

char *stripSlash(char *dirName)
{
	size_t len;

	len = strlen(dirName);
	if ((len > 1) && (dirName[len - 1] == '/'))
		dirName[len - 1] = '\0';

	return dirName;
}

/*************************************************************************/
/* preprocesses {absDirName}, that must be a complete directory (starting
   with a slash), otherwise, the function {returns} NULL. The
   preprocessing consists on:

   - adding a final slash if necessary (/home/smith -> /home/smith/)   

   - stripping all sequences of two or more contiguos slashes
   (/home//smith/ -> /home/smith/)

   - evaluating all /../ sequences (/home/smith/../ -> /home/)

   The function {returns} the same preprocessed {absDirName}. */

char *compactAbsDir(char *absDirName)
{
	char *s, *ss;

	if ((*absDirName != 0) && (*absDirName != '/'))
		return NULL;

	addSlash(absDirName);

	while ((s = strstr(absDirName, "//")) != NULL)
		strcpy(s, s + 1);

	while ((s = strstr(absDirName, "/../")) != NULL) {
		*s = 0;
		ss = strrchr(absDirName, '/');
		if (ss != NULL)
			strcpy(ss, s + 3);
		else
			strcpy(absDirName, s + 3);
	}

	return absDirName;
}

/*************************************************************************/
/* converts the absolute directory {dir} in the actual physicall
   directory, substituting all the possible soft links, and also  adds the 

   final slash if necessary.

   {dir} must be an absolute directory (star with slash), otherwise the
   funcion return NULL.

   The funcion returns the same reconverted {dir}. {dir} must be PATH_MAX
   chars long (or more) */

char *trueDir(char *dir)
{
/* limits the max. number of links. Needed for ill formed link series */

	char *s;
	char stmp[PATH_MAX * 2];
	char lnk[PATH_MAX];
	char tpath[PATH_MAX*2];
	int i;
	int max;

	strcpy(stmp,dir);
	if (compactAbsDir(stmp) == NULL)
		return NULL;
	addSlash(stmp);
	tpath[0] = '/';
	tpath[1] = '\0';
	max = 0;
	

	while (stmp[0]!='\0') {

		s = strchr(stmp,'/');
		*s = '\0';
		addSlash(tpath);
		strcat(tpath,stmp);
		strcpy(stmp,s+1);
		
		stripSlash(tpath);
		i = readlink(tpath, lnk, PATH_MAX);
		if (i > 0) {
			max ++;
			if (max>MAX_LINKS)
				return NULL;
				
			lnk[i] = '\0';
			if (lnk[0] == '/')
				strcpy(tpath, lnk);
			else {
				addSlash(tpath);
				strcat(tpath, "../");
				strcat(tpath, lnk);
			}
			addSlash(tpath);
			strcat(tpath,stmp);
			compactAbsDir(tpath);
			strcpy(stmp,tpath);
			tpath[0] = '/';
			tpath[1] = '\0';
		}
	}
	strcpy(dir,tpath);

	return dir;
}

/*************************************************************************/
/* {returns} just the last subdirectory name (without the final slash), in 

   a malloc() allocated string (you must free() it!). In {dirPath} the
   function receives a directory name, with or without the final slash. If 

   {dirPath} is the root directory ('/') the function returns '/'. */

char *getDirName(char *dirPath)
{
	char *s, *ss;
	int slash;

	slash = ((*dirPath != '\0') && (dirPath[strlen(dirPath) - 1] == '/'));
	if (slash)
		stripSlash(dirPath);

	s = strrchr(dirPath, '/');
	if ((s == NULL) || (s[1] == '\0'))
		ss = strdup(dirPath);
	else
		ss = strdup(s + 1);

	if (ss == NULL) {
		cleanUp();
		fprintf(stderr, "error: no memory\n");
		exit(1);
	}
	if (slash)
		addSlash(dirPath);

	return ss;
}

/*************************************************************************/
