/* lwr.c Upper case filename to lower case converter.
 * Copyright (C) 1996 Robert Canup.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define _POSIX_SOURCE 1
#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/stat.h>
#include <limits.h>
#include <stdlib.h>
#include <string.h>
#include "terror.h" 

int processDir(char *name);
void makelower(char *name);

#define MAX_PATH 256
/*
 * This function will process 1 directory. It is called with
 * one argument:
 * name -- The file name of the directory to process.
 *
 */
int processDir(char *name)
{
DIR 	*current_directory;	
struct	dirent * dirName;	
struct	stat status;		
char	new_name[MAX_PATH+1];	
char	currentDir[MAX_PATH+1];
int	x;

	current_directory = opendir(name) ;
	if (current_directory == NULL)
		return(-1) ;
	if(getcwd(currentDir,MAX_PATH+1) == (int)NULL) TERROR ;
	if(chdir(name)) TERROR ; /* Otherwise stat won't work properly */
	while ((dirName = readdir(current_directory)) != NULL)
	{
		if ((strcmp(dirName->d_name,".")) &&
		(strcmp(dirName->d_name,"..")))
		{
			x = stat(dirName->d_name,&status) ;
			if (x != 0) 
			{
				printf("The file name is ***%s*** the status is %i\n",dirName->d_name,x) ;
				TERROR ;
			}
			if (!S_ISDIR(status.st_mode))
			{
				strcpy(new_name,dirName->d_name) ;
				x = strlen(new_name);
				for(x=0 ; x < strlen(new_name) ; x++ )
					new_name[x] = tolower(new_name[x]);
				rename(dirName->d_name,new_name) ;
			}
		}
		rename("makefile","Makefile") ;
		rename("readme","Readme") ;
	}
	if (closedir(current_directory)) TERROR ;
	if (chdir(currentDir)) TERROR ;
	return(0);
}


void makelower(char *name)
{
char new_name[MAX_PATH +1];
int x;
	
	strcpy(new_name,name) ;
	x = strlen(new_name);
	while((new_name[x] != '/') && (x >= 0)) 
	{ 
		new_name[x] = tolower(new_name[x]);
		x-- ;
	}
	rename(name,new_name) ;			
}

int main(int argc, char *argv[])
{
char	thisArg[MAX_PATH+1];
int x;

	if(argc == 1)
	{
		strcpy(thisArg,"./");
		processDir(thisArg);
		return(0);
	}	
	else
	{
		for(x = 1; x < argc; x++)
		{
			strcpy(thisArg,argv[x]);
			if(processDir(thisArg))
			{
				/* We now know argv[x] is not a directory */
				makelower(thisArg); 
			}
		}
	}
	return(0) ;
}
