# aclocal.m4 generated automatically by aclocal 1.6.2 -*- Autoconf -*-

# Copyright 1996, 1997, 1998, 1999, 2000, 2001, 2002
# Free Software Foundation, Inc.
# This file is free software; the Free Software Foundation
# gives unlimited permission to copy and/or distribute it,
# with or without modifications, as long as this notice is preserved.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY, to the extent permitted by law; without
# even the implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE.

# isc-posix.m4 serial 2 (gettext-0.11.2)
dnl Copyright (C) 1995-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

# This file is not needed with autoconf-2.53 and newer.  Remove it in 2005.

# This test replaces the one in autoconf.
# Currently this macro should have the same name as the autoconf macro
# because gettext's gettext.m4 (distributed in the automake package)
# still uses it.  Otherwise, the use in gettext.m4 makes autoheader
# give these diagnostics:
#   configure.in:556: AC_TRY_COMPILE was called before AC_ISC_POSIX
#   configure.in:556: AC_TRY_RUN was called before AC_ISC_POSIX

undefine([AC_ISC_POSIX])

AC_DEFUN([AC_ISC_POSIX],
  [
    dnl This test replaces the obsolescent AC_ISC_POSIX kludge.
    AC_CHECK_LIB(cposix, strerror, [LIBS="$LIBS -lcposix"])
  ]
)

dnl *****************************************************************
dnl  C++ Tests for Autoconf
dnl  (c) 1997,1998,1999,2000,2001,2002,2003 by Kriang Lerdsuwanakij
dnl  lerdsuwa@users.sourceforge.net
dnl
dnl  This program is free software; you can redistribute it and/or modify
dnl  it under the terms of the GNU General Public License as published by
dnl  the Free Software Foundation; either version 2 of the License, or
dnl  (at your option) any later version.
dnl
dnl  This program is distributed in the hope that it will be useful,
dnl  but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl  GNU General Public License for more details.
dnl
dnl  As a special exception, the file `configure' generated by
dnl  `autoconf' from this file is not covered by the GNU General Public 
dnl  License.  This exception does not however invalidate any other
dnl  reasons why the generated file might be covered by the GNU General 
dnl  Public License.
dnl
dnl  You should have received a copy of the GNU General Public License
dnl  along with this program; if not, write to the Free Software
dnl  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
dnl

dnl *****************************************************************
dnl  History before ChangeLog records:
dnl  Version 0.11.1 (Sep 15, 2001)
dnl		- Fix AH_VERBATIM usage.
dnl		- Fix CXXAC_BAD_NEW test.
dnl		- Use size_t instead of unsigned.
dnl
dnl  Version 0.11.0 (Sep 11, 2001)
dnl		- Add CXXAC_BAD_NEW, CXXAC_HEADER_MACRO
dnl		- Update to autoconf 2.53
dnl
dnl  Version 0.10.5 (Jul 6, 2001)
dnl		- Update comments with the release of gcc 2.95, 3.0
dnl
dnl  Version 0.10.4 (Dec 13, 1999)
dnl		- Add CXXAC_SIZE_BOOL
dnl
dnl  Version 0.10.3 (Feb 17, 1999)
dnl		- Change CXXAC_GUIDE_DECL and its variables
dnl		  and macros to CXXAC_NO_GUIDE_DECL
dnl
dnl  Version 0.10.2 (Jan 6, 1999)
dnl		- Change for loop to do while loop in
dnl		  CXXAC_NEW_THROW_BAD_ALLOC test
dnl
dnl  Version 0.10.1 (May 27, 1998)
dnl		- Fix error in namespace test
dnl		- Check iostream library before displaying test 
dnl		  message in using namespace std test.
dnl		- Remove extra '$' in using namespace std test
dnl
dnl  Version 0.10.0 (Mar 5, 1998)
dnl		- Add CXXAC_BAD_ALLOC, CXXAC_NEW_THROW_BAD_ALLOC
dnl
dnl  Version 0.9.0 (Mar 3, 1998)
dnl		- Add CXXAC_HAVE_TYPENAME
dnl		- Add CXXAC_GUIDE_DECL
dnl		- Rename macros _CXX_* to CXX__*.
dnl		- Rename CXXAC_HAVE_MEMBER_TEMPLATE to
dnl		  CXXAC_HAVE_MEMBER_FUNCTION_TEMPLATE
dnl  Version 0.8.0 (Mar 1, 1998)
dnl		- Append space to cxxac_cv_header_need_ext and
dnl		  cxxac_cv_header_missing output from CXX_HEADER_ALL
dnl		- Move AC_REQUIRE inside CXXAC_LIB_NEED_USING_STD to 
dnl		  avoid corrupted screen output when namespace was not
dnl		  testes
dnl		- Set cxxac_cv_have_header_string inside 
dnl		  CXXAC_LIB_NEED_USING_STD
dnl		- Add CXXAC_STRING_ERASE, CXXAC_TEST_ALL updated
dnl
dnl  Version 0.7.0 (Oct 10, 1997)
dnl		- Add CXXAC_DEFAULT_EXCEPTION
dnl
dnl  Version 0.6.1 (Sep 2, 1997)
dnl		- Fix access problem in member template test
dnl		- Add member template and namespace in 
dnl		  CXXAC_TEST_ALL
dnl
dnl  Version 0.6.0 (Aug 14, 1997)
dnl		- Add CXXAC_HEADER
dnl		- Modify CXXAC_HEADER_ALL to use CXXAC_HEADER
dnl		- Add CXXAC_HAVE_NAMESPACE
dnl		- Add CXXAC_LIB_NEED_USING_STD
dnl		- Fix bug in CXXAC_BAD_DELETE - return value now
dnl		  removed
dnl
dnl  Version 0.5.0 (Aug 8, 1997)
dnl		- First version
dnl
dnl  To do:
dnl		- RTTI (#include<typeinfo>, -frtti, etc.)
dnl		- More exception handling
dnl		- new when there is not enough memory
dnl		- new (nothrow)
dnl		- auto_ptr in #include <memory>
dnl

dnl *****************************************************************
dnl CXXAC_TYPE_WCHAR_T	Test if `wchar_t' is a C++ built-in type.  
dnl			If it fails (cxxac_cv_have_wchar_t = no), 
dnl			you can use CXXAC_DEFINE_WCHAR_T to determine if
dnl			they can be safely defined.
dnl
dnl	Results:	cxxac_cv_have_wchar_t = yes/no
dnl			CXX__HAVE_WCHAR_T defined in header file
dnl				if cxxac_cv_have_wchar_t = yes
dnl
AC_DEFUN([CXXAC_TYPE_WCHAR_T], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])
  AC_MSG_CHECKING([for C++ wchar_t keyword])
  AH_TEMPLATE([CXX__HAVE_WCHAR_T],
	      [Define if C++ wchar_t is found.])

  AC_CACHE_VAL(cxxac_cv_have_wchar_t, [
    AC_TRY_COMPILE([], [wchar_t a = L'a';], [
      cxxac_cv_have_wchar_t=yes
    ], [
      cxxac_cv_have_wchar_t=no
    ])
  ])

  if test $cxxac_cv_have_wchar_t = yes; then
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT(no)
  fi

  if test $cxxac_cv_have_wchar_t = yes; then
    AC_DEFINE(CXX__HAVE_WCHAR_T)
  fi
  AC_LANG_POP([C++])
])

dnl *****************************************************************
dnl CXXAC_TYPE_BOOL	Test if `bool' is a C++ built-in type.  It is
dnl			supported by gcc 2.6.x or newer.
dnl			If it fails (cxxac_cv_have_bool = no), 
dnl			you can use CXXAC_DEFINE_BOOL to determine if
dnl			they can be safely defined.
dnl
dnl	Results:	cxxac_cv_have_bool = yes/no
dnl			CXX__HAVE_BOOL defined in header file
dnl				if cxxac_cv_have_bool = yes
dnl			cxxac_cv_bool_size = sizeof(bool)
dnl				if cxxac_cv_have_bool = yes
dnl
AC_DEFUN([CXXAC_TYPE_BOOL], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])
  AC_MSG_CHECKING([for C++ bool keyword])
  AH_TEMPLATE([CXX__HAVE_BOOL],
	      [Define if C++ bool is found.])

  AC_CACHE_VAL(cxxac_cv_have_bool, [
    AC_TRY_COMPILE([], [

bool ba = true, bb = false;
bool bc = bb;
int  ia = 1, ib = 2;
int  ic = (int)ba;
bool bd = (ia == ib);
if (bd) { ia = 0; }
if (!bd) { ia = 0; }
if (ba && bb) { ia = 0; }
if (ba || bb) { ia = 0; }

    ], [
      cxxac_cv_have_bool=yes
    ], [
      cxxac_cv_have_bool=no
    ])
  ])

  if test $cxxac_cv_have_bool = yes; then
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT(no)
  fi

  if test $cxxac_cv_have_bool = yes; then
    AC_DEFINE(CXX__HAVE_BOOL)
  fi
  AC_LANG_POP([C++])
])

dnl *****************************************************************
dnl CXXAC_SIZE_BOOL	Test the size of `bool'.
dnl
dnl	Results:	cxxac_cv_bool_size = sizeof(bool)
dnl
AC_DEFUN([CXXAC_SIZE_BOOL], [
  AC_REQUIRE([CXXAC_TYPE_BOOL])
  AC_LANG_PUSH([C++])
  AC_MSG_CHECKING([for size of C++ bool])

  if test $cxxac_cv_have_bool = yes; then
    AC_CACHE_VAL(cxxac_cv_bool_size, [
      AC_TRY_RUN([
	#include <stdio.h>
	int main()
	{
	  FILE *f = fopen("cf_cxxac.out", "w");
	  if (f) {
	    fprintf(f, "%d", sizeof(bool));
	    fclose(f);
	    exit(0); 
	  }
	  else
	    exit(1); 
	}
      ], [
	cxxac_cv_bool_size=`cat cf_cxxac.out`
      ], [
	cxxac_cv_bool_size="N/A (error during test)"
      ], [
	cxxac_cv_bool_size="N/A (due to cross-compilation)"
      ])

      rm -f cf_cxxac.out
    ])
  else
    cxxac_cv_bool_size="N/A"
  fi

  AC_MSG_RESULT($cxxac_cv_bool_size)
  AC_LANG_POP([C++])
])

dnl *****************************************************************
dnl CXXAC_DEFINE_BOOL	Test if `bool', `true' and `false' can be
dnl			defined.  Use this macro if you want to use
dnl			`bool' variable type even the compiler don't
dnl			support it.
dnl			If it fails (cxxac_cv_can_define_bool = no)
dnl			there must be symbol conflict somewhere.
dnl
dnl	Results:	cxxac_cv_can_define_bool = yes/no
dnl			CXX__CAN_DEFINE_BOOL defined in header file
dnl				if cxxac_cv_can_define_bool = yes
dnl
AC_DEFUN([CXXAC_DEFINE_BOOL], [
  AC_REQUIRE([CXXAC_TYPE_BOOL])
  AC_LANG_PUSH([C++])
  AH_TEMPLATE([CXX__CAN_DEFINE_BOOL],
	      [Define if bool, true, false can be redefined.])
  AH_VERBATIM([CXX__CAN_DEFINE_BOOL2], [
#ifndef CXX__HAVE_BUILTIN_BOOL
#  ifdef CXX__CAN_DEFINE_BOOL
enum bool { false = 0, true = 1 };
#  endif
#endif
  ])

  if test $cxxac_cv_have_bool = no; then
    AC_MSG_CHECKING([if bool, true and false can be defined])

    AC_CACHE_VAL(cxxac_cv_can_define_bool, [

      AC_TRY_COMPILE([], [int bool = 0,true = 0,false = 1;], [

        AC_TRY_COMPILE([
enum bool { false = 0, true = 1 };
        ], [
bool a = true, b = false;
        ], [
          cxxac_cv_can_define_bool=yes
        ], [
          cxxac_cv_can_define_bool=no
        ])

      ], [
        cxxac_cv_can_define_bool=no
      ])
    ])

    if test $cxxac_cv_can_define_bool = yes; then
      AC_MSG_RESULT(yes)
    else
      AC_MSG_RESULT(no)
    fi

    if test $cxxac_cv_can_define_bool; then
      AC_DEFINE(CXX__CAN_DEFINE_BOOL)
    fi
  fi
  AC_LANG_POP([C++])
])

dnl *****************************************************************
dnl CXXAC_HAVE_EXPLICIT	Test if `explicit' is available.  It is 
dnl			supported by gcc 2.7.x or newer.
dnl			If not supported, workaround is automatically
dnl			provided in your header file after running
dnl			Autoheader.
dnl
dnl	Results:	cxxac_cv_have_explicit = yes/no
dnl			CXX__HAVE_EXPLICIT defined in header file
dnl				if cxxac_cv_have_explicit = yes
dnl
AC_DEFUN([CXXAC_HAVE_EXPLICIT], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])
  AC_MSG_CHECKING([for C++ explicit keyword])
  AH_TEMPLATE([CXX__HAVE_EXPLICIT],
	      [Define if explicit is available.])
  AH_VERBATIM([CXX__HAVE_EXPLICIT2], [
#ifndef CXX__HAVE_EXPLICIT
#  define explicit		/* Discard `explicit' */
#  define CXX__NO_EXPLICIT	1
#endif
  ])

  AC_CACHE_VAL(cxxac_cv_have_explicit, [
    AC_TRY_COMPILE([

class obj_a {
	private:
		int	b;
	public:
		explicit obj_a(int _b) { b = _b; }
};

    ], [

				// Nothing in function body

    ], [
      AC_TRY_COMPILE([

class obj_a {
	private:
		int	b;
	public:
		explicit obj_a(int _b) { b = _b; }
		void	func(obj_a _a) { b = _a.b; }
};

      ], [

	int	i = 0;
	obj_a	a(1);
	a.func(i);		// Must error here, attempt to convert
				// from type int to class obj_a

      ], [
        cxxac_cv_have_explicit=no
      ], [
        cxxac_cv_have_explicit=yes
      ])
    ], [
      cxxac_cv_have_explicit=no
    ])
  ])

  if test $cxxac_cv_have_explicit = yes; then
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT(no)
  fi

  if test $cxxac_cv_have_explicit = yes; then
    AC_DEFINE(CXX__HAVE_EXPLICIT)
  fi
  AC_LANG_POP([C++])
])

dnl *****************************************************************
dnl CXXAC_HAVE_MUTABLE	Test if `mutable' is available.  It is 
dnl			supported by gcc 2.5.x or newer.
dnl			If not supported, some workaround is 
dnl			provided in your header file after running
dnl			Autoheader.  But you also have to modify your
dnl			source files to cast away const-ness of 
dnl			pointers used to modify the member data.
dnl
dnl	Results:	cxxac_cv_have_mutable = yes/no
dnl			CXX__HAVE_MUTABLE defined in header file
dnl				if cxxac_cv_have_mutable = yes
dnl			CXX__NO_MUTABLE defined in header file
dnl				if cxxac_cv_have_mutable = no
dnl
AC_DEFUN([CXXAC_HAVE_MUTABLE], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])
  AC_MSG_CHECKING([for C++ mutable keyword])
  AH_TEMPLATE([CXX__HAVE_MUTABLE], [Define if mutable is available.])
  AH_VERBATIM([CXX__HAVE_MUTABLE2], [
#ifndef CXX__HAVE_MUTABLE
#  define mutable		/* Discard `mutable' */
				/* Change const T * => T * const */
#  define _CXXAC_THIS(T)	T * const cppacThis = (T * const) this;
#  define _CXXAC_THAT(T, P)	T * const cppacThat = (T * const) (P);
#endif
  ])

  AC_CACHE_VAL(cxxac_cv_have_mutable, [
    AC_TRY_COMPILE([

class obj_a {
	private:
		mutable int	b;	// Must OK here
	public:
		obj_a() : b(0) {}
					// Must OK here
		void setb(int _b) const { b = _b; }
};

    ], [

	obj_a	a;
	a.setb(1);		// Must OK here

    ], [
      cxxac_cv_have_mutable=yes
    ], [
      cxxac_cv_have_mutable=no
    ])
  ])

  if test $cxxac_cv_have_mutable = yes; then
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT(no)
  fi

  if test $cxxac_cv_have_mutable = yes; then
    AC_DEFINE(CXX__HAVE_MUTABLE)
  fi
  AC_LANG_POP([C++])
])

dnl *****************************************************************
dnl CXXAC_HAVE_MEMBER_FUNCTION_TEMPLATE
dnl			Test if member function template is available.
dnl			It is supported by gcc 2.8.0 or newer.
dnl
dnl			There is no workaround for this problem.
dnl			Your configure script should report error and
dnl			terminate immediately
dnl
dnl	Results:	cxxac_cv_have_member_template = yes/no
dnl
AC_DEFUN([CXXAC_HAVE_MEMBER_FUNCTION_TEMPLATE], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])
  AC_MSG_CHECKING([for C++ member template])

  AC_CACHE_VAL(cxxac_cv_have_member_template, [
    AC_TRY_COMPILE([

template <class T> class obj_a {
	public:
		T	*b;

		obj_a(T *_b = 0) : b(_b) {}

						// Must OK here
		template <class S> void copy(obj_a<S>& _a)
						{ b = (T *)(_a.b); }
};

class obj_b {
	private:
		int	c;
	public:
		obj_b() : c(0) {}
};

    ], [

	int		a;
	obj_b		b;
	
	obj_a<int>	ptr_a(&a);
	obj_a<obj_b>	ptr_b(&b);	
	ptr_b.copy(ptr_a);			// Must OK here

    ], [
      cxxac_cv_have_member_template=yes
    ], [
      cxxac_cv_have_member_template=no
    ])
  ])

  if test $cxxac_cv_have_member_template = yes; then
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT(no)
  fi

  AC_LANG_POP([C++])
])

dnl *****************************************************************
dnl CXXAC_BAD_FOR	Test if variables declared inside for statement 
dnl			persist after for loop.  The correct behavior is 
dnl			that they do not and is supported by gcc 2.7.x 
dnl			or newer.
dnl
dnl			There is no workaround provided.  If you still
dnl			need the old behavior, use CXXAC_WANT_BAD_FOR
dnl			instead.
dnl
dnl	Results:	cxxac_cv_bad_for = yes/no
dnl
AC_DEFUN([CXXAC_BAD_FOR], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])
  AC_MSG_CHECKING([for scope of variable declared inside for statement])

  AC_CACHE_VAL(cxxac_cv_bad_for, [
    AC_TRY_COMPILE([], [

	for (int i = 0; i < 10; i++)
		;

	for (int i = 0; i < 10; i++)		// Must OK here
		;

    ], [
      cxxac_cv_bad_for=no
    ], [
      cxxac_cv_bad_for=yes
    ])
  ])

  if test $cxxac_cv_bad_for = yes; then
    AC_MSG_RESULT(wrong)
  else
    AC_MSG_RESULT(correct)
  fi

  AC_LANG_POP([C++])
])

dnl *****************************************************************
dnl CXXAC_WANT_BAD_FOR	Same as CXXAC_BAD_FOR but also add 
dnl			`-fno-for-scope' if the compiler support it
dnl			(works only with gcc).
dnl
dnl	Results:	cxxac_cv_bad_for = yes/no
dnl			cxxac_cv_bad_for_corrected = yes/no
dnl				if cxxac_cv_bad_for = yes
dnl
AC_DEFUN([CXXAC_WANT_BAD_FOR], [
  AC_REQUIRE([CXXAC_WANT_BAD_FOR])
  AC_LANG_PUSH([C++])
  if test $cxxac_cv_bad_for = yes; then

    AC_MSG_CHECKING([if old for variable scope can be obtained])
    cxxac_save_CXXFLAGS="$CXXFLAGS"

    AC_CACHE_VAL(cxxac_cv_bad_for_corrected, [
      CXXFLAGS="$CXXFLAGS -fno-for-scope"

      if test $GXX = yes; then
        AC_TRY_COMPILE([], [

	for (int i = 0; i < 10; i++)
		;

	for (int i = 0; i < 10; i++)		// Must error here
		;

        ], [
          cxxac_cv_bad_for_corrected=no
        ], [
          cxxac_cv_bad_for_corrected=yes
        ])
      else
        cxxac_cv_bad_for_corrected=no
      fi

    ])

    if test $cxxac_cv_bad_for_corrected = yes; then
      AC_MSG_RESULT(yes)
dnl						Keep -fno-for-scope
    else
      AC_MSG_RESULT(no)
dnl						Don't keep -fno-for-scope
      CXXFLAGS="$cxxac_save_CXXFLAGS"
    fi

  fi
  AC_LANG_POP([C++])
])

dnl *****************************************************************
dnl CXXAC_HAVE_ARRAY_NEW
dnl			Test if operator new[](size_t) is supported.  
dnl			If not supported, you don't have to replace
dnl			the array version of new.
dnl
dnl	Results:	cxxac_cv_have_array_new = yes/no
dnl			CXX__HAVE_ARRAY_NEW defined in header file
dnl				if cxxac_cv_have_array_new = yes
dnl
AC_DEFUN([CXXAC_HAVE_ARRAY_NEW], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])

  AC_MSG_CHECKING([for C++ array new replacement])
  AH_TEMPLATE([CXX__HAVE_ARRAY_NEW], [
changequote(<<, >>)dnl
	      Define if void *operator new[](size_t) is supported.
changequote([, ])dnl
  ])

  AC_CACHE_VAL(cxxac_cv_have_array_new, [
    AC_TRY_COMPILE(
#include <stddef.h>
changequote(<<, >>)dnl
    <<

void *operator new[](size_t /*n*/) throw()	// Must OK here
{
	return 0;
}

    >>,
changequote([, ])dnl
    [
				// Nothing in function body
    ], [
      cxxac_cv_have_array_new=yes
    ], [
      cxxac_cv_have_array_new=no
    ])
  ])

  if test $cxxac_cv_have_array_new = yes; then
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT(no)
  fi

  if test $cxxac_cv_have_array_new = yes; then
    AC_DEFINE(CXX__HAVE_ARRAY_NEW)
  fi
  AC_LANG_POP([C++])
])

dnl *****************************************************************
dnl CXXAC_HAVE_PLACEMENT_NEW
dnl			Test if operator new(size_t,void *) is supported.  
dnl			If not supported, you don't have to replace
dnl			the placement version of new.
dnl
dnl	Results:	cxxac_cv_have_placement_new = yes/no
dnl			CXX__HAVE_PLACEMENT_NEW defined in header file
dnl				if cxxac_cv_have_place_new = yes
dnl
AC_DEFUN([CXXAC_HAVE_PLACEMENT_NEW], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])
  AC_MSG_CHECKING([for C++ new(size_t,void *) replacement])
  AH_TEMPLATE([CXX__HAVE_PLACEMENT_NEW], [
changequote(<<, >>)dnl
	      Define if void *operator new[](size_t, void *) is supported.
changequote([, ])dnl
  ])

  AC_CACHE_VAL(cxxac_cv_have_placement_new, [
    AC_TRY_COMPILE([
#include <stddef.h>

void *operator new(size_t /*n*/,void *p)	// Must OK here
{
	return p;
}

    ], [
				// Nothing in function body
    ], [
      cxxac_cv_have_placement_new=yes
    ], [
      cxxac_cv_have_placement_new=no
    ])
  ])

  if test $cxxac_cv_have_placement_new = yes; then
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT(no)
  fi

  if test $cxxac_cv_have_placement_new = yes; then
    AC_DEFINE(CXX__HAVE_PLACEMENT_NEW)
  fi
  AC_LANG_POP([C++])
])

dnl *****************************************************************
dnl CXXAC_BAD_NEW	Test if operator new and new[] does not 
dnl			support `throw(std::bad_alloc)' exception
dnl			specification.  
dnl			If not supported, no throw(...) is needed.
dnl
dnl	Results:	cxxac_cv_bad_new = yes/no
dnl			CXX__NEW_NO_THROW defined in header file
dnl				if cxxac_cv_bad_new = yes
dnl
AC_DEFUN([CXXAC_BAD_NEW], [
  AC_REQUIRE([CXXAC_BAD_ALLOC])
  AC_REQUIRE([CXXAC_LIB_NEED_USING_STD])

  dnl avoid broken message
  CXXAC_HEADER(iostream)

  AC_LANG_PUSH([C++])
  AC_MSG_CHECKING([for C++ exception specification for new])
  AH_TEMPLATE([CXX__NEW_NO_THROW],
	      [Define if new cannot accept exception specification.])
  AH_VERBATIM([CXX__NEW_THROW_BAD_ALLOC2], [
#if !defined(CXX__NEW_NO_THROW) && defined(CXX__BAD_ALLOC) \
    && defined(CXX__NEW_THROW_BAD_ALLOC)
#  define CXX__NEW_THROW	throw(BAD_ALLOC)
#else
#  define CXX__NEW_THROW
#endif
  ])

  AC_CACHE_VAL(cxxac_cv_bad_new, [
    AC_TRY_COMPILE([
#include CXX__HEADER_new
$cxxac_using_namespace_std

void *operator new(size_t /*s*/) throw(bad_alloc) // Must OK here
{
  return 0;
}

    ], [
				// Nothing in function body
    ], [
      cxxac_cv_bad_new=no
    ], [
      cxxac_cv_bad_new=yes
    ])
  ])

dnl Message printed is the reverse of $cxxac_cv_bad_new
  if test $cxxac_cv_bad_new = yes; then
    AC_MSG_RESULT(no)
  else
    AC_MSG_RESULT(yes)
  fi

  if test $cxxac_cv_bad_new = yes; then
    AC_DEFINE(CXX__NEW_NO_THROW)
  fi
  AC_LANG_POP([C++])
])

dnl *****************************************************************
dnl CXXAC_BAD_DELETE	Test if operator delete and delete[] does not 
dnl			support `throw()' exception specification.  
dnl			throw() is required by gcc 2.8.x or newer.
dnl			If not supported, no throw() is needed.
dnl
dnl	Results:	cxxac_cv_bad_delete = yes/no
dnl			CXX__DELETE_NO_THROW defined in header file
dnl				if cxxac_cv_bad_delete = yes
dnl
AC_DEFUN([CXXAC_BAD_DELETE], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])
  AC_MSG_CHECKING([for C++ exception specification for delete])
  AH_TEMPLATE([CXX__DELETE_NO_THROW],
	      [Define if delete cannot accept exception specification.])
  AH_VERBATIM([CXX__DELETE_NO_THROW2], [
#ifndef CXX__DELETE_NO_THROW
#  define CXX__DELETE_THROW	throw()
#else
#  define CXX__DELETE_THROW
#endif
  ])

  AC_CACHE_VAL(cxxac_cv_bad_delete, [
    AC_TRY_COMPILE([
void operator delete(void * /*p*/) throw()	// Must OK here
{
}

    ], [

				// Nothing in function body

    ], [
      cxxac_cv_bad_delete=no
    ], [
      cxxac_cv_bad_delete=yes
    ])
  ])

dnl Message printed is the reverse of $cxxac_cv_bad_delete
  if test $cxxac_cv_bad_delete = yes; then
    AC_MSG_RESULT(no)
  else
    AC_MSG_RESULT(yes)
  fi

  if test $cxxac_cv_bad_delete = yes; then
    AC_DEFINE(CXX__DELETE_NO_THROW)
  fi
  AC_LANG_POP([C++])
])

dnl *****************************************************************
dnl CXXAC_HAVE_NAMESPACE
dnl			Test if namespace is supported.  It is
dnl			supported by gcc 2.95.x or newer
dnl			and egcs 1.1.
dnl
dnl	Results:	cxxac_cv_have_namespace = yes/no
dnl			CXX__HAVE_NAMESPACE defined in header file
dnl				if cxxac_cv_have_namespace = yes
dnl
AC_DEFUN([CXXAC_HAVE_NAMESPACE], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])
  AC_MSG_CHECKING([for C++ namespace])
  AH_TEMPLATE([CXX__HAVE_NAMESPACE], [Define if namespace is available.])

  AC_CACHE_VAL(cxxac_cv_have_namespace, [
    AC_TRY_COMPILE([

namespace N1 { int a; }		// original-namespace-definition
namespace N1 { int b; }		// extension-namespace-definition
namespace { int c; }		// unnamed-namespace-definition
namespace N2 = N1;		// namespace-alias-definition

namespace N3 { int d; }
namespace N4 { typedef int e; typedef long f; }
namespace N5 { namespace N6 { int g; } }

int	ia = N1::a;		// qualified-namespace-specifier
int	ib = ::N1::a;		// qualified-namespace-specifier w/ ::(opt)
int	ic = N5::N6::g;		// qualified-namespace-specifier w/
				//  nested-name-specifier(opt)

using namespace N3;		// using-directive
using N4::e;			// using-declaration
using ::N4::f;			// using-declaration w/ ::(opt)

e	ea;
f	fa;

    ], [

				// Nothing in function body

    ], [
      cxxac_cv_have_namespace=yes
    ], [
      cxxac_cv_have_namespace=no
    ])
  ])

  if test $cxxac_cv_have_namespace = yes; then
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT(no)
  fi

  if test $cxxac_cv_have_namespace = yes; then
    AC_DEFINE(CXX__HAVE_NAMESPACE)
  fi
  AC_LANG_POP([C++])
])

dnl *****************************************************************
dnl CXXAC_DEFAULT_EXCEPTION
dnl			Test if exception handling is on by default.
dnl			It is supported by gcc 2.8.0 or newer.
dnl
dnl	Results:	cxxac_cv_default_exception = yes/no
dnl			CXX__DEFAULT_EXCEPTION defined in header file
dnl				if cxxac_cv_default_exception = yes
dnl
AC_DEFUN([CXXAC_DEFAULT_EXCEPTION], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])
  AC_MSG_CHECKING([if exception handling is on by default])
  AH_TEMPLATE([CXX__DEFAULT_EXCEPTION],
	      [Define if exception handling is on by default.])

  AC_CACHE_VAL(cxxac_cv_default_exception, [

    AC_TRY_COMPILE([
    ], [

try {
	throw 1;
}
catch (...) {
	throw;
}

    ], [
      cxxac_cv_default_exception=yes
    ], [
      cxxac_cv_default_exception=no
    ])
  ])

  AC_MSG_RESULT($cxxac_cv_default_exception)
  if test $cxxac_cv_default_exception = yes; then
    AC_DEFINE(CXX__DEFAULT_EXCEPTION)
  fi

  AC_LANG_POP([C++])
])

dnl *****************************************************************
dnl CXXAC_HAVE_TYPENAME
dnl			Test if the typename keyword works.
dnl			It is supported by gcc 2.8.0 or newer.
dnl
dnl	Results:	cxxac_cv_have_typename = yes/no
dnl			CXX__HAVE_TYPENAME defined in header file
dnl				if cxxac_cv_have_typename = yes
dnl
AC_DEFUN([CXXAC_HAVE_TYPENAME], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])
  AC_MSG_CHECKING([for C++ typename keyword])
  AH_TEMPLATE([CXX__HAVE_TYPENAME],
	      [Define if typename is available.])
  AH_VERBATIM([CXX__HAVE_TYPENAME2], [
#ifdef CXX__HAVE_TYPENAME
#  define TYPENAME typename
#else
#  define TYPENAME
#endif
  ])

  AC_CACHE_VAL(cxxac_cv_have_typename, [

    AC_TRY_COMPILE([

class A {
	public:
		typedef int type;
		int value;
};

template <class T> class C {
	public:
		int f () {
			typename T::type p;
			return sizeof p;
		}
};

    ], [

C<A> c;
c.f();

    ], [
      cxxac_cv_have_typename=yes
    ], [
      cxxac_cv_have_typename=no
    ])
  ])

  AC_MSG_RESULT($cxxac_cv_have_typename)
  if test $cxxac_cv_have_typename = yes; then
    AC_DEFINE(CXX__HAVE_TYPENAME)
  fi

  AC_LANG_POP([C++])
])


dnl *****************************************************************
dnl CXXAC_NO_GUIDE_DECL
dnl			Test if ordinary function declaration will not
dnl			guide the compiler to instantiate the template
dnl			version of the function.
dnl			It is supported by gcc 2.8.0 or newer.
dnl
dnl	Results:	cxxac_cv_no_guide_decl = yes/no
dnl			CXX__NO_GUIDE_DECL defined in header file
dnl				if cxxac_cv_no_guide_decl = yes
dnl
AC_DEFUN([CXXAC_NO_GUIDE_DECL], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])
  AC_MSG_CHECKING([if C++ guided declaration for template function disabled])
  AH_TEMPLATE([CXX__NO_GUIDE_DECL],
	      [Define if guided declaration is used.])
  AH_VERBATIM([CXX__NO_GUIDE_DECL2], [
#ifndef CXX__NO_GUIDE_DECL
#  define LEFTRIGHT
#else
#  define LEFTRIGHT <>
#endif
  ])

  AC_CACHE_VAL(cxxac_cv_no_guide_decl, [

    AC_TRY_COMPILE([

template <class T> int f(T &t);

template <class T> class C {
		int value;
	public:
		friend int f<>(T &);
};

    ], [

    ], [
      cxxac_cv_no_guide_decl=yes
    ], [
      cxxac_cv_no_guide_decl=no
    ])
  ])

  AC_MSG_RESULT($cxxac_cv_no_guide_decl)
  if test $cxxac_cv_no_guide_decl = yes; then
    AC_DEFINE(CXX__NO_GUIDE_DECL)
  fi

  AC_LANG_POP([C++])
])



dnl *****************************************************************
dnl CXXAC_LIB_NEED_USING_STD
dnl			Test if library supports using namespace std.  
dnl			It is supported by libg++ 2.7.x or newer.
dnl
dnl	Results:	cxxac_cv_lib_need_using_std = yes/no
dnl			CXX__LIB_NEED_USING_STD defined in header file
dnl				if cxxac_cv_lib_need_using_std = yes
dnl			cxxac_using_namespace_std = "" or 
dnl				"using namespace std;"
dnl
dnl	[lib.contents]
dnl
AC_DEFUN([CXXAC_LIB_NEED_USING_STD], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])

  AC_REQUIRE([CXXAC_HAVE_NAMESPACE])

  dnl avoid broken message
  CXXAC_HEADER(iostream)

  AC_MSG_CHECKING([if using namespace std supported by C++ library])
  AH_TEMPLATE([CXX__LIB_NEED_USING_STD],
	      [Define if using namespace std; is required by the library.])
  AH_VERBATIM([CXX__LIB_NEED_USING_STD2], [
#ifdef CXX__LIB_NEED_USING_STD
# define USING_NAMESPACE_STD using namespace std
#else
# define USING_NAMESPACE_STD
#endif
  ])

  AC_CACHE_VAL(cxxac_cv_lib_need_using_std, [
    if test $cxxac_cv_have_namespace = yes; then

      AC_TRY_COMPILE([

#include CXX__HEADER_iostream
using namespace std;

      ], [

cout << '\n';

      ], [
        cxxac_cv_lib_need_using_std=yes
      ], [
        cxxac_cv_lib_need_using_std=no
      ])

    else
      cxxac_cv_lib_need_using_std=no
    fi
  ])

  AC_MSG_RESULT($cxxac_cv_lib_need_using_std)
  if test $cxxac_cv_lib_need_using_std = yes; then
    AC_DEFINE(CXX__LIB_NEED_USING_STD)
    cxxac_using_namespace_std="using namespace std;"
  else
    AC_DEFINE(USING_NAMESPACE_STD)
    cxxac_using_namespace_std=""
  fi

  AC_LANG_POP([C++])
])


dnl *****************************************************************
dnl CXXAC_HEADER_MACRO	Set macros inside config.h.in.
dnl
AC_DEFUN([CXXAC_HEADER_MACRO], [
  AH_TEMPLATE([CXX__HAVE_HEADER_algorithm], [Define if header algorithm is available.])
  AH_TEMPLATE([CXX__HEADER_algorithm], [Define if header algorithm is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_bitset], [Define if header bitset is available.])
  AH_TEMPLATE([CXX__HEADER_bitset], [Define if header bitset is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_complex], [Define if header complex is available.])
  AH_TEMPLATE([CXX__HEADER_complex], [Define if header complex is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_deque], [Define if header deque is available.])
  AH_TEMPLATE([CXX__HEADER_deque], [Define if header deque is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_exception], [Define if header exception is available.])
  AH_TEMPLATE([CXX__HEADER_exception], [Define if header exception is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_fstream], [Define if header fstream is available.])
  AH_TEMPLATE([CXX__HEADER_fstream], [Define if header fstream is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_functional], [Define if header functional is available.])
  AH_TEMPLATE([CXX__HEADER_functional], [Define if header functional is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_iomanip], [Define if header iomanip is available.])
  AH_TEMPLATE([CXX__HEADER_iomanip], [Define if header iomanip is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_ios], [Define if header ios is available.])
  AH_TEMPLATE([CXX__HEADER_ios], [Define if header ios is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_iofwd], [Define if header iofwd is available.])
  AH_TEMPLATE([CXX__HEADER_iofwd], [Define if header iofwd is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_iostream], [Define if header iostream is available.])
  AH_TEMPLATE([CXX__HEADER_iostream], [Define if header iostream is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_istream], [Define if header istream is available.])
  AH_TEMPLATE([CXX__HEADER_istream], [Define if header istream is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_iterator], [Define if header iterator is available.])
  AH_TEMPLATE([CXX__HEADER_iterator], [Define if header iterator is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_limits], [Define if header limits is available.])
  AH_TEMPLATE([CXX__HEADER_limits], [Define if header limits is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_list], [Define if header list is available.])
  AH_TEMPLATE([CXX__HEADER_list], [Define if header list is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_locale], [Define if header locale is available.])
  AH_TEMPLATE([CXX__HEADER_locale], [Define if header locale is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_map], [Define if header map is available.])
  AH_TEMPLATE([CXX__HEADER_map], [Define if header map is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_memory], [Define if header memory is available.])
  AH_TEMPLATE([CXX__HEADER_memory], [Define if header memory is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_new], [Define if header new is available.])
  AH_TEMPLATE([CXX__HEADER_new], [Define if header new is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_numeric], [Define if header numeric is available.])
  AH_TEMPLATE([CXX__HEADER_numeric], [Define if header numeric is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_ostream], [Define if header ostream is available.])
  AH_TEMPLATE([CXX__HEADER_ostream], [Define if header ostream is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_queue], [Define if header queue is available.])
  AH_TEMPLATE([CXX__HEADER_queue], [Define if header queue is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_set], [Define if header set is available.])
  AH_TEMPLATE([CXX__HEADER_set], [Define if header set is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_sstream], [Define if header sstream is available.])
  AH_TEMPLATE([CXX__HEADER_sstream], [Define if header sstream is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_stack], [Define if header stack is available.])
  AH_TEMPLATE([CXX__HEADER_stack], [Define if header stack is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_stdexcept], [Define if header stdexcept is available.])
  AH_TEMPLATE([CXX__HEADER_stdexcept], [Define if header stdexcept is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_streambuf], [Define if header streambuf is available.])
  AH_TEMPLATE([CXX__HEADER_streambuf], [Define if header streambuf is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_string], [Define if header string is available.])
  AH_TEMPLATE([CXX__HEADER_string], [Define if header string is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_typeinfo], [Define if header typeinfo is available.])
  AH_TEMPLATE([CXX__HEADER_typeinfo], [Define if header typeinfo is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_utility], [Define if header utility is available.])
  AH_TEMPLATE([CXX__HEADER_utility], [Define if header utility is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_valarray], [Define if header valarray is available.])
  AH_TEMPLATE([CXX__HEADER_valarray], [Define if header valarray is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_vector], [Define if header vector is available.])
  AH_TEMPLATE([CXX__HEADER_vector], [Define if header vector is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_cassert], [Define if header cassert is available.])
  AH_TEMPLATE([CXX__HEADER_cassert], [Define if header cassert is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_cctype], [Define if header cctype is available.])
  AH_TEMPLATE([CXX__HEADER_cctype], [Define if header cctype is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_cerrno], [Define if header cerrno is available.])
  AH_TEMPLATE([CXX__HEADER_cerrno], [Define if header cerrno is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_cfloat], [Define if header cfloat is available.])
  AH_TEMPLATE([CXX__HEADER_cfloat], [Define if header cfloat is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_ciso646], [Define if header ciso646 is available.])
  AH_TEMPLATE([CXX__HEADER_ciso646], [Define if header ciso646 is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_climits], [Define if header climits is available.])
  AH_TEMPLATE([CXX__HEADER_climits], [Define if header climits is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_clocale], [Define if header clocale is available.])
  AH_TEMPLATE([CXX__HEADER_clocale], [Define if header clocale is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_cmath], [Define if header cmath is available.])
  AH_TEMPLATE([CXX__HEADER_cmath], [Define if header cmath is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_csetjmp], [Define if header csetjmp is available.])
  AH_TEMPLATE([CXX__HEADER_csetjmp], [Define if header csetjmp is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_csignal], [Define if header csignal is available.])
  AH_TEMPLATE([CXX__HEADER_csignal], [Define if header csignal is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_cstdarg], [Define if header cstdarg is available.])
  AH_TEMPLATE([CXX__HEADER_cstdarg], [Define if header cstdarg is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_cstddef], [Define if header cstddef is available.])
  AH_TEMPLATE([CXX__HEADER_cstddef], [Define if header cstddef is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_cstdio], [Define if header cstdio is available.])
  AH_TEMPLATE([CXX__HEADER_cstdio], [Define if header cstdio is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_cstdlib], [Define if header cstdlib is available.])
  AH_TEMPLATE([CXX__HEADER_cstdlib], [Define if header cstdlib is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_cstring], [Define if header cstring is available.])
  AH_TEMPLATE([CXX__HEADER_cstring], [Define if header cstring is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_ctime], [Define if header ctime is available.])
  AH_TEMPLATE([CXX__HEADER_ctime], [Define if header ctime is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_cwchar], [Define if header cwchar is available.])
  AH_TEMPLATE([CXX__HEADER_cwchar], [Define if header cwchar is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_cwctype], [Define if header cwctype is available.])
  AH_TEMPLATE([CXX__HEADER_cwctype], [Define if header cwctype is available.])
])

dnl *****************************************************************
dnl CXXAC_HEADER	Test if the specified C++ and C library header 
dnl			is available.  
dnl			It is supported by gcc 3.x or newer.
dnl
dnl	Results:	cxxac_cv_have_header_xxx = yes/no/need_h
dnl			If cxxac_cv_have_header_xxx = yes/need_h, then
dnl				CXX__HAVE_HEADER_xxx defined in header file
dnl				                     to be 0 (need .h)
dnl				                     or 1 (OK)
dnl				cxxac_cv_header_xxx = header name found
dnl				CXX__HEADER_xxx defined as header name
dnl
AC_DEFUN([CXXAC_HEADER], [
  if eval "test \"\$cxxac_done_header_$1\" != yes"; then

    AC_REQUIRE([AC_PROG_CXX])
    AC_REQUIRE([CXXAC_HEADER_MACRO])
    AC_LANG_PUSH([C++])

    dnl $2 can be empty
    if test "$2" != quiet; then
      AC_MSG_CHECKING([for C++ library header $1])
    fi

    AC_CACHE_VAL(cxxac_cv_have_header_$1, [
      AC_TRY_CPP([#include <$1>], [
        eval "cxxac_cv_have_header_$1=yes"
      ], [
        AC_TRY_CPP([#include <$1.h>], [
          eval "cxxac_cv_have_header_$1=need_h"
        ], [
          eval "cxxac_cv_have_header_$1=no"
        ])
      ]);
    ])

    eval "cxxac_cv_have_header=\$cxxac_cv_have_header_$1"
    if test $cxxac_cv_have_header = yes; then
      cxxac_result=yes
      eval "cxxac_cv_header_$1=$1"
      AC_DEFINE_UNQUOTED(CXX__HAVE_HEADER_$1,1)
      AC_DEFINE_UNQUOTED(CXX__HEADER_$1,<$1>)
    elif test $cxxac_cv_have_header = need_h; then
      cxxac_result="need .h"
      eval "cxxac_cv_header_$1=$1.h"
      AC_DEFINE_UNQUOTED(CXX__HAVE_HEADER_$1,0)
      AC_DEFINE_UNQUOTED(CXX__HEADER_$1,<$1.h>)
    else
      cxxac_result=no
      eval "cxxac_cv_header_$1="
    fi

    dnl $2 can be empty
    if test "$2" != quiet; then
      AC_MSG_RESULT($cxxac_result)
    fi

    AC_LANG_POP([C++])
    eval "cxxac_done_header_$1=yes"

  fi
])


dnl *****************************************************************
dnl CXXAC_HEADER_ALL	Test if all C++ and C library header is
dnl			available.  
dnl			It is supported by gcc 3.x or newer.
dnl
dnl	Results:	cxxac_cv_have_all_header = yes/no
dnl			CXX__HAVE_ALL_HEADER defined in header file
dnl				if cxxac_cv_have_all_header = yes
dnl			cxxac_cv_header_need_ext = list of files that
dnl						   require `.h' extension
dnl			cxxac_cv_missing = list of files that is
dnl			                   cannot be found even
dnl			                   with `.h' added
dnl
AC_DEFUN([CXXAC_HEADER_ALL], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])
  AC_MSG_NOTICE(checking for all C++ library header)
  AH_TEMPLATE([CXX__HAVE_ALL_HEADER],
	      [Define if all C++ and C library header is available.])

  cxxac_file="algorithm bitset complex deque exception fstream functional"
  cxxac_file="$cxxac_file iomanip ios iosfwd iostream istream iterator limits"
  cxxac_file="$cxxac_file list locale map memory new numeric"
  cxxac_file="$cxxac_file ostream queue set sstream stack stdexcept"
  cxxac_file="$cxxac_file streambuf string typeinfo utility valarray vector"
  cxxac_file="$cxxac_file cassert cctype cerrno cfloat"
  cxxac_file="$cxxac_file ciso646 climits clocale cmath"
  cxxac_file="$cxxac_file csetjmp csignal cstdarg cstddef"
  cxxac_file="$cxxac_file cstdio cstdlib cstring ctime cwchar cwctype"

  cxxac_cv_have_all_header=yes
  cxxac_cv_header_need_ext=
  cxxac_cv_header_missing=
  for cxxac_f in $cxxac_file; do
    CXXAC_HEADER($cxxac_f)
    if test $cxxac_cv_have_header != yes; then
      cxxac_cv_have_all_header=no
      if test $cxxac_cv_have_header = need_h; then
        cxxac_cv_header_need_ext="$cxxac_cv_header_need_ext $cxxac_f"
      else
        cxxac_cv_header_missing="$cxxac_cv_header_missing $cxxac_f"
      fi
    fi
  done

  dnl Append a space for easy check later
  cxxac_cv_header_need_ext="$cxxac_cv_header_need_ext "
  cxxac_cv_header_missing="$cxxac_cv_header_missing "

  AC_LANG_POP([C++])
])


dnl *****************************************************************
dnl CXXAC_STRING_ERASE	Test if `string::erase' is available.  It is 
dnl			supported by libstdc++ 2.8.0 or newer.
dnl			If not available, string::remove (in libg++
dnl			before 2.8.0) or string::replace (in all
dnl			versions of libg++/libstdc++) may be used.
dnl
dnl	Results:	cxxac_cv_string_erase = yes/no
dnl			CXX__STRING_ERASE defined in header file
dnl				if cxxac_cv_string_erase = yes
dnl
AC_DEFUN([CXXAC_STRING_ERASE], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])

  AC_REQUIRE([CXXAC_LIB_NEED_USING_STD])
  if test "x$cxxac_cv_have_header_string" = x; then
    CXXAC_HEADER(string)
  fi

  AC_MSG_CHECKING([for C++ string::erase method])
  AH_TEMPLATE([CXX__STRING_ERASE], [Define if string::erase(...) is available.])

  AC_CACHE_VAL(cxxac_cv_string_erase, [

    AC_TRY_COMPILE([

/* Some macro defined in curses.h  */
#undef move
#undef clear
#undef erase

#include <$cxxac_cv_header_string>
$cxxac_using_namespace_std

    ], [

string s("test");
s.erase(0,1);

    ], [
      cxxac_cv_string_erase=yes
    ], [
      cxxac_cv_string_erase=no
    ])
  ])

  if test $cxxac_cv_string_erase = yes; then
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT(no)
  fi

  if test $cxxac_cv_string_erase = yes; then
    AC_DEFINE(CXX__STRING_ERASE)
  fi
  AC_LANG_POP([C++])
])


dnl *****************************************************************
dnl CXXAC_STRING_IO	Test if stream I/O operators for string 
dnl			is available.
dnl
dnl	Results:	cxxac_cv_string_io = yes/no
dnl			CXX__STRING_IO defined in header file
dnl				if cxxac_cv_string_io = yes
dnl
AC_DEFUN([CXXAC_STRING_IO], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])

  AC_REQUIRE([CXXAC_LIB_NEED_USING_STD])
  CXXAC_HEADER(string)
  CXXAC_HEADER(iostream)

  AC_MSG_CHECKING([for stream I/O operators for C++ string])
  AH_TEMPLATE([CXX__STRING_IO], [Define if I/O stream operators for string is available.])

  AC_CACHE_VAL(cxxac_cv_string_io, [

    AC_TRY_COMPILE([

/* Some macro defined in curses.h  */
#undef move
#undef clear
#undef erase

#include <$cxxac_cv_header_string>
#include <$cxxac_cv_header_iostream>
$cxxac_using_namespace_std

    ], [

string s("test"), t;
cout << s << '\n';
cin >> t;

    ], [
      cxxac_cv_string_io=yes
    ], [
      cxxac_cv_string_io=no
    ])
  ])

  AC_MSG_RESULT($cxxac_cv_string_io)

  if test $cxxac_cv_string_io = yes; then
    AC_DEFINE(CXX__STRING_IO)
  fi
  AC_LANG_POP([C++])
])


dnl *****************************************************************
dnl CXXAC_BAD_ALLOC	Test if `bad_alloc' is available.  It is 
dnl			supported by gcc 2.95.x or newer and
dnl			egcs 1.1
dnl
dnl	Results:	cxxac_cv_bad_alloc = yes/no
dnl			CXX__BAD_ALLOC defined in header file
dnl				if cxxac_cv_bad_alloc = yes
dnl
AC_DEFUN([CXXAC_BAD_ALLOC], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])

  AC_REQUIRE([CXXAC_LIB_NEED_USING_STD])
  if test "x$cxxac_cv_have_header_new" = x; then
    CXXAC_HEADER(new)
  fi

  AC_REQUIRE([CXXAC_DEFAULT_EXCEPTION])

  AC_MSG_CHECKING([for bad_alloc])
  AH_TEMPLATE([CXX__BAD_ALLOC], [Define if new throws bad_alloc.])
  AH_VERBATIM([CXX__LIB_NEED_USING_STD_BAD_ALLOC], [
#ifdef CXX__BAD_ALLOC
# include CXX__HEADER_new
#else
# ifdef CXX__LIB_NEED_USING_STD
    namespace std { class bad_alloc {}; }
# else
    class bad_alloc {};
# endif
#endif
#ifdef CXX__LIB_NEED_USING_STD
# define BAD_ALLOC std::bad_alloc
#else
# define BAD_ALLOC bad_alloc
#endif
  ])


  AC_CACHE_VAL(cxxac_cv_bad_alloc, [

    if test $cxxac_cv_default_exception = yes; then
      AC_TRY_COMPILE([

#include <$cxxac_cv_header_new>
$cxxac_using_namespace_std

bad_alloc b;

      ], [
      ], [
        cxxac_cv_bad_alloc=yes
      ], [
        cxxac_cv_bad_alloc=no
      ])
    else
      cxxac_cv_bad_alloc=no
    fi
  ])

  if test $cxxac_cv_bad_alloc = yes; then
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT(no)
  fi

  if test $cxxac_cv_bad_alloc = yes; then
    AC_DEFINE(CXX__BAD_ALLOC)
  fi
  AC_LANG_POP([C++])
])


dnl *****************************************************************
dnl CXXAC_NEW_THROW_BAD_ALLOC
dnl
dnl			Test if new throws `bad_alloc'.  It is 
dnl			supported by gcc 2.95 or newer
dnl			and egcs 1.1.
dnl
dnl	Results:	cxxac_cv_new_throw_bad_alloc = yes/no
dnl			CXX__NEW_THROW_BAD_ALLOC defined in header file
dnl				if cxxac_cv_new_throw_bad_alloc = yes
dnl
AC_DEFUN([CXXAC_NEW_THROW_BAD_ALLOC], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])

  AC_REQUIRE([CXXAC_BAD_ALLOC])

  AC_MSG_CHECKING([if new throws bad_alloc])
  AH_TEMPLATE([CXX__NEW_THROW_BAD_ALLOC],
	      [Define if new throws bad_alloc.])

  AC_CACHE_VAL(cxxac_cv_new_throw_bad_alloc, [

    if test $cxxac_cv_bad_alloc = yes; then

      AC_TRY_RUN(

changequote(<<, >>)dnl
      <<

// TEST#1 - Try setting upper limit of memory resource

// If this test fails and returns 3, new[] may try
// to extend the memory limit.  We must proceed to TEST#2

#include <sys/time.h>
#include <sys/resource.h>
#include <unistd.h>

#include <$cxxac_cv_header_new>
$cxxac_using_namespace_std

int main() {
		// Set the upper resource limit.
		// This number must be large enough
		// so that memory can be allocated
		// by stack unwinding code.
	struct rlimit r;
	r.rlim_cur = 50000;
	r.rlim_max = 50000;
	if (setrlimit(RLIMIT_DATA,&r))
		exit(3);		// Unsupported test

	char *c;
	try {
		do {
			c = new char[60000];
		} while (c);
	}
	catch (bad_alloc &) {
		exit(0);
	}
	catch (...) {
		exit(2);		// Wrong exception
	}
	if (c == 0)
		exit(1);		// No throw
	else
		exit(3);		// Unsupported test
}

      >>
changequote([, ])dnl
      , [
        cxxac_cv_new_throw_result=ok
        cxxac_cv_new_throw_bad_alloc=yes
      ], [

        dnl unsupported by TEST#1     
        if test "$?" -eq 3; then

          AC_TRY_RUN(

changequote(<<, >>)dnl
      <<

// TEST#2 - Try exhausting system memory

#include <sys/time.h>
#include <sys/resource.h>
#include <unistd.h>

#include <$cxxac_cv_header_new>
$cxxac_using_namespace_std

int main() {
	char *c;
	try {
		for ( ; ; )
			c = new char[1000000];
	}
	catch (bad_alloc &) {
		return 0;
	}
	catch (...) {
		return 2;		// Wrong exception
	}
	if (c == 0)
		return 1;		// No throw
	else
		return 3;		// Unsupported test
}

      >>
changequote([, ])dnl

          , [
            cxxac_cv_new_throw_result=ok
            cxxac_cv_new_throw_bad_alloc=yes
          ], [
            cxxac_cv_new_throw_result="error $?"
            cxxac_cv_new_throw_bad_alloc=no
          ], [
            cxxac_cv_new_throw_result=cross_compile
            cxxac_cv_new_throw_bad_alloc=no
          ])

        dnl bad result from TEST#1
        else
          cxxac_cv_new_throw_result="error $?"
          cxxac_cv_new_throw_bad_alloc=no
        fi

      ], [
        cxxac_cv_new_throw_result=cross_compile
        cxxac_cv_new_throw_bad_alloc=no
      ])

    else
      cxxac_cv_new_throw_bad_alloc=no
    fi
  ])

  if test $cxxac_cv_new_throw_bad_alloc = yes; then
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT("no $cxxac_cv_new_throw_result")
  fi

  if test $cxxac_cv_new_throw_bad_alloc = yes; then
    AC_DEFINE(CXX__NEW_THROW_BAD_ALLOC)
  fi
  AC_LANG_POP([C++])
])


dnl *****************************************************************
dnl CXXAC_TEST_ALL	Run all test except CXXAC_WANT_xxx and
dnl			untested tests
dnl
dnl	Results:	All of above test
dnl
AC_DEFUN([CXXAC_TEST_ALL], [
  CXXAC_TYPE_WCHAR_T
  CXXAC_TYPE_BOOL
  CXXAC_DEFINE_BOOL

  CXXAC_HAVE_EXPLICIT
  CXXAC_HAVE_MUTABLE

  CXXAC_DEFAULT_EXCEPTION

  CXXAC_HAVE_MEMBER_FUNCTION_TEMPLATE
  CXXAC_HAVE_TYPENAME
  CXXAC_NO_GUIDE_DECL

  CXXAC_HAVE_NAMESPACE
  CXXAC_LIB_NEED_USING_STD

  CXXAC_BAD_FOR

  CXXAC_HAVE_ARRAY_NEW
  CXXAC_HAVE_PLACEMENT_NEW
  CXXAC_BAD_NEW
  CXXAC_BAD_DELETE

  CXXAC_HEADER_ALL

  CXXAC_STRING_ERASE
])

dnl *****************************************************************
dnl  End of C++ Tests for Autoconf
dnl *****************************************************************

# gettext.m4 serial 15 (gettext-0.11.3)
dnl Copyright (C) 1995-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.
dnl
dnl This file can can be used in projects which are not available under
dnl the GNU General Public License or the GNU Library General Public
dnl License but which still want to provide support for the GNU gettext
dnl functionality.
dnl Please note that the actual code of the GNU gettext library is covered
dnl by the GNU Library General Public License, and the rest of the GNU
dnl gettext package package is covered by the GNU General Public License.
dnl They are *not* in the public domain.

dnl Authors:
dnl   Ulrich Drepper <drepper@cygnus.com>, 1995-2000.
dnl   Bruno Haible <haible@clisp.cons.org>, 2000-2002.

dnl Macro to add for using GNU gettext.

dnl Usage: AM_GNU_GETTEXT([INTLSYMBOL], [NEEDSYMBOL], [INTLDIR]).
dnl INTLSYMBOL can be one of 'external', 'no-libtool', 'use-libtool'. The
dnl    default (if it is not specified or empty) is 'no-libtool'.
dnl    INTLSYMBOL should be 'external' for packages with no intl directory,
dnl    and 'no-libtool' or 'use-libtool' for packages with an intl directory.
dnl    If INTLSYMBOL is 'use-libtool', then a libtool library
dnl    $(top_builddir)/intl/libintl.la will be created (shared and/or static,
dnl    depending on --{enable,disable}-{shared,static} and on the presence of
dnl    AM-DISABLE-SHARED). If INTLSYMBOL is 'no-libtool', a static library
dnl    $(top_builddir)/intl/libintl.a will be created.
dnl If NEEDSYMBOL is specified and is 'need-ngettext', then GNU gettext
dnl    implementations (in libc or libintl) without the ngettext() function
dnl    will be ignored.
dnl INTLDIR is used to find the intl libraries.  If empty,
dnl    the value `$(top_builddir)/intl/' is used.
dnl
dnl The result of the configuration is one of three cases:
dnl 1) GNU gettext, as included in the intl subdirectory, will be compiled
dnl    and used.
dnl    Catalog format: GNU --> install in $(datadir)
dnl    Catalog extension: .mo after installation, .gmo in source tree
dnl 2) GNU gettext has been found in the system's C library.
dnl    Catalog format: GNU --> install in $(datadir)
dnl    Catalog extension: .mo after installation, .gmo in source tree
dnl 3) No internationalization, always use English msgid.
dnl    Catalog format: none
dnl    Catalog extension: none
dnl If INTLSYMBOL is 'external', only cases 2 and 3 can occur.
dnl The use of .gmo is historical (it was needed to avoid overwriting the
dnl GNU format catalogs when building on a platform with an X/Open gettext),
dnl but we keep it in order not to force irrelevant filename changes on the
dnl maintainers.
dnl
AC_DEFUN([AM_GNU_GETTEXT],
[
  dnl Argument checking.
  ifelse([$1], [], , [ifelse([$1], [external], , [ifelse([$1], [no-libtool], , [ifelse([$1], [use-libtool], ,
    [errprint([ERROR: invalid first argument to AM_GNU_GETTEXT
])])])])])
  ifelse([$2], [], , [ifelse([$2], [need-ngettext], ,
    [errprint([ERROR: invalid second argument to AM_GNU_GETTEXT
])])])
  define(gt_included_intl, ifelse([$1], [external], [no], [yes]))
  define(gt_libtool_suffix_prefix, ifelse([$1], [use-libtool], [l], []))

  AC_REQUIRE([AM_PO_SUBDIRS])dnl
  ifelse(gt_included_intl, yes, [
    AC_REQUIRE([AM_INTL_SUBDIR])dnl
  ])

  dnl Prerequisites of AC_LIB_LINKFLAGS_BODY.
  AC_REQUIRE([AC_LIB_PREPARE_PREFIX])
  AC_REQUIRE([AC_LIB_RPATH])

  dnl Sometimes libintl requires libiconv, so first search for libiconv.
  dnl Ideally we would do this search only after the
  dnl      if test "$USE_NLS" = "yes"; then
  dnl        if test "$gt_cv_func_gnugettext_libc" != "yes"; then
  dnl tests. But if configure.in invokes AM_ICONV after AM_GNU_GETTEXT
  dnl the configure script would need to contain the same shell code
  dnl again, outside any 'if'. There are two solutions:
  dnl - Invoke AM_ICONV_LINKFLAGS_BODY here, outside any 'if'.
  dnl - Control the expansions in more detail using AC_PROVIDE_IFELSE.
  dnl Since AC_PROVIDE_IFELSE is only in autoconf >= 2.52 and not
  dnl documented, we avoid it.
  ifelse(gt_included_intl, yes, , [
    AC_REQUIRE([AM_ICONV_LINKFLAGS_BODY])
  ])

  AC_MSG_CHECKING([whether NLS is requested])
  dnl Default is enabled NLS
  AC_ARG_ENABLE(nls,
    [  --disable-nls           do not use Native Language Support],
    USE_NLS=$enableval, USE_NLS=yes)
  AC_MSG_RESULT($USE_NLS)
  AC_SUBST(USE_NLS)

  ifelse(gt_included_intl, yes, [
    BUILD_INCLUDED_LIBINTL=no
    USE_INCLUDED_LIBINTL=no
  ])
  LIBINTL=
  LTLIBINTL=
  POSUB=

  dnl If we use NLS figure out what method
  if test "$USE_NLS" = "yes"; then
    gt_use_preinstalled_gnugettext=no
    ifelse(gt_included_intl, yes, [
      AC_MSG_CHECKING([whether included gettext is requested])
      AC_ARG_WITH(included-gettext,
        [  --with-included-gettext use the GNU gettext library included here],
        nls_cv_force_use_gnu_gettext=$withval,
        nls_cv_force_use_gnu_gettext=no)
      AC_MSG_RESULT($nls_cv_force_use_gnu_gettext)

      nls_cv_use_gnu_gettext="$nls_cv_force_use_gnu_gettext"
      if test "$nls_cv_force_use_gnu_gettext" != "yes"; then
    ])
        dnl User does not insist on using GNU NLS library.  Figure out what
        dnl to use.  If GNU gettext is available we use this.  Else we have
        dnl to fall back to GNU NLS library.

        dnl Add a version number to the cache macros.
        define([gt_api_version], ifelse([$2], [need-ngettext], 2, 1))
        define([gt_cv_func_gnugettext_libc], [gt_cv_func_gnugettext]gt_api_version[_libc])
        define([gt_cv_func_gnugettext_libintl], [gt_cv_func_gnugettext]gt_api_version[_libintl])

        AC_CACHE_CHECK([for GNU gettext in libc], gt_cv_func_gnugettext_libc,
         [AC_TRY_LINK([#include <libintl.h>
extern int _nl_msg_cat_cntr;
extern int *_nl_domain_bindings;],
            [bindtextdomain ("", "");
return (int) gettext ("")]ifelse([$2], [need-ngettext], [ + (int) ngettext ("", "", 0)], [])[ + _nl_msg_cat_cntr + *_nl_domain_bindings],
            gt_cv_func_gnugettext_libc=yes,
            gt_cv_func_gnugettext_libc=no)])

        if test "$gt_cv_func_gnugettext_libc" != "yes"; then
          dnl Sometimes libintl requires libiconv, so first search for libiconv.
          ifelse(gt_included_intl, yes, , [
            AM_ICONV_LINK
          ])
          dnl Search for libintl and define LIBINTL, LTLIBINTL and INCINTL
          dnl accordingly. Don't use AC_LIB_LINKFLAGS_BODY([intl],[iconv])
          dnl because that would add "-liconv" to LIBINTL and LTLIBINTL
          dnl even if libiconv doesn't exist.
          AC_LIB_LINKFLAGS_BODY([intl])
          AC_CACHE_CHECK([for GNU gettext in libintl],
            gt_cv_func_gnugettext_libintl,
           [gt_save_CPPFLAGS="$CPPFLAGS"
            CPPFLAGS="$CPPFLAGS $INCINTL"
            gt_save_LIBS="$LIBS"
            LIBS="$LIBS $LIBINTL"
            dnl Now see whether libintl exists and does not depend on libiconv.
            AC_TRY_LINK([#include <libintl.h>
extern int _nl_msg_cat_cntr;
extern
#ifdef __cplusplus
"C"
#endif
const char *_nl_expand_alias ();],
              [bindtextdomain ("", "");
return (int) gettext ("")]ifelse([$2], [need-ngettext], [ + (int) ngettext ("", "", 0)], [])[ + _nl_msg_cat_cntr + *_nl_expand_alias (0)],
              gt_cv_func_gnugettext_libintl=yes,
              gt_cv_func_gnugettext_libintl=no)
            dnl Now see whether libintl exists and depends on libiconv.
            if test "$gt_cv_func_gnugettext_libintl" != yes && test -n "$LIBICONV"; then
              LIBS="$LIBS $LIBICONV"
              AC_TRY_LINK([#include <libintl.h>
extern int _nl_msg_cat_cntr;
extern
#ifdef __cplusplus
"C"
#endif
const char *_nl_expand_alias ();],
                [bindtextdomain ("", "");
return (int) gettext ("")]ifelse([$2], [need-ngettext], [ + (int) ngettext ("", "", 0)], [])[ + _nl_msg_cat_cntr + *_nl_expand_alias (0)],
               [LIBINTL="$LIBINTL $LIBICONV"
                LTLIBINTL="$LTLIBINTL $LTLIBICONV"
                gt_cv_func_gnugettext_libintl=yes
               ])
            fi
            CPPFLAGS="$gt_save_CPPFLAGS"
            LIBS="$gt_save_LIBS"])
        fi

        dnl If an already present or preinstalled GNU gettext() is found,
        dnl use it.  But if this macro is used in GNU gettext, and GNU
        dnl gettext is already preinstalled in libintl, we update this
        dnl libintl.  (Cf. the install rule in intl/Makefile.in.)
        if test "$gt_cv_func_gnugettext_libc" = "yes" \
           || { test "$gt_cv_func_gnugettext_libintl" = "yes" \
                && test "$PACKAGE" != gettext; }; then
          gt_use_preinstalled_gnugettext=yes
        else
          dnl Reset the values set by searching for libintl.
          LIBINTL=
          LTLIBINTL=
          INCINTL=
        fi

    ifelse(gt_included_intl, yes, [
        if test "$gt_use_preinstalled_gnugettext" != "yes"; then
          dnl GNU gettext is not found in the C library.
          dnl Fall back on included GNU gettext library.
          nls_cv_use_gnu_gettext=yes
        fi
      fi

      if test "$nls_cv_use_gnu_gettext" = "yes"; then
        dnl Mark actions used to generate GNU NLS library.
        INTLOBJS="\$(GETTOBJS)"
        BUILD_INCLUDED_LIBINTL=yes
        USE_INCLUDED_LIBINTL=yes
        LIBINTL="ifelse([$3],[],\${top_builddir}/intl,[$3])/libintl.[]gt_libtool_suffix_prefix[]a $LIBICONV"
        LTLIBINTL="ifelse([$3],[],\${top_builddir}/intl,[$3])/libintl.[]gt_libtool_suffix_prefix[]a $LTLIBICONV"
        LIBS=`echo " $LIBS " | sed -e 's/ -lintl / /' -e 's/^ //' -e 's/ $//'`
      fi

      if test "$gt_use_preinstalled_gnugettext" = "yes" \
         || test "$nls_cv_use_gnu_gettext" = "yes"; then
        dnl Mark actions to use GNU gettext tools.
        CATOBJEXT=.gmo
      fi
    ])

    if test "$gt_use_preinstalled_gnugettext" = "yes" \
       || test "$nls_cv_use_gnu_gettext" = "yes"; then
      AC_DEFINE(ENABLE_NLS, 1,
        [Define to 1 if translation of program messages to the user's native language
   is requested.])
    else
      USE_NLS=no
    fi
  fi

  if test "$USE_NLS" = "yes"; then

    if test "$gt_use_preinstalled_gnugettext" = "yes"; then
      if test "$gt_cv_func_gnugettext_libintl" = "yes"; then
        AC_MSG_CHECKING([how to link with libintl])
        AC_MSG_RESULT([$LIBINTL])
        AC_LIB_APPENDTOVAR([CPPFLAGS], [$INCINTL])
      fi

      dnl For backward compatibility. Some packages may be using this.
      AC_DEFINE(HAVE_GETTEXT, 1,
       [Define if the GNU gettext() function is already present or preinstalled.])
      AC_DEFINE(HAVE_DCGETTEXT, 1,
       [Define if the GNU dcgettext() function is already present or preinstalled.])
    fi

    dnl We need to process the po/ directory.
    POSUB=po
  fi

  ifelse(gt_included_intl, yes, [
    dnl If this is used in GNU gettext we have to set BUILD_INCLUDED_LIBINTL
    dnl to 'yes' because some of the testsuite requires it.
    if test "$PACKAGE" = gettext; then
      BUILD_INCLUDED_LIBINTL=yes
    fi

    dnl Make all variables we use known to autoconf.
    AC_SUBST(BUILD_INCLUDED_LIBINTL)
    AC_SUBST(USE_INCLUDED_LIBINTL)
    AC_SUBST(CATOBJEXT)
    AC_SUBST(INTLOBJS)

    dnl For backward compatibility. Some configure.ins may be using this.
    nls_cv_header_intl=
    nls_cv_header_libgt=

    dnl For backward compatibility. Some Makefiles may be using this.
    DATADIRNAME=share
    AC_SUBST(DATADIRNAME)

    dnl For backward compatibility. Some Makefiles may be using this.
    INSTOBJEXT=.mo
    AC_SUBST(INSTOBJEXT)

    dnl For backward compatibility. Some Makefiles may be using this.
    GENCAT=gencat
    AC_SUBST(GENCAT)

    dnl Enable libtool support if the surrounding package wishes it.
    INTL_LIBTOOL_SUFFIX_PREFIX=gt_libtool_suffix_prefix
    AC_SUBST(INTL_LIBTOOL_SUFFIX_PREFIX)
  ])

  dnl For backward compatibility. Some Makefiles may be using this.
  INTLLIBS="$LIBINTL"
  AC_SUBST(INTLLIBS)

  dnl Make all documented variables known to autoconf.
  AC_SUBST(LIBINTL)
  AC_SUBST(LTLIBINTL)
  AC_SUBST(POSUB)
])


dnl Checks for all prerequisites of the po subdirectory,
dnl except for USE_NLS.
AC_DEFUN([AM_PO_SUBDIRS],
[
  AC_REQUIRE([AC_PROG_MAKE_SET])dnl
  AC_REQUIRE([AC_PROG_INSTALL])dnl
  AC_REQUIRE([AM_MKINSTALLDIRS])dnl

  dnl Perform the following tests also if --disable-nls has been given,
  dnl because they are needed for "make dist" to work.

  dnl Search for GNU msgfmt in the PATH.
  dnl The first test excludes Solaris msgfmt and early GNU msgfmt versions.
  dnl The second test excludes FreeBSD msgfmt.
  AM_PATH_PROG_WITH_TEST(MSGFMT, msgfmt,
    [$ac_dir/$ac_word --statistics /dev/null >/dev/null 2>&1 &&
     (if $ac_dir/$ac_word --statistics /dev/null 2>&1 >/dev/null | grep usage >/dev/null; then exit 1; else exit 0; fi)],
    :)
  AC_PATH_PROG(GMSGFMT, gmsgfmt, $MSGFMT)

  dnl Search for GNU xgettext 0.11 or newer in the PATH.
  dnl The first test excludes Solaris xgettext and early GNU xgettext versions.
  dnl The second test excludes FreeBSD xgettext.
  AM_PATH_PROG_WITH_TEST(XGETTEXT, xgettext,
    [$ac_dir/$ac_word --omit-header --copyright-holder= /dev/null >/dev/null 2>&1 &&
     (if $ac_dir/$ac_word --omit-header --copyright-holder= /dev/null 2>&1 >/dev/null | grep usage >/dev/null; then exit 1; else exit 0; fi)],
    :)
  dnl Remove leftover from FreeBSD xgettext call.
  rm -f messages.po

  dnl Search for GNU msgmerge 0.11 or newer in the PATH.
  AM_PATH_PROG_WITH_TEST(MSGMERGE, msgmerge,
    [$ac_dir/$ac_word --update -q /dev/null /dev/null >/dev/null 2>&1], :)

  dnl This could go away some day; the PATH_PROG_WITH_TEST already does it.
  dnl Test whether we really found GNU msgfmt.
  if test "$GMSGFMT" != ":"; then
    dnl If it is no GNU msgfmt we define it as : so that the
    dnl Makefiles still can work.
    if $GMSGFMT --statistics /dev/null >/dev/null 2>&1 &&
       (if $GMSGFMT --statistics /dev/null 2>&1 >/dev/null | grep usage >/dev/null; then exit 1; else exit 0; fi); then
      : ;
    else
      GMSGFMT=`echo "$GMSGFMT" | sed -e 's,^.*/,,'`
      AC_MSG_RESULT(
        [found $GMSGFMT program is not GNU msgfmt; ignore it])
      GMSGFMT=":"
    fi
  fi

  dnl This could go away some day; the PATH_PROG_WITH_TEST already does it.
  dnl Test whether we really found GNU xgettext.
  if test "$XGETTEXT" != ":"; then
    dnl If it is no GNU xgettext we define it as : so that the
    dnl Makefiles still can work.
    if $XGETTEXT --omit-header --copyright-holder= /dev/null >/dev/null 2>&1 &&
       (if $XGETTEXT --omit-header --copyright-holder= /dev/null 2>&1 >/dev/null | grep usage >/dev/null; then exit 1; else exit 0; fi); then
      : ;
    else
      AC_MSG_RESULT(
        [found xgettext program is not GNU xgettext; ignore it])
      XGETTEXT=":"
    fi
    dnl Remove leftover from FreeBSD xgettext call.
    rm -f messages.po
  fi

  AC_OUTPUT_COMMANDS([
    for ac_file in $CONFIG_FILES; do
      # Support "outfile[:infile[:infile...]]"
      case "$ac_file" in
        *:*) ac_file=`echo "$ac_file"|sed 's%:.*%%'` ;;
      esac
      # PO directories have a Makefile.in generated from Makefile.in.in.
      case "$ac_file" in */Makefile.in)
        # Adjust a relative srcdir.
        ac_dir=`echo "$ac_file"|sed 's%/[^/][^/]*$%%'`
        ac_dir_suffix="/`echo "$ac_dir"|sed 's%^\./%%'`"
        ac_dots=`echo "$ac_dir_suffix"|sed 's%/[^/]*%../%g'`
        # In autoconf-2.13 it is called $ac_given_srcdir.
        # In autoconf-2.50 it is called $srcdir.
        test -n "$ac_given_srcdir" || ac_given_srcdir="$srcdir"
        case "$ac_given_srcdir" in
          .)  top_srcdir=`echo $ac_dots|sed 's%/$%%'` ;;
          /*) top_srcdir="$ac_given_srcdir" ;;
          *)  top_srcdir="$ac_dots$ac_given_srcdir" ;;
        esac
        if test -f "$ac_given_srcdir/$ac_dir/POTFILES.in"; then
          rm -f "$ac_dir/POTFILES"
          test -n "$as_me" && echo "$as_me: creating $ac_dir/POTFILES" || echo "creating $ac_dir/POTFILES"
          cat "$ac_given_srcdir/$ac_dir/POTFILES.in" | sed -e "/^#/d" -e "/^[ 	]*\$/d" -e "s,.*,     $top_srcdir/& \\\\," | sed -e "\$s/\(.*\) \\\\/\1/" > "$ac_dir/POTFILES"
          # ALL_LINGUAS, POFILES, GMOFILES, UPDATEPOFILES, DUMMYPOFILES depend
          # on $ac_dir but don't depend on user-specified configuration
          # parameters.
          if test -f "$ac_given_srcdir/$ac_dir/LINGUAS"; then
            # The LINGUAS file contains the set of available languages.
            if test -n "$ALL_LINGUAS"; then
              test -n "$as_me" && echo "$as_me: setting ALL_LINGUAS in configure.in is obsolete" || echo "setting ALL_LINGUAS in configure.in is obsolete"
            fi
            ALL_LINGUAS_=`sed -e "/^#/d" "$ac_given_srcdir/$ac_dir/LINGUAS"`
            # Hide the ALL_LINGUAS assigment from automake.
            eval 'ALL_LINGUAS''=$ALL_LINGUAS_'
          fi
          case "$ac_given_srcdir" in
            .) srcdirpre= ;;
            *) srcdirpre='$(srcdir)/' ;;
          esac
          POFILES=
          GMOFILES=
          UPDATEPOFILES=
          DUMMYPOFILES=
          for lang in $ALL_LINGUAS; do
            POFILES="$POFILES $srcdirpre$lang.po"
            GMOFILES="$GMOFILES $srcdirpre$lang.gmo"
            UPDATEPOFILES="$UPDATEPOFILES $lang.po-update"
            DUMMYPOFILES="$DUMMYPOFILES $lang.nop"
          done
          # CATALOGS depends on both $ac_dir and the user's LINGUAS
          # environment variable.
          INST_LINGUAS=
          if test -n "$ALL_LINGUAS"; then
            for presentlang in $ALL_LINGUAS; do
              useit=no
              if test "%UNSET%" != "$LINGUAS"; then
                desiredlanguages="$LINGUAS"
              else
                desiredlanguages="$ALL_LINGUAS"
              fi
              for desiredlang in $desiredlanguages; do
                # Use the presentlang catalog if desiredlang is
                #   a. equal to presentlang, or
                #   b. a variant of presentlang (because in this case,
                #      presentlang can be used as a fallback for messages
                #      which are not translated in the desiredlang catalog).
                case "$desiredlang" in
                  "$presentlang"*) useit=yes;;
                esac
              done
              if test $useit = yes; then
                INST_LINGUAS="$INST_LINGUAS $presentlang"
              fi
            done
          fi
          CATALOGS=
          if test -n "$INST_LINGUAS"; then
            for lang in $INST_LINGUAS; do
              CATALOGS="$CATALOGS $lang.gmo"
            done
          fi
          test -n "$as_me" && echo "$as_me: creating $ac_dir/Makefile" || echo "creating $ac_dir/Makefile"
          sed -e "/^POTFILES =/r $ac_dir/POTFILES" -e "/^# Makevars/r $ac_given_srcdir/$ac_dir/Makevars" -e "s|@POFILES@|$POFILES|g" -e "s|@GMOFILES@|$GMOFILES|g" -e "s|@UPDATEPOFILES@|$UPDATEPOFILES|g" -e "s|@DUMMYPOFILES@|$DUMMYPOFILES|g" -e "s|@CATALOGS@|$CATALOGS|g" "$ac_dir/Makefile.in" > "$ac_dir/Makefile"
          for f in "$ac_given_srcdir/$ac_dir"/Rules-*; do
            if test -f "$f"; then
              case "$f" in
                *.orig | *.bak | *~) ;;
                *) cat "$f" >> "$ac_dir/Makefile" ;;
              esac
            fi
          done
        fi
        ;;
      esac
    done],
   [# Capture the value of obsolete $ALL_LINGUAS because we need it to compute
    # POFILES, GMOFILES, UPDATEPOFILES, DUMMYPOFILES, CATALOGS. But hide it
    # from automake.
    eval 'ALL_LINGUAS''="$ALL_LINGUAS"'
    # Capture the value of LINGUAS because we need it to compute CATALOGS.
    LINGUAS="${LINGUAS-%UNSET%}"
   ])
])


dnl Checks for all prerequisites of the intl subdirectory,
dnl except for INTL_LIBTOOL_SUFFIX_PREFIX (and possibly LIBTOOL), INTLOBJS,
dnl            USE_INCLUDED_LIBINTL, BUILD_INCLUDED_LIBINTL.
AC_DEFUN([AM_INTL_SUBDIR],
[
  AC_REQUIRE([AC_PROG_INSTALL])dnl
  AC_REQUIRE([AM_MKINSTALLDIRS])dnl
  AC_REQUIRE([AC_PROG_CC])dnl
  AC_REQUIRE([AC_CANONICAL_HOST])dnl
  AC_REQUIRE([AC_PROG_RANLIB])dnl
  AC_REQUIRE([AC_ISC_POSIX])dnl
  AC_REQUIRE([AC_HEADER_STDC])dnl
  AC_REQUIRE([AC_C_CONST])dnl
  AC_REQUIRE([AC_C_INLINE])dnl
  AC_REQUIRE([AC_TYPE_OFF_T])dnl
  AC_REQUIRE([AC_TYPE_SIZE_T])dnl
  AC_REQUIRE([AC_FUNC_ALLOCA])dnl
  AC_REQUIRE([AC_FUNC_MMAP])dnl
  AC_REQUIRE([jm_GLIBC21])dnl
  AC_REQUIRE([gt_INTDIV0])dnl

  AC_CHECK_HEADERS([argz.h limits.h locale.h nl_types.h malloc.h stddef.h \
stdlib.h string.h unistd.h sys/param.h])
  AC_CHECK_FUNCS([feof_unlocked fgets_unlocked getc_unlocked getcwd getegid \
geteuid getgid getuid mempcpy munmap putenv setenv setlocale stpcpy \
strcasecmp strdup strtoul tsearch __argz_count __argz_stringify __argz_next])

  AM_ICONV
  AM_LANGINFO_CODESET
  if test $ac_cv_header_locale_h = yes; then
    AM_LC_MESSAGES
  fi

  dnl intl/plural.c is generated from intl/plural.y. It requires bison,
  dnl because plural.y uses bison specific features. It requires at least
  dnl bison-1.26 because earlier versions generate a plural.c that doesn't
  dnl compile.
  dnl bison is only needed for the maintainer (who touches plural.y). But in
  dnl order to avoid separate Makefiles or --enable-maintainer-mode, we put
  dnl the rule in general Makefile. Now, some people carelessly touch the
  dnl files or have a broken "make" program, hence the plural.c rule will
  dnl sometimes fire. To avoid an error, defines BISON to ":" if it is not
  dnl present or too old.
  AC_CHECK_PROGS([INTLBISON], [bison])
  if test -z "$INTLBISON"; then
    ac_verc_fail=yes
  else
    dnl Found it, now check the version.
    AC_MSG_CHECKING([version of bison])
changequote(<<,>>)dnl
    ac_prog_version=`$INTLBISON --version 2>&1 | sed -n 's/^.*GNU Bison.* \([0-9]*\.[0-9.]*\).*$/\1/p'`
    case $ac_prog_version in
      '') ac_prog_version="v. ?.??, bad"; ac_verc_fail=yes;;
      1.2[6-9]* | 1.[3-9][0-9]* | [2-9].*)
changequote([,])dnl
         ac_prog_version="$ac_prog_version, ok"; ac_verc_fail=no;;
      *) ac_prog_version="$ac_prog_version, bad"; ac_verc_fail=yes;;
    esac
    AC_MSG_RESULT([$ac_prog_version])
  fi
  if test $ac_verc_fail = yes; then
    INTLBISON=:
  fi
])


AC_DEFUN([AM_MKINSTALLDIRS],
[
  dnl If the AC_CONFIG_AUX_DIR macro for autoconf is used we possibly
  dnl find the mkinstalldirs script in another subdir but $(top_srcdir).
  dnl Try to locate is.
  MKINSTALLDIRS=
  if test -n "$ac_aux_dir"; then
    MKINSTALLDIRS="$ac_aux_dir/mkinstalldirs"
  fi
  if test -z "$MKINSTALLDIRS"; then
    MKINSTALLDIRS="\$(top_srcdir)/mkinstalldirs"
  fi
  AC_SUBST(MKINSTALLDIRS)
])

# lib-prefix.m4 serial 1 (gettext-0.11)
dnl Copyright (C) 2001-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Bruno Haible.

dnl AC_LIB_PREFIX adds to the CPPFLAGS and LDFLAGS the flags that are needed
dnl to access previously installed libraries. The basic assumption is that
dnl a user will want packages to use other packages he previously installed
dnl with the same --prefix option.
dnl This macro is not needed if only AC_LIB_LINKFLAGS is used to locate
dnl libraries, but is otherwise very convenient.
AC_DEFUN([AC_LIB_PREFIX],
[
  AC_BEFORE([$0], [AC_LIB_LINKFLAGS])
  AC_REQUIRE([AC_PROG_CC])
  AC_REQUIRE([AC_CANONICAL_HOST])
  AC_REQUIRE([AC_LIB_PREPARE_PREFIX])
  dnl By default, look in $includedir and $libdir.
  use_additional=yes
  AC_LIB_WITH_FINAL_PREFIX([
    eval additional_includedir=\"$includedir\"
    eval additional_libdir=\"$libdir\"
  ])
  AC_ARG_WITH([lib-prefix],
[  --with-lib-prefix[=DIR] search for libraries in DIR/include and DIR/lib
  --without-lib-prefix    don't search for libraries in includedir and libdir],
[
    if test "X$withval" = "Xno"; then
      use_additional=no
    else
      if test "X$withval" = "X"; then
        AC_LIB_WITH_FINAL_PREFIX([
          eval additional_includedir=\"$includedir\"
          eval additional_libdir=\"$libdir\"
        ])
      else
        additional_includedir="$withval/include"
        additional_libdir="$withval/lib"
      fi
    fi
])
  if test $use_additional = yes; then
    dnl Potentially add $additional_includedir to $CPPFLAGS.
    dnl But don't add it
    dnl   1. if it's the standard /usr/include,
    dnl   2. if it's already present in $CPPFLAGS,
    dnl   3. if it's /usr/local/include and we are using GCC on Linux,
    dnl   4. if it doesn't exist as a directory.
    if test "X$additional_includedir" != "X/usr/include"; then
      haveit=
      for x in $CPPFLAGS; do
        AC_LIB_WITH_FINAL_PREFIX([eval x=\"$x\"])
        if test "X$x" = "X-I$additional_includedir"; then
          haveit=yes
          break
        fi
      done
      if test -z "$haveit"; then
        if test "X$additional_includedir" = "X/usr/local/include"; then
          if test -n "$GCC"; then
            case $host_os in
              linux*) haveit=yes;;
            esac
          fi
        fi
        if test -z "$haveit"; then
          if test -d "$additional_includedir"; then
            dnl Really add $additional_includedir to $CPPFLAGS.
            CPPFLAGS="${CPPFLAGS}${CPPFLAGS:+ }-I$additional_includedir"
          fi
        fi
      fi
    fi
    dnl Potentially add $additional_libdir to $LDFLAGS.
    dnl But don't add it
    dnl   1. if it's the standard /usr/lib,
    dnl   2. if it's already present in $LDFLAGS,
    dnl   3. if it's /usr/local/lib and we are using GCC on Linux,
    dnl   4. if it doesn't exist as a directory.
    if test "X$additional_libdir" != "X/usr/lib"; then
      haveit=
      for x in $LDFLAGS; do
        AC_LIB_WITH_FINAL_PREFIX([eval x=\"$x\"])
        if test "X$x" = "X-L$additional_libdir"; then
          haveit=yes
          break
        fi
      done
      if test -z "$haveit"; then
        if test "X$additional_libdir" = "X/usr/local/lib"; then
          if test -n "$GCC"; then
            case $host_os in
              linux*) haveit=yes;;
            esac
          fi
        fi
        if test -z "$haveit"; then
          if test -d "$additional_libdir"; then
            dnl Really add $additional_libdir to $LDFLAGS.
            LDFLAGS="${LDFLAGS}${LDFLAGS:+ }-L$additional_libdir"
          fi
        fi
      fi
    fi
  fi
])

dnl AC_LIB_PREPARE_PREFIX creates variables acl_final_prefix,
dnl acl_final_exec_prefix, containing the values to which $prefix and
dnl $exec_prefix will expand at the end of the configure script.
AC_DEFUN([AC_LIB_PREPARE_PREFIX],
[
  dnl Unfortunately, prefix and exec_prefix get only finally determined
  dnl at the end of configure.
  if test "X$prefix" = "XNONE"; then
    acl_final_prefix="$ac_default_prefix"
  else
    acl_final_prefix="$prefix"
  fi
  if test "X$exec_prefix" = "XNONE"; then
    acl_final_exec_prefix='${prefix}'
  else
    acl_final_exec_prefix="$exec_prefix"
  fi
  acl_save_prefix="$prefix"
  prefix="$acl_final_prefix"
  eval acl_final_exec_prefix=\"$acl_final_exec_prefix\"
  prefix="$acl_save_prefix"
])

dnl AC_LIB_WITH_FINAL_PREFIX([statement]) evaluates statement, with the
dnl variables prefix and exec_prefix bound to the values they will have
dnl at the end of the configure script.
AC_DEFUN([AC_LIB_WITH_FINAL_PREFIX],
[
  acl_save_prefix="$prefix"
  prefix="$acl_final_prefix"
  acl_save_exec_prefix="$exec_prefix"
  exec_prefix="$acl_final_exec_prefix"
  $1
  exec_prefix="$acl_save_exec_prefix"
  prefix="$acl_save_prefix"
])

# lib-link.m4 serial 3 (gettext-0.11.3)
dnl Copyright (C) 2001-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Bruno Haible.

dnl AC_LIB_LINKFLAGS(name [, dependencies]) searches for libname and
dnl the libraries corresponding to explicit and implicit dependencies.
dnl Sets and AC_SUBSTs the LIB${NAME} and LTLIB${NAME} variables and
dnl augments the CPPFLAGS variable.
AC_DEFUN([AC_LIB_LINKFLAGS],
[
  AC_REQUIRE([AC_LIB_PREPARE_PREFIX])
  AC_REQUIRE([AC_LIB_RPATH])
  define([Name],[translit([$1],[./-], [___])])
  define([NAME],[translit([$1],[abcdefghijklmnopqrstuvwxyz./-],
                               [ABCDEFGHIJKLMNOPQRSTUVWXYZ___])])
  AC_CACHE_CHECK([how to link with lib[]$1], [ac_cv_lib[]Name[]_libs], [
    AC_LIB_LINKFLAGS_BODY([$1], [$2])
    ac_cv_lib[]Name[]_libs="$LIB[]NAME"
    ac_cv_lib[]Name[]_ltlibs="$LTLIB[]NAME"
    ac_cv_lib[]Name[]_cppflags="$INC[]NAME"
  ])
  LIB[]NAME="$ac_cv_lib[]Name[]_libs"
  LTLIB[]NAME="$ac_cv_lib[]Name[]_ltlibs"
  INC[]NAME="$ac_cv_lib[]Name[]_cppflags"
  AC_LIB_APPENDTOVAR([CPPFLAGS], [$INC]NAME)
  AC_SUBST([LIB]NAME)
  AC_SUBST([LTLIB]NAME)
  dnl Also set HAVE_LIB[]NAME so that AC_LIB_HAVE_LINKFLAGS can reuse the
  dnl results of this search when this library appears as a dependency.
  HAVE_LIB[]NAME=yes
  undefine([Name])
  undefine([NAME])
])

dnl AC_LIB_HAVE_LINKFLAGS(name, dependencies, includes, testcode)
dnl searches for libname and the libraries corresponding to explicit and
dnl implicit dependencies, together with the specified include files and
dnl the ability to compile and link the specified testcode. If found, it
dnl sets and AC_SUBSTs HAVE_LIB${NAME}=yes and the LIB${NAME} and
dnl LTLIB${NAME} variables and augments the CPPFLAGS variable, and
dnl #defines HAVE_LIB${NAME} to 1. Otherwise, it sets and AC_SUBSTs
dnl HAVE_LIB${NAME}=no and LIB${NAME} and LTLIB${NAME} to empty.
AC_DEFUN([AC_LIB_HAVE_LINKFLAGS],
[
  AC_REQUIRE([AC_LIB_PREPARE_PREFIX])
  AC_REQUIRE([AC_LIB_RPATH])
  define([Name],[translit([$1],[./-], [___])])
  define([NAME],[translit([$1],[abcdefghijklmnopqrstuvwxyz./-],
                               [ABCDEFGHIJKLMNOPQRSTUVWXYZ___])])

  dnl Search for lib[]Name and define LIB[]NAME, LTLIB[]NAME and INC[]NAME
  dnl accordingly.
  AC_LIB_LINKFLAGS_BODY([$1], [$2])

  dnl Add $INC[]NAME to CPPFLAGS before performing the following checks,
  dnl because if the user has installed lib[]Name and not disabled its use
  dnl via --without-lib[]Name-prefix, he wants to use it.
  ac_save_CPPFLAGS="$CPPFLAGS"
  AC_LIB_APPENDTOVAR([CPPFLAGS], [$INC]NAME)

  AC_CACHE_CHECK([for lib[]$1], [ac_cv_lib[]Name], [
    ac_save_LIBS="$LIBS"
    LIBS="$LIBS $LIB[]NAME"
    AC_TRY_LINK([$3], [$4], [ac_cv_lib[]Name=yes], [ac_cv_lib[]Name=no])
    LIBS="$ac_save_LIBS"
  ])
  if test "$ac_cv_lib[]Name" = yes; then
    HAVE_LIB[]NAME=yes
    AC_DEFINE([HAVE_LIB]NAME, 1, [Define if you have the $1 library.])
    AC_MSG_CHECKING([how to link with lib[]$1])
    AC_MSG_RESULT([$LIB[]NAME])
  else
    HAVE_LIB[]NAME=no
    dnl If $LIB[]NAME didn't lead to a usable library, we don't need
    dnl $INC[]NAME either.
    CPPFLAGS="$ac_save_CPPFLAGS"
    LIB[]NAME=
    LTLIB[]NAME=
  fi
  AC_SUBST([HAVE_LIB]NAME)
  AC_SUBST([LIB]NAME)
  AC_SUBST([LTLIB]NAME)
  undefine([Name])
  undefine([NAME])
])

dnl Determine the platform dependent parameters needed to use rpath:
dnl libext, shlibext, hardcode_libdir_flag_spec, hardcode_libdir_separator,
dnl hardcode_direct, hardcode_minus_L,
dnl sys_lib_search_path_spec, sys_lib_dlsearch_path_spec.
AC_DEFUN([AC_LIB_RPATH],
[
  AC_REQUIRE([AC_PROG_CC])                dnl we use $CC, $GCC, $LDFLAGS
  AC_REQUIRE([AC_LIB_PROG_LD])            dnl we use $LD, $with_gnu_ld
  AC_REQUIRE([AC_CANONICAL_HOST])         dnl we use $host
  AC_REQUIRE([AC_CONFIG_AUX_DIR_DEFAULT]) dnl we use $ac_aux_dir
  AC_CACHE_CHECK([for shared library run path origin], acl_cv_rpath, [
    CC="$CC" GCC="$GCC" LDFLAGS="$LDFLAGS" LD="$LD" with_gnu_ld="$with_gnu_ld" \
    ${CONFIG_SHELL-/bin/sh} "$ac_aux_dir/config.rpath" "$host" > conftest.sh
    . ./conftest.sh
    rm -f ./conftest.sh
    acl_cv_rpath=done
  ])
  wl="$acl_cv_wl"
  libext="$acl_cv_libext"
  shlibext="$acl_cv_shlibext"
  hardcode_libdir_flag_spec="$acl_cv_hardcode_libdir_flag_spec"
  hardcode_libdir_separator="$acl_cv_hardcode_libdir_separator"
  hardcode_direct="$acl_cv_hardcode_direct"
  hardcode_minus_L="$acl_cv_hardcode_minus_L"
  sys_lib_search_path_spec="$acl_cv_sys_lib_search_path_spec"
  sys_lib_dlsearch_path_spec="$acl_cv_sys_lib_dlsearch_path_spec"
  dnl Determine whether the user wants rpath handling at all.
  AC_ARG_ENABLE(rpath,
    [  --disable-rpath         do not hardcode runtime library paths],
    :, enable_rpath=yes)
])

dnl AC_LIB_LINKFLAGS_BODY(name [, dependencies]) searches for libname and
dnl the libraries corresponding to explicit and implicit dependencies.
dnl Sets the LIB${NAME}, LTLIB${NAME} and INC${NAME} variables.
AC_DEFUN([AC_LIB_LINKFLAGS_BODY],
[
  define([NAME],[translit([$1],[abcdefghijklmnopqrstuvwxyz./-],
                               [ABCDEFGHIJKLMNOPQRSTUVWXYZ___])])
  dnl By default, look in $includedir and $libdir.
  use_additional=yes
  AC_LIB_WITH_FINAL_PREFIX([
    eval additional_includedir=\"$includedir\"
    eval additional_libdir=\"$libdir\"
  ])
  AC_ARG_WITH([lib$1-prefix],
[  --with-lib$1-prefix[=DIR]  search for lib$1 in DIR/include and DIR/lib
  --without-lib$1-prefix     don't search for lib$1 in includedir and libdir],
[
    if test "X$withval" = "Xno"; then
      use_additional=no
    else
      if test "X$withval" = "X"; then
        AC_LIB_WITH_FINAL_PREFIX([
          eval additional_includedir=\"$includedir\"
          eval additional_libdir=\"$libdir\"
        ])
      else
        additional_includedir="$withval/include"
        additional_libdir="$withval/lib"
      fi
    fi
])
  dnl Search the library and its dependencies in $additional_libdir and
  dnl $LDFLAGS. Using breadth-first-seach.
  LIB[]NAME=
  LTLIB[]NAME=
  INC[]NAME=
  rpathdirs=
  ltrpathdirs=
  names_already_handled=
  names_next_round='$1 $2'
  while test -n "$names_next_round"; do
    names_this_round="$names_next_round"
    names_next_round=
    for name in $names_this_round; do
      already_handled=
      for n in $names_already_handled; do
        if test "$n" = "$name"; then
          already_handled=yes
          break
        fi
      done
      if test -z "$already_handled"; then
        names_already_handled="$names_already_handled $name"
        dnl See if it was already located by an earlier AC_LIB_LINKFLAGS
        dnl or AC_LIB_HAVE_LINKFLAGS call.
        uppername=`echo "$name" | sed -e 'y|abcdefghijklmnopqrstuvwxyz./-|ABCDEFGHIJKLMNOPQRSTUVWXYZ___|'`
        eval value=\"\$HAVE_LIB$uppername\"
        if test -n "$value"; then
          if test "$value" = yes; then
            eval value=\"\$LIB$uppername\"
            test -z "$value" || LIB[]NAME="${LIB[]NAME}${LIB[]NAME:+ }$value"
            eval value=\"\$LTLIB$uppername\"
            test -z "$value" || LTLIB[]NAME="${LTLIB[]NAME}${LTLIB[]NAME:+ }$value"
          else
            dnl An earlier call to AC_LIB_HAVE_LINKFLAGS has determined
            dnl that this library doesn't exist. So just drop it.
            :
          fi
        else
          dnl Search the library lib$name in $additional_libdir and $LDFLAGS
          dnl and the already constructed $LIBNAME/$LTLIBNAME.
          found_dir=
          found_la=
          found_so=
          found_a=
          if test $use_additional = yes; then
            if test -n "$shlibext" && test -f "$additional_libdir/lib$name.$shlibext"; then
              found_dir="$additional_libdir"
              found_so="$additional_libdir/lib$name.$shlibext"
              if test -f "$additional_libdir/lib$name.la"; then
                found_la="$additional_libdir/lib$name.la"
              fi
            else
              if test -f "$additional_libdir/lib$name.$libext"; then
                found_dir="$additional_libdir"
                found_a="$additional_libdir/lib$name.$libext"
                if test -f "$additional_libdir/lib$name.la"; then
                  found_la="$additional_libdir/lib$name.la"
                fi
              fi
            fi
          fi
          if test "X$found_dir" = "X"; then
            for x in $LDFLAGS $LTLIB[]NAME; do
              AC_LIB_WITH_FINAL_PREFIX([eval x=\"$x\"])
              case "$x" in
                -L*)
                  dir=`echo "X$x" | sed -e 's/^X-L//'`
                  if test -n "$shlibext" && test -f "$dir/lib$name.$shlibext"; then
                    found_dir="$dir"
                    found_so="$dir/lib$name.$shlibext"
                    if test -f "$dir/lib$name.la"; then
                      found_la="$dir/lib$name.la"
                    fi
                  else
                    if test -f "$dir/lib$name.$libext"; then
                      found_dir="$dir"
                      found_a="$dir/lib$name.$libext"
                      if test -f "$dir/lib$name.la"; then
                        found_la="$dir/lib$name.la"
                      fi
                    fi
                  fi
                  ;;
              esac
              if test "X$found_dir" != "X"; then
                break
              fi
            done
          fi
          if test "X$found_dir" != "X"; then
            dnl Found the library.
            LTLIB[]NAME="${LTLIB[]NAME}${LTLIB[]NAME:+ }-L$found_dir -l$name"
            if test "X$found_so" != "X"; then
              dnl Linking with a shared library. We attempt to hardcode its
              dnl directory into the executable's runpath, unless it's the
              dnl standard /usr/lib.
              if test "$enable_rpath" = no || test "X$found_dir" = "X/usr/lib"; then
                dnl No hardcoding is needed.
                LIB[]NAME="${LIB[]NAME}${LIB[]NAME:+ }$found_so"
              else
                dnl Use an explicit option to hardcode DIR into the resulting
                dnl binary.
                dnl Potentially add DIR to ltrpathdirs.
                dnl The ltrpathdirs will be appended to $LTLIBNAME at the end.
                haveit=
                for x in $ltrpathdirs; do
                  if test "X$x" = "X$found_dir"; then
                    haveit=yes
                    break
                  fi
                done
                if test -z "$haveit"; then
                  ltrpathdirs="$ltrpathdirs $found_dir"
                fi
                dnl The hardcoding into $LIBNAME is system dependent.
                if test "$hardcode_direct" = yes; then
                  dnl Using DIR/libNAME.so during linking hardcodes DIR into the
                  dnl resulting binary.
                  LIB[]NAME="${LIB[]NAME}${LIB[]NAME:+ }$found_so"
                else
                  if test -n "$hardcode_libdir_flag_spec" && test "$hardcode_minus_L" = no; then
                    dnl Use an explicit option to hardcode DIR into the resulting
                    dnl binary.
                    LIB[]NAME="${LIB[]NAME}${LIB[]NAME:+ }$found_so"
                    dnl Potentially add DIR to rpathdirs.
                    dnl The rpathdirs will be appended to $LIBNAME at the end.
                    haveit=
                    for x in $rpathdirs; do
                      if test "X$x" = "X$found_dir"; then
                        haveit=yes
                        break
                      fi
                    done
                    if test -z "$haveit"; then
                      rpathdirs="$rpathdirs $found_dir"
                    fi
                  else
                    dnl Rely on "-L$found_dir".
                    dnl But don't add it if it's already contained in the LDFLAGS
                    dnl or the already constructed $LIBNAME
                    haveit=
                    for x in $LDFLAGS $LIB[]NAME; do
                      AC_LIB_WITH_FINAL_PREFIX([eval x=\"$x\"])
                      if test "X$x" = "X-L$found_dir"; then
                        haveit=yes
                        break
                      fi
                    done
                    if test -z "$haveit"; then
                      LIB[]NAME="${LIB[]NAME}${LIB[]NAME:+ }-L$found_dir"
                    fi
                    if test "$hardcode_minus_L" != no; then
                      dnl FIXME: Not sure whether we should use
                      dnl "-L$found_dir -l$name" or "-L$found_dir $found_so"
                      dnl here.
                      LIB[]NAME="${LIB[]NAME}${LIB[]NAME:+ }$found_so"
                    else
                      dnl We cannot use $hardcode_runpath_var and LD_RUN_PATH
                      dnl here, because this doesn't fit in flags passed to the
                      dnl compiler. So give up. No hardcoding. This affects only
                      dnl very old systems.
                      dnl FIXME: Not sure whether we should use
                      dnl "-L$found_dir -l$name" or "-L$found_dir $found_so"
                      dnl here.
                      LIB[]NAME="${LIB[]NAME}${LIB[]NAME:+ }-l$name"
                    fi
                  fi
                fi
              fi
            else
              if test "X$found_a" != "X"; then
                dnl Linking with a static library.
                LIB[]NAME="${LIB[]NAME}${LIB[]NAME:+ }$found_a"
              else
                dnl We shouldn't come here, but anyway it's good to have a
                dnl fallback.
                LIB[]NAME="${LIB[]NAME}${LIB[]NAME:+ }-L$found_dir -l$name"
              fi
            fi
            dnl Assume the include files are nearby.
            additional_includedir=
            case "$found_dir" in
              */lib | */lib/)
                basedir=`echo "X$found_dir" | sed -e 's,^X,,' -e 's,/lib/*$,,'`
                additional_includedir="$basedir/include"
                ;;
            esac
            if test "X$additional_includedir" != "X"; then
              dnl Potentially add $additional_includedir to $INCNAME.
              dnl But don't add it
              dnl   1. if it's the standard /usr/include,
              dnl   2. if it's /usr/local/include and we are using GCC on Linux,
              dnl   3. if it's already present in $CPPFLAGS or the already
              dnl      constructed $INCNAME,
              dnl   4. if it doesn't exist as a directory.
              if test "X$additional_includedir" != "X/usr/include"; then
                haveit=
                if test "X$additional_includedir" = "X/usr/local/include"; then
                  if test -n "$GCC"; then
                    case $host_os in
                      linux*) haveit=yes;;
                    esac
                  fi
                fi
                if test -z "$haveit"; then
                  for x in $CPPFLAGS $INC[]NAME; do
                    AC_LIB_WITH_FINAL_PREFIX([eval x=\"$x\"])
                    if test "X$x" = "X-I$additional_includedir"; then
                      haveit=yes
                      break
                    fi
                  done
                  if test -z "$haveit"; then
                    if test -d "$additional_includedir"; then
                      dnl Really add $additional_includedir to $INCNAME.
                      INC[]NAME="${INC[]NAME}${INC[]NAME:+ }-I$additional_includedir"
                    fi
                  fi
                fi
              fi
            fi
            dnl Look for dependencies.
            if test -n "$found_la"; then
              dnl Read the .la file. It defines the variables
              dnl dlname, library_names, old_library, dependency_libs, current,
              dnl age, revision, installed, dlopen, dlpreopen, libdir.
              save_libdir="$libdir"
              case "$found_la" in
                */* | *\\*) . "$found_la" ;;
                *) . "./$found_la" ;;
              esac
              libdir="$save_libdir"
              dnl We use only dependency_libs.
              for dep in $dependency_libs; do
                case "$dep" in
                  -L*)
                    additional_libdir=`echo "X$dep" | sed -e 's/^X-L//'`
                    dnl Potentially add $additional_libdir to $LIBNAME and $LTLIBNAME.
                    dnl But don't add it
                    dnl   1. if it's the standard /usr/lib,
                    dnl   2. if it's /usr/local/lib and we are using GCC on Linux,
                    dnl   3. if it's already present in $LDFLAGS or the already
                    dnl      constructed $LIBNAME,
                    dnl   4. if it doesn't exist as a directory.
                    if test "X$additional_libdir" != "X/usr/lib"; then
                      haveit=
                      if test "X$additional_libdir" = "X/usr/local/lib"; then
                        if test -n "$GCC"; then
                          case $host_os in
                            linux*) haveit=yes;;
                          esac
                        fi
                      fi
                      if test -z "$haveit"; then
                        haveit=
                        for x in $LDFLAGS $LIB[]NAME; do
                          AC_LIB_WITH_FINAL_PREFIX([eval x=\"$x\"])
                          if test "X$x" = "X-L$additional_libdir"; then
                            haveit=yes
                            break
                          fi
                        done
                        if test -z "$haveit"; then
                          if test -d "$additional_libdir"; then
                            dnl Really add $additional_libdir to $LIBNAME.
                            LIB[]NAME="${LIB[]NAME}${LIB[]NAME:+ }-L$additional_libdir"
                          fi
                        fi
                        haveit=
                        for x in $LDFLAGS $LTLIB[]NAME; do
                          AC_LIB_WITH_FINAL_PREFIX([eval x=\"$x\"])
                          if test "X$x" = "X-L$additional_libdir"; then
                            haveit=yes
                            break
                          fi
                        done
                        if test -z "$haveit"; then
                          if test -d "$additional_libdir"; then
                            dnl Really add $additional_libdir to $LTLIBNAME.
                            LTLIB[]NAME="${LTLIB[]NAME}${LTLIB[]NAME:+ }-L$additional_libdir"
                          fi
                        fi
                      fi
                    fi
                    ;;
                  -R*)
                    dir=`echo "X$dep" | sed -e 's/^X-R//'`
                    if test "$enable_rpath" != no; then
                      dnl Potentially add DIR to rpathdirs.
                      dnl The rpathdirs will be appended to $LIBNAME at the end.
                      haveit=
                      for x in $rpathdirs; do
                        if test "X$x" = "X$dir"; then
                          haveit=yes
                          break
                        fi
                      done
                      if test -z "$haveit"; then
                        rpathdirs="$rpathdirs $dir"
                      fi
                      dnl Potentially add DIR to ltrpathdirs.
                      dnl The ltrpathdirs will be appended to $LTLIBNAME at the end.
                      haveit=
                      for x in $ltrpathdirs; do
                        if test "X$x" = "X$dir"; then
                          haveit=yes
                          break
                        fi
                      done
                      if test -z "$haveit"; then
                        ltrpathdirs="$ltrpathdirs $dir"
                      fi
                    fi
                    ;;
                  -l*)
                    dnl Handle this in the next round.
                    names_next_round="$names_next_round "`echo "X$dep" | sed -e 's/^X-l//'`
                    ;;
                  *.la)
                    dnl Handle this in the next round. Throw away the .la's
                    dnl directory; it is already contained in a preceding -L
                    dnl option.
                    names_next_round="$names_next_round "`echo "X$dep" | sed -e 's,^X.*/,,' -e 's,^lib,,' -e 's,\.la$,,'`
                    ;;
                  *)
                    dnl Most likely an immediate library name.
                    LIB[]NAME="${LIB[]NAME}${LIB[]NAME:+ }$dep"
                    LTLIB[]NAME="${LTLIB[]NAME}${LTLIB[]NAME:+ }$dep"
                    ;;
                esac
              done
            fi
          else
            dnl Didn't find the library; assume it is in the system directories
            dnl known to the linker and runtime loader. (All the system
            dnl directories known to the linker should also be known to the
            dnl runtime loader, otherwise the system is severely misconfigured.)
            LIB[]NAME="${LIB[]NAME}${LIB[]NAME:+ }-l$name"
            LTLIB[]NAME="${LTLIB[]NAME}${LTLIB[]NAME:+ }-l$name"
          fi
        fi
      fi
    done
  done
  if test "X$rpathdirs" != "X"; then
    if test -n "$hardcode_libdir_separator"; then
      dnl Weird platform: only the last -rpath option counts, the user must
      dnl pass all path elements in one option. We can arrange that for a
      dnl single library, but not when more than one $LIBNAMEs are used.
      alldirs=
      for found_dir in $rpathdirs; do
        alldirs="${alldirs}${alldirs:+$hardcode_libdir_separator}$found_dir"
      done
      dnl Note: hardcode_libdir_flag_spec uses $libdir and $wl.
      acl_save_libdir="$libdir"
      libdir="$alldirs"
      eval flag=\"$hardcode_libdir_flag_spec\"
      libdir="$acl_save_libdir"
      LIB[]NAME="${LIB[]NAME}${LIB[]NAME:+ }$flag"
    else
      dnl The -rpath options are cumulative.
      for found_dir in $rpathdirs; do
        acl_save_libdir="$libdir"
        libdir="$found_dir"
        eval flag=\"$hardcode_libdir_flag_spec\"
        libdir="$acl_save_libdir"
        LIB[]NAME="${LIB[]NAME}${LIB[]NAME:+ }$flag"
      done
    fi
  fi
  if test "X$ltrpathdirs" != "X"; then
    dnl When using libtool, the option that works for both libraries and
    dnl executables is -R. The -R options are cumulative.
    for found_dir in $ltrpathdirs; do
      LTLIB[]NAME="${LTLIB[]NAME}${LTLIB[]NAME:+ }-R$found_dir"
    done
  fi
])

dnl AC_LIB_APPENDTOVAR(VAR, CONTENTS) appends the elements of CONTENTS to VAR,
dnl unless already present in VAR.
dnl Works only for CPPFLAGS, not for LIB* variables because that sometimes
dnl contains two or three consecutive elements that belong together.
AC_DEFUN([AC_LIB_APPENDTOVAR],
[
  for element in [$2]; do
    haveit=
    for x in $[$1]; do
      AC_LIB_WITH_FINAL_PREFIX([eval x=\"$x\"])
      if test "X$x" = "X$element"; then
        haveit=yes
        break
      fi
    done
    if test -z "$haveit"; then
      [$1]="${[$1]}${[$1]:+ }$element"
    fi
  done
])

# lib-ld.m4 serial 1 (gettext-0.11)
dnl Copyright (C) 1996-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl Subroutines of libtool.m4,
dnl with replacements s/AC_/AC_LIB/ and s/lt_cv/acl_cv/ to avoid collision
dnl with libtool.m4.

dnl From libtool-1.4. Sets the variable with_gnu_ld to yes or no.
AC_DEFUN([AC_LIB_PROG_LD_GNU],
[AC_CACHE_CHECK([if the linker ($LD) is GNU ld], acl_cv_prog_gnu_ld,
[# I'd rather use --version here, but apparently some GNU ld's only accept -v.
if $LD -v 2>&1 </dev/null | egrep '(GNU|with BFD)' 1>&5; then
  acl_cv_prog_gnu_ld=yes
else
  acl_cv_prog_gnu_ld=no
fi])
with_gnu_ld=$acl_cv_prog_gnu_ld
])

dnl From libtool-1.4. Sets the variable LD.
AC_DEFUN([AC_LIB_PROG_LD],
[AC_ARG_WITH(gnu-ld,
[  --with-gnu-ld           assume the C compiler uses GNU ld [default=no]],
test "$withval" = no || with_gnu_ld=yes, with_gnu_ld=no)
AC_REQUIRE([AC_PROG_CC])dnl
AC_REQUIRE([AC_CANONICAL_HOST])dnl
ac_prog=ld
if test "$GCC" = yes; then
  # Check if gcc -print-prog-name=ld gives a path.
  AC_MSG_CHECKING([for ld used by GCC])
  case $host in
  *-*-mingw*)
    # gcc leaves a trailing carriage return which upsets mingw
    ac_prog=`($CC -print-prog-name=ld) 2>&5 | tr -d '\015'` ;;
  *)
    ac_prog=`($CC -print-prog-name=ld) 2>&5` ;;
  esac
  case $ac_prog in
    # Accept absolute paths.
    [[\\/]* | [A-Za-z]:[\\/]*)]
      [re_direlt='/[^/][^/]*/\.\./']
      # Canonicalize the path of ld
      ac_prog=`echo $ac_prog| sed 's%\\\\%/%g'`
      while echo $ac_prog | grep "$re_direlt" > /dev/null 2>&1; do
	ac_prog=`echo $ac_prog| sed "s%$re_direlt%/%"`
      done
      test -z "$LD" && LD="$ac_prog"
      ;;
  "")
    # If it fails, then pretend we aren't using GCC.
    ac_prog=ld
    ;;
  *)
    # If it is relative, then search for the first ld in PATH.
    with_gnu_ld=unknown
    ;;
  esac
elif test "$with_gnu_ld" = yes; then
  AC_MSG_CHECKING([for GNU ld])
else
  AC_MSG_CHECKING([for non-GNU ld])
fi
AC_CACHE_VAL(acl_cv_path_LD,
[if test -z "$LD"; then
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}${PATH_SEPARATOR-:}"
  for ac_dir in $PATH; do
    test -z "$ac_dir" && ac_dir=.
    if test -f "$ac_dir/$ac_prog" || test -f "$ac_dir/$ac_prog$ac_exeext"; then
      acl_cv_path_LD="$ac_dir/$ac_prog"
      # Check to see if the program is GNU ld.  I'd rather use --version,
      # but apparently some GNU ld's only accept -v.
      # Break only if it was the GNU/non-GNU ld that we prefer.
      if "$acl_cv_path_LD" -v 2>&1 < /dev/null | egrep '(GNU|with BFD)' > /dev/null; then
	test "$with_gnu_ld" != no && break
      else
	test "$with_gnu_ld" != yes && break
      fi
    fi
  done
  IFS="$ac_save_ifs"
else
  acl_cv_path_LD="$LD" # Let the user override the test with a path.
fi])
LD="$acl_cv_path_LD"
if test -n "$LD"; then
  AC_MSG_RESULT($LD)
else
  AC_MSG_RESULT(no)
fi
test -z "$LD" && AC_MSG_ERROR([no acceptable ld found in \$PATH])
AC_LIB_PROG_LD_GNU
])

# iconv.m4 serial AM4 (gettext-0.11.3)
dnl Copyright (C) 2000-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Bruno Haible.

AC_DEFUN([AM_ICONV_LINKFLAGS_BODY],
[
  dnl Prerequisites of AC_LIB_LINKFLAGS_BODY.
  AC_REQUIRE([AC_LIB_PREPARE_PREFIX])
  AC_REQUIRE([AC_LIB_RPATH])

  dnl Search for libiconv and define LIBICONV, LTLIBICONV and INCICONV
  dnl accordingly.
  AC_LIB_LINKFLAGS_BODY([iconv])
])

AC_DEFUN([AM_ICONV_LINK],
[
  dnl Some systems have iconv in libc, some have it in libiconv (OSF/1 and
  dnl those with the standalone portable GNU libiconv installed).

  dnl Search for libiconv and define LIBICONV, LTLIBICONV and INCICONV
  dnl accordingly.
  AC_REQUIRE([AM_ICONV_LINKFLAGS_BODY])

  dnl Add $INCICONV to CPPFLAGS before performing the following checks,
  dnl because if the user has installed libiconv and not disabled its use
  dnl via --without-libiconv-prefix, he wants to use it. The first
  dnl AC_TRY_LINK will then fail, the second AC_TRY_LINK will succeed.
  am_save_CPPFLAGS="$CPPFLAGS"
  AC_LIB_APPENDTOVAR([CPPFLAGS], [$INCICONV])

  AC_CACHE_CHECK(for iconv, am_cv_func_iconv, [
    am_cv_func_iconv="no, consider installing GNU libiconv"
    am_cv_lib_iconv=no
    AC_TRY_LINK([#include <stdlib.h>
#include <iconv.h>],
      [iconv_t cd = iconv_open("","");
       iconv(cd,NULL,NULL,NULL,NULL);
       iconv_close(cd);],
      am_cv_func_iconv=yes)
    if test "$am_cv_func_iconv" != yes; then
      am_save_LIBS="$LIBS"
      LIBS="$LIBS $LIBICONV"
      AC_TRY_LINK([#include <stdlib.h>
#include <iconv.h>],
        [iconv_t cd = iconv_open("","");
         iconv(cd,NULL,NULL,NULL,NULL);
         iconv_close(cd);],
        am_cv_lib_iconv=yes
        am_cv_func_iconv=yes)
      LIBS="$am_save_LIBS"
    fi
  ])
  if test "$am_cv_func_iconv" = yes; then
    AC_DEFINE(HAVE_ICONV, 1, [Define if you have the iconv() function.])
  fi
  if test "$am_cv_lib_iconv" = yes; then
    AC_MSG_CHECKING([how to link with libiconv])
    AC_MSG_RESULT([$LIBICONV])
  else
    dnl If $LIBICONV didn't lead to a usable library, we don't need $INCICONV
    dnl either.
    CPPFLAGS="$am_save_CPPFLAGS"
    LIBICONV=
    LTLIBICONV=
  fi
  AC_SUBST(LIBICONV)
  AC_SUBST(LTLIBICONV)
])

AC_DEFUN([AM_ICONV],
[
  AM_ICONV_LINK
  if test "$am_cv_func_iconv" = yes; then
    AC_MSG_CHECKING([for iconv declaration])
    AC_CACHE_VAL(am_cv_proto_iconv, [
      AC_TRY_COMPILE([
#include <stdlib.h>
#include <iconv.h>
extern
#ifdef __cplusplus
"C"
#endif
#if defined(__STDC__) || defined(__cplusplus)
size_t iconv (iconv_t cd, char * *inbuf, size_t *inbytesleft, char * *outbuf, size_t *outbytesleft);
#else
size_t iconv();
#endif
], [], am_cv_proto_iconv_arg1="", am_cv_proto_iconv_arg1="const")
      am_cv_proto_iconv="extern size_t iconv (iconv_t cd, $am_cv_proto_iconv_arg1 char * *inbuf, size_t *inbytesleft, char * *outbuf, size_t *outbytesleft);"])
    am_cv_proto_iconv=`echo "[$]am_cv_proto_iconv" | tr -s ' ' | sed -e 's/( /(/'`
    AC_MSG_RESULT([$]{ac_t:-
         }[$]am_cv_proto_iconv)
    AC_DEFINE_UNQUOTED(ICONV_CONST, $am_cv_proto_iconv_arg1,
      [Define as const if the declaration of iconv() needs const.])
  fi
])

# progtest.m4 serial 2 (gettext-0.10.40)
dnl Copyright (C) 1996-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.
dnl
dnl This file can can be used in projects which are not available under
dnl the GNU General Public License or the GNU Library General Public
dnl License but which still want to provide support for the GNU gettext
dnl functionality.
dnl Please note that the actual code of the GNU gettext library is covered
dnl by the GNU Library General Public License, and the rest of the GNU
dnl gettext package package is covered by the GNU General Public License.
dnl They are *not* in the public domain.

dnl Authors:
dnl   Ulrich Drepper <drepper@cygnus.com>, 1996.

# Search path for a program which passes the given test.

dnl AM_PATH_PROG_WITH_TEST(VARIABLE, PROG-TO-CHECK-FOR,
dnl   TEST-PERFORMED-ON-FOUND_PROGRAM [, VALUE-IF-NOT-FOUND [, PATH]])
AC_DEFUN([AM_PATH_PROG_WITH_TEST],
[# Extract the first word of "$2", so it can be a program name with args.
set dummy $2; ac_word=[$]2
AC_MSG_CHECKING([for $ac_word])
AC_CACHE_VAL(ac_cv_path_$1,
[case "[$]$1" in
  /*)
  ac_cv_path_$1="[$]$1" # Let the user override the test with a path.
  ;;
  *)
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}:"
  for ac_dir in ifelse([$5], , $PATH, [$5]); do
    test -z "$ac_dir" && ac_dir=.
    if test -f $ac_dir/$ac_word; then
      if [$3]; then
	ac_cv_path_$1="$ac_dir/$ac_word"
	break
      fi
    fi
  done
  IFS="$ac_save_ifs"
dnl If no 4th arg is given, leave the cache variable unset,
dnl so AC_PATH_PROGS will keep looking.
ifelse([$4], , , [  test -z "[$]ac_cv_path_$1" && ac_cv_path_$1="$4"
])dnl
  ;;
esac])dnl
$1="$ac_cv_path_$1"
if test ifelse([$4], , [-n "[$]$1"], ["[$]$1" != "$4"]); then
  AC_MSG_RESULT([$]$1)
else
  AC_MSG_RESULT(no)
fi
AC_SUBST($1)dnl
])

# glibc21.m4 serial 2 (fileutils-4.1.3, gettext-0.10.40)
dnl Copyright (C) 2000-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

# Test for the GNU C Library, version 2.1 or newer.
# From Bruno Haible.

AC_DEFUN([jm_GLIBC21],
  [
    AC_CACHE_CHECK(whether we are using the GNU C Library 2.1 or newer,
      ac_cv_gnu_library_2_1,
      [AC_EGREP_CPP([Lucky GNU user],
	[
#include <features.h>
#ifdef __GNU_LIBRARY__
 #if (__GLIBC__ == 2 && __GLIBC_MINOR__ >= 1) || (__GLIBC__ > 2)
  Lucky GNU user
 #endif
#endif
	],
	ac_cv_gnu_library_2_1=yes,
	ac_cv_gnu_library_2_1=no)
      ]
    )
    AC_SUBST(GLIBC21)
    GLIBC21="$ac_cv_gnu_library_2_1"
  ]
)

# intdiv0.m4 serial 1 (gettext-0.11.3)
dnl Copyright (C) 2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Bruno Haible.

AC_DEFUN([gt_INTDIV0],
[
  AC_REQUIRE([AC_PROG_CC])dnl
  AC_REQUIRE([AC_CANONICAL_HOST])dnl

  AC_CACHE_CHECK([whether integer division by zero raises SIGFPE],
    gt_cv_int_divbyzero_sigfpe,
    [
      AC_TRY_RUN([
#include <stdlib.h>
#include <signal.h>

static void
#ifdef __cplusplus
sigfpe_handler (int sig)
#else
sigfpe_handler (sig) int sig;
#endif
{
  /* Exit with code 0 if SIGFPE, with code 1 if any other signal.  */
  exit (sig != SIGFPE);
}

int x = 1;
int y = 0;
int z;
int nan;

int main ()
{
  signal (SIGFPE, sigfpe_handler);
/* IRIX and AIX (when "xlc -qcheck" is used) yield signal SIGTRAP.  */
#if (defined (__sgi) || defined (_AIX)) && defined (SIGTRAP)
  signal (SIGTRAP, sigfpe_handler);
#endif
/* Linux/SPARC yields signal SIGILL.  */
#if defined (__sparc__) && defined (__linux__)
  signal (SIGILL, sigfpe_handler);
#endif

  z = x / y;
  nan = y / y;
  exit (1);
}
], gt_cv_int_divbyzero_sigfpe=yes, gt_cv_int_divbyzero_sigfpe=no,
        [
          # Guess based on the CPU.
          case "$host_cpu" in
            alpha* | i[34567]86 | m68k | s390*)
              gt_cv_int_divbyzero_sigfpe="guessing yes";;
            *)
              gt_cv_int_divbyzero_sigfpe="guessing no";;
          esac
        ])
    ])
  case "$gt_cv_int_divbyzero_sigfpe" in
    *yes) value=1;;
    *) value=0;;
  esac
  AC_DEFINE_UNQUOTED(INTDIV0_RAISES_SIGFPE, $value,
    [Define if integer division by zero raises signal SIGFPE.])
])

# codeset.m4 serial AM1 (gettext-0.10.40)
dnl Copyright (C) 2000-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Bruno Haible.

AC_DEFUN([AM_LANGINFO_CODESET],
[
  AC_CACHE_CHECK([for nl_langinfo and CODESET], am_cv_langinfo_codeset,
    [AC_TRY_LINK([#include <langinfo.h>],
      [char* cs = nl_langinfo(CODESET);],
      am_cv_langinfo_codeset=yes,
      am_cv_langinfo_codeset=no)
    ])
  if test $am_cv_langinfo_codeset = yes; then
    AC_DEFINE(HAVE_LANGINFO_CODESET, 1,
      [Define if you have <langinfo.h> and nl_langinfo(CODESET).])
  fi
])

# lcmessage.m4 serial 3 (gettext-0.11.3)
dnl Copyright (C) 1995-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.
dnl
dnl This file can can be used in projects which are not available under
dnl the GNU General Public License or the GNU Library General Public
dnl License but which still want to provide support for the GNU gettext
dnl functionality.
dnl Please note that the actual code of the GNU gettext library is covered
dnl by the GNU Library General Public License, and the rest of the GNU
dnl gettext package package is covered by the GNU General Public License.
dnl They are *not* in the public domain.

dnl Authors:
dnl   Ulrich Drepper <drepper@cygnus.com>, 1995.

# Check whether LC_MESSAGES is available in <locale.h>.

AC_DEFUN([AM_LC_MESSAGES],
[
  AC_CACHE_CHECK([for LC_MESSAGES], am_cv_val_LC_MESSAGES,
    [AC_TRY_LINK([#include <locale.h>], [return LC_MESSAGES],
       am_cv_val_LC_MESSAGES=yes, am_cv_val_LC_MESSAGES=no)])
  if test $am_cv_val_LC_MESSAGES = yes; then
    AC_DEFINE(HAVE_LC_MESSAGES, 1,
      [Define if your <locale.h> file defines LC_MESSAGES.])
  fi
])

dnl *****************************************************************
dnl  ncurses Tests for Autoconf
dnl  Version 0.2.0
dnl  (c) 2000, 2002 by Kriang Lerdsuwanakij
dnl  lerdsuwa@users.sourceforge.net
dnl
dnl  This program is free software; you can redistribute it and/or modify
dnl  it under the terms of the GNU General Public License as published by
dnl  the Free Software Foundation; either version 2 of the License, or
dnl  (at your option) any later version.
dnl
dnl  This program is distributed in the hope that it will be useful,
dnl  but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl  GNU General Public License for more details.
dnl
dnl  As a special exception, the file `configure' generated by
dnl  `autoconf' from this file is not covered by the GNU General Public 
dnl  License.  This exception does not however invalidate any other
dnl  reasons why the generated file might be covered by the GNU General 
dnl  Public License.
dnl
dnl  You should have received a copy of the GNU General Public License
dnl  along with this program; if not, write to the Free Software
dnl  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
dnl

dnl *****************************************************************
dnl NCURSESAC_BOOL	Test for size of ncurses bool
dnl
dnl	Results:	ncursesac_cv_c_bool_size and ncursesac_cv_c_bool_equi
dnl			defined
dnl
AC_DEFUN([NCURSESAC_BOOL], [
  AC_LANG_PUSH([C])
  AC_MSG_CHECKING([for size of ncurses bool])
  AC_CACHE_VAL(ncursesac_cv_c_bool_size, [
	AC_TRY_RUN([
	#include <curses.h>
	#include <stdio.h>
	int main()
	{
		FILE *f1, *f2;
		f1 = fopen("cf_kcd1.out", "w");
		f2 = fopen("cf_kcd2.out", "w");
		if (f1 && f2) {
			fprintf(f1, "%d", sizeof(bool));

			if (sizeof(bool) == sizeof(char))
				fprintf(f2, "char");
			else if (sizeof(bool) == sizeof(int))
				fprintf(f2, "int");
			else if (sizeof(bool) == sizeof(short))
				fprintf(f2, "short");
			else if (sizeof(bool) == sizeof(long))
				fprintf(f2, "long");

			fclose(f1);
			fclose(f2);
			exit(0); 
		}
		else
			exit(1); 
	}
	], [
		ncursesac_cv_c_bool_size=`cat cf_kcd1.out`
		ncursesac_cv_c_bool_equi=`cat cf_kcd2.out`
	], [
		ncursesac_cv_c_bool_size="N/A (error during test)"
		ncursesac_cv_c_bool_equi="N/A"
	], [
		ncursesac_cv_c_bool_size="N/A (due to cross-compilation)"
		ncursesac_cv_c_bool_equi="N/A"
	])
	rm -f cf_kcd1.out cf_kcd2.out
  ])
  AC_MSG_RESULT($ncursesac_cv_c_bool_size)
  AC_LANG_POP([C])
])

dnl *****************************************************************
dnl NCURSESAC_MOUSEMASK	Test if mousemask is available
dnl
dnl	Results:	ncursesac_cv_have_mousemask and NCURSESAC_HAVE_MOUSEMASK
dnl
AC_DEFUN([NCURSESAC_MOUSEMASK], [
  AC_LANG_PUSH([C])
  AC_MSG_CHECKING([for mousemask])
  AH_TEMPLATE([NCURSESAC_HAVE_MOUSEMASK],
	      [Define if you have mousemask in <curses.h> header file.])
  AC_CACHE_VAL(ncursesac_cv_have_mousemask, [
	AC_TRY_LINK([
	#include <curses.h>
	], [
	mmask_t oldMouseMask;
	mousemask(ALL_MOUSE_EVENTS, &oldMouseMask);
	], [
		ncursesac_cv_have_mousemask=yes
	], [
		ncursesac_cv_have_mousemask=no
	])
  ])
  AC_MSG_RESULT($ncursesac_cv_have_mousemask)
  if test $ncursesac_cv_have_mousemask = yes; then
    AC_DEFINE(NCURSESAC_HAVE_MOUSEMASK)
  fi

  AC_LANG_POP([C])
])

dnl *****************************************************************
dnl NCURSESAC_NEW_ATTR	Test if new attr_get and attr_set is used
dnl
dnl	Results:	ncursesac_cv_new_attr_get_attr_set and
dnl			NCURSESAC_NEW_ATTR_GET_ATTR_SET
dnl
AC_DEFUN([NCURSESAC_NEW_ATTR], [
  AC_LANG_PUSH([C])
  AC_MSG_CHECKING([for new attr_get/attr_set])
  AH_TEMPLATE([NCURSESAC_NEW_ATTR_GET_ATTR_SET],
	      [Define if you have new attr_get/attr_set in <curses.h>
	       header file.])

  AC_CACHE_VAL(ncursesac_cv_new_attr, [
	AC_TRY_LINK([
	#include <curses.h>
	], [
	wattr_get(stdscr);
	], [
		ncursesac_cv_new_attr=no
	], [
		ncursesac_cv_new_attr=yes
		
	])
  ])
  AC_MSG_RESULT($ncursesac_cv_new_attr)
  if test $ncursesac_cv_new_attr = yes; then
    AC_DEFINE(NCURSESAC_NEW_ATTR_GET_ATTR_SET)
  fi

  AC_LANG_POP([C])
])

dnl *****************************************************************
dnl  End of ncurses Tests for Autoconf
dnl *****************************************************************

dnl *****************************************************************
dnl  zlib Tests for Autoconf
dnl  Version 0.2.0
dnl  (c) 2000, 2002 by Kriang Lerdsuwanakij
dnl  lerdsuwa@users.sourceforge.net
dnl
dnl  This program is free software; you can redistribute it and/or modify
dnl  it under the terms of the GNU General Public License as published by
dnl  the Free Software Foundation; either version 2 of the License, or
dnl  (at your option) any later version.
dnl
dnl  This program is distributed in the hope that it will be useful,
dnl  but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl  GNU General Public License for more details.
dnl
dnl  As a special exception, the file `configure' generated by
dnl  `autoconf' from this file is not covered by the GNU General Public 
dnl  License.  This exception does not however invalidate any other
dnl  reasons why the generated file might be covered by the GNU General 
dnl  Public License.
dnl
dnl  You should have received a copy of the GNU General Public License
dnl  along with this program; if not, write to the Free Software
dnl  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
dnl

dnl *****************************************************************
dnl ZLIBAC_EXTERN_C	Test if extern "C" is required to build
dnl			C++ programs.
dnl
dnl	Results:	zlibac_cv_need_extern_c and ZLIBAC_NEED_EXTERN_C
dnl			defined if extern "C" is required.
dnl
AC_DEFUN([ZLIBAC_EXTERN_C], [
  AC_LANG_PUSH([C++])
  AC_MSG_CHECKING([whether zlib requires extern "C" for C++ programs])
  AH_TEMPLATE([ZLIBAC_NEED_EXTERN_C],
	      [Define if extern "C" is required for including <zlib.h> in
	       C++ programs])
  AC_CACHE_VAL(zlibac_cv_need_extern_c, [
	AC_TRY_LINK([
		#include <zlib.h>
	], [
		gzFile gz = gzopen("test", "r");
		gzclose(gz);
	], [
	  zlibac_cv_need_extern_c=no
	], [
	  zlibac_cv_need_extern_c=yes
	])
  ])
  AC_MSG_RESULT($zlibac_cv_need_extern_c)
  if test $zlibac_cv_need_extern_c = yes; then
    AC_DEFINE(ZLIBAC_NEED_EXTERN_C)
  fi

  AC_LANG_POP([C++])
])

dnl *****************************************************************
dnl ZLIBAC_GZ_FUNC	Test for zlib gz* functions
dnl
dnl	Results:	zlibac_cv_have_* and ZLIBAC_HAVE_*
dnl			defined if the corresponding function is 
dnl			available.
dnl
AC_DEFUN([ZLIBAC_GZ_FUNC], [
  AC_LANG_PUSH([C])

  AC_CHECK_FUNC(gzprintf, zlibac_cv_have_gzprintf=yes, zlibac_cv_have_gzprintf=no)
  AH_TEMPLATE([ZLIBAC_HAVE_GZPRINTF], [Define if gzprintf is available.])
  if test $zlibac_cv_have_gzprintf = yes; then
    AC_DEFINE(ZLIBAC_HAVE_GZPRINTF)
  fi

  AC_CHECK_FUNC(gzputc, zlibac_cv_have_gzputc=yes, zlibac_cv_have_gzputc=no)
  AH_TEMPLATE([ZLIBAC_HAVE_GZPUTC], [Define if gzputc is available.])
  if test $zlibac_cv_have_gzputc = yes; then
    AC_DEFINE(ZLIBAC_HAVE_GZPUTC)
  fi

  AC_CHECK_FUNC(gzgetc, zlibac_cv_have_gzgetc=yes, zlibac_cv_have_gzgetc=no)
  AH_TEMPLATE([ZLIBAC_HAVE_GZGETC], [Define if gzgetc is available.])
  if test $zlibac_cv_have_gzgetc = yes; then
    AC_DEFINE(ZLIBAC_HAVE_GZGETC)
  fi

  AC_CHECK_FUNC(gzputs, zlibac_cv_have_gzputs=yes, zlibac_cv_have_gzputs=no)
  AH_TEMPLATE([ZLIBAC_HAVE_GZPUTS], [Define if gzputs is available.])
  if test $zlibac_cv_have_gzputs = yes; then
    AC_DEFINE(ZLIBAC_HAVE_GZPUTS)
  fi

  AC_CHECK_FUNC(gzgets, zlibac_cv_have_gzgets=yes, zlibac_cv_have_gzgets=no)
  AH_TEMPLATE([ZLIBAC_HAVE_GZGETS], [Define if gzgets is available.])
  if test $zlibac_cv_have_gzgets = yes; then
    AC_DEFINE(ZLIBAC_HAVE_GZGETS)
  fi

  AC_CHECK_FUNC(gzeof, zlibac_cv_have_gzeof=yes, zlibac_cv_have_gzeof=no)
  AH_TEMPLATE([ZLIBAC_HAVE_GZEOF], [Define if gzeof is available.])
  if test $zlibac_cv_have_gzeof = yes; then
    AC_DEFINE(ZLIBAC_HAVE_GZEOF)
  fi

  AC_LANG_POP([C])
])


dnl *****************************************************************
dnl  End of zlib Tests for Autoconf
dnl *****************************************************************

