dnl *****************************************************************
dnl  C++ Tests for Autoconf
dnl  (c) 1997,1998,1999,2000,2001,2002 by Kriang Lerdsuwanakij
dnl  lerdsuwa@users.sourceforge.net
dnl
dnl  This program is free software; you can redistribute it and/or modify
dnl  it under the terms of the GNU General Public License as published by
dnl  the Free Software Foundation; either version 2 of the License, or
dnl  (at your option) any later version.
dnl
dnl  This program is distributed in the hope that it will be useful,
dnl  but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl  GNU General Public License for more details.
dnl
dnl  As a special exception, the file `configure' generated by
dnl  `autoconf' from this file is not covered by the GNU General Public 
dnl  License.  This exception does not however invalidate any other
dnl  reasons why the generated file might be covered by the GNU General 
dnl  Public License.
dnl
dnl  You should have received a copy of the GNU General Public License
dnl  along with this program; if not, write to the Free Software
dnl  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
dnl

dnl *****************************************************************
dnl  History before ChangeLog records:
dnl  Version 0.11.0 (Sep 8, 2001)
dnl		- Add CXXAC_BAD_NEW, CXXAC_HEADER_MACRO
dnl		- Update to autoconf 2.53
dnl
dnl  Version 0.10.5 (Jul 6, 2001)
dnl		- Update comments with the release of gcc 2.95, 3.0
dnl
dnl  Version 0.10.4 (Dec 13, 1999)
dnl		- Add CXXAC_SIZE_BOOL
dnl
dnl  Version 0.10.3 (Feb 17, 1999)
dnl		- Change CXXAC_GUIDE_DECL and its variables
dnl		  and macros to CXXAC_NO_GUIDE_DECL
dnl
dnl  Version 0.10.2 (Jan 6, 1999)
dnl		- Change for loop to do while loop in
dnl		  CXXAC_NEW_THROW_BAD_ALLOC test
dnl
dnl  Version 0.10.1 (May 27, 1998)
dnl		- Fix error in namespace test
dnl		- Check iostream library before displaying test 
dnl		  message in using namespace std test.
dnl		- Remove extra '$' in using namespace std test
dnl
dnl  Version 0.10.0 (Mar 5, 1998)
dnl		- Add CXXAC_BAD_ALLOC, CXXAC_NEW_THROW_BAD_ALLOC
dnl
dnl  Version 0.9.0 (Mar 3, 1998)
dnl		- Add CXXAC_HAVE_TYPENAME
dnl		- Add CXXAC_GUIDE_DECL
dnl		- Rename macros _CXX_* to CXX__*.
dnl		- Rename CXXAC_HAVE_MEMBER_TEMPLATE to
dnl		  CXXAC_HAVE_MEMBER_FUNCTION_TEMPLATE
dnl  Version 0.8.0 (Mar 1, 1998)
dnl		- Append space to cxxac_cv_header_need_ext and
dnl		  cxxac_cv_header_missing output from CXX_HEADER_ALL
dnl		- Move AC_REQUIRE inside CXXAC_LIB_NEED_USING_STD to 
dnl		  avoid corrupted screen output when namespace was not
dnl		  testes
dnl		- Set cxxac_cv_have_header_string inside 
dnl		  CXXAC_LIB_NEED_USING_STD
dnl		- Add CXXAC_STRING_ERASE, CXXAC_TEST_ALL updated
dnl
dnl  Version 0.7.0 (Oct 10, 1997)
dnl		- Add CXXAC_DEFAULT_EXCEPTION
dnl
dnl  Version 0.6.1 (Sep 2, 1997)
dnl		- Fix access problem in member template test
dnl		- Add member template and namespace in 
dnl		  CXXAC_TEST_ALL
dnl
dnl  Version 0.6.0 (Aug 14, 1997)
dnl		- Add CXXAC_HEADER
dnl		- Modify CXXAC_HEADER_ALL to use CXXAC_HEADER
dnl		- Add CXXAC_HAVE_NAMESPACE
dnl		- Add CXXAC_LIB_NEED_USING_STD
dnl		- Fix bug in CXXAC_BAD_DELETE - return value now
dnl		  removed
dnl
dnl  Version 0.5.0 (Aug 8, 1997)
dnl		- First version
dnl
dnl  To do:
dnl		- RTTI (#include<typeinfo>, -frtti, etc.)
dnl		- More exception handling
dnl		- new when there is not enough memory
dnl		- new (nothrow)
dnl		- auto_ptr in #include <memory>
dnl

dnl *****************************************************************
dnl CXXAC_TYPE_WCHAR_T	Test if `wchar_t' is a C++ built-in type.  
dnl			If it fails (cxxac_cv_have_wchar_t = no), 
dnl			you can use CXXAC_DEFINE_WCHAR_T to determine if
dnl			they can be safely defined.
dnl
dnl	Results:	cxxac_cv_have_wchar_t = yes/no
dnl			CXX__HAVE_WCHAR_T defined in header file
dnl				if cxxac_cv_have_wchar_t = yes
dnl
AC_DEFUN([CXXAC_TYPE_WCHAR_T], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])
  AC_MSG_CHECKING([for C++ wchar_t keyword])
  AH_TEMPLATE([CXX__HAVE_WCHAR_T],
	      [Define if C++ wchar_t is found.])

  AC_CACHE_VAL(cxxac_cv_have_wchar_t, [
    AC_TRY_COMPILE([], [wchar_t a = L'a';], [
      cxxac_cv_have_wchar_t=yes
    ], [
      cxxac_cv_have_wchar_t=no
    ])
  ])

  if test $cxxac_cv_have_wchar_t = yes; then
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT(no)
  fi

  if test $cxxac_cv_have_wchar_t = yes; then
    AC_DEFINE(CXX__HAVE_WCHAR_T)
  fi
  AC_LANG_POP([C++])
])

dnl *****************************************************************
dnl CXXAC_TYPE_BOOL	Test if `bool' is a C++ built-in type.  It is
dnl			supported by gcc 2.6.x or newer.
dnl			If it fails (cxxac_cv_have_bool = no), 
dnl			you can use CXXAC_DEFINE_BOOL to determine if
dnl			they can be safely defined.
dnl
dnl	Results:	cxxac_cv_have_bool = yes/no
dnl			CXX__HAVE_BOOL defined in header file
dnl				if cxxac_cv_have_bool = yes
dnl			cxxac_cv_bool_size = sizeof(bool)
dnl				if cxxac_cv_have_bool = yes
dnl
AC_DEFUN([CXXAC_TYPE_BOOL], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])
  AC_MSG_CHECKING([for C++ bool keyword])
  AH_TEMPLATE([CXX__HAVE_BOOL],
	      [Define if C++ bool is found.])

  AC_CACHE_VAL(cxxac_cv_have_bool, [
    AC_TRY_COMPILE([], [

bool ba = true, bb = false;
bool bc = bb;
int  ia = 1, ib = 2;
int  ic = (int)ba;
bool bd = (ia == ib);
if (bd) { ia = 0; }
if (!bd) { ia = 0; }
if (ba && bb) { ia = 0; }
if (ba || bb) { ia = 0; }

    ], [
      cxxac_cv_have_bool=yes
    ], [
      cxxac_cv_have_bool=no
    ])
  ])

  if test $cxxac_cv_have_bool = yes; then
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT(no)
  fi

  if test $cxxac_cv_have_bool = yes; then
    AC_DEFINE(CXX__HAVE_BOOL)
  fi
  AC_LANG_POP([C++])
])

dnl *****************************************************************
dnl CXXAC_SIZE_BOOL	Test the size of `bool'.
dnl
dnl	Results:	cxxac_cv_bool_size = sizeof(bool)
dnl
AC_DEFUN([CXXAC_SIZE_BOOL], [
  AC_REQUIRE([CXXAC_TYPE_BOOL])
  AC_LANG_PUSH([C++])
  AC_MSG_CHECKING([for size of C++ bool])

  if test $cxxac_cv_have_bool = yes; then
    AC_CACHE_VAL(cxxac_cv_bool_size, [
      AC_TRY_RUN([
	#include <stdio.h>
	int main()
	{
	  FILE *f = fopen("cf_cxxac.out", "w");
	  if (f) {
	    fprintf(f, "%d", sizeof(bool));
	    fclose(f);
	    exit(0); 
	  }
	  else
	    exit(1); 
	}
      ], [
	cxxac_cv_bool_size=`cat cf_cxxac.out`
      ], [
	cxxac_cv_bool_size="N/A (error during test)"
      ], [
	cxxac_cv_bool_size="N/A (due to cross-compilation)"
      ])

      rm -f cf_cxxac.out
    ])
  else
    cxxac_cv_bool_size="N/A"
  fi

  AC_MSG_RESULT($cxxac_cv_bool_size)
  AC_LANG_POP([C++])
])

dnl *****************************************************************
dnl CXXAC_DEFINE_BOOL	Test if `bool', `true' and `false' can be
dnl			defined.  Use this macro if you want to use
dnl			`bool' variable type even the compiler don't
dnl			support it.
dnl			If it fails (cxxac_cv_can_define_bool = no)
dnl			there must be symbol conflict somewhere.
dnl
dnl	Results:	cxxac_cv_can_define_bool = yes/no
dnl			CXX__CAN_DEFINE_BOOL defined in header file
dnl				if cxxac_cv_can_define_bool = yes
dnl
AC_DEFUN([CXXAC_DEFINE_BOOL], [
  AC_REQUIRE([CXXAC_TYPE_BOOL])
  AC_LANG_PUSH([C++])
  AH_TEMPLATE([CXX__CAN_DEFINE_BOOL],
	      [Define if bool, true, false can be redefined.])
  AH_VERBATIM([enum bool], [
#ifndef CXX__HAVE_BUILTIN_BOOL
#  ifdef CXX__CAN_DEFINE_BOOL
enum bool { false = 0, true = 1 };
#  endif
#endif
  ])

  if test $cxxac_cv_have_bool = no; then
    AC_MSG_CHECKING([if bool, true and false can be defined])

    AC_CACHE_VAL(cxxac_cv_can_define_bool, [

      AC_TRY_COMPILE([], [int bool = 0,true = 0,false = 1;], [

        AC_TRY_COMPILE([
enum bool { false = 0, true = 1 };
        ], [
bool a = true, b = false;
        ], [
          cxxac_cv_can_define_bool=yes
        ], [
          cxxac_cv_can_define_bool=no
        ])

      ], [
        cxxac_cv_can_define_bool=no
      ])
    ])

    if test $cxxac_cv_can_define_bool = yes; then
      AC_MSG_RESULT(yes)
    else
      AC_MSG_RESULT(no)
    fi

    if test $cxxac_cv_can_define_bool; then
      AC_DEFINE(CXX__CAN_DEFINE_BOOL)
    fi
  fi
  AC_LANG_POP([C++])
])

dnl *****************************************************************
dnl CXXAC_HAVE_EXPLICIT	Test if `explicit' is available.  It is 
dnl			supported by gcc 2.7.x or newer.
dnl			If not supported, workaround is automatically
dnl			provided in your header file after running
dnl			Autoheader.
dnl
dnl	Results:	cxxac_cv_have_explicit = yes/no
dnl			CXX__HAVE_EXPLICIT defined in header file
dnl				if cxxac_cv_have_explicit = yes
dnl
AC_DEFUN([CXXAC_HAVE_EXPLICIT], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])
  AC_MSG_CHECKING([for C++ explicit keyword])
  AH_TEMPLATE([CXX__HAVE_EXPLICIT],
	      [Define if explicit is available.])
  AH_VERBATIM([explicit], [
#ifndef CXX__HAVE_EXPLICIT
#  define explicit		/* Discard `explicit' */
#  define CXX__NO_EXPLICIT	1
#endif
  ])

  AC_CACHE_VAL(cxxac_cv_have_explicit, [
    AC_TRY_COMPILE([

class obj_a {
	private:
		int	b;
	public:
		explicit obj_a(int _b) { b = _b; }
};

    ], [

				// Nothing in function body

    ], [
      AC_TRY_COMPILE([

class obj_a {
	private:
		int	b;
	public:
		explicit obj_a(int _b) { b = _b; }
		void	func(obj_a _a) { b = _a.b; }
};

      ], [

	int	i = 0;
	obj_a	a(1);
	a.func(i);		// Must error here, attempt to convert
				// from type int to class obj_a

      ], [
        cxxac_cv_have_explicit=no
      ], [
        cxxac_cv_have_explicit=yes
      ])
    ], [
      cxxac_cv_have_explicit=no
    ])
  ])

  if test $cxxac_cv_have_explicit = yes; then
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT(no)
  fi

  if test $cxxac_cv_have_explicit = yes; then
    AC_DEFINE(CXX__HAVE_EXPLICIT)
  fi
  AC_LANG_POP([C++])
])

dnl *****************************************************************
dnl CXXAC_HAVE_MUTABLE	Test if `mutable' is available.  It is 
dnl			supported by gcc 2.5.x or newer.
dnl			If not supported, some workaround is 
dnl			provided in your header file after running
dnl			Autoheader.  But you also have to modify your
dnl			source files to cast away const-ness of 
dnl			pointers used to modify the member data.
dnl
dnl	Results:	cxxac_cv_have_mutable = yes/no
dnl			CXX__HAVE_MUTABLE defined in header file
dnl				if cxxac_cv_have_mutable = yes
dnl			CXX__NO_MUTABLE defined in header file
dnl				if cxxac_cv_have_mutable = no
dnl
AC_DEFUN([CXXAC_HAVE_MUTABLE], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])
  AC_MSG_CHECKING([for C++ mutable keyword])
  AH_TEMPLATE([CXX__HAVE_MUTABLE], [Define if mutable is available.])
  AH_VERBATIM([mutable], [
#ifndef CXX__HAVE_MUTABLE
#  define mutable		/* Discard `mutable' */
				/* Change const T * => T * const */
#  define _CXXAC_THIS(T)	T * const cppacThis = (T * const) this;
#  define _CXXAC_THAT(T, P)	T * const cppacThat = (T * const) (P);
#endif
  ])

  AC_CACHE_VAL(cxxac_cv_have_mutable, [
    AC_TRY_COMPILE([

class obj_a {
	private:
		mutable int	b;	// Must OK here
	public:
		obj_a() : b(0) {}
					// Must OK here
		void setb(int _b) const { b = _b; }
};

    ], [

	obj_a	a;
	a.setb(1);		// Must OK here

    ], [
      cxxac_cv_have_mutable=yes
    ], [
      cxxac_cv_have_mutable=no
    ])
  ])

  if test $cxxac_cv_have_mutable = yes; then
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT(no)
  fi

  if test $cxxac_cv_have_mutable = yes; then
    AC_DEFINE(CXX__HAVE_MUTABLE)
  fi
  AC_LANG_POP([C++])
])

dnl *****************************************************************
dnl CXXAC_HAVE_MEMBER_FUNCTION_TEMPLATE
dnl			Test if member function template is available.
dnl			It is supported by gcc 2.8.0 or newer.
dnl
dnl			There is no workaround for this problem.
dnl			Your configure script should report error and
dnl			terminate immediately
dnl
dnl	Results:	cxxac_cv_have_member_template = yes/no
dnl
AC_DEFUN([CXXAC_HAVE_MEMBER_FUNCTION_TEMPLATE], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])
  AC_MSG_CHECKING([for C++ member template])

  AC_CACHE_VAL(cxxac_cv_have_member_template, [
    AC_TRY_COMPILE([

template <class T> class obj_a {
	public:
		T	*b;

		obj_a(T *_b = 0) : b(_b) {}

						// Must OK here
		template <class S> void copy(obj_a<S>& _a)
						{ b = (T *)(_a.b); }
};

class obj_b {
	private:
		int	c;
	public:
		obj_b() : c(0) {}
};

    ], [

	int		a;
	obj_b		b;
	
	obj_a<int>	ptr_a(&a);
	obj_a<obj_b>	ptr_b(&b);	
	ptr_b.copy(ptr_a);			// Must OK here

    ], [
      cxxac_cv_have_member_template=yes
    ], [
      cxxac_cv_have_member_template=no
    ])
  ])

  if test $cxxac_cv_have_member_template = yes; then
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT(no)
  fi

  AC_LANG_POP([C++])
])

dnl *****************************************************************
dnl CXXAC_BAD_FOR	Test if variables declared inside for statement 
dnl			persist after for loop.  The correct behavior is 
dnl			that they do not and is supported by gcc 2.7.x 
dnl			or newer.
dnl
dnl			There is no workaround provided.  If you still
dnl			need the old behavior, use CXXAC_WANT_BAD_FOR
dnl			instead.
dnl
dnl	Results:	cxxac_cv_bad_for = yes/no
dnl
AC_DEFUN([CXXAC_BAD_FOR], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])
  AC_MSG_CHECKING([for scope of variable declared inside for statement])

  AC_CACHE_VAL(cxxac_cv_bad_for, [
    AC_TRY_COMPILE([], [

	for (int i = 0; i < 10; i++)
		;

	for (int i = 0; i < 10; i++)		// Must OK here
		;

    ], [
      cxxac_cv_bad_for=no
    ], [
      cxxac_cv_bad_for=yes
    ])
  ])

  if test $cxxac_cv_bad_for = yes; then
    AC_MSG_RESULT(wrong)
  else
    AC_MSG_RESULT(correct)
  fi

  AC_LANG_POP([C++])
])

dnl *****************************************************************
dnl CXXAC_WANT_BAD_FOR	Same as CXXAC_BAD_FOR but also add 
dnl			`-fno-for-scope' if the compiler support it
dnl			(works only with gcc).
dnl
dnl	Results:	cxxac_cv_bad_for = yes/no
dnl			cxxac_cv_bad_for_corrected = yes/no
dnl				if cxxac_cv_bad_for = yes
dnl
AC_DEFUN([CXXAC_WANT_BAD_FOR], [
  AC_REQUIRE([CXXAC_WANT_BAD_FOR])
  AC_LANG_PUSH([C++])
  if test $cxxac_cv_bad_for = yes; then

    AC_MSG_CHECKING([if old for variable scope can be obtained])
    cxxac_save_CXXFLAGS="$CXXFLAGS"

    AC_CACHE_VAL(cxxac_cv_bad_for_corrected, [
      CXXFLAGS="$CXXFLAGS -fno-for-scope"

      if test $GXX = yes; then
        AC_TRY_COMPILE([], [

	for (int i = 0; i < 10; i++)
		;

	for (int i = 0; i < 10; i++)		// Must error here
		;

        ], [
          cxxac_cv_bad_for_corrected=no
        ], [
          cxxac_cv_bad_for_corrected=yes
        ])
      else
        cxxac_cv_bad_for_corrected=no
      fi

    ])

    if test $cxxac_cv_bad_for_corrected = yes; then
      AC_MSG_RESULT(yes)
dnl						Keep -fno-for-scope
    else
      AC_MSG_RESULT(no)
dnl						Don't keep -fno-for-scope
      CXXFLAGS="$cxxac_save_CXXFLAGS"
    fi

  fi
  AC_LANG_POP([C++])
])

dnl *****************************************************************
dnl CXXAC_HAVE_ARRAY_NEW
dnl			Test if operator new[](size_t) is supported.  
dnl			If not supported, you don't have to replace
dnl			the array version of new.
dnl
dnl	Results:	cxxac_cv_have_array_new = yes/no
dnl			CXX__HAVE_ARRAY_NEW defined in header file
dnl				if cxxac_cv_have_array_new = yes
dnl
AC_DEFUN([CXXAC_HAVE_ARRAY_NEW], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])

  AC_MSG_CHECKING([for C++ array new replacement])
  AH_TEMPLATE([CXX__HAVE_ARRAY_NEW], [
changequote(<<, >>)dnl
	      Define if void *operator new[](size_t) is supported.
changequote([, ])dnl
  ])

  AC_CACHE_VAL(cxxac_cv_have_array_new, [
    AC_TRY_COMPILE(
changequote(<<, >>)dnl
    <<

					// Should check & use size_t

void *operator new[](unsigned n)	// Must OK here
{
	return 0;
}

    >>,
changequote([, ])dnl
    [

				// Nothing in function body

    ], [
      cxxac_cv_have_array_new=yes
    ], [
      cxxac_cv_have_array_new=no
    ])
  ])

  if test $cxxac_cv_have_array_new = yes; then
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT(no)
  fi

  if test $cxxac_cv_have_array_new = yes; then
    AC_DEFINE(CXX__HAVE_ARRAY_NEW)
  fi
  AC_LANG_POP([C++])
])

dnl *****************************************************************
dnl CXXAC_HAVE_PLACEMENT_NEW
dnl			Test if operator new(size_t,void *) is supported.  
dnl			If not supported, you don't have to replace
dnl			the placement version of new.
dnl
dnl	Results:	cxxac_cv_have_placement_new = yes/no
dnl			CXX__HAVE_PLACEMENT_NEW defined in header file
dnl				if cxxac_cv_have_place_new = yes
dnl
AC_DEFUN([CXXAC_HAVE_PLACEMENT_NEW], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])
  AC_MSG_CHECKING([for C++ new(size_t,void *) replacement])
  AH_TEMPLATE([CXX__HAVE_PLACEMENT_NEW], [
changequote(<<, >>)dnl
	      Define if void *operator new[](size_t, void *) is supported.
changequote([, ])dnl
  ])

  AC_CACHE_VAL(cxxac_cv_have_placement_new, [
    AC_TRY_COMPILE([

					// Should check & use size_t

void *operator new(unsigned n,void *p)	// Must OK here
{
	return p;
}

    ], [

				// Nothing in function body

    ], [
      cxxac_cv_have_placement_new=yes
    ], [
      cxxac_cv_have_placement_new=no
    ])
  ])

  if test $cxxac_cv_have_placement_new = yes; then
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT(no)
  fi

  if test $cxxac_cv_have_placement_new = yes; then
    AC_DEFINE(CXX__HAVE_PLACEMENT_NEW)
  fi
  AC_LANG_POP([C++])
])

dnl *****************************************************************
dnl CXXAC_BAD_NEW	Test if operator new and new[] does not 
dnl			support `throw(std::bad_alloc)' exception
dnl			specification.  
dnl			If not supported, no throw(...) is needed.
dnl
dnl	Results:	cxxac_cv_bad_new = yes/no
dnl			CXX__NEW_NO_THROW defined in header file
dnl				if cxxac_cv_bad_new = yes
dnl
AC_DEFUN([CXXAC_BAD_NEW], [
  AC_REQUIRE([CXXAC_BAD_ALLOC])
  AC_LANG_PUSH([C++])
  AC_MSG_CHECKING([for C++ exception specification for new])
  AH_TEMPLATE([CXX__NEW_NO_THROW],
	      [Define if new cannot accept exception specification.])
  AH_VERBATIM([CXX__NEW_THROW], [
#if !defined(CXX__NEW_NO_THROW) && defined(CXX__BAD_ALLOC) \
    && defined(CXX__NEW_THROW_BAD_ALLOC)
#  define CXX__NEW_THROW	throw()
#else
#  define CXX__NEW_THROW
#endif
  ])

  AC_CACHE_VAL(cxxac_cv_bad_new, [
    AC_TRY_COMPILE([
void operator new(void *p) throw(std::bad_alloc) // Must OK here
{
}

    ], [

				// Nothing in function body

    ], [
      cxxac_cv_bad_new=no
    ], [
      cxxac_cv_bad_new=yes
    ])
  ])

dnl Message printed is the reverse of $cxxac_cv_bad_new
  if test $cxxac_cv_bad_new = yes; then
    AC_MSG_RESULT(no)
  else
    AC_MSG_RESULT(yes)
  fi

  if test $cxxac_cv_bad_new = yes; then
    AC_DEFINE(CXX__NEW_NO_THROW)
  fi
  AC_LANG_POP([C++])
])

dnl *****************************************************************
dnl CXXAC_BAD_DELETE	Test if operator delete and delete[] does not 
dnl			support `throw()' exception specification.  
dnl			throw() is required by gcc 2.8.x or newer.
dnl			If not supported, no throw() is needed.
dnl
dnl	Results:	cxxac_cv_bad_delete = yes/no
dnl			CXX__DELETE_NO_THROW defined in header file
dnl				if cxxac_cv_bad_delete = yes
dnl
AC_DEFUN([CXXAC_BAD_DELETE], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])
  AC_MSG_CHECKING([for C++ exception specification for delete])
  AH_TEMPLATE([CXX__DELETE_NO_THROW],
	      [Define if delete cannot accept exception specification.])
  AH_VERBATIM([CXX__DELETE_THROW], [
#ifndef CXX__DELETE_NO_THROW
#  define CXX__DELETE_THROW	throw()
#else
#  define CXX__DELETE_THROW
#endif
  ])

  AC_CACHE_VAL(cxxac_cv_bad_delete, [
    AC_TRY_COMPILE([
void operator delete(void *p) throw()	// Must OK here
{
}

    ], [

				// Nothing in function body

    ], [
      cxxac_cv_bad_delete=no
    ], [
      cxxac_cv_bad_delete=yes
    ])
  ])

dnl Message printed is the reverse of $cxxac_cv_bad_delete
  if test $cxxac_cv_bad_delete = yes; then
    AC_MSG_RESULT(no)
  else
    AC_MSG_RESULT(yes)
  fi

  if test $cxxac_cv_bad_delete = yes; then
    AC_DEFINE(CXX__DELETE_NO_THROW)
  fi
  AC_LANG_POP([C++])
])

dnl *****************************************************************
dnl CXXAC_HAVE_NAMESPACE
dnl			Test if namespace is supported.  It is
dnl			supported by gcc 2.95.x or newer
dnl			and egcs 1.1.
dnl
dnl	Results:	cxxac_cv_have_namespace = yes/no
dnl			CXX__HAVE_NAMESPACE defined in header file
dnl				if cxxac_cv_have_namespace = yes
dnl
AC_DEFUN([CXXAC_HAVE_NAMESPACE], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])
  AC_MSG_CHECKING([for C++ namespace])
  AH_TEMPLATE([CXX__HAVE_NAMESPACE], [Define if namespace is available.])

  AC_CACHE_VAL(cxxac_cv_have_namespace, [
    AC_TRY_COMPILE([

namespace N1 { int a; }		// original-namespace-definition
namespace N1 { int b; }		// extension-namespace-definition
namespace { int c; }		// unnamed-namespace-definition
namespace N2 = N1;		// namespace-alias-definition

namespace N3 { int d; }
namespace N4 { typedef int e; typedef long f; }
namespace N5 { namespace N6 { int g; } }

int	ia = N1::a;		// qualified-namespace-specifier
int	ib = ::N1::a;		// qualified-namespace-specifier w/ ::(opt)
int	ic = N5::N6::g;		// qualified-namespace-specifier w/
				//  nested-name-specifier(opt)

using namespace N3;		// using-directive
using N4::e;			// using-declaration
using ::N4::f;			// using-declaration w/ ::(opt)

e	ea;
f	fa;

    ], [

				// Nothing in function body

    ], [
      cxxac_cv_have_namespace=yes
    ], [
      cxxac_cv_have_namespace=no
    ])
  ])

  if test $cxxac_cv_have_namespace = yes; then
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT(no)
  fi

  if test $cxxac_cv_have_namespace = yes; then
    AC_DEFINE(CXX__HAVE_NAMESPACE)
  fi
  AC_LANG_POP([C++])
])

dnl *****************************************************************
dnl CXXAC_DEFAULT_EXCEPTION
dnl			Test if exception handling is on by default.
dnl			It is supported by gcc 2.8.0 or newer.
dnl
dnl	Results:	cxxac_cv_default_exception = yes/no
dnl			CXX__DEFAULT_EXCEPTION defined in header file
dnl				if cxxac_cv_default_exception = yes
dnl
AC_DEFUN([CXXAC_DEFAULT_EXCEPTION], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])
  AC_MSG_CHECKING([if exception handling is on by default])
  AH_TEMPLATE([CXX__DEFAULT_EXCEPTION],
	      [Define if exception handling is on by default.])

  AC_CACHE_VAL(cxxac_cv_default_exception, [

    AC_TRY_COMPILE([
    ], [

try {
	throw 1;
}
catch (...) {
	throw;
}

    ], [
      cxxac_cv_default_exception=yes
    ], [
      cxxac_cv_default_exception=no
    ])
  ])

  AC_MSG_RESULT($cxxac_cv_default_exception)
  if test $cxxac_cv_default_exception = yes; then
    AC_DEFINE(CXX__DEFAULT_EXCEPTION)
  fi

  AC_LANG_POP([C++])
])

dnl *****************************************************************
dnl CXXAC_HAVE_TYPENAME
dnl			Test if the typename keyword works.
dnl			It is supported by gcc 2.8.0 or newer.
dnl
dnl	Results:	cxxac_cv_have_typename = yes/no
dnl			CXX__HAVE_TYPENAME defined in header file
dnl				if cxxac_cv_have_typename = yes
dnl
AC_DEFUN([CXXAC_HAVE_TYPENAME], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])
  AC_MSG_CHECKING([for C++ typename keyword])
  AH_TEMPLATE([CXX__HAVE_TYPENAME],
	      [Define if typename is available.])
  AH_VERBATIM([TYPENAME], [
#ifdef CXX__HAVE_TYPENAME
#  define TYPENAME typename
#else
#  define TYPENAME
#endif
  ])

  AC_CACHE_VAL(cxxac_cv_have_typename, [

    AC_TRY_COMPILE([

class A {
	public:
		typedef int type;
		int value;
};

template <class T> class C {
	public:
		int f () {
			typename T::type p;
			return sizeof p;
		}
};

    ], [

C<A> c;
c.f();

    ], [
      cxxac_cv_have_typename=yes
    ], [
      cxxac_cv_have_typename=no
    ])
  ])

  AC_MSG_RESULT($cxxac_cv_have_typename)
  if test $cxxac_cv_have_typename = yes; then
    AC_DEFINE(CXX__HAVE_TYPENAME)
  fi

  AC_LANG_POP([C++])
])


dnl *****************************************************************
dnl CXXAC_NO_GUIDE_DECL
dnl			Test if ordinary function declaration will not
dnl			guide the compiler to instantiate the template
dnl			version of the function.
dnl			It is supported by gcc 2.8.0 or newer.
dnl
dnl	Results:	cxxac_cv_no_guide_decl = yes/no
dnl			CXX__NO_GUIDE_DECL defined in header file
dnl				if cxxac_cv_no_guide_decl = yes
dnl
AC_DEFUN([CXXAC_NO_GUIDE_DECL], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])
  AC_MSG_CHECKING([if C++ guided declaration for template function disabled])
  AH_TEMPLATE([CXX__NO_GUIDE_DECL],
	      [Define if guided declaration is used.])
  AH_VERBATIM([LEFTRIGHT], [
#ifndef CXX__NO_GUIDE_DECL
#  define LEFTRIGHT
#else
#  define LEFTRIGHT <>
#endif
  ])

  AC_CACHE_VAL(cxxac_cv_no_guide_decl, [

    AC_TRY_COMPILE([

template <class T> int f(T &t);

template <class T> class C {
		int value;
	public:
		friend int f<>(T &);
};

    ], [

    ], [
      cxxac_cv_no_guide_decl=yes
    ], [
      cxxac_cv_no_guide_decl=no
    ])
  ])

  AC_MSG_RESULT($cxxac_cv_no_guide_decl)
  if test $cxxac_cv_no_guide_decl = yes; then
    AC_DEFINE(CXX__NO_GUIDE_DECL)
  fi

  AC_LANG_POP([C++])
])



dnl *****************************************************************
dnl CXXAC_LIB_NEED_USING_STD
dnl			Test if library supports using namespace std.  
dnl			It is supported by libg++ 2.7.x or newer.
dnl
dnl	Results:	cxxac_cv_lib_need_using_std = yes/no
dnl			CXX__LIB_NEED_USING_STD defined in header file
dnl				if cxxac_cv_lib_need_using_std = yes
dnl			cxxac_using_namespace_std = "" or 
dnl				"using namespace std;"
dnl
dnl	[lib.contents]
dnl
AC_DEFUN([CXXAC_LIB_NEED_USING_STD], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])

  AC_REQUIRE([CXXAC_HAVE_NAMESPACE])

  dnl avoid broken message
  CXXAC_HEADER(iostream)

  AC_MSG_CHECKING([if using namespace std supported by C++ library])
  AH_TEMPLATE([CXX__LIB_NEED_USING_STD],
	      [Define if using namespace std; is required by the library.])
  AH_VERBATIM([USING_NAMESPACE_STD], [
#ifdef CXX__LIB_NEED_USING_STD
# define USING_NAMESPACE_STD using namespace std
#else
# define USING_NAMESPACE_STD
#endif
  ])

  AC_CACHE_VAL(cxxac_cv_lib_need_using_std, [
    if test $cxxac_cv_have_namespace = yes; then

      AC_TRY_COMPILE([

#include CXX__HEADER_iostream
using namespace std;

      ], [

cout << '\n';

      ], [
        cxxac_cv_lib_need_using_std=yes
      ], [
        cxxac_cv_lib_need_using_std=no
      ])

    else
      cxxac_cv_lib_need_using_std=no
    fi
  ])

  AC_MSG_RESULT($cxxac_cv_lib_need_using_std)
  if test $cxxac_cv_lib_need_using_std = yes; then
    AC_DEFINE(CXX__LIB_NEED_USING_STD)
    cxxac_using_namespace_std="using namespace std;"
  else
    AC_DEFINE(USING_NAMESPACE_STD)
    cxxac_using_namespace_std=""
  fi

  AC_LANG_POP([C++])
])


dnl *****************************************************************
dnl CXXAC_HEADER_MACRO	Set macros inside config.h.in.
dnl
AC_DEFUN([CXXAC_HEADER_MACRO], [
  AH_TEMPLATE([CXX__HAVE_HEADER_algorithm], [Define if header algorithm is available.])
  AH_TEMPLATE([CXX__HEADER_algorithm], [Define if header algorithm is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_bitset], [Define if header bitset is available.])
  AH_TEMPLATE([CXX__HEADER_bitset], [Define if header bitset is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_complex], [Define if header complex is available.])
  AH_TEMPLATE([CXX__HEADER_complex], [Define if header complex is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_deque], [Define if header deque is available.])
  AH_TEMPLATE([CXX__HEADER_deque], [Define if header deque is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_exception], [Define if header exception is available.])
  AH_TEMPLATE([CXX__HEADER_exception], [Define if header exception is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_fstream], [Define if header fstream is available.])
  AH_TEMPLATE([CXX__HEADER_fstream], [Define if header fstream is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_functional], [Define if header functional is available.])
  AH_TEMPLATE([CXX__HEADER_functional], [Define if header functional is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_iomanip], [Define if header iomanip is available.])
  AH_TEMPLATE([CXX__HEADER_iomanip], [Define if header iomanip is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_ios], [Define if header ios is available.])
  AH_TEMPLATE([CXX__HEADER_ios], [Define if header ios is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_iofwd], [Define if header iofwd is available.])
  AH_TEMPLATE([CXX__HEADER_iofwd], [Define if header iofwd is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_iostream], [Define if header iostream is available.])
  AH_TEMPLATE([CXX__HEADER_iostream], [Define if header iostream is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_istream], [Define if header istream is available.])
  AH_TEMPLATE([CXX__HEADER_istream], [Define if header istream is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_iterator], [Define if header iterator is available.])
  AH_TEMPLATE([CXX__HEADER_iterator], [Define if header iterator is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_limits], [Define if header limits is available.])
  AH_TEMPLATE([CXX__HEADER_limits], [Define if header limits is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_list], [Define if header list is available.])
  AH_TEMPLATE([CXX__HEADER_list], [Define if header list is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_locale], [Define if header locale is available.])
  AH_TEMPLATE([CXX__HEADER_locale], [Define if header locale is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_map], [Define if header map is available.])
  AH_TEMPLATE([CXX__HEADER_map], [Define if header map is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_memory], [Define if header memory is available.])
  AH_TEMPLATE([CXX__HEADER_memory], [Define if header memory is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_new], [Define if header new is available.])
  AH_TEMPLATE([CXX__HEADER_new], [Define if header new is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_numeric], [Define if header numeric is available.])
  AH_TEMPLATE([CXX__HEADER_numeric], [Define if header numeric is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_ostream], [Define if header ostream is available.])
  AH_TEMPLATE([CXX__HEADER_ostream], [Define if header ostream is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_queue], [Define if header queue is available.])
  AH_TEMPLATE([CXX__HEADER_queue], [Define if header queue is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_set], [Define if header set is available.])
  AH_TEMPLATE([CXX__HEADER_set], [Define if header set is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_sstream], [Define if header sstream is available.])
  AH_TEMPLATE([CXX__HEADER_sstream], [Define if header sstream is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_stack], [Define if header stack is available.])
  AH_TEMPLATE([CXX__HEADER_stack], [Define if header stack is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_stdexcept], [Define if header stdexcept is available.])
  AH_TEMPLATE([CXX__HEADER_stdexcept], [Define if header stdexcept is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_streambuf], [Define if header streambuf is available.])
  AH_TEMPLATE([CXX__HEADER_streambuf], [Define if header streambuf is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_string], [Define if header string is available.])
  AH_TEMPLATE([CXX__HEADER_string], [Define if header string is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_typeinfo], [Define if header typeinfo is available.])
  AH_TEMPLATE([CXX__HEADER_typeinfo], [Define if header typeinfo is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_utility], [Define if header utility is available.])
  AH_TEMPLATE([CXX__HEADER_utility], [Define if header utility is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_valarray], [Define if header valarray is available.])
  AH_TEMPLATE([CXX__HEADER_valarray], [Define if header valarray is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_vector], [Define if header vector is available.])
  AH_TEMPLATE([CXX__HEADER_vector], [Define if header vector is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_cassert], [Define if header cassert is available.])
  AH_TEMPLATE([CXX__HEADER_cassert], [Define if header cassert is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_cctype], [Define if header cctype is available.])
  AH_TEMPLATE([CXX__HEADER_cctype], [Define if header cctype is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_cerrno], [Define if header cerrno is available.])
  AH_TEMPLATE([CXX__HEADER_cerrno], [Define if header cerrno is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_cfloat], [Define if header cfloat is available.])
  AH_TEMPLATE([CXX__HEADER_cfloat], [Define if header cfloat is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_ciso646], [Define if header ciso646 is available.])
  AH_TEMPLATE([CXX__HEADER_ciso646], [Define if header ciso646 is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_climits], [Define if header climits is available.])
  AH_TEMPLATE([CXX__HEADER_climits], [Define if header climits is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_clocale], [Define if header clocale is available.])
  AH_TEMPLATE([CXX__HEADER_clocale], [Define if header clocale is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_cmath], [Define if header cmath is available.])
  AH_TEMPLATE([CXX__HEADER_cmath], [Define if header cmath is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_csetjmp], [Define if header csetjmp is available.])
  AH_TEMPLATE([CXX__HEADER_csetjmp], [Define if header csetjmp is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_csignal], [Define if header csignal is available.])
  AH_TEMPLATE([CXX__HEADER_csignal], [Define if header csignal is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_cstdarg], [Define if header cstdarg is available.])
  AH_TEMPLATE([CXX__HEADER_cstdarg], [Define if header cstdarg is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_cstddef], [Define if header cstddef is available.])
  AH_TEMPLATE([CXX__HEADER_cstddef], [Define if header cstddef is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_cstdio], [Define if header cstdio is available.])
  AH_TEMPLATE([CXX__HEADER_cstdio], [Define if header cstdio is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_cstdlib], [Define if header cstdlib is available.])
  AH_TEMPLATE([CXX__HEADER_cstdlib], [Define if header cstdlib is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_cstring], [Define if header cstring is available.])
  AH_TEMPLATE([CXX__HEADER_cstring], [Define if header cstring is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_ctime], [Define if header ctime is available.])
  AH_TEMPLATE([CXX__HEADER_ctime], [Define if header ctime is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_cwchar], [Define if header cwchar is available.])
  AH_TEMPLATE([CXX__HEADER_cwchar], [Define if header cwchar is available.])
  AH_TEMPLATE([CXX__HAVE_HEADER_cwctype], [Define if header cwctype is available.])
  AH_TEMPLATE([CXX__HEADER_cwctype], [Define if header cwctype is available.])
])

dnl *****************************************************************
dnl CXXAC_HEADER	Test if the specified C++ and C library header 
dnl			is available.  
dnl			It is supported by gcc 3.x or newer.
dnl
dnl	Results:	cxxac_cv_have_header_xxx = yes/no/need_h
dnl			If cxxac_cv_have_header_xxx = yes/need_h, then
dnl				CXX__HAVE_HEADER_xxx defined in header file
dnl				                     to be 0 (need .h)
dnl				                     or 1 (OK)
dnl				cxxac_cv_header_xxx = header name found
dnl				CXX__HEADER_xxx defined as header name
dnl
AC_DEFUN([CXXAC_HEADER], [
  if eval "test \"\$cxxac_done_header_$1\" != yes"; then

    AC_REQUIRE([AC_PROG_CXX])
    AC_REQUIRE([CXXAC_HEADER_MACRO])
    AC_LANG_PUSH([C++])

    dnl $2 can be empty
    if test "$2" != quiet; then
      AC_MSG_CHECKING([for C++ library header $1])
    fi

    AC_CACHE_VAL(cxxac_cv_have_header_$1, [
      AC_TRY_CPP([#include <$1>], [
        eval "cxxac_cv_have_header_$1=yes"
      ], [
        AC_TRY_CPP([#include <$1.h>], [
          eval "cxxac_cv_have_header_$1=need_h"
        ], [
          eval "cxxac_cv_have_header_$1=no"
        ])
      ]);
    ])

    eval "cxxac_cv_have_header=\$cxxac_cv_have_header_$1"
    if test $cxxac_cv_have_header = yes; then
      cxxac_result=yes
      eval "cxxac_cv_header_$1=$1"
      AC_DEFINE_UNQUOTED(CXX__HAVE_HEADER_$1,1)
      AC_DEFINE_UNQUOTED(CXX__HEADER_$1,<$1>)
    elif test $cxxac_cv_have_header = need_h; then
      cxxac_result="need .h"
      eval "cxxac_cv_header_$1=$1.h"
      AC_DEFINE_UNQUOTED(CXX__HAVE_HEADER_$1,0)
      AC_DEFINE_UNQUOTED(CXX__HEADER_$1,<$1.h>)
    else
      cxxac_result=no
      eval "cxxac_cv_header_$1="
    fi

    dnl $2 can be empty
    if test "$2" != quiet; then
      AC_MSG_RESULT($cxxac_result)
    fi

    AC_LANG_POP([C++])
    eval "cxxac_done_header_$1=yes"

  fi
])


dnl *****************************************************************
dnl CXXAC_HEADER_ALL	Test if all C++ and C library header is
dnl			available.  
dnl			It is supported by gcc 3.x or newer.
dnl
dnl	Results:	cxxac_cv_have_all_header = yes/no
dnl			CXX__HAVE_ALL_HEADER defined in header file
dnl				if cxxac_cv_have_all_header = yes
dnl			cxxac_cv_header_need_ext = list of files that
dnl						   require `.h' extension
dnl			cxxac_cv_missing = list of files that is
dnl			                   cannot be found even
dnl			                   with `.h' added
dnl
AC_DEFUN([CXXAC_HEADER_ALL], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])
  AC_MSG_NOTICE(checking for all C++ library header)
  AH_TEMPLATE([CXX__HAVE_ALL_HEADER],
	      [Define if all C++ and C library header is available.])

  cxxac_file="algorithm bitset complex deque exception fstream functional"
  cxxac_file="$cxxac_file iomanip ios iosfwd iostream istream iterator limits"
  cxxac_file="$cxxac_file list locale map memory new numeric"
  cxxac_file="$cxxac_file ostream queue set sstream stack stdexcept"
  cxxac_file="$cxxac_file streambuf string typeinfo utility valarray vector"
  cxxac_file="$cxxac_file cassert cctype cerrno cfloat"
  cxxac_file="$cxxac_file ciso646 climits clocale cmath"
  cxxac_file="$cxxac_file csetjmp csignal cstdarg cstddef"
  cxxac_file="$cxxac_file cstdio cstdlib cstring ctime cwchar cwctype"

  cxxac_cv_have_all_header=yes
  cxxac_cv_header_need_ext=
  cxxac_cv_header_missing=
  for cxxac_f in $cxxac_file; do
    CXXAC_HEADER($cxxac_f)
    if test $cxxac_cv_have_header != yes; then
      cxxac_cv_have_all_header=no
      if test $cxxac_cv_have_header = need_h; then
        cxxac_cv_header_need_ext="$cxxac_cv_header_need_ext $cxxac_f"
      else
        cxxac_cv_header_missing="$cxxac_cv_header_missing $cxxac_f"
      fi
    fi
  done

  dnl Append a space for easy check later
  cxxac_cv_header_need_ext="$cxxac_cv_header_need_ext "
  cxxac_cv_header_missing="$cxxac_cv_header_missing "

  AC_LANG_POP([C++])
])


dnl *****************************************************************
dnl CXXAC_STRING_ERASE	Test if `string::erase' is available.  It is 
dnl			supported by libstdc++ 2.8.0 or newer.
dnl			If not available, string::remove (in libg++
dnl			before 2.8.0) or string::replace (in all
dnl			versions of libg++/libstdc++) may be used.
dnl
dnl	Results:	cxxac_cv_string_erase = yes/no
dnl			CXX__STRING_ERASE defined in header file
dnl				if cxxac_cv_string_erase = yes
dnl
AC_DEFUN([CXXAC_STRING_ERASE], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])

  AC_REQUIRE([CXXAC_LIB_NEED_USING_STD])
  if test "x$cxxac_cv_have_header_string" = x; then
    CXXAC_HEADER(string)
  fi

  AC_MSG_CHECKING([for C++ string::erase method])
  AH_TEMPLATE([CXX__STRING_ERASE], [Define if string::erase(...) is available.])

  AC_CACHE_VAL(cxxac_cv_string_erase, [

    AC_TRY_COMPILE([

/* Some macro defined in curses.h  */
#undef move
#undef clear
#undef erase

#include <$cxxac_cv_header_string>
$cxxac_using_namespace_std

    ], [

string s("test");
s.erase(0,1);

    ], [
      cxxac_cv_string_erase=yes
    ], [
      cxxac_cv_string_erase=no
    ])
  ])

  if test $cxxac_cv_string_erase = yes; then
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT(no)
  fi

  if test $cxxac_cv_string_erase = yes; then
    AC_DEFINE(CXX__STRING_ERASE)
  fi
  AC_LANG_POP([C++])
])


dnl *****************************************************************
dnl CXXAC_STRING_IO	Test if stream I/O operators for string 
dnl			is available.
dnl
dnl	Results:	cxxac_cv_string_io = yes/no
dnl			CXX__STRING_IO defined in header file
dnl				if cxxac_cv_string_io = yes
dnl
AC_DEFUN([CXXAC_STRING_IO], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])

  AC_REQUIRE([CXXAC_LIB_NEED_USING_STD])
  if test "x$cxxac_cv_have_header_string" = x; then
    CXXAC_HEADER(string)
  fi

  AC_MSG_CHECKING([for stream I/O operators for C++ string])
  AH_TEMPLATE([CXX__STRING_IO], [Define if I/O stream operators for string is available.])

  AC_CACHE_VAL(cxxac_cv_string_io, [

    AC_TRY_COMPILE([

/* Some macro defined in curses.h  */
#undef move
#undef clear
#undef erase

#include <$cxxac_cv_header_string>
$cxxac_using_namespace_std

    ], [

string s("test"), t;
cout << s << '\n';
cin >> t;

    ], [
      cxxac_cv_string_io=yes
    ], [
      cxxac_cv_string_io=no
    ])
  ])

  AC_MSG_RESULT($cxxac_cv_string_io)

  if test $cxxac_cv_string_io = yes; then
    AC_DEFINE(CXX__STRING_IO)
  fi
  AC_LANG_POP([C++])
])


dnl *****************************************************************
dnl CXXAC_BAD_ALLOC	Test if `bad_alloc' is available.  It is 
dnl			supported by gcc 2.95.x or newer and
dnl			egcs 1.1
dnl
dnl	Results:	cxxac_cv_bad_alloc = yes/no
dnl			CXX__BAD_ALLOC defined in header file
dnl				if cxxac_cv_bad_alloc = yes
dnl
AC_DEFUN([CXXAC_BAD_ALLOC], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])

  AC_REQUIRE([CXXAC_LIB_NEED_USING_STD])
  if test "x$cxxac_cv_have_header_new" = x; then
    CXXAC_HEADER(new)
  fi

  AC_REQUIRE([CXXAC_DEFAULT_EXCEPTION])

  AC_MSG_CHECKING([for bad_alloc])
  AH_TEMPLATE([CXX__BAD_ALLOC], [Define if new throws bad_alloc.])

  AC_CACHE_VAL(cxxac_cv_bad_alloc, [

    if test $cxxac_cv_default_exception = yes; then
      AC_TRY_COMPILE([

#include <$cxxac_cv_header_new>
$cxxac_using_namespace_std

bad_alloc b;

      ], [
      ], [
        cxxac_cv_bad_alloc=yes
      ], [
        cxxac_cv_bad_alloc=no
      ])
    else
      cxxac_cv_bad_alloc=no
    fi
  ])

  if test $cxxac_cv_bad_alloc = yes; then
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT(no)
  fi

  if test $cxxac_cv_bad_alloc = yes; then
    AC_DEFINE(CXX__BAD_ALLOC)
  fi
  AC_LANG_POP([C++])
])


dnl *****************************************************************
dnl CXXAC_NEW_THROW_BAD_ALLOC
dnl
dnl			Test if new throws `bad_alloc'.  It is 
dnl			supported by gcc 2.95 or newer
dnl			and egcs 1.1.
dnl
dnl	Results:	cxxac_cv_new_throw_bad_alloc = yes/no
dnl			CXX__NEW_THROW_BAD_ALLOC defined in header file
dnl				if cxxac_cv_new_throw_bad_alloc = yes
dnl
AC_DEFUN([CXXAC_NEW_THROW_BAD_ALLOC], [
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_PUSH([C++])

  AC_REQUIRE([CXXAC_BAD_ALLOC])

  AC_MSG_CHECKING([if new throws bad_alloc])
  AH_TEMPLATE([CXX__NEW_THROW_BAD_ALLOC],
	      [Define if new throws bad_alloc.])

  AC_CACHE_VAL(cxxac_cv_new_throw_bad_alloc, [

    if test $cxxac_cv_bad_alloc = yes; then

      AC_TRY_RUN(

changequote(<<, >>)dnl
      <<

// TEST#1 - Try setting upper limit of memory resource

// If this test fails and returns 3, new[] may try
// to extend the memory limit.  We must proceed to TEST#2

#include <sys/time.h>
#include <sys/resource.h>
#include <unistd.h>

#include <$cxxac_cv_header_new>
$cxxac_using_namespace_std

int main() {
		// Set the upper resource limit.
		// This number must be large enough
		// so that memory can be allocated
		// by stack unwinding code.
	struct rlimit r;
	r.rlim_cur = 50000;
	r.rlim_max = 50000;
	if (setrlimit(RLIMIT_DATA,&r))
		exit(3);		// Unsupported test

	char *c;
	try {
		do {
			c = new char[60000];
		} while (c);
	}
	catch (bad_alloc &) {
		exit(0);
	}
	catch (...) {
		exit(2);		// Wrong exception
	}
	if (c == 0)
		exit(1);		// No throw
	else
		exit(3);		// Unsupported test
}

      >>
changequote([, ])dnl
      , [
        cxxac_cv_new_throw_result=ok
        cxxac_cv_new_throw_bad_alloc=yes
      ], [

        dnl unsupported by TEST#1     
        if test "$?" -eq 3; then

          AC_TRY_RUN(

changequote(<<, >>)dnl
      <<

// TEST#2 - Try exhausting system memory

#include <sys/time.h>
#include <sys/resource.h>
#include <unistd.h>

#include <$cxxac_cv_header_new>
$cxxac_using_namespace_std

int main() {
	char *c;
	try {
		for ( ; ; )
			c = new char[1000000];
	}
	catch (bad_alloc &) {
		return 0;
	}
	catch (...) {
		return 2;		// Wrong exception
	}
	if (c == 0)
		return 1;		// No throw
	else
		return 3;		// Unsupported test
}

      >>
changequote([, ])dnl

          , [
            cxxac_cv_new_throw_result=ok
            cxxac_cv_new_throw_bad_alloc=yes
          ], [
            cxxac_cv_new_throw_result="error $?"
            cxxac_cv_new_throw_bad_alloc=no
          ], [
            cxxac_cv_new_throw_result=cross_compile
            cxxac_cv_new_throw_bad_alloc=no
          ])

        dnl bad result from TEST#1
        else
          cxxac_cv_new_throw_result="error $?"
          cxxac_cv_new_throw_bad_alloc=no
        fi

      ], [
        cxxac_cv_new_throw_result=cross_compile
        cxxac_cv_new_throw_bad_alloc=no
      ])

    else
      cxxac_cv_new_throw_bad_alloc=no
    fi
  ])

  if test $cxxac_cv_new_throw_bad_alloc = yes; then
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT("no $cxxac_cv_new_throw_result")
  fi

  if test $cxxac_cv_new_throw_bad_alloc = yes; then
    AC_DEFINE(CXX__NEW_THROW_BAD_ALLOC)
  fi
  AC_LANG_POP([C++])
])


dnl *****************************************************************
dnl CXXAC_TEST_ALL	Run all test except CXXAC_WANT_xxx and
dnl			untested tests
dnl
dnl	Results:	All of above test
dnl
AC_DEFUN([CXXAC_TEST_ALL], [
  CXXAC_TYPE_WCHAR_T
  CXXAC_TYPE_BOOL
  CXXAC_DEFINE_BOOL

  CXXAC_HAVE_EXPLICIT
  CXXAC_HAVE_MUTABLE

  CXXAC_DEFAULT_EXCEPTION

  CXXAC_HAVE_MEMBER_FUNCTION_TEMPLATE
  CXXAC_HAVE_TYPENAME
  CXXAC_NO_GUIDE_DECL

  CXXAC_HAVE_NAMESPACE
  CXXAC_LIB_NEED_USING_STD

  CXXAC_BAD_FOR

  CXXAC_HAVE_ARRAY_NEW
  CXXAC_HAVE_PLACEMENT_NEW
  CXXAC_BAD_NEW
  CXXAC_BAD_DELETE

  CXXAC_HEADER_ALL

  CXXAC_STRING_ERASE
])

dnl *****************************************************************
dnl  End of C++ Tests for Autoconf
dnl *****************************************************************
