dnl aclocal.m4 generated automatically by aclocal 1.4

dnl Copyright (C) 1994, 1995-8, 1999 Free Software Foundation, Inc.
dnl This file is free software; the Free Software Foundation
dnl gives unlimited permission to copy and/or distribute it,
dnl with or without modifications, as long as this notice is preserved.

dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY, to the extent permitted by law; without
dnl even the implied warranty of MERCHANTABILITY or FITNESS FOR A
dnl PARTICULAR PURPOSE.

dnl *****************************************************************
dnl  C++ Tests for Autoconf
dnl  (c) 1997,1998,1999,2000,2001 by Kriang Lerdsuwanakij
dnl  lerdsuwa@users.sourceforge.net
dnl
dnl  This program is free software; you can redistribute it and/or modify
dnl  it under the terms of the GNU General Public License as published by
dnl  the Free Software Foundation; either version 2 of the License, or
dnl  (at your option) any later version.
dnl
dnl  This program is distributed in the hope that it will be useful,
dnl  but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl  GNU General Public License for more details.
dnl
dnl  As a special exception, the file `configure' generated by
dnl  `autoconf' from this file is not covered by the GNU General Public 
dnl  License.  This exception does not however invalidate any other
dnl  reasons why the generated file might be covered by the GNU General 
dnl  Public License.
dnl
dnl  You should have received a copy of the GNU General Public License
dnl  along with this program; if not, write to the Free Software
dnl  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
dnl

dnl *****************************************************************
dnl  History before ChangeLog records:
dnl  Version 0.10.5 (Jul 6, 2001)
dnl		- Update comments with the release of gcc 2.95, 3.0
dnl
dnl  Version 0.10.4 (Dec 13, 1999)
dnl		- Add CXXAC_SIZE_BOOL
dnl
dnl  Version 0.10.3 (Feb 17, 1999)
dnl		- Change CXXAC_GUIDE_DECL and its variables
dnl		  and macros to CXXAC_NO_GUIDE_DECL
dnl
dnl  Version 0.10.2 (Jan 6, 1999)
dnl		- Change for loop to do while loop in
dnl		  CXXAC_NEW_THROW_BAD_ALLOC test
dnl
dnl  Version 0.10.1 (May 27, 1998)
dnl		- Fix error in namespace test
dnl		- Check iostream library before displaying test 
dnl		  message in using namespace std test.
dnl		- Remove extra '$' in using namespace std test
dnl
dnl  Version 0.10.0 (Mar 5, 1998)
dnl		- Add CXXAC_BAD_ALLOC, CXXAC_NEW_THROW_BAD_ALLOC
dnl
dnl  Version 0.9.0 (Mar 3, 1998)
dnl		- Add CXXAC_HAVE_TYPENAME
dnl		- Add CXXAC_GUIDE_DECL
dnl		- Rename macros _CXX_* to CXX__*.
dnl		- Rename CXXAC_HAVE_MEMBER_TEMPLATE to
dnl		  CXXAC_HAVE_MEMBER_FUNCTION_TEMPLATE
dnl  Version 0.8.0 (Mar 1, 1998)
dnl		- Append space to cxxac_cv_header_need_ext and
dnl		  cxxac_cv_header_missing output from CXX_HEADER_ALL
dnl		- Move AC_REQUIRE inside CXXAC_LIB_NEED_USING_STD to 
dnl		  avoid corrupted screen output when namespace was not
dnl		  testes
dnl		- Set cxxac_cv_have_header_string inside 
dnl		  CXXAC_LIB_NEED_USING_STD
dnl		- Add CXXAC_STRING_ERASE, CXXAC_TEST_ALL updated
dnl
dnl  Version 0.7.0 (Oct 10, 1997)
dnl		- Add CXXAC_DEFAULT_EXCEPTION
dnl
dnl  Version 0.6.1 (Sep 2, 1997)
dnl		- Fix access problem in member template test
dnl		- Add member template and namespace in 
dnl		  CXXAC_TEST_ALL
dnl
dnl  Version 0.6.0 (Aug 14, 1997)
dnl		- Add CXXAC_HEADER
dnl		- Modify CXXAC_HEADER_ALL to use CXXAC_HEADER
dnl		- Add CXXAC_HAVE_NAMESPACE
dnl		- Add CXXAC_LIB_NEED_USING_STD
dnl		- Fix bug in CXXAC_BAD_DELETE - return value now
dnl		  removed
dnl
dnl  Version 0.5.0 (Aug 8, 1997)
dnl		- First version
dnl
dnl  To do:
dnl		- RTTI (#include<typeinfo>, -frtti, etc.)
dnl		- More exception handling
dnl		- new when there is not enough memory
dnl		- new (nothrow)
dnl		- auto_ptr in #include <memory>
dnl

dnl *****************************************************************
dnl CXXAC_TYPE_WCHAR_T	Test if `wchar_t' is a C++ built-in type.  
dnl			If it fails (cxxac_cv_have_wchar_t = no), 
dnl			you can use CXXAC_DEFINE_WCHAR_T to determine if
dnl			they can be safely defined.
dnl
dnl	Results:	cxxac_cv_have_wchar_t = yes/no
dnl			CXX__HAVE_WCHAR_T defined in header file
dnl				if cxxac_cv_have_wchar_t = yes
dnl
AC_DEFUN([CXXAC_TYPE_WCHAR_T], [
  AC_LANG_SAVE
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_CPLUSPLUS
  AC_MSG_CHECKING([for C++ wchar_t keyword])

  AC_CACHE_VAL(cxxac_cv_have_wchar_t, [
    AC_TRY_COMPILE([], [wchar_t a = L'a';], [
      cxxac_cv_have_wchar_t=yes
    ], [
      cxxac_cv_have_wchar_t=no
    ])
  ])

  if test $cxxac_cv_have_wchar_t = yes; then
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT(no)
  fi

  if test $cxxac_cv_have_wchar_t = yes; then
    AC_DEFINE(CXX__HAVE_WCHAR_T)
  fi
  AC_LANG_RESTORE
])

dnl *****************************************************************
dnl CXXAC_TYPE_BOOL	Test if `bool' is a C++ built-in type.  It is
dnl			supported by gcc 2.6.x or newer.
dnl			If it fails (cxxac_cv_have_bool = no), 
dnl			you can use CXXAC_DEFINE_BOOL to determine if
dnl			they can be safely defined.
dnl
dnl	Results:	cxxac_cv_have_bool = yes/no
dnl			CXX__HAVE_BOOL defined in header file
dnl				if cxxac_cv_have_bool = yes
dnl			cxxac_cv_bool_size = sizeof(bool)
dnl				if cxxac_cv_have_bool = yes
dnl
AC_DEFUN([CXXAC_TYPE_BOOL], [
  AC_LANG_SAVE
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_CPLUSPLUS
  AC_MSG_CHECKING([for C++ bool keyword])

  AC_CACHE_VAL(cxxac_cv_have_bool, [
    AC_TRY_COMPILE([], [

bool ba = true, bb = false;
bool bc = bb;
int  ia = 1, ib = 2;
int  ic = (int)ba;
bool bd = (ia == ib);
if (bd) { ia = 0; }
if (!bd) { ia = 0; }
if (ba && bb) { ia = 0; }
if (ba || bb) { ia = 0; }

    ], [
      cxxac_cv_have_bool=yes
    ], [
      cxxac_cv_have_bool=no
    ])
  ])

  if test $cxxac_cv_have_bool = yes; then
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT(no)
  fi

  if test $cxxac_cv_have_bool = yes; then
    AC_DEFINE(CXX__HAVE_BOOL)
  fi
  AC_LANG_RESTORE
])

dnl *****************************************************************
dnl CXXAC_SIZE_BOOL	Test the size of `bool'.
dnl
dnl	Results:	cxxac_cv_bool_size = sizeof(bool)
dnl
AC_DEFUN([CXXAC_SIZE_BOOL], [
  AC_LANG_SAVE
  AC_REQUIRE([CXXAC_TYPE_BOOL])
  AC_MSG_CHECKING([for size of C++ bool])

  if test $cxxac_cv_have_bool = yes; then
    AC_LANG_CPLUSPLUS

    AC_CACHE_VAL(cxxac_cv_bool_size, [
      AC_TRY_RUN([
	#include <stdio.h>
	int main()
	{
	  FILE *f = fopen("cf_cxxac.out", "w");
	  if (f) {
	    fprintf(f, "%d", sizeof(bool));
	    fclose(f);
	    exit(0); 
	  }
	  else
	    exit(1); 
	}
      ], [
	cxxac_cv_bool_size=`cat cf_cxxac.out`
      ], [
	cxxac_cv_bool_size="N/A (error during test)"
      ], [
	cxxac_cv_bool_size="N/A (due to cross-compilation)"
      ])

      rm -f cf_cxxac.out
    ])
  else
    cxxac_cv_bool_size="N/A"
  fi

  AC_MSG_RESULT($cxxac_cv_bool_size)
  AC_LANG_RESTORE
])

dnl *****************************************************************
dnl CXXAC_DEFINE_BOOL	Test if `bool', `true' and `false' can be
dnl			defined.  Use this macro if you want to use
dnl			`bool' variable type even the compiler don't
dnl			support it.
dnl			If it fails (cxxac_cv_can_define_bool = no)
dnl			there must be symbol conflict somewhere.
dnl
dnl	Results:	cxxac_cv_can_define_bool = yes/no
dnl			CXX__CAN_DEFINE_BOOL defined in header file
dnl				if cxxac_cv_can_define_bool = yes
dnl
AC_DEFUN([CXXAC_DEFINE_BOOL], [
  AC_LANG_SAVE
  AC_REQUIRE([CXXAC_TYPE_BOOL])
  if test $cxxac_cv_have_bool = no; then
    AC_LANG_CPLUSPLUS
    AC_MSG_CHECKING([if bool, true and false can be defined])

    AC_CACHE_VAL(cxxac_cv_can_define_bool, [

      AC_TRY_COMPILE([], [int bool = 0,true = 0,false = 1;], [

        AC_TRY_COMPILE([
enum bool { false = 0, true = 1 };
        ], [
bool a = true, b = false;
        ], [
          cxxac_cv_can_define_bool=yes
        ], [
          cxxac_cv_can_define_bool=no
        ])

      ], [
        cxxac_cv_can_define_bool=no
      ])
    ])

    if test $cxxac_cv_can_define_bool = yes; then
      AC_MSG_RESULT(yes)
    else
      AC_MSG_RESULT(no)
    fi

    if test $cxxac_cv_can_define_bool; then
      AC_DEFINE(CXX__CAN_DEFINE_BOOL)
    fi
  fi
  AC_LANG_RESTORE
])

dnl *****************************************************************
dnl CXXAC_HAVE_EXPLICIT	Test if `explicit' is available.  It is 
dnl			supported by gcc 2.7.x or newer.
dnl			If not supported, workaround is automatically
dnl			provided in your header file after running
dnl			Autoheader.
dnl
dnl	Results:	cxxac_cv_have_explicit = yes/no
dnl			CXX__HAVE_EXPLICIT defined in header file
dnl				if cxxac_cv_have_explicit = yes
dnl
AC_DEFUN([CXXAC_HAVE_EXPLICIT], [
  AC_LANG_SAVE
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_CPLUSPLUS
  AC_MSG_CHECKING([for C++ explicit keyword])

  AC_CACHE_VAL(cxxac_cv_have_explicit, [
    AC_TRY_COMPILE([

class obj_a {
	private:
		int	b;
	public:
		explicit obj_a(int _b) { b = _b; }
};

    ], [

				// Nothing in function body

    ], [
      AC_TRY_COMPILE([

class obj_a {
	private:
		int	b;
	public:
		explicit obj_a(int _b) { b = _b; }
		void	func(obj_a _a) { b = _a.b; }
};

      ], [

	int	i = 0;
	obj_a	a(1);
	a.func(i);		// Must error here, attempt to convert
				// from type int to class obj_a

      ], [
        cxxac_cv_have_explicit=no
      ], [
        cxxac_cv_have_explicit=yes
      ])
    ], [
      cxxac_cv_have_explicit=no
    ])
  ])

  if test $cxxac_cv_have_explicit = yes; then
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT(no)
  fi

  if test $cxxac_cv_have_explicit = yes; then
    AC_DEFINE(CXX__HAVE_EXPLICIT)
  fi
  AC_LANG_RESTORE
])

dnl *****************************************************************
dnl CXXAC_HAVE_MUTABLE	Test if `mutable' is available.  It is 
dnl			supported by gcc 2.5.x or newer.
dnl			If not supported, some workaround is 
dnl			provided in your header file after running
dnl			Autoheader.  But you also have to modify your
dnl			source files to cast away const-ness of 
dnl			pointers used to modify the member data.
dnl
dnl	Results:	cxxac_cv_have_mutable = yes/no
dnl			CXX__HAVE_MUTABLE defined in header file
dnl				if cxxac_cv_have_mutable = yes
dnl			CXX__NO_MUTABLE defined in header file
dnl				if cxxac_cv_have_mutable = no
dnl
AC_DEFUN([CXXAC_HAVE_MUTABLE], [
  AC_LANG_SAVE
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_CPLUSPLUS
  AC_MSG_CHECKING([for C++ mutable keyword])

  AC_CACHE_VAL(cxxac_cv_have_mutable, [
    AC_TRY_COMPILE([

class obj_a {
	private:
		mutable int	b;	// Must OK here
	public:
		obj_a() : b(0) {}
					// Must OK here
		void setb(int _b) const { b = _b; }
};

    ], [

	obj_a	a;
	a.setb(1);		// Must OK here

    ], [
      cxxac_cv_have_mutable=yes
    ], [
      cxxac_cv_have_mutable=no
    ])
  ])

  if test $cxxac_cv_have_mutable = yes; then
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT(no)
  fi

  if test $cxxac_cv_have_mutable = yes; then
    AC_DEFINE(CXX__HAVE_MUTABLE)
  fi
  AC_LANG_RESTORE
])

dnl *****************************************************************
dnl CXXAC_HAVE_MEMBER_FUNCTION_TEMPLATE
dnl			Test if member function template is available.
dnl			It is supported by gcc 2.8.0 or newer.
dnl
dnl			There is no workaround for this problem.
dnl			Your configure script should report error and
dnl			terminate immediately
dnl
dnl	Results:	cxxac_cv_have_member_template = yes/no
dnl
AC_DEFUN([CXXAC_HAVE_MEMBER_FUNCTION_TEMPLATE], [
  AC_LANG_SAVE
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_CPLUSPLUS
  AC_MSG_CHECKING([for C++ member template])

  AC_CACHE_VAL(cxxac_cv_have_member_template, [
    AC_TRY_COMPILE([

template <class T> class obj_a {
	public:
		T	*b;

		obj_a(T *_b = 0) : b(_b) {}

						// Must OK here
		template <class S> void copy(obj_a<S>& _a)
						{ b = (T *)(_a.b); }
};

class obj_b {
	private:
		int	c;
	public:
		obj_b() : c(0) {}
};

    ], [

	int		a;
	obj_b		b;
	
	obj_a<int>	ptr_a(&a);
	obj_a<obj_b>	ptr_b(&b);	
	ptr_b.copy(ptr_a);			// Must OK here

    ], [
      cxxac_cv_have_member_template=yes
    ], [
      cxxac_cv_have_member_template=no
    ])
  ])

  if test $cxxac_cv_have_member_template = yes; then
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT(no)
  fi

  AC_LANG_RESTORE
])

dnl *****************************************************************
dnl CXXAC_BAD_FOR	Test if variables declared inside for statement 
dnl			persist after for loop.  The correct behavior is 
dnl			that they do not and is supported by gcc 2.7.x 
dnl			or newer.
dnl
dnl			There is no workaround provided.  If you still
dnl			need the old behavior, use CXXAC_WANT_BAD_FOR
dnl			instead.
dnl
dnl	Results:	cxxac_cv_bad_for = yes/no
dnl
AC_DEFUN([CXXAC_BAD_FOR], [
  AC_LANG_SAVE
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_CPLUSPLUS
  AC_MSG_CHECKING([for scope of variable declared inside for statement])

  AC_CACHE_VAL(cxxac_cv_bad_for, [
    AC_TRY_COMPILE([], [

	for (int i = 0; i < 10; i++)
		;

	for (int i = 0; i < 10; i++)		// Must OK here
		;

    ], [
      cxxac_cv_bad_for=no
    ], [
      cxxac_cv_bad_for=yes
    ])
  ])

  if test $cxxac_cv_bad_for = yes; then
    AC_MSG_RESULT(wrong)
  else
    AC_MSG_RESULT(correct)
  fi

  AC_LANG_RESTORE
])

dnl *****************************************************************
dnl CXXAC_WANT_BAD_FOR	Same as CXXAC_BAD_FOR but also add 
dnl			`-fno-for-scope' if the compiler support it
dnl			(works only with gcc).
dnl
dnl	Results:	cxxac_cv_bad_for = yes/no
dnl			cxxac_cv_bad_for_corrected = yes/no
dnl				if cxxac_cv_bad_for = yes
dnl
AC_DEFUN([CXXAC_WANT_BAD_FOR], [
  AC_LANG_SAVE
  AC_REQUIRE([CXXAC_WANT_BAD_FOR])
  AC_LANG_CPLUSPLUS
  if test $cxxac_cv_bad_for = yes; then

    AC_MSG_CHECKING([if old for variable scope can be obtained])
    cxxac_save_CXXFLAGS="$CXXFLAGS"

    AC_CACHE_VAL(cxxac_cv_bad_for_corrected, [
      CXXFLAGS="$CXXFLAGS -fno-for-scope"

      if test $GXX = yes; then
        AC_TRY_COMPILE([], [

	for (int i = 0; i < 10; i++)
		;

	for (int i = 0; i < 10; i++)		// Must error here
		;

        ], [
          cxxac_cv_bad_for_corrected=no
        ], [
          cxxac_cv_bad_for_corrected=yes
        ])
      else
        cxxac_cv_bad_for_corrected=no
      fi

    ])

    if test $cxxac_cv_bad_for_corrected = yes; then
      AC_MSG_RESULT(yes)
dnl						Keep -fno-for-scope
    else
      AC_MSG_RESULT(no)
dnl						Don't keep -fno-for-scope
      CXXFLAGS="$cxxac_save_CXXFLAGS"
    fi

  fi
  AC_LANG_RESTORE
])

dnl *****************************************************************
dnl CXXAC_HAVE_ARRAY_NEW
dnl			Test if operator new[](size_t) is supported.  
dnl			If not supported, you don't have to replace
dnl			the array version of new.
dnl
dnl	Results:	cxxac_cv_have_array_new = yes/no
dnl			CXX__HAVE_ARRAY_NEW defined in header file
dnl				if cxxac_cv_have_array_new = yes
dnl			CXX__NO_ARRAY_NEW defined in header file
dnl				if cxxac_cv_have_array_new = no
dnl
AC_DEFUN([CXXAC_HAVE_ARRAY_NEW], [
  AC_LANG_SAVE
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_CPLUSPLUS

  AC_MSG_CHECKING([for C++ array new replacement])

  AC_CACHE_VAL(cxxac_cv_have_array_new, [
    AC_TRY_COMPILE(
changequote(<<, >>)dnl
    <<

					// Should check & use size_t

void *operator new[](unsigned n)	// Must OK here
{
	return 0;
}

    >>,
changequote([, ])dnl
    [

				// Nothing in function body

    ], [
      cxxac_cv_have_array_new=yes
    ], [
      cxxac_cv_have_array_new=no
    ])
  ])

  if test $cxxac_cv_have_array_new = yes; then
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT(no)
  fi

  if test $cxxac_cv_have_array_new = yes; then
    AC_DEFINE(CXX__HAVE_ARRAY_NEW)
  fi
  AC_LANG_RESTORE
])

dnl *****************************************************************
dnl CXXAC_HAVE_PLACEMENT_NEW
dnl			Test if operator new(size_t,void *) is supported.  
dnl			If not supported, you don't have to replace
dnl			the placement version of new.
dnl
dnl	Results:	cxxac_cv_have_placement_new = yes/no
dnl			CXX__HAVE_PLACEMENT_NEW defined in header file
dnl				if cxxac_cv_have_place_new = yes
dnl			CXX__NO_PLACEMENT_NEW defined in header file
dnl				if cxxac_cv_have_place_new = no
dnl
AC_DEFUN([CXXAC_HAVE_PLACEMENT_NEW], [
  AC_LANG_SAVE
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_CPLUSPLUS
  AC_MSG_CHECKING([for C++ new(size_t,void *) replacement])

  AC_CACHE_VAL(cxxac_cv_have_placement_new, [
    AC_TRY_COMPILE([

					// Should check & use size_t

void *operator new(unsigned n,void *p)	// Must OK here
{
	return p;
}

    ], [

				// Nothing in function body

    ], [
      cxxac_cv_have_placement_new=yes
    ], [
      cxxac_cv_have_placement_new=no
    ])
  ])

  if test $cxxac_cv_have_placement_new = yes; then
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT(no)
  fi

  if test $cxxac_cv_have_placement_new = yes; then
    AC_DEFINE(CXX__HAVE_PLACEMENT_NEW)
  fi
  AC_LANG_RESTORE
])

dnl *****************************************************************
dnl CXXAC_BAD_DELETE	Test if operator delete and delete[] does not 
dnl			support `throw()' exception specification.  
dnl			throw() is required by gcc 2.8.x or newer.
dnl			If not supported, no throw() is needed.
dnl
dnl	Results:	cxxac_cv_bad_delete = yes/no
dnl			CXX__DELETE_NO_THROW defined in header file
dnl				if cxxac_cv_bad_delete = yes
dnl
AC_DEFUN([CXXAC_BAD_DELETE], [
  AC_LANG_SAVE
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_CPLUSPLUS
  AC_MSG_CHECKING([for C++ exception specification for delete])

  AC_CACHE_VAL(cxxac_cv_bad_delete, [
    AC_TRY_COMPILE([
void operator delete(void *p) throw()	// Must OK here
{
}

    ], [

				// Nothing in function body

    ], [
      cxxac_cv_bad_delete=no
    ], [
      cxxac_cv_bad_delete=yes
    ])
  ])

dnl Message printed is the reverse of $cxxac_cv_bad_delete
  if test $cxxac_cv_bad_delete = yes; then
    AC_MSG_RESULT(no)
  else
    AC_MSG_RESULT(yes)
  fi

  if test $cxxac_cv_bad_delete = yes; then
    AC_DEFINE(CXX__DELETE_NO_THROW)
  fi
  AC_LANG_RESTORE
])

dnl *****************************************************************
dnl CXXAC_HAVE_NAMESPACE
dnl			Test if namespace is supported.  It is
dnl			supported by gcc 2.95.x or newer
dnl			and egcs 1.1.
dnl
dnl	Results:	cxxac_cv_have_namespace = yes/no
dnl			CXX__HAVE_NAMESPACE defined in header file
dnl				if cxxac_cv_have_namespace = yes
dnl
AC_DEFUN([CXXAC_HAVE_NAMESPACE], [
  AC_LANG_SAVE
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_CPLUSPLUS
  AC_MSG_CHECKING([for C++ namespace])

  AC_CACHE_VAL(cxxac_cv_have_namespace, [
    AC_TRY_COMPILE([

namespace N1 { int a; }		// original-namespace-definition
namespace N1 { int b; }		// extension-namespace-definition
namespace { int c; }		// unnamed-namespace-definition
namespace N2 = N1;		// namespace-alias-definition

namespace N3 { int d; }
namespace N4 { typedef int e; typedef long f; }
namespace N5 { namespace N6 { int g; } }

int	ia = N1::a;		// qualified-namespace-specifier
int	ib = ::N1::a;		// qualified-namespace-specifier w/ ::(opt)
int	ic = N5::N6::g;		// qualified-namespace-specifier w/
				//  nested-name-specifier(opt)

using namespace N3;		// using-directive
using N4::e;			// using-declaration
using ::N4::f;			// using-declaration w/ ::(opt)

e	ea;
f	fa;

    ], [

				// Nothing in function body

    ], [
      cxxac_cv_have_namespace=yes
    ], [
      cxxac_cv_have_namespace=no
    ])
  ])

  if test $cxxac_cv_have_namespace = yes; then
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT(no)
  fi

  if test $cxxac_cv_have_namespace = yes; then
    AC_DEFINE(CXX__HAVE_NAMESPACE)
  fi
  AC_LANG_RESTORE
])

dnl *****************************************************************
dnl CXXAC_DEFAULT_EXCEPTION
dnl			Test if exception handling is on by default.
dnl			It is supported by gcc 2.8.0 or newer.
dnl
dnl	Results:	cxxac_cv_default_exception = yes/no
dnl			CXX__DEFAULT_EXCEPTION defined in header file
dnl				if cxxac_cv_default_exception = yes
dnl
AC_DEFUN([CXXAC_DEFAULT_EXCEPTION], [
  AC_LANG_SAVE
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_CPLUSPLUS
  AC_MSG_CHECKING([if exception handling is on by default])

  AC_CACHE_VAL(cxxac_cv_default_exception, [

    AC_TRY_COMPILE([
    ], [

try {
	throw 1;
}
catch (...) {
	throw;
}

    ], [
      cxxac_cv_default_exception=yes
    ], [
      cxxac_cv_default_exception=no
    ])
  ])

  AC_MSG_RESULT($cxxac_cv_default_exception)
  if test $cxxac_cv_default_exception = yes; then
    AC_DEFINE(CXX__DEFAULT_EXCEPTION)
  fi

  AC_LANG_RESTORE
])

dnl *****************************************************************
dnl CXXAC_HAVE_TYPENAME
dnl			Test if the typename keyword works.
dnl			It is supported by gcc 2.8.0 or newer.
dnl
dnl	Results:	cxxac_cv_have_typename = yes/no
dnl			CXX__HAVE_TYPENAME defined in header file
dnl				if cxxac_cv_have_typename = yes
dnl
AC_DEFUN([CXXAC_HAVE_TYPENAME], [
  AC_LANG_SAVE
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_CPLUSPLUS
  AC_MSG_CHECKING([for C++ typename keyword])

  AC_CACHE_VAL(cxxac_cv_have_typename, [

    AC_TRY_COMPILE([

class A {
	public:
		typedef int type;
		int value;
};

template <class T> class C {
	public:
		int f () {
			typename T::type p;
			return sizeof p;
		}
};

    ], [

C<A> c;
c.f();

    ], [
      cxxac_cv_have_typename=yes
    ], [
      cxxac_cv_have_typename=no
    ])
  ])

  AC_MSG_RESULT($cxxac_cv_have_typename)
  if test $cxxac_cv_have_typename = yes; then
    AC_DEFINE(CXX__HAVE_TYPENAME)
  fi

  AC_LANG_RESTORE
])


dnl *****************************************************************
dnl CXXAC_NO_GUIDE_DECL
dnl			Test if ordinary function declaration will not
dnl			guide the compiler to instantiate the template
dnl			version of the function.
dnl			It is supported by gcc 2.8.0 or newer.
dnl
dnl	Results:	cxxac_cv_no_guide_decl = yes/no
dnl			CXX__NO_GUIDE_DECL defined in header file
dnl				if cxxac_cv_no_guide_decl = yes
dnl
AC_DEFUN([CXXAC_NO_GUIDE_DECL], [
  AC_LANG_SAVE
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_CPLUSPLUS
  AC_MSG_CHECKING([if C++ guided declaration for template function disabled])

  AC_CACHE_VAL(cxxac_cv_no_guide_decl, [

    AC_TRY_COMPILE([

template <class T> int f(T &t);

template <class T> class C {
		int value;
	public:
		friend int f<>(T &);
};

    ], [

    ], [
      cxxac_cv_no_guide_decl=yes
    ], [
      cxxac_cv_no_guide_decl=no
    ])
  ])

  AC_MSG_RESULT($cxxac_cv_no_guide_decl)
  if test $cxxac_cv_no_guide_decl = yes; then
    AC_DEFINE(CXX__NO_GUIDE_DECL)
  fi

  AC_LANG_RESTORE
])



dnl *****************************************************************
dnl CXXAC_LIB_NEED_USING_STD
dnl			Test if library supports using namespace std.  
dnl			It is supported by libg++ 2.7.x or newer.
dnl
dnl	Results:	cxxac_cv_lib_need_using_std = yes/no
dnl			CXX__LIB_NEED_USING_STD defined in header file
dnl				if cxxac_cv_lib_need_using_std = yes
dnl			cxxac_using_namespace_std = "" or 
dnl				"using namespace std;"
dnl
dnl	[lib.contents]
dnl
AC_DEFUN([CXXAC_LIB_NEED_USING_STD], [
  AC_LANG_SAVE
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_CPLUSPLUS

  AC_REQUIRE([CXXAC_HAVE_NAMESPACE])

  dnl avoid broken message
  CXXAC_HEADER(iostream)

  AC_MSG_CHECKING([if using namespace std supported by C++ library])

  AC_CACHE_VAL(cxxac_cv_lib_need_using_std, [
    if test $cxxac_cv_have_namespace = yes; then

      AC_TRY_COMPILE([

#include CXX__HEADER_iostream
using namespace std;

      ], [

cout << '\n';

      ], [
        cxxac_cv_lib_need_using_std=yes
      ], [
        cxxac_cv_lib_need_using_std=no
      ])

    else
      cxxac_cv_lib_need_using_std=no
    fi
  ])

  AC_MSG_RESULT($cxxac_cv_lib_need_using_std)
  if test $cxxac_cv_lib_need_using_std = yes; then
    AC_DEFINE(CXX__LIB_NEED_USING_STD)
    cxxac_using_namespace_std="using namespace std;"
  else
    cxxac_using_namespace_std=""
  fi

  AC_LANG_RESTORE
])


dnl *****************************************************************
dnl CXXAC_HEADER	Test if the specified C++ and C library header 
dnl			is available.  
dnl			It is supported by gcc 3.x or newer.
dnl
dnl	Results:	cxxac_cv_have_header_xxx = yes/no/need_h
dnl			If cxxac_cv_have_header_xxx = yes/need_h, then
dnl				CXX__HAVE_HEADER_xxx defined in header file
dnl				                     to be 0 (need .h)
dnl				                     or 1 (OK)
dnl				cxxac_cv_header_xxx = header name found
dnl				CXX__HEADER_xxx defined as header name
dnl
AC_DEFUN([CXXAC_HEADER], [
  if eval "test \"\$cxxac_done_header_$1\" != yes"; then

    AC_LANG_SAVE
    AC_REQUIRE([AC_PROG_CXX])
    AC_LANG_CPLUSPLUS

    dnl $2 can be empty
    if test "$2" != quiet; then
      AC_MSG_CHECKING([for C++ library header $1])
    fi

    AC_CACHE_VAL(cxxac_cv_have_header_$1, [
      AC_TRY_CPP([#include <$1>], [
        eval "cxxac_cv_have_header_$1=yes"
      ], [
        AC_TRY_CPP([#include <$1.h>], [
          eval "cxxac_cv_have_header_$1=need_h"
        ], [
          eval "cxxac_cv_have_header_$1=no"
        ])
      ]);
    ])

    eval "cxxac_cv_have_header=\$cxxac_cv_have_header_$1"
    if test $cxxac_cv_have_header = yes; then
      cxxac_result=yes
      eval "cxxac_cv_header_$1=$1"
      AC_DEFINE_UNQUOTED(CXX__HAVE_HEADER_$1,1)
      AC_DEFINE_UNQUOTED(CXX__HEADER_$1,<$1>)
    elif test $cxxac_cv_have_header = need_h; then
      cxxac_result="need .h"
      eval "cxxac_cv_header_$1=$1.h"
      AC_DEFINE_UNQUOTED(CXX__HAVE_HEADER_$1,0)
      AC_DEFINE_UNQUOTED(CXX__HEADER_$1,<$1.h>)
    else
      cxxac_result=no
      eval "cxxac_cv_header_$1="
    fi

    dnl $2 can be empty
    if test "$2" != quiet; then
      AC_MSG_RESULT($cxxac_result)
    fi

    AC_LANG_RESTORE
    eval "cxxac_done_header_$1=yes"

  fi
])


dnl *****************************************************************
dnl CXXAC_HEADER_ALL	Test if all C++ and C library header is
dnl			available.  
dnl			It is supported by gcc 3.x or newer.
dnl
dnl	Results:	cxxac_cv_have_all_header = yes/no
dnl			CXX__HAVE_ALL_HEADER defined in header file
dnl				if cxxac_cv_have_all_header = yes
dnl			cxxac_cv_header_need_ext = list of files that
dnl						   require `.h' extension
dnl			cxxac_cv_missing = list of files that is
dnl			                   cannot be found even
dnl			                   with `.h' added
dnl
AC_DEFUN([CXXAC_HEADER_ALL], [
  AC_LANG_SAVE
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_CPLUSPLUS
  AC_MSG_NOTICE(checking for all C++ library header)

  cxxac_file="algorithm bitset complex deque exception fstream functional"
  cxxac_file="$cxxac_file iomanip ios iosfwd iostream istream iterator limits"
  cxxac_file="$cxxac_file list locale map memory new numeric"
  cxxac_file="$cxxac_file ostream queue set sstream stack stdexcept"
  cxxac_file="$cxxac_file streambuf string typeinfo utility valarray vector"
  cxxac_file="$cxxac_file cassert cctype cerrno cfloat"
  cxxac_file="$cxxac_file ciso646 climits clocale cmath"
  cxxac_file="$cxxac_file csetjmp csignal cstdarg cstddef"
  cxxac_file="$cxxac_file cstdio cstdlib cstring ctime cwchar cwctype"

  cxxac_cv_have_all_header=yes
  cxxac_cv_header_need_ext=
  cxxac_cv_header_missing=
  for cxxac_f in $cxxac_file; do
    CXXAC_HEADER($cxxac_f)
    if test $cxxac_cv_have_header != yes; then
      cxxac_cv_have_all_header=no
      if test $cxxac_cv_have_header = need_h; then
        cxxac_cv_header_need_ext="$cxxac_cv_header_need_ext $cxxac_f"
      else
        cxxac_cv_header_missing="$cxxac_cv_header_missing $cxxac_f"
      fi
    fi
  done

  dnl Append a space for easy check later
  cxxac_cv_header_need_ext="$cxxac_cv_header_need_ext "
  cxxac_cv_header_missing="$cxxac_cv_header_missing "

  AC_LANG_RESTORE
])


dnl *****************************************************************
dnl CXXAC_STRING_ERASE	Test if `string::erase' is available.  It is 
dnl			supported by libstdc++ 2.8.0 or newer.
dnl			If not available, string::remove (in libg++
dnl			before 2.8.0) or string::replace (in all
dnl			versions of libg++/libstdc++) may be used.
dnl
dnl	Results:	cxxac_cv_string_erase = yes/no
dnl			CXX__STRING_ERASE defined in header file
dnl				if cxxac_cv_string_erase = yes
dnl
AC_DEFUN([CXXAC_STRING_ERASE], [
  AC_LANG_SAVE
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_CPLUSPLUS

  AC_REQUIRE([CXXAC_LIB_NEED_USING_STD])
  if test "x$cxxac_cv_have_header_string" = x; then
    CXXAC_HEADER(string)
  fi

  AC_MSG_CHECKING([for C++ string::erase method])

  AC_CACHE_VAL(cxxac_cv_string_erase, [

    AC_TRY_COMPILE([

/* Some macro defined in curses.h  */
#undef move
#undef clear
#undef erase

#include <$cxxac_cv_header_string>
$cxxac_using_namespace_std

    ], [

string s("test");
s.erase(0,1);

    ], [
      cxxac_cv_string_erase=yes
    ], [
      cxxac_cv_string_erase=no
    ])
  ])

  if test $cxxac_cv_string_erase = yes; then
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT(no)
  fi

  if test $cxxac_cv_string_erase = yes; then
    AC_DEFINE(CXX__STRING_ERASE)
  fi
  AC_LANG_RESTORE
])


dnl *****************************************************************
dnl CXXAC_STRING_IO	Test if stream I/O operators for string 
dnl			is available.
dnl
dnl	Results:	cxxac_cv_string_io = yes/no
dnl			CXX__STRING_IO defined in header file
dnl				if cxxac_cv_string_io = yes
dnl
AC_DEFUN([CXXAC_STRING_IO], [
  AC_LANG_SAVE
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_CPLUSPLUS

  AC_REQUIRE([CXXAC_LIB_NEED_USING_STD])
  if test "x$cxxac_cv_have_header_string" = x; then
    CXXAC_HEADER(string)
  fi

  AC_MSG_CHECKING([for stream I/O operators for C++ string])

  AC_CACHE_VAL(cxxac_cv_string_io, [

    AC_TRY_COMPILE([

/* Some macro defined in curses.h  */
#undef move
#undef clear
#undef erase

#include <$cxxac_cv_header_string>
$cxxac_using_namespace_std

    ], [

string s("test"), t;
cout << s << '\n';
cin >> t;

    ], [
      cxxac_cv_string_io=yes
    ], [
      cxxac_cv_string_io=no
    ])
  ])

  AC_MSG_RESULT($cxxac_cv_string_io)

  if test $cxxac_cv_string_io = yes; then
    AC_DEFINE(CXX__STRING_IO)
  fi
  AC_LANG_RESTORE
])


dnl *****************************************************************
dnl CXXAC_BAD_ALLOC	Test if `bad_alloc' is available.  It is 
dnl			supported by gcc 2.95.x or newer and
dnl			egcs 1.1
dnl
dnl	Results:	cxxac_cv_bad_alloc = yes/no
dnl			CXX__BAD_ALLOC defined in header file
dnl				if cxxac_cv_bad_alloc = yes
dnl
AC_DEFUN([CXXAC_BAD_ALLOC], [
  AC_LANG_SAVE
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_CPLUSPLUS

  AC_REQUIRE([CXXAC_LIB_NEED_USING_STD])
  if test "x$cxxac_cv_have_header_new" = x; then
    CXXAC_HEADER(new)
  fi

  AC_REQUIRE([CXXAC_DEFAULT_EXCEPTION])

  AC_MSG_CHECKING([for bad_alloc])

  AC_CACHE_VAL(cxxac_cv_bad_alloc, [

    if test $cxxac_cv_default_exception = yes; then
      AC_TRY_COMPILE([

#include <$cxxac_cv_header_new>
$cxxac_using_namespace_std

bad_alloc b;

      ], [
      ], [
        cxxac_cv_bad_alloc=yes
      ], [
        cxxac_cv_bad_alloc=no
      ])
    else
      cxxac_cv_bad_alloc=no
    fi
  ])

  if test $cxxac_cv_bad_alloc = yes; then
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT(no)
  fi

  if test $cxxac_cv_bad_alloc = yes; then
    AC_DEFINE(CXX__BAD_ALLOC)
  fi
  AC_LANG_RESTORE
])


dnl *****************************************************************
dnl CXXAC_NEW_THROW_BAD_ALLOC
dnl
dnl			Test if new throws `bad_alloc'.  It is 
dnl			supported by gcc 2.95 or newer
dnl			and egcs 1.1.
dnl
dnl	Results:	cxxac_cv_new_throw_bad_alloc = yes/no
dnl			CXX__NEW_THROW_BAD_ALLOC defined in header file
dnl				if cxxac_cv_new_throw_bad_alloc = yes
dnl
AC_DEFUN([CXXAC_NEW_THROW_BAD_ALLOC], [
  AC_LANG_SAVE
  AC_REQUIRE([AC_PROG_CXX])
  AC_LANG_CPLUSPLUS

  AC_REQUIRE([CXXAC_BAD_ALLOC])

  AC_MSG_CHECKING([if new throws bad_alloc])

  AC_CACHE_VAL(cxxac_cv_new_throw_bad_alloc, [

    if test $cxxac_cv_bad_alloc = yes; then

      AC_TRY_RUN(

changequote(<<, >>)dnl
      <<

// TEST#1 - Try setting upper limit of memory resource

// If this test fails and returns 3, new[] may try
// to extend the memory limit.  We must proceed to TEST#2

#include <sys/time.h>
#include <sys/resource.h>
#include <unistd.h>

#include <$cxxac_cv_header_new>
$cxxac_using_namespace_std

int main() {
		// Set the upper resource limit.
		// This number must be large enough
		// so that memory can be allocated
		// by stack unwinding code.
	struct rlimit r;
	r.rlim_cur = 50000;
	r.rlim_max = 50000;
	if (setrlimit(RLIMIT_DATA,&r))
		exit(3);		// Unsupported test

	char *c;
	try {
		do {
			c = new char[60000];
		} while (c);
	}
	catch (bad_alloc &) {
		exit(0);
	}
	catch (...) {
		exit(2);		// Wrong exception
	}
	if (c == 0)
		exit(1);		// No throw
	else
		exit(3);		// Unsupported test
}

      >>
changequote([, ])dnl
      , [
        cxxac_cv_new_throw_result=ok
        cxxac_cv_new_throw_bad_alloc=yes
      ], [

        dnl unsupported by TEST#1     
        if test "$?" -eq 3; then

          AC_TRY_RUN(

changequote(<<, >>)dnl
      <<

// TEST#2 - Try exhausting system memory

#include <sys/time.h>
#include <sys/resource.h>
#include <unistd.h>

#include <$cxxac_cv_header_new>
$cxxac_using_namespace_std

int main() {
	char *c;
	try {
		for ( ; ; )
			c = new char[1000000];
	}
	catch (bad_alloc &) {
		return 0;
	}
	catch (...) {
		return 2;		// Wrong exception
	}
	if (c == 0)
		return 1;		// No throw
	else
		return 3;		// Unsupported test
}

      >>
changequote([, ])dnl

          , [
            cxxac_cv_new_throw_result=ok
            cxxac_cv_new_throw_bad_alloc=yes
          ], [
            cxxac_cv_new_throw_result="error $?"
            cxxac_cv_new_throw_bad_alloc=no
          ], [
            cxxac_cv_new_throw_result=cross_compile
            cxxac_cv_new_throw_bad_alloc=no
          ])

        dnl bad result from TEST#1
        else
          cxxac_cv_new_throw_result="error $?"
          cxxac_cv_new_throw_bad_alloc=no
        fi

      ], [
        cxxac_cv_new_throw_result=cross_compile
        cxxac_cv_new_throw_bad_alloc=no
      ])

    else
      cxxac_cv_new_throw_bad_alloc=no
    fi
  ])

  if test $cxxac_cv_new_throw_bad_alloc = yes; then
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT("no $cxxac_cv_new_throw_result")
  fi

  if test $cxxac_cv_new_throw_bad_alloc = yes; then
    AC_DEFINE(CXX__NEW_THROW_BAD_ALLOC)
  fi
  AC_LANG_RESTORE
])


dnl *****************************************************************
dnl CXXAC_TEST_ALL	Run all test except CXXAC_WANT_xxx and
dnl			untested tests
dnl
dnl	Results:	All of above test
dnl
AC_DEFUN([CXXAC_TEST_ALL], [
  CXXAC_TYPE_WCHAR_T
  CXXAC_TYPE_BOOL
  CXXAC_DEFINE_BOOL

  CXXAC_HAVE_EXPLICIT
  CXXAC_HAVE_MUTABLE

  CXXAC_DEFAULT_EXCEPTION

  CXXAC_HAVE_MEMBER_FUNCTION_TEMPLATE
  CXXAC_HAVE_TYPENAME
  CXXAC_NO_GUIDE_DECL

  CXXAC_HAVE_NAMESPACE
  CXXAC_LIB_NEED_USING_STD

  CXXAC_BAD_FOR

  CXXAC_HAVE_ARRAY_NEW
  CXXAC_HAVE_PLACEMENT_NEW
  CXXAC_BAD_DELETE

  CXXAC_HEADER_ALL

  CXXAC_STRING_ERASE
])

dnl *****************************************************************
dnl  End of C++ Tests for Autoconf
dnl *****************************************************************

# Macro to add for using GNU gettext.
# Ulrich Drepper <drepper@cygnus.com>, 1995.
#
# This file can be copied and used freely without restrictions.  It can
# be used in projects which are not available under the GNU Public License
# but which still want to provide support for the GNU gettext functionality.
# Please note that the actual code is *not* freely available.

# serial 5

AC_DEFUN(AM_WITH_NLS,
  [AC_MSG_CHECKING([whether NLS is requested])
    dnl Default is enabled NLS
    AC_ARG_ENABLE(nls,
      [  --disable-nls           do not use Native Language Support],
      USE_NLS=$enableval, USE_NLS=yes)
    AC_MSG_RESULT($USE_NLS)
    AC_SUBST(USE_NLS)

    USE_INCLUDED_LIBINTL=no

    dnl If we use NLS figure out what method
    if test "$USE_NLS" = "yes"; then
      AC_DEFINE(ENABLE_NLS)
      AC_MSG_CHECKING([whether included gettext is requested])
      AC_ARG_WITH(included-gettext,
        [  --with-included-gettext use the GNU gettext library included here],
        nls_cv_force_use_gnu_gettext=$withval,
        nls_cv_force_use_gnu_gettext=no)
      AC_MSG_RESULT($nls_cv_force_use_gnu_gettext)

      nls_cv_use_gnu_gettext="$nls_cv_force_use_gnu_gettext"
      if test "$nls_cv_force_use_gnu_gettext" != "yes"; then
        dnl User does not insist on using GNU NLS library.  Figure out what
        dnl to use.  If gettext or catgets are available (in this order) we
        dnl use this.  Else we have to fall back to GNU NLS library.
	dnl catgets is only used if permitted by option --with-catgets.
	nls_cv_header_intl=
	nls_cv_header_libgt=
	CATOBJEXT=NONE

	AC_CHECK_HEADER(libintl.h,
	  [AC_CACHE_CHECK([for gettext in libc], gt_cv_func_gettext_libc,
	    [AC_TRY_LINK([#include <libintl.h>], [return (int) gettext ("")],
	       gt_cv_func_gettext_libc=yes, gt_cv_func_gettext_libc=no)])

	   if test "$gt_cv_func_gettext_libc" != "yes"; then
	     AC_CHECK_LIB(intl, bindtextdomain,
	       [AC_CACHE_CHECK([for gettext in libintl],
		 gt_cv_func_gettext_libintl,
		 [AC_CHECK_LIB(intl, gettext,
		  gt_cv_func_gettext_libintl=yes,
		  gt_cv_func_gettext_libintl=no)],
		 gt_cv_func_gettext_libintl=no)])
	   fi

	   if test "$gt_cv_func_gettext_libc" = "yes" \
	      || test "$gt_cv_func_gettext_libintl" = "yes"; then
	      AC_DEFINE(HAVE_GETTEXT)
	      AM_PATH_PROG_WITH_TEST(MSGFMT, msgfmt,
		[test -z "`$ac_dir/$ac_word -h 2>&1 | grep 'dv '`"], no)dnl
	      if test "$MSGFMT" != "no"; then
		AC_CHECK_FUNCS(dcgettext)
		AC_PATH_PROG(GMSGFMT, gmsgfmt, $MSGFMT)
		AM_PATH_PROG_WITH_TEST(XGETTEXT, xgettext,
		  [test -z "`$ac_dir/$ac_word -h 2>&1 | grep '(HELP)'`"], :)
		AC_TRY_LINK(, [extern int _nl_msg_cat_cntr;
			       return _nl_msg_cat_cntr],
		  [CATOBJEXT=.gmo
		   DATADIRNAME=share],
		  [CATOBJEXT=.mo
		   DATADIRNAME=lib])
		INSTOBJEXT=.mo
	      fi
	    fi
	])

        if test "$CATOBJEXT" = "NONE"; then
	  AC_MSG_CHECKING([whether catgets can be used])
	  AC_ARG_WITH(catgets,
	    [  --with-catgets          use catgets functions if available],
	    nls_cv_use_catgets=$withval, nls_cv_use_catgets=no)
	  AC_MSG_RESULT($nls_cv_use_catgets)

	  if test "$nls_cv_use_catgets" = "yes"; then
	    dnl No gettext in C library.  Try catgets next.
	    AC_CHECK_LIB(i, main)
	    AC_CHECK_FUNC(catgets,
	      [AC_DEFINE(HAVE_CATGETS)
	       INTLOBJS="\$(CATOBJS)"
	       AC_PATH_PROG(GENCAT, gencat, no)dnl
	       if test "$GENCAT" != "no"; then
		 AC_PATH_PROG(GMSGFMT, gmsgfmt, no)
		 if test "$GMSGFMT" = "no"; then
		   AM_PATH_PROG_WITH_TEST(GMSGFMT, msgfmt,
		    [test -z "`$ac_dir/$ac_word -h 2>&1 | grep 'dv '`"], no)
		 fi
		 AM_PATH_PROG_WITH_TEST(XGETTEXT, xgettext,
		   [test -z "`$ac_dir/$ac_word -h 2>&1 | grep '(HELP)'`"], :)
		 USE_INCLUDED_LIBINTL=yes
		 CATOBJEXT=.cat
		 INSTOBJEXT=.cat
		 DATADIRNAME=lib
		 INTLDEPS='$(top_builddir)/intl/libintl.a'
		 INTLLIBS=$INTLDEPS
		 LIBS=`echo $LIBS | sed -e 's/-lintl//'`
		 nls_cv_header_intl=intl/libintl.h
		 nls_cv_header_libgt=intl/libgettext.h
	       fi])
	  fi
        fi

        if test "$CATOBJEXT" = "NONE"; then
	  dnl Neither gettext nor catgets in included in the C library.
	  dnl Fall back on GNU gettext library.
	  nls_cv_use_gnu_gettext=yes
        fi
      fi

      if test "$nls_cv_use_gnu_gettext" = "yes"; then
        dnl Mark actions used to generate GNU NLS library.
        INTLOBJS="\$(GETTOBJS)"
        AM_PATH_PROG_WITH_TEST(MSGFMT, msgfmt,
	  [test -z "`$ac_dir/$ac_word -h 2>&1 | grep 'dv '`"], msgfmt)
        AC_PATH_PROG(GMSGFMT, gmsgfmt, $MSGFMT)
        AM_PATH_PROG_WITH_TEST(XGETTEXT, xgettext,
	  [test -z "`$ac_dir/$ac_word -h 2>&1 | grep '(HELP)'`"], :)
        AC_SUBST(MSGFMT)
	USE_INCLUDED_LIBINTL=yes
        CATOBJEXT=.gmo
        INSTOBJEXT=.mo
        DATADIRNAME=share
	INTLDEPS='$(top_builddir)/intl/libintl.a'
	INTLLIBS=$INTLDEPS
	LIBS=`echo $LIBS | sed -e 's/-lintl//'`
        nls_cv_header_intl=intl/libintl.h
        nls_cv_header_libgt=intl/libgettext.h
      fi

      dnl Test whether we really found GNU xgettext.
      if test "$XGETTEXT" != ":"; then
	dnl If it is no GNU xgettext we define it as : so that the
	dnl Makefiles still can work.
	if $XGETTEXT --omit-header /dev/null 2> /dev/null; then
	  : ;
	else
	  AC_MSG_RESULT(
	    [found xgettext program is not GNU xgettext; ignore it])
	  XGETTEXT=":"
	fi
      fi

      # We need to process the po/ directory.
      POSUB=po
    else
      DATADIRNAME=share
      nls_cv_header_intl=intl/libintl.h
      nls_cv_header_libgt=intl/libgettext.h
    fi
    AC_LINK_FILES($nls_cv_header_libgt, $nls_cv_header_intl)
    AC_OUTPUT_COMMANDS(
     [case "$CONFIG_FILES" in *po/Makefile.in*)
        sed -e "/POTFILES =/r po/POTFILES" po/Makefile.in > po/Makefile
      esac])


    # If this is used in GNU gettext we have to set USE_NLS to `yes'
    # because some of the sources are only built for this goal.
    if test "$PACKAGE" = gettext; then
      USE_NLS=yes
      USE_INCLUDED_LIBINTL=yes
    fi

    dnl These rules are solely for the distribution goal.  While doing this
    dnl we only have to keep exactly one list of the available catalogs
    dnl in configure.in.
    for lang in $ALL_LINGUAS; do
      GMOFILES="$GMOFILES $lang.gmo"
      POFILES="$POFILES $lang.po"
    done

    dnl Make all variables we use known to autoconf.
    AC_SUBST(USE_INCLUDED_LIBINTL)
    AC_SUBST(CATALOGS)
    AC_SUBST(CATOBJEXT)
    AC_SUBST(DATADIRNAME)
    AC_SUBST(GMOFILES)
    AC_SUBST(INSTOBJEXT)
    AC_SUBST(INTLDEPS)
    AC_SUBST(INTLLIBS)
    AC_SUBST(INTLOBJS)
    AC_SUBST(POFILES)
    AC_SUBST(POSUB)
  ])

AC_DEFUN(AM_GNU_GETTEXT,
  [AC_REQUIRE([AC_PROG_MAKE_SET])dnl
   AC_REQUIRE([AC_PROG_CC])dnl
   AC_REQUIRE([AC_PROG_RANLIB])dnl
   AC_REQUIRE([AC_ISC_POSIX])dnl
   AC_REQUIRE([AC_HEADER_STDC])dnl
   AC_REQUIRE([AC_C_CONST])dnl
   AC_REQUIRE([AC_C_INLINE])dnl
   AC_REQUIRE([AC_TYPE_OFF_T])dnl
   AC_REQUIRE([AC_TYPE_SIZE_T])dnl
   AC_REQUIRE([AC_FUNC_ALLOCA])dnl
   AC_REQUIRE([AC_FUNC_MMAP])dnl

   AC_CHECK_HEADERS([argz.h limits.h locale.h nl_types.h malloc.h string.h \
unistd.h sys/param.h])
   AC_CHECK_FUNCS([getcwd munmap putenv setenv setlocale strchr strcasecmp \
strdup __argz_count __argz_stringify __argz_next])

   if test "${ac_cv_func_stpcpy+set}" != "set"; then
     AC_CHECK_FUNCS(stpcpy)
   fi
   if test "${ac_cv_func_stpcpy}" = "yes"; then
     AC_DEFINE(HAVE_STPCPY)
   fi

   AM_LC_MESSAGES
   AM_WITH_NLS

   if test "x$CATOBJEXT" != "x"; then
     if test "x$ALL_LINGUAS" = "x"; then
       LINGUAS=
     else
       AC_MSG_CHECKING(for catalogs to be installed)
       NEW_LINGUAS=
       for lang in ${LINGUAS=$ALL_LINGUAS}; do
         case "$ALL_LINGUAS" in
          *$lang*) NEW_LINGUAS="$NEW_LINGUAS $lang" ;;
         esac
       done
       LINGUAS=$NEW_LINGUAS
       AC_MSG_RESULT($LINGUAS)
     fi

     dnl Construct list of names of catalog files to be constructed.
     if test -n "$LINGUAS"; then
       for lang in $LINGUAS; do CATALOGS="$CATALOGS $lang$CATOBJEXT"; done
     fi
   fi

   dnl The reference to <locale.h> in the installed <libintl.h> file
   dnl must be resolved because we cannot expect the users of this
   dnl to define HAVE_LOCALE_H.
   if test $ac_cv_header_locale_h = yes; then
     INCLUDE_LOCALE_H="#include <locale.h>"
   else
     INCLUDE_LOCALE_H="\
/* The system does not provide the header <locale.h>.  Take care yourself.  */"
   fi
   AC_SUBST(INCLUDE_LOCALE_H)

   dnl Determine which catalog format we have (if any is needed)
   dnl For now we know about two different formats:
   dnl   Linux libc-5 and the normal X/Open format
   test -d intl || mkdir intl
   if test "$CATOBJEXT" = ".cat"; then
     AC_CHECK_HEADER(linux/version.h, msgformat=linux, msgformat=xopen)

     dnl Transform the SED scripts while copying because some dumb SEDs
     dnl cannot handle comments.
     sed -e '/^#/d' $srcdir/intl/$msgformat-msg.sed > intl/po2msg.sed
   fi
   dnl po2tbl.sed is always needed.
   sed -e '/^#.*[^\\]$/d' -e '/^#$/d' \
     $srcdir/intl/po2tbl.sed.in > intl/po2tbl.sed

   dnl In the intl/Makefile.in we have a special dependency which makes
   dnl only sense for gettext.  We comment this out for non-gettext
   dnl packages.
   if test "$PACKAGE" = "gettext"; then
     GT_NO="#NO#"
     GT_YES=
   else
     GT_NO=
     GT_YES="#YES#"
   fi
   AC_SUBST(GT_NO)
   AC_SUBST(GT_YES)

   dnl If the AC_CONFIG_AUX_DIR macro for autoconf is used we possibly
   dnl find the mkinstalldirs script in another subdir but ($top_srcdir).
   dnl Try to locate is.
   MKINSTALLDIRS=
   if test -n "$ac_aux_dir"; then
     MKINSTALLDIRS="$ac_aux_dir/mkinstalldirs"
   fi
   if test -z "$MKINSTALLDIRS"; then
     MKINSTALLDIRS="\$(top_srcdir)/mkinstalldirs"
   fi
   AC_SUBST(MKINSTALLDIRS)

   dnl *** For now the libtool support in intl/Makefile is not for real.
   l=
   AC_SUBST(l)

   dnl Generate list of files to be processed by xgettext which will
   dnl be included in po/Makefile.
   test -d po || mkdir po
   if test "x$srcdir" != "x."; then
     if test "x`echo $srcdir | sed 's@/.*@@'`" = "x"; then
       posrcprefix="$srcdir/"
     else
       posrcprefix="../$srcdir/"
     fi
   else
     posrcprefix="../"
   fi
   rm -f po/POTFILES
   sed -e "/^#/d" -e "/^\$/d" -e "s,.*,	$posrcprefix& \\\\," -e "\$s/\(.*\) \\\\/\1/" \
	< $srcdir/po/POTFILES.in > po/POTFILES
  ])

# Search path for a program which passes the given test.
# Ulrich Drepper <drepper@cygnus.com>, 1996.
#
# This file can be copied and used freely without restrictions.  It can
# be used in projects which are not available under the GNU Public License
# but which still want to provide support for the GNU gettext functionality.
# Please note that the actual code is *not* freely available.

# serial 1

dnl AM_PATH_PROG_WITH_TEST(VARIABLE, PROG-TO-CHECK-FOR,
dnl   TEST-PERFORMED-ON-FOUND_PROGRAM [, VALUE-IF-NOT-FOUND [, PATH]])
AC_DEFUN(AM_PATH_PROG_WITH_TEST,
[# Extract the first word of "$2", so it can be a program name with args.
set dummy $2; ac_word=[$]2
AC_MSG_CHECKING([for $ac_word])
AC_CACHE_VAL(ac_cv_path_$1,
[case "[$]$1" in
  /*)
  ac_cv_path_$1="[$]$1" # Let the user override the test with a path.
  ;;
  *)
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}:"
  for ac_dir in ifelse([$5], , $PATH, [$5]); do
    test -z "$ac_dir" && ac_dir=.
    if test -f $ac_dir/$ac_word; then
      if [$3]; then
	ac_cv_path_$1="$ac_dir/$ac_word"
	break
      fi
    fi
  done
  IFS="$ac_save_ifs"
dnl If no 4th arg is given, leave the cache variable unset,
dnl so AC_PATH_PROGS will keep looking.
ifelse([$4], , , [  test -z "[$]ac_cv_path_$1" && ac_cv_path_$1="$4"
])dnl
  ;;
esac])dnl
$1="$ac_cv_path_$1"
if test -n "[$]$1"; then
  AC_MSG_RESULT([$]$1)
else
  AC_MSG_RESULT(no)
fi
AC_SUBST($1)dnl
])

# Check whether LC_MESSAGES is available in <locale.h>.
# Ulrich Drepper <drepper@cygnus.com>, 1995.
#
# This file can be copied and used freely without restrictions.  It can
# be used in projects which are not available under the GNU Public License
# but which still want to provide support for the GNU gettext functionality.
# Please note that the actual code is *not* freely available.

# serial 1

AC_DEFUN(AM_LC_MESSAGES,
  [if test $ac_cv_header_locale_h = yes; then
    AC_CACHE_CHECK([for LC_MESSAGES], am_cv_val_LC_MESSAGES,
      [AC_TRY_LINK([#include <locale.h>], [return LC_MESSAGES],
       am_cv_val_LC_MESSAGES=yes, am_cv_val_LC_MESSAGES=no)])
    if test $am_cv_val_LC_MESSAGES = yes; then
      AC_DEFINE(HAVE_LC_MESSAGES)
    fi
  fi])

dnl *****************************************************************
dnl  ncurses Tests for Autoconf
dnl  Version 0.1.0
dnl  (c) 2000 by Kriang Lerdsuwanakij
dnl  lerdsuwa@users.sourceforge.net
dnl
dnl  This program is free software; you can redistribute it and/or modify
dnl  it under the terms of the GNU General Public License as published by
dnl  the Free Software Foundation; either version 2 of the License, or
dnl  (at your option) any later version.
dnl
dnl  This program is distributed in the hope that it will be useful,
dnl  but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl  GNU General Public License for more details.
dnl
dnl  As a special exception, the file `configure' generated by
dnl  `autoconf' from this file is not covered by the GNU General Public 
dnl  License.  This exception does not however invalidate any other
dnl  reasons why the generated file might be covered by the GNU General 
dnl  Public License.
dnl
dnl  You should have received a copy of the GNU General Public License
dnl  along with this program; if not, write to the Free Software
dnl  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
dnl

dnl *****************************************************************
dnl NCURSESAC_BOOL	Test for size of ncurses bool
dnl
dnl	Results:	ncursesac_cv_c_bool_size and ncursesac_cv_c_bool_equi
dnl			defined
dnl
AC_DEFUN([NCURSESAC_BOOL], [
  AC_LANG_SAVE
  AC_LANG_C
  AC_MSG_CHECKING([for size of ncurses bool])
  AC_CACHE_VAL(ncursesac_cv_c_bool_size, [
	AC_TRY_RUN([
	#include <curses.h>
	#include <stdio.h>
	int main()
	{
		FILE *f1, *f2;
		f1 = fopen("cf_kcd1.out", "w");
		f2 = fopen("cf_kcd2.out", "w");
		if (f1 && f2) {
			fprintf(f1, "%d", sizeof(bool));

			if (sizeof(bool) == sizeof(char))
				fprintf(f2, "char");
			else if (sizeof(bool) == sizeof(int))
				fprintf(f2, "int");
			else if (sizeof(bool) == sizeof(short))
				fprintf(f2, "short");
			else if (sizeof(bool) == sizeof(long))
				fprintf(f2, "long");

			fclose(f1);
			fclose(f2);
			exit(0); 
		}
		else
			exit(1); 
	}
	], [
		ncursesac_cv_c_bool_size=`cat cf_kcd1.out`
		ncursesac_cv_c_bool_equi=`cat cf_kcd2.out`
	], [
		ncursesac_cv_c_bool_size="N/A (error during test)"
		ncursesac_cv_c_bool_equi="N/A"
	], [
		ncursesac_cv_c_bool_size="N/A (due to cross-compilation)"
		ncursesac_cv_c_bool_equi="N/A"
	])
	rm -f cf_kcd1.out cf_kcd2.out
  ])
  AC_MSG_RESULT($ncursesac_cv_c_bool_size)
  AC_LANG_RESTORE
])

dnl *****************************************************************
dnl NCURSESAC_MOUSEMASK	Test if mousemask is available
dnl
dnl	Results:	ncursesac_cv_have_mousemask and NCURSES_AC_HAVEMOUSEMASK
dnl
AC_DEFUN([NCURSESAC_MOUSEMASK], [
  AC_LANG_SAVE
  AC_LANG_C
  AC_MSG_CHECKING([for mousemask])
  AC_CACHE_VAL(ncursesac_cv_have_mousemask, [
	AC_TRY_LINK([
	#include <curses.h>
	], [
	mmask_t oldMouseMask;
	mousemask(ALL_MOUSE_EVENTS, &oldMouseMask);
	], [
		ncursesac_cv_have_mousemask=yes
	], [
		ncursesac_cv_have_mousemask=no
	])
  ])
  AC_MSG_RESULT($ncursesac_cv_have_mousemask)
  if test $ncursesac_cv_have_mousemask = yes; then
    AC_DEFINE(NCURSESAC_HAVE_MOUSEMASK)
  fi

  AC_LANG_RESTORE
])

dnl *****************************************************************
dnl NCURSESAC_NEW_ATTR	Test if new attr_get and attr_set is used
dnl
dnl	Results:	ncursesac_cv_new_attr_get_attr_set and
dnl			NCURSESAC_NEW_ATTR_GET_ATTR_SET
dnl
AC_DEFUN([NCURSESAC_NEW_ATTR], [
  AC_LANG_SAVE
  AC_LANG_C
  AC_MSG_CHECKING([for new attr_get/attr_set])

  AC_CACHE_VAL(ncursesac_cv_new_attr, [
	AC_TRY_LINK([
	#include <curses.h>
	], [
	wattr_get(stdscr);
	], [
		ncursesac_cv_new_attr=no
	], [
		ncursesac_cv_new_attr=yes
		
	])
  ])
  AC_MSG_RESULT($ncursesac_cv_new_attr)
  if test $ncursesac_cv_new_attr = yes; then
    AC_DEFINE(NCURSESAC_NEW_ATTR_GET_ATTR_SET)
  fi

  AC_LANG_RESTORE
])

dnl *****************************************************************
dnl  End of ncurses Tests for Autoconf
dnl *****************************************************************

dnl *****************************************************************
dnl  zlib Tests for Autoconf
dnl  Version 0.1.0
dnl  (c) 2000 by Kriang Lerdsuwanakij
dnl  lerdsuwa@users.sourceforge.net
dnl
dnl  This program is free software; you can redistribute it and/or modify
dnl  it under the terms of the GNU General Public License as published by
dnl  the Free Software Foundation; either version 2 of the License, or
dnl  (at your option) any later version.
dnl
dnl  This program is distributed in the hope that it will be useful,
dnl  but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl  GNU General Public License for more details.
dnl
dnl  As a special exception, the file `configure' generated by
dnl  `autoconf' from this file is not covered by the GNU General Public 
dnl  License.  This exception does not however invalidate any other
dnl  reasons why the generated file might be covered by the GNU General 
dnl  Public License.
dnl
dnl  You should have received a copy of the GNU General Public License
dnl  along with this program; if not, write to the Free Software
dnl  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
dnl

dnl *****************************************************************
dnl ZLIBAC_EXTERN_C	Test if extern "C" is required to build
dnl			C++ programs.
dnl
dnl	Results:	zlibac_cv_need_extern_c and ZLIBAC_NEED_EXTERN_C
dnl			defined if extern "C" is required.
dnl
AC_DEFUN([ZLIBAC_EXTERN_C], [
  AC_LANG_SAVE
  AC_LANG_CPLUSPLUS
  AC_MSG_CHECKING([whether zlib requires extern "C" for C++ programs])
  AC_CACHE_VAL(zlibac_cv_need_extern_c, [
	AC_TRY_LINK([
		#include <zlib.h>
	], [
		gzFile gz = gzopen("test", "r");
		gzclose(gz);
	], [
	  zlibac_cv_need_extern_c=no
	], [
	  zlibac_cv_need_extern_c=yes
	])
  ])
  AC_MSG_RESULT($zlibac_cv_need_extern_c)
  if test $zlibac_cv_need_extern_c = yes; then
    AC_DEFINE(ZLIBAC_NEED_EXTERN_C)
  fi

  AC_LANG_RESTORE
])

dnl *****************************************************************
dnl ZLIBAC_GZ_FUNC	Test for zlib gz* functions
dnl
dnl	Results:	zlibac_cv_have_* and ZLIBAC_HAVE_*
dnl			defined if the corresponding function is 
dnl			available.
dnl
AC_DEFUN([ZLIBAC_GZ_FUNC], [
  AC_LANG_SAVE
  AC_LANG_C

  AC_CHECK_FUNC(gzprintf, zlibac_cv_have_gzprintf=yes, zlibac_cv_have_gzprintf=no)
  if test $zlibac_cv_have_gzprintf = yes; then
    AC_DEFINE(ZLIBAC_HAVE_GZPRINTF)
  fi

  AC_CHECK_FUNC(gzputc, zlibac_cv_have_gzputc=yes, zlibac_cv_have_gzputc=no)
  if test $zlibac_cv_have_gzputc = yes; then
    AC_DEFINE(ZLIBAC_HAVE_GZPUTC)
  fi

  AC_CHECK_FUNC(gzgetc, zlibac_cv_have_gzgetc=yes, zlibac_cv_have_gzgetc=no)
  if test $zlibac_cv_have_gzgetc = yes; then
    AC_DEFINE(ZLIBAC_HAVE_GZGETC)
  fi

  AC_CHECK_FUNC(gzputs, zlibac_cv_have_gzputs=yes, zlibac_cv_have_gzputs=no)
  if test $zlibac_cv_have_gzputs = yes; then
    AC_DEFINE(ZLIBAC_HAVE_GZPUTS)
  fi

  AC_CHECK_FUNC(gzgets, zlibac_cv_have_gzgets=yes, zlibac_cv_have_gzgets=no)
  if test $zlibac_cv_have_gzgets = yes; then
    AC_DEFINE(ZLIBAC_HAVE_GZGETS)
  fi

  AC_CHECK_FUNC(gzeof, zlibac_cv_have_gzeof=yes, zlibac_cv_have_gzeof=no)
  if test $zlibac_cv_have_gzeof = yes; then
    AC_DEFINE(ZLIBAC_HAVE_GZEOF)
  fi

  AC_LANG_RESTORE
])


dnl *****************************************************************
dnl  End of zlib Tests for Autoconf
dnl *****************************************************************

