/*
 *  guage - A realtime alternative to the 'wc' command.
 *  Copyright (C) 1997 Michael Raymond Brown
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Author: Michael Raymond Brown
 *  EMail:  michael@arrakeen.demon.co.uk
 *  WWW:    http://www.arrakeen.demon.co.uk/
 *  Address:  Michael Brown
 *            Kia Ora
 *            Brook Street
 *            Great Bromley
 *            Nr Colchester
 *            Essex
 *            CO7 7HX
 *            England
 *
 * PS. No spam please
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>


void syntax(const char* message)
   {
    if (message) fprintf(stderr, "error: %s\n", message);
    fprintf(stderr, "syntax: guage [-l] [-b] [-copy] [-bs <block size>]\n"
		    "        -l = Print a count of lines\n"
		    "        -b = Print a count of bytes (default)\n"
		    "        -copy = Copy standard input to standard output\n"
		    "        -bs = Set the larget block that can be read\n");
    exit(1);
   }

char* number(int bytes)
   {char temp1[64];
    static char temp2[64];
    char*  ptr;
    int    len = sprintf(temp1, "%d", bytes);
    int  count=-2;

    ptr=temp2+64;
    do {
        count++;
        if (count == 3)
           {*--ptr=',';
            count=0;
           }
        *--ptr=temp1[len];
    } while (len--);
    return ptr;
   }

int main(int argc, char** argv)
   {int do_lines=0; int lines=0;
    int do_bytes=0; int bytes=0;
    int do_speed=0; int last_bytes=0;
    int copy_output=0;
    int   buflen=4096;
    int dodefault=1;
    int rlen;
    char* buffer;
    time_t lasttime;
    time_t thistime;
    double speed = -3;

    while (--argc)
       {char* p=*++argv;
	if (strcmp(p, "-l") == 0)
	   {do_lines=1;
	    dodefault=0;
	   }
	else if (strcmp(p, "-b") == 0)
	   {do_bytes=1;
	    dodefault=0;
	   }
        else if (strcmp(p, "-speed") == 0)
	   {do_speed=1;
	   }
	else if (strcmp(p, "-copy") == 0)
	   {copy_output=1;
	   }
	else if (strcmp(p, "-bs") == 0)
	   {if (!--argv) syntax((char*)0);
	    buflen=atoi(*++argv);
	    if (!buflen) syntax("buflen is too small");
	   }
       }

    if (dodefault) do_bytes=1;

    lasttime=0;
    buffer = malloc(buflen);
    for (rlen=1;rlen;)
	{rlen = read(0, buffer, buflen);
	 if (rlen==-1) syntax("read ");

	 if (copy_output && rlen) write(1, buffer, rlen);

	 thistime=time((void*)0);
	 if (!rlen) thistime++;
	 if (lasttime != thistime)
	     fprintf(stderr, "\r");
	 if (do_lines)
	    {
	     int count=rlen;
	     char* ptr=buffer;
	     while (count--)
	        {if (*ptr == '\n') lines++;
		 ptr++;
	        }
	     if (lasttime != thistime)
	         fprintf(stderr, "%s Lines   ", number(lines));
	    }
	 if (do_bytes)
	    {
	     bytes+=rlen;
	     if (lasttime != thistime)
		{
		 fprintf(stderr, "%s Bytes   ", number(bytes));
		 if (do_speed)
		    {
		     if (speed < -2)
			{speed=-1;
			}
		     else if (speed < 0)
			{speed = (double)(bytes-last_bytes) / (thistime-lasttime);
			}
		     else
			{double v = (double)(bytes-last_bytes) / (thistime-lasttime);
			 speed = ((speed * 7) + v) / 8;
			}
		     if (speed >= 0) fprintf(stderr, "%f bps   ", speed);
		     last_bytes = bytes;
		}   }
	    }
	 lasttime=thistime;
	}
    fprintf(stderr, "\n");

    return 0;
   }

