#  $Id: makefile.mms 0.07 1996/01/05 00:00:07 tom Exp $
###############################################################################
#
#  Vax/VMS VAX-C with MMS
#  Makefile to create the extended `gcal' program.
#
#
#  After constructing gcal.exe with this Makefile, you should set up
#  symbols for gcal.exe.  Edit the example below, changing
#  "disk:[directory]" as appropriate.
#
#$ gcal == "$disk:[directory]gcal.exe"
#
#
#  Copyright (C) 1994-1996      Thomas Esken            <esken@uni-muenster.de>
#                               Im Hagenfeld 84
#                               D-48147 M"unster
#                               GERMANY
#
###############################################################################
#
#
#
DEF = /define=(#
DEF2 =)#
#
#  BEGIN: General program modification symbols,
#           which may be changed by the user !!
#



#  Write the line `DEBUG = $(DEF)DEBUG=1$(DEF2)'
#    for including some debugging code in program.
#
#  Write the line `DEBUG = $(DEF)DEBUG=0$(DEF2)'
#    if you don't need it...
#
#DEBUG = $(DEF)DEBUG=0$(DEF2)#



#  Write the line `USE_CATH = $(DEF)USE_CATH=1$(DEF2)'
#    for showing some specific Catholic holidays in eternal holiday list, too.
#
#  Write the line `USE_CATH = $(DEF)USE_CATH=0$(DEF2)'
#    if you don't need them...
#
USE_CATH = $(DEF)USE_CATH=1$(DEF2)#



#  Write the line `USE_EASC = $(DEF)USE_EASC=1$(DEF2)'
#    in case you want to use the 8-bit extended IBM-ASCII character set.
#
#  Write the line `USE_EASC = $(DEF)USE_EASC=0$(DEF2)'
#    in case you want to use the 7-bit ISO-ASCII/EBCDIC character set.
#
#USE_EASC = $(DEF)USE_EASC=0$(DEF2)#



#  Write the line `USE_GER = $(DEF)USE_GER=1$(DEF2)'
#    in case you want to use German message texts, holidays
#    and calendar layout.
#
#  Write the line `USE_GER = $(DEF)USE_GER=0$(DEF2)'
#    in case you want to use English message texts, holidays
#    and calendar layout.
#
#USE_GER = $(DEF)USE_GER=0$(DEF2)#



#  Write the line `USE_HLS = $(DEF)USE_HLS=1$(DEF2)'
#    to run this program using control sequences for highlighting the current
#    day/holidays/text (MS/PC-DOS will use the [n]ansi.sys driver for emitting
#    ANSI escape highlighting sequences; OS2/Linux/UN*X-like systems will use
#    Termcap for emitting the terminal specific highlighting sequences.
#    If this fails, default (generic) ANSI highlighting sequences will be used).
#
#  Write the line `USE_HLS = $(DEF)USE_HLS=0$(DEF2)'
#    to run this program without highlighting...
#
USE_HLS = $(DEF)USE_HLS=1$(DEF2)#



#  Write the line `USE_PAGER = $(DEF)USE_PAGER=1$(DEF2)'
#    in case you want to use an external pager or if it fails
#    a simple, built-in pager.
#
#  Write the line `USE_PAGER = $(DEF)USE_PAGER=0$(DEF2)'
#    in case you don't like this feature...
#
USE_PAGER = $(DEF)USE_PAGER=1$(DEF2)#



#  Write the line `USE_RC = $(DEF)USE_RC=1$(DEF2)'
#    for using the special month dates functions (print daily / weekly
#    monthly / yearly / eternal / special fixed dates as stated in
#    resource files).
#
#  Write the line `USE_RC = $(DEF)USE_RC=0$(DEF2)'
#    if you don't like this feature...
#
USE_RC = $(DEF)USE_RC=1$(DEF2)#



#  Write the line `USE_USHDY = $(DEF)USE_USHDY=1$(DEF2)'
#    for showing additional specific U.S. holidays in eternal holiday
#    list, too (active only if symbol USE_GER is set to 0).
#
#  Write the line `USE_USHDY = $(DEF)USE_USHDY=0$(DEF2)'
#    if you don't need them...
#
#USE_USHDY = $(DEF)USE_USHDY=0$(DEF2)#



#  Specify, which directories shall be used for the resource files:
#
#  (Define the empty string \"\" if you don't need library directories,
#  so library files are searched in the actual and $HOME directory only)
#
#
#  Name of user (private access) specific library directory
#    (relative to $HOME directory)
#
GCAL_USR_LIBDIR = \"lib/gcal-lib\"
#
#  Name of system (common access) specific library directory
#    (static to root directory)
#
GCAL_SYS_LIBDIR = \"/usr/lib/gcal-lib\"



#  Write the line `EXIT_STAT_HLP = $(DEF)EXIT_STAT_HLP=127$(DEF2)'
#    if you want the exit status 127 on a given --help, --long-help[=ARG],
#    --license and --version argument.
#
#  Comment the line `EXIT_STAT_HLP = $(DEF)EXIT_STAT_HLP=127$(DEF2)' or write
#    `EXIT_STAT_HLP = $(DEF)EXIT_STAT_HLP=0' if you want the exit status 0
#     on a given --help, --long-help[=ARG], --license and --version argument.
#
#EXIT_STAT_HLP = $(DEF)EXIT_STAT_HLP=127$(DEF2)#



#  Either write the line `GREG_1582 = $(DEF)GREG_1582=1$(DEF2)'
#    if you want the Gregorian reformation have occured in 1582
#  or write the line `GREG_1752 = $(DEF)GREG_1752=1$(DEF2)'
#    if you want the Gregorian reformation have occured in 1752.
#
#  Using this is not necessary in most cases, because this year is
#    set correctly depending on selected language to use (see USE_GER);
#    this means to the year 1582 for German users and to the year 1752
#    for English/American users by default.  But if you want to change
#    this, feel free to do.
#
#GREG_1582 = $(DEF)GREG_1582=0$(DEF2)#
#GREG_1752 = $(DEF)GREG_1752=0$(DEF2)#



#
#
#
DEFINES = $(DEBUG) $(USE_CATH) $(USE_EASC) $(USE_GER) \
  $(USE_HLS) $(USE_PAGER) $(USE_RC) $(USE_USHDY)
DEFINES2 = $(DEF)GCAL_USR_LIBDIR=$(GCAL_USR_LIBDIR)$(DEF2) \
  $(DEF)GCAL_SYS_LIBDIR=$(GCAL_SYS_LIBDIR)$(DEF2)
DEFINES3 = $(EXIT_STAT_HLP) $(GREG_1582) $(GREG_1752)



#
#  END: general program modification symbols,
#         which may be changed by the user !!
#



#
CC = cc
CFLAGS = /define=(VAXC) /warning
#
LD = link
LDFLAGS =
#
X = .exe
O = .obj
C = .c
H = .h

OBJS = gcal$(O) gcal_fil$(O) gcal_hdy$(O) gcal_hlp$(O) gcal_prt$(O) \
  gcal_rc$(O) gcal_rcc$(O) gcal_rcu$(O) gcal_tty$(O) gcal_utl$(O)



$(C)$(O) :
	define/user sys sys$library
	$(CC) $* $(DEFINES) $(DEFINES2) $(DEFINES3) $(CFLAGS)



gcal$(X) : $(OBJS)
	define lnk$library sys$share:vaxcrtl
	$(LD) $(LDFLAGS) /exec=gcal $+

clean:
	delete gcal$(X);0
	delete *$(O);0
