#  $Id: cal2gcal.pl 0.04 1996/01/30 00:00:04 tom Exp $
#
#  cal2gcal.pl:  Very simple, slow and silly `Perl' script for converting
#                  "BSD-calendar(1)" appointments into the `gcal' format.
#
#
#  Copyright (C) 1995, 1996 Thomas Esken
#
#  This software doesn't claim completeness, correctness or usability.
#  On principle I will not be liable for ANY damages or losses (implicit
#  or explicit), which result from using or handling my software.
#  If you use this software, you agree without any exception to this
#  agreement, which binds you LEGALLY !!
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the `GNU General Public License' as published by
#  the `Free Software Foundation'; either version 2, or (at your option)
#  any later version.
#
#  You should have received a copy of the `GNU General Public License'
#  along with this program; if not, write to the:
#
#    Free Software Foundation, Inc.
#    59 Temple Place - Suite 330
#    Boston, MA 02111-1307,  USA
#
#
$[ = 1;			# set array base to 1
$, = ' ';		# set output field separator
$\ = "\n";		# set output record separator

#
# Define the field separator used (blank acutally)
#
$FS = ' \t';
#
# Print some leading comment text
#
print '; cal2gcal.pl output';
print ';';
print '; Absolutely NO warrenty!';
print ';';
print ';';
#
# Pre-initialize the constructed line
#
$line = '';

#
# Main block
#

while (<>) {
    chop;	# strip record separator
    @Fld = split(/[$FS]/, $_, 9999);

    $datepart = $Fld[1];
    #
    # Strip leading whitspace characters in text part of appointment
    #
    $calcolumn = length($Fld[1]) + 1;
    while (substr($_, $calcolumn, 1) =~ /[$FS]/) {
	$calcolumn++;
    }
    $textpart = substr($_, $calcolumn, 999999);
    #
    # Construct the line
    #
    if (substr($datepart, 3, 1) eq '/') {
	#
	# If line is completed just print it
	#
	if ($line ne '') {
	    print $line;
	    $line = '';
	}
	$month = substr($datepart, 1, 2);
	$day = substr($datepart, 4, 2);
	$line = '0000' . $month . $day . ' ' . $textpart;
    }
    else {
	#
	# Strip leading whitspace characters in continuation of
	#   text part of appointment
	#
	$calcolumn = 1;
	while (substr($_, $calcolumn, 1) =~ /[$FS]/) {
	    $calcolumn++;
	}
	$line = $line . ' ' . substr($_, $calcolumn, 999999);
    }
}
