/*
*  gcal_hlp.c:  The help, version and license screens.
*
*
*  Copyright (C) 1994, 1995, 1996 Thomas Esken
*
*  This software doesn't claim completeness, correctness or usability.
*  On principle I will not be liable for ANY damages or losses (implicit
*  or explicit), which result from using or handling my software.
*  If you use this software, you agree without any exception to this
*  agreement, which binds you LEGALLY !!
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the `GNU General Public License' as published by
*  the `Free Software Foundation'; either version 2, or (at your option)
*  any later version.
*
*  You should have received a copy of the `GNU General Public License'
*  along with this program; if not, write to the:
*
*    Free Software Foundation, Inc.
*    59 Temple Place - Suite 330
*    Boston, MA 02111-1307,  USA
*/



#ifdef RCSID
static char rcsid[]="$Id: gcal_hlp.c 1.00 1996/03/06 01:00:00 tom Exp $";
#endif



/*
*  Include header files.
*/
#include "gcal_tai.h"
#include "gcal.h"



/*
*  Function prototypes.
*/
#if __cplusplus
extern "C"
{
#endif
/*
************************************************** Defined in `gcal_tty.c'.
*/
IMPORT void
print_text __P_((FILE *fp,
                 char *text_line));
/*
************************************************** Defined in `gcal_utl.c'.
*/
IMPORT VOID_PTR
my_malloc __P_((const int   amount,
                const int   exit_status,
                const char *module_name,
                const long  module_line,
                const char *var_name,
                const int   var_contents));
#if USE_GER
IMPORT const char *
short_day_name __P_((const int day));
#else /* !USE_GER */
IMPORT const char *
short3_day_name __P_((const int day));
#endif /* !USE_GER */
IMPORT const char *
short_month_name __P_((const int month));
/*
************************************************** Defined in `gcal_hlp.c'.
*/
EXPORT void
my_help_on_help __P_((      FILE *fp,
                      const char *longopt,
                      const Bool  lopt_ambig,
                      const int   cols));
EXPORT void
my_extended_help __P_((      FILE *fp,
                       const int   longopt_symbolic));
EXPORT void
my_basic_help __P_((FILE *fp));
EXPORT void
my_license __P_((      FILE *fp,
                 const char *prgr_id));
EXPORT void
my_version __P_((      FILE *fp,
                 const char *prgr_id));
EXPORT const char *
usage_msg __P_((void));
EXPORT void
put_longopt_description __P_((FILE *fp));
LOCAL const char *
get_longopt_description __P_((const int  longopt_symbolic,
                              const Bool with_larglist));
LOCAL void
my_copyright __P_((      FILE *fp,
                   const char *prgr_id));
LOCAL void
my_help_head_text __P_((FILE *fp));
LOCAL void
my_help_tail_text __P_((FILE *fp));
#if __cplusplus
}
#endif



/*
*  Declare public(extern) variables.
*/
IMPORT const Lopt_struct  lopt[];     /* The longoption structure */
IMPORT Hls_struct   ehls2s;           /* Effective hls 2 start (holiday) */
IMPORT Hls_struct   ehls2e;           /* Effective hls 2 end (holiday) */
IMPORT int          len_year_max;     /* String length of the maximum year able to compute */
IMPORT int          act_year;         /* Actual year */
IMPORT int          is_tty;           /* Is output displayed on a terminal? */
IMPORT int          len_prgr_name;    /* Length of actual program name */
IMPORT char        *s1;               /* General purpose text buffer */
IMPORT char        *s2;               /* General purpose text buffer */
IMPORT char        *prgr_name;        /* Stores the actual program name */
#ifdef GCAL_EPAGER
IMPORT char        *ext_pager;        /* Name of external pager program */
#endif
IMPORT Bool         emu_hls;          /* Must we emulate the highlighting sequences? */
IMPORT Bool         highlight_flag;   /* -H<yes> or -H<no> */



#ifdef ANSI_PROTO
PUBLIC void
my_help_on_help (      FILE *fp,
                 const char *longopt,
                 const Bool  lopt_ambig,
                 const int   cols)
#else /* !ANSI_PROTO */
   PUBLIC void
my_help_on_help (fp, longopt, lopt_ambig, cols)
         FILE *fp;
   const char *longopt;
   const Bool  lopt_ambig;
   const int   cols;
#endif /* !ANSI_PROTO */
/*
   Prints the "help on help" text to file `fp' using the central output
     function `print_text()' and uses global text buffer `s1' internally.
     If delivered `lopt_ambig' is TRUE, only display the names of all
     longoptions stored in `lopt' structure member `long_name', which
     are equal to delivered `longopt'.
*/
{
   auto     const Lopt_struct  *ptr_lopt=lopt;
   register const int           filler_blanks=2;
   register const int           len_longopt=(int)strlen(longopt);
   register       int           len_line;
   register       int           len_string;


#if USE_GER
   sprintf(s1, "%s: Benutze `%s %s' mit einem dieser Argumente",
           prgr_name, prgr_name, get_longopt_description (SYM_LONG_HELP2, TRUE));
#else /* !USE_GER */
   sprintf(s1, "%s: Use `%s %s' with one of these arguments",
           prgr_name, prgr_name, get_longopt_description (SYM_LONG_HELP2, TRUE));
#endif /* !USE_GER */
   print_text (fp, s1);
   print_text (fp, s1);
   for (len_line=0 ; len_line < filler_blanks ; len_line++)
     s1[len_line] = ' ';
   s1[len_line] = '\0';
   if (lopt_ambig)
    {
      while (*ptr_lopt->long_name < *longopt)
        ptr_lopt++;
      while (strncmp(longopt+1, ptr_lopt->long_name+1, len_longopt-1))
        ptr_lopt++;
    }
   while (ptr_lopt->long_name != NULL)
    {
      len_string = (int)strlen(ptr_lopt->long_name) + 1;
      if ((ptr_lopt+1)->long_name != NULL)
        len_string++;
      if (len_line + len_string >= cols)
       {
         print_text (fp, s1);
         for (len_line=0 ; len_line < filler_blanks ; len_line++)
           s1[len_line] = ' ';
         s1[len_line] = '\0';
       }
      strcat(s1, " ");
      strcat(s1, ptr_lopt->long_name);
      if ((ptr_lopt+1)->long_name != NULL)
       {
         if (   lopt_ambig
             && strncmp(longopt, (ptr_lopt+1)->long_name, len_longopt))
           break;
         strcat(s1, ",");
         len_line += len_string;
       }
      ptr_lopt++;
    }
   print_text (fp, s1);
}



#ifdef ANSI_PROTO
PUBLIC void
my_extended_help (      FILE *fp,
                  const int   longopt_symbolic)
#else /* !ANSI_PROTO */
   PUBLIC void
my_extended_help (fp, longopt_symbolic)
         FILE *fp;
   const int   longopt_symbolic;
#endif /* !ANSI_PROTO */
/*
   Prints the "extended help" text to file `fp' using the central
     output function `print_text()' and uses global text buffer
     `s1' and `s2' internally.
     If `longopt_symbolic' is set to SYM_NIL, the complete text
     is shown, otherwise the text corresponding to SYM_??? only!
*/
{
   auto Bool  print_hls=(Bool)(is_tty&&highlight_flag&&!emu_hls);


   if (longopt_symbolic == SYM_NIL)
    {
      my_help_head_text (fp);
#if USE_RC
#  if USE_GER
      sprintf(s1, USAGE"%s [[OPTION...] [%cDATUM] [%cDATEI...]] [KOMMANDO]",
              prgr_name, RC_ADATE_CHAR, RSP_CHAR);
#  else /* !USE_GER */
      sprintf(s1, USAGE"%s [[OPTION...] [%cDATE] [%cFILE...]] [COMMAND]",
              prgr_name, RC_ADATE_CHAR, RSP_CHAR);
#  endif /* !USE_GER */
#else /* !USE_RC */
#  if USE_GER
      sprintf(s1, USAGE"%s [[OPTION...] [%cDATEI...]] [KOMMANDO]", prgr_name, RSP_CHAR);
#  else /* !USE_GER */
      sprintf(s1, USAGE"%s [[OPTION...] [%cFILE...]] [COMMAND]", prgr_name, RSP_CHAR);
#  endif /* !USE_GER */
#endif /* !USE_RC */
      print_text (fp, s1);
      print_text (fp, s1);
      print_text (fp, s1);
      if (print_hls)
        strcpy(s1, ehls2s.seq);
      strcat(s1, "OPTION");
      if (print_hls)
        strcat(s1, ehls2e.seq);
      print_text (fp, s1);
    }
#if USE_GER
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_HELP:
        sprintf(s1, SWITCH"?        %s", get_longopt_description (SYM_HELP, TRUE));
        print_text (fp, s1);
        sprintf(s1, SWITCH"h        %s", get_longopt_description (SYM_HELP, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Hilfetext ausgeben und Programm beenden");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_LONG_HELP1:
      case SYM_LONG_HELP2:
        sprintf(s1, SWITCH"??       %s", get_longopt_description (SYM_LONG_HELP1, TRUE));
        print_text (fp, s1);
        sprintf(s1, SWITCH"hh       %s", get_longopt_description (SYM_LONG_HELP1, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s", get_longopt_description (SYM_LONG_HELP2, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Erweiterten Hilfetext ausgeben und Programm beenden");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_LICENSE1:
      case SYM_LICENSE2:
      case SYM_LICENSE3:
        sprintf(s1, SWITCH"L        %s", get_longopt_description (SYM_LICENSE1, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s", get_longopt_description (SYM_LICENSE2, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s", get_longopt_description (SYM_LICENSE3, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Softwarelizenz ausgeben und Programm beenden");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_VERSION:
        sprintf(s1, SWITCH"V        %s", get_longopt_description (SYM_VERSION, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Versionsnummer ausgeben und Programm beenden");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_RESPONSE_FILE:
        sprintf(s1, SWITCH"R ARG    %s", get_longopt_description (SYM_RESPONSE_FILE, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          Antwortdatei f"UE"r die `%cDATEI' Option erzeugen", RSP_CHAR);
        print_text (fp, s1);
        strcpy(s1, "   ARG    = Schreibe Argumente der Kommandozeile in Datei ARG");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#  ifdef GCAL_SHELL
      case SYM_SCRIPT_FILE:
        sprintf(s1, SWITCH"S ARG    %s", get_longopt_description (SYM_SCRIPT_FILE, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          Shell script mit den Argumenten der Kommandozeile erzeugen");
        print_text (fp, s1);
        strcpy(s1, "   ARG    = Dateiname des shell scripts");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#endif
#  if USE_RC
      case SYM_DATE_VARIABLE1:
      case SYM_DATE_VARIABLE2:
        sprintf(s1, SWITCH"v ARG    %s", get_longopt_description (SYM_DATE_VARIABLE1, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s", get_longopt_description (SYM_DATE_VARIABLE2, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Globale Datumvariable(n) \"dvar->a|b|c|d|f|...|z\" definieren");
        print_text (fp, s1);
        strcpy(s1, "   ARG    = Durch `"SEP"' Zeichen getrennte Definitionen der "
               "Form \"dvar"RC_DVAR_ASSIGN"`mmtt'\"");
        print_text (fp, s1);
        strcpy(s1, "            z.B.  "SWITCH"v a"RC_DVAR_ASSIGN"1127"SEP"b"RC_DVAR_ASSIGN
               "054   Setze `a' auf 27 Nov und `b' auf 4 Mai");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_EXPORT_LOCAL_DVARS:
        sprintf(s1, "          %s", get_longopt_description (SYM_EXPORT_LOCAL_DVARS, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Lokale Datumvariablen von Datei zu Datei exportieren");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#  endif
      case SYM_DEBUG:
        sprintf(s1, "          %s", get_longopt_description (SYM_DEBUG, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Einige Debug-Informationen ausgeben");
        print_text (fp, s1);
        strcpy(s1, "  [ARG]   = internal    Warnungen bei Erreichen programminterner Maxima");
        print_text (fp, s1);
        strcpy(s1, "          = handled     Wie `internal' und zudem gehandhabte Dateinamen");
        print_text (fp, s1);
        strcpy(s1, "          = unhandled   Wie `internal' und zudem nicht gehandhabte Dateinamen");
        print_text (fp, s1);
        strcpy(s1, "          = all         Wie `handled' und `unhandled' zusammen");
        print_text (fp, s1);
        strcpy(s1, "          = abort       Wie `all' und Abbruch bei ungehandhabten Dateinamen");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_TYPE_OF_CALENDAR:
        sprintf(s1, SWITCH"i[MOD]   %s", get_longopt_description (SYM_TYPE_OF_CALENDAR, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Spezial-Kalenderformat f"UE"r Kalenderblatt verwenden");
        print_text (fp, s1);
        strcat(s1, "  [MOD]   = -   Standard-Kalenderformat f"UE"r Kalenderblatt verwenden");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_SUPPRESS_CALENDAR:
        sprintf(s1, SWITCH"u        %s", get_longopt_description (SYM_SUPPRESS_CALENDAR, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Ausgabe des Kalenderblatts explizit unterdr"UE"cken");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#  if USE_PAGER
      case SYM_PAGER:
        sprintf(s1, SWITCH"p        %s", get_longopt_description (SYM_PAGER, TRUE));
        print_text (fp, s1);
#    ifdef GCAL_EPAGER
        if (ext_pager != (char *)NULL)
          sprintf(s1, "          Ausgabe durch externen `%s' Paginierer lenken",
                  (*ext_pager == *DIR_SEP) ? strrchr(ext_pager, *DIR_SEP)+1 : ext_pager);
        else
          strcpy(s1, "          Ausgabe durch einfachen, internen Paginierer lenken");
#    else /* !GCAL_EPAGER */
        strcpy(s1, "          Ausgabe durch einfachen, internen Paginierer lenken");
#    endif /* !GCAL_EPAGER */
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#  endif
      case SYM_DISABLE_HIGHLIGHTING:
        sprintf(s1, SWITCH"H no     %s", get_longopt_description (SYM_DISABLE_HIGHLIGHTING, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s=no",  get_longopt_description (SYM_HIGHLIGHTING, FALSE));
        print_text (fp, s1);
        strcpy(s1, "          Text, Feiertag bzw. aktuelles Datum ohne Hervorhebung ausgeben");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_FORCE_HIGHLIGHTING:
        sprintf(s1, SWITCH"H yes    %s", get_longopt_description (SYM_FORCE_HIGHLIGHTING, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s=yes",  get_longopt_description (SYM_HIGHLIGHTING, FALSE));
        print_text (fp, s1);
        strcpy(s1, "          Bel"AE"sst Hervorhebungssequenzen in Ausgabe bei Ausgabeumlenkung");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_HIGHLIGHTING:
        sprintf(s1, SWITCH"H ARG    %s", get_longopt_description (SYM_HIGHLIGHTING, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Setze Hervorhebungssequenz-Paare 1 (=aktueller Tag) und 2 (=Feiertag)");
        print_text (fp, s1);
        strcpy(s1, "   ARG    = Durch `"SEP"' Zeichen getrennte Hervorhebungssequenz-Paare");
        print_text (fp, s1);
        strcpy(s1, "            z.B.  "SWITCH"H \\x2"SEP"\\x"
               "AE   Benutze Hex-Wert 2 und AE f"UE"r Sequenz 1");
        print_text (fp, s1);
        strcpy(s1, "            z.B.  "SWITCH"H "SEP""SEP"*"SEP
               "*      Benutze Zeichen `*' und `*' f"UE"r Sequenz 2");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_BLOCKS:
        sprintf(s1, SWITCH"b ARG    %s", get_longopt_description (SYM_BLOCKS, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Format des Jahreskalenders festlegen");
        print_text (fp, s1);
        strcpy(s1, "   ARG    = 1|2|3|4|6|12   Anzahl der Bl"OE"cke");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_CALENDAR_DATES:
        sprintf(s1, SWITCH"j[MOD]   %s", get_longopt_description (SYM_CALENDAR_DATES, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Fortlaufenden Tag des Jahres im Kalenderblatt verwenden");
        print_text (fp, s1);
        strcpy(s1, "  [MOD]   = b   Beide Datumnotationen (Tag des Monats+Jahres) verwenden");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_HOLIDAY_DATES:
        sprintf(s1, SWITCH"jn[MOD]  %s", get_longopt_description (SYM_HOLIDAY_DATES, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Fortlaufenden Tag des Jahres in ewiger Feiertagsliste verwenden");
        print_text (fp, s1);
        strcpy(s1, "   [MOD]  = b   Beide Datumnotationen (Tag des Monats+Jahres) verwenden");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#if USE_RC
      case SYM_FIXED_DATES:
        sprintf(s1, SWITCH"jc[MOD]  %s", get_longopt_description (SYM_FIXED_DATES, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Fortlaufenden Tag des Jahres in Terminwarnungsliste verwenden");
        print_text (fp, s1);
        strcpy(s1, "   [MOD]  = b   Beide Datumnotationen (Tag des Monats+Jahres) verwenden");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#endif
      case SYM_STARTING_DAY:
        sprintf(s1, SWITCH"s ARG    %s", get_longopt_description (SYM_STARTING_DAY, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Starttag der Woche festlegen");
        print_text (fp, s1);
        sprintf(s1, "   ARG    = 0|Today | %d|%s | %d|%s | ... | %d|%s",
                DAY_MIN, short_day_name (DAY_MIN),
                DAY_MIN+1, short_day_name (DAY_MIN+1),
                DAY_MAX, short_day_name (DAY_MAX));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#  ifdef GCAL_EMAIL
      case SYM_MAIL:
        sprintf(s1, SWITCH"m ARG    %s", get_longopt_description (SYM_MAIL, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Versenden der Ausgabe via `"MAIL_PRGR"' Programm an Benutzer");
        print_text (fp, s1);
        strcpy(s1, "   ARG    = Email Adresse");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#  endif
      case SYM_DESC_HOLIDAY_LIST:
      case SYM_HOLIDAY_LIST:
        sprintf(s1, SWITCH"n|N[MOD] %s", get_longopt_description (SYM_DESC_HOLIDAY_LIST, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s", get_longopt_description (SYM_HOLIDAY_LIST, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          Ewige Feiertagsliste ausgeben "
                "(Jahr im Bereich: %d...%d)", EASTER_MIN, EASTER_MAX);
        print_text (fp, s1);
        strcpy(s1, " n        = Gesetzliche Feiertage und Erinnerungstage");
        print_text (fp, s1);
        strcpy(s1, "   N      = Nur gesetzliche Feiertage");
        print_text (fp, s1);
        strcpy(s1, "    [MOD] = "DES_LIT"   Absteigend sortiert");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_EXCLUDE_HD_TITLE:
        sprintf(s1, SWITCH"X        %s", get_longopt_description (SYM_EXCLUDE_HD_TITLE, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Ewige Feiertagsliste ohne "UUE"berschrift ausgeben");
        print_text (fp, s1);
      default:
        ;   /* Void */
    }
#  if USE_RC
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s1);
      sprintf(s1, "+++ TERMINWARNUNGEN +++");
      print_text (fp, s1);
      print_text (fp, s1);
    }
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_LIST_OF_FIXED_DATES:
        sprintf(s1, SWITCH"c|C[MOD] %s", get_longopt_description (SYM_LIST_OF_FIXED_DATES, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Benutze Standard-Ressourcendatei `"PRGR_RC_NAME"' f"UE"r Terminliste");
        print_text (fp, s1);
        strcpy(s1, "          Impliziert Warnungszeitraum:  Heute");
        print_text (fp, s1);
        strcpy(s1, " c        = Nur die Daten ausgeben, zu denen Termine vorliegen");
        print_text (fp, s1);
        strcpy(s1, "   C      = Auch die Daten ausgeben, zu denen keine Termine vorliegen");
        print_text (fp, s1);
      default:
        ;   /* Void */
    }
   if (longopt_symbolic == SYM_NIL)
    {
      strcpy(s1, "    [MOD] = Einer oder mehr der folgenden Modifizierer; hier markiert mit #");
      print_text (fp, s1);
      print_text (fp, s1);
    }
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_GROUPING_TEXT:
        sprintf(s1, "          %s", get_longopt_description (SYM_GROUPING_TEXT, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # g[MOD]       = Benutze Trenntext MOD f"UE"r tageweise Gruppierung");
        print_text (fp, s1);
        print_text (fp, s1);
      default:
        ;   /* Void */
    }
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s1);
      strcpy(s1, "          1. Sortierordnung des Textes");
      print_text (fp, s1);
    }
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_DESC_FIXED_DATES:
        sprintf(s1, "          %s", get_longopt_description (SYM_DESC_FIXED_DATES, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # "DES_LIT"            = Absteigend sortiert");
        print_text (fp, s1);
      default:
        ;   /* Void */
    }
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s1);
      strcpy(s1, "          2. Darstellung des Textes");
      print_text (fp, s1);
    }
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_INCLUDE_FILENAME:
        sprintf(s1, "          %s", get_longopt_description (SYM_INCLUDE_FILENAME, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # a            = Herkunft der Terminwarnung ausgeben");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_ALTERNATIVE_FORMAT:
        sprintf(s1, "          %s", get_longopt_description (SYM_ALTERNATIVE_FORMAT, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # A            = Alternatives Listenformat verwenden");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_INCLUDE_HOLIDAY:
        sprintf(s1, "          %s", get_longopt_description (SYM_INCLUDE_HOLIDAY, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # e            = Gesetzliche Feiertage und Erinnerungstage einf"UE"gen");
        print_text (fp, s1);
        strcpy(s1, "          # E            = Nur gesetzliche Feiertage einf"UE"gen");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_INCLUDE_WEEK_NO:
        sprintf(s1, "          %s", get_longopt_description (SYM_INCLUDE_WEEK_NO, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # k            = ISO-Wochennummer ausgeben");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_OMIT_DATE_PART:
        sprintf(s1, "          %s", get_longopt_description (SYM_OMIT_DATE_PART, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # o            = Datumfeld nur einmal ausgeben");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_EXCLUDE_RC_TITLE:
        sprintf(s1, "          %s", get_longopt_description (SYM_EXCLUDE_RC_TITLE, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # x            = Terminwarnungsliste ohne "UUE"berschrift ausgeben");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_INCLUDE_CONS_NO:
        sprintf(s1, "          %s", get_longopt_description (SYM_INCLUDE_CONS_NO, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # z            = Fortlaufende Postennummer ausgeben");
        print_text (fp, s1);
      default:
        ;   /* Void */
    }
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s1);
      strcpy(s1, "          3. Warnungszeitraum");
      print_text (fp, s1);
    }
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_LEAP_DAY:
        sprintf(s1, "          %s", get_longopt_description (SYM_LEAP_DAY, TRUE));
        print_text (fp, s1);
        strcpy(s1, "                         = Den `29-FEBRUAR' in Nicht-Schaltjahren handhaben");
        print_text (fp, s1);
        strcpy(s1, "                           ARG = february   Am `28-FEBRUAR' ber"UE"cksichtigen");
        print_text (fp, s1);
        strcpy(s1, "                           ARG = march      Am `01-M"AAE"RZ' ber"UE"cksichtigen");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_INCLUDE_TODAY:
        sprintf(s1, "          %s", get_longopt_description (SYM_INCLUDE_TODAY, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # d            = Aktuelles Datum einschliessen bei Datumliste");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_LIST_MODE:
        sprintf(s1, "          %s", get_longopt_description (SYM_LIST_MODE, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # l            = Datumliste anstelle Einzeldatum");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      default:
        ;   /* Void */
    }
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_PERIOD:
        sprintf(s1, "          %s", get_longopt_description (SYM_PERIOD, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # Nd           = Einzelner absoluter Tag N");
        print_text (fp, s1);
        sprintf(s1, "          # %cdN          = Einzelner absoluter Tag N",
                RC_NWD_CHAR);
        print_text (fp, s1);
        print_text (fp, s1);
        strcpy(s1, "          # NMOD         = Einzelner Tag N relativ zu heute");
        print_text (fp, s1);
        strcpy(s1, "             MOD           = "ASC_LIT"   Vorw"AE"rts");
        print_text (fp, s1);
        strcpy(s1, "                           = "DES_LIT"   R"UE"ckw"AE"rts");
        print_text (fp, s1);
        print_text (fp, s1);
        strcpy(s1, "          # Nw           = Gesamte Woche N");
        print_text (fp, s1);
        strcpy(s1, "                           N = 0        1'te Woche / letzte Woche im Vorjahr");
        print_text (fp, s1);
        strcpy(s1, "                           N = 1...52   1'te...52'te Woche (stets)");
        print_text (fp, s1);
        strcpy(s1, "                           N = 53       53'te Woche (manchmal)");
        print_text (fp, s1);
        strcpy(s1, "                           N = 99       Letzte Woche");
        print_text (fp, s1);
        print_text (fp, s1);
        strcpy(s1, "          # `mmtt'       = Einzelner Tag `tt' im Monat `mm'");
        print_text (fp, s1);
        print_text (fp, s1);
        strcpy(s1, "          # `mmwww'N     = Einzelner N'ter Wochentag `www' im Monat `mm'");
        print_text (fp, s1);
        strcpy(s1, "                           N = 1...4   1'ter...4'ter Wochentag `www' (stets)");
        print_text (fp, s1);
        strcpy(s1, "                           N = 5       5'ter Wochentag `www' (manchmal)");
        print_text (fp, s1);
        strcpy(s1, "                           N = 9       Letzter Wochentag `www'");
        print_text (fp, s1);
        print_text (fp, s1);
        sprintf(s1, "          # %cdN`www'     = Einzelner N'ter Wochentag `www'",
                RC_NWD_CHAR);
        print_text (fp, s1);
        strcpy(s1, "                           N = 1...51   1'ter...51'ter Wochentag `www' (stets)");
        print_text (fp, s1);
        strcpy(s1, "                           N = 52|53    52|53'ter Wochentag `www' (manchmal)");
        print_text (fp, s1);
        strcpy(s1, "                           N = 99       Letzter Wochentag `www'");
        print_text (fp, s1);
        print_text (fp, s1);
        sprintf(s1, "          # %cwN`www'     = Einzelner Wochentag `www' der N'ten Woche",
                RC_NWD_CHAR);
        print_text (fp, s1);
        strcpy(s1, "                           N = 0        `www' der nicht in der 1'ten Woche ist");
        print_text (fp, s1);
        strcpy(s1, "                           N = 1...51   `www' der 1'ten...51'ten Woche (stets)");
        print_text (fp, s1);
        strcpy(s1, "                           N = 52|53    `www' der 52|53'ten Woche (manchmal)");
        print_text (fp, s1);
        strcpy(s1, "                           N = 99       `www' der letzten Woche");
        print_text (fp, s1);
        print_text (fp, s1);
        sprintf(s1, "          # %ce[["ASC_LIT"|"DES_LIT"]N]   = "
                "Einzelner Tag N relativ zu Ostersonntag", RC_HDY_CHAR);
        print_text (fp, s1);
        print_text (fp, s1);
        sprintf(s1, "          # %ce["ASC_LIT"|"DES_LIT"]N`www'= "
                "Einzelner N'ter Wochentag relativ zu Ostersonntag", RC_HDY_CHAR);
        print_text (fp, s1);
        print_text (fp, s1);
        sprintf(s1, "          # %cv[["ASC_LIT"|"DES_LIT"]N]   = "
                "Einzelner Tag N relativ zur Datumvariablen", RC_HDY_CHAR);
        print_text (fp, s1);
        print_text (fp, s1);
        sprintf(s1, "          # %cv["ASC_LIT"|"DES_LIT"]N`www'= "
                "Einzelner N'ter Wochentag relativ zur Datumvariablen", RC_HDY_CHAR);
        print_text (fp, s1);
        print_text (fp, s1);
        strcpy(s1, "          # t|T          = Datumliste von morgen");
        print_text (fp, s1);
        print_text (fp, s1);
        strcpy(s1, "          # w|W[MOD]     = Datumliste der gesamten Woche");
        print_text (fp, s1);
        strcpy(s1, "               [MOD]       = "ASC_LIT"   Liste von morgen bis Ende der Woche");
        print_text (fp, s1);
        strcpy(s1, "                           = "DES_LIT"   Liste von gestern bis Anfang der Woche");
        print_text (fp, s1);
        print_text (fp, s1);
        strcpy(s1, "          # m|M[MOD]     = Datumliste des gesamten Monats");
        print_text (fp, s1);
        strcpy(s1, "               [MOD]       = "ASC_LIT"   Liste von morgen bis Ende des Monats");
        print_text (fp, s1);
        strcpy(s1, "                           = "DES_LIT"   Liste von gestern bis Anfang der Monats");
        print_text (fp, s1);
        print_text (fp, s1);
        strcpy(s1, "          # y|Y[MOD]     = Liste des gesamten Jahres");
        print_text (fp, s1);
        strcpy(s1, "               [MOD]       = "ASC_LIT"   Liste von morgen bis Ende des Jahres");
        print_text (fp, s1);
        strcpy(s1, "                           = "DES_LIT"   Liste von gestern bis Anfang des Jahres");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_RESOURCE_FILE:
        sprintf(s1, SWITCH"f|F ARG  %s", get_longopt_description (SYM_RESOURCE_FILE, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Benutze alternative Datei(en) anstelle Standard-Ressourcendatei");
        print_text (fp, s1);
        strcpy(s1, "          Impliziert Warnungszeitraum:  Heute");
        print_text (fp, s1);
        strcpy(s1, " f        = Nur die Daten ausgeben, zu denen Termine vorliegen");
        print_text (fp, s1);
        strcpy(s1, "   F      = Auch die Daten ausgeben, zu denen keine Termine vorliegen");
        print_text (fp, s1);
        strcpy(s1, "     ARG  = Einzelne Datei oder durch `"RC_FNAME_SEP
               "' Zeichen separierte Liste von Dateien");
        print_text (fp, s1);
      default:
          ;   /* Void */
    }
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s1);
      print_text (fp, s1);
      if (print_hls)
        strcpy(s1, ehls2s.seq);
      sprintf(s2, "%cDATUM", RC_ADATE_CHAR);
      strcat(s1, s2);
      if (print_hls)
        strcat(s1, ehls2e.seq);
      print_text (fp, s1);
      strcpy(s1, "Vorgegebenes `DATUM' anstelle des heutigen Datums verwenden");
      print_text (fp, s1);
      sprintf(s1, "Datumformat:  `"Y_LIT2"[mm[tt|www[N]]]', `"Y_LIT2"%c%c|dvar[["ASC_LIT"|"
              DES_LIT"]N[www]]', `"Y_LIT2"%cdN[www]'", RC_HDY_CHAR, RC_EASTER_CHAR, RC_NWD_CHAR);
      print_text (fp, s1);
      sprintf(s1, "              `"Y_LIT2"%cwN[www]', `Monatsname[tt]', `Wochentagsname[N]'"
              " oder `tt'", RC_NWD_CHAR);
      print_text (fp, s1);
    }
#  endif /* USE_RC */
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s1);
      print_text (fp, s1);
      if (print_hls)
        strcpy(s1, ehls2s.seq);
      sprintf(s2, "%cDATEI", RSP_CHAR);
      strcat(s1, s2);
      if (print_hls)
        strcat(s1, ehls2e.seq);
      print_text (fp, s1);
      strcpy(s1, "L"AE"dt Optionen und Kommandos aus `DATEI' vor");
      print_text (fp, s1);
      print_text (fp, s1);
      print_text (fp, s1);
      if (print_hls)
        strcpy(s1, ehls2s.seq);
      strcat(s1, "KOMMANDO");
      if (print_hls)
        strcat(s1, ehls2e.seq);
      print_text (fp, s1);
      sprintf(s1, "mm       = Monat im Bereich:  %d...%d", MONTH_MIN, MONTH_MAX);
      print_text (fp, s1);
      strcpy (s1, "                       oder:  Monatsname | "MONTH3_LIT" | "
              MONTH3_LIT""MONTH3_LIT" | "MONTH3_LIT""ASC_LIT" | "MONTH3_LIT""DES_LIT);
      print_text (fp, s1);
      print_text (fp, s1);
      strcpy(s1, "           Liste:    mm["YEAR_SEP""Y_LIT2"]"
             MLIST_SEP"..."MLIST_SEP"mm["YEAR_SEP""Y_LIT2"]");
      print_text (fp, s1);
      strcpy(s1, "           Bereich:  mm["YEAR_SEP""Y_LIT2"]"
             MRANGE_SEP"mm["YEAR_SEP""Y_LIT2"]");
      print_text (fp, s1);
      print_text (fp, s1);
      sprintf(s1, Y_LIT2"     = Jahr  im Bereich:  %d...%d", YEAR_MIN, YEAR_MAX);
      print_text (fp, s1);
      print_text (fp, s1);
      strcpy(s1, "           Liste:    [mm"FYEAR_SEP"]"Y_LIT2
             ""YLIST_SEP"..."YLIST_SEP"[mm"FYEAR_SEP"]"Y_LIT2);
      print_text (fp, s1);
      strcpy(s1, "           Bereich:  [mm"FYEAR_SEP"]"Y_LIT2
             ""YRANGE_SEP"[mm"FYEAR_SEP"]"Y_LIT2);
      print_text (fp, s1);
      print_text (fp, s1);
      print_text (fp, s1);
      sprintf(s1, "   +++ Bei zweistelliger Jahresangabe wird NICHT"
              " von %2d"Y_LIT" ausgegangen +++", act_year/100);
    }
#else /* !USE_GER */
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_HELP:
        sprintf(s1, SWITCH"?        %s", get_longopt_description (SYM_HELP, TRUE));
        print_text (fp, s1);
        sprintf(s1, SWITCH"h        %s", get_longopt_description (SYM_HELP, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Display help text and quit program");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_LONG_HELP1:
      case SYM_LONG_HELP2:
        sprintf(s1, SWITCH"??       %s", get_longopt_description (SYM_LONG_HELP1, TRUE));
        print_text (fp, s1);
        sprintf(s1, SWITCH"hh       %s", get_longopt_description (SYM_LONG_HELP1, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s", get_longopt_description (SYM_LONG_HELP2, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Display extended help text and quit program");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_LICENSE1:
      case SYM_LICENSE2:
      case SYM_LICENSE3:
        sprintf(s1, SWITCH"L        %s", get_longopt_description (SYM_LICENSE1, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s", get_longopt_description (SYM_LICENSE2, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s", get_longopt_description (SYM_LICENSE3, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Display software license and quit program");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_VERSION:
        sprintf(s1, SWITCH"V        %s", get_longopt_description (SYM_VERSION, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Display version number and quit program");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_RESPONSE_FILE:
        sprintf(s1, SWITCH"R ARG    %s", get_longopt_description (SYM_RESPONSE_FILE, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          Create response file for the `%cFILE' option", RSP_CHAR);
        print_text (fp, s1);
        strcpy(s1, "   ARG    = Store arguments of command line in file ARG");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#  ifdef GCAL_SHELL
      case SYM_SCRIPT_FILE:
        sprintf(s1, SWITCH"S ARG    %s", get_longopt_description (SYM_SCRIPT_FILE, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          Create shell script which contains the arguments of command line");
        print_text (fp, s1);
        strcpy(s1, "   ARG    = File name of the shell script");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#endif
#  if USE_RC
      case SYM_DATE_VARIABLE1:
      case SYM_DATE_VARIABLE2:
        sprintf(s1, SWITCH"v ARG    %s", get_longopt_description (SYM_DATE_VARIABLE1, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s", get_longopt_description (SYM_DATE_VARIABLE2, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Define global date variable(s) \"dvar->a|b|c|d|f|...|z\"");
        print_text (fp, s1);
        strcpy(s1, "   ARG    = Definition of `dvar"RC_DVAR_ASSIGN
               "mmdd' separated by `"SEP"' characters");
        print_text (fp, s1);
        strcpy(s1, "            e.g.  "SWITCH"v a"RC_DVAR_ASSIGN"1127"SEP"b"RC_DVAR_ASSIGN
               "054   Set `a' to Nov 27 and `b' to May 4");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_EXPORT_LOCAL_DVARS:
        sprintf(s1, "          %s", get_longopt_description (SYM_EXPORT_LOCAL_DVARS, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Export local date variables from file to file");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#  endif
      case SYM_DEBUG:
        sprintf(s1, "          %s", get_longopt_description (SYM_DEBUG, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Display some debug informations");
        print_text (fp, s1);
        strcpy(s1, "  [ARG]   = internal    Warnings if program internal maximums are reached");
        print_text (fp, s1);
        strcpy(s1, "          = handled     Like `internal' and file names which are handled");
        print_text (fp, s1);
        strcpy(s1, "          = unhandled   Like `internal' und file names which are unhandled");
        print_text (fp, s1);
        strcpy(s1, "          = all         Like `handled' and `unhandled' together");
        print_text (fp, s1);
        strcpy(s1, "          = abort       Like `all' and abort if file name can't be handled");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_TYPE_OF_CALENDAR:
        sprintf(s1, SWITCH"i[MOD]   %s", get_longopt_description (SYM_TYPE_OF_CALENDAR, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Use special format for calendar sheet");
        print_text (fp, s1);
        strcat(s1, "  [MOD]   = -   Use standard format for calendar sheet");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_SUPPRESS_CALENDAR:
        sprintf(s1, SWITCH"u        %s", get_longopt_description (SYM_SUPPRESS_CALENDAR, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Suppress output of calendar sheet explicitly");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#  if USE_PAGER
      case SYM_PAGER:
        sprintf(s1, SWITCH"p        %s", get_longopt_description (SYM_PAGER, TRUE));
        print_text (fp, s1);
#    ifdef GCAL_EPAGER
        if (ext_pager != (char *)NULL)
          sprintf(s1, "          Pass output thru external `%s' pager",
                  (*ext_pager == *DIR_SEP) ? strrchr(ext_pager, *DIR_SEP)+1 : ext_pager);
        else
          strcpy(s1, "          Pass output thru simple, internal pager");
#    else /* !GCAL_EPAGER */
        strcpy(s1, "          Pass output thru simple, internal pager");
#    endif /* !GCAL_EPAGER */
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#  endif
      case SYM_DISABLE_HIGHLIGHTING:
        sprintf(s1, SWITCH"H no     %s", get_longopt_description (SYM_DISABLE_HIGHLIGHTING, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s=no",  get_longopt_description (SYM_HIGHLIGHTING, FALSE));
        print_text (fp, s1);
        strcpy(s1, "          Disable highlighting of text, holiday resp., actual day");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_FORCE_HIGHLIGHTING:
        sprintf(s1, SWITCH"H yes    %s", get_longopt_description (SYM_FORCE_HIGHLIGHTING, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s=yes",  get_longopt_description (SYM_HIGHLIGHTING, FALSE));
        print_text (fp, s1);
        strcpy(s1, "          Forces highlighting sequences if output is redirected/piped");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_HIGHLIGHTING:
        sprintf(s1, SWITCH"H ARG    %s", get_longopt_description (SYM_HIGHLIGHTING, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Set highlighting sequence pairs 1 (=actual day) and 2 (=holiday)");
        print_text (fp, s1);
        strcpy(s1, "   ARG    = Highlighting sequence pairs separated by `"SEP"' characters");
        print_text (fp, s1);
        strcpy(s1, "            e.g.  "SWITCH"H \\x2"SEP"\\x"
               "AE   Use hex values 2 and AE for sequence 1");
        print_text (fp, s1);
        strcpy(s1, "            e.g.  "SWITCH"H "SEP""SEP"*"SEP
               "*      Use characters `*' and `*' for sequence 2");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_BLOCKS:
        sprintf(s1, SWITCH"b ARG    %s", get_longopt_description (SYM_BLOCKS, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Modify format of year calendar");
        print_text (fp, s1);
        strcpy(s1, "   ARG    = 1|2|3|4|6|12   Number of blocks");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_CALENDAR_DATES:
        sprintf(s1, SWITCH"j[MOD]   %s", get_longopt_description (SYM_CALENDAR_DATES, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Use consecutive day of year in calendar sheet");
        print_text (fp, s1);
        strcpy(s1, "  [MOD]   = b   Use both date notations (day of month+year)");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_HOLIDAY_DATES:
        sprintf(s1, SWITCH"jn[MOD]  %s", get_longopt_description (SYM_HOLIDAY_DATES, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Use consecutive day of year in eternal holiday list");
        print_text (fp, s1);
        strcpy(s1, "   [MOD]  = b   Use both date notations (day of month+year)");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#if USE_RC
      case SYM_FIXED_DATES:
        sprintf(s1, SWITCH"jc[MOD]  %s", get_longopt_description (SYM_FIXED_DATES, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Use consecutive day of year in fixed date warning list");
        print_text (fp, s1);
        strcpy(s1, "   [MOD]  = b   Use both date notations (day of month+year)");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#endif
      case SYM_STARTING_DAY:
        sprintf(s1, SWITCH"s ARG    %s", get_longopt_description (SYM_STARTING_DAY, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Set starting day of week");
        print_text (fp, s1);
        sprintf(s1, "   ARG    = 0|Today | %d|%s | %d|%s | ... | %d|%s",
                DAY_MIN, short3_day_name (DAY_MIN),
                DAY_MIN+1, short3_day_name (DAY_MIN+1),
                DAY_MAX, short3_day_name (DAY_MAX));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#  ifdef GCAL_EMAIL
      case SYM_MAIL:
        sprintf(s1, SWITCH"m ARG    %s", get_longopt_description (SYM_MAIL, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Send output via `"MAIL_PRGR"' program to user");
        print_text (fp, s1);
        strcpy(s1, "   ARG    = Email Address");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#  endif
      case SYM_DESC_HOLIDAY_LIST:
      case SYM_HOLIDAY_LIST:
        sprintf(s1, SWITCH"n|N[MOD] %s", get_longopt_description (SYM_DESC_HOLIDAY_LIST, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s", get_longopt_description (SYM_HOLIDAY_LIST, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          Display eternal holiday list "
                "(Year in range: %d...%d)", EASTER_MIN, EASTER_MAX);
        print_text (fp, s1);
        strcpy(s1, " n        = Legal days and memorial days");
        print_text (fp, s1);
        strcpy(s1, "   N      = Legal days only");
        print_text (fp, s1);
        strcpy(s1, "    [MOD] = "DES_LIT"   Descending sort order");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_EXCLUDE_HD_TITLE:
        sprintf(s1, SWITCH"X        %s", get_longopt_description (SYM_EXCLUDE_HD_TITLE, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Exclude title of eternal holiday list");
        print_text (fp, s1);
      default:
        ;   /* Void */
    }
#  if USE_RC
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s1);
      sprintf(s1, "+++ FIXED DATE WARNINGS +++");
      print_text (fp, s1);
      print_text (fp, s1);
    }
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_LIST_OF_FIXED_DATES:
        sprintf(s1, SWITCH"c|C[MOD] %s", get_longopt_description (SYM_LIST_OF_FIXED_DATES, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Use standard resource file `"PRGR_RC_NAME"' for fixed dates list");
        print_text (fp, s1);
        strcpy(s1, "          Implies warning period:  Today");
        print_text (fp, s1);
        strcpy(s1, " c        = Display only those dates, for which fixed dates exists");
        print_text (fp, s1);
        strcpy(s1, "   C      = Display those dates, for which fixed dates doesn't exit, too");
        print_text (fp, s1);
      default:
        ;   /* Void */
    }
   if (longopt_symbolic == SYM_NIL)
    {
      strcpy(s1, "    [MOD] = One or more of the following modifiers which are marked by #");
      print_text (fp, s1);
      print_text (fp, s1);
    }
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_GROUPING_TEXT:
        sprintf(s1, "          %s", get_longopt_description (SYM_GROUPING_TEXT, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # g[MOD]       = Group fixed date warnings by day using text MOD");
        print_text (fp, s1);
        print_text (fp, s1);
      default:
        ;   /* Void */
    }
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s1);
      strcpy(s1, "          1. Sorting oder of text");
      print_text (fp, s1);
    }
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_DESC_FIXED_DATES:
        sprintf(s1, "          %s", get_longopt_description (SYM_DESC_FIXED_DATES, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # "DES_LIT"            = Descending sort order");
        print_text (fp, s1);
      default:
        ;   /* Void */
    }
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s1);
      strcpy(s1, "          2. Representation of text");
      print_text (fp, s1);
    }
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_INCLUDE_FILENAME:
        sprintf(s1, "          %s", get_longopt_description (SYM_INCLUDE_FILENAME, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # a            = Display origin of fixed date warning");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_ALTERNATIVE_FORMAT:
        sprintf(s1, "          %s", get_longopt_description (SYM_ALTERNATIVE_FORMAT, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # A            = Display using alternative list format");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_INCLUDE_HOLIDAY:
        sprintf(s1, "          %s", get_longopt_description (SYM_INCLUDE_HOLIDAY, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # e            = Include legal days and memorial days");
        print_text (fp, s1);
        strcpy(s1, "          # E            = Include legal days only");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_INCLUDE_WEEK_NO:
        sprintf(s1, "          %s", get_longopt_description (SYM_INCLUDE_WEEK_NO, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # k            = Display ISO week number");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_OMIT_DATE_PART:
        sprintf(s1, "          %s", get_longopt_description (SYM_OMIT_DATE_PART, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # o            = Omit repeating date part of fixed date warnings");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_EXCLUDE_RC_TITLE:
        sprintf(s1, "          %s", get_longopt_description (SYM_EXCLUDE_RC_TITLE, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # x            = Exclude title of fixed date warning list");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_INCLUDE_CONS_NO:
        sprintf(s1, "          %s", get_longopt_description (SYM_INCLUDE_CONS_NO, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # z            = Display consecutive number of fixed date warnings");
        print_text (fp, s1);
      default:
        ;   /* Void */
    }
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s1);
      strcpy(s1, "          3. Respected warning period");
      print_text (fp, s1);
    }
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_LEAP_DAY:
        sprintf(s1, "          %s", get_longopt_description (SYM_LEAP_DAY, TRUE));
        print_text (fp, s1);
        strcpy(s1, "                         = Manage `29-FEBRUARY' in non-leap years");
        print_text (fp, s1);
        strcpy(s1, "                           ARG = february   Respect at `28-FEBRUARY'");
        print_text (fp, s1);
        strcpy(s1, "                           ARG = march      Respect at `01-MARCH'");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_INCLUDE_TODAY:
        sprintf(s1, "          %s", get_longopt_description (SYM_INCLUDE_TODAY, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # d            = Include actual date if list of periods is generated");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_LIST_MODE:
        sprintf(s1, "          %s", get_longopt_description (SYM_LIST_MODE, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # l            = Generate list of periods instead of a single period");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      default:
        ;   /* Void */
    }
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_PERIOD:
        sprintf(s1, "          %s", get_longopt_description (SYM_PERIOD, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # Nd           = Single absolute day N");
        print_text (fp, s1);
        sprintf(s1, "          # %cdN          = Single absolute day N",
                RC_NWD_CHAR);
        print_text (fp, s1);
        print_text (fp, s1);
        strcpy(s1, "          # NMOD         = Single day N relative to today");
        print_text (fp, s1);
        strcpy(s1, "             MOD           = "ASC_LIT"   Forwards");
        print_text (fp, s1);
        strcpy(s1, "                           = "DES_LIT"   Backwards");
        print_text (fp, s1);
        print_text (fp, s1);
        strcpy(s1, "          # Nw           = Complete week N");
        print_text (fp, s1);
        strcpy(s1, "                           N = 0        1'st week / last week of previous year");
        print_text (fp, s1);
        strcpy(s1, "                           N = 1...52   1'st...52'nd week (always)");
        print_text (fp, s1);
        strcpy(s1, "                           N = 53       53'rd week (sometimes)");
        print_text (fp, s1);
        strcpy(s1, "                           N = 99       Last week");
        print_text (fp, s1);
        print_text (fp, s1);
        strcpy(s1, "          # `mmdd'       = Single day `dd' of month `mm'");
        print_text (fp, s1);
        print_text (fp, s1);
        strcpy(s1, "          # `mmwww'N     = Single N'th weekday `www' of month `mm'");
        print_text (fp, s1);
        strcpy(s1, "                           N = 1...4   1'st...4'th weekday `www' (always)");
        print_text (fp, s1);
        strcpy(s1, "                           N = 5       5'th weekday `www' (sometimes)");
        print_text (fp, s1);
        strcpy(s1, "                           N = 9       Last weekday `www'");
        print_text (fp, s1);
        print_text (fp, s1);
        sprintf(s1, "          # %cdN`www'     = Single N'th weekday `www'",
                RC_NWD_CHAR);
        print_text (fp, s1);
        strcpy(s1, "                           N = 1...51   1'st...51'st weekday `www' (always)");
        print_text (fp, s1);
        strcpy(s1, "                           N = 52|53    52|53'rd weekday `www' (sometimes)");
        print_text (fp, s1);
        strcpy(s1, "                           N = 99       Last weekday `www'");
        print_text (fp, s1);
        print_text (fp, s1);
        sprintf(s1, "          # %cwN`www'     = Single weekday `www' of N'th week",
                RC_NWD_CHAR);
        print_text (fp, s1);
        strcpy(s1, "                           N = 0        `www' which isn't located in 1'st week");
        print_text (fp, s1);
        strcpy(s1, "                           N = 1...51   `www' of 1'st...51'st week (always)");
        print_text (fp, s1);
        strcpy(s1, "                           N = 52|53    `www' of 52|53'rd week (sometimes)");
        print_text (fp, s1);
        strcpy(s1, "                           N = 99       `www' of last week");
        print_text (fp, s1);
        print_text (fp, s1);
        sprintf(s1, "          # %ce[["ASC_LIT"|"DES_LIT"]N]   = "
                "Single day N relative to Easter Sunday", RC_HDY_CHAR);
        print_text (fp, s1);
        print_text (fp, s1);
        sprintf(s1, "          # %ce["ASC_LIT"|"DES_LIT"]N`www'= "
                "Single N'th weekday relative to Easter Sunday", RC_HDY_CHAR);
        print_text (fp, s1);
        print_text (fp, s1);
        sprintf(s1, "          # %cv[["ASC_LIT"|"DES_LIT"]N]   = "
                "Single day N relative to date variable", RC_HDY_CHAR);
        print_text (fp, s1);
        print_text (fp, s1);
        sprintf(s1, "          # %cv["ASC_LIT"|"DES_LIT"]N`www'= "
                "Single N'th weekday relative to date variable", RC_HDY_CHAR);
        print_text (fp, s1);
        print_text (fp, s1);
        strcpy(s1, "          # t|T          = List tomorrow");
        print_text (fp, s1);
        print_text (fp, s1);
        strcpy(s1, "          # w|W[MOD]     = List complete week");
        print_text (fp, s1);
        strcpy(s1, "               [MOD]       = "ASC_LIT"   List tomorrow until ending day of week");
        print_text (fp, s1);
        strcpy(s1, "                           = "DES_LIT"   List yesterday until starting day of week");
        print_text (fp, s1);
        print_text (fp, s1);
        strcpy(s1, "          # m|M[MOD]     = List complete month");
        print_text (fp, s1);
        strcpy(s1, "               [MOD]       = "ASC_LIT"   List tomorrow until starting day of month");
        print_text (fp, s1);
        strcpy(s1, "                           = "DES_LIT"   List yesterday until starting day of month");
        print_text (fp, s1);
        print_text (fp, s1);
        strcpy(s1, "          # y|Y[MOD]     = List complete year");
        print_text (fp, s1);
        strcpy(s1, "               [MOD]       = "ASC_LIT"   List tomorrow until starting day of year");
        print_text (fp, s1);
        strcpy(s1, "                           = "DES_LIT"   List yesterday until ending day of year");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_RESOURCE_FILE:
        sprintf(s1, SWITCH"f|F ARG  %s", get_longopt_description (SYM_RESOURCE_FILE, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Use alternative file(s) instead of standard resource file");
        print_text (fp, s1);
        strcpy(s1, "          Implies warning period:  Today");
        print_text (fp, s1);
        strcpy(s1, " f        = Display only those dates, for which fixed dates exists");
        print_text (fp, s1);
        strcpy(s1, "   F      = Display those dates, for which fixed dates doesn't exit, too");
        print_text (fp, s1);
        strcpy(s1, "     ARG  = Single file or list of files separated by `"RC_FNAME_SEP"' character");
        print_text (fp, s1);
      default:
          ;   /* Void */
    }
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s1);
      print_text (fp, s1);
      if (print_hls)
        strcpy(s1, ehls2s.seq);
      sprintf(s2, "%cDATE", RC_ADATE_CHAR);
      strcat(s1, s2);
      if (print_hls)
        strcat(s1, ehls2e.seq);
      print_text (fp, s1);
      strcpy(s1, "Use given `DATE' instead of todays date");
      print_text (fp, s1);
      sprintf(s1, "Date format:  `"Y_LIT2"[mm[dd|www[N]]]', `"Y_LIT2"%c%c|dvar[["ASC_LIT"|"
              DES_LIT"]N[www]]', `"Y_LIT2"%cdN[www]'", RC_HDY_CHAR, RC_EASTER_CHAR, RC_NWD_CHAR);
      print_text (fp, s1);
      sprintf(s1, "              `"Y_LIT2"%cwN[www]', `month name[dd]', `weekday name[N]'"
              " or `dd'", RC_NWD_CHAR);
      print_text (fp, s1);
    }
#  endif /* USE_RC */
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s1);
      print_text (fp, s1);
      if (print_hls)
        strcpy(s1, ehls2s.seq);
      sprintf(s2, "%cFILE", RSP_CHAR);
      strcat(s1, s2);
      if (print_hls)
        strcat(s1, ehls2e.seq);
      print_text (fp, s1);
      strcpy(s1, "Preload options and commands from `FILE'");
      print_text (fp, s1);
      print_text (fp, s1);
      print_text (fp, s1);
      if (print_hls)
        strcpy(s1, ehls2s.seq);
      strcat(s1, "COMMAND");
      if (print_hls)
        strcat(s1, ehls2e.seq);
      print_text (fp, s1);
      sprintf(s1, "mm        = Month in range:  %d...%d", MONTH_MIN, MONTH_MAX);
      print_text (fp, s1);
      strcpy (s1, "                        or:  month name | "MONTH3_LIT" | "
              MONTH3_LIT""MONTH3_LIT" | "MONTH3_LIT""ASC_LIT" | "MONTH3_LIT""DES_LIT);
      print_text (fp, s1);
      print_text (fp, s1);
      strcpy(s1, "            List:   mm["YEAR_SEP""Y_LIT2"]"
             MLIST_SEP"..."MLIST_SEP"mm["YEAR_SEP""Y_LIT2"]");
      print_text (fp, s1);
      strcpy(s1, "            Range:  mm["YEAR_SEP""Y_LIT2"]"
             MRANGE_SEP"mm["YEAR_SEP""Y_LIT2"]");
      print_text (fp, s1);
      print_text (fp, s1);
      sprintf(s1, Y_LIT2"      = Year  in range:  %d...%d", YEAR_MIN, YEAR_MAX);
      print_text (fp, s1);
      print_text (fp, s1);
      strcpy(s1, "            List:   [mm"FYEAR_SEP"]"Y_LIT2
             ""YLIST_SEP"..."YLIST_SEP"[mm"FYEAR_SEP"]"Y_LIT2);
      print_text (fp, s1);
      strcpy(s1, "            Range:  [mm"FYEAR_SEP"]"Y_LIT2
             ""YRANGE_SEP"[mm"FYEAR_SEP"]"Y_LIT2);
      print_text (fp, s1);
      print_text (fp, s1);
      print_text (fp, s1);
      sprintf(s1, "    +++ If you specify two digits for the year"
              " I DON'T ASSUME %2d"Y_LIT" +++", act_year/100);
    }
#endif /* !USE_GER */
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s1);
      my_help_tail_text (fp);
    }
}



#ifdef ANSI_PROTO
PUBLIC void
my_basic_help (FILE *fp)
#else /* !ANSI_PROTO */
   PUBLIC void
my_basic_help (fp)
   FILE *fp;
#endif /* !ANSI_PROTO */
/*
   Prints the "basic help" text to file `fp' using the central
     output function `print_text()' and uses global text buffer
     `s1' internally.
*/
{
   my_help_head_text (fp);
#if USE_GER
   strcpy(s1, SWITCH"h|hh   = Hilfetext; "SWITCH"L = Lizenz; "
          SWITCH"V = Version; "SWITCH"u = Kalender unterdr"UE"cken");
   print_text (fp, s1);
   strcpy(s1, SWITCH"i[-]   = Spezial-Kalenderformat; ");
#  if USE_PAGER
   strcat(s1, SWITCH"p = Paginierer; ");
#  endif
   strcat(s1, SWITCH"H yes = Mit Hervorhebungen");
   print_text (fp, s1);
   strcpy(s1, SWITCH"b ARG  = Jahreskalender in "
          "1|2|3|4|6|12 Bl"OE"cken; "SWITCH"H no = Ohne Hervorhebungen");
   print_text (fp, s1);
   strcpy(s1, SWITCH"j[]    = Fortlaufenden Tag des Jahres ausgeben (Modifizierer: ");
#  if USE_RC
   strcat(s1, "[b n nb c cb])");
#  else /* !USE_RC */
   strcat(s1, "[b n nb])");
#  endif /* !USE_RC */
   print_text (fp, s1);
   sprintf(s1, SWITCH"s ARG  = Starttag der Woche "
           "(ARG = 0|Today | %d|%s | %d|%s | ... | %d|%s)",
           DAY_MIN, short_day_name (DAY_MIN),
           DAY_MIN+1, short_day_name (DAY_MIN+1),
           DAY_MAX, short_day_name (DAY_MAX));
   print_text (fp, s1);
   sprintf(s1, SWITCH"n|N["DES_LIT"] = Ewige Feiertagsliste ausgeben "
           "(Jahr im Bereich: %d...%d)", EASTER_MIN, EASTER_MAX);
   print_text (fp, s1);
#  if USE_RC
   strcpy(s1, SWITCH"c|C[]  = Terminliste aus Datei `"PRGR_RC_NAME"'; "
          SWITCH"f|F ARG["RC_FNAME_SEP"ARG+...]=Benutze Datei ARG");
   print_text (fp, s1);
   strcpy(s1, "    ^^--> [g[] | ["DES_LIT"aAdeEkloxz][N[d|w|"ASC_LIT
          "|"DES_LIT"]|`mmtt'|`mmwww'N|t|[w|m|y["ASC_LIT"|"DES_LIT"]]]]");
   print_text (fp, s1);
#  endif
   sprintf(s1, "mm   = Monat im Bereich: %d...%d               "
           "Liste:   mm["YEAR_SEP""Y_LIT2"]"MLIST_SEP"..."MLIST_SEP
           "mm["YEAR_SEP""Y_LIT2"]", MONTH_MIN, MONTH_MAX);
   print_text (fp, s1);
   strcpy(s1, "                   oder: Monatsname|"MONTH3_LIT"["MONTH3_LIT"|"ASC_LIT"|"DES_LIT"]  "
          "Bereich: mm["YEAR_SEP""Y_LIT2"]"MRANGE_SEP"mm["YEAR_SEP""Y_LIT2"]");
   print_text (fp, s1);
   sprintf(s1, Y_LIT2" = Jahr  im Bereich: %d...%d%*s       "
           "Liste:   [mm"FYEAR_SEP"]"Y_LIT2""YLIST_SEP"..."YLIST_SEP
           "[mm"FYEAR_SEP"]"Y_LIT2, YEAR_MIN, YEAR_MAX, 6-len_year_max+4, "");
   print_text (fp, s1);
   strcpy(s1, "                                              "
          "Bereich: [mm"FYEAR_SEP"]"Y_LIT2""YRANGE_SEP"[mm"FYEAR_SEP"]"Y_LIT2);
   print_text (fp, s1);
   sprintf(s1, "   +++ Bei zweistelliger Jahresangabe wird NICHT"
           " von %2d"Y_LIT" ausgegangen +++", act_year/100);
#else /* !USE_GER */
   strcpy(s1, SWITCH"h|hh   = Help screen; "SWITCH"L = License; "
          SWITCH"V = Version; "SWITCH"u = Suppress calendar sheet");
   print_text (fp, s1);
   strcpy(s1, SWITCH"i[-]   = Special calendar format; ");
#  if USE_PAGER
   strcat(s1, SWITCH"p = Simple pager; ");
#  endif
   strcat(s1, SWITCH"H yes = Use highlighting");
   print_text (fp, s1);
   strcpy(s1, SWITCH"b ARG  = Year calendar with 1|2|3|4|6|12 blocks; "
          SWITCH"H no = Disable highlighting");
   print_text (fp, s1);
   strcpy(s1, SWITCH"j[]    = Output of consecutive day of year (Modifiers: ");
#  if USE_RC
   strcat(s1, "[b n nb c cb])");
#  else /* !USE_RC */
   strcat(s1, "[b n nb])");
#  endif /* !USE_RC */
   print_text (fp, s1);
   sprintf(s1, SWITCH"s ARG  = Starting day of week "
           "(ARG = 0|Today | %d|%s | %d|%s | ... | %d|%s)",
           DAY_MIN, short3_day_name (DAY_MIN),
           DAY_MIN+1, short3_day_name (DAY_MIN+1),
           DAY_MAX, short3_day_name (DAY_MAX));
   print_text (fp, s1);
   sprintf(s1, SWITCH"n|N["DES_LIT"] = Display eternal holiday list "
           "(Year in range: %d...%d)", EASTER_MIN, EASTER_MAX);
   print_text (fp, s1);
#  if USE_RC
   strcpy(s1, SWITCH"c|C[]  = Fixed dates list of file `"PRGR_RC_NAME"'; "
          SWITCH"f|F ARG["RC_FNAME_SEP"ARG+...]=Use file ARG");
   print_text (fp, s1);
   strcpy(s1, "    ^^--> [g[] | ["DES_LIT"aAdeEkloxz][N[d|w|"ASC_LIT
          "|"DES_LIT"]|`mmdd'|`mmwww'N|t|[w|m|y["ASC_LIT"|"DES_LIT"]]]]");
   print_text (fp, s1);
#  endif
   sprintf(s1, "mm    = Month in range: %d...%d                 "
           "List:  mm["YEAR_SEP""Y_LIT2"]"MLIST_SEP"..."MLIST_SEP
           "mm["YEAR_SEP""Y_LIT2"]", MONTH_MIN, MONTH_MAX);
   print_text (fp, s1);
   strcpy(s1, "                    or: month name|"MONTH3_LIT"["MONTH3_LIT"|"ASC_LIT"|"DES_LIT"]    "
          "Range: mm["YEAR_SEP""Y_LIT2"]"MRANGE_SEP"mm["YEAR_SEP""Y_LIT2"]");
   print_text (fp, s1);
   sprintf(s1, Y_LIT2"  = Year  in range: %d...%d%*s         "
           "List:  [mm"FYEAR_SEP"]"Y_LIT2""YLIST_SEP"..."YLIST_SEP
           "[mm"FYEAR_SEP"]"Y_LIT2, YEAR_MIN, YEAR_MAX, 6-len_year_max+4, "");
   print_text (fp, s1);
   strcpy(s1, "                                               "
          "Range: [mm"FYEAR_SEP"]"Y_LIT2""YRANGE_SEP"[mm"FYEAR_SEP"]"Y_LIT2);
   print_text (fp, s1);
   sprintf(s1, "    +++ If you specify two digits for the year"
           " I DON'T assume %2d"Y_LIT" +++", act_year/100);
#endif /* !USE_GER */
   my_help_tail_text (fp);
}



#ifdef ANSI_PROTO
PUBLIC void
my_license (      FILE *fp,
            const char *prgr_id)
#else /* !ANSI_PROTO */
   PUBLIC void
my_license (fp, prgr_id)
         FILE *fp;
   const char *prgr_id;
#endif /* !ANSI_PROTO */
/*
   Prints the program-id and the license text to file `fp' using the central
     output function `print_text()', uses global text buffer `s1' internally.
*/
{
   my_copyright (fp, prgr_id);
#if USE_GER
   strcpy(s1, "   Diese Software erhebt keinen Anspruch auf Vollst"AE"ndigkeit,");
   print_text (fp, s1);
   strcpy(s1, "   Verwendungsf"AE"higkeit oder Korrektheit. F"UE"r JEDWEDE Sch"AE"den oder");
   print_text (fp, s1);
   strcpy(s1, "   Verluste (implizit oder explizit), die aus Nutzung oder Handhabung");
   print_text (fp, s1);
   strcpy(s1, "   meiner Software hervorgehen, wird grunds"AE"tzlich keine Haftung");
   print_text (fp, s1);
   strcpy(s1, "   "UE"bernommen. Bei Verwendung dieser Software erkl"AE"rt sich der Benutzer");
   print_text (fp, s1);
   strcpy(s1, "   mit dieser Vereinbarung in vollem Umfang einverstanden.");
   print_text (fp, s1);
   print_text (fp, s1);
   strcpy(s1, "   Dieses Programm ist freie Software; Sie k"OE"nnen es weitervertreiben");
   print_text (fp, s1);
   strcpy(s1, "   und/oder ver"AE"ndern innerhalb der Bestimmungen der `GNU General Public");
   print_text (fp, s1);
   strcpy(s1, "   License'; herausgegeben von der `Free Software Foundation';");
   print_text (fp, s1);
   strcpy(s1, "   in der Version 2 oder jeder sp"AE"teren Version.");
   print_text (fp, s1);
   print_text (fp, s1);
   strcpy(s1, "   Sie sollten eine Kopie der `GNU General Public License' zusammen mit");
   print_text (fp, s1);
   strcpy(s1, "   diesem Programm erhalten haben; falls nicht, schreiben Sie an die:");
#else /* !USE_GER */
   strcpy(s1, "   This software doesn't claim completeness, correctness or usability.");
   print_text (fp, s1);
   strcpy(s1, "   On principle I will not be liable for ANY damages or losses (implicit");
   print_text (fp, s1);
   strcpy(s1, "   or explicit), which result from using or handling my software.");
   print_text (fp, s1);
   strcpy(s1, "   If you use this software, you agree without any exception to this");
   print_text (fp, s1);
   strcpy(s1, "   agreement, which binds you LEGALLY !!");
   print_text (fp, s1);
   print_text (fp, s1);
   strcpy(s1, "   This program is free software; you can redistribute it and/or modify");
   print_text (fp, s1);
   strcpy(s1, "   it under the terms of the `GNU General Public License' as published by");
   print_text (fp, s1);
   strcpy(s1, "   the `Free Software Foundation'; either version 2, or (at your option)");
   print_text (fp, s1);
   strcpy(s1, "   any later version.");
   print_text (fp, s1);
   print_text (fp, s1);
   strcpy(s1, "   You should have received a copy of the `GNU General Public License'");
   print_text (fp, s1);
   strcpy(s1, "   along with this program; if not, write to the:");
#endif /* !USE_GER */
   print_text (fp, s1);
   print_text (fp, s1);
   strcpy(s1, "      Free Software Foundation, Inc.");
   print_text (fp, s1);
   strcpy(s1, "      59 Temple Place - Suite 330");
   print_text (fp, s1);
   strcpy(s1, "      Boston, MA 02111-1307,  USA");
   print_text (fp, s1);
}



#ifdef ANSI_PROTO
PUBLIC void
my_version (      FILE *fp,
            const char *prgr_id)
#else /* !ANSI_PROTO */
   PUBLIC void
my_version (fp, prgr_id)
         FILE *fp;
   const char *prgr_id;
#endif /* !ANSI_PROTO */
/*
   Prints the program-id and all compilation flags to file `fp' using the central
     output function `print_text()', uses global text buffer `s1' internally.
*/
{
   register int  i=0;


   my_copyright (fp, prgr_id);
#if USE_GER
   strcpy(s1, "   Kompilations-Optionen:");
#else /* !USE_GER */
   strcpy(s1, "   Compilation options:");
#endif /* !USE_GER */
   print_text (fp, s1);
#if HAVE_ASSERT_H && DEBUG
   strcpy(s1, "      DEBUG");
   print_text (fp, s1);
#endif
   strcpy(s1, "     ");
#if USE_CATH
   strcat(s1, " USE_CATH");
   i++;
#endif
#if USE_EASC
   strcat(s1, " USE_EASC");
   i++;
#endif
#if USE_GER
   strcat(s1, " USE_GER");
   i++;
#endif
#if USE_HLS
   strcat(s1, " USE_HLS");
   i++;
#endif
#if USE_PAGER
   strcat(s1, " USE_PAGER");
   i++;
#endif
#if USE_RC
   strcat(s1, " USE_RC");
   i++;
#endif
#if !USE_GER && USE_USHDY
   strcat(s1, " USE_USHDY");
   i++;
#endif
   if (i)
     print_text (fp, s1);
   sprintf(s1, "      EXIT_STAT_HELP=%d", EXIT_STAT_HLP);
   print_text (fp, s1);
   sprintf(s1, "      GREG_%d (%d-%d %s)", GREG_YEAR,
           GREG_F_DAY, GREG_L_DAY, short_month_name (GREG_MONTH));
   print_text (fp, s1);
   sprintf(s1, "      GCAL_SYS_LIBDIR=%s", GCAL_SYS_LIBDIR);
   print_text (fp, s1);
   sprintf(s1, "      GCAL_USR_LIBDIR=%s", GCAL_USR_LIBDIR);
   print_text (fp, s1);
}



#ifdef ANSI_PROTO
PUBLIC const char *
usage_msg (void)
#else /* !ANSI_PROTO */
   PUBLIC const char *
usage_msg (void)
#endif /* !ANSI_PROTO */
/*
   Copies the constructed preprocessor text `USAGE_MSG'
     to the usage text `usage_text' and includes the actual program name.
*/
{
   static char  *usg_text;
   static Bool   is_initialized=FALSE;


   if (!is_initialized)
    {
      usg_text = (char *)my_malloc (strlen(USAGE_MSG)-2+len_prgr_name+1,
                                    124, __FILE__, ((long)__LINE__)-1,
                                    "usg_text", 0);
      sprintf(usg_text, USAGE_MSG, prgr_name);
      is_initialized = TRUE;
    }

   return usg_text;
}



#ifdef ANSI_PROTO
PUBLIC void
put_longopt_description (FILE *fp)
#else /* !ANSI_PROTO */
   PUBLIC void
put_longopt_description (fp)
   FILE *fp;
#endif /* !ANSI_PROTO */
/*
   Puts a description text of the long-style options to file `fp'.
*/
{
#if USE_GER
   fprintf(fp, "Benutze `%s %s' oder ",
           prgr_name, get_longopt_description (SYM_HELP, TRUE));
   fprintf(fp, "`%s %s|["LARG_SEP"?]' f"UE"r mehr Information.",
           prgr_name, get_longopt_description (SYM_LONG_HELP2, TRUE));
#else /* !USE_GER */
   fprintf(fp, "Use `%s %s' or ",
           prgr_name, get_longopt_description (SYM_HELP, TRUE));
   fprintf(fp, "`%s %s|["LARG_SEP"?]' for more information.",
           prgr_name, get_longopt_description (SYM_LONG_HELP2, TRUE));
#endif /* !USE_GER */
}



#ifdef ANSI_PROTO
LOCAL const char *
get_longopt_description (const int  longopt_symbolic,
                         const Bool with_larglist)
#else /* !ANSI_PROTO */
   LOCAL const char *
get_longopt_description (longopt_symbolic, with_larglist)
   const int  longopt_symbolic;
   const Bool with_larglist;
#endif /* !ANSI_PROTO */
/*
   Returns a description text of given `longopt_symbolic' long-style option
     in global text buffer `s2'.  If `with_larglist' is TRUE, the returned
     description text contains the argument list text (if any) too, otherwise
     the returned description text contains the complete name of the long option only!
*/
{
   auto     const Lopt_struct  *ptr_lopt=lopt;
   register       int           i;


   while (ptr_lopt->long_name != NULL)
    {
      if (ptr_lopt->symbolic_name == longopt_symbolic)
        break;
      ptr_lopt++;
    }
   if (ptr_lopt->long_name != NULL)
    {
      i = 0;
      sprintf(s2, SWITCH""SWITCH"%s", ptr_lopt->long_name);
      if (   with_larglist
          && (ptr_lopt->larg_mode != LARG_NO))
       {
         if (ptr_lopt->larg_mode == LARG_NO_OR_ONE)
           strcat(s2, "["LARG_SEP);
         else
           strcat(s2, LARG_SEP);
         if (   (ptr_lopt->larg_mode == LARG_ONE)
             && (ptr_lopt->largs[0] == NULL))
           strcat(s2, LARG_TXT);
         else
          {
            if (ptr_lopt->largs[0] == NULL)
              strcat(s2, LARG_TXT);
            else
              while (ptr_lopt->largs[i] != NULL)
               {
                 strcat(s2, ptr_lopt->largs[i]);
                 if (ptr_lopt->largs[i+1] != NULL)
                   strcat(s2, "|");
                 i++;
               }
          }
         if (ptr_lopt->larg_mode == LARG_NO_OR_ONE)
           strcat(s2, "]");
       }
    }
   else
     *s2 = '\0';

   return s2;
}



#ifdef ANSI_PROTO
LOCAL void
my_copyright (      FILE *fp,
              const char *prgr_id)
#else /* !ANSI_PROTO */
   LOCAL void
my_copyright (fp, prgr_id)
         FILE *fp;
   const char *prgr_id;
#endif /* !ANSI_PROTO */
/*
   Prints the id and copyright text to file `fp' using the central output
     function `print_text()' and uses global text buffer `s1' internally.
*/
{
   strcpy(s1, prgr_id);
   print_text (fp, s1);
   print_text (fp, s1);
   strcpy(s1, "   "COPYRIGHT_TXT);
   print_text (fp, s1);
   print_text (fp, s1);
}



#ifdef ANSI_PROTO
LOCAL void
my_help_head_text (FILE *fp)
#else /* !ANSI_PROTO */
   LOCAL void
my_help_head_text (fp)
   FILE *fp;
#endif /* !ANSI_PROTO */
/*
   Prints the help header text to file `fp' using the central
     output function `print_text()' and uses global text buffer
     `s1' and `s2' internally.
*/
{
   auto Bool  print_hls=(Bool)(is_tty&&highlight_flag&&!emu_hls);


   *s1 = '\0';
   if (print_hls)
     strcpy(s1, ehls2s.seq);
   strcat(s1, prgr_name);
   if (print_hls)
     strcat(s1, ehls2e.seq);
#if USE_GER
   sprintf(s2, ":%*s Das GNU Kalenderprogramm  (", 6-len_prgr_name, "");
#else /* !USE_GER */
   sprintf(s2, ":%*s The GNU calendar program  (", 6-len_prgr_name, "");
#endif /* !USE_GER */
   strcat(s1, s2);
   if (print_hls)
     strcat(s1, ehls2s.seq);
   strcat(s1, VERSION_NO);
   if (print_hls)
     strcat(s1, ehls2e.seq);
   strcat(s1, ")  "COPYRIGHT_TXT);
   print_text (fp, s1);
   print_text (fp, s1);
   strcpy(s1, usage_msg ());
   print_text (fp, s1);
   print_text (fp, s1);
}



#ifdef ANSI_PROTO
LOCAL void
my_help_tail_text (FILE *fp)
#else /* !ANSI_PROTO */
   LOCAL void
my_help_tail_text (fp)
   FILE *fp;
#endif /* !ANSI_PROTO */
/*
   Prints the help tail text to file `fp' using the central
     output function `print_text()' and uses global text buffer
     `s1' internally.
*/
{
   auto Bool  print_hls=(Bool)(is_tty&&highlight_flag&&!emu_hls);


   print_text (fp, s1);
   print_text (fp, s1);
#if USE_GER
   sprintf(s1, "`%s' ist `freie Software'     %*s", prgr_name, 6-len_prgr_name, "");
#else /* !USE_GER */
   sprintf(s1, "`%s' is `free software'       %*s", prgr_name, 6-len_prgr_name, "");
#endif /* !USE_GER */
   if (print_hls)
     strcat(s1, ehls2s.seq);
   strcat(s1, "\\\\\\_''/'");
   if (print_hls)
     strcat(s1, ehls2e.seq);
#if USE_GER
#  if USE_EASC
   strcat(s1, " ");
#  endif
   strcat(s1, "          Viel Spa"SZ" damit   =8^)");
#else /* !USE_GER */
   strcat(s1, "                     Enjoy   =8^)");
#endif /* !USE_GER */
   print_text (fp, s1);
   if (print_hls)
     strcpy(s1, ehls2s.seq);
   strcat(s1, "---------------------------oOO    (/o-o\\) "
          "   OOo---------------------------");
   if (print_hls)
     strcat(s1, ehls2e.seq);
   print_text (fp, s1);
   if (print_hls)
     strcpy(s1, ehls2s.seq);
   strcat(s1, "  Thomas Esken                o  (.  \"  .)"
          "  o   Internet :                 ");
   if (print_hls)
     strcat(s1, ehls2e.seq);
   print_text (fp, s1);
   if (print_hls)
     strcpy(s1, ehls2s.seq);
   strcat(s1, "  Im Hagenfeld 84              \\___) ~ (__"
          "_/      (esken@uni-muenster.de)  ");
   if (print_hls)
     strcat(s1, ehls2e.seq);
   print_text (fp, s1);
   if (print_hls)
     strcpy(s1, ehls2s.seq);
   strcat(s1, "  D-48147 M\"unster; GERMANY               "
          "      Phone    : +49 251 232585  ");
   if (print_hls)
     strcat(s1, ehls2e.seq);
   print_text (fp, s1);
}
